// services/network/public/mojom/schemeful_site.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SCHEMEFUL_SITE_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SCHEMEFUL_SITE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/schemeful_site.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/schemeful_site.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>




#include "services/network/public/cpp/schemeful_site_mojom_traits.h"




namespace network::mojom {








class  SchemefulSite {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SchemefulSite, T>::value>;
  using DataView = SchemefulSiteDataView;
  using Data_ = internal::SchemefulSite_Data;

  template <typename... Args>
  static SchemefulSitePtr New(Args&&... args) {
    return SchemefulSitePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SchemefulSitePtr From(const U& u) {
    return mojo::TypeConverter<SchemefulSitePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SchemefulSite>::Convert(*this);
  }


  SchemefulSite();

  explicit SchemefulSite(
      const ::url::Origin& site_as_origin);


  ~SchemefulSite();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SchemefulSitePtr>
  SchemefulSitePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SchemefulSite::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SchemefulSite::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SchemefulSite::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SchemefulSite::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SchemefulSite::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SchemefulSite::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SchemefulSite_UnserializedMessageContext<
            UserType, SchemefulSite::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SchemefulSite::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SchemefulSite::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SchemefulSite_UnserializedMessageContext<
            UserType, SchemefulSite::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SchemefulSite::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin site_as_origin;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SchemefulSite::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SchemefulSite::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SchemefulSite::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SchemefulSite::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SchemefulSitePtr SchemefulSite::Clone() const {
  return New(
      mojo::Clone(site_as_origin)
  );
}

template <typename T, SchemefulSite::EnableIfSame<T>*>
bool SchemefulSite::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->site_as_origin, other_struct.site_as_origin))
    return false;
  return true;
}

template <typename T, SchemefulSite::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.site_as_origin < rhs.site_as_origin)
    return true;
  if (rhs.site_as_origin < lhs.site_as_origin)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::SchemefulSite::DataView,
                                         ::network::mojom::SchemefulSitePtr> {
  static bool IsNull(const ::network::mojom::SchemefulSitePtr& input) { return !input; }
  static void SetToNull(::network::mojom::SchemefulSitePtr* output) { output->reset(); }

  static const decltype(::network::mojom::SchemefulSite::site_as_origin)& site_as_origin(
      const ::network::mojom::SchemefulSitePtr& input) {
    return input->site_as_origin;
  }

  static bool Read(::network::mojom::SchemefulSite::DataView input, ::network::mojom::SchemefulSitePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SCHEMEFUL_SITE_MOJOM_H_