// services/network/public/mojom/schemeful_site.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SCHEMEFUL_SITE_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SCHEMEFUL_SITE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/schemeful_site.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"




#include "services/network/public/mojom/schemeful_site.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SchemefulSiteDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SchemefulSiteDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SchemefulSite_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::site_as_origin(input)) in_site_as_origin = Traits::site_as_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->site_as_origin)::BaseType> site_as_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_site_as_origin,
      site_as_origin_fragment);

    fragment->site_as_origin.Set(
        site_as_origin_fragment.is_null() ? nullptr : site_as_origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->site_as_origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site_as_origin in SchemefulSite struct");
  }

  static bool Deserialize(::network::mojom::internal::SchemefulSite_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SchemefulSiteDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void SchemefulSiteDataView::GetSiteAsOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->site_as_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SCHEMEFUL_SITE_MOJOM_SHARED_H_