// services/network/public/mojom/restricted_udp_socket.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/restricted_udp_socket.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/restricted_udp_socket.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* RestrictedUDPSocketModeToStringHelper(RestrictedUDPSocketMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RestrictedUDPSocketMode::CONNECTED:
      return "CONNECTED";
    case RestrictedUDPSocketMode::BOUND:
      return "BOUND";
    default:
      return nullptr;
  }
}

std::string RestrictedUDPSocketModeToString(RestrictedUDPSocketMode value) {
  const char *str = RestrictedUDPSocketModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RestrictedUDPSocketMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RestrictedUDPSocketMode value) {
  return os << RestrictedUDPSocketModeToString(value);
}

namespace internal {


// static
bool RestrictedUDPSocketParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedUDPSocketParams_Data* object =
      static_cast<const RestrictedUDPSocketParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->socket_options, validation_context))
    return false;

  return true;
}

RestrictedUDPSocketParams_Data::RestrictedUDPSocketParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedUDPSocket_JoinGroup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedUDPSocket_JoinGroup_Params_Data* object =
      static_cast<const RestrictedUDPSocket_JoinGroup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_address, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->group_address, validation_context))
    return false;

  return true;
}

RestrictedUDPSocket_JoinGroup_Params_Data::RestrictedUDPSocket_JoinGroup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedUDPSocket_JoinGroup_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedUDPSocket_JoinGroup_ResponseParams_Data* object =
      static_cast<const RestrictedUDPSocket_JoinGroup_ResponseParams_Data*>(data);

  return true;
}

RestrictedUDPSocket_JoinGroup_ResponseParams_Data::RestrictedUDPSocket_JoinGroup_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedUDPSocket_LeaveGroup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedUDPSocket_LeaveGroup_Params_Data* object =
      static_cast<const RestrictedUDPSocket_LeaveGroup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_address, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->group_address, validation_context))
    return false;

  return true;
}

RestrictedUDPSocket_LeaveGroup_Params_Data::RestrictedUDPSocket_LeaveGroup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedUDPSocket_LeaveGroup_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedUDPSocket_LeaveGroup_ResponseParams_Data* object =
      static_cast<const RestrictedUDPSocket_LeaveGroup_ResponseParams_Data*>(data);

  return true;
}

RestrictedUDPSocket_LeaveGroup_ResponseParams_Data::RestrictedUDPSocket_LeaveGroup_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedUDPSocket_ReceiveMore_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedUDPSocket_ReceiveMore_Params_Data* object =
      static_cast<const RestrictedUDPSocket_ReceiveMore_Params_Data*>(data);

  return true;
}

RestrictedUDPSocket_ReceiveMore_Params_Data::RestrictedUDPSocket_ReceiveMore_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedUDPSocket_Send_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedUDPSocket_Send_Params_Data* object =
      static_cast<const RestrictedUDPSocket_Send_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

RestrictedUDPSocket_Send_Params_Data::RestrictedUDPSocket_Send_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedUDPSocket_Send_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedUDPSocket_Send_ResponseParams_Data* object =
      static_cast<const RestrictedUDPSocket_Send_ResponseParams_Data*>(data);

  return true;
}

RestrictedUDPSocket_Send_ResponseParams_Data::RestrictedUDPSocket_Send_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedUDPSocket_SendTo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedUDPSocket_SendTo_Params_Data* object =
      static_cast<const RestrictedUDPSocket_SendTo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dest_addr, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dest_addr, validation_context))
    return false;


  if (!::network::mojom::internal::DnsQueryType_Data
        ::Validate(object->dns_query_type, validation_context))
    return false;

  return true;
}

RestrictedUDPSocket_SendTo_Params_Data::RestrictedUDPSocket_SendTo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RestrictedUDPSocket_SendTo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RestrictedUDPSocket_SendTo_ResponseParams_Data* object =
      static_cast<const RestrictedUDPSocket_SendTo_ResponseParams_Data*>(data);

  return true;
}

RestrictedUDPSocket_SendTo_ResponseParams_Data::RestrictedUDPSocket_SendTo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::RestrictedUDPSocketMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::RestrictedUDPSocketMode value) {
  return std::move(context).WriteString(::network::mojom::RestrictedUDPSocketModeToString(value));
}

} // namespace perfetto