// services/network/public/mojom/restricted_cookie_manager.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/restricted_cookie_manager.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var cookie_manager$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cookie_manager.mojom', 'cookie_manager.mojom.js');
  }
  var shared_memory$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/shared_memory.mojom', '../../../../mojo/public/mojom/base/shared_memory.mojom.js');
  }
  var site_for_cookies$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/site_for_cookies.mojom', 'site_for_cookies.mojom.js');
  }
  var storage_access_api$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/storage_access_api.mojom', 'storage_access_api.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../url/mojom/origin.mojom.js');
  }


  var INVALID_COOKIE_VERSION = 0;
  var INITIAL_COOKIE_VERSION = 1;
  var CookieMatchType = {};
  CookieMatchType.EQUALS = 0;
  CookieMatchType.STARTS_WITH = 1;
  CookieMatchType.MIN_VALUE = 0;
  CookieMatchType.MAX_VALUE = 1;

  CookieMatchType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  CookieMatchType.toKnownEnumValue = function(value) {
    return value;
  };

  CookieMatchType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var RestrictedCookieManagerRole = {};
  RestrictedCookieManagerRole.SCRIPT = 0;
  RestrictedCookieManagerRole.NETWORK = 1;
  RestrictedCookieManagerRole.MIN_VALUE = 0;
  RestrictedCookieManagerRole.MAX_VALUE = 1;

  RestrictedCookieManagerRole.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  RestrictedCookieManagerRole.toKnownEnumValue = function(value) {
    return value;
  };

  RestrictedCookieManagerRole.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function CookieManagerGetOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManagerGetOptions.prototype.initDefaults_ = function() {
    this.name = null;
    this.matchType = 0;
  };
  CookieManagerGetOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManagerGetOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManagerGetOptions.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManagerGetOptions.matchType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, CookieMatchType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManagerGetOptions.encodedSize = codec.kStructHeaderSize + 16;

  CookieManagerGetOptions.decode = function(decoder) {
    var packed;
    var val = new CookieManagerGetOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.matchType =
        decoder.decodeStruct(new codec.Enum(CookieMatchType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CookieManagerGetOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManagerGetOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.Int32, val.matchType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CookiesResponse(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookiesResponse.prototype.initDefaults_ = function() {
    this.version = 0;
    this.versionBuffer = null;
    this.cookies = null;
  };
  CookiesResponse.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookiesResponse.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CookiesResponse.versionBuffer
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, shared_memory$.ReadOnlySharedMemoryRegion, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookiesResponse.cookies
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookiesResponse.encodedSize = codec.kStructHeaderSize + 24;

  CookiesResponse.decode = function(decoder) {
    var packed;
    var val = new CookiesResponse();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.version =
        decoder.decodeStruct(codec.Uint64);
    val.versionBuffer =
        decoder.decodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion);
    val.cookies =
        decoder.decodeStruct(codec.String);
    return val;
  };

  CookiesResponse.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookiesResponse.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.version);
    encoder.encodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion, val.versionBuffer);
    encoder.encodeStruct(codec.String, val.cookies);
  };
  function RestrictedCookieManager_GetAllForUrl_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedCookieManager_GetAllForUrl_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.siteForCookies = null;
    this.topFrameOrigin = null;
    this.storageAccessApiStatus = 0;
    this.isAdTagged = false;
    this.applyDevtoolsOverrides = false;
    this.forceDisableThirdPartyCookies = false;
    this.options = null;
  };
  RestrictedCookieManager_GetAllForUrl_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedCookieManager_GetAllForUrl_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_GetAllForUrl_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_GetAllForUrl_Params.siteForCookies
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, site_for_cookies$.SiteForCookies, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_GetAllForUrl_Params.topFrameOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_GetAllForUrl_Params.storageAccessApiStatus
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, storage_access_api$.StorageAccessApiStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_GetAllForUrl_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, CookieManagerGetOptions, false);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  RestrictedCookieManager_GetAllForUrl_Params.encodedSize = codec.kStructHeaderSize + 40;

  RestrictedCookieManager_GetAllForUrl_Params.decode = function(decoder) {
    var packed;
    var val = new RestrictedCookieManager_GetAllForUrl_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.siteForCookies =
        decoder.decodeStructPointer(site_for_cookies$.SiteForCookies);
    val.topFrameOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.storageAccessApiStatus =
        decoder.decodeStruct(new codec.Enum(storage_access_api$.StorageAccessApiStatus));
    packed = decoder.readUint8();
    val.isAdTagged = (packed >> 0) & 1 ? true : false;
    val.applyDevtoolsOverrides = (packed >> 1) & 1 ? true : false;
    val.forceDisableThirdPartyCookies = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.options =
        decoder.decodeStructPointer(CookieManagerGetOptions);
    return val;
  };

  RestrictedCookieManager_GetAllForUrl_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedCookieManager_GetAllForUrl_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(site_for_cookies$.SiteForCookies, val.siteForCookies);
    encoder.encodeStructPointer(origin$.Origin, val.topFrameOrigin);
    encoder.encodeStruct(codec.Int32, val.storageAccessApiStatus);
    packed = 0;
    packed |= (val.isAdTagged & 1) << 0
    packed |= (val.applyDevtoolsOverrides & 1) << 1
    packed |= (val.forceDisableThirdPartyCookies & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(CookieManagerGetOptions, val.options);
  };
  function RestrictedCookieManager_GetAllForUrl_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedCookieManager_GetAllForUrl_ResponseParams.prototype.initDefaults_ = function() {
    this.cookies = null;
  };
  RestrictedCookieManager_GetAllForUrl_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedCookieManager_GetAllForUrl_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_GetAllForUrl_ResponseParams.cookies
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(cookie_manager$.CookieWithAccessResult), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RestrictedCookieManager_GetAllForUrl_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  RestrictedCookieManager_GetAllForUrl_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new RestrictedCookieManager_GetAllForUrl_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cookies =
        decoder.decodeArrayPointer(new codec.PointerTo(cookie_manager$.CookieWithAccessResult));
    return val;
  };

  RestrictedCookieManager_GetAllForUrl_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedCookieManager_GetAllForUrl_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(cookie_manager$.CookieWithAccessResult), val.cookies);
  };
  function RestrictedCookieManager_SetCanonicalCookie_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedCookieManager_SetCanonicalCookie_Params.prototype.initDefaults_ = function() {
    this.cookie = null;
    this.url = null;
    this.siteForCookies = null;
    this.topFrameOrigin = null;
    this.storageAccessApiStatus = 0;
    this.isAdTagged = false;
    this.applyDevtoolsOverrides = false;
    this.status = null;
  };
  RestrictedCookieManager_SetCanonicalCookie_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedCookieManager_SetCanonicalCookie_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_SetCanonicalCookie_Params.cookie
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, cookie_manager$.CanonicalCookie, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_SetCanonicalCookie_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_SetCanonicalCookie_Params.siteForCookies
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, site_for_cookies$.SiteForCookies, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_SetCanonicalCookie_Params.topFrameOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_SetCanonicalCookie_Params.storageAccessApiStatus
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, storage_access_api$.StorageAccessApiStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_SetCanonicalCookie_Params.status
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, cookie_manager$.CookieInclusionStatus, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  RestrictedCookieManager_SetCanonicalCookie_Params.encodedSize = codec.kStructHeaderSize + 48;

  RestrictedCookieManager_SetCanonicalCookie_Params.decode = function(decoder) {
    var packed;
    var val = new RestrictedCookieManager_SetCanonicalCookie_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cookie =
        decoder.decodeStructPointer(cookie_manager$.CanonicalCookie);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.siteForCookies =
        decoder.decodeStructPointer(site_for_cookies$.SiteForCookies);
    val.topFrameOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.storageAccessApiStatus =
        decoder.decodeStruct(new codec.Enum(storage_access_api$.StorageAccessApiStatus));
    packed = decoder.readUint8();
    val.isAdTagged = (packed >> 0) & 1 ? true : false;
    val.applyDevtoolsOverrides = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.status =
        decoder.decodeStructPointer(cookie_manager$.CookieInclusionStatus);
    return val;
  };

  RestrictedCookieManager_SetCanonicalCookie_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedCookieManager_SetCanonicalCookie_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(cookie_manager$.CanonicalCookie, val.cookie);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(site_for_cookies$.SiteForCookies, val.siteForCookies);
    encoder.encodeStructPointer(origin$.Origin, val.topFrameOrigin);
    encoder.encodeStruct(codec.Int32, val.storageAccessApiStatus);
    packed = 0;
    packed |= (val.isAdTagged & 1) << 0
    packed |= (val.applyDevtoolsOverrides & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(cookie_manager$.CookieInclusionStatus, val.status);
  };
  function RestrictedCookieManager_SetCanonicalCookie_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedCookieManager_SetCanonicalCookie_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  RestrictedCookieManager_SetCanonicalCookie_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedCookieManager_SetCanonicalCookie_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RestrictedCookieManager_SetCanonicalCookie_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  RestrictedCookieManager_SetCanonicalCookie_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new RestrictedCookieManager_SetCanonicalCookie_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RestrictedCookieManager_SetCanonicalCookie_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedCookieManager_SetCanonicalCookie_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RestrictedCookieManager_AddChangeListener_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedCookieManager_AddChangeListener_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.siteForCookies = null;
    this.topFrameOrigin = null;
    this.storageAccessApiStatus = 0;
    this.listener = new cookie_manager$.CookieChangeListenerPtr();
  };
  RestrictedCookieManager_AddChangeListener_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedCookieManager_AddChangeListener_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_AddChangeListener_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_AddChangeListener_Params.siteForCookies
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, site_for_cookies$.SiteForCookies, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_AddChangeListener_Params.topFrameOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_AddChangeListener_Params.storageAccessApiStatus
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, storage_access_api$.StorageAccessApiStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_AddChangeListener_Params.listener
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 28, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RestrictedCookieManager_AddChangeListener_Params.encodedSize = codec.kStructHeaderSize + 40;

  RestrictedCookieManager_AddChangeListener_Params.decode = function(decoder) {
    var packed;
    var val = new RestrictedCookieManager_AddChangeListener_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.siteForCookies =
        decoder.decodeStructPointer(site_for_cookies$.SiteForCookies);
    val.topFrameOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.storageAccessApiStatus =
        decoder.decodeStruct(new codec.Enum(storage_access_api$.StorageAccessApiStatus));
    val.listener =
        decoder.decodeStruct(new codec.Interface(cookie_manager$.CookieChangeListenerPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RestrictedCookieManager_AddChangeListener_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedCookieManager_AddChangeListener_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(site_for_cookies$.SiteForCookies, val.siteForCookies);
    encoder.encodeStructPointer(origin$.Origin, val.topFrameOrigin);
    encoder.encodeStruct(codec.Int32, val.storageAccessApiStatus);
    encoder.encodeStruct(new codec.Interface(cookie_manager$.CookieChangeListenerPtr), val.listener);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RestrictedCookieManager_AddChangeListener_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedCookieManager_AddChangeListener_ResponseParams.prototype.initDefaults_ = function() {
  };
  RestrictedCookieManager_AddChangeListener_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedCookieManager_AddChangeListener_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RestrictedCookieManager_AddChangeListener_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  RestrictedCookieManager_AddChangeListener_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new RestrictedCookieManager_AddChangeListener_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  RestrictedCookieManager_AddChangeListener_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedCookieManager_AddChangeListener_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function RestrictedCookieManager_SetCookieFromString_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedCookieManager_SetCookieFromString_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.siteForCookies = null;
    this.topFrameOrigin = null;
    this.storageAccessApiStatus = 0;
    this.getVersionSharedMemory = false;
    this.isAdTagged = false;
    this.applyDevtoolsOverrides = false;
    this.cookie = null;
  };
  RestrictedCookieManager_SetCookieFromString_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedCookieManager_SetCookieFromString_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_SetCookieFromString_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_SetCookieFromString_Params.siteForCookies
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, site_for_cookies$.SiteForCookies, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_SetCookieFromString_Params.topFrameOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_SetCookieFromString_Params.storageAccessApiStatus
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, storage_access_api$.StorageAccessApiStatus);
    if (err !== validator.validationError.NONE)
        return err;





    // validate RestrictedCookieManager_SetCookieFromString_Params.cookie
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RestrictedCookieManager_SetCookieFromString_Params.encodedSize = codec.kStructHeaderSize + 40;

  RestrictedCookieManager_SetCookieFromString_Params.decode = function(decoder) {
    var packed;
    var val = new RestrictedCookieManager_SetCookieFromString_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.siteForCookies =
        decoder.decodeStructPointer(site_for_cookies$.SiteForCookies);
    val.topFrameOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.storageAccessApiStatus =
        decoder.decodeStruct(new codec.Enum(storage_access_api$.StorageAccessApiStatus));
    packed = decoder.readUint8();
    val.getVersionSharedMemory = (packed >> 0) & 1 ? true : false;
    val.isAdTagged = (packed >> 1) & 1 ? true : false;
    val.applyDevtoolsOverrides = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.cookie =
        decoder.decodeStruct(codec.String);
    return val;
  };

  RestrictedCookieManager_SetCookieFromString_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedCookieManager_SetCookieFromString_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(site_for_cookies$.SiteForCookies, val.siteForCookies);
    encoder.encodeStructPointer(origin$.Origin, val.topFrameOrigin);
    encoder.encodeStruct(codec.Int32, val.storageAccessApiStatus);
    packed = 0;
    packed |= (val.getVersionSharedMemory & 1) << 0
    packed |= (val.isAdTagged & 1) << 1
    packed |= (val.applyDevtoolsOverrides & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.cookie);
  };
  function RestrictedCookieManager_SetCookieFromString_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedCookieManager_SetCookieFromString_ResponseParams.prototype.initDefaults_ = function() {
    this.response = null;
  };
  RestrictedCookieManager_SetCookieFromString_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedCookieManager_SetCookieFromString_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_SetCookieFromString_ResponseParams.response
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, CookiesResponse, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RestrictedCookieManager_SetCookieFromString_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  RestrictedCookieManager_SetCookieFromString_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new RestrictedCookieManager_SetCookieFromString_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.response =
        decoder.decodeStructPointer(CookiesResponse);
    return val;
  };

  RestrictedCookieManager_SetCookieFromString_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedCookieManager_SetCookieFromString_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(CookiesResponse, val.response);
  };
  function RestrictedCookieManager_GetCookiesString_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedCookieManager_GetCookiesString_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.siteForCookies = null;
    this.topFrameOrigin = null;
    this.storageAccessApiStatus = 0;
    this.getVersionSharedMemory = false;
    this.isAdTagged = false;
    this.applyDevtoolsOverrides = false;
    this.forceDisableThirdPartyCookies = false;
  };
  RestrictedCookieManager_GetCookiesString_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedCookieManager_GetCookiesString_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_GetCookiesString_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_GetCookiesString_Params.siteForCookies
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, site_for_cookies$.SiteForCookies, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_GetCookiesString_Params.topFrameOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_GetCookiesString_Params.storageAccessApiStatus
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, storage_access_api$.StorageAccessApiStatus);
    if (err !== validator.validationError.NONE)
        return err;





    return validator.validationError.NONE;
  };

  RestrictedCookieManager_GetCookiesString_Params.encodedSize = codec.kStructHeaderSize + 32;

  RestrictedCookieManager_GetCookiesString_Params.decode = function(decoder) {
    var packed;
    var val = new RestrictedCookieManager_GetCookiesString_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.siteForCookies =
        decoder.decodeStructPointer(site_for_cookies$.SiteForCookies);
    val.topFrameOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.storageAccessApiStatus =
        decoder.decodeStruct(new codec.Enum(storage_access_api$.StorageAccessApiStatus));
    packed = decoder.readUint8();
    val.getVersionSharedMemory = (packed >> 0) & 1 ? true : false;
    val.isAdTagged = (packed >> 1) & 1 ? true : false;
    val.applyDevtoolsOverrides = (packed >> 2) & 1 ? true : false;
    val.forceDisableThirdPartyCookies = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RestrictedCookieManager_GetCookiesString_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedCookieManager_GetCookiesString_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(site_for_cookies$.SiteForCookies, val.siteForCookies);
    encoder.encodeStructPointer(origin$.Origin, val.topFrameOrigin);
    encoder.encodeStruct(codec.Int32, val.storageAccessApiStatus);
    packed = 0;
    packed |= (val.getVersionSharedMemory & 1) << 0
    packed |= (val.isAdTagged & 1) << 1
    packed |= (val.applyDevtoolsOverrides & 1) << 2
    packed |= (val.forceDisableThirdPartyCookies & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RestrictedCookieManager_GetCookiesString_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedCookieManager_GetCookiesString_ResponseParams.prototype.initDefaults_ = function() {
    this.version = 0;
    this.versionBuffer = null;
    this.cookies = null;
  };
  RestrictedCookieManager_GetCookiesString_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedCookieManager_GetCookiesString_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate RestrictedCookieManager_GetCookiesString_ResponseParams.versionBuffer
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, shared_memory$.ReadOnlySharedMemoryRegion, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_GetCookiesString_ResponseParams.cookies
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RestrictedCookieManager_GetCookiesString_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  RestrictedCookieManager_GetCookiesString_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new RestrictedCookieManager_GetCookiesString_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.version =
        decoder.decodeStruct(codec.Uint64);
    val.versionBuffer =
        decoder.decodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion);
    val.cookies =
        decoder.decodeStruct(codec.String);
    return val;
  };

  RestrictedCookieManager_GetCookiesString_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedCookieManager_GetCookiesString_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.version);
    encoder.encodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion, val.versionBuffer);
    encoder.encodeStruct(codec.String, val.cookies);
  };
  function RestrictedCookieManager_CookiesEnabledFor_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedCookieManager_CookiesEnabledFor_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.siteForCookies = null;
    this.topFrameOrigin = null;
    this.storageAccessApiStatus = 0;
    this.applyDevtoolsOverrides = false;
  };
  RestrictedCookieManager_CookiesEnabledFor_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedCookieManager_CookiesEnabledFor_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_CookiesEnabledFor_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_CookiesEnabledFor_Params.siteForCookies
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, site_for_cookies$.SiteForCookies, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_CookiesEnabledFor_Params.topFrameOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RestrictedCookieManager_CookiesEnabledFor_Params.storageAccessApiStatus
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, storage_access_api$.StorageAccessApiStatus);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RestrictedCookieManager_CookiesEnabledFor_Params.encodedSize = codec.kStructHeaderSize + 32;

  RestrictedCookieManager_CookiesEnabledFor_Params.decode = function(decoder) {
    var packed;
    var val = new RestrictedCookieManager_CookiesEnabledFor_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.siteForCookies =
        decoder.decodeStructPointer(site_for_cookies$.SiteForCookies);
    val.topFrameOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.storageAccessApiStatus =
        decoder.decodeStruct(new codec.Enum(storage_access_api$.StorageAccessApiStatus));
    packed = decoder.readUint8();
    val.applyDevtoolsOverrides = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RestrictedCookieManager_CookiesEnabledFor_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedCookieManager_CookiesEnabledFor_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(site_for_cookies$.SiteForCookies, val.siteForCookies);
    encoder.encodeStructPointer(origin$.Origin, val.topFrameOrigin);
    encoder.encodeStruct(codec.Int32, val.storageAccessApiStatus);
    packed = 0;
    packed |= (val.applyDevtoolsOverrides & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RestrictedCookieManager_CookiesEnabledFor_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RestrictedCookieManager_CookiesEnabledFor_ResponseParams.prototype.initDefaults_ = function() {
    this.cookiesEnabled = false;
  };
  RestrictedCookieManager_CookiesEnabledFor_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RestrictedCookieManager_CookiesEnabledFor_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RestrictedCookieManager_CookiesEnabledFor_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  RestrictedCookieManager_CookiesEnabledFor_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new RestrictedCookieManager_CookiesEnabledFor_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.cookiesEnabled = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RestrictedCookieManager_CookiesEnabledFor_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RestrictedCookieManager_CookiesEnabledFor_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.cookiesEnabled & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kRestrictedCookieManager_GetAllForUrl_Name = 0;
  var kRestrictedCookieManager_SetCanonicalCookie_Name = 1;
  var kRestrictedCookieManager_AddChangeListener_Name = 2;
  var kRestrictedCookieManager_SetCookieFromString_Name = 3;
  var kRestrictedCookieManager_GetCookiesString_Name = 4;
  var kRestrictedCookieManager_CookiesEnabledFor_Name = 5;

  function RestrictedCookieManagerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(RestrictedCookieManager,
                                                   handleOrPtrInfo);
  }

  function RestrictedCookieManagerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        RestrictedCookieManager, associatedInterfacePtrInfo);
  }

  RestrictedCookieManagerAssociatedPtr.prototype =
      Object.create(RestrictedCookieManagerPtr.prototype);
  RestrictedCookieManagerAssociatedPtr.prototype.constructor =
      RestrictedCookieManagerAssociatedPtr;

  function RestrictedCookieManagerProxy(receiver) {
    this.receiver_ = receiver;
  }
  RestrictedCookieManagerPtr.prototype.getAllForUrl = function() {
    return RestrictedCookieManagerProxy.prototype.getAllForUrl
        .apply(this.ptr.getProxy(), arguments);
  };

  RestrictedCookieManagerProxy.prototype.getAllForUrl = function(url, siteForCookies, topFrameOrigin, storageAccessApiStatus, options, isAdTagged, applyDevtoolsOverrides, forceDisableThirdPartyCookies) {
    var params_ = new RestrictedCookieManager_GetAllForUrl_Params();
    params_.url = url;
    params_.siteForCookies = siteForCookies;
    params_.topFrameOrigin = topFrameOrigin;
    params_.storageAccessApiStatus = storageAccessApiStatus;
    params_.options = options;
    params_.isAdTagged = isAdTagged;
    params_.applyDevtoolsOverrides = applyDevtoolsOverrides;
    params_.forceDisableThirdPartyCookies = forceDisableThirdPartyCookies;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRestrictedCookieManager_GetAllForUrl_Name,
          codec.align(RestrictedCookieManager_GetAllForUrl_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(RestrictedCookieManager_GetAllForUrl_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(RestrictedCookieManager_GetAllForUrl_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  RestrictedCookieManagerPtr.prototype.setCanonicalCookie = function() {
    return RestrictedCookieManagerProxy.prototype.setCanonicalCookie
        .apply(this.ptr.getProxy(), arguments);
  };

  RestrictedCookieManagerProxy.prototype.setCanonicalCookie = function(cookie, url, siteForCookies, topFrameOrigin, storageAccessApiStatus, status, isAdTagged, applyDevtoolsOverrides) {
    var params_ = new RestrictedCookieManager_SetCanonicalCookie_Params();
    params_.cookie = cookie;
    params_.url = url;
    params_.siteForCookies = siteForCookies;
    params_.topFrameOrigin = topFrameOrigin;
    params_.storageAccessApiStatus = storageAccessApiStatus;
    params_.status = status;
    params_.isAdTagged = isAdTagged;
    params_.applyDevtoolsOverrides = applyDevtoolsOverrides;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRestrictedCookieManager_SetCanonicalCookie_Name,
          codec.align(RestrictedCookieManager_SetCanonicalCookie_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(RestrictedCookieManager_SetCanonicalCookie_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(RestrictedCookieManager_SetCanonicalCookie_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  RestrictedCookieManagerPtr.prototype.addChangeListener = function() {
    return RestrictedCookieManagerProxy.prototype.addChangeListener
        .apply(this.ptr.getProxy(), arguments);
  };

  RestrictedCookieManagerProxy.prototype.addChangeListener = function(url, siteForCookies, topFrameOrigin, storageAccessApiStatus, listener) {
    var params_ = new RestrictedCookieManager_AddChangeListener_Params();
    params_.url = url;
    params_.siteForCookies = siteForCookies;
    params_.topFrameOrigin = topFrameOrigin;
    params_.storageAccessApiStatus = storageAccessApiStatus;
    params_.listener = listener;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRestrictedCookieManager_AddChangeListener_Name,
          codec.align(RestrictedCookieManager_AddChangeListener_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(RestrictedCookieManager_AddChangeListener_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(RestrictedCookieManager_AddChangeListener_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  RestrictedCookieManagerPtr.prototype.setCookieFromString = function() {
    return RestrictedCookieManagerProxy.prototype.setCookieFromString
        .apply(this.ptr.getProxy(), arguments);
  };

  RestrictedCookieManagerProxy.prototype.setCookieFromString = function(url, siteForCookies, topFrameOrigin, storageAccessApiStatus, getVersionSharedMemory, isAdTagged, applyDevtoolsOverrides, cookie) {
    var params_ = new RestrictedCookieManager_SetCookieFromString_Params();
    params_.url = url;
    params_.siteForCookies = siteForCookies;
    params_.topFrameOrigin = topFrameOrigin;
    params_.storageAccessApiStatus = storageAccessApiStatus;
    params_.getVersionSharedMemory = getVersionSharedMemory;
    params_.isAdTagged = isAdTagged;
    params_.applyDevtoolsOverrides = applyDevtoolsOverrides;
    params_.cookie = cookie;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRestrictedCookieManager_SetCookieFromString_Name,
          codec.align(RestrictedCookieManager_SetCookieFromString_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(RestrictedCookieManager_SetCookieFromString_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(RestrictedCookieManager_SetCookieFromString_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  RestrictedCookieManagerPtr.prototype.getCookiesString = function() {
    return RestrictedCookieManagerProxy.prototype.getCookiesString
        .apply(this.ptr.getProxy(), arguments);
  };

  RestrictedCookieManagerProxy.prototype.getCookiesString = function(url, siteForCookies, topFrameOrigin, storageAccessApiStatus, getVersionSharedMemory, isAdTagged, applyDevtoolsOverrides, forceDisableThirdPartyCookies) {
    var params_ = new RestrictedCookieManager_GetCookiesString_Params();
    params_.url = url;
    params_.siteForCookies = siteForCookies;
    params_.topFrameOrigin = topFrameOrigin;
    params_.storageAccessApiStatus = storageAccessApiStatus;
    params_.getVersionSharedMemory = getVersionSharedMemory;
    params_.isAdTagged = isAdTagged;
    params_.applyDevtoolsOverrides = applyDevtoolsOverrides;
    params_.forceDisableThirdPartyCookies = forceDisableThirdPartyCookies;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRestrictedCookieManager_GetCookiesString_Name,
          codec.align(RestrictedCookieManager_GetCookiesString_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(RestrictedCookieManager_GetCookiesString_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(RestrictedCookieManager_GetCookiesString_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  RestrictedCookieManagerPtr.prototype.cookiesEnabledFor = function() {
    return RestrictedCookieManagerProxy.prototype.cookiesEnabledFor
        .apply(this.ptr.getProxy(), arguments);
  };

  RestrictedCookieManagerProxy.prototype.cookiesEnabledFor = function(url, siteForCookies, topFrameOrigin, storageAccessApiStatus, applyDevtoolsOverrides) {
    var params_ = new RestrictedCookieManager_CookiesEnabledFor_Params();
    params_.url = url;
    params_.siteForCookies = siteForCookies;
    params_.topFrameOrigin = topFrameOrigin;
    params_.storageAccessApiStatus = storageAccessApiStatus;
    params_.applyDevtoolsOverrides = applyDevtoolsOverrides;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRestrictedCookieManager_CookiesEnabledFor_Name,
          codec.align(RestrictedCookieManager_CookiesEnabledFor_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(RestrictedCookieManager_CookiesEnabledFor_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(RestrictedCookieManager_CookiesEnabledFor_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function RestrictedCookieManagerStub(delegate) {
    this.delegate_ = delegate;
  }
  RestrictedCookieManagerStub.prototype.getAllForUrl = function(url, siteForCookies, topFrameOrigin, storageAccessApiStatus, options, isAdTagged, applyDevtoolsOverrides, forceDisableThirdPartyCookies) {
    return this.delegate_ && this.delegate_.getAllForUrl && this.delegate_.getAllForUrl(url, siteForCookies, topFrameOrigin, storageAccessApiStatus, options, isAdTagged, applyDevtoolsOverrides, forceDisableThirdPartyCookies);
  }
  RestrictedCookieManagerStub.prototype.setCanonicalCookie = function(cookie, url, siteForCookies, topFrameOrigin, storageAccessApiStatus, status, isAdTagged, applyDevtoolsOverrides) {
    return this.delegate_ && this.delegate_.setCanonicalCookie && this.delegate_.setCanonicalCookie(cookie, url, siteForCookies, topFrameOrigin, storageAccessApiStatus, status, isAdTagged, applyDevtoolsOverrides);
  }
  RestrictedCookieManagerStub.prototype.addChangeListener = function(url, siteForCookies, topFrameOrigin, storageAccessApiStatus, listener) {
    return this.delegate_ && this.delegate_.addChangeListener && this.delegate_.addChangeListener(url, siteForCookies, topFrameOrigin, storageAccessApiStatus, listener);
  }
  RestrictedCookieManagerStub.prototype.setCookieFromString = function(url, siteForCookies, topFrameOrigin, storageAccessApiStatus, getVersionSharedMemory, isAdTagged, applyDevtoolsOverrides, cookie) {
    return this.delegate_ && this.delegate_.setCookieFromString && this.delegate_.setCookieFromString(url, siteForCookies, topFrameOrigin, storageAccessApiStatus, getVersionSharedMemory, isAdTagged, applyDevtoolsOverrides, cookie);
  }
  RestrictedCookieManagerStub.prototype.getCookiesString = function(url, siteForCookies, topFrameOrigin, storageAccessApiStatus, getVersionSharedMemory, isAdTagged, applyDevtoolsOverrides, forceDisableThirdPartyCookies) {
    return this.delegate_ && this.delegate_.getCookiesString && this.delegate_.getCookiesString(url, siteForCookies, topFrameOrigin, storageAccessApiStatus, getVersionSharedMemory, isAdTagged, applyDevtoolsOverrides, forceDisableThirdPartyCookies);
  }
  RestrictedCookieManagerStub.prototype.cookiesEnabledFor = function(url, siteForCookies, topFrameOrigin, storageAccessApiStatus, applyDevtoolsOverrides) {
    return this.delegate_ && this.delegate_.cookiesEnabledFor && this.delegate_.cookiesEnabledFor(url, siteForCookies, topFrameOrigin, storageAccessApiStatus, applyDevtoolsOverrides);
  }

  RestrictedCookieManagerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  RestrictedCookieManagerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kRestrictedCookieManager_GetAllForUrl_Name:
      var params = reader.decodeStruct(RestrictedCookieManager_GetAllForUrl_Params);
      this.getAllForUrl(params.url, params.siteForCookies, params.topFrameOrigin, params.storageAccessApiStatus, params.options, params.isAdTagged, params.applyDevtoolsOverrides, params.forceDisableThirdPartyCookies).then(function(response) {
        var responseParams =
            new RestrictedCookieManager_GetAllForUrl_ResponseParams();
        responseParams.cookies = response.cookies;
        var builder = new codec.MessageV1Builder(
            kRestrictedCookieManager_GetAllForUrl_Name,
            codec.align(RestrictedCookieManager_GetAllForUrl_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(RestrictedCookieManager_GetAllForUrl_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kRestrictedCookieManager_SetCanonicalCookie_Name:
      var params = reader.decodeStruct(RestrictedCookieManager_SetCanonicalCookie_Params);
      this.setCanonicalCookie(params.cookie, params.url, params.siteForCookies, params.topFrameOrigin, params.storageAccessApiStatus, params.status, params.isAdTagged, params.applyDevtoolsOverrides).then(function(response) {
        var responseParams =
            new RestrictedCookieManager_SetCanonicalCookie_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kRestrictedCookieManager_SetCanonicalCookie_Name,
            codec.align(RestrictedCookieManager_SetCanonicalCookie_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(RestrictedCookieManager_SetCanonicalCookie_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kRestrictedCookieManager_AddChangeListener_Name:
      var params = reader.decodeStruct(RestrictedCookieManager_AddChangeListener_Params);
      this.addChangeListener(params.url, params.siteForCookies, params.topFrameOrigin, params.storageAccessApiStatus, params.listener).then(function(response) {
        var responseParams =
            new RestrictedCookieManager_AddChangeListener_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kRestrictedCookieManager_AddChangeListener_Name,
            codec.align(RestrictedCookieManager_AddChangeListener_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(RestrictedCookieManager_AddChangeListener_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kRestrictedCookieManager_SetCookieFromString_Name:
      var params = reader.decodeStruct(RestrictedCookieManager_SetCookieFromString_Params);
      this.setCookieFromString(params.url, params.siteForCookies, params.topFrameOrigin, params.storageAccessApiStatus, params.getVersionSharedMemory, params.isAdTagged, params.applyDevtoolsOverrides, params.cookie).then(function(response) {
        var responseParams =
            new RestrictedCookieManager_SetCookieFromString_ResponseParams();
        responseParams.response = response.response;
        var builder = new codec.MessageV1Builder(
            kRestrictedCookieManager_SetCookieFromString_Name,
            codec.align(RestrictedCookieManager_SetCookieFromString_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(RestrictedCookieManager_SetCookieFromString_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kRestrictedCookieManager_GetCookiesString_Name:
      var params = reader.decodeStruct(RestrictedCookieManager_GetCookiesString_Params);
      this.getCookiesString(params.url, params.siteForCookies, params.topFrameOrigin, params.storageAccessApiStatus, params.getVersionSharedMemory, params.isAdTagged, params.applyDevtoolsOverrides, params.forceDisableThirdPartyCookies).then(function(response) {
        var responseParams =
            new RestrictedCookieManager_GetCookiesString_ResponseParams();
        responseParams.version = response.version;
        responseParams.versionBuffer = response.versionBuffer;
        responseParams.cookies = response.cookies;
        var builder = new codec.MessageV1Builder(
            kRestrictedCookieManager_GetCookiesString_Name,
            codec.align(RestrictedCookieManager_GetCookiesString_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(RestrictedCookieManager_GetCookiesString_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kRestrictedCookieManager_CookiesEnabledFor_Name:
      var params = reader.decodeStruct(RestrictedCookieManager_CookiesEnabledFor_Params);
      this.cookiesEnabledFor(params.url, params.siteForCookies, params.topFrameOrigin, params.storageAccessApiStatus, params.applyDevtoolsOverrides).then(function(response) {
        var responseParams =
            new RestrictedCookieManager_CookiesEnabledFor_ResponseParams();
        responseParams.cookiesEnabled = response.cookiesEnabled;
        var builder = new codec.MessageV1Builder(
            kRestrictedCookieManager_CookiesEnabledFor_Name,
            codec.align(RestrictedCookieManager_CookiesEnabledFor_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(RestrictedCookieManager_CookiesEnabledFor_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateRestrictedCookieManagerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kRestrictedCookieManager_GetAllForUrl_Name:
        if (message.expectsResponse())
          paramsClass = RestrictedCookieManager_GetAllForUrl_Params;
      break;
      case kRestrictedCookieManager_SetCanonicalCookie_Name:
        if (message.expectsResponse())
          paramsClass = RestrictedCookieManager_SetCanonicalCookie_Params;
      break;
      case kRestrictedCookieManager_AddChangeListener_Name:
        if (message.expectsResponse())
          paramsClass = RestrictedCookieManager_AddChangeListener_Params;
      break;
      case kRestrictedCookieManager_SetCookieFromString_Name:
        if (message.expectsResponse())
          paramsClass = RestrictedCookieManager_SetCookieFromString_Params;
      break;
      case kRestrictedCookieManager_GetCookiesString_Name:
        if (message.expectsResponse())
          paramsClass = RestrictedCookieManager_GetCookiesString_Params;
      break;
      case kRestrictedCookieManager_CookiesEnabledFor_Name:
        if (message.expectsResponse())
          paramsClass = RestrictedCookieManager_CookiesEnabledFor_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateRestrictedCookieManagerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kRestrictedCookieManager_GetAllForUrl_Name:
        if (message.isResponse())
          paramsClass = RestrictedCookieManager_GetAllForUrl_ResponseParams;
        break;
      case kRestrictedCookieManager_SetCanonicalCookie_Name:
        if (message.isResponse())
          paramsClass = RestrictedCookieManager_SetCanonicalCookie_ResponseParams;
        break;
      case kRestrictedCookieManager_AddChangeListener_Name:
        if (message.isResponse())
          paramsClass = RestrictedCookieManager_AddChangeListener_ResponseParams;
        break;
      case kRestrictedCookieManager_SetCookieFromString_Name:
        if (message.isResponse())
          paramsClass = RestrictedCookieManager_SetCookieFromString_ResponseParams;
        break;
      case kRestrictedCookieManager_GetCookiesString_Name:
        if (message.isResponse())
          paramsClass = RestrictedCookieManager_GetCookiesString_ResponseParams;
        break;
      case kRestrictedCookieManager_CookiesEnabledFor_Name:
        if (message.isResponse())
          paramsClass = RestrictedCookieManager_CookiesEnabledFor_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var RestrictedCookieManager = {
    name: 'network.mojom.RestrictedCookieManager',
    kVersion: 0,
    ptrClass: RestrictedCookieManagerPtr,
    proxyClass: RestrictedCookieManagerProxy,
    stubClass: RestrictedCookieManagerStub,
    validateRequest: validateRestrictedCookieManagerRequest,
    validateResponse: validateRestrictedCookieManagerResponse,
  };
  RestrictedCookieManagerStub.prototype.validator = validateRestrictedCookieManagerRequest;
  RestrictedCookieManagerProxy.prototype.validator = validateRestrictedCookieManagerResponse;
  exports.INVALID_COOKIE_VERSION = INVALID_COOKIE_VERSION;
  exports.INITIAL_COOKIE_VERSION = INITIAL_COOKIE_VERSION;
  exports.CookieMatchType = CookieMatchType;
  exports.RestrictedCookieManagerRole = RestrictedCookieManagerRole;
  exports.CookieManagerGetOptions = CookieManagerGetOptions;
  exports.CookiesResponse = CookiesResponse;
  exports.RestrictedCookieManager = RestrictedCookieManager;
  exports.RestrictedCookieManagerPtr = RestrictedCookieManagerPtr;
  exports.RestrictedCookieManagerAssociatedPtr = RestrictedCookieManagerAssociatedPtr;
})();