// services/network/public/mojom/restricted_cookie_manager.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_COOKIE_MANAGER_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_COOKIE_MANAGER_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/restricted_cookie_manager.mojom-shared-internal.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "services/network/public/mojom/storage_access_api.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"

#include "services/network/public/mojom/restricted_cookie_manager.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CookieMatchType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::RestrictedCookieManagerRole, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CookieManagerGetOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieManagerGetOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieManagerGetOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in CookieManagerGetOptions struct");

      
      mojo::internal::Serialize<::network::mojom::CookieMatchType>(
        Traits::match_type(input),
        &fragment->match_type);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CookiesResponseDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookiesResponseDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookiesResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->version = Traits::version(input);

      decltype(Traits::version_buffer(input)) in_version_buffer = Traits::version_buffer(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->version_buffer)::BaseType> version_buffer_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView, send_validation>(
        in_version_buffer,
        version_buffer_fragment);

      fragment->version_buffer.Set(
          version_buffer_fragment.is_null() ? nullptr : version_buffer_fragment.data());

      decltype(Traits::cookies(input)) in_cookies = Traits::cookies(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cookies)::BaseType> cookies_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_cookies,
        cookies_fragment);

      fragment->cookies.Set(
          cookies_fragment.is_null() ? nullptr : cookies_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cookies.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cookies in CookiesResponse struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_COOKIE_MANAGER_MOJOM_SEND_VALIDATION_H_