// services/network/public/mojom/restricted_cookie_manager.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_COOKIE_MANAGER_MOJOM_PARAMS_DATA_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_COOKIE_MANAGER_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace network::mojom {
namespace internal {
class  RestrictedCookieManager_GetAllForUrl_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<::network::mojom::internal::SiteForCookies_Data> site_for_cookies;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> top_frame_origin;
  int32_t storage_access_api_status;
  uint8_t is_ad_tagged : 1;
  uint8_t apply_devtools_overrides : 1;
  uint8_t force_disable_third_party_cookies : 1;
  uint8_t pad6_[3];
  mojo::internal::Pointer<internal::CookieManagerGetOptions_Data> options;

 private:
  friend class mojo::internal::MessageFragment<RestrictedCookieManager_GetAllForUrl_Params_Data>;

  RestrictedCookieManager_GetAllForUrl_Params_Data();
  ~RestrictedCookieManager_GetAllForUrl_Params_Data() = delete;
};
static_assert(sizeof(RestrictedCookieManager_GetAllForUrl_Params_Data) == 48,
              "Bad sizeof(RestrictedCookieManager_GetAllForUrl_Params_Data)");
class  RestrictedCookieManager_GetAllForUrl_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::CookieWithAccessResult_Data>>> cookies;

 private:
  friend class mojo::internal::MessageFragment<RestrictedCookieManager_GetAllForUrl_ResponseParams_Data>;

  RestrictedCookieManager_GetAllForUrl_ResponseParams_Data();
  ~RestrictedCookieManager_GetAllForUrl_ResponseParams_Data() = delete;
};
static_assert(sizeof(RestrictedCookieManager_GetAllForUrl_ResponseParams_Data) == 16,
              "Bad sizeof(RestrictedCookieManager_GetAllForUrl_ResponseParams_Data)");
class  RestrictedCookieManager_SetCanonicalCookie_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::CanonicalCookie_Data> cookie;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<::network::mojom::internal::SiteForCookies_Data> site_for_cookies;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> top_frame_origin;
  int32_t storage_access_api_status;
  uint8_t is_ad_tagged : 1;
  uint8_t apply_devtools_overrides : 1;
  uint8_t pad6_[3];
  mojo::internal::Pointer<::network::mojom::internal::CookieInclusionStatus_Data> status;

 private:
  friend class mojo::internal::MessageFragment<RestrictedCookieManager_SetCanonicalCookie_Params_Data>;

  RestrictedCookieManager_SetCanonicalCookie_Params_Data();
  ~RestrictedCookieManager_SetCanonicalCookie_Params_Data() = delete;
};
static_assert(sizeof(RestrictedCookieManager_SetCanonicalCookie_Params_Data) == 56,
              "Bad sizeof(RestrictedCookieManager_SetCanonicalCookie_Params_Data)");
class  RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data>;

  RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data();
  ~RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data() = delete;
};
static_assert(sizeof(RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data) == 16,
              "Bad sizeof(RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data)");
class  RestrictedCookieManager_AddChangeListener_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<::network::mojom::internal::SiteForCookies_Data> site_for_cookies;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> top_frame_origin;
  int32_t storage_access_api_status;
  mojo::internal::Interface_Data listener;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<RestrictedCookieManager_AddChangeListener_Params_Data>;

  RestrictedCookieManager_AddChangeListener_Params_Data();
  ~RestrictedCookieManager_AddChangeListener_Params_Data() = delete;
};
static_assert(sizeof(RestrictedCookieManager_AddChangeListener_Params_Data) == 48,
              "Bad sizeof(RestrictedCookieManager_AddChangeListener_Params_Data)");
class  RestrictedCookieManager_AddChangeListener_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<RestrictedCookieManager_AddChangeListener_ResponseParams_Data>;

  RestrictedCookieManager_AddChangeListener_ResponseParams_Data();
  ~RestrictedCookieManager_AddChangeListener_ResponseParams_Data() = delete;
};
static_assert(sizeof(RestrictedCookieManager_AddChangeListener_ResponseParams_Data) == 8,
              "Bad sizeof(RestrictedCookieManager_AddChangeListener_ResponseParams_Data)");
class  RestrictedCookieManager_SetCookieFromString_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<::network::mojom::internal::SiteForCookies_Data> site_for_cookies;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> top_frame_origin;
  int32_t storage_access_api_status;
  uint8_t get_version_shared_memory : 1;
  uint8_t is_ad_tagged : 1;
  uint8_t apply_devtools_overrides : 1;
  uint8_t pad6_[3];
  mojo::internal::Pointer<mojo::internal::String_Data> cookie;

 private:
  friend class mojo::internal::MessageFragment<RestrictedCookieManager_SetCookieFromString_Params_Data>;

  RestrictedCookieManager_SetCookieFromString_Params_Data();
  ~RestrictedCookieManager_SetCookieFromString_Params_Data() = delete;
};
static_assert(sizeof(RestrictedCookieManager_SetCookieFromString_Params_Data) == 48,
              "Bad sizeof(RestrictedCookieManager_SetCookieFromString_Params_Data)");
class  RestrictedCookieManager_SetCookieFromString_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CookiesResponse_Data> response;

 private:
  friend class mojo::internal::MessageFragment<RestrictedCookieManager_SetCookieFromString_ResponseParams_Data>;

  RestrictedCookieManager_SetCookieFromString_ResponseParams_Data();
  ~RestrictedCookieManager_SetCookieFromString_ResponseParams_Data() = delete;
};
static_assert(sizeof(RestrictedCookieManager_SetCookieFromString_ResponseParams_Data) == 16,
              "Bad sizeof(RestrictedCookieManager_SetCookieFromString_ResponseParams_Data)");
class  RestrictedCookieManager_GetCookiesString_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<::network::mojom::internal::SiteForCookies_Data> site_for_cookies;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> top_frame_origin;
  int32_t storage_access_api_status;
  uint8_t get_version_shared_memory : 1;
  uint8_t is_ad_tagged : 1;
  uint8_t apply_devtools_overrides : 1;
  uint8_t force_disable_third_party_cookies : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<RestrictedCookieManager_GetCookiesString_Params_Data>;

  RestrictedCookieManager_GetCookiesString_Params_Data();
  ~RestrictedCookieManager_GetCookiesString_Params_Data() = delete;
};
static_assert(sizeof(RestrictedCookieManager_GetCookiesString_Params_Data) == 40,
              "Bad sizeof(RestrictedCookieManager_GetCookiesString_Params_Data)");
class  RestrictedCookieManager_GetCookiesString_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t version;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data> version_buffer;
  mojo::internal::Pointer<mojo::internal::String_Data> cookies;

 private:
  friend class mojo::internal::MessageFragment<RestrictedCookieManager_GetCookiesString_ResponseParams_Data>;

  RestrictedCookieManager_GetCookiesString_ResponseParams_Data();
  ~RestrictedCookieManager_GetCookiesString_ResponseParams_Data() = delete;
};
static_assert(sizeof(RestrictedCookieManager_GetCookiesString_ResponseParams_Data) == 32,
              "Bad sizeof(RestrictedCookieManager_GetCookiesString_ResponseParams_Data)");
class  RestrictedCookieManager_CookiesEnabledFor_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<::network::mojom::internal::SiteForCookies_Data> site_for_cookies;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> top_frame_origin;
  int32_t storage_access_api_status;
  uint8_t apply_devtools_overrides : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<RestrictedCookieManager_CookiesEnabledFor_Params_Data>;

  RestrictedCookieManager_CookiesEnabledFor_Params_Data();
  ~RestrictedCookieManager_CookiesEnabledFor_Params_Data() = delete;
};
static_assert(sizeof(RestrictedCookieManager_CookiesEnabledFor_Params_Data) == 40,
              "Bad sizeof(RestrictedCookieManager_CookiesEnabledFor_Params_Data)");
class  RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t cookies_enabled : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data>;

  RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data();
  ~RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data() = delete;
};
static_assert(sizeof(RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data) == 16,
              "Bad sizeof(RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data)");

}  // namespace internal


class RestrictedCookieManager_GetAllForUrl_ParamsDataView {
 public:
  RestrictedCookieManager_GetAllForUrl_ParamsDataView() = default;

  RestrictedCookieManager_GetAllForUrl_ParamsDataView(
      internal::RestrictedCookieManager_GetAllForUrl_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSiteForCookiesDataView(
      ::network::mojom::SiteForCookiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiteForCookies(UserType* output) {
    
    auto* pointer = data_->site_for_cookies.Get();
    return mojo::internal::Deserialize<::network::mojom::SiteForCookiesDataView>(
        pointer, output, message_);
  }
  inline void GetTopFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopFrameOrigin(UserType* output) {
    
    auto* pointer = data_->top_frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStorageAccessApiStatus(UserType* output) const {
    auto data_value = data_->storage_access_api_status;
    return mojo::internal::Deserialize<::network::mojom::StorageAccessApiStatus>(
        data_value, output);
  }
  ::network::mojom::StorageAccessApiStatus storage_access_api_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::StorageAccessApiStatus>(data_->storage_access_api_status));
  }
  inline void GetOptionsDataView(
      CookieManagerGetOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieManagerGetOptionsDataView>(
        pointer, output, message_);
  }
  bool is_ad_tagged() const {
    return data_->is_ad_tagged;
  }
  bool apply_devtools_overrides() const {
    return data_->apply_devtools_overrides;
  }
  bool force_disable_third_party_cookies() const {
    return data_->force_disable_third_party_cookies;
  }
 private:
  internal::RestrictedCookieManager_GetAllForUrl_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RestrictedCookieManager_GetAllForUrl_ResponseParamsDataView {
 public:
  RestrictedCookieManager_GetAllForUrl_ResponseParamsDataView() = default;

  RestrictedCookieManager_GetAllForUrl_ResponseParamsDataView(
      internal::RestrictedCookieManager_GetAllForUrl_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCookiesDataView(
      mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookies(UserType* output) {
    
    auto* pointer = data_->cookies.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>>(
        pointer, output, message_);
  }
 private:
  internal::RestrictedCookieManager_GetAllForUrl_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RestrictedCookieManager_SetCanonicalCookie_ParamsDataView {
 public:
  RestrictedCookieManager_SetCanonicalCookie_ParamsDataView() = default;

  RestrictedCookieManager_SetCanonicalCookie_ParamsDataView(
      internal::RestrictedCookieManager_SetCanonicalCookie_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCookieDataView(
      ::network::mojom::CanonicalCookieDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookie(UserType* output) {
    
    auto* pointer = data_->cookie.Get();
    return mojo::internal::Deserialize<::network::mojom::CanonicalCookieDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSiteForCookiesDataView(
      ::network::mojom::SiteForCookiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiteForCookies(UserType* output) {
    
    auto* pointer = data_->site_for_cookies.Get();
    return mojo::internal::Deserialize<::network::mojom::SiteForCookiesDataView>(
        pointer, output, message_);
  }
  inline void GetTopFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopFrameOrigin(UserType* output) {
    
    auto* pointer = data_->top_frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStorageAccessApiStatus(UserType* output) const {
    auto data_value = data_->storage_access_api_status;
    return mojo::internal::Deserialize<::network::mojom::StorageAccessApiStatus>(
        data_value, output);
  }
  ::network::mojom::StorageAccessApiStatus storage_access_api_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::StorageAccessApiStatus>(data_->storage_access_api_status));
  }
  inline void GetStatusDataView(
      ::network::mojom::CookieInclusionStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieInclusionStatusDataView>(
        pointer, output, message_);
  }
  bool is_ad_tagged() const {
    return data_->is_ad_tagged;
  }
  bool apply_devtools_overrides() const {
    return data_->apply_devtools_overrides;
  }
 private:
  internal::RestrictedCookieManager_SetCanonicalCookie_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RestrictedCookieManager_SetCanonicalCookie_ResponseParamsDataView {
 public:
  RestrictedCookieManager_SetCanonicalCookie_ResponseParamsDataView() = default;

  RestrictedCookieManager_SetCanonicalCookie_ResponseParamsDataView(
      internal::RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data* data_ = nullptr;
};


class RestrictedCookieManager_AddChangeListener_ParamsDataView {
 public:
  RestrictedCookieManager_AddChangeListener_ParamsDataView() = default;

  RestrictedCookieManager_AddChangeListener_ParamsDataView(
      internal::RestrictedCookieManager_AddChangeListener_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSiteForCookiesDataView(
      ::network::mojom::SiteForCookiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiteForCookies(UserType* output) {
    
    auto* pointer = data_->site_for_cookies.Get();
    return mojo::internal::Deserialize<::network::mojom::SiteForCookiesDataView>(
        pointer, output, message_);
  }
  inline void GetTopFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopFrameOrigin(UserType* output) {
    
    auto* pointer = data_->top_frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStorageAccessApiStatus(UserType* output) const {
    auto data_value = data_->storage_access_api_status;
    return mojo::internal::Deserialize<::network::mojom::StorageAccessApiStatus>(
        data_value, output);
  }
  ::network::mojom::StorageAccessApiStatus storage_access_api_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::StorageAccessApiStatus>(data_->storage_access_api_status));
  }
  template <typename UserType>
  UserType TakeListener() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::CookieChangeListenerInterfaceBase>>(
            &data_->listener, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::RestrictedCookieManager_AddChangeListener_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RestrictedCookieManager_AddChangeListener_ResponseParamsDataView {
 public:
  RestrictedCookieManager_AddChangeListener_ResponseParamsDataView() = default;

  RestrictedCookieManager_AddChangeListener_ResponseParamsDataView(
      internal::RestrictedCookieManager_AddChangeListener_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::RestrictedCookieManager_AddChangeListener_ResponseParams_Data* data_ = nullptr;
};


class RestrictedCookieManager_SetCookieFromString_ParamsDataView {
 public:
  RestrictedCookieManager_SetCookieFromString_ParamsDataView() = default;

  RestrictedCookieManager_SetCookieFromString_ParamsDataView(
      internal::RestrictedCookieManager_SetCookieFromString_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSiteForCookiesDataView(
      ::network::mojom::SiteForCookiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiteForCookies(UserType* output) {
    
    auto* pointer = data_->site_for_cookies.Get();
    return mojo::internal::Deserialize<::network::mojom::SiteForCookiesDataView>(
        pointer, output, message_);
  }
  inline void GetTopFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopFrameOrigin(UserType* output) {
    
    auto* pointer = data_->top_frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStorageAccessApiStatus(UserType* output) const {
    auto data_value = data_->storage_access_api_status;
    return mojo::internal::Deserialize<::network::mojom::StorageAccessApiStatus>(
        data_value, output);
  }
  ::network::mojom::StorageAccessApiStatus storage_access_api_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::StorageAccessApiStatus>(data_->storage_access_api_status));
  }
  bool get_version_shared_memory() const {
    return data_->get_version_shared_memory;
  }
  bool is_ad_tagged() const {
    return data_->is_ad_tagged;
  }
  bool apply_devtools_overrides() const {
    return data_->apply_devtools_overrides;
  }
  inline void GetCookieDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookie(UserType* output) {
    
    auto* pointer = data_->cookie.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::RestrictedCookieManager_SetCookieFromString_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RestrictedCookieManager_SetCookieFromString_ResponseParamsDataView {
 public:
  RestrictedCookieManager_SetCookieFromString_ResponseParamsDataView() = default;

  RestrictedCookieManager_SetCookieFromString_ResponseParamsDataView(
      internal::RestrictedCookieManager_SetCookieFromString_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResponseDataView(
      CookiesResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponse(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::CookiesResponseDataView, UserType>(),
    "Attempting to read the optional `response` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadResponse` instead "
    "of `ReadResponse if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->response.Get();
    return mojo::internal::Deserialize<::network::mojom::CookiesResponseDataView>(
        pointer, output, message_);
  }
 private:
  internal::RestrictedCookieManager_SetCookieFromString_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RestrictedCookieManager_GetCookiesString_ParamsDataView {
 public:
  RestrictedCookieManager_GetCookiesString_ParamsDataView() = default;

  RestrictedCookieManager_GetCookiesString_ParamsDataView(
      internal::RestrictedCookieManager_GetCookiesString_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSiteForCookiesDataView(
      ::network::mojom::SiteForCookiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiteForCookies(UserType* output) {
    
    auto* pointer = data_->site_for_cookies.Get();
    return mojo::internal::Deserialize<::network::mojom::SiteForCookiesDataView>(
        pointer, output, message_);
  }
  inline void GetTopFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopFrameOrigin(UserType* output) {
    
    auto* pointer = data_->top_frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStorageAccessApiStatus(UserType* output) const {
    auto data_value = data_->storage_access_api_status;
    return mojo::internal::Deserialize<::network::mojom::StorageAccessApiStatus>(
        data_value, output);
  }
  ::network::mojom::StorageAccessApiStatus storage_access_api_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::StorageAccessApiStatus>(data_->storage_access_api_status));
  }
  bool get_version_shared_memory() const {
    return data_->get_version_shared_memory;
  }
  bool is_ad_tagged() const {
    return data_->is_ad_tagged;
  }
  bool apply_devtools_overrides() const {
    return data_->apply_devtools_overrides;
  }
  bool force_disable_third_party_cookies() const {
    return data_->force_disable_third_party_cookies;
  }
 private:
  internal::RestrictedCookieManager_GetCookiesString_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RestrictedCookieManager_GetCookiesString_ResponseParamsDataView {
 public:
  RestrictedCookieManager_GetCookiesString_ResponseParamsDataView() = default;

  RestrictedCookieManager_GetCookiesString_ResponseParamsDataView(
      internal::RestrictedCookieManager_GetCookiesString_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t version() const {
    return data_->version;
  }
  inline void GetVersionBufferDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersionBuffer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView, UserType>(),
    "Attempting to read the optional `version_buffer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVersionBuffer` instead "
    "of `ReadVersionBuffer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->version_buffer.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, message_);
  }
  inline void GetCookiesDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookies(UserType* output) {
    
    auto* pointer = data_->cookies.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::RestrictedCookieManager_GetCookiesString_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RestrictedCookieManager_CookiesEnabledFor_ParamsDataView {
 public:
  RestrictedCookieManager_CookiesEnabledFor_ParamsDataView() = default;

  RestrictedCookieManager_CookiesEnabledFor_ParamsDataView(
      internal::RestrictedCookieManager_CookiesEnabledFor_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSiteForCookiesDataView(
      ::network::mojom::SiteForCookiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiteForCookies(UserType* output) {
    
    auto* pointer = data_->site_for_cookies.Get();
    return mojo::internal::Deserialize<::network::mojom::SiteForCookiesDataView>(
        pointer, output, message_);
  }
  inline void GetTopFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopFrameOrigin(UserType* output) {
    
    auto* pointer = data_->top_frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStorageAccessApiStatus(UserType* output) const {
    auto data_value = data_->storage_access_api_status;
    return mojo::internal::Deserialize<::network::mojom::StorageAccessApiStatus>(
        data_value, output);
  }
  ::network::mojom::StorageAccessApiStatus storage_access_api_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::StorageAccessApiStatus>(data_->storage_access_api_status));
  }
  bool apply_devtools_overrides() const {
    return data_->apply_devtools_overrides;
  }
 private:
  internal::RestrictedCookieManager_CookiesEnabledFor_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RestrictedCookieManager_CookiesEnabledFor_ResponseParamsDataView {
 public:
  RestrictedCookieManager_CookiesEnabledFor_ResponseParamsDataView() = default;

  RestrictedCookieManager_CookiesEnabledFor_ResponseParamsDataView(
      internal::RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool cookies_enabled() const {
    return data_->cookies_enabled;
  }
 private:
  internal::RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data* data_ = nullptr;
};

inline void RestrictedCookieManager_GetAllForUrl_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void RestrictedCookieManager_GetAllForUrl_ParamsDataView::GetSiteForCookiesDataView(
    ::network::mojom::SiteForCookiesDataView* output) {
  auto pointer = data_->site_for_cookies.Get();
  *output = ::network::mojom::SiteForCookiesDataView(pointer, message_);
}
inline void RestrictedCookieManager_GetAllForUrl_ParamsDataView::GetTopFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->top_frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void RestrictedCookieManager_GetAllForUrl_ParamsDataView::GetOptionsDataView(
    CookieManagerGetOptionsDataView* output) {
  auto pointer = data_->options.Get();
  *output = CookieManagerGetOptionsDataView(pointer, message_);
}


inline void RestrictedCookieManager_GetAllForUrl_ResponseParamsDataView::GetCookiesDataView(
    mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>* output) {
  auto pointer = data_->cookies.Get();
  *output = mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>(pointer, message_);
}


inline void RestrictedCookieManager_SetCanonicalCookie_ParamsDataView::GetCookieDataView(
    ::network::mojom::CanonicalCookieDataView* output) {
  auto pointer = data_->cookie.Get();
  *output = ::network::mojom::CanonicalCookieDataView(pointer, message_);
}
inline void RestrictedCookieManager_SetCanonicalCookie_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void RestrictedCookieManager_SetCanonicalCookie_ParamsDataView::GetSiteForCookiesDataView(
    ::network::mojom::SiteForCookiesDataView* output) {
  auto pointer = data_->site_for_cookies.Get();
  *output = ::network::mojom::SiteForCookiesDataView(pointer, message_);
}
inline void RestrictedCookieManager_SetCanonicalCookie_ParamsDataView::GetTopFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->top_frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void RestrictedCookieManager_SetCanonicalCookie_ParamsDataView::GetStatusDataView(
    ::network::mojom::CookieInclusionStatusDataView* output) {
  auto pointer = data_->status.Get();
  *output = ::network::mojom::CookieInclusionStatusDataView(pointer, message_);
}




inline void RestrictedCookieManager_AddChangeListener_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void RestrictedCookieManager_AddChangeListener_ParamsDataView::GetSiteForCookiesDataView(
    ::network::mojom::SiteForCookiesDataView* output) {
  auto pointer = data_->site_for_cookies.Get();
  *output = ::network::mojom::SiteForCookiesDataView(pointer, message_);
}
inline void RestrictedCookieManager_AddChangeListener_ParamsDataView::GetTopFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->top_frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}




inline void RestrictedCookieManager_SetCookieFromString_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void RestrictedCookieManager_SetCookieFromString_ParamsDataView::GetSiteForCookiesDataView(
    ::network::mojom::SiteForCookiesDataView* output) {
  auto pointer = data_->site_for_cookies.Get();
  *output = ::network::mojom::SiteForCookiesDataView(pointer, message_);
}
inline void RestrictedCookieManager_SetCookieFromString_ParamsDataView::GetTopFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->top_frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void RestrictedCookieManager_SetCookieFromString_ParamsDataView::GetCookieDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->cookie.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void RestrictedCookieManager_SetCookieFromString_ResponseParamsDataView::GetResponseDataView(
    CookiesResponseDataView* output) {
  auto pointer = data_->response.Get();
  *output = CookiesResponseDataView(pointer, message_);
}


inline void RestrictedCookieManager_GetCookiesString_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void RestrictedCookieManager_GetCookiesString_ParamsDataView::GetSiteForCookiesDataView(
    ::network::mojom::SiteForCookiesDataView* output) {
  auto pointer = data_->site_for_cookies.Get();
  *output = ::network::mojom::SiteForCookiesDataView(pointer, message_);
}
inline void RestrictedCookieManager_GetCookiesString_ParamsDataView::GetTopFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->top_frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void RestrictedCookieManager_GetCookiesString_ResponseParamsDataView::GetVersionBufferDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->version_buffer.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, message_);
}
inline void RestrictedCookieManager_GetCookiesString_ResponseParamsDataView::GetCookiesDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->cookies.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void RestrictedCookieManager_CookiesEnabledFor_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void RestrictedCookieManager_CookiesEnabledFor_ParamsDataView::GetSiteForCookiesDataView(
    ::network::mojom::SiteForCookiesDataView* output) {
  auto pointer = data_->site_for_cookies.Get();
  *output = ::network::mojom::SiteForCookiesDataView(pointer, message_);
}
inline void RestrictedCookieManager_CookiesEnabledFor_ParamsDataView::GetTopFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->top_frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}





}  // network::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_COOKIE_MANAGER_MOJOM_PARAMS_DATA_H_