// services/network/public/mojom/restricted_cookie_manager.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');




/**
 * @const { !bigint }
 * @export
 */
network.mojom.INVALID_COOKIE_VERSION = BigInt('0');

/**
 * @const { !bigint }
 * @export
 */
network.mojom.INITIAL_COOKIE_VERSION = BigInt('1');


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CookieMatchTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CookieMatchType = {
  
  EQUALS: 0,
  STARTS_WITH: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.RestrictedCookieManagerRoleSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.RestrictedCookieManagerRole = {
  
  SCRIPT: 0,
  NETWORK: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.RestrictedCookieManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.RestrictedCookieManager.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.RestrictedCookieManagerInterface }
 */
network.mojom.RestrictedCookieManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.RestrictedCookieManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.RestrictedCookieManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.RestrictedCookieManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.SiteForCookies } siteForCookies
   * @param { !url.mojom.Origin } topFrameOrigin
   * @param { !network.mojom.StorageAccessApiStatus } storageAccessApiStatus
   * @param { !network.mojom.CookieManagerGetOptions } options
   * @param { !boolean } isAdTagged
   * @param { !boolean } applyDevtoolsOverrides
   * @param { !boolean } forceDisableThirdPartyCookies
   * @return {!Promise<{
        cookies: !Array<!network.mojom.CookieWithAccessResult>,
   *  }>}
   */

  getAllForUrl(
      url,
      siteForCookies,
      topFrameOrigin,
      storageAccessApiStatus,
      options,
      isAdTagged,
      applyDevtoolsOverrides,
      forceDisableThirdPartyCookies) {
    return this.proxy.sendMessage(
        0,
        network.mojom.RestrictedCookieManager_GetAllForUrl_ParamsSpec.$,
        network.mojom.RestrictedCookieManager_GetAllForUrl_ResponseParamsSpec.$,
        [
          url,
          siteForCookies,
          topFrameOrigin,
          storageAccessApiStatus,
          options,
          isAdTagged,
          applyDevtoolsOverrides,
          forceDisableThirdPartyCookies
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.CanonicalCookie } cookie
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.SiteForCookies } siteForCookies
   * @param { !url.mojom.Origin } topFrameOrigin
   * @param { !network.mojom.StorageAccessApiStatus } storageAccessApiStatus
   * @param { !network.mojom.CookieInclusionStatus } status
   * @param { !boolean } isAdTagged
   * @param { !boolean } applyDevtoolsOverrides
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setCanonicalCookie(
      cookie,
      url,
      siteForCookies,
      topFrameOrigin,
      storageAccessApiStatus,
      status,
      isAdTagged,
      applyDevtoolsOverrides) {
    return this.proxy.sendMessage(
        1,
        network.mojom.RestrictedCookieManager_SetCanonicalCookie_ParamsSpec.$,
        network.mojom.RestrictedCookieManager_SetCanonicalCookie_ResponseParamsSpec.$,
        [
          cookie,
          url,
          siteForCookies,
          topFrameOrigin,
          storageAccessApiStatus,
          status,
          isAdTagged,
          applyDevtoolsOverrides
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.SiteForCookies } siteForCookies
   * @param { !url.mojom.Origin } topFrameOrigin
   * @param { !network.mojom.StorageAccessApiStatus } storageAccessApiStatus
   * @param { !network.mojom.CookieChangeListenerRemote } listener
   * @return {!Promise}
   */

  addChangeListener(
      url,
      siteForCookies,
      topFrameOrigin,
      storageAccessApiStatus,
      listener) {
    return this.proxy.sendMessage(
        2,
        network.mojom.RestrictedCookieManager_AddChangeListener_ParamsSpec.$,
        network.mojom.RestrictedCookieManager_AddChangeListener_ResponseParamsSpec.$,
        [
          url,
          siteForCookies,
          topFrameOrigin,
          storageAccessApiStatus,
          listener
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.SiteForCookies } siteForCookies
   * @param { !url.mojom.Origin } topFrameOrigin
   * @param { !network.mojom.StorageAccessApiStatus } storageAccessApiStatus
   * @param { !boolean } getVersionSharedMemory
   * @param { !boolean } isAdTagged
   * @param { !boolean } applyDevtoolsOverrides
   * @param { !string } cookie
   * @return {!Promise<{
        response: ?network.mojom.CookiesResponse,
   *  }>}
   */

  setCookieFromString(
      url,
      siteForCookies,
      topFrameOrigin,
      storageAccessApiStatus,
      getVersionSharedMemory,
      isAdTagged,
      applyDevtoolsOverrides,
      cookie) {
    return this.proxy.sendMessage(
        3,
        network.mojom.RestrictedCookieManager_SetCookieFromString_ParamsSpec.$,
        network.mojom.RestrictedCookieManager_SetCookieFromString_ResponseParamsSpec.$,
        [
          url,
          siteForCookies,
          topFrameOrigin,
          storageAccessApiStatus,
          getVersionSharedMemory,
          isAdTagged,
          applyDevtoolsOverrides,
          cookie
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.SiteForCookies } siteForCookies
   * @param { !url.mojom.Origin } topFrameOrigin
   * @param { !network.mojom.StorageAccessApiStatus } storageAccessApiStatus
   * @param { !boolean } getVersionSharedMemory
   * @param { !boolean } isAdTagged
   * @param { !boolean } applyDevtoolsOverrides
   * @param { !boolean } forceDisableThirdPartyCookies
   * @return {!Promise<{
        version: !bigint,
        versionBuffer: ?mojoBase.mojom.ReadOnlySharedMemoryRegion,
        cookies: !string,
   *  }>}
   */

  getCookiesString(
      url,
      siteForCookies,
      topFrameOrigin,
      storageAccessApiStatus,
      getVersionSharedMemory,
      isAdTagged,
      applyDevtoolsOverrides,
      forceDisableThirdPartyCookies) {
    return this.proxy.sendMessage(
        4,
        network.mojom.RestrictedCookieManager_GetCookiesString_ParamsSpec.$,
        network.mojom.RestrictedCookieManager_GetCookiesString_ResponseParamsSpec.$,
        [
          url,
          siteForCookies,
          topFrameOrigin,
          storageAccessApiStatus,
          getVersionSharedMemory,
          isAdTagged,
          applyDevtoolsOverrides,
          forceDisableThirdPartyCookies
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.SiteForCookies } siteForCookies
   * @param { !url.mojom.Origin } topFrameOrigin
   * @param { !network.mojom.StorageAccessApiStatus } storageAccessApiStatus
   * @param { !boolean } applyDevtoolsOverrides
   * @return {!Promise<{
        cookiesEnabled: !boolean,
   *  }>}
   */

  cookiesEnabledFor(
      url,
      siteForCookies,
      topFrameOrigin,
      storageAccessApiStatus,
      applyDevtoolsOverrides) {
    return this.proxy.sendMessage(
        5,
        network.mojom.RestrictedCookieManager_CookiesEnabledFor_ParamsSpec.$,
        network.mojom.RestrictedCookieManager_CookiesEnabledFor_ResponseParamsSpec.$,
        [
          url,
          siteForCookies,
          topFrameOrigin,
          storageAccessApiStatus,
          applyDevtoolsOverrides
        ],
        false);
  }
};

/**
 * An object which receives request messages for the RestrictedCookieManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.RestrictedCookieManagerReceiver = class {
  /**
   * @param {!network.mojom.RestrictedCookieManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.RestrictedCookieManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.RestrictedCookieManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.RestrictedCookieManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.RestrictedCookieManager_GetAllForUrl_ParamsSpec.$,
        network.mojom.RestrictedCookieManager_GetAllForUrl_ResponseParamsSpec.$,
        impl.getAllForUrl.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.RestrictedCookieManager_SetCanonicalCookie_ParamsSpec.$,
        network.mojom.RestrictedCookieManager_SetCanonicalCookie_ResponseParamsSpec.$,
        impl.setCanonicalCookie.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.RestrictedCookieManager_AddChangeListener_ParamsSpec.$,
        network.mojom.RestrictedCookieManager_AddChangeListener_ResponseParamsSpec.$,
        impl.addChangeListener.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.RestrictedCookieManager_SetCookieFromString_ParamsSpec.$,
        network.mojom.RestrictedCookieManager_SetCookieFromString_ResponseParamsSpec.$,
        impl.setCookieFromString.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        network.mojom.RestrictedCookieManager_GetCookiesString_ParamsSpec.$,
        network.mojom.RestrictedCookieManager_GetCookiesString_ResponseParamsSpec.$,
        impl.getCookiesString.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        network.mojom.RestrictedCookieManager_CookiesEnabledFor_ParamsSpec.$,
        network.mojom.RestrictedCookieManager_CookiesEnabledFor_ResponseParamsSpec.$,
        impl.cookiesEnabledFor.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.RestrictedCookieManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.RestrictedCookieManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.RestrictedCookieManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.RestrictedCookieManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the RestrictedCookieManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.RestrictedCookieManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.RestrictedCookieManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.RestrictedCookieManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAllForUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.RestrictedCookieManager_GetAllForUrl_ParamsSpec.$,
        network.mojom.RestrictedCookieManager_GetAllForUrl_ResponseParamsSpec.$,
        this.getAllForUrl.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCanonicalCookie =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.RestrictedCookieManager_SetCanonicalCookie_ParamsSpec.$,
        network.mojom.RestrictedCookieManager_SetCanonicalCookie_ResponseParamsSpec.$,
        this.setCanonicalCookie.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addChangeListener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.RestrictedCookieManager_AddChangeListener_ParamsSpec.$,
        network.mojom.RestrictedCookieManager_AddChangeListener_ResponseParamsSpec.$,
        this.addChangeListener.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCookieFromString =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.RestrictedCookieManager_SetCookieFromString_ParamsSpec.$,
        network.mojom.RestrictedCookieManager_SetCookieFromString_ResponseParamsSpec.$,
        this.setCookieFromString.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCookiesString =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        network.mojom.RestrictedCookieManager_GetCookiesString_ParamsSpec.$,
        network.mojom.RestrictedCookieManager_GetCookiesString_ResponseParamsSpec.$,
        this.getCookiesString.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cookiesEnabledFor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        network.mojom.RestrictedCookieManager_CookiesEnabledFor_ParamsSpec.$,
        network.mojom.RestrictedCookieManager_CookiesEnabledFor_ResponseParamsSpec.$,
        this.cookiesEnabledFor.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookieManagerGetOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CookiesResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedCookieManager_GetAllForUrl_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedCookieManager_GetAllForUrl_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedCookieManager_SetCanonicalCookie_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedCookieManager_SetCanonicalCookie_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedCookieManager_AddChangeListener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedCookieManager_AddChangeListener_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedCookieManager_SetCookieFromString_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedCookieManager_SetCookieFromString_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedCookieManager_GetCookiesString_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedCookieManager_GetCookiesString_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedCookieManager_CookiesEnabledFor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RestrictedCookieManager_CookiesEnabledFor_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.CookieManagerGetOptionsSpec.$,
    'CookieManagerGetOptions',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'matchType', 8,
        0,
        network.mojom.CookieMatchTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.CookieManagerGetOptions = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !network.mojom.CookieMatchType } */
    this.matchType;
  }
};



mojo.internal.Struct(
    network.mojom.CookiesResponseSpec.$,
    'CookiesResponse',
    [
      mojo.internal.StructField(
        'version', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'versionBuffer', 8,
        0,
        mojoBase.mojom.ReadOnlySharedMemoryRegionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookies', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.CookiesResponse = class {
  constructor() {
    /** @export { !bigint } */
    this.version;
    /** @export { (mojoBase.mojom.ReadOnlySharedMemoryRegion|undefined) } */
    this.versionBuffer;
    /** @export { !string } */
    this.cookies;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedCookieManager_GetAllForUrl_ParamsSpec.$,
    'RestrictedCookieManager_GetAllForUrl_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'siteForCookies', 8,
        0,
        network.mojom.SiteForCookiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'topFrameOrigin', 16,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'storageAccessApiStatus', 24,
        0,
        network.mojom.StorageAccessApiStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 32,
        0,
        network.mojom.CookieManagerGetOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isAdTagged', 28,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'applyDevtoolsOverrides', 28,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'forceDisableThirdPartyCookies', 28,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
network.mojom.RestrictedCookieManager_GetAllForUrl_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.SiteForCookies } */
    this.siteForCookies;
    /** @export { !url.mojom.Origin } */
    this.topFrameOrigin;
    /** @export { !network.mojom.StorageAccessApiStatus } */
    this.storageAccessApiStatus;
    /** @export { !network.mojom.CookieManagerGetOptions } */
    this.options;
    /** @export { !boolean } */
    this.isAdTagged;
    /** @export { !boolean } */
    this.applyDevtoolsOverrides;
    /** @export { !boolean } */
    this.forceDisableThirdPartyCookies;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedCookieManager_GetAllForUrl_ResponseParamsSpec.$,
    'RestrictedCookieManager_GetAllForUrl_ResponseParams',
    [
      mojo.internal.StructField(
        'cookies', 0,
        0,
        mojo.internal.Array(network.mojom.CookieWithAccessResultSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.RestrictedCookieManager_GetAllForUrl_ResponseParams = class {
  constructor() {
    /** @export { !Array<!network.mojom.CookieWithAccessResult> } */
    this.cookies;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedCookieManager_SetCanonicalCookie_ParamsSpec.$,
    'RestrictedCookieManager_SetCanonicalCookie_Params',
    [
      mojo.internal.StructField(
        'cookie', 0,
        0,
        network.mojom.CanonicalCookieSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'siteForCookies', 16,
        0,
        network.mojom.SiteForCookiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'topFrameOrigin', 24,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'storageAccessApiStatus', 32,
        0,
        network.mojom.StorageAccessApiStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'status', 40,
        0,
        network.mojom.CookieInclusionStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isAdTagged', 36,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'applyDevtoolsOverrides', 36,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
network.mojom.RestrictedCookieManager_SetCanonicalCookie_Params = class {
  constructor() {
    /** @export { !network.mojom.CanonicalCookie } */
    this.cookie;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.SiteForCookies } */
    this.siteForCookies;
    /** @export { !url.mojom.Origin } */
    this.topFrameOrigin;
    /** @export { !network.mojom.StorageAccessApiStatus } */
    this.storageAccessApiStatus;
    /** @export { !network.mojom.CookieInclusionStatus } */
    this.status;
    /** @export { !boolean } */
    this.isAdTagged;
    /** @export { !boolean } */
    this.applyDevtoolsOverrides;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedCookieManager_SetCanonicalCookie_ResponseParamsSpec.$,
    'RestrictedCookieManager_SetCanonicalCookie_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.RestrictedCookieManager_SetCanonicalCookie_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedCookieManager_AddChangeListener_ParamsSpec.$,
    'RestrictedCookieManager_AddChangeListener_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'siteForCookies', 8,
        0,
        network.mojom.SiteForCookiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'topFrameOrigin', 16,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'storageAccessApiStatus', 24,
        0,
        network.mojom.StorageAccessApiStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'listener', 28,
        0,
        mojo.internal.InterfaceProxy(network.mojom.CookieChangeListenerRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
network.mojom.RestrictedCookieManager_AddChangeListener_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.SiteForCookies } */
    this.siteForCookies;
    /** @export { !url.mojom.Origin } */
    this.topFrameOrigin;
    /** @export { !network.mojom.StorageAccessApiStatus } */
    this.storageAccessApiStatus;
    /** @export { !network.mojom.CookieChangeListenerRemote } */
    this.listener;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedCookieManager_AddChangeListener_ResponseParamsSpec.$,
    'RestrictedCookieManager_AddChangeListener_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.RestrictedCookieManager_AddChangeListener_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedCookieManager_SetCookieFromString_ParamsSpec.$,
    'RestrictedCookieManager_SetCookieFromString_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'siteForCookies', 8,
        0,
        network.mojom.SiteForCookiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'topFrameOrigin', 16,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'storageAccessApiStatus', 24,
        0,
        network.mojom.StorageAccessApiStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'getVersionSharedMemory', 28,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isAdTagged', 28,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'applyDevtoolsOverrides', 28,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookie', 32,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
network.mojom.RestrictedCookieManager_SetCookieFromString_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.SiteForCookies } */
    this.siteForCookies;
    /** @export { !url.mojom.Origin } */
    this.topFrameOrigin;
    /** @export { !network.mojom.StorageAccessApiStatus } */
    this.storageAccessApiStatus;
    /** @export { !boolean } */
    this.getVersionSharedMemory;
    /** @export { !boolean } */
    this.isAdTagged;
    /** @export { !boolean } */
    this.applyDevtoolsOverrides;
    /** @export { !string } */
    this.cookie;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedCookieManager_SetCookieFromString_ResponseParamsSpec.$,
    'RestrictedCookieManager_SetCookieFromString_ResponseParams',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        network.mojom.CookiesResponseSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.RestrictedCookieManager_SetCookieFromString_ResponseParams = class {
  constructor() {
    /** @export { (network.mojom.CookiesResponse|undefined) } */
    this.response;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedCookieManager_GetCookiesString_ParamsSpec.$,
    'RestrictedCookieManager_GetCookiesString_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'siteForCookies', 8,
        0,
        network.mojom.SiteForCookiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'topFrameOrigin', 16,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'storageAccessApiStatus', 24,
        0,
        network.mojom.StorageAccessApiStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'getVersionSharedMemory', 28,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isAdTagged', 28,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'applyDevtoolsOverrides', 28,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'forceDisableThirdPartyCookies', 28,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
network.mojom.RestrictedCookieManager_GetCookiesString_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.SiteForCookies } */
    this.siteForCookies;
    /** @export { !url.mojom.Origin } */
    this.topFrameOrigin;
    /** @export { !network.mojom.StorageAccessApiStatus } */
    this.storageAccessApiStatus;
    /** @export { !boolean } */
    this.getVersionSharedMemory;
    /** @export { !boolean } */
    this.isAdTagged;
    /** @export { !boolean } */
    this.applyDevtoolsOverrides;
    /** @export { !boolean } */
    this.forceDisableThirdPartyCookies;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedCookieManager_GetCookiesString_ResponseParamsSpec.$,
    'RestrictedCookieManager_GetCookiesString_ResponseParams',
    [
      mojo.internal.StructField(
        'version', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'versionBuffer', 8,
        0,
        mojoBase.mojom.ReadOnlySharedMemoryRegionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookies', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.RestrictedCookieManager_GetCookiesString_ResponseParams = class {
  constructor() {
    /** @export { !bigint } */
    this.version;
    /** @export { (mojoBase.mojom.ReadOnlySharedMemoryRegion|undefined) } */
    this.versionBuffer;
    /** @export { !string } */
    this.cookies;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedCookieManager_CookiesEnabledFor_ParamsSpec.$,
    'RestrictedCookieManager_CookiesEnabledFor_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'siteForCookies', 8,
        0,
        network.mojom.SiteForCookiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'topFrameOrigin', 16,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'storageAccessApiStatus', 24,
        0,
        network.mojom.StorageAccessApiStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'applyDevtoolsOverrides', 28,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
network.mojom.RestrictedCookieManager_CookiesEnabledFor_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.SiteForCookies } */
    this.siteForCookies;
    /** @export { !url.mojom.Origin } */
    this.topFrameOrigin;
    /** @export { !network.mojom.StorageAccessApiStatus } */
    this.storageAccessApiStatus;
    /** @export { !boolean } */
    this.applyDevtoolsOverrides;
  }
};



mojo.internal.Struct(
    network.mojom.RestrictedCookieManager_CookiesEnabledFor_ResponseParamsSpec.$,
    'RestrictedCookieManager_CookiesEnabledFor_ResponseParams',
    [
      mojo.internal.StructField(
        'cookiesEnabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.RestrictedCookieManager_CookiesEnabledFor_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.cookiesEnabled;
  }
};

