// services/network/public/mojom/restricted_cookie_manager.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_COOKIE_MANAGER_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_COOKIE_MANAGER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/restricted_cookie_manager.mojom-shared-internal.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "services/network/public/mojom/storage_access_api.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"


namespace network::mojom {
class CookieManagerGetOptionsDataView;

class CookiesResponseDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::CookieManagerGetOptionsDataView> {
  using Data = ::network::mojom::internal::CookieManagerGetOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CookiesResponseDataView> {
  using Data = ::network::mojom::internal::CookiesResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class CookieMatchType : int32_t {
  
  EQUALS = 0,
  
  STARTS_WITH = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CookieMatchType value);
inline bool IsKnownEnumValue(CookieMatchType value) {
  return internal::CookieMatchType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RestrictedCookieManagerRole : int32_t {
  
  SCRIPT = 0,
  
  NETWORK = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, RestrictedCookieManagerRole value);
inline bool IsKnownEnumValue(RestrictedCookieManagerRole value) {
  return internal::RestrictedCookieManagerRole_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class RestrictedCookieManagerInterfaceBase {};

using RestrictedCookieManagerPtrDataView =
    mojo::InterfacePtrDataView<RestrictedCookieManagerInterfaceBase>;
using RestrictedCookieManagerRequestDataView =
    mojo::InterfaceRequestDataView<RestrictedCookieManagerInterfaceBase>;
using RestrictedCookieManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RestrictedCookieManagerInterfaceBase>;
using RestrictedCookieManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RestrictedCookieManagerInterfaceBase>;


class CookieManagerGetOptionsDataView {
 public:
  CookieManagerGetOptionsDataView() = default;

  CookieManagerGetOptionsDataView(
      internal::CookieManagerGetOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMatchType(UserType* output) const {
    auto data_value = data_->match_type;
    return mojo::internal::Deserialize<::network::mojom::CookieMatchType>(
        data_value, output);
  }
  CookieMatchType match_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CookieMatchType>(data_->match_type));
  }
 private:
  internal::CookieManagerGetOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookiesResponseDataView {
 public:
  CookiesResponseDataView() = default;

  CookiesResponseDataView(
      internal::CookiesResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t version() const {
    return data_->version;
  }
  inline void GetVersionBufferDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVersionBuffer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView, UserType>(),
    "Attempting to read the optional `version_buffer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVersionBuffer` instead "
    "of `ReadVersionBuffer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->version_buffer.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, message_);
  }
  inline void GetCookiesDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookies(UserType* output) {
    
    auto* pointer = data_->cookies.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::CookiesResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_COOKIE_MANAGER_MOJOM_DATA_VIEW_H_