// services/network/public/mojom/proxy_resolving_socket.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.ProxyResolvingSocketPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.ProxyResolvingSocket.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.ProxyResolvingSocketInterface }
 */
network.mojom.ProxyResolvingSocketRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.ProxyResolvingSocketPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.ProxyResolvingSocketPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.ProxyResolvingSocketPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.HostPortPair } hostPortPair
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network.mojom.TLSClientSocketPendingReceiver } receiver
   * @param { ?network.mojom.SocketObserverRemote } observer
   * @return {!Promise<{
        netError: !number,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
   *  }>}
   */

  upgradeToTLS(
      hostPortPair,
      trafficAnnotation,
      receiver,
      observer) {
    return this.proxy.sendMessage(
        0,
        network.mojom.ProxyResolvingSocket_UpgradeToTLS_ParamsSpec.$,
        network.mojom.ProxyResolvingSocket_UpgradeToTLS_ResponseParamsSpec.$,
        [
          hostPortPair,
          trafficAnnotation,
          receiver,
          observer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ProxyResolvingSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.ProxyResolvingSocketReceiver = class {
  /**
   * @param {!network.mojom.ProxyResolvingSocketInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.ProxyResolvingSocketRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.ProxyResolvingSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ProxyResolvingSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.ProxyResolvingSocket_UpgradeToTLS_ParamsSpec.$,
        network.mojom.ProxyResolvingSocket_UpgradeToTLS_ResponseParamsSpec.$,
        impl.upgradeToTLS.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.ProxyResolvingSocket = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ProxyResolvingSocket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.ProxyResolvingSocketRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.ProxyResolvingSocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ProxyResolvingSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.ProxyResolvingSocketCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.ProxyResolvingSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ProxyResolvingSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.upgradeToTLS =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.ProxyResolvingSocket_UpgradeToTLS_ParamsSpec.$,
        network.mojom.ProxyResolvingSocket_UpgradeToTLS_ResponseParamsSpec.$,
        this.upgradeToTLS.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.ProxyResolvingSocketFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.ProxyResolvingSocketFactory.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.ProxyResolvingSocketFactoryInterface }
 */
network.mojom.ProxyResolvingSocketFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.ProxyResolvingSocketFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.ProxyResolvingSocketFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.ProxyResolvingSocketFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { ?network.mojom.ProxyResolvingSocketOptions } options
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network.mojom.ProxyResolvingSocketPendingReceiver } socket
   * @param { ?network.mojom.SocketObserverRemote } observer
   * @return {!Promise<{
        result: !number,
        localAddr: ?network.mojom.IPEndPoint,
        peerAddr: ?network.mojom.IPEndPoint,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
   *  }>}
   */

  createProxyResolvingSocket(
      url,
      networkAnonymizationKey,
      options,
      trafficAnnotation,
      socket,
      observer) {
    return this.proxy.sendMessage(
        0,
        network.mojom.ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ParamsSpec.$,
        network.mojom.ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParamsSpec.$,
        [
          url,
          networkAnonymizationKey,
          options,
          trafficAnnotation,
          socket,
          observer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ProxyResolvingSocketFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.ProxyResolvingSocketFactoryReceiver = class {
  /**
   * @param {!network.mojom.ProxyResolvingSocketFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.ProxyResolvingSocketFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.ProxyResolvingSocketFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ProxyResolvingSocketFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ParamsSpec.$,
        network.mojom.ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParamsSpec.$,
        impl.createProxyResolvingSocket.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.ProxyResolvingSocketFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ProxyResolvingSocketFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.ProxyResolvingSocketFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.ProxyResolvingSocketFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ProxyResolvingSocketFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.ProxyResolvingSocketFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.ProxyResolvingSocketFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ProxyResolvingSocketFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createProxyResolvingSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ParamsSpec.$,
        network.mojom.ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParamsSpec.$,
        this.createProxyResolvingSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ProxyResolvingSocketOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ProxyResolvingSocket_UpgradeToTLS_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ProxyResolvingSocket_UpgradeToTLS_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.ProxyResolvingSocketOptionsSpec.$,
    'ProxyResolvingSocketOptions',
    [
      mojo.internal.StructField(
        'useTls', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.ProxyResolvingSocketOptions = class {
  constructor() {
    /** @export { !boolean } */
    this.useTls;
  }
};



mojo.internal.Struct(
    network.mojom.ProxyResolvingSocket_UpgradeToTLS_ParamsSpec.$,
    'ProxyResolvingSocket_UpgradeToTLS_Params',
    [
      mojo.internal.StructField(
        'hostPortPair', 0,
        0,
        network.mojom.HostPortPairSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 8,
        0,
        network.mojom.MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 16,
        0,
        mojo.internal.InterfaceRequest(network.mojom.TLSClientSocketPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observer', 20,
        0,
        mojo.internal.InterfaceProxy(network.mojom.SocketObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
network.mojom.ProxyResolvingSocket_UpgradeToTLS_Params = class {
  constructor() {
    /** @export { !network.mojom.HostPortPair } */
    this.hostPortPair;
    /** @export { !network.mojom.MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @export { !network.mojom.TLSClientSocketPendingReceiver } */
    this.receiver;
    /** @export { (network.mojom.SocketObserverRemote|undefined) } */
    this.observer;
  }
};



mojo.internal.Struct(
    network.mojom.ProxyResolvingSocket_UpgradeToTLS_ResponseParamsSpec.$,
    'ProxyResolvingSocket_UpgradeToTLS_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiveStream', 4,
        0,
        mojo.internal.Handle,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sendStream', 8,
        0,
        mojo.internal.Handle,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.ProxyResolvingSocket_UpgradeToTLS_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.netError;
    /** @export { (MojoHandle|undefined) } */
    this.receiveStream;
    /** @export { (MojoHandle|undefined) } */
    this.sendStream;
  }
};



mojo.internal.Struct(
    network.mojom.ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ParamsSpec.$,
    'ProxyResolvingSocketFactory_CreateProxyResolvingSocket_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 8,
        0,
        network.mojom.NetworkAnonymizationKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 24,
        0,
        network.mojom.ProxyResolvingSocketOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 32,
        0,
        network.mojom.MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'socket', 40,
        0,
        mojo.internal.InterfaceRequest(network.mojom.ProxyResolvingSocketPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observer', 44,
        0,
        mojo.internal.InterfaceProxy(network.mojom.SocketObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);





/** @record */
network.mojom.ProxyResolvingSocketFactory_CreateProxyResolvingSocket_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @export { (network.mojom.ProxyResolvingSocketOptions|undefined) } */
    this.options;
    /** @export { !network.mojom.MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @export { !network.mojom.ProxyResolvingSocketPendingReceiver } */
    this.socket;
    /** @export { (network.mojom.SocketObserverRemote|undefined) } */
    this.observer;
  }
};



mojo.internal.Struct(
    network.mojom.ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParamsSpec.$,
    'ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localAddr', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'peerAddr', 16,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiveStream', 4,
        0,
        mojo.internal.Handle,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sendStream', 24,
        0,
        mojo.internal.Handle,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
network.mojom.ProxyResolvingSocketFactory_CreateProxyResolvingSocket_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.localAddr;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.peerAddr;
    /** @export { (MojoHandle|undefined) } */
    this.receiveStream;
    /** @export { (MojoHandle|undefined) } */
    this.sendStream;
  }
};

