// services/network/public/mojom/proxy_config_with_annotation.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  MutableNetworkTrafficAnnotationTag as network_mojom_MutableNetworkTrafficAnnotationTag,
  MutableNetworkTrafficAnnotationTagSpec as network_mojom_MutableNetworkTrafficAnnotationTagSpec
} from './mutable_network_traffic_annotation_tag.mojom.m.js';

import {
  ProxyConfig as network_mojom_ProxyConfig,
  ProxyConfigSpec as network_mojom_ProxyConfigSpec
} from './proxy_config.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ProxyConfigClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.ProxyConfigClient', scope);
  }
}

/** @interface */
export class ProxyConfigClientInterface {
  
  /**
   * @param { !ProxyConfigWithAnnotation } proxyConfig
   */

  onProxyConfigUpdated(proxyConfig) {}
  
  /**
   * @return {!Promise}
   */

  flushProxyConfig() {}
}

/**
 * @implements { ProxyConfigClientInterface }
 */
export class ProxyConfigClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ProxyConfigClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ProxyConfigClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ProxyConfigClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ProxyConfigWithAnnotation } proxyConfig
   */

  onProxyConfigUpdated(
      proxyConfig) {
    this.proxy.sendMessage(
        0,
        ProxyConfigClient_OnProxyConfigUpdated_ParamsSpec.$,
        null,
        [
          proxyConfig
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  flushProxyConfig() {
    return this.proxy.sendMessage(
        1,
        ProxyConfigClient_FlushProxyConfig_ParamsSpec.$,
        ProxyConfigClient_FlushProxyConfig_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ProxyConfigClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ProxyConfigClientReceiver {
  /**
   * @param {!ProxyConfigClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ProxyConfigClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ProxyConfigClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyConfigClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ProxyConfigClient_OnProxyConfigUpdated_ParamsSpec.$,
        null,
        impl.onProxyConfigUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ProxyConfigClient_FlushProxyConfig_ParamsSpec.$,
        ProxyConfigClient_FlushProxyConfig_ResponseParamsSpec.$,
        impl.flushProxyConfig.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ProxyConfigClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ProxyConfigClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ProxyConfigClientRemote}
   */
  static getRemote() {
    let remote = new ProxyConfigClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ProxyConfigClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ProxyConfigClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ProxyConfigClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyConfigClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onProxyConfigUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ProxyConfigClient_OnProxyConfigUpdated_ParamsSpec.$,
        null,
        this.onProxyConfigUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flushProxyConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ProxyConfigClient_FlushProxyConfig_ParamsSpec.$,
        ProxyConfigClient_FlushProxyConfig_ResponseParamsSpec.$,
        this.flushProxyConfig.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ProxyConfigPollerClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.ProxyConfigPollerClient', scope);
  }
}

/** @interface */
export class ProxyConfigPollerClientInterface {
  
  /**
   */

  onLazyProxyConfigPoll() {}
}

/**
 * @implements { ProxyConfigPollerClientInterface }
 */
export class ProxyConfigPollerClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ProxyConfigPollerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ProxyConfigPollerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ProxyConfigPollerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onLazyProxyConfigPoll() {
    this.proxy.sendMessage(
        0,
        ProxyConfigPollerClient_OnLazyProxyConfigPoll_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ProxyConfigPollerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ProxyConfigPollerClientReceiver {
  /**
   * @param {!ProxyConfigPollerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ProxyConfigPollerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ProxyConfigPollerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyConfigPollerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ProxyConfigPollerClient_OnLazyProxyConfigPoll_ParamsSpec.$,
        null,
        impl.onLazyProxyConfigPoll.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ProxyConfigPollerClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ProxyConfigPollerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ProxyConfigPollerClientRemote}
   */
  static getRemote() {
    let remote = new ProxyConfigPollerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ProxyConfigPollerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ProxyConfigPollerClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ProxyConfigPollerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyConfigPollerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLazyProxyConfigPoll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ProxyConfigPollerClient_OnLazyProxyConfigPoll_ParamsSpec.$,
        null,
        this.onLazyProxyConfigPoll.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ProxyErrorClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.ProxyErrorClient', scope);
  }
}

/** @interface */
export class ProxyErrorClientInterface {
  
  /**
   * @param { !number } lineNumber
   * @param { !string } details
   */

  onPACScriptError(lineNumber, details) {}
  
  /**
   * @param { !number } netError
   */

  onRequestMaybeFailedDueToProxySettings(netError) {}
}

/**
 * @implements { ProxyErrorClientInterface }
 */
export class ProxyErrorClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ProxyErrorClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ProxyErrorClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ProxyErrorClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } lineNumber
   * @param { !string } details
   */

  onPACScriptError(
      lineNumber,
      details) {
    this.proxy.sendMessage(
        0,
        ProxyErrorClient_OnPACScriptError_ParamsSpec.$,
        null,
        [
          lineNumber,
          details
        ],
        false);
  }

  
  /**
   * @param { !number } netError
   */

  onRequestMaybeFailedDueToProxySettings(
      netError) {
    this.proxy.sendMessage(
        1,
        ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_ParamsSpec.$,
        null,
        [
          netError
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ProxyErrorClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ProxyErrorClientReceiver {
  /**
   * @param {!ProxyErrorClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ProxyErrorClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ProxyErrorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyErrorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ProxyErrorClient_OnPACScriptError_ParamsSpec.$,
        null,
        impl.onPACScriptError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_ParamsSpec.$,
        null,
        impl.onRequestMaybeFailedDueToProxySettings.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ProxyErrorClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ProxyErrorClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ProxyErrorClientRemote}
   */
  static getRemote() {
    let remote = new ProxyErrorClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ProxyErrorClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ProxyErrorClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ProxyErrorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyErrorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPACScriptError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ProxyErrorClient_OnPACScriptError_ParamsSpec.$,
        null,
        this.onPACScriptError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRequestMaybeFailedDueToProxySettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_ParamsSpec.$,
        null,
        this.onRequestMaybeFailedDueToProxySettings.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyConfigWithAnnotationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyConfigClient_OnProxyConfigUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyConfigClient_FlushProxyConfig_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyConfigClient_FlushProxyConfig_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyConfigPollerClient_OnLazyProxyConfigPoll_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyErrorClient_OnPACScriptError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ProxyConfigWithAnnotationSpec.$,
    'ProxyConfigWithAnnotation',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        network_mojom_ProxyConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 8,
        0,
        network_mojom_MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ProxyConfigWithAnnotation {
  constructor() {
    /** @type { !network_mojom_ProxyConfig } */
    this.value;
    /** @type { !network_mojom_MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
  }
}



mojo.internal.Struct(
    ProxyConfigClient_OnProxyConfigUpdated_ParamsSpec.$,
    'ProxyConfigClient_OnProxyConfigUpdated_Params',
    [
      mojo.internal.StructField(
        'proxyConfig', 0,
        0,
        ProxyConfigWithAnnotationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ProxyConfigClient_OnProxyConfigUpdated_Params {
  constructor() {
    /** @type { !ProxyConfigWithAnnotation } */
    this.proxyConfig;
  }
}



mojo.internal.Struct(
    ProxyConfigClient_FlushProxyConfig_ParamsSpec.$,
    'ProxyConfigClient_FlushProxyConfig_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ProxyConfigClient_FlushProxyConfig_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ProxyConfigClient_FlushProxyConfig_ResponseParamsSpec.$,
    'ProxyConfigClient_FlushProxyConfig_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ProxyConfigClient_FlushProxyConfig_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    ProxyConfigPollerClient_OnLazyProxyConfigPoll_ParamsSpec.$,
    'ProxyConfigPollerClient_OnLazyProxyConfigPoll_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ProxyConfigPollerClient_OnLazyProxyConfigPoll_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ProxyErrorClient_OnPACScriptError_ParamsSpec.$,
    'ProxyErrorClient_OnPACScriptError_Params',
    [
      mojo.internal.StructField(
        'lineNumber', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'details', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ProxyErrorClient_OnPACScriptError_Params {
  constructor() {
    /** @type { !number } */
    this.lineNumber;
    /** @type { !string } */
    this.details;
  }
}



mojo.internal.Struct(
    ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_ParamsSpec.$,
    'ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_Params',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_Params {
  constructor() {
    /** @type { !number } */
    this.netError;
  }
}

