// services/network/public/mojom/proxy_config_with_annotation.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.ProxyConfigClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.ProxyConfigClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.ProxyConfigClientInterface }
 */
network.mojom.ProxyConfigClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.ProxyConfigClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.ProxyConfigClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.ProxyConfigClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.ProxyConfigWithAnnotation } proxyConfig
   */

  onProxyConfigUpdated(
      proxyConfig) {
    this.proxy.sendMessage(
        0,
        network.mojom.ProxyConfigClient_OnProxyConfigUpdated_ParamsSpec.$,
        null,
        [
          proxyConfig
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  flushProxyConfig() {
    return this.proxy.sendMessage(
        1,
        network.mojom.ProxyConfigClient_FlushProxyConfig_ParamsSpec.$,
        network.mojom.ProxyConfigClient_FlushProxyConfig_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ProxyConfigClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.ProxyConfigClientReceiver = class {
  /**
   * @param {!network.mojom.ProxyConfigClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.ProxyConfigClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.ProxyConfigClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ProxyConfigClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.ProxyConfigClient_OnProxyConfigUpdated_ParamsSpec.$,
        null,
        impl.onProxyConfigUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.ProxyConfigClient_FlushProxyConfig_ParamsSpec.$,
        network.mojom.ProxyConfigClient_FlushProxyConfig_ResponseParamsSpec.$,
        impl.flushProxyConfig.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.ProxyConfigClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ProxyConfigClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.ProxyConfigClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.ProxyConfigClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ProxyConfigClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.ProxyConfigClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.ProxyConfigClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ProxyConfigClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onProxyConfigUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.ProxyConfigClient_OnProxyConfigUpdated_ParamsSpec.$,
        null,
        this.onProxyConfigUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flushProxyConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.ProxyConfigClient_FlushProxyConfig_ParamsSpec.$,
        network.mojom.ProxyConfigClient_FlushProxyConfig_ResponseParamsSpec.$,
        this.flushProxyConfig.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.ProxyConfigPollerClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.ProxyConfigPollerClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.ProxyConfigPollerClientInterface }
 */
network.mojom.ProxyConfigPollerClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.ProxyConfigPollerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.ProxyConfigPollerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.ProxyConfigPollerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onLazyProxyConfigPoll() {
    this.proxy.sendMessage(
        0,
        network.mojom.ProxyConfigPollerClient_OnLazyProxyConfigPoll_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ProxyConfigPollerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.ProxyConfigPollerClientReceiver = class {
  /**
   * @param {!network.mojom.ProxyConfigPollerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.ProxyConfigPollerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.ProxyConfigPollerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ProxyConfigPollerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.ProxyConfigPollerClient_OnLazyProxyConfigPoll_ParamsSpec.$,
        null,
        impl.onLazyProxyConfigPoll.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.ProxyConfigPollerClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ProxyConfigPollerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.ProxyConfigPollerClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.ProxyConfigPollerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ProxyConfigPollerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.ProxyConfigPollerClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.ProxyConfigPollerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ProxyConfigPollerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLazyProxyConfigPoll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.ProxyConfigPollerClient_OnLazyProxyConfigPoll_ParamsSpec.$,
        null,
        this.onLazyProxyConfigPoll.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.ProxyErrorClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.ProxyErrorClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.ProxyErrorClientInterface }
 */
network.mojom.ProxyErrorClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.ProxyErrorClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.ProxyErrorClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.ProxyErrorClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } lineNumber
   * @param { !string } details
   */

  onPACScriptError(
      lineNumber,
      details) {
    this.proxy.sendMessage(
        0,
        network.mojom.ProxyErrorClient_OnPACScriptError_ParamsSpec.$,
        null,
        [
          lineNumber,
          details
        ],
        false);
  }

  
  /**
   * @param { !number } netError
   */

  onRequestMaybeFailedDueToProxySettings(
      netError) {
    this.proxy.sendMessage(
        1,
        network.mojom.ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_ParamsSpec.$,
        null,
        [
          netError
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ProxyErrorClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.ProxyErrorClientReceiver = class {
  /**
   * @param {!network.mojom.ProxyErrorClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.ProxyErrorClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.ProxyErrorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ProxyErrorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.ProxyErrorClient_OnPACScriptError_ParamsSpec.$,
        null,
        impl.onPACScriptError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_ParamsSpec.$,
        null,
        impl.onRequestMaybeFailedDueToProxySettings.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.ProxyErrorClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ProxyErrorClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.ProxyErrorClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.ProxyErrorClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ProxyErrorClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.ProxyErrorClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.ProxyErrorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ProxyErrorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPACScriptError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.ProxyErrorClient_OnPACScriptError_ParamsSpec.$,
        null,
        this.onPACScriptError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRequestMaybeFailedDueToProxySettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_ParamsSpec.$,
        null,
        this.onRequestMaybeFailedDueToProxySettings.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ProxyConfigWithAnnotationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ProxyConfigClient_OnProxyConfigUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ProxyConfigClient_FlushProxyConfig_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ProxyConfigClient_FlushProxyConfig_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ProxyConfigPollerClient_OnLazyProxyConfigPoll_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ProxyErrorClient_OnPACScriptError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.ProxyConfigWithAnnotationSpec.$,
    'ProxyConfigWithAnnotation',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        network.mojom.ProxyConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 8,
        0,
        network.mojom.MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.ProxyConfigWithAnnotation = class {
  constructor() {
    /** @export { !network.mojom.ProxyConfig } */
    this.value;
    /** @export { !network.mojom.MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
  }
};



mojo.internal.Struct(
    network.mojom.ProxyConfigClient_OnProxyConfigUpdated_ParamsSpec.$,
    'ProxyConfigClient_OnProxyConfigUpdated_Params',
    [
      mojo.internal.StructField(
        'proxyConfig', 0,
        0,
        network.mojom.ProxyConfigWithAnnotationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.ProxyConfigClient_OnProxyConfigUpdated_Params = class {
  constructor() {
    /** @export { !network.mojom.ProxyConfigWithAnnotation } */
    this.proxyConfig;
  }
};



mojo.internal.Struct(
    network.mojom.ProxyConfigClient_FlushProxyConfig_ParamsSpec.$,
    'ProxyConfigClient_FlushProxyConfig_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.ProxyConfigClient_FlushProxyConfig_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.ProxyConfigClient_FlushProxyConfig_ResponseParamsSpec.$,
    'ProxyConfigClient_FlushProxyConfig_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.ProxyConfigClient_FlushProxyConfig_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.ProxyConfigPollerClient_OnLazyProxyConfigPoll_ParamsSpec.$,
    'ProxyConfigPollerClient_OnLazyProxyConfigPoll_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.ProxyConfigPollerClient_OnLazyProxyConfigPoll_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.ProxyErrorClient_OnPACScriptError_ParamsSpec.$,
    'ProxyErrorClient_OnPACScriptError_Params',
    [
      mojo.internal.StructField(
        'lineNumber', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'details', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.ProxyErrorClient_OnPACScriptError_Params = class {
  constructor() {
    /** @export { !number } */
    this.lineNumber;
    /** @export { !string } */
    this.details;
  }
};



mojo.internal.Struct(
    network.mojom.ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_ParamsSpec.$,
    'ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_Params',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_Params = class {
  constructor() {
    /** @export { !number } */
    this.netError;
  }
};

