// services/network/public/mojom/proxy_config.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/proxy_config.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var big_string$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/big_string.mojom', '../../../../mojo/public/mojom/base/big_string.mojom.js');
  }
  var network_param$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_param.mojom', 'network_param.mojom.js');
  }
  var scheme_host_port$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/scheme_host_port.mojom', '../../../../url/mojom/scheme_host_port.mojom.js');
  }


  var ProxyRulesType = {};
  ProxyRulesType.EMPTY = 0;
  ProxyRulesType.PROXY_LIST = 1;
  ProxyRulesType.PROXY_LIST_PER_SCHEME = 2;
  ProxyRulesType.MIN_VALUE = 0;
  ProxyRulesType.MAX_VALUE = 2;

  ProxyRulesType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  ProxyRulesType.toKnownEnumValue = function(value) {
    return value;
  };

  ProxyRulesType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ProxyOverrideRuleResult = {};
  ProxyOverrideRuleResult.kNotFound = 0;
  ProxyOverrideRuleResult.kResolved = 1;
  ProxyOverrideRuleResult.MIN_VALUE = 0;
  ProxyOverrideRuleResult.MAX_VALUE = 1;

  ProxyOverrideRuleResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  ProxyOverrideRuleResult.toKnownEnumValue = function(value) {
    return value;
  };

  ProxyOverrideRuleResult.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var IpProtectionProxyBypassPolicy = {};
  IpProtectionProxyBypassPolicy.kNone = 0;
  IpProtectionProxyBypassPolicy.kFirstPartyToTopLevelFrame = 1;
  IpProtectionProxyBypassPolicy.kExclusionList = 2;
  IpProtectionProxyBypassPolicy.MIN_VALUE = 0;
  IpProtectionProxyBypassPolicy.MAX_VALUE = 2;

  IpProtectionProxyBypassPolicy.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  IpProtectionProxyBypassPolicy.toKnownEnumValue = function(value) {
    return value;
  };

  IpProtectionProxyBypassPolicy.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function ProxyHostMatchingRules(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ProxyHostMatchingRules.prototype.initDefaults_ = function() {
    this.rules = null;
  };
  ProxyHostMatchingRules.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ProxyHostMatchingRules.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ProxyHostMatchingRules.rules
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ProxyHostMatchingRules.encodedSize = codec.kStructHeaderSize + 8;

  ProxyHostMatchingRules.decode = function(decoder) {
    var packed;
    var val = new ProxyHostMatchingRules();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.rules =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  ProxyHostMatchingRules.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ProxyHostMatchingRules.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.rules);
  };
  function ProxyList(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ProxyList.prototype.initDefaults_ = function() {
    this.proxies = null;
  };
  ProxyList.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ProxyList.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ProxyList.proxies
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(network_param$.ProxyChain), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ProxyList.encodedSize = codec.kStructHeaderSize + 8;

  ProxyList.decode = function(decoder) {
    var packed;
    var val = new ProxyList();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.proxies =
        decoder.decodeArrayPointer(new codec.PointerTo(network_param$.ProxyChain));
    return val;
  };

  ProxyList.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ProxyList.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(network_param$.ProxyChain), val.proxies);
  };
  function ProxyRules(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ProxyRules.prototype.initDefaults_ = function() {
    this.bypassRules = null;
    this.reverseBypass = false;
    this.type = 0;
    this.singleProxies = null;
    this.proxiesForHttp = null;
    this.proxiesForHttps = null;
    this.proxiesForFtp = null;
    this.fallbackProxies = null;
  };
  ProxyRules.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ProxyRules.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ProxyRules.bypassRules
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ProxyHostMatchingRules, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ProxyRules.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, ProxyRulesType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ProxyRules.singleProxies
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, ProxyList, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ProxyRules.proxiesForHttp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, ProxyList, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ProxyRules.proxiesForHttps
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, ProxyList, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ProxyRules.proxiesForFtp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, ProxyList, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ProxyRules.fallbackProxies
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, ProxyList, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ProxyRules.encodedSize = codec.kStructHeaderSize + 56;

  ProxyRules.decode = function(decoder) {
    var packed;
    var val = new ProxyRules();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bypassRules =
        decoder.decodeStructPointer(ProxyHostMatchingRules);
    packed = decoder.readUint8();
    val.reverseBypass = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.type =
        decoder.decodeStruct(new codec.Enum(ProxyRulesType));
    val.singleProxies =
        decoder.decodeStructPointer(ProxyList);
    val.proxiesForHttp =
        decoder.decodeStructPointer(ProxyList);
    val.proxiesForHttps =
        decoder.decodeStructPointer(ProxyList);
    val.proxiesForFtp =
        decoder.decodeStructPointer(ProxyList);
    val.fallbackProxies =
        decoder.decodeStructPointer(ProxyList);
    return val;
  };

  ProxyRules.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ProxyRules.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ProxyHostMatchingRules, val.bypassRules);
    packed = 0;
    packed |= (val.reverseBypass & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStructPointer(ProxyList, val.singleProxies);
    encoder.encodeStructPointer(ProxyList, val.proxiesForHttp);
    encoder.encodeStructPointer(ProxyList, val.proxiesForHttps);
    encoder.encodeStructPointer(ProxyList, val.proxiesForFtp);
    encoder.encodeStructPointer(ProxyList, val.fallbackProxies);
  };
  function DnsProbeCondition(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DnsProbeCondition.prototype.initDefaults_ = function() {
    this.host = null;
    this.result = 0;
  };
  DnsProbeCondition.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DnsProbeCondition.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DnsProbeCondition.host
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, scheme_host_port$.SchemeHostPort, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DnsProbeCondition.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, ProxyOverrideRuleResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DnsProbeCondition.encodedSize = codec.kStructHeaderSize + 16;

  DnsProbeCondition.decode = function(decoder) {
    var packed;
    var val = new DnsProbeCondition();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.host =
        decoder.decodeStructPointer(scheme_host_port$.SchemeHostPort);
    val.result =
        decoder.decodeStruct(new codec.Enum(ProxyOverrideRuleResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DnsProbeCondition.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DnsProbeCondition.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(scheme_host_port$.SchemeHostPort, val.host);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ProxyOverrideRule(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ProxyOverrideRule.prototype.initDefaults_ = function() {
    this.destinationMatchers = null;
    this.excludeDestinationMatchers = null;
    this.dnsConditions = null;
    this.proxyList = null;
  };
  ProxyOverrideRule.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ProxyOverrideRule.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ProxyOverrideRule.destinationMatchers
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ProxyHostMatchingRules, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ProxyOverrideRule.excludeDestinationMatchers
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ProxyHostMatchingRules, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ProxyOverrideRule.dnsConditions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(DnsProbeCondition), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ProxyOverrideRule.proxyList
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, ProxyList, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ProxyOverrideRule.encodedSize = codec.kStructHeaderSize + 32;

  ProxyOverrideRule.decode = function(decoder) {
    var packed;
    var val = new ProxyOverrideRule();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.destinationMatchers =
        decoder.decodeStructPointer(ProxyHostMatchingRules);
    val.excludeDestinationMatchers =
        decoder.decodeStructPointer(ProxyHostMatchingRules);
    val.dnsConditions =
        decoder.decodeArrayPointer(new codec.PointerTo(DnsProbeCondition));
    val.proxyList =
        decoder.decodeStructPointer(ProxyList);
    return val;
  };

  ProxyOverrideRule.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ProxyOverrideRule.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ProxyHostMatchingRules, val.destinationMatchers);
    encoder.encodeStructPointer(ProxyHostMatchingRules, val.excludeDestinationMatchers);
    encoder.encodeArrayPointer(new codec.PointerTo(DnsProbeCondition), val.dnsConditions);
    encoder.encodeStructPointer(ProxyList, val.proxyList);
  };
  function ProxyConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ProxyConfig.prototype.initDefaults_ = function() {
    this.proxyOverrideRules = null;
    this.autoDetect = false;
    this.fromSystem = false;
    this.pacMandatory = false;
    this.pacUrl = null;
    this.proxyRules = null;
  };
  ProxyConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ProxyConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ProxyConfig.proxyOverrideRules
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(ProxyOverrideRule), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;




    // validate ProxyConfig.pacUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, big_string$.BigString, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ProxyConfig.proxyRules
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, ProxyRules, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ProxyConfig.encodedSize = codec.kStructHeaderSize + 32;

  ProxyConfig.decode = function(decoder) {
    var packed;
    var val = new ProxyConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.proxyOverrideRules =
        decoder.decodeArrayPointer(new codec.PointerTo(ProxyOverrideRule));
    packed = decoder.readUint8();
    val.autoDetect = (packed >> 0) & 1 ? true : false;
    val.fromSystem = (packed >> 1) & 1 ? true : false;
    val.pacMandatory = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.pacUrl =
        decoder.decodeStructPointer(big_string$.BigString);
    val.proxyRules =
        decoder.decodeStructPointer(ProxyRules);
    return val;
  };

  ProxyConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ProxyConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(ProxyOverrideRule), val.proxyOverrideRules);
    packed = 0;
    packed |= (val.autoDetect & 1) << 0
    packed |= (val.fromSystem & 1) << 1
    packed |= (val.pacMandatory & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(big_string$.BigString, val.pacUrl);
    encoder.encodeStructPointer(ProxyRules, val.proxyRules);
  };
  exports.ProxyRulesType = ProxyRulesType;
  exports.ProxyOverrideRuleResult = ProxyOverrideRuleResult;
  exports.IpProtectionProxyBypassPolicy = IpProtectionProxyBypassPolicy;
  exports.ProxyHostMatchingRules = ProxyHostMatchingRules;
  exports.ProxyList = ProxyList;
  exports.ProxyRules = ProxyRules;
  exports.DnsProbeCondition = DnsProbeCondition;
  exports.ProxyOverrideRule = ProxyOverrideRule;
  exports.ProxyConfig = ProxyConfig;
})();