// services/network/public/mojom/proxy_config.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/proxy_config.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/proxy_config.mojom-params-data.h"
#include "services/network/public/mojom/proxy_config.mojom-shared-message-ids.h"

#include "services/network/public/mojom/proxy_config.mojom-import-headers.h"
#include "services/network/public/mojom/proxy_config.mojom-test-utils.h"
#include "net/cert/cert_verify_result.h"


namespace network::mojom {
ProxyHostMatchingRules::ProxyHostMatchingRules()
    : rules() {}

ProxyHostMatchingRules::ProxyHostMatchingRules(
    std::vector<std::string> rules_in)
    : rules(std::move(rules_in)) {}

ProxyHostMatchingRules::~ProxyHostMatchingRules() = default;

void ProxyHostMatchingRules::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rules"), this->rules,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyHostMatchingRules::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProxyList::ProxyList()
    : proxies() {}

ProxyList::ProxyList(
    std::vector<::net::ProxyChain> proxies_in)
    : proxies(std::move(proxies_in)) {}

ProxyList::~ProxyList() = default;

void ProxyList::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxies"), this->proxies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::net::ProxyChain>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyList::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProxyRules::ProxyRules()
    : bypass_rules(),
      reverse_bypass(),
      type(),
      single_proxies(),
      proxies_for_http(),
      proxies_for_https(),
      proxies_for_ftp(),
      fallback_proxies() {}

ProxyRules::ProxyRules(
    const ::net::ProxyHostMatchingRules& bypass_rules_in,
    bool reverse_bypass_in,
    ::net::ProxyConfig::ProxyRules::Type type_in,
    const ::net::ProxyList& single_proxies_in,
    const ::net::ProxyList& proxies_for_http_in,
    const ::net::ProxyList& proxies_for_https_in,
    const ::net::ProxyList& proxies_for_ftp_in,
    const ::net::ProxyList& fallback_proxies_in)
    : bypass_rules(std::move(bypass_rules_in)),
      reverse_bypass(std::move(reverse_bypass_in)),
      type(std::move(type_in)),
      single_proxies(std::move(single_proxies_in)),
      proxies_for_http(std::move(proxies_for_http_in)),
      proxies_for_https(std::move(proxies_for_https_in)),
      proxies_for_ftp(std::move(proxies_for_ftp_in)),
      fallback_proxies(std::move(fallback_proxies_in)) {}

ProxyRules::~ProxyRules() = default;

void ProxyRules::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bypass_rules"), this->bypass_rules,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ProxyHostMatchingRules&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reverse_bypass"), this->reverse_bypass,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::ProxyConfig::ProxyRules::Type>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "single_proxies"), this->single_proxies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ProxyList&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxies_for_http"), this->proxies_for_http,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ProxyList&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxies_for_https"), this->proxies_for_https,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ProxyList&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxies_for_ftp"), this->proxies_for_ftp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ProxyList&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fallback_proxies"), this->fallback_proxies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ProxyList&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyRules::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DnsProbeCondition::DnsProbeCondition()
    : host(),
      result() {}

DnsProbeCondition::DnsProbeCondition(
    const ::url::SchemeHostPort& host_in,
    ProxyOverrideRuleResult result_in)
    : host(std::move(host_in)),
      result(std::move(result_in)) {}

DnsProbeCondition::~DnsProbeCondition() = default;

void DnsProbeCondition::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host"), this->host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::SchemeHostPort&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "result"), this->result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProxyOverrideRuleResult>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DnsProbeCondition::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProxyOverrideRule::ProxyOverrideRule()
    : destination_matchers(),
      exclude_destination_matchers(),
      dns_conditions(),
      proxy_list() {}

ProxyOverrideRule::ProxyOverrideRule(
    const ::net::ProxyHostMatchingRules& destination_matchers_in,
    const ::net::ProxyHostMatchingRules& exclude_destination_matchers_in,
    std::vector<DnsProbeConditionPtr> dns_conditions_in,
    const ::net::ProxyList& proxy_list_in)
    : destination_matchers(std::move(destination_matchers_in)),
      exclude_destination_matchers(std::move(exclude_destination_matchers_in)),
      dns_conditions(std::move(dns_conditions_in)),
      proxy_list(std::move(proxy_list_in)) {}

ProxyOverrideRule::~ProxyOverrideRule() = default;

void ProxyOverrideRule::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "destination_matchers"), this->destination_matchers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ProxyHostMatchingRules&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exclude_destination_matchers"), this->exclude_destination_matchers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ProxyHostMatchingRules&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dns_conditions"), this->dns_conditions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<DnsProbeConditionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxy_list"), this->proxy_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ProxyList&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyOverrideRule::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProxyConfig::ProxyConfig()
    : proxy_override_rules(),
      auto_detect(),
      from_system(),
      pac_url(),
      pac_mandatory(),
      proxy_rules() {}

ProxyConfig::ProxyConfig(
    std::vector<ProxyOverrideRulePtr> proxy_override_rules_in,
    bool auto_detect_in,
    bool from_system_in,
    const ::std::string& pac_url_in,
    bool pac_mandatory_in,
    const ::net::ProxyConfig::ProxyRules& proxy_rules_in)
    : proxy_override_rules(std::move(proxy_override_rules_in)),
      auto_detect(std::move(auto_detect_in)),
      from_system(std::move(from_system_in)),
      pac_url(std::move(pac_url_in)),
      pac_mandatory(std::move(pac_mandatory_in)),
      proxy_rules(std::move(proxy_rules_in)) {}

ProxyConfig::~ProxyConfig() = default;

void ProxyConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxy_override_rules"), this->proxy_override_rules,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ProxyOverrideRulePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auto_detect"), this->auto_detect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "from_system"), this->from_system,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pac_url"), this->pac_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pac_mandatory"), this->pac_mandatory,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxy_rules"), this->proxy_rules,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ProxyConfig::ProxyRules&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::ProxyHostMatchingRules::DataView, ::network::mojom::ProxyHostMatchingRulesPtr>::Read(
    ::network::mojom::ProxyHostMatchingRules::DataView input,
    ::network::mojom::ProxyHostMatchingRulesPtr* output) {
  bool success = true;
  ::network::mojom::ProxyHostMatchingRulesPtr result(::network::mojom::ProxyHostMatchingRules::New());
  
      if (success && !input.ReadRules(&result->rules))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::ProxyList::DataView, ::network::mojom::ProxyListPtr>::Read(
    ::network::mojom::ProxyList::DataView input,
    ::network::mojom::ProxyListPtr* output) {
  bool success = true;
  ::network::mojom::ProxyListPtr result(::network::mojom::ProxyList::New());
  
      if (success && !input.ReadProxies(&result->proxies))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::ProxyRules::DataView, ::network::mojom::ProxyRulesPtr>::Read(
    ::network::mojom::ProxyRules::DataView input,
    ::network::mojom::ProxyRulesPtr* output) {
  bool success = true;
  ::network::mojom::ProxyRulesPtr result(::network::mojom::ProxyRules::New());
  
      if (success && !input.ReadBypassRules(&result->bypass_rules))
        success = false;
      if (success)
        result->reverse_bypass = input.reverse_bypass();
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadSingleProxies(&result->single_proxies))
        success = false;
      if (success && !input.ReadProxiesForHttp(&result->proxies_for_http))
        success = false;
      if (success && !input.ReadProxiesForHttps(&result->proxies_for_https))
        success = false;
      if (success && !input.ReadProxiesForFtp(&result->proxies_for_ftp))
        success = false;
      if (success && !input.ReadFallbackProxies(&result->fallback_proxies))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::DnsProbeCondition::DataView, ::network::mojom::DnsProbeConditionPtr>::Read(
    ::network::mojom::DnsProbeCondition::DataView input,
    ::network::mojom::DnsProbeConditionPtr* output) {
  bool success = true;
  ::network::mojom::DnsProbeConditionPtr result(::network::mojom::DnsProbeCondition::New());
  
      if (success && !input.ReadHost(&result->host))
        success = false;
      if (success && !input.ReadResult(&result->result))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::ProxyOverrideRule::DataView, ::network::mojom::ProxyOverrideRulePtr>::Read(
    ::network::mojom::ProxyOverrideRule::DataView input,
    ::network::mojom::ProxyOverrideRulePtr* output) {
  bool success = true;
  ::network::mojom::ProxyOverrideRulePtr result(::network::mojom::ProxyOverrideRule::New());
  
      if (success && !input.ReadDestinationMatchers(&result->destination_matchers))
        success = false;
      if (success && !input.ReadExcludeDestinationMatchers(&result->exclude_destination_matchers))
        success = false;
      if (success && !input.ReadDnsConditions(&result->dns_conditions))
        success = false;
      if (success && !input.ReadProxyList(&result->proxy_list))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::ProxyConfig::DataView, ::network::mojom::ProxyConfigPtr>::Read(
    ::network::mojom::ProxyConfig::DataView input,
    ::network::mojom::ProxyConfigPtr* output) {
  bool success = true;
  ::network::mojom::ProxyConfigPtr result(::network::mojom::ProxyConfig::New());
  
      if (success && !input.ReadProxyOverrideRules(&result->proxy_override_rules))
        success = false;
      if (success)
        result->auto_detect = input.auto_detect();
      if (success)
        result->from_system = input.from_system();
      if (success && !input.ReadPacUrl(&result->pac_url))
        success = false;
      if (success)
        result->pac_mandatory = input.pac_mandatory();
      if (success && !input.ReadProxyRules(&result->proxy_rules))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {




}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif