// services/network/public/mojom/proxy_config.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/proxy_config.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_string.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "url/mojom/scheme_host_port.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/proxy_config.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::ProxyRulesType>
    : public mojo::internal::EnumHashImpl<::network::mojom::ProxyRulesType> {};

template <>
struct hash<::network::mojom::ProxyOverrideRuleResult>
    : public mojo::internal::EnumHashImpl<::network::mojom::ProxyOverrideRuleResult> {};

template <>
struct hash<::network::mojom::IpProtectionProxyBypassPolicy>
    : public mojo::internal::EnumHashImpl<::network::mojom::IpProtectionProxyBypassPolicy> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ProxyRulesType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ProxyRulesType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ProxyRulesType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ProxyOverrideRuleResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ProxyOverrideRuleResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ProxyOverrideRuleResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::IpProtectionProxyBypassPolicy, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::IpProtectionProxyBypassPolicy, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::IpProtectionProxyBypassPolicy>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ProxyHostMatchingRulesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ProxyHostMatchingRulesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ProxyHostMatchingRules_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::rules(input)) in_rules = Traits::rules(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rules)::BaseType>
        rules_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& rules_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_rules,
      rules_fragment,
      &rules_validate_params);

    fragment->rules.Set(
        rules_fragment.is_null() ? nullptr : rules_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->rules.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rules in ProxyHostMatchingRules struct");
  }

  static bool Deserialize(::network::mojom::internal::ProxyHostMatchingRules_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ProxyHostMatchingRulesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ProxyListDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ProxyListDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ProxyList_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::proxies(input)) in_proxies = Traits::proxies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->proxies)::BaseType>
        proxies_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& proxies_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ProxyChainDataView>>(
      in_proxies,
      proxies_fragment,
      &proxies_validate_params);

    fragment->proxies.Set(
        proxies_fragment.is_null() ? nullptr : proxies_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->proxies.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null proxies in ProxyList struct");
  }

  static bool Deserialize(::network::mojom::internal::ProxyList_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ProxyListDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ProxyRulesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ProxyRulesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ProxyRules_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::bypass_rules(input)) in_bypass_rules = Traits::bypass_rules(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bypass_rules)::BaseType> bypass_rules_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ProxyHostMatchingRulesDataView>(
      in_bypass_rules,
      bypass_rules_fragment);

    fragment->bypass_rules.Set(
        bypass_rules_fragment.is_null() ? nullptr : bypass_rules_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bypass_rules.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bypass_rules in ProxyRules struct");

    fragment->reverse_bypass = Traits::reverse_bypass(input);

    
    mojo::internal::Serialize<::network::mojom::ProxyRulesType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::single_proxies(input)) in_single_proxies = Traits::single_proxies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->single_proxies)::BaseType> single_proxies_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ProxyListDataView>(
      in_single_proxies,
      single_proxies_fragment);

    fragment->single_proxies.Set(
        single_proxies_fragment.is_null() ? nullptr : single_proxies_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->single_proxies.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null single_proxies in ProxyRules struct");

    decltype(Traits::proxies_for_http(input)) in_proxies_for_http = Traits::proxies_for_http(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->proxies_for_http)::BaseType> proxies_for_http_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ProxyListDataView>(
      in_proxies_for_http,
      proxies_for_http_fragment);

    fragment->proxies_for_http.Set(
        proxies_for_http_fragment.is_null() ? nullptr : proxies_for_http_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->proxies_for_http.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null proxies_for_http in ProxyRules struct");

    decltype(Traits::proxies_for_https(input)) in_proxies_for_https = Traits::proxies_for_https(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->proxies_for_https)::BaseType> proxies_for_https_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ProxyListDataView>(
      in_proxies_for_https,
      proxies_for_https_fragment);

    fragment->proxies_for_https.Set(
        proxies_for_https_fragment.is_null() ? nullptr : proxies_for_https_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->proxies_for_https.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null proxies_for_https in ProxyRules struct");

    decltype(Traits::proxies_for_ftp(input)) in_proxies_for_ftp = Traits::proxies_for_ftp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->proxies_for_ftp)::BaseType> proxies_for_ftp_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ProxyListDataView>(
      in_proxies_for_ftp,
      proxies_for_ftp_fragment);

    fragment->proxies_for_ftp.Set(
        proxies_for_ftp_fragment.is_null() ? nullptr : proxies_for_ftp_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->proxies_for_ftp.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null proxies_for_ftp in ProxyRules struct");

    decltype(Traits::fallback_proxies(input)) in_fallback_proxies = Traits::fallback_proxies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fallback_proxies)::BaseType> fallback_proxies_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ProxyListDataView>(
      in_fallback_proxies,
      fallback_proxies_fragment);

    fragment->fallback_proxies.Set(
        fallback_proxies_fragment.is_null() ? nullptr : fallback_proxies_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->fallback_proxies.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null fallback_proxies in ProxyRules struct");
  }

  static bool Deserialize(::network::mojom::internal::ProxyRules_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ProxyRulesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DnsProbeConditionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DnsProbeConditionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DnsProbeCondition_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::host(input)) in_host = Traits::host(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->host)::BaseType> host_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::SchemeHostPortDataView>(
      in_host,
      host_fragment);

    fragment->host.Set(
        host_fragment.is_null() ? nullptr : host_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->host.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in DnsProbeCondition struct");

    
    mojo::internal::Serialize<::network::mojom::ProxyOverrideRuleResult>(
      Traits::result(input),
      &fragment->result);
  }

  static bool Deserialize(::network::mojom::internal::DnsProbeCondition_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DnsProbeConditionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ProxyOverrideRuleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ProxyOverrideRuleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ProxyOverrideRule_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::destination_matchers(input)) in_destination_matchers = Traits::destination_matchers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->destination_matchers)::BaseType> destination_matchers_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ProxyHostMatchingRulesDataView>(
      in_destination_matchers,
      destination_matchers_fragment);

    fragment->destination_matchers.Set(
        destination_matchers_fragment.is_null() ? nullptr : destination_matchers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->destination_matchers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null destination_matchers in ProxyOverrideRule struct");

    decltype(Traits::exclude_destination_matchers(input)) in_exclude_destination_matchers = Traits::exclude_destination_matchers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->exclude_destination_matchers)::BaseType> exclude_destination_matchers_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ProxyHostMatchingRulesDataView>(
      in_exclude_destination_matchers,
      exclude_destination_matchers_fragment);

    fragment->exclude_destination_matchers.Set(
        exclude_destination_matchers_fragment.is_null() ? nullptr : exclude_destination_matchers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->exclude_destination_matchers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null exclude_destination_matchers in ProxyOverrideRule struct");

    decltype(Traits::dns_conditions(input)) in_dns_conditions = Traits::dns_conditions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dns_conditions)::BaseType>
        dns_conditions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& dns_conditions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::DnsProbeConditionDataView>>(
      in_dns_conditions,
      dns_conditions_fragment,
      &dns_conditions_validate_params);

    fragment->dns_conditions.Set(
        dns_conditions_fragment.is_null() ? nullptr : dns_conditions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->dns_conditions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dns_conditions in ProxyOverrideRule struct");

    decltype(Traits::proxy_list(input)) in_proxy_list = Traits::proxy_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->proxy_list)::BaseType> proxy_list_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ProxyListDataView>(
      in_proxy_list,
      proxy_list_fragment);

    fragment->proxy_list.Set(
        proxy_list_fragment.is_null() ? nullptr : proxy_list_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->proxy_list.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null proxy_list in ProxyOverrideRule struct");
  }

  static bool Deserialize(::network::mojom::internal::ProxyOverrideRule_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ProxyOverrideRuleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ProxyConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ProxyConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ProxyConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::proxy_override_rules(input)) in_proxy_override_rules = Traits::proxy_override_rules(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->proxy_override_rules)::BaseType>
        proxy_override_rules_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& proxy_override_rules_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ProxyOverrideRuleDataView>>(
      in_proxy_override_rules,
      proxy_override_rules_fragment,
      &proxy_override_rules_validate_params);

    fragment->proxy_override_rules.Set(
        proxy_override_rules_fragment.is_null() ? nullptr : proxy_override_rules_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->proxy_override_rules.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null proxy_override_rules in ProxyConfig struct");

    fragment->auto_detect = Traits::auto_detect(input);

    fragment->from_system = Traits::from_system(input);

    decltype(Traits::pac_url(input)) in_pac_url = Traits::pac_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pac_url)::BaseType> pac_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::BigStringDataView>(
      in_pac_url,
      pac_url_fragment);

    fragment->pac_url.Set(
        pac_url_fragment.is_null() ? nullptr : pac_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pac_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pac_url in ProxyConfig struct");

    fragment->pac_mandatory = Traits::pac_mandatory(input);

    decltype(Traits::proxy_rules(input)) in_proxy_rules = Traits::proxy_rules(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->proxy_rules)::BaseType> proxy_rules_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ProxyRulesDataView>(
      in_proxy_rules,
      proxy_rules_fragment);

    fragment->proxy_rules.Set(
        proxy_rules_fragment.is_null() ? nullptr : proxy_rules_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->proxy_rules.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null proxy_rules in ProxyConfig struct");
  }

  static bool Deserialize(::network::mojom::internal::ProxyConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ProxyConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void ProxyHostMatchingRulesDataView::GetRulesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->rules.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void ProxyListDataView::GetProxiesDataView(
    mojo::ArrayDataView<::network::mojom::ProxyChainDataView>* output) {
  auto pointer = data_->proxies.Get();
  *output = mojo::ArrayDataView<::network::mojom::ProxyChainDataView>(pointer, message_);
}


inline void ProxyRulesDataView::GetBypassRulesDataView(
    ProxyHostMatchingRulesDataView* output) {
  auto pointer = data_->bypass_rules.Get();
  *output = ProxyHostMatchingRulesDataView(pointer, message_);
}
inline void ProxyRulesDataView::GetSingleProxiesDataView(
    ProxyListDataView* output) {
  auto pointer = data_->single_proxies.Get();
  *output = ProxyListDataView(pointer, message_);
}
inline void ProxyRulesDataView::GetProxiesForHttpDataView(
    ProxyListDataView* output) {
  auto pointer = data_->proxies_for_http.Get();
  *output = ProxyListDataView(pointer, message_);
}
inline void ProxyRulesDataView::GetProxiesForHttpsDataView(
    ProxyListDataView* output) {
  auto pointer = data_->proxies_for_https.Get();
  *output = ProxyListDataView(pointer, message_);
}
inline void ProxyRulesDataView::GetProxiesForFtpDataView(
    ProxyListDataView* output) {
  auto pointer = data_->proxies_for_ftp.Get();
  *output = ProxyListDataView(pointer, message_);
}
inline void ProxyRulesDataView::GetFallbackProxiesDataView(
    ProxyListDataView* output) {
  auto pointer = data_->fallback_proxies.Get();
  *output = ProxyListDataView(pointer, message_);
}


inline void DnsProbeConditionDataView::GetHostDataView(
    ::url::mojom::SchemeHostPortDataView* output) {
  auto pointer = data_->host.Get();
  *output = ::url::mojom::SchemeHostPortDataView(pointer, message_);
}


inline void ProxyOverrideRuleDataView::GetDestinationMatchersDataView(
    ProxyHostMatchingRulesDataView* output) {
  auto pointer = data_->destination_matchers.Get();
  *output = ProxyHostMatchingRulesDataView(pointer, message_);
}
inline void ProxyOverrideRuleDataView::GetExcludeDestinationMatchersDataView(
    ProxyHostMatchingRulesDataView* output) {
  auto pointer = data_->exclude_destination_matchers.Get();
  *output = ProxyHostMatchingRulesDataView(pointer, message_);
}
inline void ProxyOverrideRuleDataView::GetDnsConditionsDataView(
    mojo::ArrayDataView<DnsProbeConditionDataView>* output) {
  auto pointer = data_->dns_conditions.Get();
  *output = mojo::ArrayDataView<DnsProbeConditionDataView>(pointer, message_);
}
inline void ProxyOverrideRuleDataView::GetProxyListDataView(
    ProxyListDataView* output) {
  auto pointer = data_->proxy_list.Get();
  *output = ProxyListDataView(pointer, message_);
}


inline void ProxyConfigDataView::GetProxyOverrideRulesDataView(
    mojo::ArrayDataView<ProxyOverrideRuleDataView>* output) {
  auto pointer = data_->proxy_override_rules.Get();
  *output = mojo::ArrayDataView<ProxyOverrideRuleDataView>(pointer, message_);
}
inline void ProxyConfigDataView::GetPacUrlDataView(
    ::mojo_base::mojom::BigStringDataView* output) {
  auto pointer = data_->pac_url.Get();
  *output = ::mojo_base::mojom::BigStringDataView(pointer, message_);
}
inline void ProxyConfigDataView::GetProxyRulesDataView(
    ProxyRulesDataView* output) {
  auto pointer = data_->proxy_rules.Get();
  *output = ProxyRulesDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ProxyRulesType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ProxyRulesType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ProxyOverrideRuleResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ProxyOverrideRuleResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::IpProtectionProxyBypassPolicy> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::IpProtectionProxyBypassPolicy value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_SHARED_H_