// services/network/public/mojom/proxy_config.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/proxy_config.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/proxy_config.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* ProxyRulesTypeToStringHelper(ProxyRulesType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ProxyRulesType::EMPTY:
      return "EMPTY";
    case ProxyRulesType::PROXY_LIST:
      return "PROXY_LIST";
    case ProxyRulesType::PROXY_LIST_PER_SCHEME:
      return "PROXY_LIST_PER_SCHEME";
    default:
      return nullptr;
  }
}

std::string ProxyRulesTypeToString(ProxyRulesType value) {
  const char *str = ProxyRulesTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ProxyRulesType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ProxyRulesType value) {
  return os << ProxyRulesTypeToString(value);
}

NOINLINE static const char* ProxyOverrideRuleResultToStringHelper(ProxyOverrideRuleResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ProxyOverrideRuleResult::kNotFound:
      return "kNotFound";
    case ProxyOverrideRuleResult::kResolved:
      return "kResolved";
    default:
      return nullptr;
  }
}

std::string ProxyOverrideRuleResultToString(ProxyOverrideRuleResult value) {
  const char *str = ProxyOverrideRuleResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ProxyOverrideRuleResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ProxyOverrideRuleResult value) {
  return os << ProxyOverrideRuleResultToString(value);
}

NOINLINE static const char* IpProtectionProxyBypassPolicyToStringHelper(IpProtectionProxyBypassPolicy value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IpProtectionProxyBypassPolicy::kNone:
      return "kNone";
    case IpProtectionProxyBypassPolicy::kFirstPartyToTopLevelFrame:
      return "kFirstPartyToTopLevelFrame";
    case IpProtectionProxyBypassPolicy::kExclusionList:
      return "kExclusionList";
    default:
      return nullptr;
  }
}

std::string IpProtectionProxyBypassPolicyToString(IpProtectionProxyBypassPolicy value) {
  const char *str = IpProtectionProxyBypassPolicyToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IpProtectionProxyBypassPolicy value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IpProtectionProxyBypassPolicy value) {
  return os << IpProtectionProxyBypassPolicyToString(value);
}

namespace internal {


// static
bool ProxyHostMatchingRules_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProxyHostMatchingRules_Data* object =
      static_cast<const ProxyHostMatchingRules_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rules, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& rules_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->rules, validation_context,
                                         &rules_validate_params)) {
    return false;
  }

  return true;
}

ProxyHostMatchingRules_Data::ProxyHostMatchingRules_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProxyList_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProxyList_Data* object =
      static_cast<const ProxyList_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->proxies, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& proxies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->proxies, validation_context,
                                         &proxies_validate_params)) {
    return false;
  }

  return true;
}

ProxyList_Data::ProxyList_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProxyRules_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProxyRules_Data* object =
      static_cast<const ProxyRules_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bypass_rules, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bypass_rules, validation_context))
    return false;


  if (!::network::mojom::internal::ProxyRulesType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->single_proxies, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->single_proxies, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->proxies_for_http, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->proxies_for_http, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->proxies_for_https, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->proxies_for_https, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->proxies_for_ftp, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->proxies_for_ftp, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fallback_proxies, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->fallback_proxies, validation_context))
    return false;

  return true;
}

ProxyRules_Data::ProxyRules_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DnsProbeCondition_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DnsProbeCondition_Data* object =
      static_cast<const DnsProbeCondition_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->host, validation_context))
    return false;


  if (!::network::mojom::internal::ProxyOverrideRuleResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

DnsProbeCondition_Data::DnsProbeCondition_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProxyOverrideRule_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProxyOverrideRule_Data* object =
      static_cast<const ProxyOverrideRule_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->destination_matchers, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->destination_matchers, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->exclude_destination_matchers, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->exclude_destination_matchers, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dns_conditions, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& dns_conditions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->dns_conditions, validation_context,
                                         &dns_conditions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->proxy_list, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->proxy_list, validation_context))
    return false;

  return true;
}

ProxyOverrideRule_Data::ProxyOverrideRule_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProxyConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProxyConfig_Data* object =
      static_cast<const ProxyConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->proxy_override_rules, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& proxy_override_rules_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->proxy_override_rules, validation_context,
                                         &proxy_override_rules_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pac_url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pac_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->proxy_rules, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->proxy_rules, validation_context))
    return false;

  return true;
}

ProxyConfig_Data::ProxyConfig_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ProxyRulesType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::ProxyRulesType value) {
  return std::move(context).WriteString(::network::mojom::ProxyRulesTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ProxyOverrideRuleResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::ProxyOverrideRuleResult value) {
  return std::move(context).WriteString(::network::mojom::ProxyOverrideRuleResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::IpProtectionProxyBypassPolicy>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::IpProtectionProxyBypassPolicy value) {
  return std::move(context).WriteString(::network::mojom::IpProtectionProxyBypassPolicyToString(value));
}

} // namespace perfetto