// services/network/public/mojom/proxy_config.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/proxy_config.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/proxy_config.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/proxy_config.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_string.mojom-blink.h"
#include "services/network/public/mojom/network_param.mojom-blink.h"
#include "url/mojom/scheme_host_port.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {













class  ProxyHostMatchingRules {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProxyHostMatchingRules, T>::value>;
  using DataView = ProxyHostMatchingRulesDataView;
  using Data_ = internal::ProxyHostMatchingRules_Data;

  template <typename... Args>
  static ProxyHostMatchingRulesPtr New(Args&&... args) {
    return ProxyHostMatchingRulesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProxyHostMatchingRulesPtr From(const U& u) {
    return mojo::TypeConverter<ProxyHostMatchingRulesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProxyHostMatchingRules>::Convert(*this);
  }


  ProxyHostMatchingRules();

  explicit ProxyHostMatchingRules(
      ::blink::Vector<::blink::String> rules);


  ~ProxyHostMatchingRules();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProxyHostMatchingRulesPtr>
  ProxyHostMatchingRulesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProxyHostMatchingRules::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProxyHostMatchingRules::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProxyHostMatchingRules::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyHostMatchingRules::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyHostMatchingRules::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProxyHostMatchingRules::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProxyHostMatchingRules_UnserializedMessageContext<
            UserType, ProxyHostMatchingRules::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProxyHostMatchingRules::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProxyHostMatchingRules::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProxyHostMatchingRules_UnserializedMessageContext<
            UserType, ProxyHostMatchingRules::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProxyHostMatchingRules::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::blink::String> rules;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProxyHostMatchingRules::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProxyHostMatchingRules::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProxyHostMatchingRules::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProxyHostMatchingRules::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ProxyList {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProxyList, T>::value>;
  using DataView = ProxyListDataView;
  using Data_ = internal::ProxyList_Data;

  template <typename... Args>
  static ProxyListPtr New(Args&&... args) {
    return ProxyListPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProxyListPtr From(const U& u) {
    return mojo::TypeConverter<ProxyListPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProxyList>::Convert(*this);
  }


  ProxyList();

  explicit ProxyList(
      ::blink::Vector<::net::ProxyChain> proxies);


  ~ProxyList();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProxyListPtr>
  ProxyListPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProxyList::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProxyList::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProxyList::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyList::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyList::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProxyList::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProxyList_UnserializedMessageContext<
            UserType, ProxyList::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProxyList::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProxyList::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProxyList_UnserializedMessageContext<
            UserType, ProxyList::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProxyList::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::net::ProxyChain> proxies;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProxyList::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProxyList::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProxyList::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProxyList::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ProxyRules {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProxyRules, T>::value>;
  using DataView = ProxyRulesDataView;
  using Data_ = internal::ProxyRules_Data;

  template <typename... Args>
  static ProxyRulesPtr New(Args&&... args) {
    return ProxyRulesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProxyRulesPtr From(const U& u) {
    return mojo::TypeConverter<ProxyRulesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProxyRules>::Convert(*this);
  }


  ProxyRules();

  ProxyRules(
      ProxyHostMatchingRulesPtr bypass_rules,
      bool reverse_bypass,
      ProxyRulesType type,
      ProxyListPtr single_proxies,
      ProxyListPtr proxies_for_http,
      ProxyListPtr proxies_for_https,
      ProxyListPtr proxies_for_ftp,
      ProxyListPtr fallback_proxies);

ProxyRules(const ProxyRules&) = delete;
ProxyRules& operator=(const ProxyRules&) = delete;

  ~ProxyRules();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProxyRulesPtr>
  ProxyRulesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProxyRules::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProxyRules::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProxyRules::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyRules::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyRules::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProxyRules::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProxyRules_UnserializedMessageContext<
            UserType, ProxyRules::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProxyRules::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProxyRules::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProxyRules_UnserializedMessageContext<
            UserType, ProxyRules::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProxyRules::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ProxyHostMatchingRulesPtr bypass_rules;
  
  bool reverse_bypass;
  
  ProxyRulesType type;
  
  ProxyListPtr single_proxies;
  
  ProxyListPtr proxies_for_http;
  
  ProxyListPtr proxies_for_https;
  
  ProxyListPtr proxies_for_ftp;
  
  ProxyListPtr fallback_proxies;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProxyRules::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProxyRules::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProxyRules::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProxyRules::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DnsProbeCondition {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DnsProbeCondition, T>::value>;
  using DataView = DnsProbeConditionDataView;
  using Data_ = internal::DnsProbeCondition_Data;

  template <typename... Args>
  static DnsProbeConditionPtr New(Args&&... args) {
    return DnsProbeConditionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DnsProbeConditionPtr From(const U& u) {
    return mojo::TypeConverter<DnsProbeConditionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DnsProbeCondition>::Convert(*this);
  }


  DnsProbeCondition();

  DnsProbeCondition(
      const ::url::SchemeHostPort& host,
      ProxyOverrideRuleResult result);


  ~DnsProbeCondition();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DnsProbeConditionPtr>
  DnsProbeConditionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DnsProbeCondition::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DnsProbeCondition::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DnsProbeCondition::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DnsProbeCondition::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DnsProbeCondition::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DnsProbeCondition::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DnsProbeCondition_UnserializedMessageContext<
            UserType, DnsProbeCondition::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DnsProbeCondition::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DnsProbeCondition::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DnsProbeCondition_UnserializedMessageContext<
            UserType, DnsProbeCondition::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DnsProbeCondition::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::SchemeHostPort host;
  
  ProxyOverrideRuleResult result;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DnsProbeCondition::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DnsProbeCondition::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DnsProbeCondition::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DnsProbeCondition::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ProxyOverrideRule {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProxyOverrideRule, T>::value>;
  using DataView = ProxyOverrideRuleDataView;
  using Data_ = internal::ProxyOverrideRule_Data;

  template <typename... Args>
  static ProxyOverrideRulePtr New(Args&&... args) {
    return ProxyOverrideRulePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProxyOverrideRulePtr From(const U& u) {
    return mojo::TypeConverter<ProxyOverrideRulePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProxyOverrideRule>::Convert(*this);
  }


  ProxyOverrideRule();

  ProxyOverrideRule(
      ProxyHostMatchingRulesPtr destination_matchers,
      ProxyHostMatchingRulesPtr exclude_destination_matchers,
      ::blink::Vector<DnsProbeConditionPtr> dns_conditions,
      ProxyListPtr proxy_list);

ProxyOverrideRule(const ProxyOverrideRule&) = delete;
ProxyOverrideRule& operator=(const ProxyOverrideRule&) = delete;

  ~ProxyOverrideRule();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProxyOverrideRulePtr>
  ProxyOverrideRulePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProxyOverrideRule::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProxyOverrideRule::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProxyOverrideRule::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyOverrideRule::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyOverrideRule::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProxyOverrideRule::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProxyOverrideRule_UnserializedMessageContext<
            UserType, ProxyOverrideRule::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProxyOverrideRule::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProxyOverrideRule::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProxyOverrideRule_UnserializedMessageContext<
            UserType, ProxyOverrideRule::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProxyOverrideRule::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ProxyHostMatchingRulesPtr destination_matchers;
  
  ProxyHostMatchingRulesPtr exclude_destination_matchers;
  
  ::blink::Vector<DnsProbeConditionPtr> dns_conditions;
  
  ProxyListPtr proxy_list;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProxyOverrideRule::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProxyOverrideRule::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProxyOverrideRule::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProxyOverrideRule::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ProxyConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProxyConfig, T>::value>;
  using DataView = ProxyConfigDataView;
  using Data_ = internal::ProxyConfig_Data;

  template <typename... Args>
  static ProxyConfigPtr New(Args&&... args) {
    return ProxyConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProxyConfigPtr From(const U& u) {
    return mojo::TypeConverter<ProxyConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProxyConfig>::Convert(*this);
  }


  ProxyConfig();

  ProxyConfig(
      ::blink::Vector<ProxyOverrideRulePtr> proxy_override_rules,
      bool auto_detect,
      bool from_system,
      const ::blink::String& pac_url,
      bool pac_mandatory,
      ProxyRulesPtr proxy_rules);

ProxyConfig(const ProxyConfig&) = delete;
ProxyConfig& operator=(const ProxyConfig&) = delete;

  ~ProxyConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProxyConfigPtr>
  ProxyConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProxyConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProxyConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProxyConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProxyConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProxyConfig_UnserializedMessageContext<
            UserType, ProxyConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProxyConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProxyConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProxyConfig_UnserializedMessageContext<
            UserType, ProxyConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProxyConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<ProxyOverrideRulePtr> proxy_override_rules;
  
  bool auto_detect;
  
  bool from_system;
  
  ::blink::String pac_url;
  
  bool pac_mandatory;
  
  ProxyRulesPtr proxy_rules;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProxyConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProxyConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProxyConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProxyConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ProxyHostMatchingRulesPtr ProxyHostMatchingRules::Clone() const {
  return New(
      mojo::Clone(rules)
  );
}

template <typename T, ProxyHostMatchingRules::EnableIfSame<T>*>
bool ProxyHostMatchingRules::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->rules, other_struct.rules))
    return false;
  return true;
}

template <typename T, ProxyHostMatchingRules::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.rules < rhs.rules)
    return true;
  if (rhs.rules < lhs.rules)
    return false;
  return false;
}
template <typename StructPtrType>
ProxyListPtr ProxyList::Clone() const {
  return New(
      mojo::Clone(proxies)
  );
}

template <typename T, ProxyList::EnableIfSame<T>*>
bool ProxyList::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->proxies, other_struct.proxies))
    return false;
  return true;
}

template <typename T, ProxyList::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.proxies < rhs.proxies)
    return true;
  if (rhs.proxies < lhs.proxies)
    return false;
  return false;
}
template <typename StructPtrType>
ProxyRulesPtr ProxyRules::Clone() const {
  return New(
      mojo::Clone(bypass_rules),
      mojo::Clone(reverse_bypass),
      mojo::Clone(type),
      mojo::Clone(single_proxies),
      mojo::Clone(proxies_for_http),
      mojo::Clone(proxies_for_https),
      mojo::Clone(proxies_for_ftp),
      mojo::Clone(fallback_proxies)
  );
}

template <typename T, ProxyRules::EnableIfSame<T>*>
bool ProxyRules::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bypass_rules, other_struct.bypass_rules))
    return false;
  if (!mojo::Equals(this->reverse_bypass, other_struct.reverse_bypass))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->single_proxies, other_struct.single_proxies))
    return false;
  if (!mojo::Equals(this->proxies_for_http, other_struct.proxies_for_http))
    return false;
  if (!mojo::Equals(this->proxies_for_https, other_struct.proxies_for_https))
    return false;
  if (!mojo::Equals(this->proxies_for_ftp, other_struct.proxies_for_ftp))
    return false;
  if (!mojo::Equals(this->fallback_proxies, other_struct.fallback_proxies))
    return false;
  return true;
}

template <typename T, ProxyRules::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bypass_rules < rhs.bypass_rules)
    return true;
  if (rhs.bypass_rules < lhs.bypass_rules)
    return false;
  if (lhs.reverse_bypass < rhs.reverse_bypass)
    return true;
  if (rhs.reverse_bypass < lhs.reverse_bypass)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.single_proxies < rhs.single_proxies)
    return true;
  if (rhs.single_proxies < lhs.single_proxies)
    return false;
  if (lhs.proxies_for_http < rhs.proxies_for_http)
    return true;
  if (rhs.proxies_for_http < lhs.proxies_for_http)
    return false;
  if (lhs.proxies_for_https < rhs.proxies_for_https)
    return true;
  if (rhs.proxies_for_https < lhs.proxies_for_https)
    return false;
  if (lhs.proxies_for_ftp < rhs.proxies_for_ftp)
    return true;
  if (rhs.proxies_for_ftp < lhs.proxies_for_ftp)
    return false;
  if (lhs.fallback_proxies < rhs.fallback_proxies)
    return true;
  if (rhs.fallback_proxies < lhs.fallback_proxies)
    return false;
  return false;
}
template <typename StructPtrType>
DnsProbeConditionPtr DnsProbeCondition::Clone() const {
  return New(
      mojo::Clone(host),
      mojo::Clone(result)
  );
}

template <typename T, DnsProbeCondition::EnableIfSame<T>*>
bool DnsProbeCondition::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->host, other_struct.host))
    return false;
  if (!mojo::Equals(this->result, other_struct.result))
    return false;
  return true;
}

template <typename T, DnsProbeCondition::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.host < rhs.host)
    return true;
  if (rhs.host < lhs.host)
    return false;
  if (lhs.result < rhs.result)
    return true;
  if (rhs.result < lhs.result)
    return false;
  return false;
}
template <typename StructPtrType>
ProxyOverrideRulePtr ProxyOverrideRule::Clone() const {
  return New(
      mojo::Clone(destination_matchers),
      mojo::Clone(exclude_destination_matchers),
      mojo::Clone(dns_conditions),
      mojo::Clone(proxy_list)
  );
}

template <typename T, ProxyOverrideRule::EnableIfSame<T>*>
bool ProxyOverrideRule::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->destination_matchers, other_struct.destination_matchers))
    return false;
  if (!mojo::Equals(this->exclude_destination_matchers, other_struct.exclude_destination_matchers))
    return false;
  if (!mojo::Equals(this->dns_conditions, other_struct.dns_conditions))
    return false;
  if (!mojo::Equals(this->proxy_list, other_struct.proxy_list))
    return false;
  return true;
}

template <typename T, ProxyOverrideRule::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.destination_matchers < rhs.destination_matchers)
    return true;
  if (rhs.destination_matchers < lhs.destination_matchers)
    return false;
  if (lhs.exclude_destination_matchers < rhs.exclude_destination_matchers)
    return true;
  if (rhs.exclude_destination_matchers < lhs.exclude_destination_matchers)
    return false;
  if (lhs.dns_conditions < rhs.dns_conditions)
    return true;
  if (rhs.dns_conditions < lhs.dns_conditions)
    return false;
  if (lhs.proxy_list < rhs.proxy_list)
    return true;
  if (rhs.proxy_list < lhs.proxy_list)
    return false;
  return false;
}
template <typename StructPtrType>
ProxyConfigPtr ProxyConfig::Clone() const {
  return New(
      mojo::Clone(proxy_override_rules),
      mojo::Clone(auto_detect),
      mojo::Clone(from_system),
      mojo::Clone(pac_url),
      mojo::Clone(pac_mandatory),
      mojo::Clone(proxy_rules)
  );
}

template <typename T, ProxyConfig::EnableIfSame<T>*>
bool ProxyConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->proxy_override_rules, other_struct.proxy_override_rules))
    return false;
  if (!mojo::Equals(this->auto_detect, other_struct.auto_detect))
    return false;
  if (!mojo::Equals(this->from_system, other_struct.from_system))
    return false;
  if (!mojo::Equals(this->pac_url, other_struct.pac_url))
    return false;
  if (!mojo::Equals(this->pac_mandatory, other_struct.pac_mandatory))
    return false;
  if (!mojo::Equals(this->proxy_rules, other_struct.proxy_rules))
    return false;
  return true;
}

template <typename T, ProxyConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.proxy_override_rules < rhs.proxy_override_rules)
    return true;
  if (rhs.proxy_override_rules < lhs.proxy_override_rules)
    return false;
  if (lhs.auto_detect < rhs.auto_detect)
    return true;
  if (rhs.auto_detect < lhs.auto_detect)
    return false;
  if (lhs.from_system < rhs.from_system)
    return true;
  if (rhs.from_system < lhs.from_system)
    return false;
  if (lhs.pac_url < rhs.pac_url)
    return true;
  if (rhs.pac_url < lhs.pac_url)
    return false;
  if (lhs.pac_mandatory < rhs.pac_mandatory)
    return true;
  if (rhs.pac_mandatory < lhs.pac_mandatory)
    return false;
  if (lhs.proxy_rules < rhs.proxy_rules)
    return true;
  if (rhs.proxy_rules < lhs.proxy_rules)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::network::mojom::blink::ProxyHostMatchingRules::DataView,
                                         ::network::mojom::blink::ProxyHostMatchingRulesPtr> {
  static bool IsNull(const ::network::mojom::blink::ProxyHostMatchingRulesPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ProxyHostMatchingRulesPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::ProxyHostMatchingRules::rules)& rules(
      const ::network::mojom::blink::ProxyHostMatchingRulesPtr& input) {
    return input->rules;
  }

  static bool Read(::network::mojom::blink::ProxyHostMatchingRules::DataView input, ::network::mojom::blink::ProxyHostMatchingRulesPtr* output);
};


template <>
struct  StructTraits<::network::mojom::blink::ProxyList::DataView,
                                         ::network::mojom::blink::ProxyListPtr> {
  static bool IsNull(const ::network::mojom::blink::ProxyListPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ProxyListPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::ProxyList::proxies)& proxies(
      const ::network::mojom::blink::ProxyListPtr& input) {
    return input->proxies;
  }

  static bool Read(::network::mojom::blink::ProxyList::DataView input, ::network::mojom::blink::ProxyListPtr* output);
};


template <>
struct  StructTraits<::network::mojom::blink::ProxyRules::DataView,
                                         ::network::mojom::blink::ProxyRulesPtr> {
  static bool IsNull(const ::network::mojom::blink::ProxyRulesPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ProxyRulesPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::ProxyRules::bypass_rules)& bypass_rules(
      const ::network::mojom::blink::ProxyRulesPtr& input) {
    return input->bypass_rules;
  }

  static decltype(::network::mojom::blink::ProxyRules::reverse_bypass) reverse_bypass(
      const ::network::mojom::blink::ProxyRulesPtr& input) {
    return input->reverse_bypass;
  }

  static decltype(::network::mojom::blink::ProxyRules::type) type(
      const ::network::mojom::blink::ProxyRulesPtr& input) {
    return input->type;
  }

  static const decltype(::network::mojom::blink::ProxyRules::single_proxies)& single_proxies(
      const ::network::mojom::blink::ProxyRulesPtr& input) {
    return input->single_proxies;
  }

  static const decltype(::network::mojom::blink::ProxyRules::proxies_for_http)& proxies_for_http(
      const ::network::mojom::blink::ProxyRulesPtr& input) {
    return input->proxies_for_http;
  }

  static const decltype(::network::mojom::blink::ProxyRules::proxies_for_https)& proxies_for_https(
      const ::network::mojom::blink::ProxyRulesPtr& input) {
    return input->proxies_for_https;
  }

  static const decltype(::network::mojom::blink::ProxyRules::proxies_for_ftp)& proxies_for_ftp(
      const ::network::mojom::blink::ProxyRulesPtr& input) {
    return input->proxies_for_ftp;
  }

  static const decltype(::network::mojom::blink::ProxyRules::fallback_proxies)& fallback_proxies(
      const ::network::mojom::blink::ProxyRulesPtr& input) {
    return input->fallback_proxies;
  }

  static bool Read(::network::mojom::blink::ProxyRules::DataView input, ::network::mojom::blink::ProxyRulesPtr* output);
};


template <>
struct  StructTraits<::network::mojom::blink::DnsProbeCondition::DataView,
                                         ::network::mojom::blink::DnsProbeConditionPtr> {
  static bool IsNull(const ::network::mojom::blink::DnsProbeConditionPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::DnsProbeConditionPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::DnsProbeCondition::host)& host(
      const ::network::mojom::blink::DnsProbeConditionPtr& input) {
    return input->host;
  }

  static decltype(::network::mojom::blink::DnsProbeCondition::result) result(
      const ::network::mojom::blink::DnsProbeConditionPtr& input) {
    return input->result;
  }

  static bool Read(::network::mojom::blink::DnsProbeCondition::DataView input, ::network::mojom::blink::DnsProbeConditionPtr* output);
};


template <>
struct  StructTraits<::network::mojom::blink::ProxyOverrideRule::DataView,
                                         ::network::mojom::blink::ProxyOverrideRulePtr> {
  static bool IsNull(const ::network::mojom::blink::ProxyOverrideRulePtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ProxyOverrideRulePtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::ProxyOverrideRule::destination_matchers)& destination_matchers(
      const ::network::mojom::blink::ProxyOverrideRulePtr& input) {
    return input->destination_matchers;
  }

  static const decltype(::network::mojom::blink::ProxyOverrideRule::exclude_destination_matchers)& exclude_destination_matchers(
      const ::network::mojom::blink::ProxyOverrideRulePtr& input) {
    return input->exclude_destination_matchers;
  }

  static const decltype(::network::mojom::blink::ProxyOverrideRule::dns_conditions)& dns_conditions(
      const ::network::mojom::blink::ProxyOverrideRulePtr& input) {
    return input->dns_conditions;
  }

  static const decltype(::network::mojom::blink::ProxyOverrideRule::proxy_list)& proxy_list(
      const ::network::mojom::blink::ProxyOverrideRulePtr& input) {
    return input->proxy_list;
  }

  static bool Read(::network::mojom::blink::ProxyOverrideRule::DataView input, ::network::mojom::blink::ProxyOverrideRulePtr* output);
};


template <>
struct  StructTraits<::network::mojom::blink::ProxyConfig::DataView,
                                         ::network::mojom::blink::ProxyConfigPtr> {
  static bool IsNull(const ::network::mojom::blink::ProxyConfigPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ProxyConfigPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::ProxyConfig::proxy_override_rules)& proxy_override_rules(
      const ::network::mojom::blink::ProxyConfigPtr& input) {
    return input->proxy_override_rules;
  }

  static decltype(::network::mojom::blink::ProxyConfig::auto_detect) auto_detect(
      const ::network::mojom::blink::ProxyConfigPtr& input) {
    return input->auto_detect;
  }

  static decltype(::network::mojom::blink::ProxyConfig::from_system) from_system(
      const ::network::mojom::blink::ProxyConfigPtr& input) {
    return input->from_system;
  }

  static  decltype(::network::mojom::blink::ProxyConfig::pac_url)& pac_url(
       ::network::mojom::blink::ProxyConfigPtr& input) {
    return input->pac_url;
  }

  static decltype(::network::mojom::blink::ProxyConfig::pac_mandatory) pac_mandatory(
      const ::network::mojom::blink::ProxyConfigPtr& input) {
    return input->pac_mandatory;
  }

  static const decltype(::network::mojom::blink::ProxyConfig::proxy_rules)& proxy_rules(
      const ::network::mojom::blink::ProxyConfigPtr& input) {
    return input->proxy_rules;
  }

  static bool Read(::network::mojom::blink::ProxyConfig::DataView input, ::network::mojom::blink::ProxyConfigPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_BLINK_H_