// services/network/public/mojom/permissions_policy/permissions_policy.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PERMISSIONS_POLICY_PERMISSIONS_POLICY_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PERMISSIONS_POLICY_PERMISSIONS_POLICY_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared-internal.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy_feature.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"

#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::OriginWithPossibleWildcardsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::OriginWithPossibleWildcardsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::OriginWithPossibleWildcards_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::scheme(input)) in_scheme = Traits::scheme(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scheme)::BaseType> scheme_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_scheme,
        scheme_fragment);

      fragment->scheme.Set(
          scheme_fragment.is_null() ? nullptr : scheme_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scheme.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scheme in OriginWithPossibleWildcards struct");

      decltype(Traits::host(input)) in_host = Traits::host(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->host)::BaseType> host_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_host,
        host_fragment);

      fragment->host.Set(
          host_fragment.is_null() ? nullptr : host_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->host.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host in OriginWithPossibleWildcards struct");

      fragment->port = Traits::port(input);

      fragment->is_host_wildcard = Traits::is_host_wildcard(input);

      fragment->is_port_wildcard = Traits::is_port_wildcard(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::ParsedPermissionsPolicyDeclarationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ParsedPermissionsPolicyDeclarationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ParsedPermissionsPolicyDeclaration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::PermissionsPolicyFeature>(
        Traits::feature(input),
        &fragment->feature);

      decltype(Traits::allowed_origins(input)) in_allowed_origins = Traits::allowed_origins(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->allowed_origins)::BaseType>
          allowed_origins_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& allowed_origins_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::OriginWithPossibleWildcardsDataView>, send_validation>(
        in_allowed_origins,
        allowed_origins_fragment,
        &allowed_origins_validate_params);

      fragment->allowed_origins.Set(
          allowed_origins_fragment.is_null() ? nullptr : allowed_origins_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->allowed_origins.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null allowed_origins in ParsedPermissionsPolicyDeclaration struct");

      decltype(Traits::self_if_matches(input)) in_self_if_matches = Traits::self_if_matches(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->self_if_matches)::BaseType> self_if_matches_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_self_if_matches,
        self_if_matches_fragment);

      fragment->self_if_matches.Set(
          self_if_matches_fragment.is_null() ? nullptr : self_if_matches_fragment.data());

      fragment->matches_all_origins = Traits::matches_all_origins(input);

      fragment->matches_opaque_src = Traits::matches_opaque_src(input);

      decltype(Traits::reporting_endpoint(input)) in_reporting_endpoint = Traits::reporting_endpoint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reporting_endpoint)::BaseType> reporting_endpoint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_reporting_endpoint,
        reporting_endpoint_fragment);

      fragment->reporting_endpoint.Set(
          reporting_endpoint_fragment.is_null() ? nullptr : reporting_endpoint_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::PermissionsPolicyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::PermissionsPolicyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::PermissionsPolicy_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::origin(input)) in_origin = Traits::origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin)::BaseType> origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_origin,
        origin_fragment);

      fragment->origin.Set(
          origin_fragment.is_null() ? nullptr : origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in PermissionsPolicy struct");

      fragment->headerless = Traits::headerless(input);

      decltype(Traits::declarations(input)) in_declarations = Traits::declarations(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->declarations)::BaseType>
          declarations_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& declarations_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>, send_validation>(
        in_declarations,
        declarations_fragment,
        &declarations_validate_params);

      fragment->declarations.Set(
          declarations_fragment.is_null() ? nullptr : declarations_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->declarations.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null declarations in PermissionsPolicy struct");

      decltype(Traits::inherited_policies(input)) in_inherited_policies = Traits::inherited_policies(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->inherited_policies)::BaseType> inherited_policies_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_inherited_policies,
        inherited_policies_fragment);

      fragment->inherited_policies.Set(
          inherited_policies_fragment.is_null() ? nullptr : inherited_policies_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->inherited_policies.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null inherited_policies in PermissionsPolicy struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PERMISSIONS_POLICY_PERMISSIONS_POLICY_MOJOM_SEND_VALIDATION_H_