// services/network/public/mojom/permissions_policy/permissions_policy.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PERMISSIONS_POLICY_PERMISSIONS_POLICY_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PERMISSIONS_POLICY_PERMISSIONS_POLICY_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/permissions_policy/permissions_policy_feature.mojom-blink-forward.h"
#include "url/mojom/origin.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "services/network/public/cpp/permissions_policy/permissions_policy_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {










class BLINK_PLATFORM_EXPORT OriginWithPossibleWildcards {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OriginWithPossibleWildcards, T>::value>;
  using DataView = OriginWithPossibleWildcardsDataView;
  using Data_ = internal::OriginWithPossibleWildcards_Data;

  template <typename... Args>
  static OriginWithPossibleWildcardsPtr New(Args&&... args) {
    return OriginWithPossibleWildcardsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OriginWithPossibleWildcardsPtr From(const U& u) {
    return mojo::TypeConverter<OriginWithPossibleWildcardsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OriginWithPossibleWildcards>::Convert(*this);
  }


  OriginWithPossibleWildcards();

  OriginWithPossibleWildcards(
      const ::blink::String& scheme,
      const ::blink::String& host,
      int32_t port,
      bool is_host_wildcard,
      bool is_port_wildcard);


  ~OriginWithPossibleWildcards();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OriginWithPossibleWildcardsPtr>
  OriginWithPossibleWildcardsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OriginWithPossibleWildcards::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OriginWithPossibleWildcards::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OriginWithPossibleWildcards::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OriginWithPossibleWildcards::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OriginWithPossibleWildcards::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OriginWithPossibleWildcards::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OriginWithPossibleWildcards_UnserializedMessageContext<
            UserType, OriginWithPossibleWildcards::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OriginWithPossibleWildcards::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OriginWithPossibleWildcards::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OriginWithPossibleWildcards_UnserializedMessageContext<
            UserType, OriginWithPossibleWildcards::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OriginWithPossibleWildcards::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String scheme;
  
  ::blink::String host;
  
  int32_t port;
  
  bool is_host_wildcard;
  
  bool is_port_wildcard;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OriginWithPossibleWildcards::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OriginWithPossibleWildcards::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OriginWithPossibleWildcards::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OriginWithPossibleWildcards::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT ParsedPermissionsPolicyDeclaration {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ParsedPermissionsPolicyDeclaration, T>::value>;
  using DataView = ParsedPermissionsPolicyDeclarationDataView;
  using Data_ = internal::ParsedPermissionsPolicyDeclaration_Data;

  template <typename... Args>
  static ParsedPermissionsPolicyDeclarationPtr New(Args&&... args) {
    return ParsedPermissionsPolicyDeclarationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ParsedPermissionsPolicyDeclarationPtr From(const U& u) {
    return mojo::TypeConverter<ParsedPermissionsPolicyDeclarationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ParsedPermissionsPolicyDeclaration>::Convert(*this);
  }


  ParsedPermissionsPolicyDeclaration();

  ParsedPermissionsPolicyDeclaration(
      ::network::mojom::blink::PermissionsPolicyFeature feature,
      ::blink::Vector<::network::OriginWithPossibleWildcards> allowed_origins,
      const ::scoped_refptr<const ::blink::SecurityOrigin>& self_if_matches,
      bool matches_all_origins,
      bool matches_opaque_src,
      const ::blink::String& reporting_endpoint);


  ~ParsedPermissionsPolicyDeclaration();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ParsedPermissionsPolicyDeclarationPtr>
  ParsedPermissionsPolicyDeclarationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ParsedPermissionsPolicyDeclaration::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ParsedPermissionsPolicyDeclaration::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ParsedPermissionsPolicyDeclaration::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ParsedPermissionsPolicyDeclaration::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ParsedPermissionsPolicyDeclaration::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ParsedPermissionsPolicyDeclaration::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ParsedPermissionsPolicyDeclaration_UnserializedMessageContext<
            UserType, ParsedPermissionsPolicyDeclaration::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ParsedPermissionsPolicyDeclaration::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ParsedPermissionsPolicyDeclaration::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ParsedPermissionsPolicyDeclaration_UnserializedMessageContext<
            UserType, ParsedPermissionsPolicyDeclaration::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ParsedPermissionsPolicyDeclaration::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::network::mojom::blink::PermissionsPolicyFeature feature;
  
  ::blink::Vector<::network::OriginWithPossibleWildcards> allowed_origins;
  
  ::scoped_refptr<const ::blink::SecurityOrigin> self_if_matches;
  
  bool matches_all_origins;
  
  bool matches_opaque_src;
  
  ::blink::String reporting_endpoint;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ParsedPermissionsPolicyDeclaration::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ParsedPermissionsPolicyDeclaration::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ParsedPermissionsPolicyDeclaration::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ParsedPermissionsPolicyDeclaration::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT PermissionsPolicy {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PermissionsPolicy, T>::value>;
  using DataView = PermissionsPolicyDataView;
  using Data_ = internal::PermissionsPolicy_Data;

  template <typename... Args>
  static PermissionsPolicyPtr New(Args&&... args) {
    return PermissionsPolicyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PermissionsPolicyPtr From(const U& u) {
    return mojo::TypeConverter<PermissionsPolicyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PermissionsPolicy>::Convert(*this);
  }


  PermissionsPolicy();

  PermissionsPolicy(
      const ::scoped_refptr<const ::blink::SecurityOrigin>& origin,
      bool headerless,
      ::blink::Vector<::network::ParsedPermissionsPolicyDeclaration> declarations,
      const ::blink::String& inherited_policies);


  ~PermissionsPolicy();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PermissionsPolicyPtr>
  PermissionsPolicyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PermissionsPolicy::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PermissionsPolicy::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PermissionsPolicy::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PermissionsPolicy::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PermissionsPolicy::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PermissionsPolicy::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PermissionsPolicy_UnserializedMessageContext<
            UserType, PermissionsPolicy::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PermissionsPolicy::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PermissionsPolicy::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PermissionsPolicy_UnserializedMessageContext<
            UserType, PermissionsPolicy::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PermissionsPolicy::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::scoped_refptr<const ::blink::SecurityOrigin> origin;
  
  bool headerless;
  
  ::blink::Vector<::network::ParsedPermissionsPolicyDeclaration> declarations;
  
  ::blink::String inherited_policies;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PermissionsPolicy::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PermissionsPolicy::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PermissionsPolicy::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PermissionsPolicy::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
OriginWithPossibleWildcardsPtr OriginWithPossibleWildcards::Clone() const {
  return New(
      mojo::Clone(scheme),
      mojo::Clone(host),
      mojo::Clone(port),
      mojo::Clone(is_host_wildcard),
      mojo::Clone(is_port_wildcard)
  );
}

template <typename T, OriginWithPossibleWildcards::EnableIfSame<T>*>
bool OriginWithPossibleWildcards::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scheme, other_struct.scheme))
    return false;
  if (!mojo::Equals(this->host, other_struct.host))
    return false;
  if (!mojo::Equals(this->port, other_struct.port))
    return false;
  if (!mojo::Equals(this->is_host_wildcard, other_struct.is_host_wildcard))
    return false;
  if (!mojo::Equals(this->is_port_wildcard, other_struct.is_port_wildcard))
    return false;
  return true;
}

template <typename T, OriginWithPossibleWildcards::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scheme < rhs.scheme)
    return true;
  if (rhs.scheme < lhs.scheme)
    return false;
  if (lhs.host < rhs.host)
    return true;
  if (rhs.host < lhs.host)
    return false;
  if (lhs.port < rhs.port)
    return true;
  if (rhs.port < lhs.port)
    return false;
  if (lhs.is_host_wildcard < rhs.is_host_wildcard)
    return true;
  if (rhs.is_host_wildcard < lhs.is_host_wildcard)
    return false;
  if (lhs.is_port_wildcard < rhs.is_port_wildcard)
    return true;
  if (rhs.is_port_wildcard < lhs.is_port_wildcard)
    return false;
  return false;
}
template <typename StructPtrType>
ParsedPermissionsPolicyDeclarationPtr ParsedPermissionsPolicyDeclaration::Clone() const {
  return New(
      mojo::Clone(feature),
      mojo::Clone(allowed_origins),
      mojo::Clone(self_if_matches),
      mojo::Clone(matches_all_origins),
      mojo::Clone(matches_opaque_src),
      mojo::Clone(reporting_endpoint)
  );
}

template <typename T, ParsedPermissionsPolicyDeclaration::EnableIfSame<T>*>
bool ParsedPermissionsPolicyDeclaration::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->feature, other_struct.feature))
    return false;
  if (!mojo::Equals(this->allowed_origins, other_struct.allowed_origins))
    return false;
  if (!mojo::Equals(this->self_if_matches, other_struct.self_if_matches))
    return false;
  if (!mojo::Equals(this->matches_all_origins, other_struct.matches_all_origins))
    return false;
  if (!mojo::Equals(this->matches_opaque_src, other_struct.matches_opaque_src))
    return false;
  if (!mojo::Equals(this->reporting_endpoint, other_struct.reporting_endpoint))
    return false;
  return true;
}

template <typename T, ParsedPermissionsPolicyDeclaration::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.feature < rhs.feature)
    return true;
  if (rhs.feature < lhs.feature)
    return false;
  if (lhs.allowed_origins < rhs.allowed_origins)
    return true;
  if (rhs.allowed_origins < lhs.allowed_origins)
    return false;
  if (lhs.self_if_matches < rhs.self_if_matches)
    return true;
  if (rhs.self_if_matches < lhs.self_if_matches)
    return false;
  if (lhs.matches_all_origins < rhs.matches_all_origins)
    return true;
  if (rhs.matches_all_origins < lhs.matches_all_origins)
    return false;
  if (lhs.matches_opaque_src < rhs.matches_opaque_src)
    return true;
  if (rhs.matches_opaque_src < lhs.matches_opaque_src)
    return false;
  if (lhs.reporting_endpoint < rhs.reporting_endpoint)
    return true;
  if (rhs.reporting_endpoint < lhs.reporting_endpoint)
    return false;
  return false;
}
template <typename StructPtrType>
PermissionsPolicyPtr PermissionsPolicy::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(headerless),
      mojo::Clone(declarations),
      mojo::Clone(inherited_policies)
  );
}

template <typename T, PermissionsPolicy::EnableIfSame<T>*>
bool PermissionsPolicy::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->headerless, other_struct.headerless))
    return false;
  if (!mojo::Equals(this->declarations, other_struct.declarations))
    return false;
  if (!mojo::Equals(this->inherited_policies, other_struct.inherited_policies))
    return false;
  return true;
}

template <typename T, PermissionsPolicy::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.headerless < rhs.headerless)
    return true;
  if (rhs.headerless < lhs.headerless)
    return false;
  if (lhs.declarations < rhs.declarations)
    return true;
  if (rhs.declarations < lhs.declarations)
    return false;
  if (lhs.inherited_policies < rhs.inherited_policies)
    return true;
  if (rhs.inherited_policies < lhs.inherited_policies)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::OriginWithPossibleWildcards::DataView,
                                         ::network::mojom::blink::OriginWithPossibleWildcardsPtr> {
  static bool IsNull(const ::network::mojom::blink::OriginWithPossibleWildcardsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::OriginWithPossibleWildcardsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::OriginWithPossibleWildcards::scheme)& scheme(
      const ::network::mojom::blink::OriginWithPossibleWildcardsPtr& input) {
    return input->scheme;
  }

  static const decltype(::network::mojom::blink::OriginWithPossibleWildcards::host)& host(
      const ::network::mojom::blink::OriginWithPossibleWildcardsPtr& input) {
    return input->host;
  }

  static decltype(::network::mojom::blink::OriginWithPossibleWildcards::port) port(
      const ::network::mojom::blink::OriginWithPossibleWildcardsPtr& input) {
    return input->port;
  }

  static decltype(::network::mojom::blink::OriginWithPossibleWildcards::is_host_wildcard) is_host_wildcard(
      const ::network::mojom::blink::OriginWithPossibleWildcardsPtr& input) {
    return input->is_host_wildcard;
  }

  static decltype(::network::mojom::blink::OriginWithPossibleWildcards::is_port_wildcard) is_port_wildcard(
      const ::network::mojom::blink::OriginWithPossibleWildcardsPtr& input) {
    return input->is_port_wildcard;
  }

  static bool Read(::network::mojom::blink::OriginWithPossibleWildcards::DataView input, ::network::mojom::blink::OriginWithPossibleWildcardsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::ParsedPermissionsPolicyDeclaration::DataView,
                                         ::network::mojom::blink::ParsedPermissionsPolicyDeclarationPtr> {
  static bool IsNull(const ::network::mojom::blink::ParsedPermissionsPolicyDeclarationPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ParsedPermissionsPolicyDeclarationPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::ParsedPermissionsPolicyDeclaration::feature) feature(
      const ::network::mojom::blink::ParsedPermissionsPolicyDeclarationPtr& input) {
    return input->feature;
  }

  static const decltype(::network::mojom::blink::ParsedPermissionsPolicyDeclaration::allowed_origins)& allowed_origins(
      const ::network::mojom::blink::ParsedPermissionsPolicyDeclarationPtr& input) {
    return input->allowed_origins;
  }

  static const decltype(::network::mojom::blink::ParsedPermissionsPolicyDeclaration::self_if_matches)& self_if_matches(
      const ::network::mojom::blink::ParsedPermissionsPolicyDeclarationPtr& input) {
    return input->self_if_matches;
  }

  static decltype(::network::mojom::blink::ParsedPermissionsPolicyDeclaration::matches_all_origins) matches_all_origins(
      const ::network::mojom::blink::ParsedPermissionsPolicyDeclarationPtr& input) {
    return input->matches_all_origins;
  }

  static decltype(::network::mojom::blink::ParsedPermissionsPolicyDeclaration::matches_opaque_src) matches_opaque_src(
      const ::network::mojom::blink::ParsedPermissionsPolicyDeclarationPtr& input) {
    return input->matches_opaque_src;
  }

  static const decltype(::network::mojom::blink::ParsedPermissionsPolicyDeclaration::reporting_endpoint)& reporting_endpoint(
      const ::network::mojom::blink::ParsedPermissionsPolicyDeclarationPtr& input) {
    return input->reporting_endpoint;
  }

  static bool Read(::network::mojom::blink::ParsedPermissionsPolicyDeclaration::DataView input, ::network::mojom::blink::ParsedPermissionsPolicyDeclarationPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::PermissionsPolicy::DataView,
                                         ::network::mojom::blink::PermissionsPolicyPtr> {
  static bool IsNull(const ::network::mojom::blink::PermissionsPolicyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::PermissionsPolicyPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::PermissionsPolicy::origin)& origin(
      const ::network::mojom::blink::PermissionsPolicyPtr& input) {
    return input->origin;
  }

  static decltype(::network::mojom::blink::PermissionsPolicy::headerless) headerless(
      const ::network::mojom::blink::PermissionsPolicyPtr& input) {
    return input->headerless;
  }

  static const decltype(::network::mojom::blink::PermissionsPolicy::declarations)& declarations(
      const ::network::mojom::blink::PermissionsPolicyPtr& input) {
    return input->declarations;
  }

  static const decltype(::network::mojom::blink::PermissionsPolicy::inherited_policies)& inherited_policies(
      const ::network::mojom::blink::PermissionsPolicyPtr& input) {
    return input->inherited_policies;
  }

  static bool Read(::network::mojom::blink::PermissionsPolicy::DataView input, ::network::mojom::blink::PermissionsPolicyPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PERMISSIONS_POLICY_PERMISSIONS_POLICY_MOJOM_BLINK_H_