// services/network/public/mojom/parsed_headers.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_HEADERS_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_HEADERS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/parsed_headers.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/parsed_headers.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/parsed_headers.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/connection_allowlist.mojom.h"
#include "services/network/public/mojom/content_security_policy.mojom.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom.h"
#include "services/network/public/mojom/cross_origin_opener_policy.mojom.h"
#include "services/network/public/mojom/integrity_policy.mojom.h"
#include "services/network/public/mojom/document_isolation_policy.mojom.h"
#include "services/network/public/mojom/link_header.mojom.h"
#include "services/network/public/mojom/no_vary_search.mojom.h"
#include "services/network/public/mojom/supports_loading_mode.mojom-forward.h"
#include "services/network/public/mojom/timing_allow_origin.mojom.h"
#include "services/network/public/mojom/web_client_hints_types.mojom-forward.h"
#include "services/network/public/mojom/x_frame_options.mojom-forward.h"
#include <string>
#include <vector>








namespace network::mojom {








class  ParsedHeaders {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ParsedHeaders, T>::value>;
  using DataView = ParsedHeadersDataView;
  using Data_ = internal::ParsedHeaders_Data;

  template <typename... Args>
  static ParsedHeadersPtr New(Args&&... args) {
    return ParsedHeadersPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ParsedHeadersPtr From(const U& u) {
    return mojo::TypeConverter<ParsedHeadersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ParsedHeaders>::Convert(*this);
  }


  ParsedHeaders();

  ParsedHeaders(
      std::vector<::network::mojom::ContentSecurityPolicyPtr> content_security_policy,
      ::network::mojom::AllowCSPFromHeaderValuePtr allow_csp_from,
      const ::network::ConnectionAllowlists& connection_allowlists,
      const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy,
      const ::network::CrossOriginOpenerPolicy& cross_origin_opener_policy,
      const ::network::DocumentIsolationPolicy& document_isolation_policy,
      const ::network::IntegrityPolicy& integrity_policy,
      const ::network::IntegrityPolicy& integrity_policy_report_only,
      OriginAgentClusterValue origin_agent_cluster,
      std::optional<std::vector<::network::mojom::WebClientHintsType>> accept_ch,
      std::optional<std::vector<::network::mojom::WebClientHintsType>> critical_ch,
      bool client_hints_ignored_due_to_clear_site_data_header,
      ::network::mojom::XFrameOptionsValue xfo,
      std::vector<::network::mojom::LinkHeaderPtr> link_headers,
      ::network::mojom::TimingAllowOriginPtr timing_allow_origin,
      std::vector<::network::mojom::LoadingMode> supports_loading_mode,
      const std::optional<base::flat_map<std::string, std::string>>& reporting_endpoints,
      std::optional<std::vector<std::string>> cookie_indices,
      std::optional<std::vector<std::string>> avail_language,
      std::optional<std::vector<std::string>> content_language,
      ::network::mojom::NoVarySearchWithParseErrorPtr no_vary_search_with_parse_error,
      bool observe_browsing_topics,
      bool allow_cross_origin_event_reporting);

ParsedHeaders(const ParsedHeaders&) = delete;
ParsedHeaders& operator=(const ParsedHeaders&) = delete;

  ~ParsedHeaders();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ParsedHeadersPtr>
  ParsedHeadersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ParsedHeaders::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ParsedHeaders::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ParsedHeaders::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ParsedHeaders::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ParsedHeaders::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ParsedHeaders::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ParsedHeaders_UnserializedMessageContext<
            UserType, ParsedHeaders::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ParsedHeaders::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ParsedHeaders::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ParsedHeaders_UnserializedMessageContext<
            UserType, ParsedHeaders::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ParsedHeaders::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::network::mojom::ContentSecurityPolicyPtr> content_security_policy;
  
  ::network::mojom::AllowCSPFromHeaderValuePtr allow_csp_from;
  
  ::network::ConnectionAllowlists connection_allowlists;
  
  ::network::CrossOriginEmbedderPolicy cross_origin_embedder_policy;
  
  ::network::CrossOriginOpenerPolicy cross_origin_opener_policy;
  
  ::network::DocumentIsolationPolicy document_isolation_policy;
  
  ::network::IntegrityPolicy integrity_policy;
  
  ::network::IntegrityPolicy integrity_policy_report_only;
  
  OriginAgentClusterValue origin_agent_cluster;
  
  std::optional<std::vector<::network::mojom::WebClientHintsType>> accept_ch;
  
  std::optional<std::vector<::network::mojom::WebClientHintsType>> critical_ch;
  
  bool client_hints_ignored_due_to_clear_site_data_header;
  
  ::network::mojom::XFrameOptionsValue xfo;
  
  std::vector<::network::mojom::LinkHeaderPtr> link_headers;
  
  ::network::mojom::TimingAllowOriginPtr timing_allow_origin;
  
  std::vector<::network::mojom::LoadingMode> supports_loading_mode;
  
  std::optional<base::flat_map<std::string, std::string>> reporting_endpoints;
  
  std::optional<std::vector<std::string>> cookie_indices;
  
  std::optional<std::vector<std::string>> avail_language;
  
  std::optional<std::vector<std::string>> content_language;
  
  ::network::mojom::NoVarySearchWithParseErrorPtr no_vary_search_with_parse_error;
  
  bool observe_browsing_topics;
  
  bool allow_cross_origin_event_reporting;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ParsedHeaders::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ParsedHeaders::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ParsedHeaders::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ParsedHeaders::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ParsedHeadersPtr ParsedHeaders::Clone() const {
  return New(
      mojo::Clone(content_security_policy),
      mojo::Clone(allow_csp_from),
      mojo::Clone(connection_allowlists),
      mojo::Clone(cross_origin_embedder_policy),
      mojo::Clone(cross_origin_opener_policy),
      mojo::Clone(document_isolation_policy),
      mojo::Clone(integrity_policy),
      mojo::Clone(integrity_policy_report_only),
      mojo::Clone(origin_agent_cluster),
      mojo::Clone(accept_ch),
      mojo::Clone(critical_ch),
      mojo::Clone(client_hints_ignored_due_to_clear_site_data_header),
      mojo::Clone(xfo),
      mojo::Clone(link_headers),
      mojo::Clone(timing_allow_origin),
      mojo::Clone(supports_loading_mode),
      mojo::Clone(reporting_endpoints),
      mojo::Clone(cookie_indices),
      mojo::Clone(avail_language),
      mojo::Clone(content_language),
      mojo::Clone(no_vary_search_with_parse_error),
      mojo::Clone(observe_browsing_topics),
      mojo::Clone(allow_cross_origin_event_reporting)
  );
}

template <typename T, ParsedHeaders::EnableIfSame<T>*>
bool ParsedHeaders::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->content_security_policy, other_struct.content_security_policy))
    return false;
  if (!mojo::Equals(this->allow_csp_from, other_struct.allow_csp_from))
    return false;
  if (!mojo::Equals(this->connection_allowlists, other_struct.connection_allowlists))
    return false;
  if (!mojo::Equals(this->cross_origin_embedder_policy, other_struct.cross_origin_embedder_policy))
    return false;
  if (!mojo::Equals(this->cross_origin_opener_policy, other_struct.cross_origin_opener_policy))
    return false;
  if (!mojo::Equals(this->document_isolation_policy, other_struct.document_isolation_policy))
    return false;
  if (!mojo::Equals(this->integrity_policy, other_struct.integrity_policy))
    return false;
  if (!mojo::Equals(this->integrity_policy_report_only, other_struct.integrity_policy_report_only))
    return false;
  if (!mojo::Equals(this->origin_agent_cluster, other_struct.origin_agent_cluster))
    return false;
  if (!mojo::Equals(this->accept_ch, other_struct.accept_ch))
    return false;
  if (!mojo::Equals(this->critical_ch, other_struct.critical_ch))
    return false;
  if (!mojo::Equals(this->client_hints_ignored_due_to_clear_site_data_header, other_struct.client_hints_ignored_due_to_clear_site_data_header))
    return false;
  if (!mojo::Equals(this->xfo, other_struct.xfo))
    return false;
  if (!mojo::Equals(this->link_headers, other_struct.link_headers))
    return false;
  if (!mojo::Equals(this->timing_allow_origin, other_struct.timing_allow_origin))
    return false;
  if (!mojo::Equals(this->supports_loading_mode, other_struct.supports_loading_mode))
    return false;
  if (!mojo::Equals(this->reporting_endpoints, other_struct.reporting_endpoints))
    return false;
  if (!mojo::Equals(this->cookie_indices, other_struct.cookie_indices))
    return false;
  if (!mojo::Equals(this->avail_language, other_struct.avail_language))
    return false;
  if (!mojo::Equals(this->content_language, other_struct.content_language))
    return false;
  if (!mojo::Equals(this->no_vary_search_with_parse_error, other_struct.no_vary_search_with_parse_error))
    return false;
  if (!mojo::Equals(this->observe_browsing_topics, other_struct.observe_browsing_topics))
    return false;
  if (!mojo::Equals(this->allow_cross_origin_event_reporting, other_struct.allow_cross_origin_event_reporting))
    return false;
  return true;
}

template <typename T, ParsedHeaders::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.content_security_policy < rhs.content_security_policy)
    return true;
  if (rhs.content_security_policy < lhs.content_security_policy)
    return false;
  if (lhs.allow_csp_from < rhs.allow_csp_from)
    return true;
  if (rhs.allow_csp_from < lhs.allow_csp_from)
    return false;
  if (lhs.connection_allowlists < rhs.connection_allowlists)
    return true;
  if (rhs.connection_allowlists < lhs.connection_allowlists)
    return false;
  if (lhs.cross_origin_embedder_policy < rhs.cross_origin_embedder_policy)
    return true;
  if (rhs.cross_origin_embedder_policy < lhs.cross_origin_embedder_policy)
    return false;
  if (lhs.cross_origin_opener_policy < rhs.cross_origin_opener_policy)
    return true;
  if (rhs.cross_origin_opener_policy < lhs.cross_origin_opener_policy)
    return false;
  if (lhs.document_isolation_policy < rhs.document_isolation_policy)
    return true;
  if (rhs.document_isolation_policy < lhs.document_isolation_policy)
    return false;
  if (lhs.integrity_policy < rhs.integrity_policy)
    return true;
  if (rhs.integrity_policy < lhs.integrity_policy)
    return false;
  if (lhs.integrity_policy_report_only < rhs.integrity_policy_report_only)
    return true;
  if (rhs.integrity_policy_report_only < lhs.integrity_policy_report_only)
    return false;
  if (lhs.origin_agent_cluster < rhs.origin_agent_cluster)
    return true;
  if (rhs.origin_agent_cluster < lhs.origin_agent_cluster)
    return false;
  if (lhs.accept_ch < rhs.accept_ch)
    return true;
  if (rhs.accept_ch < lhs.accept_ch)
    return false;
  if (lhs.critical_ch < rhs.critical_ch)
    return true;
  if (rhs.critical_ch < lhs.critical_ch)
    return false;
  if (lhs.client_hints_ignored_due_to_clear_site_data_header < rhs.client_hints_ignored_due_to_clear_site_data_header)
    return true;
  if (rhs.client_hints_ignored_due_to_clear_site_data_header < lhs.client_hints_ignored_due_to_clear_site_data_header)
    return false;
  if (lhs.xfo < rhs.xfo)
    return true;
  if (rhs.xfo < lhs.xfo)
    return false;
  if (lhs.link_headers < rhs.link_headers)
    return true;
  if (rhs.link_headers < lhs.link_headers)
    return false;
  if (lhs.timing_allow_origin < rhs.timing_allow_origin)
    return true;
  if (rhs.timing_allow_origin < lhs.timing_allow_origin)
    return false;
  if (lhs.supports_loading_mode < rhs.supports_loading_mode)
    return true;
  if (rhs.supports_loading_mode < lhs.supports_loading_mode)
    return false;
  if (lhs.reporting_endpoints < rhs.reporting_endpoints)
    return true;
  if (rhs.reporting_endpoints < lhs.reporting_endpoints)
    return false;
  if (lhs.cookie_indices < rhs.cookie_indices)
    return true;
  if (rhs.cookie_indices < lhs.cookie_indices)
    return false;
  if (lhs.avail_language < rhs.avail_language)
    return true;
  if (rhs.avail_language < lhs.avail_language)
    return false;
  if (lhs.content_language < rhs.content_language)
    return true;
  if (rhs.content_language < lhs.content_language)
    return false;
  if (lhs.no_vary_search_with_parse_error < rhs.no_vary_search_with_parse_error)
    return true;
  if (rhs.no_vary_search_with_parse_error < lhs.no_vary_search_with_parse_error)
    return false;
  if (lhs.observe_browsing_topics < rhs.observe_browsing_topics)
    return true;
  if (rhs.observe_browsing_topics < lhs.observe_browsing_topics)
    return false;
  if (lhs.allow_cross_origin_event_reporting < rhs.allow_cross_origin_event_reporting)
    return true;
  if (rhs.allow_cross_origin_event_reporting < lhs.allow_cross_origin_event_reporting)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::ParsedHeaders::DataView,
                                         ::network::mojom::ParsedHeadersPtr> {
  static bool IsNull(const ::network::mojom::ParsedHeadersPtr& input) { return !input; }
  static void SetToNull(::network::mojom::ParsedHeadersPtr* output) { output->reset(); }

  static const decltype(::network::mojom::ParsedHeaders::content_security_policy)& content_security_policy(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->content_security_policy;
  }

  static const decltype(::network::mojom::ParsedHeaders::allow_csp_from)& allow_csp_from(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->allow_csp_from;
  }

  static const decltype(::network::mojom::ParsedHeaders::connection_allowlists)& connection_allowlists(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->connection_allowlists;
  }

  static const decltype(::network::mojom::ParsedHeaders::cross_origin_embedder_policy)& cross_origin_embedder_policy(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->cross_origin_embedder_policy;
  }

  static const decltype(::network::mojom::ParsedHeaders::cross_origin_opener_policy)& cross_origin_opener_policy(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->cross_origin_opener_policy;
  }

  static const decltype(::network::mojom::ParsedHeaders::document_isolation_policy)& document_isolation_policy(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->document_isolation_policy;
  }

  static const decltype(::network::mojom::ParsedHeaders::integrity_policy)& integrity_policy(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->integrity_policy;
  }

  static const decltype(::network::mojom::ParsedHeaders::integrity_policy_report_only)& integrity_policy_report_only(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->integrity_policy_report_only;
  }

  static decltype(::network::mojom::ParsedHeaders::origin_agent_cluster) origin_agent_cluster(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->origin_agent_cluster;
  }

  static const decltype(::network::mojom::ParsedHeaders::accept_ch)& accept_ch(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->accept_ch;
  }

  static const decltype(::network::mojom::ParsedHeaders::critical_ch)& critical_ch(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->critical_ch;
  }

  static decltype(::network::mojom::ParsedHeaders::client_hints_ignored_due_to_clear_site_data_header) client_hints_ignored_due_to_clear_site_data_header(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->client_hints_ignored_due_to_clear_site_data_header;
  }

  static decltype(::network::mojom::ParsedHeaders::xfo) xfo(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->xfo;
  }

  static const decltype(::network::mojom::ParsedHeaders::link_headers)& link_headers(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->link_headers;
  }

  static const decltype(::network::mojom::ParsedHeaders::timing_allow_origin)& timing_allow_origin(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->timing_allow_origin;
  }

  static const decltype(::network::mojom::ParsedHeaders::supports_loading_mode)& supports_loading_mode(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->supports_loading_mode;
  }

  static const decltype(::network::mojom::ParsedHeaders::reporting_endpoints)& reporting_endpoints(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->reporting_endpoints;
  }

  static const decltype(::network::mojom::ParsedHeaders::cookie_indices)& cookie_indices(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->cookie_indices;
  }

  static const decltype(::network::mojom::ParsedHeaders::avail_language)& avail_language(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->avail_language;
  }

  static const decltype(::network::mojom::ParsedHeaders::content_language)& content_language(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->content_language;
  }

  static const decltype(::network::mojom::ParsedHeaders::no_vary_search_with_parse_error)& no_vary_search_with_parse_error(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->no_vary_search_with_parse_error;
  }

  static decltype(::network::mojom::ParsedHeaders::observe_browsing_topics) observe_browsing_topics(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->observe_browsing_topics;
  }

  static decltype(::network::mojom::ParsedHeaders::allow_cross_origin_event_reporting) allow_cross_origin_event_reporting(
      const ::network::mojom::ParsedHeadersPtr& input) {
    return input->allow_cross_origin_event_reporting;
  }

  static bool Read(::network::mojom::ParsedHeaders::DataView input, ::network::mojom::ParsedHeadersPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_HEADERS_MOJOM_H_