// services/network/public/mojom/p2p_trusted.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.P2PTrustedSocketManagerClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.P2PTrustedSocketManagerClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.P2PTrustedSocketManagerClientInterface }
 */
network.mojom.P2PTrustedSocketManagerClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.P2PTrustedSocketManagerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.P2PTrustedSocketManagerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.P2PTrustedSocketManagerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  invalidSocketPortRangeRequested() {
    this.proxy.sendMessage(
        0,
        network.mojom.P2PTrustedSocketManagerClient_InvalidSocketPortRangeRequested_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } packetHeader
   * @param { !bigint } packetLength
   * @param { !boolean } incoming
   */

  dumpPacket(
      packetHeader,
      packetLength,
      incoming) {
    this.proxy.sendMessage(
        1,
        network.mojom.P2PTrustedSocketManagerClient_DumpPacket_ParamsSpec.$,
        null,
        [
          packetHeader,
          packetLength,
          incoming
        ],
        false);
  }
};

/**
 * An object which receives request messages for the P2PTrustedSocketManagerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.P2PTrustedSocketManagerClientReceiver = class {
  /**
   * @param {!network.mojom.P2PTrustedSocketManagerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.P2PTrustedSocketManagerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.P2PTrustedSocketManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.P2PTrustedSocketManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.P2PTrustedSocketManagerClient_InvalidSocketPortRangeRequested_ParamsSpec.$,
        null,
        impl.invalidSocketPortRangeRequested.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.P2PTrustedSocketManagerClient_DumpPacket_ParamsSpec.$,
        null,
        impl.dumpPacket.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.P2PTrustedSocketManagerClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.P2PTrustedSocketManagerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.P2PTrustedSocketManagerClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.P2PTrustedSocketManagerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the P2PTrustedSocketManagerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.P2PTrustedSocketManagerClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.P2PTrustedSocketManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.P2PTrustedSocketManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.invalidSocketPortRangeRequested =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.P2PTrustedSocketManagerClient_InvalidSocketPortRangeRequested_ParamsSpec.$,
        null,
        this.invalidSocketPortRangeRequested.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dumpPacket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.P2PTrustedSocketManagerClient_DumpPacket_ParamsSpec.$,
        null,
        this.dumpPacket.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.P2PTrustedSocketManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.P2PTrustedSocketManager.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.P2PTrustedSocketManagerInterface }
 */
network.mojom.P2PTrustedSocketManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.P2PTrustedSocketManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.P2PTrustedSocketManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.P2PTrustedSocketManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } incoming
   * @param { !boolean } outgoing
   */

  startRtpDump(
      incoming,
      outgoing) {
    this.proxy.sendMessage(
        0,
        network.mojom.P2PTrustedSocketManager_StartRtpDump_ParamsSpec.$,
        null,
        [
          incoming,
          outgoing
        ],
        false);
  }

  
  /**
   * @param { !boolean } incoming
   * @param { !boolean } outgoing
   */

  stopRtpDump(
      incoming,
      outgoing) {
    this.proxy.sendMessage(
        1,
        network.mojom.P2PTrustedSocketManager_StopRtpDump_ParamsSpec.$,
        null,
        [
          incoming,
          outgoing
        ],
        false);
  }

  
  /**
   */

  pauseNetworkChangeNotifications() {
    this.proxy.sendMessage(
        2,
        network.mojom.P2PTrustedSocketManager_PauseNetworkChangeNotifications_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  resumeNetworkChangeNotifications() {
    this.proxy.sendMessage(
        3,
        network.mojom.P2PTrustedSocketManager_ResumeNetworkChangeNotifications_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the P2PTrustedSocketManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.P2PTrustedSocketManagerReceiver = class {
  /**
   * @param {!network.mojom.P2PTrustedSocketManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.P2PTrustedSocketManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.P2PTrustedSocketManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.P2PTrustedSocketManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.P2PTrustedSocketManager_StartRtpDump_ParamsSpec.$,
        null,
        impl.startRtpDump.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.P2PTrustedSocketManager_StopRtpDump_ParamsSpec.$,
        null,
        impl.stopRtpDump.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.P2PTrustedSocketManager_PauseNetworkChangeNotifications_ParamsSpec.$,
        null,
        impl.pauseNetworkChangeNotifications.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.P2PTrustedSocketManager_ResumeNetworkChangeNotifications_ParamsSpec.$,
        null,
        impl.resumeNetworkChangeNotifications.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.P2PTrustedSocketManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.P2PTrustedSocketManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.P2PTrustedSocketManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.P2PTrustedSocketManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the P2PTrustedSocketManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.P2PTrustedSocketManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.P2PTrustedSocketManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.P2PTrustedSocketManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startRtpDump =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.P2PTrustedSocketManager_StartRtpDump_ParamsSpec.$,
        null,
        this.startRtpDump.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopRtpDump =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.P2PTrustedSocketManager_StopRtpDump_ParamsSpec.$,
        null,
        this.stopRtpDump.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.pauseNetworkChangeNotifications =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.P2PTrustedSocketManager_PauseNetworkChangeNotifications_ParamsSpec.$,
        null,
        this.pauseNetworkChangeNotifications.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resumeNetworkChangeNotifications =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.P2PTrustedSocketManager_ResumeNetworkChangeNotifications_ParamsSpec.$,
        null,
        this.resumeNetworkChangeNotifications.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PTrustedSocketManagerClient_InvalidSocketPortRangeRequested_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PTrustedSocketManagerClient_DumpPacket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PTrustedSocketManager_StartRtpDump_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PTrustedSocketManager_StopRtpDump_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PTrustedSocketManager_PauseNetworkChangeNotifications_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PTrustedSocketManager_ResumeNetworkChangeNotifications_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.P2PTrustedSocketManagerClient_InvalidSocketPortRangeRequested_ParamsSpec.$,
    'P2PTrustedSocketManagerClient_InvalidSocketPortRangeRequested_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.P2PTrustedSocketManagerClient_InvalidSocketPortRangeRequested_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.P2PTrustedSocketManagerClient_DumpPacket_ParamsSpec.$,
    'P2PTrustedSocketManagerClient_DumpPacket_Params',
    [
      mojo.internal.StructField(
        'packetHeader', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'packetLength', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'incoming', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.P2PTrustedSocketManagerClient_DumpPacket_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.packetHeader;
    /** @export { !bigint } */
    this.packetLength;
    /** @export { !boolean } */
    this.incoming;
  }
};



mojo.internal.Struct(
    network.mojom.P2PTrustedSocketManager_StartRtpDump_ParamsSpec.$,
    'P2PTrustedSocketManager_StartRtpDump_Params',
    [
      mojo.internal.StructField(
        'incoming', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outgoing', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.P2PTrustedSocketManager_StartRtpDump_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.incoming;
    /** @export { !boolean } */
    this.outgoing;
  }
};



mojo.internal.Struct(
    network.mojom.P2PTrustedSocketManager_StopRtpDump_ParamsSpec.$,
    'P2PTrustedSocketManager_StopRtpDump_Params',
    [
      mojo.internal.StructField(
        'incoming', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outgoing', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.P2PTrustedSocketManager_StopRtpDump_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.incoming;
    /** @export { !boolean } */
    this.outgoing;
  }
};



mojo.internal.Struct(
    network.mojom.P2PTrustedSocketManager_PauseNetworkChangeNotifications_ParamsSpec.$,
    'P2PTrustedSocketManager_PauseNetworkChangeNotifications_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.P2PTrustedSocketManager_PauseNetworkChangeNotifications_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.P2PTrustedSocketManager_ResumeNetworkChangeNotifications_ParamsSpec.$,
    'P2PTrustedSocketManager_ResumeNetworkChangeNotifications_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.P2PTrustedSocketManager_ResumeNetworkChangeNotifications_Params = class {
  constructor() {
  }
};

