// services/network/public/mojom/p2p.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  ReadOnlyBuffer as mojoBase_mojom_ReadOnlyBuffer,
  ReadOnlyBufferSpec as mojoBase_mojom_ReadOnlyBufferSpec
} from '../../../../mojo/public/mojom/base/read_only_buffer.mojom.m.js';

import {
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  AddressFamily as network_mojom_AddressFamily,
  AddressFamilySpec as network_mojom_AddressFamilySpec
} from './address_family.mojom.m.js';

import {
  IPAddress as network_mojom_IPAddress,
  IPAddressSpec as network_mojom_IPAddressSpec
} from './ip_address.mojom.m.js';

import {
  IPEndPoint as network_mojom_IPEndPoint,
  IPEndPointSpec as network_mojom_IPEndPointSpec
} from './ip_endpoint.mojom.m.js';

import {
  MutableNetworkTrafficAnnotationTag as network_mojom_MutableNetworkTrafficAnnotationTag,
  MutableNetworkTrafficAnnotationTagSpec as network_mojom_MutableNetworkTrafficAnnotationTagSpec
} from './mutable_network_traffic_annotation_tag.mojom.m.js';

import {
  NetworkInterface as network_mojom_NetworkInterface,
  NetworkInterfaceSpec as network_mojom_NetworkInterfaceSpec
} from './network_interface.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const P2PSocketTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const P2PSocketType = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const P2PSocketOptionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const P2PSocketOption = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const EcnMarkingSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const EcnMarking = {
  
  kNotEct: 0,
  kEct1: 1,
  kEct0: 2,
  kCe: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class P2PNetworkNotificationClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.P2PNetworkNotificationClient', scope);
  }
}

/** @interface */
export class P2PNetworkNotificationClientInterface {
  
  /**
   * @param { !Array<!network_mojom_NetworkInterface> } networks
   * @param { !network_mojom_IPAddress } defaultIpv4LocalAddress
   * @param { !network_mojom_IPAddress } defaultIpv6LocalAddress
   */

  networkListChanged(networks, defaultIpv4LocalAddress, defaultIpv6LocalAddress) {}
}

/**
 * @implements { P2PNetworkNotificationClientInterface }
 */
export class P2PNetworkNotificationClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!P2PNetworkNotificationClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          P2PNetworkNotificationClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!P2PNetworkNotificationClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!network_mojom_NetworkInterface> } networks
   * @param { !network_mojom_IPAddress } defaultIpv4LocalAddress
   * @param { !network_mojom_IPAddress } defaultIpv6LocalAddress
   */

  networkListChanged(
      networks,
      defaultIpv4LocalAddress,
      defaultIpv6LocalAddress) {
    this.proxy.sendMessage(
        0,
        P2PNetworkNotificationClient_NetworkListChanged_ParamsSpec.$,
        null,
        [
          networks,
          defaultIpv4LocalAddress,
          defaultIpv6LocalAddress
        ],
        false);
  }
}

/**
 * An object which receives request messages for the P2PNetworkNotificationClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class P2PNetworkNotificationClientReceiver {
  /**
   * @param {!P2PNetworkNotificationClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!P2PNetworkNotificationClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        P2PNetworkNotificationClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!P2PNetworkNotificationClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        P2PNetworkNotificationClient_NetworkListChanged_ParamsSpec.$,
        null,
        impl.networkListChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class P2PNetworkNotificationClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.P2PNetworkNotificationClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!P2PNetworkNotificationClientRemote}
   */
  static getRemote() {
    let remote = new P2PNetworkNotificationClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the P2PNetworkNotificationClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class P2PNetworkNotificationClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      P2PNetworkNotificationClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!P2PNetworkNotificationClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.networkListChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        P2PNetworkNotificationClient_NetworkListChanged_ParamsSpec.$,
        null,
        this.networkListChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class P2PSocketManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.P2PSocketManager', scope);
  }
}

/** @interface */
export class P2PSocketManagerInterface {
  
  /**
   * @param { !P2PNetworkNotificationClientRemote } client
   */

  startNetworkNotifications(client) {}
  
  /**
   * @param { !string } hostName
   * @param { ?network_mojom_AddressFamily } addressFamily
   * @param { !boolean } enableMdns
   * @return {!Promise<{
        addresses: !Array<!network_mojom_IPAddress>,
   *  }>}
   */

  getHostAddress(hostName, addressFamily, enableMdns) {}
  
  /**
   * @param { !P2PSocketType } type
   * @param { !network_mojom_IPEndPoint } localAddress
   * @param { !P2PPortRange } portRange
   * @param { !P2PHostAndIPEndPoint } remoteAddress
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { ?mojoBase_mojom_UnguessableToken } devtoolsToken
   * @param { !P2PSocketClientRemote } client
   * @param { !P2PSocketPendingReceiver } socket
   */

  createSocket(type, localAddress, portRange, remoteAddress, trafficAnnotation, devtoolsToken, client, socket) {}
}

/**
 * @implements { P2PSocketManagerInterface }
 */
export class P2PSocketManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!P2PSocketManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          P2PSocketManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!P2PSocketManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !P2PNetworkNotificationClientRemote } client
   */

  startNetworkNotifications(
      client) {
    this.proxy.sendMessage(
        0,
        P2PSocketManager_StartNetworkNotifications_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }

  
  /**
   * @param { !string } hostName
   * @param { ?network_mojom_AddressFamily } addressFamily
   * @param { !boolean } enableMdns
   * @return {!Promise<{
        addresses: !Array<!network_mojom_IPAddress>,
   *  }>}
   */

  getHostAddress(
      hostName,
      addressFamily,
      enableMdns) {
    return this.proxy.sendMessage(
        1,
        P2PSocketManager_GetHostAddress_ParamsSpec.$,
        P2PSocketManager_GetHostAddress_ResponseParamsSpec.$,
        [
          hostName,
          addressFamily,
          enableMdns
        ],
        false);
  }

  
  /**
   * @param { !P2PSocketType } type
   * @param { !network_mojom_IPEndPoint } localAddress
   * @param { !P2PPortRange } portRange
   * @param { !P2PHostAndIPEndPoint } remoteAddress
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { ?mojoBase_mojom_UnguessableToken } devtoolsToken
   * @param { !P2PSocketClientRemote } client
   * @param { !P2PSocketPendingReceiver } socket
   */

  createSocket(
      type,
      localAddress,
      portRange,
      remoteAddress,
      trafficAnnotation,
      devtoolsToken,
      client,
      socket) {
    this.proxy.sendMessage(
        2,
        P2PSocketManager_CreateSocket_ParamsSpec.$,
        null,
        [
          type,
          localAddress,
          portRange,
          remoteAddress,
          trafficAnnotation,
          devtoolsToken,
          client,
          socket
        ],
        false);
  }
}

/**
 * An object which receives request messages for the P2PSocketManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class P2PSocketManagerReceiver {
  /**
   * @param {!P2PSocketManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!P2PSocketManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        P2PSocketManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!P2PSocketManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        P2PSocketManager_StartNetworkNotifications_ParamsSpec.$,
        null,
        impl.startNetworkNotifications.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        P2PSocketManager_GetHostAddress_ParamsSpec.$,
        P2PSocketManager_GetHostAddress_ResponseParamsSpec.$,
        impl.getHostAddress.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        P2PSocketManager_CreateSocket_ParamsSpec.$,
        null,
        impl.createSocket.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class P2PSocketManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.P2PSocketManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!P2PSocketManagerRemote}
   */
  static getRemote() {
    let remote = new P2PSocketManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the P2PSocketManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class P2PSocketManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      P2PSocketManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!P2PSocketManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startNetworkNotifications =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        P2PSocketManager_StartNetworkNotifications_ParamsSpec.$,
        null,
        this.startNetworkNotifications.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getHostAddress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        P2PSocketManager_GetHostAddress_ParamsSpec.$,
        P2PSocketManager_GetHostAddress_ResponseParamsSpec.$,
        this.getHostAddress.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        P2PSocketManager_CreateSocket_ParamsSpec.$,
        null,
        this.createSocket.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class P2PSocketPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.P2PSocket', scope);
  }
}

/** @interface */
export class P2PSocketInterface {
  
  /**
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   * @param { !P2PPacketInfo } packetInfo
   */

  send(data, packetInfo) {}
  
  /**
   * @param { !Array<!P2PSendPacket> } packetBatch
   */

  sendBatch(packetBatch) {}
  
  /**
   * @param { !P2PSocketOption } option
   * @param { !number } value
   */

  setOption(option, value) {}
}

/**
 * @implements { P2PSocketInterface }
 */
export class P2PSocketRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!P2PSocketPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          P2PSocketPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!P2PSocketPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   * @param { !P2PPacketInfo } packetInfo
   */

  send(
      data,
      packetInfo) {
    this.proxy.sendMessage(
        0,
        P2PSocket_Send_ParamsSpec.$,
        null,
        [
          data,
          packetInfo
        ],
        false);
  }

  
  /**
   * @param { !Array<!P2PSendPacket> } packetBatch
   */

  sendBatch(
      packetBatch) {
    this.proxy.sendMessage(
        1,
        P2PSocket_SendBatch_ParamsSpec.$,
        null,
        [
          packetBatch
        ],
        false);
  }

  
  /**
   * @param { !P2PSocketOption } option
   * @param { !number } value
   */

  setOption(
      option,
      value) {
    this.proxy.sendMessage(
        2,
        P2PSocket_SetOption_ParamsSpec.$,
        null,
        [
          option,
          value
        ],
        false);
  }
}

/**
 * An object which receives request messages for the P2PSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class P2PSocketReceiver {
  /**
   * @param {!P2PSocketInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!P2PSocketRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        P2PSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!P2PSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        P2PSocket_Send_ParamsSpec.$,
        null,
        impl.send.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        P2PSocket_SendBatch_ParamsSpec.$,
        null,
        impl.sendBatch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        P2PSocket_SetOption_ParamsSpec.$,
        null,
        impl.setOption.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class P2PSocket {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.P2PSocket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!P2PSocketRemote}
   */
  static getRemote() {
    let remote = new P2PSocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the P2PSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class P2PSocketCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      P2PSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!P2PSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.send =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        P2PSocket_Send_ParamsSpec.$,
        null,
        this.send.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendBatch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        P2PSocket_SendBatch_ParamsSpec.$,
        null,
        this.sendBatch.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setOption =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        P2PSocket_SetOption_ParamsSpec.$,
        null,
        this.setOption.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class P2PSocketClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.P2PSocketClient', scope);
  }
}

/** @interface */
export class P2PSocketClientInterface {
  
  /**
   * @param { !network_mojom_IPEndPoint } localAddress
   * @param { !network_mojom_IPEndPoint } remoteAddress
   */

  socketCreated(localAddress, remoteAddress) {}
  
  /**
   * @param { !P2PSendPacketMetrics } sendMetrics
   */

  sendComplete(sendMetrics) {}
  
  /**
   * @param { !Array<!P2PSendPacketMetrics> } sendMetricsBatch
   */

  sendBatchComplete(sendMetricsBatch) {}
  
  /**
   * @param { !Array<!P2PReceivedPacket> } packets
   */

  dataReceived(packets) {}
}

/**
 * @implements { P2PSocketClientInterface }
 */
export class P2PSocketClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!P2PSocketClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          P2PSocketClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!P2PSocketClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_IPEndPoint } localAddress
   * @param { !network_mojom_IPEndPoint } remoteAddress
   */

  socketCreated(
      localAddress,
      remoteAddress) {
    this.proxy.sendMessage(
        0,
        P2PSocketClient_SocketCreated_ParamsSpec.$,
        null,
        [
          localAddress,
          remoteAddress
        ],
        false);
  }

  
  /**
   * @param { !P2PSendPacketMetrics } sendMetrics
   */

  sendComplete(
      sendMetrics) {
    this.proxy.sendMessage(
        1,
        P2PSocketClient_SendComplete_ParamsSpec.$,
        null,
        [
          sendMetrics
        ],
        false);
  }

  
  /**
   * @param { !Array<!P2PSendPacketMetrics> } sendMetricsBatch
   */

  sendBatchComplete(
      sendMetricsBatch) {
    this.proxy.sendMessage(
        2,
        P2PSocketClient_SendBatchComplete_ParamsSpec.$,
        null,
        [
          sendMetricsBatch
        ],
        false);
  }

  
  /**
   * @param { !Array<!P2PReceivedPacket> } packets
   */

  dataReceived(
      packets) {
    this.proxy.sendMessage(
        3,
        P2PSocketClient_DataReceived_ParamsSpec.$,
        null,
        [
          packets
        ],
        false);
  }
}

/**
 * An object which receives request messages for the P2PSocketClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class P2PSocketClientReceiver {
  /**
   * @param {!P2PSocketClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!P2PSocketClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        P2PSocketClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!P2PSocketClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        P2PSocketClient_SocketCreated_ParamsSpec.$,
        null,
        impl.socketCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        P2PSocketClient_SendComplete_ParamsSpec.$,
        null,
        impl.sendComplete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        P2PSocketClient_SendBatchComplete_ParamsSpec.$,
        null,
        impl.sendBatchComplete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        P2PSocketClient_DataReceived_ParamsSpec.$,
        null,
        impl.dataReceived.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class P2PSocketClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.P2PSocketClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!P2PSocketClientRemote}
   */
  static getRemote() {
    let remote = new P2PSocketClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the P2PSocketClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class P2PSocketClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      P2PSocketClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!P2PSocketClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.socketCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        P2PSocketClient_SocketCreated_ParamsSpec.$,
        null,
        this.socketCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        P2PSocketClient_SendComplete_ParamsSpec.$,
        null,
        this.sendComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendBatchComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        P2PSocketClient_SendBatchComplete_ParamsSpec.$,
        null,
        this.sendBatchComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dataReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        P2PSocketClient_DataReceived_ParamsSpec.$,
        null,
        this.dataReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PHostAndIPEndPointSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PPacketInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PPortRangeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PSendPacketMetricsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PReceivedPacketSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PSendPacketSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PNetworkNotificationClient_NetworkListChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PSocketManager_StartNetworkNotifications_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PSocketManager_GetHostAddress_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PSocketManager_GetHostAddress_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PSocketManager_CreateSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PSocket_Send_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PSocket_SendBatch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PSocket_SetOption_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PSocketClient_SocketCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PSocketClient_SendComplete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PSocketClient_SendBatchComplete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PSocketClient_DataReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    P2PHostAndIPEndPointSpec.$,
    'P2PHostAndIPEndPoint',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class P2PHostAndIPEndPoint {
  constructor() {
  }
}



mojo.internal.Struct(
    P2PPacketInfoSpec.$,
    'P2PPacketInfo',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class P2PPacketInfo {
  constructor() {
  }
}



mojo.internal.Struct(
    P2PPortRangeSpec.$,
    'P2PPortRange',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class P2PPortRange {
  constructor() {
  }
}



mojo.internal.Struct(
    P2PSendPacketMetricsSpec.$,
    'P2PSendPacketMetrics',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class P2PSendPacketMetrics {
  constructor() {
  }
}



mojo.internal.Struct(
    P2PReceivedPacketSpec.$,
    'P2PReceivedPacket',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'socketAddress', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timestamp', 16,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ecn', 24,
        0,
        EcnMarkingSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class P2PReceivedPacket {
  constructor() {
    /** @type { !mojoBase_mojom_ReadOnlyBuffer } */
    this.data;
    /** @type { !network_mojom_IPEndPoint } */
    this.socketAddress;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.timestamp;
    /** @type { !EcnMarking } */
    this.ecn;
  }
}



mojo.internal.Struct(
    P2PSendPacketSpec.$,
    'P2PSendPacket',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'packetInfo', 8,
        0,
        P2PPacketInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class P2PSendPacket {
  constructor() {
    /** @type { !mojoBase_mojom_ReadOnlyBuffer } */
    this.data;
    /** @type { !P2PPacketInfo } */
    this.packetInfo;
  }
}



mojo.internal.Struct(
    P2PNetworkNotificationClient_NetworkListChanged_ParamsSpec.$,
    'P2PNetworkNotificationClient_NetworkListChanged_Params',
    [
      mojo.internal.StructField(
        'networks', 0,
        0,
        mojo.internal.Array(network_mojom_NetworkInterfaceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'defaultIpv4LocalAddress', 8,
        0,
        network_mojom_IPAddressSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'defaultIpv6LocalAddress', 16,
        0,
        network_mojom_IPAddressSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class P2PNetworkNotificationClient_NetworkListChanged_Params {
  constructor() {
    /** @type { !Array<!network_mojom_NetworkInterface> } */
    this.networks;
    /** @type { !network_mojom_IPAddress } */
    this.defaultIpv4LocalAddress;
    /** @type { !network_mojom_IPAddress } */
    this.defaultIpv6LocalAddress;
  }
}



mojo.internal.Struct(
    P2PSocketManager_StartNetworkNotifications_ParamsSpec.$,
    'P2PSocketManager_StartNetworkNotifications_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(P2PNetworkNotificationClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class P2PSocketManager_StartNetworkNotifications_Params {
  constructor() {
    /** @type { !P2PNetworkNotificationClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    P2PSocketManager_GetHostAddress_ParamsSpec.$,
    'P2PSocketManager_GetHostAddress_Params',
    [
      mojo.internal.StructField(
        'hostName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'address_family_$flag', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "address_family_$value",
          originalFieldName: "addressFamily",
        }
      ),
      mojo.internal.StructField(
        'address_family_$value', 12,
        0,
        network_mojom_AddressFamilySpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "addressFamily",
        }
      ),
      mojo.internal.StructField(
        'enableMdns', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class P2PSocketManager_GetHostAddress_Params {
  constructor() {
    /** @type { !string } */
    this.hostName;
    /** @type { (network_mojom_AddressFamily|undefined) } */
    this.addressFamily;
    /** @type { !boolean } */
    this.enableMdns;
  }
}



mojo.internal.Struct(
    P2PSocketManager_GetHostAddress_ResponseParamsSpec.$,
    'P2PSocketManager_GetHostAddress_ResponseParams',
    [
      mojo.internal.StructField(
        'addresses', 0,
        0,
        mojo.internal.Array(network_mojom_IPAddressSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class P2PSocketManager_GetHostAddress_ResponseParams {
  constructor() {
    /** @type { !Array<!network_mojom_IPAddress> } */
    this.addresses;
  }
}



mojo.internal.Struct(
    P2PSocketManager_CreateSocket_ParamsSpec.$,
    'P2PSocketManager_CreateSocket_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        P2PSocketTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'localAddress', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'portRange', 16,
        0,
        P2PPortRangeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remoteAddress', 24,
        0,
        P2PHostAndIPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 32,
        0,
        network_mojom_MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'devtoolsToken', 40,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 48,
        0,
        mojo.internal.InterfaceProxy(P2PSocketClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'socket', 4,
        0,
        mojo.internal.InterfaceRequest(P2PSocketPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class P2PSocketManager_CreateSocket_Params {
  constructor() {
    /** @type { !P2PSocketType } */
    this.type;
    /** @type { !network_mojom_IPEndPoint } */
    this.localAddress;
    /** @type { !P2PPortRange } */
    this.portRange;
    /** @type { !P2PHostAndIPEndPoint } */
    this.remoteAddress;
    /** @type { !network_mojom_MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.devtoolsToken;
    /** @type { !P2PSocketClientRemote } */
    this.client;
    /** @type { !P2PSocketPendingReceiver } */
    this.socket;
  }
}



mojo.internal.Struct(
    P2PSocket_Send_ParamsSpec.$,
    'P2PSocket_Send_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'packetInfo', 8,
        0,
        P2PPacketInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class P2PSocket_Send_Params {
  constructor() {
    /** @type { !mojoBase_mojom_ReadOnlyBuffer } */
    this.data;
    /** @type { !P2PPacketInfo } */
    this.packetInfo;
  }
}



mojo.internal.Struct(
    P2PSocket_SendBatch_ParamsSpec.$,
    'P2PSocket_SendBatch_Params',
    [
      mojo.internal.StructField(
        'packetBatch', 0,
        0,
        mojo.internal.Array(P2PSendPacketSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class P2PSocket_SendBatch_Params {
  constructor() {
    /** @type { !Array<!P2PSendPacket> } */
    this.packetBatch;
  }
}



mojo.internal.Struct(
    P2PSocket_SetOption_ParamsSpec.$,
    'P2PSocket_SetOption_Params',
    [
      mojo.internal.StructField(
        'option', 0,
        0,
        P2PSocketOptionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class P2PSocket_SetOption_Params {
  constructor() {
    /** @type { !P2PSocketOption } */
    this.option;
    /** @type { !number } */
    this.value;
  }
}



mojo.internal.Struct(
    P2PSocketClient_SocketCreated_ParamsSpec.$,
    'P2PSocketClient_SocketCreated_Params',
    [
      mojo.internal.StructField(
        'localAddress', 0,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remoteAddress', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class P2PSocketClient_SocketCreated_Params {
  constructor() {
    /** @type { !network_mojom_IPEndPoint } */
    this.localAddress;
    /** @type { !network_mojom_IPEndPoint } */
    this.remoteAddress;
  }
}



mojo.internal.Struct(
    P2PSocketClient_SendComplete_ParamsSpec.$,
    'P2PSocketClient_SendComplete_Params',
    [
      mojo.internal.StructField(
        'sendMetrics', 0,
        0,
        P2PSendPacketMetricsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class P2PSocketClient_SendComplete_Params {
  constructor() {
    /** @type { !P2PSendPacketMetrics } */
    this.sendMetrics;
  }
}



mojo.internal.Struct(
    P2PSocketClient_SendBatchComplete_ParamsSpec.$,
    'P2PSocketClient_SendBatchComplete_Params',
    [
      mojo.internal.StructField(
        'sendMetricsBatch', 0,
        0,
        mojo.internal.Array(P2PSendPacketMetricsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class P2PSocketClient_SendBatchComplete_Params {
  constructor() {
    /** @type { !Array<!P2PSendPacketMetrics> } */
    this.sendMetricsBatch;
  }
}



mojo.internal.Struct(
    P2PSocketClient_DataReceived_ParamsSpec.$,
    'P2PSocketClient_DataReceived_Params',
    [
      mojo.internal.StructField(
        'packets', 0,
        0,
        mojo.internal.Array(P2PReceivedPacketSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class P2PSocketClient_DataReceived_Params {
  constructor() {
    /** @type { !Array<!P2PReceivedPacket> } */
    this.packets;
  }
}

