// services/network/public/mojom/p2p.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_P2P_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_P2P_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/p2p.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/p2p.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/p2p.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom.h"
#include "services/network/public/mojom/address_family.mojom.h"
#include "services/network/public/mojom/network_interface.mojom.h"
#include "services/network/public/mojom/ip_address.mojom.h"
#include "services/network/public/mojom/ip_endpoint.mojom.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "services/network/public/cpp/p2p_param_traits.h"




namespace network::mojom {

class P2PNetworkNotificationClientProxy;

template <typename ImplRefTraits>
class P2PNetworkNotificationClientStub;

class P2PNetworkNotificationClientRequestValidator;


class P2PNetworkNotificationClient
    : public P2PNetworkNotificationClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.P2PNetworkNotificationClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = P2PNetworkNotificationClientInterfaceBase;
  using Proxy_ = P2PNetworkNotificationClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = P2PNetworkNotificationClientStub<ImplRefTraits>;

  using RequestValidator_ = P2PNetworkNotificationClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kNetworkListChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct NetworkListChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~P2PNetworkNotificationClient() = default;

  virtual void NetworkListChanged(const std::vector<::net::NetworkInterface>& networks, const ::net::IPAddress& default_ipv4_local_address, const ::net::IPAddress& default_ipv6_local_address) = 0;
};

class P2PSocketManagerProxy;

template <typename ImplRefTraits>
class P2PSocketManagerStub;

class P2PSocketManagerRequestValidator;
class P2PSocketManagerResponseValidator;


class P2PSocketManager
    : public P2PSocketManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.P2PSocketManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = P2PSocketManagerInterfaceBase;
  using Proxy_ = P2PSocketManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = P2PSocketManagerStub<ImplRefTraits>;

  using RequestValidator_ = P2PSocketManagerRequestValidator;
  using ResponseValidator_ = P2PSocketManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kStartNetworkNotificationsMinVersion = 0,
    kGetHostAddressMinVersion = 0,
    kCreateSocketMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StartNetworkNotifications_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetHostAddress_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateSocket_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~P2PSocketManager() = default;

  virtual void StartNetworkNotifications(::mojo::PendingRemote<P2PNetworkNotificationClient> client) = 0;

  using GetHostAddressCallback = base::OnceCallback<void(const std::vector<::net::IPAddress>&)>;
  using GetHostAddressMojoCallback = base::OnceCallback<void(const std::vector<::net::IPAddress>&)>;

  virtual void GetHostAddress(const std::string& host_name, std::optional<::net::AddressFamily> address_family, bool enable_mdns, GetHostAddressCallback callback) = 0;

  virtual void CreateSocket(::network::P2PSocketType type, const ::net::IPEndPoint& local_address, const ::network::P2PPortRange& port_range, const ::network::P2PHostAndIPEndPoint& remote_address, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, const std::optional<::base::UnguessableToken>& devtools_token, ::mojo::PendingRemote<P2PSocketClient> client, ::mojo::PendingReceiver<P2PSocket> socket) = 0;
};

class P2PSocketProxy;

template <typename ImplRefTraits>
class P2PSocketStub;

class P2PSocketRequestValidator;


class P2PSocket
    : public P2PSocketInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.P2PSocket";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = P2PSocketInterfaceBase;
  using Proxy_ = P2PSocketProxy;

  template <typename ImplRefTraits>
  using Stub_ = P2PSocketStub<ImplRefTraits>;

  using RequestValidator_ = P2PSocketRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSendMinVersion = 0,
    kSendBatchMinVersion = 0,
    kSetOptionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Send_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendBatch_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetOption_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~P2PSocket() = default;

  virtual void Send(::base::span<const ::uint8_t> data, const ::network::P2PPacketInfo& packet_info) = 0;

  virtual void SendBatch(std::vector<P2PSendPacketPtr> packet_batch) = 0;

  virtual void SetOption(::network::P2PSocketOption option, int32_t value) = 0;
};

class P2PSocketClientProxy;

template <typename ImplRefTraits>
class P2PSocketClientStub;

class P2PSocketClientRequestValidator;


class P2PSocketClient
    : public P2PSocketClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.P2PSocketClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = P2PSocketClientInterfaceBase;
  using Proxy_ = P2PSocketClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = P2PSocketClientStub<ImplRefTraits>;

  using RequestValidator_ = P2PSocketClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSocketCreatedMinVersion = 0,
    kSendCompleteMinVersion = 0,
    kSendBatchCompleteMinVersion = 0,
    kDataReceivedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SocketCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendBatchComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DataReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~P2PSocketClient() = default;

  virtual void SocketCreated(const ::net::IPEndPoint& local_address, const ::net::IPEndPoint& remote_address) = 0;

  virtual void SendComplete(const ::network::P2PSendPacketMetrics& send_metrics) = 0;

  virtual void SendBatchComplete(const std::vector<::network::P2PSendPacketMetrics>& send_metrics_batch) = 0;

  virtual void DataReceived(std::vector<P2PReceivedPacketPtr> packets) = 0;
};



class  P2PNetworkNotificationClientProxy
    : public P2PNetworkNotificationClient {
 public:
  using InterfaceType = P2PNetworkNotificationClient;

  explicit P2PNetworkNotificationClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void NetworkListChanged(const std::vector<::net::NetworkInterface>& networks, const ::net::IPAddress& default_ipv4_local_address, const ::net::IPAddress& default_ipv6_local_address) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  P2PSocketManagerProxy
    : public P2PSocketManager {
 public:
  using InterfaceType = P2PSocketManager;

  explicit P2PSocketManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StartNetworkNotifications(::mojo::PendingRemote<P2PNetworkNotificationClient> client) final;
  
  void GetHostAddress(const std::string& host_name, std::optional<::net::AddressFamily> address_family, bool enable_mdns, GetHostAddressCallback callback) final;
  
  void CreateSocket(::network::P2PSocketType type, const ::net::IPEndPoint& local_address, const ::network::P2PPortRange& port_range, const ::network::P2PHostAndIPEndPoint& remote_address, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, const std::optional<::base::UnguessableToken>& devtools_token, ::mojo::PendingRemote<P2PSocketClient> client, ::mojo::PendingReceiver<P2PSocket> socket) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  P2PSocketProxy
    : public P2PSocket {
 public:
  using InterfaceType = P2PSocket;

  explicit P2PSocketProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Send(::base::span<const ::uint8_t> data, const ::network::P2PPacketInfo& packet_info) final;
  
  void SendBatch(std::vector<P2PSendPacketPtr> packet_batch) final;
  
  void SetOption(::network::P2PSocketOption option, int32_t value) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  P2PSocketClientProxy
    : public P2PSocketClient {
 public:
  using InterfaceType = P2PSocketClient;

  explicit P2PSocketClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SocketCreated(const ::net::IPEndPoint& local_address, const ::net::IPEndPoint& remote_address) final;
  
  void SendComplete(const ::network::P2PSendPacketMetrics& send_metrics) final;
  
  void SendBatchComplete(const std::vector<::network::P2PSendPacketMetrics>& send_metrics_batch) final;
  
  void DataReceived(std::vector<P2PReceivedPacketPtr> packets) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  P2PNetworkNotificationClientStubDispatch {
 public:
  static bool Accept(P2PNetworkNotificationClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      P2PNetworkNotificationClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<P2PNetworkNotificationClient>>
class P2PNetworkNotificationClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  P2PNetworkNotificationClientStub() = default;
  ~P2PNetworkNotificationClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return P2PNetworkNotificationClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return P2PNetworkNotificationClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  P2PSocketManagerStubDispatch {
 public:
  static bool Accept(P2PSocketManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      P2PSocketManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<P2PSocketManager>>
class P2PSocketManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  P2PSocketManagerStub() = default;
  ~P2PSocketManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return P2PSocketManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return P2PSocketManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  P2PSocketStubDispatch {
 public:
  static bool Accept(P2PSocket* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      P2PSocket* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<P2PSocket>>
class P2PSocketStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  P2PSocketStub() = default;
  ~P2PSocketStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return P2PSocketStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return P2PSocketStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  P2PSocketClientStubDispatch {
 public:
  static bool Accept(P2PSocketClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      P2PSocketClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<P2PSocketClient>>
class P2PSocketClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  P2PSocketClientStub() = default;
  ~P2PSocketClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return P2PSocketClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return P2PSocketClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  P2PNetworkNotificationClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  P2PSocketManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  P2PSocketRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  P2PSocketClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  P2PSocketManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};

















class  P2PReceivedPacket {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<P2PReceivedPacket, T>::value>;
  using DataView = P2PReceivedPacketDataView;
  using Data_ = internal::P2PReceivedPacket_Data;

  template <typename... Args>
  static P2PReceivedPacketPtr New(Args&&... args) {
    return P2PReceivedPacketPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static P2PReceivedPacketPtr From(const U& u) {
    return mojo::TypeConverter<P2PReceivedPacketPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, P2PReceivedPacket>::Convert(*this);
  }


  P2PReceivedPacket();

  P2PReceivedPacket(
      ::base::span<const ::uint8_t> data,
      const ::net::IPEndPoint& socket_address,
      ::base::TimeTicks timestamp,
      ::webrtc::EcnMarking ecn);


  ~P2PReceivedPacket();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = P2PReceivedPacketPtr>
  P2PReceivedPacketPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, P2PReceivedPacket::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, P2PReceivedPacket::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, P2PReceivedPacket::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        P2PReceivedPacket::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        P2PReceivedPacket::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        P2PReceivedPacket::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::P2PReceivedPacket_UnserializedMessageContext<
            UserType, P2PReceivedPacket::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<P2PReceivedPacket::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return P2PReceivedPacket::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::P2PReceivedPacket_UnserializedMessageContext<
            UserType, P2PReceivedPacket::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<P2PReceivedPacket::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::span<const ::uint8_t> data;
  
  ::net::IPEndPoint socket_address;
  
  ::base::TimeTicks timestamp;
  
  ::webrtc::EcnMarking ecn;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, P2PReceivedPacket::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, P2PReceivedPacket::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, P2PReceivedPacket::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, P2PReceivedPacket::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  P2PSendPacket {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<P2PSendPacket, T>::value>;
  using DataView = P2PSendPacketDataView;
  using Data_ = internal::P2PSendPacket_Data;

  template <typename... Args>
  static P2PSendPacketPtr New(Args&&... args) {
    return P2PSendPacketPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static P2PSendPacketPtr From(const U& u) {
    return mojo::TypeConverter<P2PSendPacketPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, P2PSendPacket>::Convert(*this);
  }


  P2PSendPacket();

  P2PSendPacket(
      ::base::span<const ::uint8_t> data,
      const ::network::P2PPacketInfo& packet_info);


  ~P2PSendPacket();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = P2PSendPacketPtr>
  P2PSendPacketPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, P2PSendPacket::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, P2PSendPacket::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, P2PSendPacket::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        P2PSendPacket::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        P2PSendPacket::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        P2PSendPacket::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::P2PSendPacket_UnserializedMessageContext<
            UserType, P2PSendPacket::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<P2PSendPacket::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return P2PSendPacket::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::P2PSendPacket_UnserializedMessageContext<
            UserType, P2PSendPacket::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<P2PSendPacket::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::span<const ::uint8_t> data;
  
  ::network::P2PPacketInfo packet_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, P2PSendPacket::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, P2PSendPacket::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, P2PSendPacket::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, P2PSendPacket::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
P2PReceivedPacketPtr P2PReceivedPacket::Clone() const {
  return New(
      mojo::Clone(data),
      mojo::Clone(socket_address),
      mojo::Clone(timestamp),
      mojo::Clone(ecn)
  );
}

template <typename T, P2PReceivedPacket::EnableIfSame<T>*>
bool P2PReceivedPacket::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->socket_address, other_struct.socket_address))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->ecn, other_struct.ecn))
    return false;
  return true;
}

template <typename T, P2PReceivedPacket::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  if (lhs.socket_address < rhs.socket_address)
    return true;
  if (rhs.socket_address < lhs.socket_address)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.ecn < rhs.ecn)
    return true;
  if (rhs.ecn < lhs.ecn)
    return false;
  return false;
}
template <typename StructPtrType>
P2PSendPacketPtr P2PSendPacket::Clone() const {
  return New(
      mojo::Clone(data),
      mojo::Clone(packet_info)
  );
}

template <typename T, P2PSendPacket::EnableIfSame<T>*>
bool P2PSendPacket::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->packet_info, other_struct.packet_info))
    return false;
  return true;
}

template <typename T, P2PSendPacket::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  if (lhs.packet_info < rhs.packet_info)
    return true;
  if (rhs.packet_info < lhs.packet_info)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::P2PReceivedPacket::DataView,
                                         ::network::mojom::P2PReceivedPacketPtr> {
  static bool IsNull(const ::network::mojom::P2PReceivedPacketPtr& input) { return !input; }
  static void SetToNull(::network::mojom::P2PReceivedPacketPtr* output) { output->reset(); }

  static const decltype(::network::mojom::P2PReceivedPacket::data)& data(
      const ::network::mojom::P2PReceivedPacketPtr& input) {
    return input->data;
  }

  static const decltype(::network::mojom::P2PReceivedPacket::socket_address)& socket_address(
      const ::network::mojom::P2PReceivedPacketPtr& input) {
    return input->socket_address;
  }

  static const decltype(::network::mojom::P2PReceivedPacket::timestamp)& timestamp(
      const ::network::mojom::P2PReceivedPacketPtr& input) {
    return input->timestamp;
  }

  static decltype(::network::mojom::P2PReceivedPacket::ecn) ecn(
      const ::network::mojom::P2PReceivedPacketPtr& input) {
    return input->ecn;
  }

  static bool Read(::network::mojom::P2PReceivedPacket::DataView input, ::network::mojom::P2PReceivedPacketPtr* output);
};


template <>
struct  StructTraits<::network::mojom::P2PSendPacket::DataView,
                                         ::network::mojom::P2PSendPacketPtr> {
  static bool IsNull(const ::network::mojom::P2PSendPacketPtr& input) { return !input; }
  static void SetToNull(::network::mojom::P2PSendPacketPtr* output) { output->reset(); }

  static const decltype(::network::mojom::P2PSendPacket::data)& data(
      const ::network::mojom::P2PSendPacketPtr& input) {
    return input->data;
  }

  static const decltype(::network::mojom::P2PSendPacket::packet_info)& packet_info(
      const ::network::mojom::P2PSendPacketPtr& input) {
    return input->packet_info;
  }

  static bool Read(::network::mojom::P2PSendPacket::DataView input, ::network::mojom::P2PSendPacketPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_P2P_MOJOM_H_