// services/network/public/mojom/p2p.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_P2P_MOJOM_SHARED_INTERNAL_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_P2P_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/message_fragment.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared-internal.h"
#include "services/network/public/mojom/address_family.mojom-shared-internal.h"
#include "services/network/public/mojom/network_interface.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_address.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared-internal.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace network::mojom {
namespace internal {
using P2PHostAndIPEndPoint_Data = mojo::native::internal::NativeStruct_Data;
using P2PPacketInfo_Data = mojo::native::internal::NativeStruct_Data;
using P2PPortRange_Data = mojo::native::internal::NativeStruct_Data;
using P2PSendPacketMetrics_Data = mojo::native::internal::NativeStruct_Data;
class P2PReceivedPacket_Data;
class P2PSendPacket_Data;
using P2PSocketType_Data =
    mojo::internal::NativeEnum_Data;
using P2PSocketOption_Data =
    mojo::internal::NativeEnum_Data;

struct EcnMarking_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  P2PReceivedPacket_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlyBuffer_Data> data;
  mojo::internal::Pointer<::network::mojom::internal::IPEndPoint_Data> socket_address;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> timestamp;
  int32_t ecn;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<P2PReceivedPacket_Data>;

  P2PReceivedPacket_Data();
  ~P2PReceivedPacket_Data() = delete;
};
static_assert(sizeof(P2PReceivedPacket_Data) == 40,
              "Bad sizeof(P2PReceivedPacket_Data)");
// Used by P2PReceivedPacket::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct P2PReceivedPacket_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  P2PReceivedPacket_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~P2PReceivedPacket_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<P2PReceivedPacket_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    P2PReceivedPacket_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  P2PSendPacket_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlyBuffer_Data> data;
  mojo::internal::Pointer<internal::P2PPacketInfo_Data> packet_info;

 private:
  friend class mojo::internal::MessageFragment<P2PSendPacket_Data>;

  P2PSendPacket_Data();
  ~P2PSendPacket_Data() = delete;
};
static_assert(sizeof(P2PSendPacket_Data) == 24,
              "Bad sizeof(P2PSendPacket_Data)");
// Used by P2PSendPacket::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct P2PSendPacket_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  P2PSendPacket_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~P2PSendPacket_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<P2PSendPacket_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    P2PSendPacket_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_P2P_MOJOM_SHARED_INTERNAL_H_