// services/network/public/mojom/p2p.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('network.mojom.AddressFamily');
goog.require('network.mojom.IPAddress');
goog.require('network.mojom.IPEndPoint');
goog.require('network.mojom.MutableNetworkTrafficAnnotationTag');
goog.require('network.mojom.NetworkInterface');
goog.require('mojoBase.mojom.ReadOnlyBuffer');
goog.require('mojoBase.mojom.TimeTicks');
goog.require('mojoBase.mojom.UnguessableToken');




goog.provide('network.mojom.P2PSocketType');
goog.provide('network.mojom.P2PSocketTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.P2PSocketTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.P2PSocketType = {
  
};

goog.provide('network.mojom.P2PSocketOption');
goog.provide('network.mojom.P2PSocketOptionSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.P2PSocketOptionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.P2PSocketOption = {
  
};

goog.provide('network.mojom.EcnMarking');
goog.provide('network.mojom.EcnMarkingSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.EcnMarkingSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.EcnMarking = {
  
  kNotEct: 0,
  kEct1: 1,
  kEct0: 2,
  kCe: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



goog.provide('network.mojom.P2PNetworkNotificationClient');
goog.provide('network.mojom.P2PNetworkNotificationClientReceiver');
goog.provide('network.mojom.P2PNetworkNotificationClientCallbackRouter');
goog.provide('network.mojom.P2PNetworkNotificationClientInterface');
goog.provide('network.mojom.P2PNetworkNotificationClientRemote');
goog.provide('network.mojom.P2PNetworkNotificationClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.P2PNetworkNotificationClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.P2PNetworkNotificationClient.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.P2PNetworkNotificationClientInterface = class {
  
  /**
   * @param { !Array<!network.mojom.NetworkInterface> } networks
   * @param { !network.mojom.IPAddress } defaultIpv4LocalAddress
   * @param { !network.mojom.IPAddress } defaultIpv6LocalAddress
   */

  networkListChanged(networks, defaultIpv4LocalAddress, defaultIpv6LocalAddress) {}
};

/**
 * @export
 * @implements { network.mojom.P2PNetworkNotificationClientInterface }
 */
network.mojom.P2PNetworkNotificationClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.P2PNetworkNotificationClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.P2PNetworkNotificationClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.P2PNetworkNotificationClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!network.mojom.NetworkInterface> } networks
   * @param { !network.mojom.IPAddress } defaultIpv4LocalAddress
   * @param { !network.mojom.IPAddress } defaultIpv6LocalAddress
   */

  networkListChanged(
      networks,
      defaultIpv4LocalAddress,
      defaultIpv6LocalAddress) {
    this.proxy.sendMessage(
        0,
        network.mojom.P2PNetworkNotificationClient_NetworkListChanged_ParamsSpec.$,
        null,
        [
          networks,
          defaultIpv4LocalAddress,
          defaultIpv6LocalAddress
        ],
        false);
  }
};

/**
 * An object which receives request messages for the P2PNetworkNotificationClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.P2PNetworkNotificationClientReceiver = class {
  /**
   * @param {!network.mojom.P2PNetworkNotificationClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.P2PNetworkNotificationClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.P2PNetworkNotificationClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.P2PNetworkNotificationClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.P2PNetworkNotificationClient_NetworkListChanged_ParamsSpec.$,
        null,
        impl.networkListChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.P2PNetworkNotificationClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.P2PNetworkNotificationClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.P2PNetworkNotificationClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.P2PNetworkNotificationClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the P2PNetworkNotificationClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.P2PNetworkNotificationClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.P2PNetworkNotificationClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.P2PNetworkNotificationClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.networkListChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.P2PNetworkNotificationClient_NetworkListChanged_ParamsSpec.$,
        null,
        this.networkListChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.P2PSocketManager');
goog.provide('network.mojom.P2PSocketManagerReceiver');
goog.provide('network.mojom.P2PSocketManagerCallbackRouter');
goog.provide('network.mojom.P2PSocketManagerInterface');
goog.provide('network.mojom.P2PSocketManagerRemote');
goog.provide('network.mojom.P2PSocketManagerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.P2PSocketManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.P2PSocketManager.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.P2PSocketManagerInterface = class {
  
  /**
   * @param { !network.mojom.P2PNetworkNotificationClientRemote } client
   */

  startNetworkNotifications(client) {}
  
  /**
   * @param { !string } hostName
   * @param { ?network.mojom.AddressFamily } addressFamily
   * @param { !boolean } enableMdns
   * @return {!Promise<{
        addresses: !Array<!network.mojom.IPAddress>,
   *  }>}
   */

  getHostAddress(hostName, addressFamily, enableMdns) {}
  
  /**
   * @param { !network.mojom.P2PSocketType } type
   * @param { !network.mojom.IPEndPoint } localAddress
   * @param { !network.mojom.P2PPortRange } portRange
   * @param { !network.mojom.P2PHostAndIPEndPoint } remoteAddress
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { ?mojoBase.mojom.UnguessableToken } devtoolsToken
   * @param { !network.mojom.P2PSocketClientRemote } client
   * @param { !network.mojom.P2PSocketPendingReceiver } socket
   */

  createSocket(type, localAddress, portRange, remoteAddress, trafficAnnotation, devtoolsToken, client, socket) {}
};

/**
 * @export
 * @implements { network.mojom.P2PSocketManagerInterface }
 */
network.mojom.P2PSocketManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.P2PSocketManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.P2PSocketManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.P2PSocketManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.P2PNetworkNotificationClientRemote } client
   */

  startNetworkNotifications(
      client) {
    this.proxy.sendMessage(
        0,
        network.mojom.P2PSocketManager_StartNetworkNotifications_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }

  
  /**
   * @param { !string } hostName
   * @param { ?network.mojom.AddressFamily } addressFamily
   * @param { !boolean } enableMdns
   * @return {!Promise<{
        addresses: !Array<!network.mojom.IPAddress>,
   *  }>}
   */

  getHostAddress(
      hostName,
      addressFamily,
      enableMdns) {
    return this.proxy.sendMessage(
        1,
        network.mojom.P2PSocketManager_GetHostAddress_ParamsSpec.$,
        network.mojom.P2PSocketManager_GetHostAddress_ResponseParamsSpec.$,
        [
          hostName,
          addressFamily,
          enableMdns
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.P2PSocketType } type
   * @param { !network.mojom.IPEndPoint } localAddress
   * @param { !network.mojom.P2PPortRange } portRange
   * @param { !network.mojom.P2PHostAndIPEndPoint } remoteAddress
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { ?mojoBase.mojom.UnguessableToken } devtoolsToken
   * @param { !network.mojom.P2PSocketClientRemote } client
   * @param { !network.mojom.P2PSocketPendingReceiver } socket
   */

  createSocket(
      type,
      localAddress,
      portRange,
      remoteAddress,
      trafficAnnotation,
      devtoolsToken,
      client,
      socket) {
    this.proxy.sendMessage(
        2,
        network.mojom.P2PSocketManager_CreateSocket_ParamsSpec.$,
        null,
        [
          type,
          localAddress,
          portRange,
          remoteAddress,
          trafficAnnotation,
          devtoolsToken,
          client,
          socket
        ],
        false);
  }
};

/**
 * An object which receives request messages for the P2PSocketManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.P2PSocketManagerReceiver = class {
  /**
   * @param {!network.mojom.P2PSocketManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.P2PSocketManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.P2PSocketManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.P2PSocketManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.P2PSocketManager_StartNetworkNotifications_ParamsSpec.$,
        null,
        impl.startNetworkNotifications.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.P2PSocketManager_GetHostAddress_ParamsSpec.$,
        network.mojom.P2PSocketManager_GetHostAddress_ResponseParamsSpec.$,
        impl.getHostAddress.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.P2PSocketManager_CreateSocket_ParamsSpec.$,
        null,
        impl.createSocket.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.P2PSocketManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.P2PSocketManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.P2PSocketManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.P2PSocketManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the P2PSocketManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.P2PSocketManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.P2PSocketManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.P2PSocketManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startNetworkNotifications =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.P2PSocketManager_StartNetworkNotifications_ParamsSpec.$,
        null,
        this.startNetworkNotifications.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getHostAddress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.P2PSocketManager_GetHostAddress_ParamsSpec.$,
        network.mojom.P2PSocketManager_GetHostAddress_ResponseParamsSpec.$,
        this.getHostAddress.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.P2PSocketManager_CreateSocket_ParamsSpec.$,
        null,
        this.createSocket.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.P2PSocket');
goog.provide('network.mojom.P2PSocketReceiver');
goog.provide('network.mojom.P2PSocketCallbackRouter');
goog.provide('network.mojom.P2PSocketInterface');
goog.provide('network.mojom.P2PSocketRemote');
goog.provide('network.mojom.P2PSocketPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.P2PSocketPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.P2PSocket.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.P2PSocketInterface = class {
  
  /**
   * @param { !mojoBase.mojom.ReadOnlyBuffer } data
   * @param { !network.mojom.P2PPacketInfo } packetInfo
   */

  send(data, packetInfo) {}
  
  /**
   * @param { !Array<!network.mojom.P2PSendPacket> } packetBatch
   */

  sendBatch(packetBatch) {}
  
  /**
   * @param { !network.mojom.P2PSocketOption } option
   * @param { !number } value
   */

  setOption(option, value) {}
};

/**
 * @export
 * @implements { network.mojom.P2PSocketInterface }
 */
network.mojom.P2PSocketRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.P2PSocketPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.P2PSocketPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.P2PSocketPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase.mojom.ReadOnlyBuffer } data
   * @param { !network.mojom.P2PPacketInfo } packetInfo
   */

  send(
      data,
      packetInfo) {
    this.proxy.sendMessage(
        0,
        network.mojom.P2PSocket_Send_ParamsSpec.$,
        null,
        [
          data,
          packetInfo
        ],
        false);
  }

  
  /**
   * @param { !Array<!network.mojom.P2PSendPacket> } packetBatch
   */

  sendBatch(
      packetBatch) {
    this.proxy.sendMessage(
        1,
        network.mojom.P2PSocket_SendBatch_ParamsSpec.$,
        null,
        [
          packetBatch
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.P2PSocketOption } option
   * @param { !number } value
   */

  setOption(
      option,
      value) {
    this.proxy.sendMessage(
        2,
        network.mojom.P2PSocket_SetOption_ParamsSpec.$,
        null,
        [
          option,
          value
        ],
        false);
  }
};

/**
 * An object which receives request messages for the P2PSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.P2PSocketReceiver = class {
  /**
   * @param {!network.mojom.P2PSocketInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.P2PSocketRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.P2PSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.P2PSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.P2PSocket_Send_ParamsSpec.$,
        null,
        impl.send.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.P2PSocket_SendBatch_ParamsSpec.$,
        null,
        impl.sendBatch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.P2PSocket_SetOption_ParamsSpec.$,
        null,
        impl.setOption.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.P2PSocket = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.P2PSocket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.P2PSocketRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.P2PSocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the P2PSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.P2PSocketCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.P2PSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.P2PSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.send =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.P2PSocket_Send_ParamsSpec.$,
        null,
        this.send.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendBatch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.P2PSocket_SendBatch_ParamsSpec.$,
        null,
        this.sendBatch.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setOption =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.P2PSocket_SetOption_ParamsSpec.$,
        null,
        this.setOption.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.P2PSocketClient');
goog.provide('network.mojom.P2PSocketClientReceiver');
goog.provide('network.mojom.P2PSocketClientCallbackRouter');
goog.provide('network.mojom.P2PSocketClientInterface');
goog.provide('network.mojom.P2PSocketClientRemote');
goog.provide('network.mojom.P2PSocketClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.P2PSocketClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.P2PSocketClient.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.P2PSocketClientInterface = class {
  
  /**
   * @param { !network.mojom.IPEndPoint } localAddress
   * @param { !network.mojom.IPEndPoint } remoteAddress
   */

  socketCreated(localAddress, remoteAddress) {}
  
  /**
   * @param { !network.mojom.P2PSendPacketMetrics } sendMetrics
   */

  sendComplete(sendMetrics) {}
  
  /**
   * @param { !Array<!network.mojom.P2PSendPacketMetrics> } sendMetricsBatch
   */

  sendBatchComplete(sendMetricsBatch) {}
  
  /**
   * @param { !Array<!network.mojom.P2PReceivedPacket> } packets
   */

  dataReceived(packets) {}
};

/**
 * @export
 * @implements { network.mojom.P2PSocketClientInterface }
 */
network.mojom.P2PSocketClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.P2PSocketClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.P2PSocketClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.P2PSocketClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.IPEndPoint } localAddress
   * @param { !network.mojom.IPEndPoint } remoteAddress
   */

  socketCreated(
      localAddress,
      remoteAddress) {
    this.proxy.sendMessage(
        0,
        network.mojom.P2PSocketClient_SocketCreated_ParamsSpec.$,
        null,
        [
          localAddress,
          remoteAddress
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.P2PSendPacketMetrics } sendMetrics
   */

  sendComplete(
      sendMetrics) {
    this.proxy.sendMessage(
        1,
        network.mojom.P2PSocketClient_SendComplete_ParamsSpec.$,
        null,
        [
          sendMetrics
        ],
        false);
  }

  
  /**
   * @param { !Array<!network.mojom.P2PSendPacketMetrics> } sendMetricsBatch
   */

  sendBatchComplete(
      sendMetricsBatch) {
    this.proxy.sendMessage(
        2,
        network.mojom.P2PSocketClient_SendBatchComplete_ParamsSpec.$,
        null,
        [
          sendMetricsBatch
        ],
        false);
  }

  
  /**
   * @param { !Array<!network.mojom.P2PReceivedPacket> } packets
   */

  dataReceived(
      packets) {
    this.proxy.sendMessage(
        3,
        network.mojom.P2PSocketClient_DataReceived_ParamsSpec.$,
        null,
        [
          packets
        ],
        false);
  }
};

/**
 * An object which receives request messages for the P2PSocketClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.P2PSocketClientReceiver = class {
  /**
   * @param {!network.mojom.P2PSocketClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.P2PSocketClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.P2PSocketClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.P2PSocketClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.P2PSocketClient_SocketCreated_ParamsSpec.$,
        null,
        impl.socketCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.P2PSocketClient_SendComplete_ParamsSpec.$,
        null,
        impl.sendComplete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.P2PSocketClient_SendBatchComplete_ParamsSpec.$,
        null,
        impl.sendBatchComplete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.P2PSocketClient_DataReceived_ParamsSpec.$,
        null,
        impl.dataReceived.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.P2PSocketClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.P2PSocketClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.P2PSocketClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.P2PSocketClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the P2PSocketClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.P2PSocketClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.P2PSocketClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.P2PSocketClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.socketCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.P2PSocketClient_SocketCreated_ParamsSpec.$,
        null,
        this.socketCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.P2PSocketClient_SendComplete_ParamsSpec.$,
        null,
        this.sendComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendBatchComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.P2PSocketClient_SendBatchComplete_ParamsSpec.$,
        null,
        this.sendBatchComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dataReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.P2PSocketClient_DataReceived_ParamsSpec.$,
        null,
        this.dataReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.P2PHostAndIPEndPointSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PHostAndIPEndPointSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.P2PPacketInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PPacketInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.P2PPortRangeSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PPortRangeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.P2PSendPacketMetricsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PSendPacketMetricsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.P2PReceivedPacketSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PReceivedPacketSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.P2PSendPacketSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PSendPacketSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.P2PNetworkNotificationClient_NetworkListChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PNetworkNotificationClient_NetworkListChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.P2PSocketManager_StartNetworkNotifications_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PSocketManager_StartNetworkNotifications_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.P2PSocketManager_GetHostAddress_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PSocketManager_GetHostAddress_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.P2PSocketManager_GetHostAddress_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PSocketManager_GetHostAddress_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.P2PSocketManager_CreateSocket_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PSocketManager_CreateSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.P2PSocket_Send_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PSocket_Send_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.P2PSocket_SendBatch_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PSocket_SendBatch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.P2PSocket_SetOption_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PSocket_SetOption_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.P2PSocketClient_SocketCreated_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PSocketClient_SocketCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.P2PSocketClient_SendComplete_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PSocketClient_SendComplete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.P2PSocketClient_SendBatchComplete_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PSocketClient_SendBatchComplete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.P2PSocketClient_DataReceived_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.P2PSocketClient_DataReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.P2PHostAndIPEndPointSpec.$,
    'P2PHostAndIPEndPoint',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.P2PHostAndIPEndPoint');

/** @record */
network.mojom.P2PHostAndIPEndPoint = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.P2PPacketInfoSpec.$,
    'P2PPacketInfo',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.P2PPacketInfo');

/** @record */
network.mojom.P2PPacketInfo = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.P2PPortRangeSpec.$,
    'P2PPortRange',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.P2PPortRange');

/** @record */
network.mojom.P2PPortRange = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.P2PSendPacketMetricsSpec.$,
    'P2PSendPacketMetrics',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.P2PSendPacketMetrics');

/** @record */
network.mojom.P2PSendPacketMetrics = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.P2PReceivedPacketSpec.$,
    'P2PReceivedPacket',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase.mojom.ReadOnlyBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'socketAddress', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timestamp', 16,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ecn', 24,
        0,
        network.mojom.EcnMarkingSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.P2PReceivedPacket');

/** @record */
network.mojom.P2PReceivedPacket = class {
  constructor() {
    /** @export { !mojoBase.mojom.ReadOnlyBuffer } */
    this.data;
    /** @export { !network.mojom.IPEndPoint } */
    this.socketAddress;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.timestamp;
    /** @export { !network.mojom.EcnMarking } */
    this.ecn;
  }
};



mojo.internal.Struct(
    network.mojom.P2PSendPacketSpec.$,
    'P2PSendPacket',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase.mojom.ReadOnlyBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'packetInfo', 8,
        0,
        network.mojom.P2PPacketInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.P2PSendPacket');

/** @record */
network.mojom.P2PSendPacket = class {
  constructor() {
    /** @export { !mojoBase.mojom.ReadOnlyBuffer } */
    this.data;
    /** @export { !network.mojom.P2PPacketInfo } */
    this.packetInfo;
  }
};



mojo.internal.Struct(
    network.mojom.P2PNetworkNotificationClient_NetworkListChanged_ParamsSpec.$,
    'P2PNetworkNotificationClient_NetworkListChanged_Params',
    [
      mojo.internal.StructField(
        'networks', 0,
        0,
        mojo.internal.Array(network.mojom.NetworkInterfaceSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'defaultIpv4LocalAddress', 8,
        0,
        network.mojom.IPAddressSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'defaultIpv6LocalAddress', 16,
        0,
        network.mojom.IPAddressSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.P2PNetworkNotificationClient_NetworkListChanged_Params');

/** @record */
network.mojom.P2PNetworkNotificationClient_NetworkListChanged_Params = class {
  constructor() {
    /** @export { !Array<!network.mojom.NetworkInterface> } */
    this.networks;
    /** @export { !network.mojom.IPAddress } */
    this.defaultIpv4LocalAddress;
    /** @export { !network.mojom.IPAddress } */
    this.defaultIpv6LocalAddress;
  }
};



mojo.internal.Struct(
    network.mojom.P2PSocketManager_StartNetworkNotifications_ParamsSpec.$,
    'P2PSocketManager_StartNetworkNotifications_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(network.mojom.P2PNetworkNotificationClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.P2PSocketManager_StartNetworkNotifications_Params');

/** @record */
network.mojom.P2PSocketManager_StartNetworkNotifications_Params = class {
  constructor() {
    /** @export { !network.mojom.P2PNetworkNotificationClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    network.mojom.P2PSocketManager_GetHostAddress_ParamsSpec.$,
    'P2PSocketManager_GetHostAddress_Params',
    [
      mojo.internal.StructField(
        'hostName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'address_family_$flag', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "address_family_$value",
          originalFieldName: "addressFamily",
        }
      ),
      mojo.internal.StructField(
        'address_family_$value', 12,
        0,
        network.mojom.AddressFamilySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "addressFamily",
        }
      ),
      mojo.internal.StructField(
        'enableMdns', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.P2PSocketManager_GetHostAddress_Params');

/** @record */
network.mojom.P2PSocketManager_GetHostAddress_Params = class {
  constructor() {
    /** @export { !string } */
    this.hostName;
    /** @export { (network.mojom.AddressFamily|undefined) } */
    this.addressFamily;
    /** @export { !boolean } */
    this.enableMdns;
  }
};



mojo.internal.Struct(
    network.mojom.P2PSocketManager_GetHostAddress_ResponseParamsSpec.$,
    'P2PSocketManager_GetHostAddress_ResponseParams',
    [
      mojo.internal.StructField(
        'addresses', 0,
        0,
        mojo.internal.Array(network.mojom.IPAddressSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.P2PSocketManager_GetHostAddress_ResponseParams');

/** @record */
network.mojom.P2PSocketManager_GetHostAddress_ResponseParams = class {
  constructor() {
    /** @export { !Array<!network.mojom.IPAddress> } */
    this.addresses;
  }
};



mojo.internal.Struct(
    network.mojom.P2PSocketManager_CreateSocket_ParamsSpec.$,
    'P2PSocketManager_CreateSocket_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        network.mojom.P2PSocketTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localAddress', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'portRange', 16,
        0,
        network.mojom.P2PPortRangeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteAddress', 24,
        0,
        network.mojom.P2PHostAndIPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 32,
        0,
        network.mojom.MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'devtoolsToken', 40,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 48,
        0,
        mojo.internal.InterfaceProxy(network.mojom.P2PSocketClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'socket', 4,
        0,
        mojo.internal.InterfaceRequest(network.mojom.P2PSocketPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);



goog.provide('network.mojom.P2PSocketManager_CreateSocket_Params');

/** @record */
network.mojom.P2PSocketManager_CreateSocket_Params = class {
  constructor() {
    /** @export { !network.mojom.P2PSocketType } */
    this.type;
    /** @export { !network.mojom.IPEndPoint } */
    this.localAddress;
    /** @export { !network.mojom.P2PPortRange } */
    this.portRange;
    /** @export { !network.mojom.P2PHostAndIPEndPoint } */
    this.remoteAddress;
    /** @export { !network.mojom.MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.devtoolsToken;
    /** @export { !network.mojom.P2PSocketClientRemote } */
    this.client;
    /** @export { !network.mojom.P2PSocketPendingReceiver } */
    this.socket;
  }
};



mojo.internal.Struct(
    network.mojom.P2PSocket_Send_ParamsSpec.$,
    'P2PSocket_Send_Params',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase.mojom.ReadOnlyBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'packetInfo', 8,
        0,
        network.mojom.P2PPacketInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.P2PSocket_Send_Params');

/** @record */
network.mojom.P2PSocket_Send_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.ReadOnlyBuffer } */
    this.data;
    /** @export { !network.mojom.P2PPacketInfo } */
    this.packetInfo;
  }
};



mojo.internal.Struct(
    network.mojom.P2PSocket_SendBatch_ParamsSpec.$,
    'P2PSocket_SendBatch_Params',
    [
      mojo.internal.StructField(
        'packetBatch', 0,
        0,
        mojo.internal.Array(network.mojom.P2PSendPacketSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.P2PSocket_SendBatch_Params');

/** @record */
network.mojom.P2PSocket_SendBatch_Params = class {
  constructor() {
    /** @export { !Array<!network.mojom.P2PSendPacket> } */
    this.packetBatch;
  }
};



mojo.internal.Struct(
    network.mojom.P2PSocket_SetOption_ParamsSpec.$,
    'P2PSocket_SetOption_Params',
    [
      mojo.internal.StructField(
        'option', 0,
        0,
        network.mojom.P2PSocketOptionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.P2PSocket_SetOption_Params');

/** @record */
network.mojom.P2PSocket_SetOption_Params = class {
  constructor() {
    /** @export { !network.mojom.P2PSocketOption } */
    this.option;
    /** @export { !number } */
    this.value;
  }
};



mojo.internal.Struct(
    network.mojom.P2PSocketClient_SocketCreated_ParamsSpec.$,
    'P2PSocketClient_SocketCreated_Params',
    [
      mojo.internal.StructField(
        'localAddress', 0,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteAddress', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.P2PSocketClient_SocketCreated_Params');

/** @record */
network.mojom.P2PSocketClient_SocketCreated_Params = class {
  constructor() {
    /** @export { !network.mojom.IPEndPoint } */
    this.localAddress;
    /** @export { !network.mojom.IPEndPoint } */
    this.remoteAddress;
  }
};



mojo.internal.Struct(
    network.mojom.P2PSocketClient_SendComplete_ParamsSpec.$,
    'P2PSocketClient_SendComplete_Params',
    [
      mojo.internal.StructField(
        'sendMetrics', 0,
        0,
        network.mojom.P2PSendPacketMetricsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.P2PSocketClient_SendComplete_Params');

/** @record */
network.mojom.P2PSocketClient_SendComplete_Params = class {
  constructor() {
    /** @export { !network.mojom.P2PSendPacketMetrics } */
    this.sendMetrics;
  }
};



mojo.internal.Struct(
    network.mojom.P2PSocketClient_SendBatchComplete_ParamsSpec.$,
    'P2PSocketClient_SendBatchComplete_Params',
    [
      mojo.internal.StructField(
        'sendMetricsBatch', 0,
        0,
        mojo.internal.Array(network.mojom.P2PSendPacketMetricsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.P2PSocketClient_SendBatchComplete_Params');

/** @record */
network.mojom.P2PSocketClient_SendBatchComplete_Params = class {
  constructor() {
    /** @export { !Array<!network.mojom.P2PSendPacketMetrics> } */
    this.sendMetricsBatch;
  }
};



mojo.internal.Struct(
    network.mojom.P2PSocketClient_DataReceived_ParamsSpec.$,
    'P2PSocketClient_DataReceived_Params',
    [
      mojo.internal.StructField(
        'packets', 0,
        0,
        mojo.internal.Array(network.mojom.P2PReceivedPacketSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.P2PSocketClient_DataReceived_Params');

/** @record */
network.mojom.P2PSocketClient_DataReceived_Params = class {
  constructor() {
    /** @export { !Array<!network.mojom.P2PReceivedPacket> } */
    this.packets;
  }
};

