// services/network/public/mojom/oblivious_http_request.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_OBLIVIOUS_HTTP_REQUEST_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_OBLIVIOUS_HTTP_REQUEST_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/oblivious_http_request.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/isolation_info.mojom-shared.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "services/network/public/mojom/oblivious_http_request.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::ObliviousHttpRequestBodyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ObliviousHttpRequestBodyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ObliviousHttpRequestBody_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::content(input)) in_content = Traits::content(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content)::BaseType> content_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView, send_validation>(
        in_content,
        content_fragment);

      fragment->content.Set(
          content_fragment.is_null() ? nullptr : content_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->content.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content in ObliviousHttpRequestBody struct");

      decltype(Traits::content_type(input)) in_content_type = Traits::content_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content_type)::BaseType> content_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_content_type,
        content_type_fragment);

      fragment->content_type.Set(
          content_type_fragment.is_null() ? nullptr : content_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->content_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_type in ObliviousHttpRequestBody struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::ObliviousHttpResponseDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ObliviousHttpResponseDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ObliviousHttpResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->response_code = Traits::response_code(input);

      decltype(Traits::headers(input)) in_headers = Traits::headers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->headers)::BaseType> headers_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::HttpResponseHeadersDataView, send_validation>(
        in_headers,
        headers_fragment);

      fragment->headers.Set(
          headers_fragment.is_null() ? nullptr : headers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->headers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers in ObliviousHttpResponse struct");

      decltype(Traits::response_body(input)) in_response_body = Traits::response_body(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->response_body)::BaseType> response_body_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView, send_validation>(
        in_response_body,
        response_body_fragment);

      fragment->response_body.Set(
          response_body_fragment.is_null() ? nullptr : response_body_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->response_body.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response_body in ObliviousHttpResponse struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::ObliviousHttpPaddingParametersDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ObliviousHttpPaddingParametersDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ObliviousHttpPaddingParameters_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->add_exponential_pad = Traits::add_exponential_pad(input);

      fragment->exponential_mean = Traits::exponential_mean(input);

      fragment->pad_to_next_power_of_two = Traits::pad_to_next_power_of_two(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::ObliviousHttpRequestDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ObliviousHttpRequestDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ObliviousHttpRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::relay_url(input)) in_relay_url = Traits::relay_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->relay_url)::BaseType> relay_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_relay_url,
        relay_url_fragment);

      fragment->relay_url.Set(
          relay_url_fragment.is_null() ? nullptr : relay_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->relay_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null relay_url in ObliviousHttpRequest struct");

      decltype(Traits::traffic_annotation(input)) in_traffic_annotation = Traits::traffic_annotation(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->traffic_annotation)::BaseType> traffic_annotation_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView, send_validation>(
        in_traffic_annotation,
        traffic_annotation_fragment);

      fragment->traffic_annotation.Set(
          traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->traffic_annotation.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null traffic_annotation in ObliviousHttpRequest struct");

      decltype(Traits::timeout_duration(input)) in_timeout_duration = Traits::timeout_duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->timeout_duration)::BaseType> timeout_duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_timeout_duration,
        timeout_duration_fragment);

      fragment->timeout_duration.Set(
          timeout_duration_fragment.is_null() ? nullptr : timeout_duration_fragment.data());

      decltype(Traits::key_config(input)) in_key_config = Traits::key_config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->key_config)::BaseType> key_config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_key_config,
        key_config_fragment);

      fragment->key_config.Set(
          key_config_fragment.is_null() ? nullptr : key_config_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->key_config.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key_config in ObliviousHttpRequest struct");

      decltype(Traits::resource_url(input)) in_resource_url = Traits::resource_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->resource_url)::BaseType> resource_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_resource_url,
        resource_url_fragment);

      fragment->resource_url.Set(
          resource_url_fragment.is_null() ? nullptr : resource_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->resource_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null resource_url in ObliviousHttpRequest struct");

      decltype(Traits::method(input)) in_method = Traits::method(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->method)::BaseType> method_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_method,
        method_fragment);

      fragment->method.Set(
          method_fragment.is_null() ? nullptr : method_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->method.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null method in ObliviousHttpRequest struct");

      decltype(Traits::request_body(input)) in_request_body = Traits::request_body(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->request_body)::BaseType> request_body_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ObliviousHttpRequestBodyDataView, send_validation>(
        in_request_body,
        request_body_fragment);

      fragment->request_body.Set(
          request_body_fragment.is_null() ? nullptr : request_body_fragment.data());

      decltype(Traits::trust_token_params(input)) in_trust_token_params = Traits::trust_token_params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->trust_token_params)::BaseType> trust_token_params_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::TrustTokenParamsDataView, send_validation>(
        in_trust_token_params,
        trust_token_params_fragment);

      fragment->trust_token_params.Set(
          trust_token_params_fragment.is_null() ? nullptr : trust_token_params_fragment.data());

      decltype(Traits::padding_params(input)) in_padding_params = Traits::padding_params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->padding_params)::BaseType> padding_params_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ObliviousHttpPaddingParametersDataView, send_validation>(
        in_padding_params,
        padding_params_fragment);

      fragment->padding_params.Set(
          padding_params_fragment.is_null() ? nullptr : padding_params_fragment.data());
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::ObliviousHttpCompletionResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::ObliviousHttpCompletionResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::ObliviousHttpCompletionResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::network::mojom::ObliviousHttpCompletionResultDataView::Tag::kNetError: {
    decltype(Traits::net_error(input))
    in_net_error = Traits::net_error(input);
    fragment->data.f_net_error = in_net_error;
    break;
  }
  case ::network::mojom::ObliviousHttpCompletionResultDataView::Tag::kOuterResponseErrorCode: {
    decltype(Traits::outer_response_error_code(input))
    in_outer_response_error_code = Traits::outer_response_error_code(input);
    fragment->data.f_outer_response_error_code = in_outer_response_error_code;
    break;
  }
  case ::network::mojom::ObliviousHttpCompletionResultDataView::Tag::kInnerResponse: {
    decltype(Traits::inner_response(input))
    in_inner_response = Traits::inner_response(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_inner_response)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::ObliviousHttpResponseDataView, send_validation>(
  in_inner_response,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null inner_response in ObliviousHttpCompletionResult union");
    fragment->data.f_inner_response.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_OBLIVIOUS_HTTP_REQUEST_MOJOM_SEND_VALIDATION_H_