// services/network/public/mojom/oblivious_http_request.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.ByteString');
goog.require('network.mojom.HttpResponseHeaders');
goog.require('network.mojom.MutableNetworkTrafficAnnotationTag');
goog.require('mojoBase.mojom.TimeDelta');
goog.require('network.mojom.TrustTokenParams');
goog.require('url.mojom.Url');






goog.provide('network.mojom.ObliviousHttpClient');
goog.provide('network.mojom.ObliviousHttpClientReceiver');
goog.provide('network.mojom.ObliviousHttpClientCallbackRouter');
goog.provide('network.mojom.ObliviousHttpClientInterface');
goog.provide('network.mojom.ObliviousHttpClientRemote');
goog.provide('network.mojom.ObliviousHttpClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.ObliviousHttpClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.ObliviousHttpClient.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.ObliviousHttpClientInterface = class {
  
  /**
   * @param { !network.mojom.ObliviousHttpCompletionResult } response
   */

  onCompleted(response) {}
};

/**
 * @export
 * @implements { network.mojom.ObliviousHttpClientInterface }
 */
network.mojom.ObliviousHttpClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.ObliviousHttpClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.ObliviousHttpClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.ObliviousHttpClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.ObliviousHttpCompletionResult } response
   */

  onCompleted(
      response) {
    this.proxy.sendMessage(
        0,
        network.mojom.ObliviousHttpClient_OnCompleted_ParamsSpec.$,
        null,
        [
          response
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ObliviousHttpClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.ObliviousHttpClientReceiver = class {
  /**
   * @param {!network.mojom.ObliviousHttpClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.ObliviousHttpClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.ObliviousHttpClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ObliviousHttpClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.ObliviousHttpClient_OnCompleted_ParamsSpec.$,
        null,
        impl.onCompleted.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.ObliviousHttpClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ObliviousHttpClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.ObliviousHttpClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.ObliviousHttpClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ObliviousHttpClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.ObliviousHttpClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.ObliviousHttpClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ObliviousHttpClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCompleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.ObliviousHttpClient_OnCompleted_ParamsSpec.$,
        null,
        this.onCompleted.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.ObliviousHttpRequestBodySpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ObliviousHttpRequestBodySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.ObliviousHttpResponseSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ObliviousHttpResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.ObliviousHttpPaddingParametersSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ObliviousHttpPaddingParametersSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.ObliviousHttpRequestSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ObliviousHttpRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.ObliviousHttpClient_OnCompleted_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ObliviousHttpClient_OnCompleted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.ObliviousHttpCompletionResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
network.mojom.ObliviousHttpCompletionResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.ObliviousHttpRequestBodySpec.$,
    'ObliviousHttpRequestBody',
    [
      mojo.internal.StructField(
        'content', 0,
        0,
        mojoBase.mojom.ByteStringSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contentType', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.ObliviousHttpRequestBody');

/** @record */
network.mojom.ObliviousHttpRequestBody = class {
  constructor() {
    /** @export { !mojoBase.mojom.ByteString } */
    this.content;
    /** @export { !string } */
    this.contentType;
  }
};



mojo.internal.Struct(
    network.mojom.ObliviousHttpResponseSpec.$,
    'ObliviousHttpResponse',
    [
      mojo.internal.StructField(
        'responseCode', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headers', 8,
        0,
        network.mojom.HttpResponseHeadersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseBody', 16,
        0,
        mojoBase.mojom.ByteStringSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.ObliviousHttpResponse');

/** @record */
network.mojom.ObliviousHttpResponse = class {
  constructor() {
    /** @export { !number } */
    this.responseCode;
    /** @export { !network.mojom.HttpResponseHeaders } */
    this.headers;
    /** @export { !mojoBase.mojom.ByteString } */
    this.responseBody;
  }
};



mojo.internal.Struct(
    network.mojom.ObliviousHttpPaddingParametersSpec.$,
    'ObliviousHttpPaddingParameters',
    [
      mojo.internal.StructField(
        'addExponentialPad', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'exponentialMean', 2,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'padToNextPowerOfTwo', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.ObliviousHttpPaddingParameters');

/** @record */
network.mojom.ObliviousHttpPaddingParameters = class {
  constructor() {
    /** @export { !boolean } */
    this.addExponentialPad;
    /** @export { !number } */
    this.exponentialMean;
    /** @export { !boolean } */
    this.padToNextPowerOfTwo;
  }
};



mojo.internal.Struct(
    network.mojom.ObliviousHttpRequestSpec.$,
    'ObliviousHttpRequest',
    [
      mojo.internal.StructField(
        'relayUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 8,
        0,
        network.mojom.MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timeoutDuration', 16,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyConfig', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resourceUrl', 32,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'method', 40,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestBody', 48,
        0,
        network.mojom.ObliviousHttpRequestBodySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trustTokenParams', 56,
        0,
        network.mojom.TrustTokenParamsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'paddingParams', 64,
        0,
        network.mojom.ObliviousHttpPaddingParametersSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 80],]);



goog.provide('network.mojom.ObliviousHttpRequest');

/** @record */
network.mojom.ObliviousHttpRequest = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.relayUrl;
    /** @export { !network.mojom.MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @export { (mojoBase.mojom.TimeDelta|undefined) } */
    this.timeoutDuration;
    /** @export { !string } */
    this.keyConfig;
    /** @export { !url.mojom.Url } */
    this.resourceUrl;
    /** @export { !string } */
    this.method;
    /** @export { (network.mojom.ObliviousHttpRequestBody|undefined) } */
    this.requestBody;
    /** @export { (network.mojom.TrustTokenParams|undefined) } */
    this.trustTokenParams;
    /** @export { (network.mojom.ObliviousHttpPaddingParameters|undefined) } */
    this.paddingParams;
  }
};



mojo.internal.Struct(
    network.mojom.ObliviousHttpClient_OnCompleted_ParamsSpec.$,
    'ObliviousHttpClient_OnCompleted_Params',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        network.mojom.ObliviousHttpCompletionResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.ObliviousHttpClient_OnCompleted_Params');

/** @record */
network.mojom.ObliviousHttpClient_OnCompleted_Params = class {
  constructor() {
    /** @export { !network.mojom.ObliviousHttpCompletionResult } */
    this.response;
  }
};

goog.provide('network.mojom.ObliviousHttpCompletionResult');


mojo.internal.Union(
    network.mojom.ObliviousHttpCompletionResultSpec.$, 'ObliviousHttpCompletionResult',
    {
      'netError': {
        'ordinal': 0,
        'type': mojo.internal.Int32,
      },
      'outerResponseErrorCode': {
        'ordinal': 1,
        'type': mojo.internal.Int32,
      },
      'innerResponse': {
        'ordinal': 2,
        'type': network.mojom.ObliviousHttpResponseSpec.$,
      },
    });

/**
 * @typedef { {
 *   netError: (!number|undefined),
 *   outerResponseErrorCode: (!number|undefined),
 *   innerResponse: (!network.mojom.ObliviousHttpResponse|undefined),
 * } }
 */
network.mojom.ObliviousHttpCompletionResult;
