// services/network/public/mojom/oblivious_http_request.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_OBLIVIOUS_HTTP_REQUEST_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_OBLIVIOUS_HTTP_REQUEST_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/oblivious_http_request.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/isolation_info.mojom-shared.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace network::mojom {
class ObliviousHttpRequestBodyDataView;

class ObliviousHttpResponseDataView;

class ObliviousHttpPaddingParametersDataView;

class ObliviousHttpRequestDataView;

class ObliviousHttpCompletionResultDataView;


}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::ObliviousHttpRequestBodyDataView> {
  using Data = ::network::mojom::internal::ObliviousHttpRequestBody_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ObliviousHttpResponseDataView> {
  using Data = ::network::mojom::internal::ObliviousHttpResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ObliviousHttpPaddingParametersDataView> {
  using Data = ::network::mojom::internal::ObliviousHttpPaddingParameters_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ObliviousHttpRequestDataView> {
  using Data = ::network::mojom::internal::ObliviousHttpRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ObliviousHttpCompletionResultDataView> {
  using Data = ::network::mojom::internal::ObliviousHttpCompletionResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {
// Interface base classes. They are used for type safety check.
class ObliviousHttpClientInterfaceBase {};

using ObliviousHttpClientPtrDataView =
    mojo::InterfacePtrDataView<ObliviousHttpClientInterfaceBase>;
using ObliviousHttpClientRequestDataView =
    mojo::InterfaceRequestDataView<ObliviousHttpClientInterfaceBase>;
using ObliviousHttpClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ObliviousHttpClientInterfaceBase>;
using ObliviousHttpClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ObliviousHttpClientInterfaceBase>;


class ObliviousHttpRequestBodyDataView {
 public:
  ObliviousHttpRequestBodyDataView() = default;

  ObliviousHttpRequestBodyDataView(
      internal::ObliviousHttpRequestBody_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetContentDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContent(UserType* output) {
    
    auto* pointer = data_->content.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  inline void GetContentTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentType(UserType* output) {
    
    auto* pointer = data_->content_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ObliviousHttpRequestBody_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ObliviousHttpResponseDataView {
 public:
  ObliviousHttpResponseDataView() = default;

  ObliviousHttpResponseDataView(
      internal::ObliviousHttpResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t response_code() const {
    return data_->response_code;
  }
  inline void GetHeadersDataView(
      ::network::mojom::HttpResponseHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpResponseHeadersDataView>(
        pointer, output, message_);
  }
  inline void GetResponseBodyDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponseBody(UserType* output) {
    
    auto* pointer = data_->response_body.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ObliviousHttpResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ObliviousHttpPaddingParametersDataView {
 public:
  ObliviousHttpPaddingParametersDataView() = default;

  ObliviousHttpPaddingParametersDataView(
      internal::ObliviousHttpPaddingParameters_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool add_exponential_pad() const {
    return data_->add_exponential_pad;
  }
  uint16_t exponential_mean() const {
    return data_->exponential_mean;
  }
  bool pad_to_next_power_of_two() const {
    return data_->pad_to_next_power_of_two;
  }
 private:
  internal::ObliviousHttpPaddingParameters_Data* data_ = nullptr;
};


class ObliviousHttpRequestDataView {
 public:
  ObliviousHttpRequestDataView() = default;

  ObliviousHttpRequestDataView(
      internal::ObliviousHttpRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRelayUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRelayUrl(UserType* output) {
    
    auto* pointer = data_->relay_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTrafficAnnotationDataView(
      ::network::mojom::MutableNetworkTrafficAnnotationTagDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrafficAnnotation(UserType* output) {
    
    auto* pointer = data_->traffic_annotation.Get();
    return mojo::internal::Deserialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
        pointer, output, message_);
  }
  inline void GetTimeoutDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeoutDuration(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `timeout_duration` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTimeoutDuration` instead "
    "of `ReadTimeoutDuration if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->timeout_duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetKeyConfigDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyConfig(UserType* output) {
    
    auto* pointer = data_->key_config.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetResourceUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResourceUrl(UserType* output) {
    
    auto* pointer = data_->resource_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethod(UserType* output) {
    
    auto* pointer = data_->method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRequestBodyDataView(
      ObliviousHttpRequestBodyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestBody(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::ObliviousHttpRequestBodyDataView, UserType>(),
    "Attempting to read the optional `request_body` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestBody` instead "
    "of `ReadRequestBody if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request_body.Get();
    return mojo::internal::Deserialize<::network::mojom::ObliviousHttpRequestBodyDataView>(
        pointer, output, message_);
  }
  inline void GetTrustTokenParamsDataView(
      ::network::mojom::TrustTokenParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustTokenParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::TrustTokenParamsDataView, UserType>(),
    "Attempting to read the optional `trust_token_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustTokenParams` instead "
    "of `ReadTrustTokenParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trust_token_params.Get();
    return mojo::internal::Deserialize<::network::mojom::TrustTokenParamsDataView>(
        pointer, output, message_);
  }
  inline void GetPaddingParamsDataView(
      ObliviousHttpPaddingParametersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPaddingParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::ObliviousHttpPaddingParametersDataView, UserType>(),
    "Attempting to read the optional `padding_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPaddingParams` instead "
    "of `ReadPaddingParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->padding_params.Get();
    return mojo::internal::Deserialize<::network::mojom::ObliviousHttpPaddingParametersDataView>(
        pointer, output, message_);
  }
 private:
  internal::ObliviousHttpRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ObliviousHttpCompletionResultDataView {
 public:
  using Tag = internal::ObliviousHttpCompletionResult_Data::ObliviousHttpCompletionResult_Tag;

  ObliviousHttpCompletionResultDataView() = default;

  ObliviousHttpCompletionResultDataView(
      internal::ObliviousHttpCompletionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_net_error() const { return data_->tag == Tag::kNetError; }
  int32_t net_error() const {
    CHECK(is_net_error());
    return data_->data.f_net_error;
  }
  bool is_outer_response_error_code() const { return data_->tag == Tag::kOuterResponseErrorCode; }
  int32_t outer_response_error_code() const {
    CHECK(is_outer_response_error_code());
    return data_->data.f_outer_response_error_code;
  }
  bool is_inner_response() const { return data_->tag == Tag::kInnerResponse; }
  inline void GetInnerResponseDataView(
      ObliviousHttpResponseDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadInnerResponse(UserType* output) const {
    
    CHECK(is_inner_response());
    return mojo::internal::Deserialize<::network::mojom::ObliviousHttpResponseDataView>(
        data_->data.f_inner_response.Get(), output, message_);
  }

 private:
  internal::ObliviousHttpCompletionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_OBLIVIOUS_HTTP_REQUEST_MOJOM_DATA_VIEW_H_