// services/network/public/mojom/no_vary_search.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/no_vary_search.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');


  var NoVarySearchParseError = {};
  NoVarySearchParseError.kOk = 0;
  NoVarySearchParseError.kDefaultValue = 1;
  NoVarySearchParseError.kNotDictionary = 2;
  NoVarySearchParseError.kUnknownDictionaryKey = 3;
  NoVarySearchParseError.kNonBooleanKeyOrder = 4;
  NoVarySearchParseError.kParamsNotStringList = 5;
  NoVarySearchParseError.kExceptNotStringList = 6;
  NoVarySearchParseError.kExceptWithoutTrueParams = 7;
  NoVarySearchParseError.MIN_VALUE = 0;
  NoVarySearchParseError.MAX_VALUE = 7;

  NoVarySearchParseError.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
      return true;
    }
    return false;
  };

  NoVarySearchParseError.toKnownEnumValue = function(value) {
    return value;
  };

  NoVarySearchParseError.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function NoVarySearch(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NoVarySearch.prototype.initDefaults_ = function() {
    this.searchVariance = null;
    this.varyOnKeyOrder = false;
  };
  NoVarySearch.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NoVarySearch.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NoVarySearch.searchVariance
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, SearchParamsVariance, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NoVarySearch.encodedSize = codec.kStructHeaderSize + 24;

  NoVarySearch.decode = function(decoder) {
    var packed;
    var val = new NoVarySearch();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.searchVariance =
        decoder.decodeStruct(SearchParamsVariance);
    packed = decoder.readUint8();
    val.varyOnKeyOrder = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NoVarySearch.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NoVarySearch.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(SearchParamsVariance, val.searchVariance);
    packed = 0;
    packed |= (val.varyOnKeyOrder & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };

  function SearchParamsVariance(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  SearchParamsVariance.Tags = {
    noVaryParams: 0,
    varyParams: 1,
  };

  SearchParamsVariance.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  SearchParamsVariance.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "noVaryParams",
        "varyParams",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a SearchParamsVariance member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(SearchParamsVariance.prototype, "noVaryParams", {
    get: function() {
      if (this.$tag != SearchParamsVariance.Tags.noVaryParams) {
        throw new ReferenceError(
            "SearchParamsVariance.noVaryParams is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SearchParamsVariance.Tags.noVaryParams;
      this.$data = value;
    }
  });
  Object.defineProperty(SearchParamsVariance.prototype, "varyParams", {
    get: function() {
      if (this.$tag != SearchParamsVariance.Tags.varyParams) {
        throw new ReferenceError(
            "SearchParamsVariance.varyParams is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SearchParamsVariance.Tags.varyParams;
      this.$data = value;
    }
  });


    SearchParamsVariance.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case SearchParamsVariance.Tags.noVaryParams:
          encoder.encodeArrayPointer(codec.String, val.noVaryParams);
          break;
        case SearchParamsVariance.Tags.varyParams:
          encoder.encodeArrayPointer(codec.String, val.varyParams);
          break;
      }
      encoder.align();
    };


    SearchParamsVariance.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new SearchParamsVariance();
      var tag = decoder.readUint32();
      switch (tag) {
        case SearchParamsVariance.Tags.noVaryParams:
          result.noVaryParams = decoder.decodeArrayPointer(codec.String);
          break;
        case SearchParamsVariance.Tags.varyParams:
          result.varyParams = decoder.decodeArrayPointer(codec.String);
          break;
      }
      decoder.align();

      return result;
    };


    SearchParamsVariance.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case SearchParamsVariance.Tags.noVaryParams:
          

    // validate SearchParamsVariance.noVaryParams
    err = messageValidator.validateArrayPointer(data_offset, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case SearchParamsVariance.Tags.varyParams:
          

    // validate SearchParamsVariance.varyParams
    err = messageValidator.validateArrayPointer(data_offset, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  SearchParamsVariance.encodedSize = 16;

  function NoVarySearchWithParseError(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  NoVarySearchWithParseError.Tags = {
    noVarySearch: 0,
    parseError: 1,
  };

  NoVarySearchWithParseError.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  NoVarySearchWithParseError.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "noVarySearch",
        "parseError",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a NoVarySearchWithParseError member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(NoVarySearchWithParseError.prototype, "noVarySearch", {
    get: function() {
      if (this.$tag != NoVarySearchWithParseError.Tags.noVarySearch) {
        throw new ReferenceError(
            "NoVarySearchWithParseError.noVarySearch is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = NoVarySearchWithParseError.Tags.noVarySearch;
      this.$data = value;
    }
  });
  Object.defineProperty(NoVarySearchWithParseError.prototype, "parseError", {
    get: function() {
      if (this.$tag != NoVarySearchWithParseError.Tags.parseError) {
        throw new ReferenceError(
            "NoVarySearchWithParseError.parseError is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = NoVarySearchWithParseError.Tags.parseError;
      this.$data = value;
    }
  });


    NoVarySearchWithParseError.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case NoVarySearchWithParseError.Tags.noVarySearch:
          encoder.encodeStructPointer(NoVarySearch, val.noVarySearch);
          break;
        case NoVarySearchWithParseError.Tags.parseError:
          encoder.encodeStruct(codec.Int32, val.parseError);
          break;
      }
      encoder.align();
    };


    NoVarySearchWithParseError.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new NoVarySearchWithParseError();
      var tag = decoder.readUint32();
      switch (tag) {
        case NoVarySearchWithParseError.Tags.noVarySearch:
          result.noVarySearch = decoder.decodeStructPointer(NoVarySearch);
          break;
        case NoVarySearchWithParseError.Tags.parseError:
          result.parseError = decoder.decodeStruct(new codec.Enum(NoVarySearchParseError));
          break;
      }
      decoder.align();

      return result;
    };


    NoVarySearchWithParseError.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case NoVarySearchWithParseError.Tags.noVarySearch:
          

    // validate NoVarySearchWithParseError.noVarySearch
    err = messageValidator.validateStructPointer(data_offset, NoVarySearch, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case NoVarySearchWithParseError.Tags.parseError:
          

    // validate NoVarySearchWithParseError.parseError
    err = messageValidator.validateEnum(data_offset, NoVarySearchParseError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  NoVarySearchWithParseError.encodedSize = 16;
  exports.NoVarySearchParseError = NoVarySearchParseError;
  exports.NoVarySearch = NoVarySearch;
  exports.SearchParamsVariance = SearchParamsVariance;
  exports.NoVarySearchWithParseError = NoVarySearchWithParseError;
})();