// services/network/public/mojom/no_vary_search.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NO_VARY_SEARCH_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NO_VARY_SEARCH_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/no_vary_search.mojom-shared-internal.h"




#include "services/network/public/mojom/no_vary_search.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::NoVarySearchParseError>
    : public mojo::internal::EnumHashImpl<::network::mojom::NoVarySearchParseError> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::NoVarySearchParseError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::NoVarySearchParseError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::NoVarySearchParseError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::NoVarySearchDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::NoVarySearchDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::NoVarySearch_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::search_variance(input)) in_search_variance = Traits::search_variance(input);
    mojo::internal::MessageFragment<decltype(fragment->search_variance)>
        search_variance_fragment(fragment.message());
    search_variance_fragment.Claim(&fragment->search_variance);
    
    mojo::internal::Serialize<::network::mojom::SearchParamsVarianceDataView>(
      in_search_variance,
      search_variance_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->search_variance.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null search_variance in NoVarySearch struct");

    fragment->vary_on_key_order = Traits::vary_on_key_order(input);
  }

  static bool Deserialize(::network::mojom::internal::NoVarySearch_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::NoVarySearchDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SearchParamsVarianceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::SearchParamsVarianceDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::SearchParamsVariance_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::network::mojom::SearchParamsVarianceDataView::Tag::kNoVaryParams: {
    decltype(Traits::no_vary_params(input))
    in_no_vary_params = Traits::no_vary_params(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_no_vary_params)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& no_vary_params_validate_params =
            mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
        
mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
  in_no_vary_params,
  value_fragment,
  &no_vary_params_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null no_vary_params in SearchParamsVariance union");
    fragment->data.f_no_vary_params.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::SearchParamsVarianceDataView::Tag::kVaryParams: {
    decltype(Traits::vary_params(input))
    in_vary_params = Traits::vary_params(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_vary_params)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& vary_params_validate_params =
            mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
        
mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
  in_vary_params,
  value_fragment,
  &vary_params_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null vary_params in SearchParamsVariance union");
    fragment->data.f_vary_params.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::network::mojom::internal::SearchParamsVariance_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SearchParamsVarianceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::NoVarySearchWithParseErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::NoVarySearchWithParseErrorDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::NoVarySearchWithParseError_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::network::mojom::NoVarySearchWithParseErrorDataView::Tag::kNoVarySearch: {
    decltype(Traits::no_vary_search(input))
    in_no_vary_search = Traits::no_vary_search(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_no_vary_search)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::NoVarySearchDataView>(
  in_no_vary_search,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null no_vary_search in NoVarySearchWithParseError union");
    fragment->data.f_no_vary_search.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::NoVarySearchWithParseErrorDataView::Tag::kParseError: {
    decltype(Traits::parse_error(input))
    in_parse_error = Traits::parse_error(input);
        
mojo::internal::Serialize<::network::mojom::NoVarySearchParseError>(
  in_parse_error,
  &fragment->data.f_parse_error);
    break;
  }
}
  }

  static bool Deserialize(::network::mojom::internal::NoVarySearchWithParseError_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::NoVarySearchWithParseErrorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void NoVarySearchDataView::GetSearchVarianceDataView(
    SearchParamsVarianceDataView* output) {
  auto pointer = &data_->search_variance;
  *output = SearchParamsVarianceDataView(pointer, message_);
}


inline void SearchParamsVarianceDataView::GetNoVaryParamsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) const {
  CHECK(is_no_vary_params());
  *output = mojo::ArrayDataView<mojo::StringDataView>(data_->data.f_no_vary_params.Get(), message_);
}
inline void SearchParamsVarianceDataView::GetVaryParamsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) const {
  CHECK(is_vary_params());
  *output = mojo::ArrayDataView<mojo::StringDataView>(data_->data.f_vary_params.Get(), message_);
}

inline void NoVarySearchWithParseErrorDataView::GetNoVarySearchDataView(
    NoVarySearchDataView* output) const {
  CHECK(is_no_vary_search());
  *output = NoVarySearchDataView(data_->data.f_no_vary_search.Get(), message_);
}


}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::NoVarySearchParseError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::NoVarySearchParseError value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NO_VARY_SEARCH_MOJOM_SHARED_H_