// services/network/public/mojom/no_vary_search.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NO_VARY_SEARCH_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NO_VARY_SEARCH_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/no_vary_search.mojom-shared-internal.h"


namespace network::mojom {
class NoVarySearchDataView;

class SearchParamsVarianceDataView;
class NoVarySearchWithParseErrorDataView;


}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::NoVarySearchDataView> {
  using Data = ::network::mojom::internal::NoVarySearch_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SearchParamsVarianceDataView> {
  using Data = ::network::mojom::internal::SearchParamsVariance_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::network::mojom::NoVarySearchWithParseErrorDataView> {
  using Data = ::network::mojom::internal::NoVarySearchWithParseError_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class NoVarySearchParseError : int32_t {
  
  kOk = 0,
  
  kDefaultValue = 1,
  
  kNotDictionary = 2,
  
  kUnknownDictionaryKey = 3,
  
  kNonBooleanKeyOrder = 4,
  
  kParamsNotStringList = 5,
  
  kExceptNotStringList = 6,
  
  kExceptWithoutTrueParams = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

 std::ostream& operator<<(std::ostream& os, NoVarySearchParseError value);
inline bool IsKnownEnumValue(NoVarySearchParseError value) {
  return internal::NoVarySearchParseError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class NoVarySearchDataView {
 public:
  NoVarySearchDataView() = default;

  NoVarySearchDataView(
      internal::NoVarySearch_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSearchVarianceDataView(
      SearchParamsVarianceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSearchVariance(UserType* output) {
    
    auto* pointer = !data_->search_variance.is_null() ? &data_->search_variance : nullptr;
    return mojo::internal::Deserialize<::network::mojom::SearchParamsVarianceDataView>(
        pointer, output, message_);
  }
  bool vary_on_key_order() const {
    return data_->vary_on_key_order;
  }
 private:
  internal::NoVarySearch_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SearchParamsVarianceDataView {
 public:
  using Tag = internal::SearchParamsVariance_Data::SearchParamsVariance_Tag;

  SearchParamsVarianceDataView() = default;

  SearchParamsVarianceDataView(
      internal::SearchParamsVariance_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_no_vary_params() const { return data_->tag == Tag::kNoVaryParams; }
  inline void GetNoVaryParamsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNoVaryParams(UserType* output) const {
    
    CHECK(is_no_vary_params());
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        data_->data.f_no_vary_params.Get(), output, message_);
  }
  bool is_vary_params() const { return data_->tag == Tag::kVaryParams; }
  inline void GetVaryParamsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadVaryParams(UserType* output) const {
    
    CHECK(is_vary_params());
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        data_->data.f_vary_params.Get(), output, message_);
  }

 private:
  internal::SearchParamsVariance_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class NoVarySearchWithParseErrorDataView {
 public:
  using Tag = internal::NoVarySearchWithParseError_Data::NoVarySearchWithParseError_Tag;

  NoVarySearchWithParseErrorDataView() = default;

  NoVarySearchWithParseErrorDataView(
      internal::NoVarySearchWithParseError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_no_vary_search() const { return data_->tag == Tag::kNoVarySearch; }
  inline void GetNoVarySearchDataView(
      NoVarySearchDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNoVarySearch(UserType* output) const {
    
    CHECK(is_no_vary_search());
    return mojo::internal::Deserialize<::network::mojom::NoVarySearchDataView>(
        data_->data.f_no_vary_search.Get(), output, message_);
  }
  bool is_parse_error() const { return data_->tag == Tag::kParseError; }
  template <typename UserType>
  [[nodiscard]] bool ReadParseError(UserType* output) const {
    CHECK(is_parse_error());
    return mojo::internal::Deserialize<::network::mojom::NoVarySearchParseError>(
        data_->data.f_parse_error, output);
  }
  NoVarySearchParseError parse_error() const {
    CHECK(is_parse_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::NoVarySearchParseError>(data_->data.f_parse_error));
  }

 private:
  internal::NoVarySearchWithParseError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NO_VARY_SEARCH_MOJOM_DATA_VIEW_H_