// services/network/public/mojom/no_vary_search.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NO_VARY_SEARCH_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NO_VARY_SEARCH_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/no_vary_search.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/no_vary_search.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/no_vary_search.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {






class BLINK_PLATFORM_EXPORT SearchParamsVariance {
 public:
  using DataView = SearchParamsVarianceDataView;
  using Data_ = internal::SearchParamsVariance_Data;
  using Tag = Data_::SearchParamsVariance_Tag;

  template <typename... Args>
  static SearchParamsVariancePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |no_vary_params|.
  static SearchParamsVariancePtr NewNoVaryParams(
      ::blink::Vector<::blink::String> value);
  // Construct an instance holding |vary_params|.
  static SearchParamsVariancePtr NewVaryParams(
      ::blink::Vector<::blink::String> value);

  template <typename U>
  static SearchParamsVariancePtr From(const U& u) {
    return mojo::TypeConverter<SearchParamsVariancePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SearchParamsVariance>::Convert(*this);
  }
  ~SearchParamsVariance();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  SearchParamsVariance(const SearchParamsVariance& other) = delete;
  SearchParamsVariance& operator=(const SearchParamsVariance& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SearchParamsVariancePtr>
  SearchParamsVariancePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SearchParamsVariance>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SearchParamsVariance>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_no_vary_params() const { return tag_ == Tag::kNoVaryParams; }
  const ::blink::Vector<::blink::String>& get_no_vary_params() const {
    CHECK(tag_ == Tag::kNoVaryParams);
    return data_.no_vary_params;
  }
  ::blink::Vector<::blink::String>& get_no_vary_params() {
    CHECK(tag_ == Tag::kNoVaryParams);
    return data_.no_vary_params;
  }
  void set_no_vary_params(::blink::Vector<::blink::String> no_vary_params);

  bool is_vary_params() const { return tag_ == Tag::kVaryParams; }
  const ::blink::Vector<::blink::String>& get_vary_params() const {
    CHECK(tag_ == Tag::kVaryParams);
    return data_.vary_params;
  }
  ::blink::Vector<::blink::String>& get_vary_params() {
    CHECK(tag_ == Tag::kVaryParams);
    return data_.vary_params;
  }
  void set_vary_params(::blink::Vector<::blink::String> vary_params);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SearchParamsVariance::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SearchParamsVariance::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNoVaryParams)>,
        ::blink::Vector<::blink::String> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kVaryParams)>,
        ::blink::Vector<::blink::String> value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::Vector<::blink::String> no_vary_params;
    ::blink::Vector<::blink::String> vary_params;
  };

  SearchParamsVariance(
      std::in_place_index_t<static_cast<size_t>(Tag::kNoVaryParams)>,
      ::blink::Vector<::blink::String> value);
  SearchParamsVariance(
      std::in_place_index_t<static_cast<size_t>(Tag::kVaryParams)>,
      ::blink::Vector<::blink::String> value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_PLATFORM_EXPORT NoVarySearchWithParseError {
 public:
  using DataView = NoVarySearchWithParseErrorDataView;
  using Data_ = internal::NoVarySearchWithParseError_Data;
  using Tag = Data_::NoVarySearchWithParseError_Tag;

  template <typename... Args>
  static NoVarySearchWithParseErrorPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |no_vary_search|.
  static NoVarySearchWithParseErrorPtr NewNoVarySearch(
      NoVarySearchPtr value);
  // Construct an instance holding |parse_error|.
  static NoVarySearchWithParseErrorPtr NewParseError(
      NoVarySearchParseError value);

  template <typename U>
  static NoVarySearchWithParseErrorPtr From(const U& u) {
    return mojo::TypeConverter<NoVarySearchWithParseErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NoVarySearchWithParseError>::Convert(*this);
  }
  ~NoVarySearchWithParseError();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  NoVarySearchWithParseError(const NoVarySearchWithParseError& other) = delete;
  NoVarySearchWithParseError& operator=(const NoVarySearchWithParseError& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = NoVarySearchWithParseErrorPtr>
  NoVarySearchWithParseErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, NoVarySearchWithParseError>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, NoVarySearchWithParseError>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_no_vary_search() const { return tag_ == Tag::kNoVarySearch; }
  const NoVarySearchPtr& get_no_vary_search() const {
    CHECK(tag_ == Tag::kNoVarySearch);
    return data_.no_vary_search;
  }
  NoVarySearchPtr& get_no_vary_search() {
    CHECK(tag_ == Tag::kNoVarySearch);
    return data_.no_vary_search;
  }
  void set_no_vary_search(NoVarySearchPtr no_vary_search);

  bool is_parse_error() const { return tag_ == Tag::kParseError; }
  NoVarySearchParseError get_parse_error() const {
    CHECK(tag_ == Tag::kParseError);
    return data_.parse_error;
  }
  void set_parse_error(NoVarySearchParseError parse_error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NoVarySearchWithParseError::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<NoVarySearchWithParseError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNoVarySearch)>,
        NoVarySearchPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kParseError)>,
        NoVarySearchParseError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    NoVarySearchPtr no_vary_search;
    NoVarySearchParseError parse_error;
  };

  NoVarySearchWithParseError(
      std::in_place_index_t<static_cast<size_t>(Tag::kNoVarySearch)>,
      NoVarySearchPtr value);
  NoVarySearchWithParseError(
      std::in_place_index_t<static_cast<size_t>(Tag::kParseError)>,
      NoVarySearchParseError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_PLATFORM_EXPORT NoVarySearch {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NoVarySearch, T>::value>;
  using DataView = NoVarySearchDataView;
  using Data_ = internal::NoVarySearch_Data;

  template <typename... Args>
  static NoVarySearchPtr New(Args&&... args) {
    return NoVarySearchPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NoVarySearchPtr From(const U& u) {
    return mojo::TypeConverter<NoVarySearchPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NoVarySearch>::Convert(*this);
  }


  NoVarySearch();

  NoVarySearch(
      SearchParamsVariancePtr search_variance,
      bool vary_on_key_order);

NoVarySearch(const NoVarySearch&) = delete;
NoVarySearch& operator=(const NoVarySearch&) = delete;

  ~NoVarySearch();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NoVarySearchPtr>
  NoVarySearchPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NoVarySearch::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NoVarySearch::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NoVarySearch::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NoVarySearch::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NoVarySearch::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NoVarySearch::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NoVarySearch_UnserializedMessageContext<
            UserType, NoVarySearch::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NoVarySearch::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NoVarySearch::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NoVarySearch_UnserializedMessageContext<
            UserType, NoVarySearch::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NoVarySearch::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  SearchParamsVariancePtr search_variance;
  
  bool vary_on_key_order;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NoVarySearch::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NoVarySearch::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NoVarySearch::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NoVarySearch::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
SearchParamsVariancePtr SearchParamsVariance::Clone() const {
  switch (tag_) {
    case Tag::kNoVaryParams:
      return NewNoVaryParams(
          mojo::Clone(data_.no_vary_params));
    case Tag::kVaryParams:
      return NewVaryParams(
          mojo::Clone(data_.vary_params));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SearchParamsVariance>::value>::type*>
bool SearchParamsVariance::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kNoVaryParams:
      return mojo::Equals(data_.no_vary_params, other.data_.no_vary_params);
    case Tag::kVaryParams:
      return mojo::Equals(data_.vary_params, other.data_.vary_params);
  }

  return false;
}
template <typename UnionPtrType>
NoVarySearchWithParseErrorPtr NoVarySearchWithParseError::Clone() const {
  switch (tag_) {
    case Tag::kNoVarySearch:
      return NewNoVarySearch(
          mojo::Clone(data_.no_vary_search));
    case Tag::kParseError:
      return NewParseError(
          mojo::Clone(data_.parse_error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, NoVarySearchWithParseError>::value>::type*>
bool NoVarySearchWithParseError::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kNoVarySearch:
      return mojo::Equals(data_.no_vary_search, other.data_.no_vary_search);
    case Tag::kParseError:
      return mojo::Equals(data_.parse_error, other.data_.parse_error);
  }

  return false;
}
template <typename StructPtrType>
NoVarySearchPtr NoVarySearch::Clone() const {
  return New(
      mojo::Clone(search_variance),
      mojo::Clone(vary_on_key_order)
  );
}

template <typename T, NoVarySearch::EnableIfSame<T>*>
bool NoVarySearch::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->search_variance, other_struct.search_variance))
    return false;
  if (!mojo::Equals(this->vary_on_key_order, other_struct.vary_on_key_order))
    return false;
  return true;
}

template <typename T, NoVarySearch::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.search_variance < rhs.search_variance)
    return true;
  if (rhs.search_variance < lhs.search_variance)
    return false;
  if (lhs.vary_on_key_order < rhs.vary_on_key_order)
    return true;
  if (rhs.vary_on_key_order < lhs.vary_on_key_order)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::NoVarySearch::DataView,
                                         ::network::mojom::blink::NoVarySearchPtr> {
  static bool IsNull(const ::network::mojom::blink::NoVarySearchPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::NoVarySearchPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::NoVarySearch::search_variance)& search_variance(
      const ::network::mojom::blink::NoVarySearchPtr& input) {
    return input->search_variance;
  }

  static decltype(::network::mojom::blink::NoVarySearch::vary_on_key_order) vary_on_key_order(
      const ::network::mojom::blink::NoVarySearchPtr& input) {
    return input->vary_on_key_order;
  }

  static bool Read(::network::mojom::blink::NoVarySearch::DataView input, ::network::mojom::blink::NoVarySearchPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::network::mojom::blink::SearchParamsVariance::DataView,
                                        ::network::mojom::blink::SearchParamsVariancePtr> {
  static bool IsNull(const ::network::mojom::blink::SearchParamsVariancePtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::SearchParamsVariancePtr* output) { output->reset(); }

  static ::network::mojom::blink::SearchParamsVariance::Tag GetTag(const ::network::mojom::blink::SearchParamsVariancePtr& input) {
    return input->which();
  }

  static const ::blink::Vector<::blink::String>& no_vary_params(const ::network::mojom::blink::SearchParamsVariancePtr& input) {
    return input->get_no_vary_params();
  }

  static const ::blink::Vector<::blink::String>& vary_params(const ::network::mojom::blink::SearchParamsVariancePtr& input) {
    return input->get_vary_params();
  }

  static bool Read(::network::mojom::blink::SearchParamsVariance::DataView input, ::network::mojom::blink::SearchParamsVariancePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::network::mojom::blink::NoVarySearchWithParseError::DataView,
                                        ::network::mojom::blink::NoVarySearchWithParseErrorPtr> {
  static bool IsNull(const ::network::mojom::blink::NoVarySearchWithParseErrorPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::NoVarySearchWithParseErrorPtr* output) { output->reset(); }

  static ::network::mojom::blink::NoVarySearchWithParseError::Tag GetTag(const ::network::mojom::blink::NoVarySearchWithParseErrorPtr& input) {
    return input->which();
  }

  static const ::network::mojom::blink::NoVarySearchPtr& no_vary_search(const ::network::mojom::blink::NoVarySearchWithParseErrorPtr& input) {
    return input->get_no_vary_search();
  }

  static  ::network::mojom::blink::NoVarySearchParseError parse_error(const ::network::mojom::blink::NoVarySearchWithParseErrorPtr& input) {
    return input->get_parse_error();
  }

  static bool Read(::network::mojom::blink::NoVarySearchWithParseError::DataView input, ::network::mojom::blink::NoVarySearchWithParseErrorPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NO_VARY_SEARCH_MOJOM_BLINK_H_