// services/network/public/mojom/network_service_test.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/network_service_test.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_service_test.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* ResolverTypeToStringHelper(ResolverType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ResolverType::kResolverTypeFail:
      return "kResolverTypeFail";
    case ResolverType::kResolverTypeFailTimeout:
      return "kResolverTypeFailTimeout";
    case ResolverType::kResolverTypeSystem:
      return "kResolverTypeSystem";
    case ResolverType::kResolverTypeIPLiteral:
      return "kResolverTypeIPLiteral";
    case ResolverType::kResolverTypeDirectLookup:
      return "kResolverTypeDirectLookup";
    default:
      return nullptr;
  }
}

std::string ResolverTypeToString(ResolverType value) {
  const char *str = ResolverTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ResolverType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ResolverType value) {
  return os << ResolverTypeToString(value);
}

namespace internal {


// static
bool Rule_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Rule_Data* object =
      static_cast<const Rule_Data*>(data);


  if (!::network::mojom::internal::ResolverType_Data
        ::Validate(object->resolver_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host_pattern, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& host_pattern_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->host_pattern, validation_context,
                                         &host_pattern_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replacement, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& replacement_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->replacement, validation_context,
                                         &replacement_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dns_aliases, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& dns_aliases_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->dns_aliases, validation_context,
                                         &dns_aliases_validate_params)) {
    return false;
  }

  return true;
}

Rule_Data::Rule_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCacheOpenEntryResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCacheOpenEntryResult_Data* object =
      static_cast<const SimpleCacheOpenEntryResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key, validation_context,
                                         &key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->entry,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SimpleCacheOpenEntryResult_Data::SimpleCacheOpenEntryResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCacheEntry_WriteData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCacheEntry_WriteData_Params_Data* object =
      static_cast<const SimpleCacheEntry_WriteData_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

SimpleCacheEntry_WriteData_Params_Data::SimpleCacheEntry_WriteData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCacheEntry_WriteData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCacheEntry_WriteData_ResponseParams_Data* object =
      static_cast<const SimpleCacheEntry_WriteData_ResponseParams_Data*>(data);

  return true;
}

SimpleCacheEntry_WriteData_ResponseParams_Data::SimpleCacheEntry_WriteData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCacheEntry_ReadData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCacheEntry_ReadData_Params_Data* object =
      static_cast<const SimpleCacheEntry_ReadData_Params_Data*>(data);

  return true;
}

SimpleCacheEntry_ReadData_Params_Data::SimpleCacheEntry_ReadData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCacheEntry_ReadData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCacheEntry_ReadData_ResponseParams_Data* object =
      static_cast<const SimpleCacheEntry_ReadData_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

SimpleCacheEntry_ReadData_ResponseParams_Data::SimpleCacheEntry_ReadData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCacheEntry_WriteSparseData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCacheEntry_WriteSparseData_Params_Data* object =
      static_cast<const SimpleCacheEntry_WriteSparseData_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

SimpleCacheEntry_WriteSparseData_Params_Data::SimpleCacheEntry_WriteSparseData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCacheEntry_WriteSparseData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCacheEntry_WriteSparseData_ResponseParams_Data* object =
      static_cast<const SimpleCacheEntry_WriteSparseData_ResponseParams_Data*>(data);

  return true;
}

SimpleCacheEntry_WriteSparseData_ResponseParams_Data::SimpleCacheEntry_WriteSparseData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCacheEntry_ReadSparseData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCacheEntry_ReadSparseData_Params_Data* object =
      static_cast<const SimpleCacheEntry_ReadSparseData_Params_Data*>(data);

  return true;
}

SimpleCacheEntry_ReadSparseData_Params_Data::SimpleCacheEntry_ReadSparseData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCacheEntry_ReadSparseData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCacheEntry_ReadSparseData_ResponseParams_Data* object =
      static_cast<const SimpleCacheEntry_ReadSparseData_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

SimpleCacheEntry_ReadSparseData_ResponseParams_Data::SimpleCacheEntry_ReadSparseData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCacheEntry_Close_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCacheEntry_Close_Params_Data* object =
      static_cast<const SimpleCacheEntry_Close_Params_Data*>(data);

  return true;
}

SimpleCacheEntry_Close_Params_Data::SimpleCacheEntry_Close_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCacheEntry_Close_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCacheEntry_Close_ResponseParams_Data* object =
      static_cast<const SimpleCacheEntry_Close_ResponseParams_Data*>(data);

  return true;
}

SimpleCacheEntry_Close_ResponseParams_Data::SimpleCacheEntry_Close_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCacheEntryEnumerator_GetNext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCacheEntryEnumerator_GetNext_Params_Data* object =
      static_cast<const SimpleCacheEntryEnumerator_GetNext_Params_Data*>(data);

  return true;
}

SimpleCacheEntryEnumerator_GetNext_Params_Data::SimpleCacheEntryEnumerator_GetNext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCacheEntryEnumerator_GetNext_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCacheEntryEnumerator_GetNext_ResponseParams_Data* object =
      static_cast<const SimpleCacheEntryEnumerator_GetNext_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

SimpleCacheEntryEnumerator_GetNext_ResponseParams_Data::SimpleCacheEntryEnumerator_GetNext_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCache_CreateEntry_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCache_CreateEntry_Params_Data* object =
      static_cast<const SimpleCache_CreateEntry_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key, validation_context,
                                         &key_validate_params)) {
    return false;
  }

  return true;
}

SimpleCache_CreateEntry_Params_Data::SimpleCache_CreateEntry_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCache_CreateEntry_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCache_CreateEntry_ResponseParams_Data* object =
      static_cast<const SimpleCache_CreateEntry_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->entry,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SimpleCache_CreateEntry_ResponseParams_Data::SimpleCache_CreateEntry_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCache_OpenEntry_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCache_OpenEntry_Params_Data* object =
      static_cast<const SimpleCache_OpenEntry_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key, validation_context,
                                         &key_validate_params)) {
    return false;
  }

  return true;
}

SimpleCache_OpenEntry_Params_Data::SimpleCache_OpenEntry_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCache_OpenEntry_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCache_OpenEntry_ResponseParams_Data* object =
      static_cast<const SimpleCache_OpenEntry_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->entry,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SimpleCache_OpenEntry_ResponseParams_Data::SimpleCache_OpenEntry_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCache_DoomEntry_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCache_DoomEntry_Params_Data* object =
      static_cast<const SimpleCache_DoomEntry_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key, validation_context,
                                         &key_validate_params)) {
    return false;
  }

  return true;
}

SimpleCache_DoomEntry_Params_Data::SimpleCache_DoomEntry_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCache_DoomEntry_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCache_DoomEntry_ResponseParams_Data* object =
      static_cast<const SimpleCache_DoomEntry_ResponseParams_Data*>(data);

  return true;
}

SimpleCache_DoomEntry_ResponseParams_Data::SimpleCache_DoomEntry_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCache_DoomAllEntries_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCache_DoomAllEntries_Params_Data* object =
      static_cast<const SimpleCache_DoomAllEntries_Params_Data*>(data);

  return true;
}

SimpleCache_DoomAllEntries_Params_Data::SimpleCache_DoomAllEntries_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCache_DoomAllEntries_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCache_DoomAllEntries_ResponseParams_Data* object =
      static_cast<const SimpleCache_DoomAllEntries_ResponseParams_Data*>(data);

  return true;
}

SimpleCache_DoomAllEntries_ResponseParams_Data::SimpleCache_DoomAllEntries_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCache_EnumerateEntries_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCache_EnumerateEntries_Params_Data* object =
      static_cast<const SimpleCache_EnumerateEntries_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SimpleCache_EnumerateEntries_Params_Data::SimpleCache_EnumerateEntries_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCache_Detach_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCache_Detach_Params_Data* object =
      static_cast<const SimpleCache_Detach_Params_Data*>(data);

  return true;
}

SimpleCache_Detach_Params_Data::SimpleCache_Detach_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SimpleCache_Detach_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SimpleCache_Detach_ResponseParams_Data* object =
      static_cast<const SimpleCache_Detach_ResponseParams_Data*>(data);

  return true;
}

SimpleCache_Detach_ResponseParams_Data::SimpleCache_Detach_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_AddRules_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_AddRules_Params_Data* object =
      static_cast<const NetworkServiceTest_AddRules_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rules, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& rules_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->rules, validation_context,
                                         &rules_validate_params)) {
    return false;
  }

  return true;
}

NetworkServiceTest_AddRules_Params_Data::NetworkServiceTest_AddRules_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_AddRules_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_AddRules_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_AddRules_ResponseParams_Data*>(data);

  return true;
}

NetworkServiceTest_AddRules_ResponseParams_Data::NetworkServiceTest_AddRules_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SimulateNetworkChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_SimulateNetworkChange_Params_Data* object =
      static_cast<const NetworkServiceTest_SimulateNetworkChange_Params_Data*>(data);


  if (!::network::mojom::internal::ConnectionType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

NetworkServiceTest_SimulateNetworkChange_Params_Data::NetworkServiceTest_SimulateNetworkChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SimulateNetworkChange_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_SimulateNetworkChange_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_SimulateNetworkChange_ResponseParams_Data*>(data);

  return true;
}

NetworkServiceTest_SimulateNetworkChange_ResponseParams_Data::NetworkServiceTest_SimulateNetworkChange_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SimulateNetworkQualityChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_SimulateNetworkQualityChange_Params_Data* object =
      static_cast<const NetworkServiceTest_SimulateNetworkQualityChange_Params_Data*>(data);


  if (!::network::mojom::internal::EffectiveConnectionType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

NetworkServiceTest_SimulateNetworkQualityChange_Params_Data::NetworkServiceTest_SimulateNetworkQualityChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams_Data*>(data);

  return true;
}

NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams_Data::NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params_Data* object =
      static_cast<const NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params_Data*>(data);

  return true;
}

NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params_Data::NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams_Data*>(data);

  return true;
}

NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams_Data::NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SimulateCrash_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_SimulateCrash_Params_Data* object =
      static_cast<const NetworkServiceTest_SimulateCrash_Params_Data*>(data);

  return true;
}

NetworkServiceTest_SimulateCrash_Params_Data::NetworkServiceTest_SimulateCrash_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data* object =
      static_cast<const NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data*>(data);

  return true;
}

NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data::NetworkServiceTest_MockCertVerifierSetDefaultResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data*>(data);

  return true;
}

NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data::NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data* object =
      static_cast<const NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cert, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cert, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host_pattern, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& host_pattern_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->host_pattern, validation_context,
                                         &host_pattern_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->verify_result, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->verify_result, validation_context))
    return false;

  return true;
}

NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data*>(data);

  return true;
}

NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data::NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetTransportSecurityStateTestSource_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_SetTransportSecurityStateTestSource_Params_Data* object =
      static_cast<const NetworkServiceTest_SetTransportSecurityStateTestSource_Params_Data*>(data);

  return true;
}

NetworkServiceTest_SetTransportSecurityStateTestSource_Params_Data::NetworkServiceTest_SetTransportSecurityStateTestSource_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams_Data*>(data);

  return true;
}

NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams_Data::NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data* object =
      static_cast<const NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data*>(data);

  return true;
}

NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data*>(data);

  return true;
}

NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data::NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_ReplaceSystemDnsConfig_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_ReplaceSystemDnsConfig_Params_Data* object =
      static_cast<const NetworkServiceTest_ReplaceSystemDnsConfig_Params_Data*>(data);

  return true;
}

NetworkServiceTest_ReplaceSystemDnsConfig_Params_Data::NetworkServiceTest_ReplaceSystemDnsConfig_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams_Data*>(data);

  return true;
}

NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams_Data::NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetTestDohConfig_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_SetTestDohConfig_Params_Data* object =
      static_cast<const NetworkServiceTest_SetTestDohConfig_Params_Data*>(data);


  if (!::network::mojom::internal::SecureDnsMode_Data
        ::Validate(object->secure_dns_mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->doh_config, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->doh_config, validation_context))
    return false;

  return true;
}

NetworkServiceTest_SetTestDohConfig_Params_Data::NetworkServiceTest_SetTestDohConfig_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetTestDohConfig_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_SetTestDohConfig_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_SetTestDohConfig_ResponseParams_Data*>(data);

  return true;
}

NetworkServiceTest_SetTestDohConfig_ResponseParams_Data::NetworkServiceTest_SetTestDohConfig_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_CrashOnResolveHost_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_CrashOnResolveHost_Params_Data* object =
      static_cast<const NetworkServiceTest_CrashOnResolveHost_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& host_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->host, validation_context,
                                         &host_validate_params)) {
    return false;
  }

  return true;
}

NetworkServiceTest_CrashOnResolveHost_Params_Data::NetworkServiceTest_CrashOnResolveHost_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_CrashOnGetCookieList_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_CrashOnGetCookieList_Params_Data* object =
      static_cast<const NetworkServiceTest_CrashOnGetCookieList_Params_Data*>(data);

  return true;
}

NetworkServiceTest_CrashOnGetCookieList_Params_Data::NetworkServiceTest_CrashOnGetCookieList_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data* object =
      static_cast<const NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data*>(data);

  return true;
}

NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data::NetworkServiceTest_GetLatestMemoryPressureLevel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data*>(data);


  if (!::mojo_base::mojom::internal::MemoryPressureLevel_Data
        ::Validate(object->memory_pressure_level, validation_context))
    return false;

  return true;
}

NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data::NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data* object =
      static_cast<const NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data*>(data);

  return true;
}

NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data*>(data);

  return true;
}

NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data::NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_GetEnvironmentVariableValue_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_GetEnvironmentVariableValue_Params_Data* object =
      static_cast<const NetworkServiceTest_GetEnvironmentVariableValue_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  return true;
}

NetworkServiceTest_GetEnvironmentVariableValue_Params_Data::NetworkServiceTest_GetEnvironmentVariableValue_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data::NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_Log_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_Log_Params_Data* object =
      static_cast<const NetworkServiceTest_Log_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

NetworkServiceTest_Log_Params_Data::NetworkServiceTest_Log_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_Log_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_Log_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_Log_ResponseParams_Data*>(data);

  return true;
}

NetworkServiceTest_Log_ResponseParams_Data::NetworkServiceTest_Log_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_ActivateFieldTrial_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_ActivateFieldTrial_Params_Data* object =
      static_cast<const NetworkServiceTest_ActivateFieldTrial_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->field_trial_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& field_trial_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->field_trial_name, validation_context,
                                         &field_trial_name_validate_params)) {
    return false;
  }

  return true;
}

NetworkServiceTest_ActivateFieldTrial_Params_Data::NetworkServiceTest_ActivateFieldTrial_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetSCTAuditingRetryDelay_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_SetSCTAuditingRetryDelay_Params_Data* object =
      static_cast<const NetworkServiceTest_SetSCTAuditingRetryDelay_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->delay, validation_context))
    return false;

  return true;
}

NetworkServiceTest_SetSCTAuditingRetryDelay_Params_Data::NetworkServiceTest_SetSCTAuditingRetryDelay_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams_Data*>(data);

  return true;
}

NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams_Data::NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_OpenFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_OpenFile_Params_Data* object =
      static_cast<const NetworkServiceTest_OpenFile_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  return true;
}

NetworkServiceTest_OpenFile_Params_Data::NetworkServiceTest_OpenFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_OpenFile_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_OpenFile_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_OpenFile_ResponseParams_Data*>(data);

  return true;
}

NetworkServiceTest_OpenFile_ResponseParams_Data::NetworkServiceTest_OpenFile_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_EnumerateFiles_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_EnumerateFiles_Params_Data* object =
      static_cast<const NetworkServiceTest_EnumerateFiles_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->factory, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->factory,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkServiceTest_EnumerateFiles_Params_Data::NetworkServiceTest_EnumerateFiles_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_EnumerateFiles_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_EnumerateFiles_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_EnumerateFiles_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entries, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->entries, validation_context,
                                         &entries_validate_params)) {
    return false;
  }

  return true;
}

NetworkServiceTest_EnumerateFiles_ResponseParams_Data::NetworkServiceTest_EnumerateFiles_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_CreateSimpleCache_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_CreateSimpleCache_Params_Data* object =
      static_cast<const NetworkServiceTest_CreateSimpleCache_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->factory, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->factory,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  return true;
}

NetworkServiceTest_CreateSimpleCache_Params_Data::NetworkServiceTest_CreateSimpleCache_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_CreateSimpleCache_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_CreateSimpleCache_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_CreateSimpleCache_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->backend,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkServiceTest_CreateSimpleCache_ResponseParams_Data::NetworkServiceTest_CreateSimpleCache_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_MakeRequestToServer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_MakeRequestToServer_Params_Data* object =
      static_cast<const NetworkServiceTest_MakeRequestToServer_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->s, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->s, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->endpoint, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->endpoint, validation_context))
    return false;

  return true;
}

NetworkServiceTest_MakeRequestToServer_Params_Data::NetworkServiceTest_MakeRequestToServer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_MakeRequestToServer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_MakeRequestToServer_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_MakeRequestToServer_ResponseParams_Data*>(data);

  return true;
}

NetworkServiceTest_MakeRequestToServer_ResponseParams_Data::NetworkServiceTest_MakeRequestToServer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params_Data* object =
      static_cast<const NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params_Data*>(data);

  return true;
}

NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params_Data::NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->addr_list, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->addr_list, validation_context))
    return false;

  return true;
}

NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams_Data::NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetIPv6ProbeResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_SetIPv6ProbeResult_Params_Data* object =
      static_cast<const NetworkServiceTest_SetIPv6ProbeResult_Params_Data*>(data);

  return true;
}

NetworkServiceTest_SetIPv6ProbeResult_Params_Data::NetworkServiceTest_SetIPv6ProbeResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_SetIPv6ProbeResult_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_SetIPv6ProbeResult_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_SetIPv6ProbeResult_ResponseParams_Data*>(data);

  return true;
}

NetworkServiceTest_SetIPv6ProbeResult_ResponseParams_Data::NetworkServiceTest_SetIPv6ProbeResult_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_AllowsGSSAPILibraryLoad_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_AllowsGSSAPILibraryLoad_Params_Data* object =
      static_cast<const NetworkServiceTest_AllowsGSSAPILibraryLoad_Params_Data*>(data);

  return true;
}

NetworkServiceTest_AllowsGSSAPILibraryLoad_Params_Data::NetworkServiceTest_AllowsGSSAPILibraryLoad_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams_Data*>(data);

  return true;
}

NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams_Data::NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_IsHappyEyeballsV3Enabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_IsHappyEyeballsV3Enabled_Params_Data* object =
      static_cast<const NetworkServiceTest_IsHappyEyeballsV3Enabled_Params_Data*>(data);

  return true;
}

NetworkServiceTest_IsHappyEyeballsV3Enabled_Params_Data::NetworkServiceTest_IsHappyEyeballsV3Enabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams_Data* object =
      static_cast<const NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams_Data*>(data);

  return true;
}

NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams_Data::NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ResolverType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::ResolverType value) {
  return std::move(context).WriteString(::network::mojom::ResolverTypeToString(value));
}

} // namespace perfetto