// services/network/public/mojom/network_service.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/network_service.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var content_settings$ =
      mojo.internal.exposeNamespace('contentSettings.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/content_settings/core/common/content_settings.mojom', '../../../../components/content_settings/core/common/content_settings.mojom.js');
  }
  var byte_string$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/byte_string.mojom', '../../../../mojo/public/mojom/base/byte_string.mojom.js');
  }
  var file$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file.mojom', '../../../../mojo/public/mojom/base/file.mojom.js');
  }
  var memory_pressure_level$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/memory_pressure_level.mojom', '../../../../mojo/public/mojom/base/memory_pressure_level.mojom.js');
  }
  var proto_wrapper$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/proto_wrapper.mojom', '../../../../mojo/public/mojom/base/proto_wrapper.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var values$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/values.mojom', '../../../../mojo/public/mojom/base/values.mojom.js');
  }
  var context$ =
      mojo.internal.exposeNamespace('sandbox.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'sandbox/policy/mojom/context.mojom', '../../../../sandbox/policy/mojom/context.mojom.js');
  }
  var sandbox$ =
      mojo.internal.exposeNamespace('sandbox.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'sandbox/policy/mojom/sandbox.mojom', '../../../../sandbox/policy/mojom/sandbox.mojom.js');
  }
  var client_security_state$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/client_security_state.mojom', 'client_security_state.mojom.js');
  }
  var first_party_sets$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/first_party_sets.mojom', 'first_party_sets.mojom.js');
  }
  var host_resolver$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/host_resolver.mojom', 'host_resolver.mojom.js');
  }
  var http_raw_headers$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/http_raw_headers.mojom', 'http_raw_headers.mojom.js');
  }
  var ip_address_space$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_address_space.mojom', 'ip_address_space.mojom.js');
  }
  var ip_endpoint$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_endpoint.mojom', 'ip_endpoint.mojom.js');
  }
  var key_pinning$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/key_pinning.mojom', 'key_pinning.mojom.js');
  }
  var mutable_network_traffic_annotation_tag$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom', 'mutable_network_traffic_annotation_tag.mojom.js');
  }
  var net_log$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/net_log.mojom', 'net_log.mojom.js');
  }
  var network_annotation_monitor$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_annotation_monitor.mojom', 'network_annotation_monitor.mojom.js');
  }
  var network_change_manager$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_change_manager.mojom', 'network_change_manager.mojom.js');
  }
  var network_context$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_context.mojom', 'network_context.mojom.js');
  }
  var network_interface$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_interface.mojom', 'network_interface.mojom.js');
  }
  var network_interface_change_listener$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_interface_change_listener.mojom', 'network_interface_change_listener.mojom.js');
  }
  var network_param$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_param.mojom', 'network_param.mojom.js');
  }
  var network_quality_estimator_manager$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_quality_estimator_manager.mojom', 'network_quality_estimator_manager.mojom.js');
  }
  var network_service_test$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_service_test.mojom', 'network_service_test.mojom.js');
  }
  var parsed_headers$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/parsed_headers.mojom', 'parsed_headers.mojom.js');
  }
  var proxy_config$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/proxy_config.mojom', 'proxy_config.mojom.js');
  }
  var schemeful_site$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/schemeful_site.mojom', 'schemeful_site.mojom.js');
  }
  var source_type$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/source_type.mojom', 'source_type.mojom.js');
  }
  var system_dns_resolution$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/system_dns_resolution.mojom', 'system_dns_resolution.mojom.js');
  }
  var trust_tokens$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/trust_tokens.mojom', 'trust_tokens.mojom.js');
  }
  var url_loader$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_loader.mojom', 'url_loader.mojom.js');
  }
  var url_loader_network_service_observer$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_loader_network_service_observer.mojom', 'url_loader_network_service_observer.mojom.js');
  }
  var url_response_head$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_response_head.mojom', 'url_response_head.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../url/mojom/origin.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }
  var ct_log_info$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ct_log_info.mojom', 'ct_log_info.mojom.js');
  }



  function HttpAuthStaticParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpAuthStaticParams.prototype.initDefaults_ = function() {
    this.gssapiLibraryName = null;
  };
  HttpAuthStaticParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpAuthStaticParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpAuthStaticParams.gssapiLibraryName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HttpAuthStaticParams.encodedSize = codec.kStructHeaderSize + 8;

  HttpAuthStaticParams.decode = function(decoder) {
    var packed;
    var val = new HttpAuthStaticParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.gssapiLibraryName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  HttpAuthStaticParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpAuthStaticParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.gssapiLibraryName);
  };
  function HttpAuthDynamicParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpAuthDynamicParams.prototype.initDefaults_ = function() {
    this.allowedSchemes = null;
    this.patternsAllowedToUseAllSchemes = null;
    this.serverAllowlist = null;
    this.delegateAllowlist = null;
    this.delegateByKdcPolicy = false;
    this.negotiateDisableCnameLookup = false;
    this.enableNegotiatePort = false;
    this.ntlmV2Enabled = true;
    this.allowGssapiLibraryLoad = true;
    this.basicOverHttpEnabled = true;
    this.androidNegotiateAccountType = null;
  };
  HttpAuthDynamicParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpAuthDynamicParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpAuthDynamicParams.allowedSchemes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, true, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpAuthDynamicParams.patternsAllowedToUseAllSchemes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpAuthDynamicParams.serverAllowlist
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpAuthDynamicParams.delegateAllowlist
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;






    // validate HttpAuthDynamicParams.androidNegotiateAccountType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, false)
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  HttpAuthDynamicParams.encodedSize = codec.kStructHeaderSize + 48;

  HttpAuthDynamicParams.decode = function(decoder) {
    var packed;
    var val = new HttpAuthDynamicParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.allowedSchemes =
        decoder.decodeArrayPointer(codec.String);
    val.patternsAllowedToUseAllSchemes =
        decoder.decodeArrayPointer(codec.String);
    val.serverAllowlist =
        decoder.decodeStruct(codec.String);
    val.delegateAllowlist =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.delegateByKdcPolicy = (packed >> 0) & 1 ? true : false;
    val.negotiateDisableCnameLookup = (packed >> 1) & 1 ? true : false;
    val.enableNegotiatePort = (packed >> 2) & 1 ? true : false;
    val.ntlmV2Enabled = (packed >> 3) & 1 ? true : false;
    val.allowGssapiLibraryLoad = (packed >> 4) & 1 ? true : false;
    val.basicOverHttpEnabled = (packed >> 5) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.androidNegotiateAccountType =
        decoder.decodeStruct(codec.String);
    return val;
  };

  HttpAuthDynamicParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpAuthDynamicParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.allowedSchemes);
    encoder.encodeArrayPointer(codec.String, val.patternsAllowedToUseAllSchemes);
    encoder.encodeStruct(codec.String, val.serverAllowlist);
    encoder.encodeStruct(codec.String, val.delegateAllowlist);
    packed = 0;
    packed |= (val.delegateByKdcPolicy & 1) << 0
    packed |= (val.negotiateDisableCnameLookup & 1) << 1
    packed |= (val.enableNegotiatePort & 1) << 2
    packed |= (val.ntlmV2Enabled & 1) << 3
    packed |= (val.allowGssapiLibraryLoad & 1) << 4
    packed |= (val.basicOverHttpEnabled & 1) << 5
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.androidNegotiateAccountType);
  };
  function EnvironmentVariable(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EnvironmentVariable.prototype.initDefaults_ = function() {
    this.name = null;
    this.value = null;
  };
  EnvironmentVariable.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EnvironmentVariable.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EnvironmentVariable.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EnvironmentVariable.value
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EnvironmentVariable.encodedSize = codec.kStructHeaderSize + 16;

  EnvironmentVariable.decode = function(decoder) {
    var packed;
    var val = new EnvironmentVariable();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.value =
        decoder.decodeStruct(codec.String);
    return val;
  };

  EnvironmentVariable.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EnvironmentVariable.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.value);
  };
  function NetworkServiceParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkServiceParams.prototype.initDefaults_ = function() {
    this.initialConnectionType = network_change_manager$.ConnectionType.CONNECTION_UNKNOWN;
    this.initialConnectionSubtype = network_change_manager$.ConnectionSubtype.SUBTYPE_UNKNOWN;
    this.environment = null;
    this.defaultObserver = new url_loader_network_service_observer$.URLLoaderNetworkServiceObserverPtr();
    this.firstPartySetsEnabled = false;
    this.systemDnsResolver = new system_dns_resolution$.SystemDnsResolverPtr();
  };
  NetworkServiceParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkServiceParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceParams.initialConnectionType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, network_change_manager$.ConnectionType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceParams.initialConnectionSubtype
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, network_change_manager$.ConnectionSubtype);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceParams.environment
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(EnvironmentVariable), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkServiceParams.defaultObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkServiceParams.systemDnsResolver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 28, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkServiceParams.encodedSize = codec.kStructHeaderSize + 40;

  NetworkServiceParams.decode = function(decoder) {
    var packed;
    var val = new NetworkServiceParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.initialConnectionType =
        decoder.decodeStruct(new codec.Enum(network_change_manager$.ConnectionType));
    val.initialConnectionSubtype =
        decoder.decodeStruct(new codec.Enum(network_change_manager$.ConnectionSubtype));
    val.environment =
        decoder.decodeArrayPointer(new codec.PointerTo(EnvironmentVariable));
    val.defaultObserver =
        decoder.decodeStruct(new codec.Interface(url_loader_network_service_observer$.URLLoaderNetworkServiceObserverPtr));
    packed = decoder.readUint8();
    val.firstPartySetsEnabled = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.systemDnsResolver =
        decoder.decodeStruct(new codec.NullableInterface(system_dns_resolution$.SystemDnsResolverPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkServiceParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkServiceParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.initialConnectionType);
    encoder.encodeStruct(codec.Int32, val.initialConnectionSubtype);
    encoder.encodeArrayPointer(new codec.PointerTo(EnvironmentVariable), val.environment);
    encoder.encodeStruct(new codec.Interface(url_loader_network_service_observer$.URLLoaderNetworkServiceObserverPtr), val.defaultObserver);
    packed = 0;
    packed |= (val.firstPartySetsEnabled & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(new codec.NullableInterface(system_dns_resolution$.SystemDnsResolverPtr), val.systemDnsResolver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SCTAuditingConfiguration(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SCTAuditingConfiguration.prototype.initDefaults_ = function() {
    this.samplingRate = 0;
    this.logExpectedIngestionDelay = null;
    this.logMaxIngestionRandomDelay = null;
    this.reportUri = null;
    this.hashdanceLookupUri = null;
    this.trafficAnnotation = null;
    this.hashdanceTrafficAnnotation = null;
  };
  SCTAuditingConfiguration.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SCTAuditingConfiguration.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SCTAuditingConfiguration.logExpectedIngestionDelay
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SCTAuditingConfiguration.logMaxIngestionRandomDelay
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SCTAuditingConfiguration.reportUri
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SCTAuditingConfiguration.hashdanceLookupUri
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SCTAuditingConfiguration.trafficAnnotation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SCTAuditingConfiguration.hashdanceTrafficAnnotation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SCTAuditingConfiguration.encodedSize = codec.kStructHeaderSize + 56;

  SCTAuditingConfiguration.decode = function(decoder) {
    var packed;
    var val = new SCTAuditingConfiguration();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.samplingRate =
        decoder.decodeStruct(codec.Double);
    val.logExpectedIngestionDelay =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.logMaxIngestionRandomDelay =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.reportUri =
        decoder.decodeStructPointer(url$.Url);
    val.hashdanceLookupUri =
        decoder.decodeStructPointer(url$.Url);
    val.trafficAnnotation =
        decoder.decodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag);
    val.hashdanceTrafficAnnotation =
        decoder.decodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag);
    return val;
  };

  SCTAuditingConfiguration.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SCTAuditingConfiguration.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Double, val.samplingRate);
    encoder.encodeStructPointer(time$.TimeDelta, val.logExpectedIngestionDelay);
    encoder.encodeStructPointer(time$.TimeDelta, val.logMaxIngestionRandomDelay);
    encoder.encodeStructPointer(url$.Url, val.reportUri);
    encoder.encodeStructPointer(url$.Url, val.hashdanceLookupUri);
    encoder.encodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, val.trafficAnnotation);
    encoder.encodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, val.hashdanceTrafficAnnotation);
  };
  function NetworkService_SetParams_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_SetParams_Params.prototype.initDefaults_ = function() {
    this.params = null;
  };
  NetworkService_SetParams_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_SetParams_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_SetParams_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, NetworkServiceParams, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_SetParams_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_SetParams_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_SetParams_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.params =
        decoder.decodeStructPointer(NetworkServiceParams);
    return val;
  };

  NetworkService_SetParams_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_SetParams_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(NetworkServiceParams, val.params);
  };
  function NetworkService_StartNetLog_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_StartNetLog_Params.prototype.initDefaults_ = function() {
    this.file = null;
    this.maxTotalSize = 0;
    this.captureMode = 0;
    this.constants = null;
    this.duration = null;
  };
  NetworkService_StartNetLog_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_StartNetLog_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_StartNetLog_Params.file
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file$.File, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkService_StartNetLog_Params.captureMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, net_log$.NetLogCaptureMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_StartNetLog_Params.constants
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, values$.DictionaryValue, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_StartNetLog_Params.duration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_StartNetLog_Params.encodedSize = codec.kStructHeaderSize + 40;

  NetworkService_StartNetLog_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_StartNetLog_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.file =
        decoder.decodeStructPointer(file$.File);
    val.maxTotalSize =
        decoder.decodeStruct(codec.Uint64);
    val.captureMode =
        decoder.decodeStruct(new codec.Enum(net_log$.NetLogCaptureMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.constants =
        decoder.decodeStructPointer(values$.DictionaryValue);
    val.duration =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  NetworkService_StartNetLog_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_StartNetLog_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file$.File, val.file);
    encoder.encodeStruct(codec.Uint64, val.maxTotalSize);
    encoder.encodeStruct(codec.Int32, val.captureMode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(values$.DictionaryValue, val.constants);
    encoder.encodeStructPointer(time$.TimeDelta, val.duration);
  };
  function NetworkService_AttachNetLogProxy_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_AttachNetLogProxy_Params.prototype.initDefaults_ = function() {
    this.proxySource = new net_log$.NetLogProxySourcePtr();
    this.proxySink = new bindings.InterfaceRequest();
  };
  NetworkService_AttachNetLogProxy_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_AttachNetLogProxy_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_AttachNetLogProxy_Params.proxySource
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_AttachNetLogProxy_Params.proxySink
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_AttachNetLogProxy_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkService_AttachNetLogProxy_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_AttachNetLogProxy_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.proxySource =
        decoder.decodeStruct(new codec.Interface(net_log$.NetLogProxySourcePtr));
    val.proxySink =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkService_AttachNetLogProxy_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_AttachNetLogProxy_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(net_log$.NetLogProxySourcePtr), val.proxySource);
    encoder.encodeStruct(codec.InterfaceRequest, val.proxySink);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkService_SetSSLKeyLogFile_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_SetSSLKeyLogFile_Params.prototype.initDefaults_ = function() {
    this.file = null;
  };
  NetworkService_SetSSLKeyLogFile_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_SetSSLKeyLogFile_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_SetSSLKeyLogFile_Params.file
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file$.File, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_SetSSLKeyLogFile_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_SetSSLKeyLogFile_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_SetSSLKeyLogFile_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.file =
        decoder.decodeStructPointer(file$.File);
    return val;
  };

  NetworkService_SetSSLKeyLogFile_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_SetSSLKeyLogFile_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file$.File, val.file);
  };
  function NetworkService_CreateNetworkContext_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_CreateNetworkContext_Params.prototype.initDefaults_ = function() {
    this.context = new bindings.InterfaceRequest();
    this.params = null;
  };
  NetworkService_CreateNetworkContext_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_CreateNetworkContext_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_CreateNetworkContext_Params.context
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_CreateNetworkContext_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, network_context$.NetworkContextParams, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_CreateNetworkContext_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkService_CreateNetworkContext_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_CreateNetworkContext_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.context =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.params =
        decoder.decodeStructPointer(network_context$.NetworkContextParams);
    return val;
  };

  NetworkService_CreateNetworkContext_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_CreateNetworkContext_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.context);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(network_context$.NetworkContextParams, val.params);
  };
  function NetworkService_ConfigureStubHostResolver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_ConfigureStubHostResolver_Params.prototype.initDefaults_ = function() {
    this.insecureDnsClientEnabled = false;
    this.happyEyeballsV3Enabled = false;
    this.additionalDnsTypesEnabled = false;
    this.secureDnsMode = 0;
    this.dnsOverHttpsConfig = null;
    this.fallbackDohNameservers = null;
  };
  NetworkService_ConfigureStubHostResolver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_ConfigureStubHostResolver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate NetworkService_ConfigureStubHostResolver_Params.secureDnsMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, host_resolver$.SecureDnsMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_ConfigureStubHostResolver_Params.dnsOverHttpsConfig
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, host_resolver$.DnsOverHttpsConfig, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkService_ConfigureStubHostResolver_Params.fallbackDohNameservers
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(ip_endpoint$.IPEndPoint), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_ConfigureStubHostResolver_Params.encodedSize = codec.kStructHeaderSize + 24;

  NetworkService_ConfigureStubHostResolver_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_ConfigureStubHostResolver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.insecureDnsClientEnabled = (packed >> 0) & 1 ? true : false;
    val.happyEyeballsV3Enabled = (packed >> 1) & 1 ? true : false;
    val.additionalDnsTypesEnabled = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.secureDnsMode =
        decoder.decodeStruct(new codec.Enum(host_resolver$.SecureDnsMode));
    val.dnsOverHttpsConfig =
        decoder.decodeStructPointer(host_resolver$.DnsOverHttpsConfig);
    val.fallbackDohNameservers =
        decoder.decodeArrayPointer(new codec.PointerTo(ip_endpoint$.IPEndPoint));
    return val;
  };

  NetworkService_ConfigureStubHostResolver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_ConfigureStubHostResolver_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.insecureDnsClientEnabled & 1) << 0
    packed |= (val.happyEyeballsV3Enabled & 1) << 1
    packed |= (val.additionalDnsTypesEnabled & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.secureDnsMode);
    encoder.encodeStructPointer(host_resolver$.DnsOverHttpsConfig, val.dnsOverHttpsConfig);
    encoder.encodeArrayPointer(new codec.PointerTo(ip_endpoint$.IPEndPoint), val.fallbackDohNameservers);
  };
  function NetworkService_DisableQuic_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_DisableQuic_Params.prototype.initDefaults_ = function() {
  };
  NetworkService_DisableQuic_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_DisableQuic_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_DisableQuic_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkService_DisableQuic_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_DisableQuic_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkService_DisableQuic_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_DisableQuic_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkService_SetUpHttpAuth_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_SetUpHttpAuth_Params.prototype.initDefaults_ = function() {
    this.httpAuthStaticParams = null;
  };
  NetworkService_SetUpHttpAuth_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_SetUpHttpAuth_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_SetUpHttpAuth_Params.httpAuthStaticParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, HttpAuthStaticParams, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_SetUpHttpAuth_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_SetUpHttpAuth_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_SetUpHttpAuth_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.httpAuthStaticParams =
        decoder.decodeStructPointer(HttpAuthStaticParams);
    return val;
  };

  NetworkService_SetUpHttpAuth_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_SetUpHttpAuth_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(HttpAuthStaticParams, val.httpAuthStaticParams);
  };
  function NetworkService_ConfigureHttpAuthPrefs_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_ConfigureHttpAuthPrefs_Params.prototype.initDefaults_ = function() {
    this.httpAuthDynamicParams = null;
  };
  NetworkService_ConfigureHttpAuthPrefs_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_ConfigureHttpAuthPrefs_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_ConfigureHttpAuthPrefs_Params.httpAuthDynamicParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, HttpAuthDynamicParams, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_ConfigureHttpAuthPrefs_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_ConfigureHttpAuthPrefs_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_ConfigureHttpAuthPrefs_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.httpAuthDynamicParams =
        decoder.decodeStructPointer(HttpAuthDynamicParams);
    return val;
  };

  NetworkService_ConfigureHttpAuthPrefs_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_ConfigureHttpAuthPrefs_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(HttpAuthDynamicParams, val.httpAuthDynamicParams);
  };
  function NetworkService_SetRawHeadersAccess_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_SetRawHeadersAccess_Params.prototype.initDefaults_ = function() {
    this.processId = 0;
    this.origins = null;
  };
  NetworkService_SetRawHeadersAccess_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_SetRawHeadersAccess_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkService_SetRawHeadersAccess_Params.origins
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(origin$.Origin), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_SetRawHeadersAccess_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkService_SetRawHeadersAccess_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_SetRawHeadersAccess_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.processId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.origins =
        decoder.decodeArrayPointer(new codec.PointerTo(origin$.Origin));
    return val;
  };

  NetworkService_SetRawHeadersAccess_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_SetRawHeadersAccess_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.processId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(origin$.Origin), val.origins);
  };
  function NetworkService_SetMaxConnectionsPerProxyChain_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_SetMaxConnectionsPerProxyChain_Params.prototype.initDefaults_ = function() {
    this.maxConnections = 0;
  };
  NetworkService_SetMaxConnectionsPerProxyChain_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_SetMaxConnectionsPerProxyChain_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkService_SetMaxConnectionsPerProxyChain_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_SetMaxConnectionsPerProxyChain_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_SetMaxConnectionsPerProxyChain_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.maxConnections =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkService_SetMaxConnectionsPerProxyChain_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_SetMaxConnectionsPerProxyChain_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.maxConnections);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkService_GetNetworkChangeManager_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_GetNetworkChangeManager_Params.prototype.initDefaults_ = function() {
    this.networkChangeManager = new bindings.InterfaceRequest();
  };
  NetworkService_GetNetworkChangeManager_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_GetNetworkChangeManager_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_GetNetworkChangeManager_Params.networkChangeManager
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_GetNetworkChangeManager_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_GetNetworkChangeManager_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_GetNetworkChangeManager_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.networkChangeManager =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkService_GetNetworkChangeManager_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_GetNetworkChangeManager_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.networkChangeManager);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkService_GetNetworkQualityEstimatorManager_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_GetNetworkQualityEstimatorManager_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  NetworkService_GetNetworkQualityEstimatorManager_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_GetNetworkQualityEstimatorManager_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_GetNetworkQualityEstimatorManager_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_GetNetworkQualityEstimatorManager_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_GetNetworkQualityEstimatorManager_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_GetNetworkQualityEstimatorManager_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkService_GetNetworkQualityEstimatorManager_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_GetNetworkQualityEstimatorManager_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkService_GetDnsConfigChangeManager_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_GetDnsConfigChangeManager_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  NetworkService_GetDnsConfigChangeManager_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_GetDnsConfigChangeManager_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_GetDnsConfigChangeManager_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_GetDnsConfigChangeManager_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_GetDnsConfigChangeManager_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_GetDnsConfigChangeManager_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkService_GetDnsConfigChangeManager_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_GetDnsConfigChangeManager_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkService_GetNetworkList_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_GetNetworkList_Params.prototype.initDefaults_ = function() {
    this.policy = 0;
  };
  NetworkService_GetNetworkList_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_GetNetworkList_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkService_GetNetworkList_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_GetNetworkList_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_GetNetworkList_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.policy =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkService_GetNetworkList_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_GetNetworkList_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.policy);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkService_GetNetworkList_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_GetNetworkList_ResponseParams.prototype.initDefaults_ = function() {
    this.networks = null;
  };
  NetworkService_GetNetworkList_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_GetNetworkList_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_GetNetworkList_ResponseParams.networks
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(network_interface$.NetworkInterface), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_GetNetworkList_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_GetNetworkList_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkService_GetNetworkList_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.networks =
        decoder.decodeArrayPointer(new codec.PointerTo(network_interface$.NetworkInterface));
    return val;
  };

  NetworkService_GetNetworkList_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_GetNetworkList_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(network_interface$.NetworkInterface), val.networks);
  };
  function NetworkService_OnTrustStoreChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_OnTrustStoreChanged_Params.prototype.initDefaults_ = function() {
  };
  NetworkService_OnTrustStoreChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_OnTrustStoreChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_OnTrustStoreChanged_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkService_OnTrustStoreChanged_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_OnTrustStoreChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkService_OnTrustStoreChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_OnTrustStoreChanged_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkService_OnClientCertStoreChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_OnClientCertStoreChanged_Params.prototype.initDefaults_ = function() {
  };
  NetworkService_OnClientCertStoreChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_OnClientCertStoreChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_OnClientCertStoreChanged_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkService_OnClientCertStoreChanged_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_OnClientCertStoreChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkService_OnClientCertStoreChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_OnClientCertStoreChanged_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkService_SetEncryptionKey_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_SetEncryptionKey_Params.prototype.initDefaults_ = function() {
    this.encryptionKey = null;
  };
  NetworkService_SetEncryptionKey_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_SetEncryptionKey_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_SetEncryptionKey_Params.encryptionKey
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, byte_string$.ByteString, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_SetEncryptionKey_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_SetEncryptionKey_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_SetEncryptionKey_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.encryptionKey =
        decoder.decodeStructPointer(byte_string$.ByteString);
    return val;
  };

  NetworkService_SetEncryptionKey_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_SetEncryptionKey_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(byte_string$.ByteString, val.encryptionKey);
  };
  function NetworkService_OnMemoryPressure_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_OnMemoryPressure_Params.prototype.initDefaults_ = function() {
    this.memoryPressureLevel = 0;
  };
  NetworkService_OnMemoryPressure_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_OnMemoryPressure_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_OnMemoryPressure_Params.memoryPressureLevel
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, memory_pressure_level$.MemoryPressureLevel);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_OnMemoryPressure_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_OnMemoryPressure_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_OnMemoryPressure_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.memoryPressureLevel =
        decoder.decodeStruct(new codec.Enum(memory_pressure_level$.MemoryPressureLevel));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkService_OnMemoryPressure_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_OnMemoryPressure_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.memoryPressureLevel);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkService_OnPeerToPeerConnectionsCountChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_OnPeerToPeerConnectionsCountChange_Params.prototype.initDefaults_ = function() {
    this.count = 0;
  };
  NetworkService_OnPeerToPeerConnectionsCountChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_OnPeerToPeerConnectionsCountChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkService_OnPeerToPeerConnectionsCountChange_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_OnPeerToPeerConnectionsCountChange_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_OnPeerToPeerConnectionsCountChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.count =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkService_OnPeerToPeerConnectionsCountChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_OnPeerToPeerConnectionsCountChange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.count);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkService_SetTrustTokenKeyCommitments_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_SetTrustTokenKeyCommitments_Params.prototype.initDefaults_ = function() {
    this.rawCommitments = null;
  };
  NetworkService_SetTrustTokenKeyCommitments_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_SetTrustTokenKeyCommitments_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_SetTrustTokenKeyCommitments_Params.rawCommitments
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_SetTrustTokenKeyCommitments_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_SetTrustTokenKeyCommitments_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_SetTrustTokenKeyCommitments_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.rawCommitments =
        decoder.decodeStruct(codec.String);
    return val;
  };

  NetworkService_SetTrustTokenKeyCommitments_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_SetTrustTokenKeyCommitments_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.rawCommitments);
  };
  function NetworkService_SetTrustTokenKeyCommitments_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_SetTrustTokenKeyCommitments_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkService_SetTrustTokenKeyCommitments_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_SetTrustTokenKeyCommitments_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_SetTrustTokenKeyCommitments_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkService_SetTrustTokenKeyCommitments_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkService_SetTrustTokenKeyCommitments_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkService_SetTrustTokenKeyCommitments_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_SetTrustTokenKeyCommitments_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkService_ClearSCTAuditingCache_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_ClearSCTAuditingCache_Params.prototype.initDefaults_ = function() {
  };
  NetworkService_ClearSCTAuditingCache_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_ClearSCTAuditingCache_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_ClearSCTAuditingCache_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkService_ClearSCTAuditingCache_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_ClearSCTAuditingCache_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkService_ClearSCTAuditingCache_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_ClearSCTAuditingCache_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkService_ConfigureSCTAuditing_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_ConfigureSCTAuditing_Params.prototype.initDefaults_ = function() {
    this.configuration = null;
  };
  NetworkService_ConfigureSCTAuditing_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_ConfigureSCTAuditing_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_ConfigureSCTAuditing_Params.configuration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SCTAuditingConfiguration, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_ConfigureSCTAuditing_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_ConfigureSCTAuditing_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_ConfigureSCTAuditing_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.configuration =
        decoder.decodeStructPointer(SCTAuditingConfiguration);
    return val;
  };

  NetworkService_ConfigureSCTAuditing_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_ConfigureSCTAuditing_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SCTAuditingConfiguration, val.configuration);
  };
  function NetworkService_UpdateCtLogList_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_UpdateCtLogList_Params.prototype.initDefaults_ = function() {
    this.logList = null;
  };
  NetworkService_UpdateCtLogList_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_UpdateCtLogList_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_UpdateCtLogList_Params.logList
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(ct_log_info$.CTLogInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_UpdateCtLogList_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_UpdateCtLogList_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_UpdateCtLogList_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.logList =
        decoder.decodeArrayPointer(new codec.PointerTo(ct_log_info$.CTLogInfo));
    return val;
  };

  NetworkService_UpdateCtLogList_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_UpdateCtLogList_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(ct_log_info$.CTLogInfo), val.logList);
  };
  function NetworkService_UpdateCtLogList_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_UpdateCtLogList_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkService_UpdateCtLogList_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_UpdateCtLogList_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_UpdateCtLogList_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkService_UpdateCtLogList_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkService_UpdateCtLogList_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkService_UpdateCtLogList_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_UpdateCtLogList_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkService_UpdateCtKnownPopularSCTs_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_UpdateCtKnownPopularSCTs_Params.prototype.initDefaults_ = function() {
    this.sctHashes = null;
  };
  NetworkService_UpdateCtKnownPopularSCTs_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_UpdateCtKnownPopularSCTs_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_UpdateCtKnownPopularSCTs_Params.sctHashes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.ArrayOf(codec.Uint8), false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_UpdateCtKnownPopularSCTs_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_UpdateCtKnownPopularSCTs_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_UpdateCtKnownPopularSCTs_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sctHashes =
        decoder.decodeArrayPointer(new codec.ArrayOf(codec.Uint8));
    return val;
  };

  NetworkService_UpdateCtKnownPopularSCTs_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_UpdateCtKnownPopularSCTs_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.ArrayOf(codec.Uint8), val.sctHashes);
  };
  function NetworkService_UpdateCtKnownPopularSCTs_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_UpdateCtKnownPopularSCTs_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkService_UpdateCtKnownPopularSCTs_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_UpdateCtKnownPopularSCTs_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_UpdateCtKnownPopularSCTs_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkService_UpdateCtKnownPopularSCTs_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkService_UpdateCtKnownPopularSCTs_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkService_UpdateCtKnownPopularSCTs_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_UpdateCtKnownPopularSCTs_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkService_SetCtEnforcementEnabled_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_SetCtEnforcementEnabled_Params.prototype.initDefaults_ = function() {
    this.enabled = false;
  };
  NetworkService_SetCtEnforcementEnabled_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_SetCtEnforcementEnabled_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkService_SetCtEnforcementEnabled_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_SetCtEnforcementEnabled_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_SetCtEnforcementEnabled_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.enabled = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkService_SetCtEnforcementEnabled_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_SetCtEnforcementEnabled_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.enabled & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkService_SetCtEnforcementEnabled_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_SetCtEnforcementEnabled_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkService_SetCtEnforcementEnabled_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_SetCtEnforcementEnabled_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_SetCtEnforcementEnabled_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkService_SetCtEnforcementEnabled_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkService_SetCtEnforcementEnabled_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkService_SetCtEnforcementEnabled_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_SetCtEnforcementEnabled_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkService_UpdateKeyPinsList_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_UpdateKeyPinsList_Params.prototype.initDefaults_ = function() {
    this.pinList = null;
    this.updateTime = null;
  };
  NetworkService_UpdateKeyPinsList_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_UpdateKeyPinsList_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_UpdateKeyPinsList_Params.pinList
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, key_pinning$.PinList, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_UpdateKeyPinsList_Params.updateTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_UpdateKeyPinsList_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkService_UpdateKeyPinsList_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_UpdateKeyPinsList_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pinList =
        decoder.decodeStructPointer(key_pinning$.PinList);
    val.updateTime =
        decoder.decodeStructPointer(time$.Time);
    return val;
  };

  NetworkService_UpdateKeyPinsList_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_UpdateKeyPinsList_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(key_pinning$.PinList, val.pinList);
    encoder.encodeStructPointer(time$.Time, val.updateTime);
  };
  function NetworkService_BindTestInterfaceForTesting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_BindTestInterfaceForTesting_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  NetworkService_BindTestInterfaceForTesting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_BindTestInterfaceForTesting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_BindTestInterfaceForTesting_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_BindTestInterfaceForTesting_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_BindTestInterfaceForTesting_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_BindTestInterfaceForTesting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkService_BindTestInterfaceForTesting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_BindTestInterfaceForTesting_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkService_SetFirstPartySets_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_SetFirstPartySets_Params.prototype.initDefaults_ = function() {
    this.sets = null;
  };
  NetworkService_SetFirstPartySets_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_SetFirstPartySets_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_SetFirstPartySets_Params.sets
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, first_party_sets$.GlobalFirstPartySets, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_SetFirstPartySets_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_SetFirstPartySets_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_SetFirstPartySets_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sets =
        decoder.decodeStructPointer(first_party_sets$.GlobalFirstPartySets);
    return val;
  };

  NetworkService_SetFirstPartySets_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_SetFirstPartySets_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(first_party_sets$.GlobalFirstPartySets, val.sets);
  };
  function NetworkService_SetExplicitlyAllowedPorts_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_SetExplicitlyAllowedPorts_Params.prototype.initDefaults_ = function() {
    this.ports = null;
  };
  NetworkService_SetExplicitlyAllowedPorts_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_SetExplicitlyAllowedPorts_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_SetExplicitlyAllowedPorts_Params.ports
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 2, codec.Uint16, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_SetExplicitlyAllowedPorts_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_SetExplicitlyAllowedPorts_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_SetExplicitlyAllowedPorts_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.ports =
        decoder.decodeArrayPointer(codec.Uint16);
    return val;
  };

  NetworkService_SetExplicitlyAllowedPorts_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_SetExplicitlyAllowedPorts_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint16, val.ports);
  };
  function NetworkService_ParseHeaders_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_ParseHeaders_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.headers = null;
  };
  NetworkService_ParseHeaders_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_ParseHeaders_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_ParseHeaders_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_ParseHeaders_Params.headers
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, network_param$.HttpResponseHeaders, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_ParseHeaders_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkService_ParseHeaders_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_ParseHeaders_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.headers =
        decoder.decodeStructPointer(network_param$.HttpResponseHeaders);
    return val;
  };

  NetworkService_ParseHeaders_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_ParseHeaders_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(network_param$.HttpResponseHeaders, val.headers);
  };
  function NetworkService_ParseHeaders_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_ParseHeaders_ResponseParams.prototype.initDefaults_ = function() {
    this.parsedHeaders = null;
  };
  NetworkService_ParseHeaders_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_ParseHeaders_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_ParseHeaders_ResponseParams.parsedHeaders
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, parsed_headers$.ParsedHeaders, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_ParseHeaders_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_ParseHeaders_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkService_ParseHeaders_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.parsedHeaders =
        decoder.decodeStructPointer(parsed_headers$.ParsedHeaders);
    return val;
  };

  NetworkService_ParseHeaders_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_ParseHeaders_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(parsed_headers$.ParsedHeaders, val.parsedHeaders);
  };
  function NetworkService_EnableDataUseUpdates_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_EnableDataUseUpdates_Params.prototype.initDefaults_ = function() {
    this.enable = false;
  };
  NetworkService_EnableDataUseUpdates_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_EnableDataUseUpdates_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkService_EnableDataUseUpdates_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_EnableDataUseUpdates_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_EnableDataUseUpdates_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.enable = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkService_EnableDataUseUpdates_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_EnableDataUseUpdates_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.enable & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkService_SetIPv6ReachabilityOverride_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_SetIPv6ReachabilityOverride_Params.prototype.initDefaults_ = function() {
    this.reachabilityOverride = false;
  };
  NetworkService_SetIPv6ReachabilityOverride_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_SetIPv6ReachabilityOverride_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkService_SetIPv6ReachabilityOverride_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_SetIPv6ReachabilityOverride_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_SetIPv6ReachabilityOverride_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.reachabilityOverride = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkService_SetIPv6ReachabilityOverride_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_SetIPv6ReachabilityOverride_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.reachabilityOverride & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkService_SetNetworkAnnotationMonitor_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_SetNetworkAnnotationMonitor_Params.prototype.initDefaults_ = function() {
    this.remote = new network_annotation_monitor$.NetworkAnnotationMonitorPtr();
  };
  NetworkService_SetNetworkAnnotationMonitor_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_SetNetworkAnnotationMonitor_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_SetNetworkAnnotationMonitor_Params.remote
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_SetNetworkAnnotationMonitor_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_SetNetworkAnnotationMonitor_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_SetNetworkAnnotationMonitor_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.remote =
        decoder.decodeStruct(new codec.Interface(network_annotation_monitor$.NetworkAnnotationMonitorPtr));
    return val;
  };

  NetworkService_SetNetworkAnnotationMonitor_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_SetNetworkAnnotationMonitor_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(network_annotation_monitor$.NetworkAnnotationMonitorPtr), val.remote);
  };
  function NetworkService_SetTpcdMetadataGrants_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_SetTpcdMetadataGrants_Params.prototype.initDefaults_ = function() {
    this.settings = null;
  };
  NetworkService_SetTpcdMetadataGrants_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_SetTpcdMetadataGrants_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_SetTpcdMetadataGrants_Params.settings
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(content_settings$.ContentSettingPatternSource), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_SetTpcdMetadataGrants_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_SetTpcdMetadataGrants_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_SetTpcdMetadataGrants_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.settings =
        decoder.decodeArrayPointer(new codec.PointerTo(content_settings$.ContentSettingPatternSource));
    return val;
  };

  NetworkService_SetTpcdMetadataGrants_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_SetTpcdMetadataGrants_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(content_settings$.ContentSettingPatternSource), val.settings);
  };
  function NetworkService_InterceptUrlLoaderForBodyDecoding_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_InterceptUrlLoaderForBodyDecoding_Params.prototype.initDefaults_ = function() {
    this.contentEncodingTypes = null;
    this.sourceBody = null;
    this.destBody = null;
    this.sourceUrlLoader = new url_loader$.URLLoaderPtr();
    this.sourceUrlLoaderClient = new bindings.InterfaceRequest();
    this.destUrlLoader = new bindings.InterfaceRequest();
    this.destUrlLoaderClient = new url_loader$.URLLoaderClientPtr();
  };
  NetworkService_InterceptUrlLoaderForBodyDecoding_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_InterceptUrlLoaderForBodyDecoding_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_InterceptUrlLoaderForBodyDecoding_Params.contentEncodingTypes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, new codec.Enum(source_type$.SourceType), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_InterceptUrlLoaderForBodyDecoding_Params.sourceBody
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_InterceptUrlLoaderForBodyDecoding_Params.destBody
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 12, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_InterceptUrlLoaderForBodyDecoding_Params.sourceUrlLoader
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_InterceptUrlLoaderForBodyDecoding_Params.sourceUrlLoaderClient
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_InterceptUrlLoaderForBodyDecoding_Params.destUrlLoader
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 28, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_InterceptUrlLoaderForBodyDecoding_Params.destUrlLoaderClient
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 32, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_InterceptUrlLoaderForBodyDecoding_Params.encodedSize = codec.kStructHeaderSize + 40;

  NetworkService_InterceptUrlLoaderForBodyDecoding_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_InterceptUrlLoaderForBodyDecoding_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.contentEncodingTypes =
        decoder.decodeArrayPointer(new codec.Enum(source_type$.SourceType));
    val.sourceBody =
        decoder.decodeStruct(codec.Handle);
    val.destBody =
        decoder.decodeStruct(codec.Handle);
    val.sourceUrlLoader =
        decoder.decodeStruct(new codec.Interface(url_loader$.URLLoaderPtr));
    val.sourceUrlLoaderClient =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.destUrlLoader =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.destUrlLoaderClient =
        decoder.decodeStruct(new codec.Interface(url_loader$.URLLoaderClientPtr));
    return val;
  };

  NetworkService_InterceptUrlLoaderForBodyDecoding_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_InterceptUrlLoaderForBodyDecoding_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.Enum(source_type$.SourceType), val.contentEncodingTypes);
    encoder.encodeStruct(codec.Handle, val.sourceBody);
    encoder.encodeStruct(codec.Handle, val.destBody);
    encoder.encodeStruct(new codec.Interface(url_loader$.URLLoaderPtr), val.sourceUrlLoader);
    encoder.encodeStruct(codec.InterfaceRequest, val.sourceUrlLoaderClient);
    encoder.encodeStruct(codec.InterfaceRequest, val.destUrlLoader);
    encoder.encodeStruct(new codec.Interface(url_loader$.URLLoaderClientPtr), val.destUrlLoaderClient);
  };
  function NetworkService_DecodeContentEncoding_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_DecodeContentEncoding_Params.prototype.initDefaults_ = function() {
    this.contentEncodingTypes = null;
    this.sourceBody = null;
    this.destBody = null;
  };
  NetworkService_DecodeContentEncoding_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_DecodeContentEncoding_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_DecodeContentEncoding_Params.contentEncodingTypes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, new codec.Enum(source_type$.SourceType), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_DecodeContentEncoding_Params.sourceBody
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkService_DecodeContentEncoding_Params.destBody
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 12, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkService_DecodeContentEncoding_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkService_DecodeContentEncoding_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_DecodeContentEncoding_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.contentEncodingTypes =
        decoder.decodeArrayPointer(new codec.Enum(source_type$.SourceType));
    val.sourceBody =
        decoder.decodeStruct(codec.Handle);
    val.destBody =
        decoder.decodeStruct(codec.Handle);
    return val;
  };

  NetworkService_DecodeContentEncoding_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_DecodeContentEncoding_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.Enum(source_type$.SourceType), val.contentEncodingTypes);
    encoder.encodeStruct(codec.Handle, val.sourceBody);
    encoder.encodeStruct(codec.Handle, val.destBody);
  };
  function NetworkService_DecodeContentEncoding_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_DecodeContentEncoding_ResponseParams.prototype.initDefaults_ = function() {
    this.errorCode = 0;
  };
  NetworkService_DecodeContentEncoding_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_DecodeContentEncoding_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkService_DecodeContentEncoding_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_DecodeContentEncoding_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkService_DecodeContentEncoding_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.errorCode =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkService_DecodeContentEncoding_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_DecodeContentEncoding_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.errorCode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkService_SetTLS13EarlyDataEnabled_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkService_SetTLS13EarlyDataEnabled_Params.prototype.initDefaults_ = function() {
    this.enabled = false;
  };
  NetworkService_SetTLS13EarlyDataEnabled_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkService_SetTLS13EarlyDataEnabled_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkService_SetTLS13EarlyDataEnabled_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkService_SetTLS13EarlyDataEnabled_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkService_SetTLS13EarlyDataEnabled_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.enabled = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkService_SetTLS13EarlyDataEnabled_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkService_SetTLS13EarlyDataEnabled_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.enabled & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kNetworkService_SetParams_Name = 0;
  var kNetworkService_StartNetLog_Name = 1;
  var kNetworkService_AttachNetLogProxy_Name = 2;
  var kNetworkService_SetSSLKeyLogFile_Name = 3;
  var kNetworkService_CreateNetworkContext_Name = 4;
  var kNetworkService_ConfigureStubHostResolver_Name = 5;
  var kNetworkService_DisableQuic_Name = 6;
  var kNetworkService_SetUpHttpAuth_Name = 7;
  var kNetworkService_ConfigureHttpAuthPrefs_Name = 8;
  var kNetworkService_SetRawHeadersAccess_Name = 9;
  var kNetworkService_SetMaxConnectionsPerProxyChain_Name = 10;
  var kNetworkService_GetNetworkChangeManager_Name = 11;
  var kNetworkService_GetNetworkQualityEstimatorManager_Name = 12;
  var kNetworkService_GetDnsConfigChangeManager_Name = 13;
  var kNetworkService_GetNetworkList_Name = 14;
  var kNetworkService_OnTrustStoreChanged_Name = 15;
  var kNetworkService_OnClientCertStoreChanged_Name = 16;
  var kNetworkService_SetEncryptionKey_Name = 17;
  var kNetworkService_OnMemoryPressure_Name = 18;
  var kNetworkService_OnPeerToPeerConnectionsCountChange_Name = 19;
  var kNetworkService_SetTrustTokenKeyCommitments_Name = 20;
  var kNetworkService_ClearSCTAuditingCache_Name = 21;
  var kNetworkService_ConfigureSCTAuditing_Name = 22;
  var kNetworkService_UpdateCtLogList_Name = 23;
  var kNetworkService_UpdateCtKnownPopularSCTs_Name = 24;
  var kNetworkService_SetCtEnforcementEnabled_Name = 25;
  var kNetworkService_UpdateKeyPinsList_Name = 26;
  var kNetworkService_BindTestInterfaceForTesting_Name = 27;
  var kNetworkService_SetFirstPartySets_Name = 28;
  var kNetworkService_SetExplicitlyAllowedPorts_Name = 29;
  var kNetworkService_ParseHeaders_Name = 30;
  var kNetworkService_EnableDataUseUpdates_Name = 31;
  var kNetworkService_SetIPv6ReachabilityOverride_Name = 32;
  var kNetworkService_SetNetworkAnnotationMonitor_Name = 33;
  var kNetworkService_SetTpcdMetadataGrants_Name = 34;
  var kNetworkService_InterceptUrlLoaderForBodyDecoding_Name = 35;
  var kNetworkService_DecodeContentEncoding_Name = 36;
  var kNetworkService_SetTLS13EarlyDataEnabled_Name = 37;

  function NetworkServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(NetworkService,
                                                   handleOrPtrInfo);
  }

  function NetworkServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        NetworkService, associatedInterfacePtrInfo);
  }

  NetworkServiceAssociatedPtr.prototype =
      Object.create(NetworkServicePtr.prototype);
  NetworkServiceAssociatedPtr.prototype.constructor =
      NetworkServiceAssociatedPtr;

  function NetworkServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  NetworkServicePtr.prototype.setParams = function() {
    return NetworkServiceProxy.prototype.setParams
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.setParams = function(params) {
    var params_ = new NetworkService_SetParams_Params();
    params_.params = params;
    var builder = new codec.MessageV0Builder(
        kNetworkService_SetParams_Name,
        codec.align(NetworkService_SetParams_Params.encodedSize));
    builder.encodeStruct(NetworkService_SetParams_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.startNetLog = function() {
    return NetworkServiceProxy.prototype.startNetLog
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.startNetLog = function(file, maxTotalSize, captureMode, constants, duration) {
    var params_ = new NetworkService_StartNetLog_Params();
    params_.file = file;
    params_.maxTotalSize = maxTotalSize;
    params_.captureMode = captureMode;
    params_.constants = constants;
    params_.duration = duration;
    var builder = new codec.MessageV0Builder(
        kNetworkService_StartNetLog_Name,
        codec.align(NetworkService_StartNetLog_Params.encodedSize));
    builder.encodeStruct(NetworkService_StartNetLog_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.attachNetLogProxy = function() {
    return NetworkServiceProxy.prototype.attachNetLogProxy
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.attachNetLogProxy = function(proxySource, proxySink) {
    var params_ = new NetworkService_AttachNetLogProxy_Params();
    params_.proxySource = proxySource;
    params_.proxySink = proxySink;
    var builder = new codec.MessageV0Builder(
        kNetworkService_AttachNetLogProxy_Name,
        codec.align(NetworkService_AttachNetLogProxy_Params.encodedSize));
    builder.encodeStruct(NetworkService_AttachNetLogProxy_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.setSSLKeyLogFile = function() {
    return NetworkServiceProxy.prototype.setSSLKeyLogFile
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.setSSLKeyLogFile = function(file) {
    var params_ = new NetworkService_SetSSLKeyLogFile_Params();
    params_.file = file;
    var builder = new codec.MessageV0Builder(
        kNetworkService_SetSSLKeyLogFile_Name,
        codec.align(NetworkService_SetSSLKeyLogFile_Params.encodedSize));
    builder.encodeStruct(NetworkService_SetSSLKeyLogFile_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.createNetworkContext = function() {
    return NetworkServiceProxy.prototype.createNetworkContext
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.createNetworkContext = function(context, params) {
    var params_ = new NetworkService_CreateNetworkContext_Params();
    params_.context = context;
    params_.params = params;
    var builder = new codec.MessageV0Builder(
        kNetworkService_CreateNetworkContext_Name,
        codec.align(NetworkService_CreateNetworkContext_Params.encodedSize));
    builder.encodeStruct(NetworkService_CreateNetworkContext_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.configureStubHostResolver = function() {
    return NetworkServiceProxy.prototype.configureStubHostResolver
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.configureStubHostResolver = function(insecureDnsClientEnabled, happyEyeballsV3Enabled, secureDnsMode, dnsOverHttpsConfig, additionalDnsTypesEnabled, fallbackDohNameservers) {
    var params_ = new NetworkService_ConfigureStubHostResolver_Params();
    params_.insecureDnsClientEnabled = insecureDnsClientEnabled;
    params_.happyEyeballsV3Enabled = happyEyeballsV3Enabled;
    params_.secureDnsMode = secureDnsMode;
    params_.dnsOverHttpsConfig = dnsOverHttpsConfig;
    params_.additionalDnsTypesEnabled = additionalDnsTypesEnabled;
    params_.fallbackDohNameservers = fallbackDohNameservers;
    var builder = new codec.MessageV0Builder(
        kNetworkService_ConfigureStubHostResolver_Name,
        codec.align(NetworkService_ConfigureStubHostResolver_Params.encodedSize));
    builder.encodeStruct(NetworkService_ConfigureStubHostResolver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.disableQuic = function() {
    return NetworkServiceProxy.prototype.disableQuic
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.disableQuic = function() {
    var params_ = new NetworkService_DisableQuic_Params();
    var builder = new codec.MessageV0Builder(
        kNetworkService_DisableQuic_Name,
        codec.align(NetworkService_DisableQuic_Params.encodedSize));
    builder.encodeStruct(NetworkService_DisableQuic_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.setUpHttpAuth = function() {
    return NetworkServiceProxy.prototype.setUpHttpAuth
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.setUpHttpAuth = function(httpAuthStaticParams) {
    var params_ = new NetworkService_SetUpHttpAuth_Params();
    params_.httpAuthStaticParams = httpAuthStaticParams;
    var builder = new codec.MessageV0Builder(
        kNetworkService_SetUpHttpAuth_Name,
        codec.align(NetworkService_SetUpHttpAuth_Params.encodedSize));
    builder.encodeStruct(NetworkService_SetUpHttpAuth_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.configureHttpAuthPrefs = function() {
    return NetworkServiceProxy.prototype.configureHttpAuthPrefs
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.configureHttpAuthPrefs = function(httpAuthDynamicParams) {
    var params_ = new NetworkService_ConfigureHttpAuthPrefs_Params();
    params_.httpAuthDynamicParams = httpAuthDynamicParams;
    var builder = new codec.MessageV0Builder(
        kNetworkService_ConfigureHttpAuthPrefs_Name,
        codec.align(NetworkService_ConfigureHttpAuthPrefs_Params.encodedSize));
    builder.encodeStruct(NetworkService_ConfigureHttpAuthPrefs_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.setRawHeadersAccess = function() {
    return NetworkServiceProxy.prototype.setRawHeadersAccess
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.setRawHeadersAccess = function(processId, origins) {
    var params_ = new NetworkService_SetRawHeadersAccess_Params();
    params_.processId = processId;
    params_.origins = origins;
    var builder = new codec.MessageV0Builder(
        kNetworkService_SetRawHeadersAccess_Name,
        codec.align(NetworkService_SetRawHeadersAccess_Params.encodedSize));
    builder.encodeStruct(NetworkService_SetRawHeadersAccess_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.setMaxConnectionsPerProxyChain = function() {
    return NetworkServiceProxy.prototype.setMaxConnectionsPerProxyChain
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.setMaxConnectionsPerProxyChain = function(maxConnections) {
    var params_ = new NetworkService_SetMaxConnectionsPerProxyChain_Params();
    params_.maxConnections = maxConnections;
    var builder = new codec.MessageV0Builder(
        kNetworkService_SetMaxConnectionsPerProxyChain_Name,
        codec.align(NetworkService_SetMaxConnectionsPerProxyChain_Params.encodedSize));
    builder.encodeStruct(NetworkService_SetMaxConnectionsPerProxyChain_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.getNetworkChangeManager = function() {
    return NetworkServiceProxy.prototype.getNetworkChangeManager
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.getNetworkChangeManager = function(networkChangeManager) {
    var params_ = new NetworkService_GetNetworkChangeManager_Params();
    params_.networkChangeManager = networkChangeManager;
    var builder = new codec.MessageV0Builder(
        kNetworkService_GetNetworkChangeManager_Name,
        codec.align(NetworkService_GetNetworkChangeManager_Params.encodedSize));
    builder.encodeStruct(NetworkService_GetNetworkChangeManager_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.getNetworkQualityEstimatorManager = function() {
    return NetworkServiceProxy.prototype.getNetworkQualityEstimatorManager
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.getNetworkQualityEstimatorManager = function(receiver) {
    var params_ = new NetworkService_GetNetworkQualityEstimatorManager_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kNetworkService_GetNetworkQualityEstimatorManager_Name,
        codec.align(NetworkService_GetNetworkQualityEstimatorManager_Params.encodedSize));
    builder.encodeStruct(NetworkService_GetNetworkQualityEstimatorManager_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.getDnsConfigChangeManager = function() {
    return NetworkServiceProxy.prototype.getDnsConfigChangeManager
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.getDnsConfigChangeManager = function(receiver) {
    var params_ = new NetworkService_GetDnsConfigChangeManager_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kNetworkService_GetDnsConfigChangeManager_Name,
        codec.align(NetworkService_GetDnsConfigChangeManager_Params.encodedSize));
    builder.encodeStruct(NetworkService_GetDnsConfigChangeManager_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.getNetworkList = function() {
    return NetworkServiceProxy.prototype.getNetworkList
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.getNetworkList = function(policy) {
    var params_ = new NetworkService_GetNetworkList_Params();
    params_.policy = policy;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkService_GetNetworkList_Name,
          codec.align(NetworkService_GetNetworkList_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkService_GetNetworkList_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkService_GetNetworkList_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServicePtr.prototype.onTrustStoreChanged = function() {
    return NetworkServiceProxy.prototype.onTrustStoreChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.onTrustStoreChanged = function() {
    var params_ = new NetworkService_OnTrustStoreChanged_Params();
    var builder = new codec.MessageV0Builder(
        kNetworkService_OnTrustStoreChanged_Name,
        codec.align(NetworkService_OnTrustStoreChanged_Params.encodedSize));
    builder.encodeStruct(NetworkService_OnTrustStoreChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.onClientCertStoreChanged = function() {
    return NetworkServiceProxy.prototype.onClientCertStoreChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.onClientCertStoreChanged = function() {
    var params_ = new NetworkService_OnClientCertStoreChanged_Params();
    var builder = new codec.MessageV0Builder(
        kNetworkService_OnClientCertStoreChanged_Name,
        codec.align(NetworkService_OnClientCertStoreChanged_Params.encodedSize));
    builder.encodeStruct(NetworkService_OnClientCertStoreChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.setEncryptionKey = function() {
    return NetworkServiceProxy.prototype.setEncryptionKey
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.setEncryptionKey = function(encryptionKey) {
    var params_ = new NetworkService_SetEncryptionKey_Params();
    params_.encryptionKey = encryptionKey;
    var builder = new codec.MessageV0Builder(
        kNetworkService_SetEncryptionKey_Name,
        codec.align(NetworkService_SetEncryptionKey_Params.encodedSize));
    builder.encodeStruct(NetworkService_SetEncryptionKey_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.onMemoryPressure = function() {
    return NetworkServiceProxy.prototype.onMemoryPressure
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.onMemoryPressure = function(memoryPressureLevel) {
    var params_ = new NetworkService_OnMemoryPressure_Params();
    params_.memoryPressureLevel = memoryPressureLevel;
    var builder = new codec.MessageV0Builder(
        kNetworkService_OnMemoryPressure_Name,
        codec.align(NetworkService_OnMemoryPressure_Params.encodedSize));
    builder.encodeStruct(NetworkService_OnMemoryPressure_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.onPeerToPeerConnectionsCountChange = function() {
    return NetworkServiceProxy.prototype.onPeerToPeerConnectionsCountChange
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.onPeerToPeerConnectionsCountChange = function(count) {
    var params_ = new NetworkService_OnPeerToPeerConnectionsCountChange_Params();
    params_.count = count;
    var builder = new codec.MessageV0Builder(
        kNetworkService_OnPeerToPeerConnectionsCountChange_Name,
        codec.align(NetworkService_OnPeerToPeerConnectionsCountChange_Params.encodedSize));
    builder.encodeStruct(NetworkService_OnPeerToPeerConnectionsCountChange_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.setTrustTokenKeyCommitments = function() {
    return NetworkServiceProxy.prototype.setTrustTokenKeyCommitments
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.setTrustTokenKeyCommitments = function(rawCommitments) {
    var params_ = new NetworkService_SetTrustTokenKeyCommitments_Params();
    params_.rawCommitments = rawCommitments;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkService_SetTrustTokenKeyCommitments_Name,
          codec.align(NetworkService_SetTrustTokenKeyCommitments_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkService_SetTrustTokenKeyCommitments_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkService_SetTrustTokenKeyCommitments_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServicePtr.prototype.clearSCTAuditingCache = function() {
    return NetworkServiceProxy.prototype.clearSCTAuditingCache
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.clearSCTAuditingCache = function() {
    var params_ = new NetworkService_ClearSCTAuditingCache_Params();
    var builder = new codec.MessageV0Builder(
        kNetworkService_ClearSCTAuditingCache_Name,
        codec.align(NetworkService_ClearSCTAuditingCache_Params.encodedSize));
    builder.encodeStruct(NetworkService_ClearSCTAuditingCache_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.configureSCTAuditing = function() {
    return NetworkServiceProxy.prototype.configureSCTAuditing
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.configureSCTAuditing = function(configuration) {
    var params_ = new NetworkService_ConfigureSCTAuditing_Params();
    params_.configuration = configuration;
    var builder = new codec.MessageV0Builder(
        kNetworkService_ConfigureSCTAuditing_Name,
        codec.align(NetworkService_ConfigureSCTAuditing_Params.encodedSize));
    builder.encodeStruct(NetworkService_ConfigureSCTAuditing_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.updateCtLogList = function() {
    return NetworkServiceProxy.prototype.updateCtLogList
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.updateCtLogList = function(logList) {
    var params_ = new NetworkService_UpdateCtLogList_Params();
    params_.logList = logList;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkService_UpdateCtLogList_Name,
          codec.align(NetworkService_UpdateCtLogList_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkService_UpdateCtLogList_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkService_UpdateCtLogList_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServicePtr.prototype.updateCtKnownPopularSCTs = function() {
    return NetworkServiceProxy.prototype.updateCtKnownPopularSCTs
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.updateCtKnownPopularSCTs = function(sctHashes) {
    var params_ = new NetworkService_UpdateCtKnownPopularSCTs_Params();
    params_.sctHashes = sctHashes;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkService_UpdateCtKnownPopularSCTs_Name,
          codec.align(NetworkService_UpdateCtKnownPopularSCTs_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkService_UpdateCtKnownPopularSCTs_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkService_UpdateCtKnownPopularSCTs_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServicePtr.prototype.setCtEnforcementEnabled = function() {
    return NetworkServiceProxy.prototype.setCtEnforcementEnabled
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.setCtEnforcementEnabled = function(enabled) {
    var params_ = new NetworkService_SetCtEnforcementEnabled_Params();
    params_.enabled = enabled;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkService_SetCtEnforcementEnabled_Name,
          codec.align(NetworkService_SetCtEnforcementEnabled_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkService_SetCtEnforcementEnabled_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkService_SetCtEnforcementEnabled_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServicePtr.prototype.updateKeyPinsList = function() {
    return NetworkServiceProxy.prototype.updateKeyPinsList
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.updateKeyPinsList = function(pinList, updateTime) {
    var params_ = new NetworkService_UpdateKeyPinsList_Params();
    params_.pinList = pinList;
    params_.updateTime = updateTime;
    var builder = new codec.MessageV0Builder(
        kNetworkService_UpdateKeyPinsList_Name,
        codec.align(NetworkService_UpdateKeyPinsList_Params.encodedSize));
    builder.encodeStruct(NetworkService_UpdateKeyPinsList_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.bindTestInterfaceForTesting = function() {
    return NetworkServiceProxy.prototype.bindTestInterfaceForTesting
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.bindTestInterfaceForTesting = function(receiver) {
    var params_ = new NetworkService_BindTestInterfaceForTesting_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kNetworkService_BindTestInterfaceForTesting_Name,
        codec.align(NetworkService_BindTestInterfaceForTesting_Params.encodedSize));
    builder.encodeStruct(NetworkService_BindTestInterfaceForTesting_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.setFirstPartySets = function() {
    return NetworkServiceProxy.prototype.setFirstPartySets
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.setFirstPartySets = function(sets) {
    var params_ = new NetworkService_SetFirstPartySets_Params();
    params_.sets = sets;
    var builder = new codec.MessageV0Builder(
        kNetworkService_SetFirstPartySets_Name,
        codec.align(NetworkService_SetFirstPartySets_Params.encodedSize));
    builder.encodeStruct(NetworkService_SetFirstPartySets_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.setExplicitlyAllowedPorts = function() {
    return NetworkServiceProxy.prototype.setExplicitlyAllowedPorts
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.setExplicitlyAllowedPorts = function(ports) {
    var params_ = new NetworkService_SetExplicitlyAllowedPorts_Params();
    params_.ports = ports;
    var builder = new codec.MessageV0Builder(
        kNetworkService_SetExplicitlyAllowedPorts_Name,
        codec.align(NetworkService_SetExplicitlyAllowedPorts_Params.encodedSize));
    builder.encodeStruct(NetworkService_SetExplicitlyAllowedPorts_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.parseHeaders = function() {
    return NetworkServiceProxy.prototype.parseHeaders
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.parseHeaders = function(url, headers) {
    var params_ = new NetworkService_ParseHeaders_Params();
    params_.url = url;
    params_.headers = headers;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkService_ParseHeaders_Name,
          codec.align(NetworkService_ParseHeaders_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkService_ParseHeaders_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkService_ParseHeaders_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServicePtr.prototype.enableDataUseUpdates = function() {
    return NetworkServiceProxy.prototype.enableDataUseUpdates
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.enableDataUseUpdates = function(enable) {
    var params_ = new NetworkService_EnableDataUseUpdates_Params();
    params_.enable = enable;
    var builder = new codec.MessageV0Builder(
        kNetworkService_EnableDataUseUpdates_Name,
        codec.align(NetworkService_EnableDataUseUpdates_Params.encodedSize));
    builder.encodeStruct(NetworkService_EnableDataUseUpdates_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.setIPv6ReachabilityOverride = function() {
    return NetworkServiceProxy.prototype.setIPv6ReachabilityOverride
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.setIPv6ReachabilityOverride = function(reachabilityOverride) {
    var params_ = new NetworkService_SetIPv6ReachabilityOverride_Params();
    params_.reachabilityOverride = reachabilityOverride;
    var builder = new codec.MessageV0Builder(
        kNetworkService_SetIPv6ReachabilityOverride_Name,
        codec.align(NetworkService_SetIPv6ReachabilityOverride_Params.encodedSize));
    builder.encodeStruct(NetworkService_SetIPv6ReachabilityOverride_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.setNetworkAnnotationMonitor = function() {
    return NetworkServiceProxy.prototype.setNetworkAnnotationMonitor
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.setNetworkAnnotationMonitor = function(remote) {
    var params_ = new NetworkService_SetNetworkAnnotationMonitor_Params();
    params_.remote = remote;
    var builder = new codec.MessageV0Builder(
        kNetworkService_SetNetworkAnnotationMonitor_Name,
        codec.align(NetworkService_SetNetworkAnnotationMonitor_Params.encodedSize));
    builder.encodeStruct(NetworkService_SetNetworkAnnotationMonitor_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.setTpcdMetadataGrants = function() {
    return NetworkServiceProxy.prototype.setTpcdMetadataGrants
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.setTpcdMetadataGrants = function(settings) {
    var params_ = new NetworkService_SetTpcdMetadataGrants_Params();
    params_.settings = settings;
    var builder = new codec.MessageV0Builder(
        kNetworkService_SetTpcdMetadataGrants_Name,
        codec.align(NetworkService_SetTpcdMetadataGrants_Params.encodedSize));
    builder.encodeStruct(NetworkService_SetTpcdMetadataGrants_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.interceptUrlLoaderForBodyDecoding = function() {
    return NetworkServiceProxy.prototype.interceptUrlLoaderForBodyDecoding
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.interceptUrlLoaderForBodyDecoding = function(contentEncodingTypes, sourceBody, destBody, sourceUrlLoader, sourceUrlLoaderClient, destUrlLoader, destUrlLoaderClient) {
    var params_ = new NetworkService_InterceptUrlLoaderForBodyDecoding_Params();
    params_.contentEncodingTypes = contentEncodingTypes;
    params_.sourceBody = sourceBody;
    params_.destBody = destBody;
    params_.sourceUrlLoader = sourceUrlLoader;
    params_.sourceUrlLoaderClient = sourceUrlLoaderClient;
    params_.destUrlLoader = destUrlLoader;
    params_.destUrlLoaderClient = destUrlLoaderClient;
    var builder = new codec.MessageV0Builder(
        kNetworkService_InterceptUrlLoaderForBodyDecoding_Name,
        codec.align(NetworkService_InterceptUrlLoaderForBodyDecoding_Params.encodedSize));
    builder.encodeStruct(NetworkService_InterceptUrlLoaderForBodyDecoding_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkServicePtr.prototype.decodeContentEncoding = function() {
    return NetworkServiceProxy.prototype.decodeContentEncoding
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.decodeContentEncoding = function(contentEncodingTypes, sourceBody, destBody) {
    var params_ = new NetworkService_DecodeContentEncoding_Params();
    params_.contentEncodingTypes = contentEncodingTypes;
    params_.sourceBody = sourceBody;
    params_.destBody = destBody;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkService_DecodeContentEncoding_Name,
          codec.align(NetworkService_DecodeContentEncoding_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkService_DecodeContentEncoding_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkService_DecodeContentEncoding_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkServicePtr.prototype.setTLS13EarlyDataEnabled = function() {
    return NetworkServiceProxy.prototype.setTLS13EarlyDataEnabled
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkServiceProxy.prototype.setTLS13EarlyDataEnabled = function(enabled) {
    var params_ = new NetworkService_SetTLS13EarlyDataEnabled_Params();
    params_.enabled = enabled;
    var builder = new codec.MessageV0Builder(
        kNetworkService_SetTLS13EarlyDataEnabled_Name,
        codec.align(NetworkService_SetTLS13EarlyDataEnabled_Params.encodedSize));
    builder.encodeStruct(NetworkService_SetTLS13EarlyDataEnabled_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function NetworkServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  NetworkServiceStub.prototype.setParams = function(params) {
    return this.delegate_ && this.delegate_.setParams && this.delegate_.setParams(params);
  }
  NetworkServiceStub.prototype.startNetLog = function(file, maxTotalSize, captureMode, constants, duration) {
    return this.delegate_ && this.delegate_.startNetLog && this.delegate_.startNetLog(file, maxTotalSize, captureMode, constants, duration);
  }
  NetworkServiceStub.prototype.attachNetLogProxy = function(proxySource, proxySink) {
    return this.delegate_ && this.delegate_.attachNetLogProxy && this.delegate_.attachNetLogProxy(proxySource, proxySink);
  }
  NetworkServiceStub.prototype.setSSLKeyLogFile = function(file) {
    return this.delegate_ && this.delegate_.setSSLKeyLogFile && this.delegate_.setSSLKeyLogFile(file);
  }
  NetworkServiceStub.prototype.createNetworkContext = function(context, params) {
    return this.delegate_ && this.delegate_.createNetworkContext && this.delegate_.createNetworkContext(context, params);
  }
  NetworkServiceStub.prototype.configureStubHostResolver = function(insecureDnsClientEnabled, happyEyeballsV3Enabled, secureDnsMode, dnsOverHttpsConfig, additionalDnsTypesEnabled, fallbackDohNameservers) {
    return this.delegate_ && this.delegate_.configureStubHostResolver && this.delegate_.configureStubHostResolver(insecureDnsClientEnabled, happyEyeballsV3Enabled, secureDnsMode, dnsOverHttpsConfig, additionalDnsTypesEnabled, fallbackDohNameservers);
  }
  NetworkServiceStub.prototype.disableQuic = function() {
    return this.delegate_ && this.delegate_.disableQuic && this.delegate_.disableQuic();
  }
  NetworkServiceStub.prototype.setUpHttpAuth = function(httpAuthStaticParams) {
    return this.delegate_ && this.delegate_.setUpHttpAuth && this.delegate_.setUpHttpAuth(httpAuthStaticParams);
  }
  NetworkServiceStub.prototype.configureHttpAuthPrefs = function(httpAuthDynamicParams) {
    return this.delegate_ && this.delegate_.configureHttpAuthPrefs && this.delegate_.configureHttpAuthPrefs(httpAuthDynamicParams);
  }
  NetworkServiceStub.prototype.setRawHeadersAccess = function(processId, origins) {
    return this.delegate_ && this.delegate_.setRawHeadersAccess && this.delegate_.setRawHeadersAccess(processId, origins);
  }
  NetworkServiceStub.prototype.setMaxConnectionsPerProxyChain = function(maxConnections) {
    return this.delegate_ && this.delegate_.setMaxConnectionsPerProxyChain && this.delegate_.setMaxConnectionsPerProxyChain(maxConnections);
  }
  NetworkServiceStub.prototype.getNetworkChangeManager = function(networkChangeManager) {
    return this.delegate_ && this.delegate_.getNetworkChangeManager && this.delegate_.getNetworkChangeManager(networkChangeManager);
  }
  NetworkServiceStub.prototype.getNetworkQualityEstimatorManager = function(receiver) {
    return this.delegate_ && this.delegate_.getNetworkQualityEstimatorManager && this.delegate_.getNetworkQualityEstimatorManager(receiver);
  }
  NetworkServiceStub.prototype.getDnsConfigChangeManager = function(receiver) {
    return this.delegate_ && this.delegate_.getDnsConfigChangeManager && this.delegate_.getDnsConfigChangeManager(receiver);
  }
  NetworkServiceStub.prototype.getNetworkList = function(policy) {
    return this.delegate_ && this.delegate_.getNetworkList && this.delegate_.getNetworkList(policy);
  }
  NetworkServiceStub.prototype.onTrustStoreChanged = function() {
    return this.delegate_ && this.delegate_.onTrustStoreChanged && this.delegate_.onTrustStoreChanged();
  }
  NetworkServiceStub.prototype.onClientCertStoreChanged = function() {
    return this.delegate_ && this.delegate_.onClientCertStoreChanged && this.delegate_.onClientCertStoreChanged();
  }
  NetworkServiceStub.prototype.setEncryptionKey = function(encryptionKey) {
    return this.delegate_ && this.delegate_.setEncryptionKey && this.delegate_.setEncryptionKey(encryptionKey);
  }
  NetworkServiceStub.prototype.onMemoryPressure = function(memoryPressureLevel) {
    return this.delegate_ && this.delegate_.onMemoryPressure && this.delegate_.onMemoryPressure(memoryPressureLevel);
  }
  NetworkServiceStub.prototype.onPeerToPeerConnectionsCountChange = function(count) {
    return this.delegate_ && this.delegate_.onPeerToPeerConnectionsCountChange && this.delegate_.onPeerToPeerConnectionsCountChange(count);
  }
  NetworkServiceStub.prototype.setTrustTokenKeyCommitments = function(rawCommitments) {
    return this.delegate_ && this.delegate_.setTrustTokenKeyCommitments && this.delegate_.setTrustTokenKeyCommitments(rawCommitments);
  }
  NetworkServiceStub.prototype.clearSCTAuditingCache = function() {
    return this.delegate_ && this.delegate_.clearSCTAuditingCache && this.delegate_.clearSCTAuditingCache();
  }
  NetworkServiceStub.prototype.configureSCTAuditing = function(configuration) {
    return this.delegate_ && this.delegate_.configureSCTAuditing && this.delegate_.configureSCTAuditing(configuration);
  }
  NetworkServiceStub.prototype.updateCtLogList = function(logList) {
    return this.delegate_ && this.delegate_.updateCtLogList && this.delegate_.updateCtLogList(logList);
  }
  NetworkServiceStub.prototype.updateCtKnownPopularSCTs = function(sctHashes) {
    return this.delegate_ && this.delegate_.updateCtKnownPopularSCTs && this.delegate_.updateCtKnownPopularSCTs(sctHashes);
  }
  NetworkServiceStub.prototype.setCtEnforcementEnabled = function(enabled) {
    return this.delegate_ && this.delegate_.setCtEnforcementEnabled && this.delegate_.setCtEnforcementEnabled(enabled);
  }
  NetworkServiceStub.prototype.updateKeyPinsList = function(pinList, updateTime) {
    return this.delegate_ && this.delegate_.updateKeyPinsList && this.delegate_.updateKeyPinsList(pinList, updateTime);
  }
  NetworkServiceStub.prototype.bindTestInterfaceForTesting = function(receiver) {
    return this.delegate_ && this.delegate_.bindTestInterfaceForTesting && this.delegate_.bindTestInterfaceForTesting(receiver);
  }
  NetworkServiceStub.prototype.setFirstPartySets = function(sets) {
    return this.delegate_ && this.delegate_.setFirstPartySets && this.delegate_.setFirstPartySets(sets);
  }
  NetworkServiceStub.prototype.setExplicitlyAllowedPorts = function(ports) {
    return this.delegate_ && this.delegate_.setExplicitlyAllowedPorts && this.delegate_.setExplicitlyAllowedPorts(ports);
  }
  NetworkServiceStub.prototype.parseHeaders = function(url, headers) {
    return this.delegate_ && this.delegate_.parseHeaders && this.delegate_.parseHeaders(url, headers);
  }
  NetworkServiceStub.prototype.enableDataUseUpdates = function(enable) {
    return this.delegate_ && this.delegate_.enableDataUseUpdates && this.delegate_.enableDataUseUpdates(enable);
  }
  NetworkServiceStub.prototype.setIPv6ReachabilityOverride = function(reachabilityOverride) {
    return this.delegate_ && this.delegate_.setIPv6ReachabilityOverride && this.delegate_.setIPv6ReachabilityOverride(reachabilityOverride);
  }
  NetworkServiceStub.prototype.setNetworkAnnotationMonitor = function(remote) {
    return this.delegate_ && this.delegate_.setNetworkAnnotationMonitor && this.delegate_.setNetworkAnnotationMonitor(remote);
  }
  NetworkServiceStub.prototype.setTpcdMetadataGrants = function(settings) {
    return this.delegate_ && this.delegate_.setTpcdMetadataGrants && this.delegate_.setTpcdMetadataGrants(settings);
  }
  NetworkServiceStub.prototype.interceptUrlLoaderForBodyDecoding = function(contentEncodingTypes, sourceBody, destBody, sourceUrlLoader, sourceUrlLoaderClient, destUrlLoader, destUrlLoaderClient) {
    return this.delegate_ && this.delegate_.interceptUrlLoaderForBodyDecoding && this.delegate_.interceptUrlLoaderForBodyDecoding(contentEncodingTypes, sourceBody, destBody, sourceUrlLoader, sourceUrlLoaderClient, destUrlLoader, destUrlLoaderClient);
  }
  NetworkServiceStub.prototype.decodeContentEncoding = function(contentEncodingTypes, sourceBody, destBody) {
    return this.delegate_ && this.delegate_.decodeContentEncoding && this.delegate_.decodeContentEncoding(contentEncodingTypes, sourceBody, destBody);
  }
  NetworkServiceStub.prototype.setTLS13EarlyDataEnabled = function(enabled) {
    return this.delegate_ && this.delegate_.setTLS13EarlyDataEnabled && this.delegate_.setTLS13EarlyDataEnabled(enabled);
  }

  NetworkServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kNetworkService_SetParams_Name:
      var params = reader.decodeStruct(NetworkService_SetParams_Params);
      this.setParams(params.params);
      return true;
    case kNetworkService_StartNetLog_Name:
      var params = reader.decodeStruct(NetworkService_StartNetLog_Params);
      this.startNetLog(params.file, params.maxTotalSize, params.captureMode, params.constants, params.duration);
      return true;
    case kNetworkService_AttachNetLogProxy_Name:
      var params = reader.decodeStruct(NetworkService_AttachNetLogProxy_Params);
      this.attachNetLogProxy(params.proxySource, params.proxySink);
      return true;
    case kNetworkService_SetSSLKeyLogFile_Name:
      var params = reader.decodeStruct(NetworkService_SetSSLKeyLogFile_Params);
      this.setSSLKeyLogFile(params.file);
      return true;
    case kNetworkService_CreateNetworkContext_Name:
      var params = reader.decodeStruct(NetworkService_CreateNetworkContext_Params);
      this.createNetworkContext(params.context, params.params);
      return true;
    case kNetworkService_ConfigureStubHostResolver_Name:
      var params = reader.decodeStruct(NetworkService_ConfigureStubHostResolver_Params);
      this.configureStubHostResolver(params.insecureDnsClientEnabled, params.happyEyeballsV3Enabled, params.secureDnsMode, params.dnsOverHttpsConfig, params.additionalDnsTypesEnabled, params.fallbackDohNameservers);
      return true;
    case kNetworkService_DisableQuic_Name:
      var params = reader.decodeStruct(NetworkService_DisableQuic_Params);
      this.disableQuic();
      return true;
    case kNetworkService_SetUpHttpAuth_Name:
      var params = reader.decodeStruct(NetworkService_SetUpHttpAuth_Params);
      this.setUpHttpAuth(params.httpAuthStaticParams);
      return true;
    case kNetworkService_ConfigureHttpAuthPrefs_Name:
      var params = reader.decodeStruct(NetworkService_ConfigureHttpAuthPrefs_Params);
      this.configureHttpAuthPrefs(params.httpAuthDynamicParams);
      return true;
    case kNetworkService_SetRawHeadersAccess_Name:
      var params = reader.decodeStruct(NetworkService_SetRawHeadersAccess_Params);
      this.setRawHeadersAccess(params.processId, params.origins);
      return true;
    case kNetworkService_SetMaxConnectionsPerProxyChain_Name:
      var params = reader.decodeStruct(NetworkService_SetMaxConnectionsPerProxyChain_Params);
      this.setMaxConnectionsPerProxyChain(params.maxConnections);
      return true;
    case kNetworkService_GetNetworkChangeManager_Name:
      var params = reader.decodeStruct(NetworkService_GetNetworkChangeManager_Params);
      this.getNetworkChangeManager(params.networkChangeManager);
      return true;
    case kNetworkService_GetNetworkQualityEstimatorManager_Name:
      var params = reader.decodeStruct(NetworkService_GetNetworkQualityEstimatorManager_Params);
      this.getNetworkQualityEstimatorManager(params.receiver);
      return true;
    case kNetworkService_GetDnsConfigChangeManager_Name:
      var params = reader.decodeStruct(NetworkService_GetDnsConfigChangeManager_Params);
      this.getDnsConfigChangeManager(params.receiver);
      return true;
    case kNetworkService_OnTrustStoreChanged_Name:
      var params = reader.decodeStruct(NetworkService_OnTrustStoreChanged_Params);
      this.onTrustStoreChanged();
      return true;
    case kNetworkService_OnClientCertStoreChanged_Name:
      var params = reader.decodeStruct(NetworkService_OnClientCertStoreChanged_Params);
      this.onClientCertStoreChanged();
      return true;
    case kNetworkService_SetEncryptionKey_Name:
      var params = reader.decodeStruct(NetworkService_SetEncryptionKey_Params);
      this.setEncryptionKey(params.encryptionKey);
      return true;
    case kNetworkService_OnMemoryPressure_Name:
      var params = reader.decodeStruct(NetworkService_OnMemoryPressure_Params);
      this.onMemoryPressure(params.memoryPressureLevel);
      return true;
    case kNetworkService_OnPeerToPeerConnectionsCountChange_Name:
      var params = reader.decodeStruct(NetworkService_OnPeerToPeerConnectionsCountChange_Params);
      this.onPeerToPeerConnectionsCountChange(params.count);
      return true;
    case kNetworkService_ClearSCTAuditingCache_Name:
      var params = reader.decodeStruct(NetworkService_ClearSCTAuditingCache_Params);
      this.clearSCTAuditingCache();
      return true;
    case kNetworkService_ConfigureSCTAuditing_Name:
      var params = reader.decodeStruct(NetworkService_ConfigureSCTAuditing_Params);
      this.configureSCTAuditing(params.configuration);
      return true;
    case kNetworkService_UpdateKeyPinsList_Name:
      var params = reader.decodeStruct(NetworkService_UpdateKeyPinsList_Params);
      this.updateKeyPinsList(params.pinList, params.updateTime);
      return true;
    case kNetworkService_BindTestInterfaceForTesting_Name:
      var params = reader.decodeStruct(NetworkService_BindTestInterfaceForTesting_Params);
      this.bindTestInterfaceForTesting(params.receiver);
      return true;
    case kNetworkService_SetFirstPartySets_Name:
      var params = reader.decodeStruct(NetworkService_SetFirstPartySets_Params);
      this.setFirstPartySets(params.sets);
      return true;
    case kNetworkService_SetExplicitlyAllowedPorts_Name:
      var params = reader.decodeStruct(NetworkService_SetExplicitlyAllowedPorts_Params);
      this.setExplicitlyAllowedPorts(params.ports);
      return true;
    case kNetworkService_EnableDataUseUpdates_Name:
      var params = reader.decodeStruct(NetworkService_EnableDataUseUpdates_Params);
      this.enableDataUseUpdates(params.enable);
      return true;
    case kNetworkService_SetIPv6ReachabilityOverride_Name:
      var params = reader.decodeStruct(NetworkService_SetIPv6ReachabilityOverride_Params);
      this.setIPv6ReachabilityOverride(params.reachabilityOverride);
      return true;
    case kNetworkService_SetNetworkAnnotationMonitor_Name:
      var params = reader.decodeStruct(NetworkService_SetNetworkAnnotationMonitor_Params);
      this.setNetworkAnnotationMonitor(params.remote);
      return true;
    case kNetworkService_SetTpcdMetadataGrants_Name:
      var params = reader.decodeStruct(NetworkService_SetTpcdMetadataGrants_Params);
      this.setTpcdMetadataGrants(params.settings);
      return true;
    case kNetworkService_InterceptUrlLoaderForBodyDecoding_Name:
      var params = reader.decodeStruct(NetworkService_InterceptUrlLoaderForBodyDecoding_Params);
      this.interceptUrlLoaderForBodyDecoding(params.contentEncodingTypes, params.sourceBody, params.destBody, params.sourceUrlLoader, params.sourceUrlLoaderClient, params.destUrlLoader, params.destUrlLoaderClient);
      return true;
    case kNetworkService_SetTLS13EarlyDataEnabled_Name:
      var params = reader.decodeStruct(NetworkService_SetTLS13EarlyDataEnabled_Params);
      this.setTLS13EarlyDataEnabled(params.enabled);
      return true;
    default:
      return false;
    }
  };

  NetworkServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kNetworkService_GetNetworkList_Name:
      var params = reader.decodeStruct(NetworkService_GetNetworkList_Params);
      this.getNetworkList(params.policy).then(function(response) {
        var responseParams =
            new NetworkService_GetNetworkList_ResponseParams();
        responseParams.networks = response.networks;
        var builder = new codec.MessageV1Builder(
            kNetworkService_GetNetworkList_Name,
            codec.align(NetworkService_GetNetworkList_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkService_GetNetworkList_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkService_SetTrustTokenKeyCommitments_Name:
      var params = reader.decodeStruct(NetworkService_SetTrustTokenKeyCommitments_Params);
      this.setTrustTokenKeyCommitments(params.rawCommitments).then(function(response) {
        var responseParams =
            new NetworkService_SetTrustTokenKeyCommitments_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkService_SetTrustTokenKeyCommitments_Name,
            codec.align(NetworkService_SetTrustTokenKeyCommitments_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkService_SetTrustTokenKeyCommitments_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkService_UpdateCtLogList_Name:
      var params = reader.decodeStruct(NetworkService_UpdateCtLogList_Params);
      this.updateCtLogList(params.logList).then(function(response) {
        var responseParams =
            new NetworkService_UpdateCtLogList_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkService_UpdateCtLogList_Name,
            codec.align(NetworkService_UpdateCtLogList_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkService_UpdateCtLogList_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkService_UpdateCtKnownPopularSCTs_Name:
      var params = reader.decodeStruct(NetworkService_UpdateCtKnownPopularSCTs_Params);
      this.updateCtKnownPopularSCTs(params.sctHashes).then(function(response) {
        var responseParams =
            new NetworkService_UpdateCtKnownPopularSCTs_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkService_UpdateCtKnownPopularSCTs_Name,
            codec.align(NetworkService_UpdateCtKnownPopularSCTs_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkService_UpdateCtKnownPopularSCTs_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkService_SetCtEnforcementEnabled_Name:
      var params = reader.decodeStruct(NetworkService_SetCtEnforcementEnabled_Params);
      this.setCtEnforcementEnabled(params.enabled).then(function(response) {
        var responseParams =
            new NetworkService_SetCtEnforcementEnabled_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkService_SetCtEnforcementEnabled_Name,
            codec.align(NetworkService_SetCtEnforcementEnabled_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkService_SetCtEnforcementEnabled_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkService_ParseHeaders_Name:
      var params = reader.decodeStruct(NetworkService_ParseHeaders_Params);
      this.parseHeaders(params.url, params.headers).then(function(response) {
        var responseParams =
            new NetworkService_ParseHeaders_ResponseParams();
        responseParams.parsedHeaders = response.parsedHeaders;
        var builder = new codec.MessageV1Builder(
            kNetworkService_ParseHeaders_Name,
            codec.align(NetworkService_ParseHeaders_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkService_ParseHeaders_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkService_DecodeContentEncoding_Name:
      var params = reader.decodeStruct(NetworkService_DecodeContentEncoding_Params);
      this.decodeContentEncoding(params.contentEncodingTypes, params.sourceBody, params.destBody).then(function(response) {
        var responseParams =
            new NetworkService_DecodeContentEncoding_ResponseParams();
        responseParams.errorCode = response.errorCode;
        var builder = new codec.MessageV1Builder(
            kNetworkService_DecodeContentEncoding_Name,
            codec.align(NetworkService_DecodeContentEncoding_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkService_DecodeContentEncoding_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateNetworkServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kNetworkService_SetParams_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_SetParams_Params;
      break;
      case kNetworkService_StartNetLog_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_StartNetLog_Params;
      break;
      case kNetworkService_AttachNetLogProxy_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_AttachNetLogProxy_Params;
      break;
      case kNetworkService_SetSSLKeyLogFile_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_SetSSLKeyLogFile_Params;
      break;
      case kNetworkService_CreateNetworkContext_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_CreateNetworkContext_Params;
      break;
      case kNetworkService_ConfigureStubHostResolver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_ConfigureStubHostResolver_Params;
      break;
      case kNetworkService_DisableQuic_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_DisableQuic_Params;
      break;
      case kNetworkService_SetUpHttpAuth_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_SetUpHttpAuth_Params;
      break;
      case kNetworkService_ConfigureHttpAuthPrefs_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_ConfigureHttpAuthPrefs_Params;
      break;
      case kNetworkService_SetRawHeadersAccess_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_SetRawHeadersAccess_Params;
      break;
      case kNetworkService_SetMaxConnectionsPerProxyChain_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_SetMaxConnectionsPerProxyChain_Params;
      break;
      case kNetworkService_GetNetworkChangeManager_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_GetNetworkChangeManager_Params;
      break;
      case kNetworkService_GetNetworkQualityEstimatorManager_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_GetNetworkQualityEstimatorManager_Params;
      break;
      case kNetworkService_GetDnsConfigChangeManager_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_GetDnsConfigChangeManager_Params;
      break;
      case kNetworkService_GetNetworkList_Name:
        if (message.expectsResponse())
          paramsClass = NetworkService_GetNetworkList_Params;
      break;
      case kNetworkService_OnTrustStoreChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_OnTrustStoreChanged_Params;
      break;
      case kNetworkService_OnClientCertStoreChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_OnClientCertStoreChanged_Params;
      break;
      case kNetworkService_SetEncryptionKey_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_SetEncryptionKey_Params;
      break;
      case kNetworkService_OnMemoryPressure_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_OnMemoryPressure_Params;
      break;
      case kNetworkService_OnPeerToPeerConnectionsCountChange_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_OnPeerToPeerConnectionsCountChange_Params;
      break;
      case kNetworkService_SetTrustTokenKeyCommitments_Name:
        if (message.expectsResponse())
          paramsClass = NetworkService_SetTrustTokenKeyCommitments_Params;
      break;
      case kNetworkService_ClearSCTAuditingCache_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_ClearSCTAuditingCache_Params;
      break;
      case kNetworkService_ConfigureSCTAuditing_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_ConfigureSCTAuditing_Params;
      break;
      case kNetworkService_UpdateCtLogList_Name:
        if (message.expectsResponse())
          paramsClass = NetworkService_UpdateCtLogList_Params;
      break;
      case kNetworkService_UpdateCtKnownPopularSCTs_Name:
        if (message.expectsResponse())
          paramsClass = NetworkService_UpdateCtKnownPopularSCTs_Params;
      break;
      case kNetworkService_SetCtEnforcementEnabled_Name:
        if (message.expectsResponse())
          paramsClass = NetworkService_SetCtEnforcementEnabled_Params;
      break;
      case kNetworkService_UpdateKeyPinsList_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_UpdateKeyPinsList_Params;
      break;
      case kNetworkService_BindTestInterfaceForTesting_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_BindTestInterfaceForTesting_Params;
      break;
      case kNetworkService_SetFirstPartySets_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_SetFirstPartySets_Params;
      break;
      case kNetworkService_SetExplicitlyAllowedPorts_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_SetExplicitlyAllowedPorts_Params;
      break;
      case kNetworkService_ParseHeaders_Name:
        if (message.expectsResponse())
          paramsClass = NetworkService_ParseHeaders_Params;
      break;
      case kNetworkService_EnableDataUseUpdates_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_EnableDataUseUpdates_Params;
      break;
      case kNetworkService_SetIPv6ReachabilityOverride_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_SetIPv6ReachabilityOverride_Params;
      break;
      case kNetworkService_SetNetworkAnnotationMonitor_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_SetNetworkAnnotationMonitor_Params;
      break;
      case kNetworkService_SetTpcdMetadataGrants_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_SetTpcdMetadataGrants_Params;
      break;
      case kNetworkService_InterceptUrlLoaderForBodyDecoding_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_InterceptUrlLoaderForBodyDecoding_Params;
      break;
      case kNetworkService_DecodeContentEncoding_Name:
        if (message.expectsResponse())
          paramsClass = NetworkService_DecodeContentEncoding_Params;
      break;
      case kNetworkService_SetTLS13EarlyDataEnabled_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkService_SetTLS13EarlyDataEnabled_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateNetworkServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kNetworkService_GetNetworkList_Name:
        if (message.isResponse())
          paramsClass = NetworkService_GetNetworkList_ResponseParams;
        break;
      case kNetworkService_SetTrustTokenKeyCommitments_Name:
        if (message.isResponse())
          paramsClass = NetworkService_SetTrustTokenKeyCommitments_ResponseParams;
        break;
      case kNetworkService_UpdateCtLogList_Name:
        if (message.isResponse())
          paramsClass = NetworkService_UpdateCtLogList_ResponseParams;
        break;
      case kNetworkService_UpdateCtKnownPopularSCTs_Name:
        if (message.isResponse())
          paramsClass = NetworkService_UpdateCtKnownPopularSCTs_ResponseParams;
        break;
      case kNetworkService_SetCtEnforcementEnabled_Name:
        if (message.isResponse())
          paramsClass = NetworkService_SetCtEnforcementEnabled_ResponseParams;
        break;
      case kNetworkService_ParseHeaders_Name:
        if (message.isResponse())
          paramsClass = NetworkService_ParseHeaders_ResponseParams;
        break;
      case kNetworkService_DecodeContentEncoding_Name:
        if (message.isResponse())
          paramsClass = NetworkService_DecodeContentEncoding_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var NetworkService = {
    name: 'network.mojom.NetworkService',
    kVersion: 0,
    ptrClass: NetworkServicePtr,
    proxyClass: NetworkServiceProxy,
    stubClass: NetworkServiceStub,
    validateRequest: validateNetworkServiceRequest,
    validateResponse: validateNetworkServiceResponse,
  };
  NetworkServiceStub.prototype.validator = validateNetworkServiceRequest;
  NetworkServiceProxy.prototype.validator = validateNetworkServiceResponse;
  exports.HttpAuthStaticParams = HttpAuthStaticParams;
  exports.HttpAuthDynamicParams = HttpAuthDynamicParams;
  exports.EnvironmentVariable = EnvironmentVariable;
  exports.NetworkServiceParams = NetworkServiceParams;
  exports.SCTAuditingConfiguration = SCTAuditingConfiguration;
  exports.NetworkService = NetworkService;
  exports.NetworkServicePtr = NetworkServicePtr;
  exports.NetworkServiceAssociatedPtr = NetworkServiceAssociatedPtr;
})();