// services/network/public/mojom/network_service.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/network_service.mojom-shared-internal.h"
#include "components/content_settings/core/common/content_settings.mojom-shared.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/memory_pressure_level.mojom-shared.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "services/network/public/mojom/client_security_state.mojom-shared.h"
#include "services/network/public/mojom/first_party_sets.mojom-shared.h"
#include "services/network/public/mojom/host_resolver.mojom-shared.h"
#include "services/network/public/mojom/http_raw_headers.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/key_pinning.mojom-shared.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared.h"
#include "services/network/public/mojom/net_log.mojom-shared.h"
#include "services/network/public/mojom/network_annotation_monitor.mojom-shared.h"
#include "services/network/public/mojom/network_change_manager.mojom-shared.h"
#include "services/network/public/mojom/network_context.mojom-shared.h"
#include "services/network/public/mojom/network_interface.mojom-shared.h"
#include "services/network/public/mojom/network_interface_change_listener.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/network_quality_estimator_manager.mojom-shared.h"
#include "services/network/public/mojom/network_service_test.mojom-shared.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared.h"
#include "services/network/public/mojom/proxy_config.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "services/network/public/mojom/source_type.mojom-shared.h"
#include "services/network/public/mojom/system_dns_resolution.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "services/network/public/mojom/url_loader_network_service_observer.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/ct_log_info.mojom-shared.h"

#include "services/network/public/mojom/network_service.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::HttpAuthStaticParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::HttpAuthStaticParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::HttpAuthStaticParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::gssapi_library_name(input)) in_gssapi_library_name = Traits::gssapi_library_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gssapi_library_name)::BaseType> gssapi_library_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_gssapi_library_name,
        gssapi_library_name_fragment);

      fragment->gssapi_library_name.Set(
          gssapi_library_name_fragment.is_null() ? nullptr : gssapi_library_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gssapi_library_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gssapi_library_name in HttpAuthStaticParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::HttpAuthDynamicParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::HttpAuthDynamicParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::HttpAuthDynamicParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::allowed_schemes(input)) in_allowed_schemes = Traits::allowed_schemes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->allowed_schemes)::BaseType>
          allowed_schemes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& allowed_schemes_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_allowed_schemes,
        allowed_schemes_fragment,
        &allowed_schemes_validate_params);

      fragment->allowed_schemes.Set(
          allowed_schemes_fragment.is_null() ? nullptr : allowed_schemes_fragment.data());

      decltype(Traits::patterns_allowed_to_use_all_schemes(input)) in_patterns_allowed_to_use_all_schemes = Traits::patterns_allowed_to_use_all_schemes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->patterns_allowed_to_use_all_schemes)::BaseType>
          patterns_allowed_to_use_all_schemes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& patterns_allowed_to_use_all_schemes_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_patterns_allowed_to_use_all_schemes,
        patterns_allowed_to_use_all_schemes_fragment,
        &patterns_allowed_to_use_all_schemes_validate_params);

      fragment->patterns_allowed_to_use_all_schemes.Set(
          patterns_allowed_to_use_all_schemes_fragment.is_null() ? nullptr : patterns_allowed_to_use_all_schemes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->patterns_allowed_to_use_all_schemes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null patterns_allowed_to_use_all_schemes in HttpAuthDynamicParams struct");

      decltype(Traits::server_allowlist(input)) in_server_allowlist = Traits::server_allowlist(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->server_allowlist)::BaseType> server_allowlist_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_server_allowlist,
        server_allowlist_fragment);

      fragment->server_allowlist.Set(
          server_allowlist_fragment.is_null() ? nullptr : server_allowlist_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->server_allowlist.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null server_allowlist in HttpAuthDynamicParams struct");

      decltype(Traits::delegate_allowlist(input)) in_delegate_allowlist = Traits::delegate_allowlist(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->delegate_allowlist)::BaseType> delegate_allowlist_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_delegate_allowlist,
        delegate_allowlist_fragment);

      fragment->delegate_allowlist.Set(
          delegate_allowlist_fragment.is_null() ? nullptr : delegate_allowlist_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->delegate_allowlist.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null delegate_allowlist in HttpAuthDynamicParams struct");

      fragment->delegate_by_kdc_policy = Traits::delegate_by_kdc_policy(input);

      fragment->negotiate_disable_cname_lookup = Traits::negotiate_disable_cname_lookup(input);

      fragment->enable_negotiate_port = Traits::enable_negotiate_port(input);

      fragment->ntlm_v2_enabled = Traits::ntlm_v2_enabled(input);

      decltype(Traits::android_negotiate_account_type(input)) in_android_negotiate_account_type = Traits::android_negotiate_account_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->android_negotiate_account_type)::BaseType> android_negotiate_account_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_android_negotiate_account_type,
        android_negotiate_account_type_fragment);

      fragment->android_negotiate_account_type.Set(
          android_negotiate_account_type_fragment.is_null() ? nullptr : android_negotiate_account_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->android_negotiate_account_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null android_negotiate_account_type in HttpAuthDynamicParams struct");

      fragment->allow_gssapi_library_load = Traits::allow_gssapi_library_load(input);

      fragment->basic_over_http_enabled = Traits::basic_over_http_enabled(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::EnvironmentVariableDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::EnvironmentVariableDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::EnvironmentVariable_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in EnvironmentVariable struct");

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->value)::BaseType> value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_value,
        value_fragment);

      fragment->value.Set(
          value_fragment.is_null() ? nullptr : value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in EnvironmentVariable struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::NetworkServiceParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::NetworkServiceParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::NetworkServiceParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::ConnectionType>(
        Traits::initial_connection_type(input),
        &fragment->initial_connection_type);

      
      mojo::internal::Serialize<::network::mojom::ConnectionSubtype>(
        Traits::initial_connection_subtype(input),
        &fragment->initial_connection_subtype);

      decltype(Traits::environment(input)) in_environment = Traits::environment(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->environment)::BaseType>
          environment_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& environment_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::EnvironmentVariableDataView>, send_validation>(
        in_environment,
        environment_fragment,
        &environment_validate_params);

      fragment->environment.Set(
          environment_fragment.is_null() ? nullptr : environment_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->environment.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null environment in NetworkServiceParams struct");

      decltype(Traits::default_observer(input)) in_default_observer = Traits::default_observer(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderNetworkServiceObserverInterfaceBase>>(
        in_default_observer,
        &fragment->default_observer,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->default_observer)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid default_observer in NetworkServiceParams struct");

      fragment->first_party_sets_enabled = Traits::first_party_sets_enabled(input);

      decltype(Traits::system_dns_resolver(input)) in_system_dns_resolver = Traits::system_dns_resolver(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SystemDnsResolverInterfaceBase>>(
        in_system_dns_resolver,
        &fragment->system_dns_resolver,
        &fragment.message());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::SCTAuditingConfigurationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SCTAuditingConfigurationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SCTAuditingConfiguration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->sampling_rate = Traits::sampling_rate(input);

      decltype(Traits::log_expected_ingestion_delay(input)) in_log_expected_ingestion_delay = Traits::log_expected_ingestion_delay(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->log_expected_ingestion_delay)::BaseType> log_expected_ingestion_delay_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_log_expected_ingestion_delay,
        log_expected_ingestion_delay_fragment);

      fragment->log_expected_ingestion_delay.Set(
          log_expected_ingestion_delay_fragment.is_null() ? nullptr : log_expected_ingestion_delay_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->log_expected_ingestion_delay.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null log_expected_ingestion_delay in SCTAuditingConfiguration struct");

      decltype(Traits::log_max_ingestion_random_delay(input)) in_log_max_ingestion_random_delay = Traits::log_max_ingestion_random_delay(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->log_max_ingestion_random_delay)::BaseType> log_max_ingestion_random_delay_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_log_max_ingestion_random_delay,
        log_max_ingestion_random_delay_fragment);

      fragment->log_max_ingestion_random_delay.Set(
          log_max_ingestion_random_delay_fragment.is_null() ? nullptr : log_max_ingestion_random_delay_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->log_max_ingestion_random_delay.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null log_max_ingestion_random_delay in SCTAuditingConfiguration struct");

      decltype(Traits::report_uri(input)) in_report_uri = Traits::report_uri(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->report_uri)::BaseType> report_uri_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_report_uri,
        report_uri_fragment);

      fragment->report_uri.Set(
          report_uri_fragment.is_null() ? nullptr : report_uri_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->report_uri.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null report_uri in SCTAuditingConfiguration struct");

      decltype(Traits::hashdance_lookup_uri(input)) in_hashdance_lookup_uri = Traits::hashdance_lookup_uri(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hashdance_lookup_uri)::BaseType> hashdance_lookup_uri_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_hashdance_lookup_uri,
        hashdance_lookup_uri_fragment);

      fragment->hashdance_lookup_uri.Set(
          hashdance_lookup_uri_fragment.is_null() ? nullptr : hashdance_lookup_uri_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->hashdance_lookup_uri.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hashdance_lookup_uri in SCTAuditingConfiguration struct");

      decltype(Traits::traffic_annotation(input)) in_traffic_annotation = Traits::traffic_annotation(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->traffic_annotation)::BaseType> traffic_annotation_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView, send_validation>(
        in_traffic_annotation,
        traffic_annotation_fragment);

      fragment->traffic_annotation.Set(
          traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->traffic_annotation.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null traffic_annotation in SCTAuditingConfiguration struct");

      decltype(Traits::hashdance_traffic_annotation(input)) in_hashdance_traffic_annotation = Traits::hashdance_traffic_annotation(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hashdance_traffic_annotation)::BaseType> hashdance_traffic_annotation_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView, send_validation>(
        in_hashdance_traffic_annotation,
        hashdance_traffic_annotation_fragment);

      fragment->hashdance_traffic_annotation.Set(
          hashdance_traffic_annotation_fragment.is_null() ? nullptr : hashdance_traffic_annotation_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->hashdance_traffic_annotation.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hashdance_traffic_annotation in SCTAuditingConfiguration struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_SEND_VALIDATION_H_