// services/network/public/mojom/network_service.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('network.mojom.ConnectionSubtype');
goog.require('network.mojom.ConnectionType');
goog.require('mojoBase.mojom.MemoryPressureLevel');
goog.require('network.mojom.NetLogCaptureMode');
goog.require('network.mojom.SecureDnsMode');
goog.require('network.mojom.SourceType');
goog.require('network.mojom.DnsConfigChangeManager');
goog.require('network.mojom.NetLogProxySink');
goog.require('network.mojom.NetLogProxySource');
goog.require('network.mojom.NetworkAnnotationMonitor');
goog.require('network.mojom.NetworkChangeManager');
goog.require('network.mojom.NetworkContext');
goog.require('network.mojom.NetworkQualityEstimatorManager');
goog.require('network.mojom.NetworkServiceTest');
goog.require('network.mojom.SystemDnsResolver');
goog.require('network.mojom.URLLoader');
goog.require('network.mojom.URLLoaderClient');
goog.require('network.mojom.URLLoaderNetworkServiceObserver');
goog.require('mojoBase.mojom.ByteString');
goog.require('network.mojom.CTLogInfo');
goog.require('contentSettings.mojom.ContentSettingPatternSource');
goog.require('mojoBase.mojom.DictionaryValue');
goog.require('network.mojom.DnsOverHttpsConfig');
goog.require('mojoBase.mojom.File');
goog.require('network.mojom.GlobalFirstPartySets');
goog.require('network.mojom.HttpResponseHeaders');
goog.require('network.mojom.IPEndPoint');
goog.require('network.mojom.MutableNetworkTrafficAnnotationTag');
goog.require('network.mojom.NetworkContextParams');
goog.require('network.mojom.NetworkInterface');
goog.require('url.mojom.Origin');
goog.require('network.mojom.ParsedHeaders');
goog.require('network.mojom.PinList');
goog.require('mojoBase.mojom.Time');
goog.require('mojoBase.mojom.TimeDelta');
goog.require('url.mojom.Url');






goog.provide('network.mojom.NetworkService');
goog.provide('network.mojom.NetworkServiceReceiver');
goog.provide('network.mojom.NetworkServiceCallbackRouter');
goog.provide('network.mojom.NetworkServiceInterface');
goog.provide('network.mojom.NetworkServiceRemote');
goog.provide('network.mojom.NetworkServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.NetworkServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.NetworkService.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.NetworkServiceInterface = class {
  
  /**
   * @param { !network.mojom.NetworkServiceParams } params
   */

  setParams(params) {}
  
  /**
   * @param { !mojoBase.mojom.File } file
   * @param { !bigint } maxTotalSize
   * @param { !network.mojom.NetLogCaptureMode } captureMode
   * @param { !mojoBase.mojom.DictionaryValue } constants
   * @param { ?mojoBase.mojom.TimeDelta } duration
   */

  startNetLog(file, maxTotalSize, captureMode, constants, duration) {}
  
  /**
   * @param { !network.mojom.NetLogProxySourceRemote } proxySource
   * @param { !network.mojom.NetLogProxySinkPendingReceiver } proxySink
   */

  attachNetLogProxy(proxySource, proxySink) {}
  
  /**
   * @param { !mojoBase.mojom.File } file
   */

  setSSLKeyLogFile(file) {}
  
  /**
   * @param { !network.mojom.NetworkContextPendingReceiver } context
   * @param { !network.mojom.NetworkContextParams } params
   */

  createNetworkContext(context, params) {}
  
  /**
   * @param { !boolean } insecureDnsClientEnabled
   * @param { !boolean } happyEyeballsV3Enabled
   * @param { !network.mojom.SecureDnsMode } secureDnsMode
   * @param { !network.mojom.DnsOverHttpsConfig } dnsOverHttpsConfig
   * @param { !boolean } additionalDnsTypesEnabled
   * @param { !Array<!network.mojom.IPEndPoint> } fallbackDohNameservers
   */

  configureStubHostResolver(insecureDnsClientEnabled, happyEyeballsV3Enabled, secureDnsMode, dnsOverHttpsConfig, additionalDnsTypesEnabled, fallbackDohNameservers) {}
  
  /**
   */

  disableQuic() {}
  
  /**
   * @param { !network.mojom.HttpAuthStaticParams } httpAuthStaticParams
   */

  setUpHttpAuth(httpAuthStaticParams) {}
  
  /**
   * @param { !network.mojom.HttpAuthDynamicParams } httpAuthDynamicParams
   */

  configureHttpAuthPrefs(httpAuthDynamicParams) {}
  
  /**
   * @param { !number } processId
   * @param { !Array<!url.mojom.Origin> } origins
   */

  setRawHeadersAccess(processId, origins) {}
  
  /**
   * @param { !number } maxConnections
   */

  setMaxConnectionsPerProxyChain(maxConnections) {}
  
  /**
   * @param { !network.mojom.NetworkChangeManagerPendingReceiver } networkChangeManager
   */

  getNetworkChangeManager(networkChangeManager) {}
  
  /**
   * @param { !network.mojom.NetworkQualityEstimatorManagerPendingReceiver } receiver
   */

  getNetworkQualityEstimatorManager(receiver) {}
  
  /**
   * @param { !network.mojom.DnsConfigChangeManagerPendingReceiver } receiver
   */

  getDnsConfigChangeManager(receiver) {}
  
  /**
   * @param { !number } policy
   * @return {!Promise<{
        networks: ?Array<!network.mojom.NetworkInterface>,
   *  }>}
   */

  getNetworkList(policy) {}
  
  /**
   */

  onTrustStoreChanged() {}
  
  /**
   */

  onClientCertStoreChanged() {}
  
  /**
   * @param { !mojoBase.mojom.ByteString } encryptionKey
   */

  setEncryptionKey(encryptionKey) {}
  
  /**
   * @param { !mojoBase.mojom.MemoryPressureLevel } memoryPressureLevel
   */

  onMemoryPressure(memoryPressureLevel) {}
  
  /**
   * @param { !number } count
   */

  onPeerToPeerConnectionsCountChange(count) {}
  
  /**
   * @param { !string } rawCommitments
   * @return {!Promise}
   */

  setTrustTokenKeyCommitments(rawCommitments) {}
  
  /**
   */

  clearSCTAuditingCache() {}
  
  /**
   * @param { !network.mojom.SCTAuditingConfiguration } configuration
   */

  configureSCTAuditing(configuration) {}
  
  /**
   * @param { !Array<!network.mojom.CTLogInfo> } logList
   * @return {!Promise}
   */

  updateCtLogList(logList) {}
  
  /**
   * @param { !Array<!Array<!number>> } sctHashes
   * @return {!Promise}
   */

  updateCtKnownPopularSCTs(sctHashes) {}
  
  /**
   * @param { !boolean } enabled
   * @return {!Promise}
   */

  setCtEnforcementEnabled(enabled) {}
  
  /**
   * @param { !network.mojom.PinList } pinList
   * @param { !mojoBase.mojom.Time } updateTime
   */

  updateKeyPinsList(pinList, updateTime) {}
  
  /**
   * @param { !network.mojom.NetworkServiceTestPendingReceiver } receiver
   */

  bindTestInterfaceForTesting(receiver) {}
  
  /**
   * @param { !network.mojom.GlobalFirstPartySets } sets
   */

  setFirstPartySets(sets) {}
  
  /**
   * @param { !Array<!number> } ports
   */

  setExplicitlyAllowedPorts(ports) {}
  
  /**
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.HttpResponseHeaders } headers
   * @return {!Promise<{
        parsedHeaders: !network.mojom.ParsedHeaders,
   *  }>}
   */

  parseHeaders(url, headers) {}
  
  /**
   * @param { !boolean } enable
   */

  enableDataUseUpdates(enable) {}
  
  /**
   * @param { !boolean } reachabilityOverride
   */

  setIPv6ReachabilityOverride(reachabilityOverride) {}
  
  /**
   * @param { !network.mojom.NetworkAnnotationMonitorRemote } remote
   */

  setNetworkAnnotationMonitor(remote) {}
  
  /**
   * @param { !Array<!contentSettings.mojom.ContentSettingPatternSource> } settings
   */

  setTpcdMetadataGrants(settings) {}
  
  /**
   * @param { !Array<!network.mojom.SourceType> } contentEncodingTypes
   * @param { !MojoHandle } sourceBody
   * @param { !MojoHandle } destBody
   * @param { !network.mojom.URLLoaderRemote } sourceUrlLoader
   * @param { !network.mojom.URLLoaderClientPendingReceiver } sourceUrlLoaderClient
   * @param { !network.mojom.URLLoaderPendingReceiver } destUrlLoader
   * @param { !network.mojom.URLLoaderClientRemote } destUrlLoaderClient
   */

  interceptUrlLoaderForBodyDecoding(contentEncodingTypes, sourceBody, destBody, sourceUrlLoader, sourceUrlLoaderClient, destUrlLoader, destUrlLoaderClient) {}
  
  /**
   * @param { !Array<!network.mojom.SourceType> } contentEncodingTypes
   * @param { !MojoHandle } sourceBody
   * @param { !MojoHandle } destBody
   * @return {!Promise<{
        errorCode: !number,
   *  }>}
   */

  decodeContentEncoding(contentEncodingTypes, sourceBody, destBody) {}
  
  /**
   * @param { !boolean } enabled
   */

  setTLS13EarlyDataEnabled(enabled) {}
};

/**
 * @export
 * @implements { network.mojom.NetworkServiceInterface }
 */
network.mojom.NetworkServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.NetworkServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.NetworkServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.NetworkServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.NetworkServiceParams } params
   */

  setParams(
      params) {
    this.proxy.sendMessage(
        0,
        network.mojom.NetworkService_SetParams_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.File } file
   * @param { !bigint } maxTotalSize
   * @param { !network.mojom.NetLogCaptureMode } captureMode
   * @param { !mojoBase.mojom.DictionaryValue } constants
   * @param { ?mojoBase.mojom.TimeDelta } duration
   */

  startNetLog(
      file,
      maxTotalSize,
      captureMode,
      constants,
      duration) {
    this.proxy.sendMessage(
        1,
        network.mojom.NetworkService_StartNetLog_ParamsSpec.$,
        null,
        [
          file,
          maxTotalSize,
          captureMode,
          constants,
          duration
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.NetLogProxySourceRemote } proxySource
   * @param { !network.mojom.NetLogProxySinkPendingReceiver } proxySink
   */

  attachNetLogProxy(
      proxySource,
      proxySink) {
    this.proxy.sendMessage(
        2,
        network.mojom.NetworkService_AttachNetLogProxy_ParamsSpec.$,
        null,
        [
          proxySource,
          proxySink
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.File } file
   */

  setSSLKeyLogFile(
      file) {
    this.proxy.sendMessage(
        3,
        network.mojom.NetworkService_SetSSLKeyLogFile_ParamsSpec.$,
        null,
        [
          file
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.NetworkContextPendingReceiver } context
   * @param { !network.mojom.NetworkContextParams } params
   */

  createNetworkContext(
      context,
      params) {
    this.proxy.sendMessage(
        4,
        network.mojom.NetworkService_CreateNetworkContext_ParamsSpec.$,
        null,
        [
          context,
          params
        ],
        false);
  }

  
  /**
   * @param { !boolean } insecureDnsClientEnabled
   * @param { !boolean } happyEyeballsV3Enabled
   * @param { !network.mojom.SecureDnsMode } secureDnsMode
   * @param { !network.mojom.DnsOverHttpsConfig } dnsOverHttpsConfig
   * @param { !boolean } additionalDnsTypesEnabled
   * @param { !Array<!network.mojom.IPEndPoint> } fallbackDohNameservers
   */

  configureStubHostResolver(
      insecureDnsClientEnabled,
      happyEyeballsV3Enabled,
      secureDnsMode,
      dnsOverHttpsConfig,
      additionalDnsTypesEnabled,
      fallbackDohNameservers) {
    this.proxy.sendMessage(
        5,
        network.mojom.NetworkService_ConfigureStubHostResolver_ParamsSpec.$,
        null,
        [
          insecureDnsClientEnabled,
          happyEyeballsV3Enabled,
          secureDnsMode,
          dnsOverHttpsConfig,
          additionalDnsTypesEnabled,
          fallbackDohNameservers
        ],
        false);
  }

  
  /**
   */

  disableQuic() {
    this.proxy.sendMessage(
        6,
        network.mojom.NetworkService_DisableQuic_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.HttpAuthStaticParams } httpAuthStaticParams
   */

  setUpHttpAuth(
      httpAuthStaticParams) {
    this.proxy.sendMessage(
        7,
        network.mojom.NetworkService_SetUpHttpAuth_ParamsSpec.$,
        null,
        [
          httpAuthStaticParams
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.HttpAuthDynamicParams } httpAuthDynamicParams
   */

  configureHttpAuthPrefs(
      httpAuthDynamicParams) {
    this.proxy.sendMessage(
        8,
        network.mojom.NetworkService_ConfigureHttpAuthPrefs_ParamsSpec.$,
        null,
        [
          httpAuthDynamicParams
        ],
        false);
  }

  
  /**
   * @param { !number } processId
   * @param { !Array<!url.mojom.Origin> } origins
   */

  setRawHeadersAccess(
      processId,
      origins) {
    this.proxy.sendMessage(
        9,
        network.mojom.NetworkService_SetRawHeadersAccess_ParamsSpec.$,
        null,
        [
          processId,
          origins
        ],
        false);
  }

  
  /**
   * @param { !number } maxConnections
   */

  setMaxConnectionsPerProxyChain(
      maxConnections) {
    this.proxy.sendMessage(
        10,
        network.mojom.NetworkService_SetMaxConnectionsPerProxyChain_ParamsSpec.$,
        null,
        [
          maxConnections
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.NetworkChangeManagerPendingReceiver } networkChangeManager
   */

  getNetworkChangeManager(
      networkChangeManager) {
    this.proxy.sendMessage(
        11,
        network.mojom.NetworkService_GetNetworkChangeManager_ParamsSpec.$,
        null,
        [
          networkChangeManager
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.NetworkQualityEstimatorManagerPendingReceiver } receiver
   */

  getNetworkQualityEstimatorManager(
      receiver) {
    this.proxy.sendMessage(
        12,
        network.mojom.NetworkService_GetNetworkQualityEstimatorManager_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.DnsConfigChangeManagerPendingReceiver } receiver
   */

  getDnsConfigChangeManager(
      receiver) {
    this.proxy.sendMessage(
        13,
        network.mojom.NetworkService_GetDnsConfigChangeManager_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !number } policy
   * @return {!Promise<{
        networks: ?Array<!network.mojom.NetworkInterface>,
   *  }>}
   */

  getNetworkList(
      policy) {
    return this.proxy.sendMessage(
        14,
        network.mojom.NetworkService_GetNetworkList_ParamsSpec.$,
        network.mojom.NetworkService_GetNetworkList_ResponseParamsSpec.$,
        [
          policy
        ],
        false);
  }

  
  /**
   */

  onTrustStoreChanged() {
    this.proxy.sendMessage(
        15,
        network.mojom.NetworkService_OnTrustStoreChanged_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onClientCertStoreChanged() {
    this.proxy.sendMessage(
        16,
        network.mojom.NetworkService_OnClientCertStoreChanged_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.ByteString } encryptionKey
   */

  setEncryptionKey(
      encryptionKey) {
    this.proxy.sendMessage(
        17,
        network.mojom.NetworkService_SetEncryptionKey_ParamsSpec.$,
        null,
        [
          encryptionKey
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.MemoryPressureLevel } memoryPressureLevel
   */

  onMemoryPressure(
      memoryPressureLevel) {
    this.proxy.sendMessage(
        18,
        network.mojom.NetworkService_OnMemoryPressure_ParamsSpec.$,
        null,
        [
          memoryPressureLevel
        ],
        false);
  }

  
  /**
   * @param { !number } count
   */

  onPeerToPeerConnectionsCountChange(
      count) {
    this.proxy.sendMessage(
        19,
        network.mojom.NetworkService_OnPeerToPeerConnectionsCountChange_ParamsSpec.$,
        null,
        [
          count
        ],
        false);
  }

  
  /**
   * @param { !string } rawCommitments
   * @return {!Promise}
   */

  setTrustTokenKeyCommitments(
      rawCommitments) {
    return this.proxy.sendMessage(
        20,
        network.mojom.NetworkService_SetTrustTokenKeyCommitments_ParamsSpec.$,
        network.mojom.NetworkService_SetTrustTokenKeyCommitments_ResponseParamsSpec.$,
        [
          rawCommitments
        ],
        false);
  }

  
  /**
   */

  clearSCTAuditingCache() {
    this.proxy.sendMessage(
        21,
        network.mojom.NetworkService_ClearSCTAuditingCache_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.SCTAuditingConfiguration } configuration
   */

  configureSCTAuditing(
      configuration) {
    this.proxy.sendMessage(
        22,
        network.mojom.NetworkService_ConfigureSCTAuditing_ParamsSpec.$,
        null,
        [
          configuration
        ],
        false);
  }

  
  /**
   * @param { !Array<!network.mojom.CTLogInfo> } logList
   * @return {!Promise}
   */

  updateCtLogList(
      logList) {
    return this.proxy.sendMessage(
        23,
        network.mojom.NetworkService_UpdateCtLogList_ParamsSpec.$,
        network.mojom.NetworkService_UpdateCtLogList_ResponseParamsSpec.$,
        [
          logList
        ],
        false);
  }

  
  /**
   * @param { !Array<!Array<!number>> } sctHashes
   * @return {!Promise}
   */

  updateCtKnownPopularSCTs(
      sctHashes) {
    return this.proxy.sendMessage(
        24,
        network.mojom.NetworkService_UpdateCtKnownPopularSCTs_ParamsSpec.$,
        network.mojom.NetworkService_UpdateCtKnownPopularSCTs_ResponseParamsSpec.$,
        [
          sctHashes
        ],
        false);
  }

  
  /**
   * @param { !boolean } enabled
   * @return {!Promise}
   */

  setCtEnforcementEnabled(
      enabled) {
    return this.proxy.sendMessage(
        25,
        network.mojom.NetworkService_SetCtEnforcementEnabled_ParamsSpec.$,
        network.mojom.NetworkService_SetCtEnforcementEnabled_ResponseParamsSpec.$,
        [
          enabled
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.PinList } pinList
   * @param { !mojoBase.mojom.Time } updateTime
   */

  updateKeyPinsList(
      pinList,
      updateTime) {
    this.proxy.sendMessage(
        26,
        network.mojom.NetworkService_UpdateKeyPinsList_ParamsSpec.$,
        null,
        [
          pinList,
          updateTime
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.NetworkServiceTestPendingReceiver } receiver
   */

  bindTestInterfaceForTesting(
      receiver) {
    this.proxy.sendMessage(
        27,
        network.mojom.NetworkService_BindTestInterfaceForTesting_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.GlobalFirstPartySets } sets
   */

  setFirstPartySets(
      sets) {
    this.proxy.sendMessage(
        28,
        network.mojom.NetworkService_SetFirstPartySets_ParamsSpec.$,
        null,
        [
          sets
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } ports
   */

  setExplicitlyAllowedPorts(
      ports) {
    this.proxy.sendMessage(
        29,
        network.mojom.NetworkService_SetExplicitlyAllowedPorts_ParamsSpec.$,
        null,
        [
          ports
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.HttpResponseHeaders } headers
   * @return {!Promise<{
        parsedHeaders: !network.mojom.ParsedHeaders,
   *  }>}
   */

  parseHeaders(
      url,
      headers) {
    return this.proxy.sendMessage(
        30,
        network.mojom.NetworkService_ParseHeaders_ParamsSpec.$,
        network.mojom.NetworkService_ParseHeaders_ResponseParamsSpec.$,
        [
          url,
          headers
        ],
        false);
  }

  
  /**
   * @param { !boolean } enable
   */

  enableDataUseUpdates(
      enable) {
    this.proxy.sendMessage(
        31,
        network.mojom.NetworkService_EnableDataUseUpdates_ParamsSpec.$,
        null,
        [
          enable
        ],
        false);
  }

  
  /**
   * @param { !boolean } reachabilityOverride
   */

  setIPv6ReachabilityOverride(
      reachabilityOverride) {
    this.proxy.sendMessage(
        32,
        network.mojom.NetworkService_SetIPv6ReachabilityOverride_ParamsSpec.$,
        null,
        [
          reachabilityOverride
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.NetworkAnnotationMonitorRemote } remote
   */

  setNetworkAnnotationMonitor(
      remote) {
    this.proxy.sendMessage(
        33,
        network.mojom.NetworkService_SetNetworkAnnotationMonitor_ParamsSpec.$,
        null,
        [
          remote
        ],
        false);
  }

  
  /**
   * @param { !Array<!contentSettings.mojom.ContentSettingPatternSource> } settings
   */

  setTpcdMetadataGrants(
      settings) {
    this.proxy.sendMessage(
        34,
        network.mojom.NetworkService_SetTpcdMetadataGrants_ParamsSpec.$,
        null,
        [
          settings
        ],
        false);
  }

  
  /**
   * @param { !Array<!network.mojom.SourceType> } contentEncodingTypes
   * @param { !MojoHandle } sourceBody
   * @param { !MojoHandle } destBody
   * @param { !network.mojom.URLLoaderRemote } sourceUrlLoader
   * @param { !network.mojom.URLLoaderClientPendingReceiver } sourceUrlLoaderClient
   * @param { !network.mojom.URLLoaderPendingReceiver } destUrlLoader
   * @param { !network.mojom.URLLoaderClientRemote } destUrlLoaderClient
   */

  interceptUrlLoaderForBodyDecoding(
      contentEncodingTypes,
      sourceBody,
      destBody,
      sourceUrlLoader,
      sourceUrlLoaderClient,
      destUrlLoader,
      destUrlLoaderClient) {
    this.proxy.sendMessage(
        35,
        network.mojom.NetworkService_InterceptUrlLoaderForBodyDecoding_ParamsSpec.$,
        null,
        [
          contentEncodingTypes,
          sourceBody,
          destBody,
          sourceUrlLoader,
          sourceUrlLoaderClient,
          destUrlLoader,
          destUrlLoaderClient
        ],
        false);
  }

  
  /**
   * @param { !Array<!network.mojom.SourceType> } contentEncodingTypes
   * @param { !MojoHandle } sourceBody
   * @param { !MojoHandle } destBody
   * @return {!Promise<{
        errorCode: !number,
   *  }>}
   */

  decodeContentEncoding(
      contentEncodingTypes,
      sourceBody,
      destBody) {
    return this.proxy.sendMessage(
        36,
        network.mojom.NetworkService_DecodeContentEncoding_ParamsSpec.$,
        network.mojom.NetworkService_DecodeContentEncoding_ResponseParamsSpec.$,
        [
          contentEncodingTypes,
          sourceBody,
          destBody
        ],
        false);
  }

  
  /**
   * @param { !boolean } enabled
   */

  setTLS13EarlyDataEnabled(
      enabled) {
    this.proxy.sendMessage(
        37,
        network.mojom.NetworkService_SetTLS13EarlyDataEnabled_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NetworkService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.NetworkServiceReceiver = class {
  /**
   * @param {!network.mojom.NetworkServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.NetworkServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.NetworkServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.NetworkServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.NetworkService_SetParams_ParamsSpec.$,
        null,
        impl.setParams.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.NetworkService_StartNetLog_ParamsSpec.$,
        null,
        impl.startNetLog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.NetworkService_AttachNetLogProxy_ParamsSpec.$,
        null,
        impl.attachNetLogProxy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.NetworkService_SetSSLKeyLogFile_ParamsSpec.$,
        null,
        impl.setSSLKeyLogFile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        network.mojom.NetworkService_CreateNetworkContext_ParamsSpec.$,
        null,
        impl.createNetworkContext.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        network.mojom.NetworkService_ConfigureStubHostResolver_ParamsSpec.$,
        null,
        impl.configureStubHostResolver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        network.mojom.NetworkService_DisableQuic_ParamsSpec.$,
        null,
        impl.disableQuic.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        network.mojom.NetworkService_SetUpHttpAuth_ParamsSpec.$,
        null,
        impl.setUpHttpAuth.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        network.mojom.NetworkService_ConfigureHttpAuthPrefs_ParamsSpec.$,
        null,
        impl.configureHttpAuthPrefs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        network.mojom.NetworkService_SetRawHeadersAccess_ParamsSpec.$,
        null,
        impl.setRawHeadersAccess.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        network.mojom.NetworkService_SetMaxConnectionsPerProxyChain_ParamsSpec.$,
        null,
        impl.setMaxConnectionsPerProxyChain.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        network.mojom.NetworkService_GetNetworkChangeManager_ParamsSpec.$,
        null,
        impl.getNetworkChangeManager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        network.mojom.NetworkService_GetNetworkQualityEstimatorManager_ParamsSpec.$,
        null,
        impl.getNetworkQualityEstimatorManager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        network.mojom.NetworkService_GetDnsConfigChangeManager_ParamsSpec.$,
        null,
        impl.getDnsConfigChangeManager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        network.mojom.NetworkService_GetNetworkList_ParamsSpec.$,
        network.mojom.NetworkService_GetNetworkList_ResponseParamsSpec.$,
        impl.getNetworkList.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        network.mojom.NetworkService_OnTrustStoreChanged_ParamsSpec.$,
        null,
        impl.onTrustStoreChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        network.mojom.NetworkService_OnClientCertStoreChanged_ParamsSpec.$,
        null,
        impl.onClientCertStoreChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        network.mojom.NetworkService_SetEncryptionKey_ParamsSpec.$,
        null,
        impl.setEncryptionKey.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        network.mojom.NetworkService_OnMemoryPressure_ParamsSpec.$,
        null,
        impl.onMemoryPressure.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        network.mojom.NetworkService_OnPeerToPeerConnectionsCountChange_ParamsSpec.$,
        null,
        impl.onPeerToPeerConnectionsCountChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        network.mojom.NetworkService_SetTrustTokenKeyCommitments_ParamsSpec.$,
        network.mojom.NetworkService_SetTrustTokenKeyCommitments_ResponseParamsSpec.$,
        impl.setTrustTokenKeyCommitments.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        network.mojom.NetworkService_ClearSCTAuditingCache_ParamsSpec.$,
        null,
        impl.clearSCTAuditingCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        network.mojom.NetworkService_ConfigureSCTAuditing_ParamsSpec.$,
        null,
        impl.configureSCTAuditing.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        network.mojom.NetworkService_UpdateCtLogList_ParamsSpec.$,
        network.mojom.NetworkService_UpdateCtLogList_ResponseParamsSpec.$,
        impl.updateCtLogList.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        network.mojom.NetworkService_UpdateCtKnownPopularSCTs_ParamsSpec.$,
        network.mojom.NetworkService_UpdateCtKnownPopularSCTs_ResponseParamsSpec.$,
        impl.updateCtKnownPopularSCTs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        network.mojom.NetworkService_SetCtEnforcementEnabled_ParamsSpec.$,
        network.mojom.NetworkService_SetCtEnforcementEnabled_ResponseParamsSpec.$,
        impl.setCtEnforcementEnabled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        network.mojom.NetworkService_UpdateKeyPinsList_ParamsSpec.$,
        null,
        impl.updateKeyPinsList.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        network.mojom.NetworkService_BindTestInterfaceForTesting_ParamsSpec.$,
        null,
        impl.bindTestInterfaceForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        28,
        network.mojom.NetworkService_SetFirstPartySets_ParamsSpec.$,
        null,
        impl.setFirstPartySets.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        29,
        network.mojom.NetworkService_SetExplicitlyAllowedPorts_ParamsSpec.$,
        null,
        impl.setExplicitlyAllowedPorts.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        30,
        network.mojom.NetworkService_ParseHeaders_ParamsSpec.$,
        network.mojom.NetworkService_ParseHeaders_ResponseParamsSpec.$,
        impl.parseHeaders.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        31,
        network.mojom.NetworkService_EnableDataUseUpdates_ParamsSpec.$,
        null,
        impl.enableDataUseUpdates.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        32,
        network.mojom.NetworkService_SetIPv6ReachabilityOverride_ParamsSpec.$,
        null,
        impl.setIPv6ReachabilityOverride.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        33,
        network.mojom.NetworkService_SetNetworkAnnotationMonitor_ParamsSpec.$,
        null,
        impl.setNetworkAnnotationMonitor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        34,
        network.mojom.NetworkService_SetTpcdMetadataGrants_ParamsSpec.$,
        null,
        impl.setTpcdMetadataGrants.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        35,
        network.mojom.NetworkService_InterceptUrlLoaderForBodyDecoding_ParamsSpec.$,
        null,
        impl.interceptUrlLoaderForBodyDecoding.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        36,
        network.mojom.NetworkService_DecodeContentEncoding_ParamsSpec.$,
        network.mojom.NetworkService_DecodeContentEncoding_ResponseParamsSpec.$,
        impl.decodeContentEncoding.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        37,
        network.mojom.NetworkService_SetTLS13EarlyDataEnabled_ParamsSpec.$,
        null,
        impl.setTLS13EarlyDataEnabled.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.NetworkService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.NetworkService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.NetworkServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.NetworkServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the NetworkService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.NetworkServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.NetworkServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.NetworkServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setParams =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.NetworkService_SetParams_ParamsSpec.$,
        null,
        this.setParams.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startNetLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.NetworkService_StartNetLog_ParamsSpec.$,
        null,
        this.startNetLog.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.attachNetLogProxy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.NetworkService_AttachNetLogProxy_ParamsSpec.$,
        null,
        this.attachNetLogProxy.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSSLKeyLogFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.NetworkService_SetSSLKeyLogFile_ParamsSpec.$,
        null,
        this.setSSLKeyLogFile.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createNetworkContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        network.mojom.NetworkService_CreateNetworkContext_ParamsSpec.$,
        null,
        this.createNetworkContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.configureStubHostResolver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        network.mojom.NetworkService_ConfigureStubHostResolver_ParamsSpec.$,
        null,
        this.configureStubHostResolver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.disableQuic =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        network.mojom.NetworkService_DisableQuic_ParamsSpec.$,
        null,
        this.disableQuic.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setUpHttpAuth =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        network.mojom.NetworkService_SetUpHttpAuth_ParamsSpec.$,
        null,
        this.setUpHttpAuth.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.configureHttpAuthPrefs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        network.mojom.NetworkService_ConfigureHttpAuthPrefs_ParamsSpec.$,
        null,
        this.configureHttpAuthPrefs.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setRawHeadersAccess =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        network.mojom.NetworkService_SetRawHeadersAccess_ParamsSpec.$,
        null,
        this.setRawHeadersAccess.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setMaxConnectionsPerProxyChain =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        network.mojom.NetworkService_SetMaxConnectionsPerProxyChain_ParamsSpec.$,
        null,
        this.setMaxConnectionsPerProxyChain.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getNetworkChangeManager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        network.mojom.NetworkService_GetNetworkChangeManager_ParamsSpec.$,
        null,
        this.getNetworkChangeManager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getNetworkQualityEstimatorManager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        network.mojom.NetworkService_GetNetworkQualityEstimatorManager_ParamsSpec.$,
        null,
        this.getNetworkQualityEstimatorManager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDnsConfigChangeManager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        network.mojom.NetworkService_GetDnsConfigChangeManager_ParamsSpec.$,
        null,
        this.getDnsConfigChangeManager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getNetworkList =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        network.mojom.NetworkService_GetNetworkList_ParamsSpec.$,
        network.mojom.NetworkService_GetNetworkList_ResponseParamsSpec.$,
        this.getNetworkList.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTrustStoreChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        network.mojom.NetworkService_OnTrustStoreChanged_ParamsSpec.$,
        null,
        this.onTrustStoreChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onClientCertStoreChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        network.mojom.NetworkService_OnClientCertStoreChanged_ParamsSpec.$,
        null,
        this.onClientCertStoreChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setEncryptionKey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        network.mojom.NetworkService_SetEncryptionKey_ParamsSpec.$,
        null,
        this.setEncryptionKey.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onMemoryPressure =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        network.mojom.NetworkService_OnMemoryPressure_ParamsSpec.$,
        null,
        this.onMemoryPressure.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPeerToPeerConnectionsCountChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        network.mojom.NetworkService_OnPeerToPeerConnectionsCountChange_ParamsSpec.$,
        null,
        this.onPeerToPeerConnectionsCountChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTrustTokenKeyCommitments =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        network.mojom.NetworkService_SetTrustTokenKeyCommitments_ParamsSpec.$,
        network.mojom.NetworkService_SetTrustTokenKeyCommitments_ResponseParamsSpec.$,
        this.setTrustTokenKeyCommitments.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearSCTAuditingCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        network.mojom.NetworkService_ClearSCTAuditingCache_ParamsSpec.$,
        null,
        this.clearSCTAuditingCache.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.configureSCTAuditing =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        network.mojom.NetworkService_ConfigureSCTAuditing_ParamsSpec.$,
        null,
        this.configureSCTAuditing.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateCtLogList =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        network.mojom.NetworkService_UpdateCtLogList_ParamsSpec.$,
        network.mojom.NetworkService_UpdateCtLogList_ResponseParamsSpec.$,
        this.updateCtLogList.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateCtKnownPopularSCTs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        network.mojom.NetworkService_UpdateCtKnownPopularSCTs_ParamsSpec.$,
        network.mojom.NetworkService_UpdateCtKnownPopularSCTs_ResponseParamsSpec.$,
        this.updateCtKnownPopularSCTs.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCtEnforcementEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        network.mojom.NetworkService_SetCtEnforcementEnabled_ParamsSpec.$,
        network.mojom.NetworkService_SetCtEnforcementEnabled_ResponseParamsSpec.$,
        this.setCtEnforcementEnabled.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateKeyPinsList =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        network.mojom.NetworkService_UpdateKeyPinsList_ParamsSpec.$,
        null,
        this.updateKeyPinsList.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindTestInterfaceForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        network.mojom.NetworkService_BindTestInterfaceForTesting_ParamsSpec.$,
        null,
        this.bindTestInterfaceForTesting.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setFirstPartySets =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        28,
        network.mojom.NetworkService_SetFirstPartySets_ParamsSpec.$,
        null,
        this.setFirstPartySets.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setExplicitlyAllowedPorts =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        29,
        network.mojom.NetworkService_SetExplicitlyAllowedPorts_ParamsSpec.$,
        null,
        this.setExplicitlyAllowedPorts.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.parseHeaders =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        30,
        network.mojom.NetworkService_ParseHeaders_ParamsSpec.$,
        network.mojom.NetworkService_ParseHeaders_ResponseParamsSpec.$,
        this.parseHeaders.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableDataUseUpdates =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        31,
        network.mojom.NetworkService_EnableDataUseUpdates_ParamsSpec.$,
        null,
        this.enableDataUseUpdates.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIPv6ReachabilityOverride =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        32,
        network.mojom.NetworkService_SetIPv6ReachabilityOverride_ParamsSpec.$,
        null,
        this.setIPv6ReachabilityOverride.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setNetworkAnnotationMonitor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        33,
        network.mojom.NetworkService_SetNetworkAnnotationMonitor_ParamsSpec.$,
        null,
        this.setNetworkAnnotationMonitor.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTpcdMetadataGrants =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        34,
        network.mojom.NetworkService_SetTpcdMetadataGrants_ParamsSpec.$,
        null,
        this.setTpcdMetadataGrants.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.interceptUrlLoaderForBodyDecoding =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        35,
        network.mojom.NetworkService_InterceptUrlLoaderForBodyDecoding_ParamsSpec.$,
        null,
        this.interceptUrlLoaderForBodyDecoding.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.decodeContentEncoding =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        36,
        network.mojom.NetworkService_DecodeContentEncoding_ParamsSpec.$,
        network.mojom.NetworkService_DecodeContentEncoding_ResponseParamsSpec.$,
        this.decodeContentEncoding.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTLS13EarlyDataEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        37,
        network.mojom.NetworkService_SetTLS13EarlyDataEnabled_ParamsSpec.$,
        null,
        this.setTLS13EarlyDataEnabled.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.HttpAuthStaticParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpAuthStaticParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.HttpAuthDynamicParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.HttpAuthDynamicParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.EnvironmentVariableSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.EnvironmentVariableSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SCTAuditingConfigurationSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SCTAuditingConfigurationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_SetParams_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_SetParams_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_StartNetLog_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_StartNetLog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_AttachNetLogProxy_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_AttachNetLogProxy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_SetSSLKeyLogFile_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_SetSSLKeyLogFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_CreateNetworkContext_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_CreateNetworkContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_ConfigureStubHostResolver_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_ConfigureStubHostResolver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_DisableQuic_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_DisableQuic_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_SetUpHttpAuth_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_SetUpHttpAuth_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_ConfigureHttpAuthPrefs_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_ConfigureHttpAuthPrefs_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_SetRawHeadersAccess_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_SetRawHeadersAccess_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_SetMaxConnectionsPerProxyChain_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_SetMaxConnectionsPerProxyChain_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_GetNetworkChangeManager_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_GetNetworkChangeManager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_GetNetworkQualityEstimatorManager_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_GetNetworkQualityEstimatorManager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_GetDnsConfigChangeManager_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_GetDnsConfigChangeManager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_GetNetworkList_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_GetNetworkList_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_GetNetworkList_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_GetNetworkList_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_OnTrustStoreChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_OnTrustStoreChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_OnClientCertStoreChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_OnClientCertStoreChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_SetEncryptionKey_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_SetEncryptionKey_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_OnMemoryPressure_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_OnMemoryPressure_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_OnPeerToPeerConnectionsCountChange_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_OnPeerToPeerConnectionsCountChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_SetTrustTokenKeyCommitments_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_SetTrustTokenKeyCommitments_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_SetTrustTokenKeyCommitments_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_SetTrustTokenKeyCommitments_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_ClearSCTAuditingCache_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_ClearSCTAuditingCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_ConfigureSCTAuditing_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_ConfigureSCTAuditing_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_UpdateCtLogList_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_UpdateCtLogList_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_UpdateCtLogList_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_UpdateCtLogList_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_UpdateCtKnownPopularSCTs_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_UpdateCtKnownPopularSCTs_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_UpdateCtKnownPopularSCTs_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_UpdateCtKnownPopularSCTs_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_SetCtEnforcementEnabled_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_SetCtEnforcementEnabled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_SetCtEnforcementEnabled_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_SetCtEnforcementEnabled_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_UpdateKeyPinsList_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_UpdateKeyPinsList_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_BindTestInterfaceForTesting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_BindTestInterfaceForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_SetFirstPartySets_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_SetFirstPartySets_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_SetExplicitlyAllowedPorts_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_SetExplicitlyAllowedPorts_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_ParseHeaders_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_ParseHeaders_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_ParseHeaders_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_ParseHeaders_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_EnableDataUseUpdates_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_EnableDataUseUpdates_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_SetIPv6ReachabilityOverride_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_SetIPv6ReachabilityOverride_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_SetNetworkAnnotationMonitor_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_SetNetworkAnnotationMonitor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_SetTpcdMetadataGrants_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_SetTpcdMetadataGrants_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_InterceptUrlLoaderForBodyDecoding_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_InterceptUrlLoaderForBodyDecoding_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_DecodeContentEncoding_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_DecodeContentEncoding_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_DecodeContentEncoding_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_DecodeContentEncoding_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkService_SetTLS13EarlyDataEnabled_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkService_SetTLS13EarlyDataEnabled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.HttpAuthStaticParamsSpec.$,
    'HttpAuthStaticParams',
    [
      mojo.internal.StructField(
        'gssapiLibraryName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.HttpAuthStaticParams');

/** @record */
network.mojom.HttpAuthStaticParams = class {
  constructor() {
    /** @export { !string } */
    this.gssapiLibraryName;
  }
};



mojo.internal.Struct(
    network.mojom.HttpAuthDynamicParamsSpec.$,
    'HttpAuthDynamicParams',
    [
      mojo.internal.StructField(
        'allowedSchemes', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'patternsAllowedToUseAllSchemes', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serverAllowlist', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'delegateAllowlist', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'delegateByKdcPolicy', 32,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'negotiateDisableCnameLookup', 32,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableNegotiatePort', 32,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ntlmV2Enabled', 32,
        3,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'androidNegotiateAccountType', 40,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowGssapiLibraryLoad', 32,
        4,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'basicOverHttpEnabled', 32,
        5,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('network.mojom.HttpAuthDynamicParams');

/** @record */
network.mojom.HttpAuthDynamicParams = class {
  constructor() {
    /** @export { (Array<!string>|undefined) } */
    this.allowedSchemes;
    /** @export { !Array<!string> } */
    this.patternsAllowedToUseAllSchemes;
    /** @export { !string } */
    this.serverAllowlist;
    /** @export { !string } */
    this.delegateAllowlist;
    /** @export { !boolean } */
    this.delegateByKdcPolicy;
    /** @export { !boolean } */
    this.negotiateDisableCnameLookup;
    /** @export { !boolean } */
    this.enableNegotiatePort;
    /** @export { !boolean } */
    this.ntlmV2Enabled;
    /** @export { !string } */
    this.androidNegotiateAccountType;
    /** @export { !boolean } */
    this.allowGssapiLibraryLoad;
    /** @export { !boolean } */
    this.basicOverHttpEnabled;
  }
};



mojo.internal.Struct(
    network.mojom.EnvironmentVariableSpec.$,
    'EnvironmentVariable',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.EnvironmentVariable');

/** @record */
network.mojom.EnvironmentVariable = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !string } */
    this.value;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceParamsSpec.$,
    'NetworkServiceParams',
    [
      mojo.internal.StructField(
        'initialConnectionType', 0,
        0,
        network.mojom.ConnectionTypeSpec.$,
        network.mojom.ConnectionType.CONNECTION_UNKNOWN,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initialConnectionSubtype', 4,
        0,
        network.mojom.ConnectionSubtypeSpec.$,
        network.mojom.ConnectionSubtype.SUBTYPE_UNKNOWN,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'environment', 8,
        0,
        mojo.internal.Array(network.mojom.EnvironmentVariableSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'defaultObserver', 16,
        0,
        mojo.internal.InterfaceProxy(network.mojom.URLLoaderNetworkServiceObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'firstPartySetsEnabled', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'systemDnsResolver', 28,
        0,
        mojo.internal.InterfaceProxy(network.mojom.SystemDnsResolverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('network.mojom.NetworkServiceParams');

/** @record */
network.mojom.NetworkServiceParams = class {
  constructor() {
    /** @export { !network.mojom.ConnectionType } */
    this.initialConnectionType;
    /** @export { !network.mojom.ConnectionSubtype } */
    this.initialConnectionSubtype;
    /** @export { !Array<!network.mojom.EnvironmentVariable> } */
    this.environment;
    /** @export { !network.mojom.URLLoaderNetworkServiceObserverRemote } */
    this.defaultObserver;
    /** @export { !boolean } */
    this.firstPartySetsEnabled;
    /** @export { (network.mojom.SystemDnsResolverRemote|undefined) } */
    this.systemDnsResolver;
  }
};



mojo.internal.Struct(
    network.mojom.SCTAuditingConfigurationSpec.$,
    'SCTAuditingConfiguration',
    [
      mojo.internal.StructField(
        'samplingRate', 0,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'logExpectedIngestionDelay', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'logMaxIngestionRandomDelay', 16,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportUri', 24,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hashdanceLookupUri', 32,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 40,
        0,
        network.mojom.MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hashdanceTrafficAnnotation', 48,
        0,
        network.mojom.MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);



goog.provide('network.mojom.SCTAuditingConfiguration');

/** @record */
network.mojom.SCTAuditingConfiguration = class {
  constructor() {
    /** @export { !number } */
    this.samplingRate;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.logExpectedIngestionDelay;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.logMaxIngestionRandomDelay;
    /** @export { !url.mojom.Url } */
    this.reportUri;
    /** @export { !url.mojom.Url } */
    this.hashdanceLookupUri;
    /** @export { !network.mojom.MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @export { !network.mojom.MutableNetworkTrafficAnnotationTag } */
    this.hashdanceTrafficAnnotation;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_SetParams_ParamsSpec.$,
    'NetworkService_SetParams_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        network.mojom.NetworkServiceParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_SetParams_Params');

/** @record */
network.mojom.NetworkService_SetParams_Params = class {
  constructor() {
    /** @export { !network.mojom.NetworkServiceParams } */
    this.params;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_StartNetLog_ParamsSpec.$,
    'NetworkService_StartNetLog_Params',
    [
      mojo.internal.StructField(
        'file', 0,
        0,
        mojoBase.mojom.FileSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxTotalSize', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'captureMode', 16,
        0,
        network.mojom.NetLogCaptureModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'constants', 24,
        0,
        mojoBase.mojom.DictionaryValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'duration', 32,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('network.mojom.NetworkService_StartNetLog_Params');

/** @record */
network.mojom.NetworkService_StartNetLog_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.File } */
    this.file;
    /** @export { !bigint } */
    this.maxTotalSize;
    /** @export { !network.mojom.NetLogCaptureMode } */
    this.captureMode;
    /** @export { !mojoBase.mojom.DictionaryValue } */
    this.constants;
    /** @export { (mojoBase.mojom.TimeDelta|undefined) } */
    this.duration;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_AttachNetLogProxy_ParamsSpec.$,
    'NetworkService_AttachNetLogProxy_Params',
    [
      mojo.internal.StructField(
        'proxySource', 0,
        0,
        mojo.internal.InterfaceProxy(network.mojom.NetLogProxySourceRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'proxySink', 8,
        0,
        mojo.internal.InterfaceRequest(network.mojom.NetLogProxySinkPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkService_AttachNetLogProxy_Params');

/** @record */
network.mojom.NetworkService_AttachNetLogProxy_Params = class {
  constructor() {
    /** @export { !network.mojom.NetLogProxySourceRemote } */
    this.proxySource;
    /** @export { !network.mojom.NetLogProxySinkPendingReceiver } */
    this.proxySink;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_SetSSLKeyLogFile_ParamsSpec.$,
    'NetworkService_SetSSLKeyLogFile_Params',
    [
      mojo.internal.StructField(
        'file', 0,
        0,
        mojoBase.mojom.FileSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_SetSSLKeyLogFile_Params');

/** @record */
network.mojom.NetworkService_SetSSLKeyLogFile_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.File } */
    this.file;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_CreateNetworkContext_ParamsSpec.$,
    'NetworkService_CreateNetworkContext_Params',
    [
      mojo.internal.StructField(
        'context', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.NetworkContextPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'params', 8,
        0,
        network.mojom.NetworkContextParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkService_CreateNetworkContext_Params');

/** @record */
network.mojom.NetworkService_CreateNetworkContext_Params = class {
  constructor() {
    /** @export { !network.mojom.NetworkContextPendingReceiver } */
    this.context;
    /** @export { !network.mojom.NetworkContextParams } */
    this.params;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_ConfigureStubHostResolver_ParamsSpec.$,
    'NetworkService_ConfigureStubHostResolver_Params',
    [
      mojo.internal.StructField(
        'insecureDnsClientEnabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'happyEyeballsV3Enabled', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'secureDnsMode', 4,
        0,
        network.mojom.SecureDnsModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dnsOverHttpsConfig', 8,
        0,
        network.mojom.DnsOverHttpsConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'additionalDnsTypesEnabled', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fallbackDohNameservers', 16,
        0,
        mojo.internal.Array(network.mojom.IPEndPointSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.NetworkService_ConfigureStubHostResolver_Params');

/** @record */
network.mojom.NetworkService_ConfigureStubHostResolver_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.insecureDnsClientEnabled;
    /** @export { !boolean } */
    this.happyEyeballsV3Enabled;
    /** @export { !network.mojom.SecureDnsMode } */
    this.secureDnsMode;
    /** @export { !network.mojom.DnsOverHttpsConfig } */
    this.dnsOverHttpsConfig;
    /** @export { !boolean } */
    this.additionalDnsTypesEnabled;
    /** @export { !Array<!network.mojom.IPEndPoint> } */
    this.fallbackDohNameservers;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_DisableQuic_ParamsSpec.$,
    'NetworkService_DisableQuic_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkService_DisableQuic_Params');

/** @record */
network.mojom.NetworkService_DisableQuic_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_SetUpHttpAuth_ParamsSpec.$,
    'NetworkService_SetUpHttpAuth_Params',
    [
      mojo.internal.StructField(
        'httpAuthStaticParams', 0,
        0,
        network.mojom.HttpAuthStaticParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_SetUpHttpAuth_Params');

/** @record */
network.mojom.NetworkService_SetUpHttpAuth_Params = class {
  constructor() {
    /** @export { !network.mojom.HttpAuthStaticParams } */
    this.httpAuthStaticParams;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_ConfigureHttpAuthPrefs_ParamsSpec.$,
    'NetworkService_ConfigureHttpAuthPrefs_Params',
    [
      mojo.internal.StructField(
        'httpAuthDynamicParams', 0,
        0,
        network.mojom.HttpAuthDynamicParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_ConfigureHttpAuthPrefs_Params');

/** @record */
network.mojom.NetworkService_ConfigureHttpAuthPrefs_Params = class {
  constructor() {
    /** @export { !network.mojom.HttpAuthDynamicParams } */
    this.httpAuthDynamicParams;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_SetRawHeadersAccess_ParamsSpec.$,
    'NetworkService_SetRawHeadersAccess_Params',
    [
      mojo.internal.StructField(
        'processId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'origins', 8,
        0,
        mojo.internal.Array(url.mojom.OriginSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkService_SetRawHeadersAccess_Params');

/** @record */
network.mojom.NetworkService_SetRawHeadersAccess_Params = class {
  constructor() {
    /** @export { !number } */
    this.processId;
    /** @export { !Array<!url.mojom.Origin> } */
    this.origins;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_SetMaxConnectionsPerProxyChain_ParamsSpec.$,
    'NetworkService_SetMaxConnectionsPerProxyChain_Params',
    [
      mojo.internal.StructField(
        'maxConnections', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_SetMaxConnectionsPerProxyChain_Params');

/** @record */
network.mojom.NetworkService_SetMaxConnectionsPerProxyChain_Params = class {
  constructor() {
    /** @export { !number } */
    this.maxConnections;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_GetNetworkChangeManager_ParamsSpec.$,
    'NetworkService_GetNetworkChangeManager_Params',
    [
      mojo.internal.StructField(
        'networkChangeManager', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.NetworkChangeManagerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_GetNetworkChangeManager_Params');

/** @record */
network.mojom.NetworkService_GetNetworkChangeManager_Params = class {
  constructor() {
    /** @export { !network.mojom.NetworkChangeManagerPendingReceiver } */
    this.networkChangeManager;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_GetNetworkQualityEstimatorManager_ParamsSpec.$,
    'NetworkService_GetNetworkQualityEstimatorManager_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.NetworkQualityEstimatorManagerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_GetNetworkQualityEstimatorManager_Params');

/** @record */
network.mojom.NetworkService_GetNetworkQualityEstimatorManager_Params = class {
  constructor() {
    /** @export { !network.mojom.NetworkQualityEstimatorManagerPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_GetDnsConfigChangeManager_ParamsSpec.$,
    'NetworkService_GetDnsConfigChangeManager_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.DnsConfigChangeManagerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_GetDnsConfigChangeManager_Params');

/** @record */
network.mojom.NetworkService_GetDnsConfigChangeManager_Params = class {
  constructor() {
    /** @export { !network.mojom.DnsConfigChangeManagerPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_GetNetworkList_ParamsSpec.$,
    'NetworkService_GetNetworkList_Params',
    [
      mojo.internal.StructField(
        'policy', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_GetNetworkList_Params');

/** @record */
network.mojom.NetworkService_GetNetworkList_Params = class {
  constructor() {
    /** @export { !number } */
    this.policy;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_GetNetworkList_ResponseParamsSpec.$,
    'NetworkService_GetNetworkList_ResponseParams',
    [
      mojo.internal.StructField(
        'networks', 0,
        0,
        mojo.internal.Array(network.mojom.NetworkInterfaceSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_GetNetworkList_ResponseParams');

/** @record */
network.mojom.NetworkService_GetNetworkList_ResponseParams = class {
  constructor() {
    /** @export { (Array<!network.mojom.NetworkInterface>|undefined) } */
    this.networks;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_OnTrustStoreChanged_ParamsSpec.$,
    'NetworkService_OnTrustStoreChanged_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkService_OnTrustStoreChanged_Params');

/** @record */
network.mojom.NetworkService_OnTrustStoreChanged_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_OnClientCertStoreChanged_ParamsSpec.$,
    'NetworkService_OnClientCertStoreChanged_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkService_OnClientCertStoreChanged_Params');

/** @record */
network.mojom.NetworkService_OnClientCertStoreChanged_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_SetEncryptionKey_ParamsSpec.$,
    'NetworkService_SetEncryptionKey_Params',
    [
      mojo.internal.StructField(
        'encryptionKey', 0,
        0,
        mojoBase.mojom.ByteStringSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_SetEncryptionKey_Params');

/** @record */
network.mojom.NetworkService_SetEncryptionKey_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.ByteString } */
    this.encryptionKey;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_OnMemoryPressure_ParamsSpec.$,
    'NetworkService_OnMemoryPressure_Params',
    [
      mojo.internal.StructField(
        'memoryPressureLevel', 0,
        0,
        mojoBase.mojom.MemoryPressureLevelSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_OnMemoryPressure_Params');

/** @record */
network.mojom.NetworkService_OnMemoryPressure_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.MemoryPressureLevel } */
    this.memoryPressureLevel;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_OnPeerToPeerConnectionsCountChange_ParamsSpec.$,
    'NetworkService_OnPeerToPeerConnectionsCountChange_Params',
    [
      mojo.internal.StructField(
        'count', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_OnPeerToPeerConnectionsCountChange_Params');

/** @record */
network.mojom.NetworkService_OnPeerToPeerConnectionsCountChange_Params = class {
  constructor() {
    /** @export { !number } */
    this.count;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_SetTrustTokenKeyCommitments_ParamsSpec.$,
    'NetworkService_SetTrustTokenKeyCommitments_Params',
    [
      mojo.internal.StructField(
        'rawCommitments', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_SetTrustTokenKeyCommitments_Params');

/** @record */
network.mojom.NetworkService_SetTrustTokenKeyCommitments_Params = class {
  constructor() {
    /** @export { !string } */
    this.rawCommitments;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_SetTrustTokenKeyCommitments_ResponseParamsSpec.$,
    'NetworkService_SetTrustTokenKeyCommitments_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkService_SetTrustTokenKeyCommitments_ResponseParams');

/** @record */
network.mojom.NetworkService_SetTrustTokenKeyCommitments_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_ClearSCTAuditingCache_ParamsSpec.$,
    'NetworkService_ClearSCTAuditingCache_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkService_ClearSCTAuditingCache_Params');

/** @record */
network.mojom.NetworkService_ClearSCTAuditingCache_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_ConfigureSCTAuditing_ParamsSpec.$,
    'NetworkService_ConfigureSCTAuditing_Params',
    [
      mojo.internal.StructField(
        'configuration', 0,
        0,
        network.mojom.SCTAuditingConfigurationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_ConfigureSCTAuditing_Params');

/** @record */
network.mojom.NetworkService_ConfigureSCTAuditing_Params = class {
  constructor() {
    /** @export { !network.mojom.SCTAuditingConfiguration } */
    this.configuration;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_UpdateCtLogList_ParamsSpec.$,
    'NetworkService_UpdateCtLogList_Params',
    [
      mojo.internal.StructField(
        'logList', 0,
        0,
        mojo.internal.Array(network.mojom.CTLogInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_UpdateCtLogList_Params');

/** @record */
network.mojom.NetworkService_UpdateCtLogList_Params = class {
  constructor() {
    /** @export { !Array<!network.mojom.CTLogInfo> } */
    this.logList;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_UpdateCtLogList_ResponseParamsSpec.$,
    'NetworkService_UpdateCtLogList_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkService_UpdateCtLogList_ResponseParams');

/** @record */
network.mojom.NetworkService_UpdateCtLogList_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_UpdateCtKnownPopularSCTs_ParamsSpec.$,
    'NetworkService_UpdateCtKnownPopularSCTs_Params',
    [
      mojo.internal.StructField(
        'sctHashes', 0,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_UpdateCtKnownPopularSCTs_Params');

/** @record */
network.mojom.NetworkService_UpdateCtKnownPopularSCTs_Params = class {
  constructor() {
    /** @export { !Array<!Array<!number>> } */
    this.sctHashes;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_UpdateCtKnownPopularSCTs_ResponseParamsSpec.$,
    'NetworkService_UpdateCtKnownPopularSCTs_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkService_UpdateCtKnownPopularSCTs_ResponseParams');

/** @record */
network.mojom.NetworkService_UpdateCtKnownPopularSCTs_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_SetCtEnforcementEnabled_ParamsSpec.$,
    'NetworkService_SetCtEnforcementEnabled_Params',
    [
      mojo.internal.StructField(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_SetCtEnforcementEnabled_Params');

/** @record */
network.mojom.NetworkService_SetCtEnforcementEnabled_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.enabled;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_SetCtEnforcementEnabled_ResponseParamsSpec.$,
    'NetworkService_SetCtEnforcementEnabled_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkService_SetCtEnforcementEnabled_ResponseParams');

/** @record */
network.mojom.NetworkService_SetCtEnforcementEnabled_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_UpdateKeyPinsList_ParamsSpec.$,
    'NetworkService_UpdateKeyPinsList_Params',
    [
      mojo.internal.StructField(
        'pinList', 0,
        0,
        network.mojom.PinListSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'updateTime', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkService_UpdateKeyPinsList_Params');

/** @record */
network.mojom.NetworkService_UpdateKeyPinsList_Params = class {
  constructor() {
    /** @export { !network.mojom.PinList } */
    this.pinList;
    /** @export { !mojoBase.mojom.Time } */
    this.updateTime;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_BindTestInterfaceForTesting_ParamsSpec.$,
    'NetworkService_BindTestInterfaceForTesting_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.NetworkServiceTestPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_BindTestInterfaceForTesting_Params');

/** @record */
network.mojom.NetworkService_BindTestInterfaceForTesting_Params = class {
  constructor() {
    /** @export { !network.mojom.NetworkServiceTestPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_SetFirstPartySets_ParamsSpec.$,
    'NetworkService_SetFirstPartySets_Params',
    [
      mojo.internal.StructField(
        'sets', 0,
        0,
        network.mojom.GlobalFirstPartySetsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_SetFirstPartySets_Params');

/** @record */
network.mojom.NetworkService_SetFirstPartySets_Params = class {
  constructor() {
    /** @export { !network.mojom.GlobalFirstPartySets } */
    this.sets;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_SetExplicitlyAllowedPorts_ParamsSpec.$,
    'NetworkService_SetExplicitlyAllowedPorts_Params',
    [
      mojo.internal.StructField(
        'ports', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint16, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_SetExplicitlyAllowedPorts_Params');

/** @record */
network.mojom.NetworkService_SetExplicitlyAllowedPorts_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.ports;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_ParseHeaders_ParamsSpec.$,
    'NetworkService_ParseHeaders_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headers', 8,
        0,
        network.mojom.HttpResponseHeadersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkService_ParseHeaders_Params');

/** @record */
network.mojom.NetworkService_ParseHeaders_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.HttpResponseHeaders } */
    this.headers;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_ParseHeaders_ResponseParamsSpec.$,
    'NetworkService_ParseHeaders_ResponseParams',
    [
      mojo.internal.StructField(
        'parsedHeaders', 0,
        0,
        network.mojom.ParsedHeadersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_ParseHeaders_ResponseParams');

/** @record */
network.mojom.NetworkService_ParseHeaders_ResponseParams = class {
  constructor() {
    /** @export { !network.mojom.ParsedHeaders } */
    this.parsedHeaders;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_EnableDataUseUpdates_ParamsSpec.$,
    'NetworkService_EnableDataUseUpdates_Params',
    [
      mojo.internal.StructField(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_EnableDataUseUpdates_Params');

/** @record */
network.mojom.NetworkService_EnableDataUseUpdates_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.enable;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_SetIPv6ReachabilityOverride_ParamsSpec.$,
    'NetworkService_SetIPv6ReachabilityOverride_Params',
    [
      mojo.internal.StructField(
        'reachabilityOverride', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_SetIPv6ReachabilityOverride_Params');

/** @record */
network.mojom.NetworkService_SetIPv6ReachabilityOverride_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.reachabilityOverride;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_SetNetworkAnnotationMonitor_ParamsSpec.$,
    'NetworkService_SetNetworkAnnotationMonitor_Params',
    [
      mojo.internal.StructField(
        'remote', 0,
        0,
        mojo.internal.InterfaceProxy(network.mojom.NetworkAnnotationMonitorRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_SetNetworkAnnotationMonitor_Params');

/** @record */
network.mojom.NetworkService_SetNetworkAnnotationMonitor_Params = class {
  constructor() {
    /** @export { !network.mojom.NetworkAnnotationMonitorRemote } */
    this.remote;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_SetTpcdMetadataGrants_ParamsSpec.$,
    'NetworkService_SetTpcdMetadataGrants_Params',
    [
      mojo.internal.StructField(
        'settings', 0,
        0,
        mojo.internal.Array(contentSettings.mojom.ContentSettingPatternSourceSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_SetTpcdMetadataGrants_Params');

/** @record */
network.mojom.NetworkService_SetTpcdMetadataGrants_Params = class {
  constructor() {
    /** @export { !Array<!contentSettings.mojom.ContentSettingPatternSource> } */
    this.settings;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_InterceptUrlLoaderForBodyDecoding_ParamsSpec.$,
    'NetworkService_InterceptUrlLoaderForBodyDecoding_Params',
    [
      mojo.internal.StructField(
        'contentEncodingTypes', 0,
        0,
        mojo.internal.Array(network.mojom.SourceTypeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceBody', 8,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'destBody', 12,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceUrlLoader', 16,
        0,
        mojo.internal.InterfaceProxy(network.mojom.URLLoaderRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceUrlLoaderClient', 24,
        0,
        mojo.internal.InterfaceRequest(network.mojom.URLLoaderClientPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'destUrlLoader', 28,
        0,
        mojo.internal.InterfaceRequest(network.mojom.URLLoaderPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'destUrlLoaderClient', 32,
        0,
        mojo.internal.InterfaceProxy(network.mojom.URLLoaderClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('network.mojom.NetworkService_InterceptUrlLoaderForBodyDecoding_Params');

/** @record */
network.mojom.NetworkService_InterceptUrlLoaderForBodyDecoding_Params = class {
  constructor() {
    /** @export { !Array<!network.mojom.SourceType> } */
    this.contentEncodingTypes;
    /** @export { !MojoHandle } */
    this.sourceBody;
    /** @export { !MojoHandle } */
    this.destBody;
    /** @export { !network.mojom.URLLoaderRemote } */
    this.sourceUrlLoader;
    /** @export { !network.mojom.URLLoaderClientPendingReceiver } */
    this.sourceUrlLoaderClient;
    /** @export { !network.mojom.URLLoaderPendingReceiver } */
    this.destUrlLoader;
    /** @export { !network.mojom.URLLoaderClientRemote } */
    this.destUrlLoaderClient;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_DecodeContentEncoding_ParamsSpec.$,
    'NetworkService_DecodeContentEncoding_Params',
    [
      mojo.internal.StructField(
        'contentEncodingTypes', 0,
        0,
        mojo.internal.Array(network.mojom.SourceTypeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceBody', 8,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'destBody', 12,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkService_DecodeContentEncoding_Params');

/** @record */
network.mojom.NetworkService_DecodeContentEncoding_Params = class {
  constructor() {
    /** @export { !Array<!network.mojom.SourceType> } */
    this.contentEncodingTypes;
    /** @export { !MojoHandle } */
    this.sourceBody;
    /** @export { !MojoHandle } */
    this.destBody;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_DecodeContentEncoding_ResponseParamsSpec.$,
    'NetworkService_DecodeContentEncoding_ResponseParams',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_DecodeContentEncoding_ResponseParams');

/** @record */
network.mojom.NetworkService_DecodeContentEncoding_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.errorCode;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkService_SetTLS13EarlyDataEnabled_ParamsSpec.$,
    'NetworkService_SetTLS13EarlyDataEnabled_Params',
    [
      mojo.internal.StructField(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkService_SetTLS13EarlyDataEnabled_Params');

/** @record */
network.mojom.NetworkService_SetTLS13EarlyDataEnabled_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.enabled;
  }
};

