// services/network/public/mojom/network_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/network_service.mojom-shared-internal.h"
#include "components/content_settings/core/common/content_settings.mojom-shared.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/memory_pressure_level.mojom-shared.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "services/network/public/mojom/client_security_state.mojom-shared.h"
#include "services/network/public/mojom/first_party_sets.mojom-shared.h"
#include "services/network/public/mojom/host_resolver.mojom-shared.h"
#include "services/network/public/mojom/http_raw_headers.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/key_pinning.mojom-shared.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared.h"
#include "services/network/public/mojom/net_log.mojom-shared.h"
#include "services/network/public/mojom/network_annotation_monitor.mojom-shared.h"
#include "services/network/public/mojom/network_change_manager.mojom-shared.h"
#include "services/network/public/mojom/network_context.mojom-shared.h"
#include "services/network/public/mojom/network_interface.mojom-shared.h"
#include "services/network/public/mojom/network_interface_change_listener.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/network_quality_estimator_manager.mojom-shared.h"
#include "services/network/public/mojom/network_service_test.mojom-shared.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared.h"
#include "services/network/public/mojom/proxy_config.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "services/network/public/mojom/source_type.mojom-shared.h"
#include "services/network/public/mojom/system_dns_resolution.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "services/network/public/mojom/url_loader_network_service_observer.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/ct_log_info.mojom-shared.h"


namespace network::mojom {
class HttpAuthStaticParamsDataView;

class HttpAuthDynamicParamsDataView;

class EnvironmentVariableDataView;

class NetworkServiceParamsDataView;

class SCTAuditingConfigurationDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::HttpAuthStaticParamsDataView> {
  using Data = ::network::mojom::internal::HttpAuthStaticParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::HttpAuthDynamicParamsDataView> {
  using Data = ::network::mojom::internal::HttpAuthDynamicParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::EnvironmentVariableDataView> {
  using Data = ::network::mojom::internal::EnvironmentVariable_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::NetworkServiceParamsDataView> {
  using Data = ::network::mojom::internal::NetworkServiceParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SCTAuditingConfigurationDataView> {
  using Data = ::network::mojom::internal::SCTAuditingConfiguration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {
// Interface base classes. They are used for type safety check.
class NetworkServiceInterfaceBase {};

using NetworkServicePtrDataView =
    mojo::InterfacePtrDataView<NetworkServiceInterfaceBase>;
using NetworkServiceRequestDataView =
    mojo::InterfaceRequestDataView<NetworkServiceInterfaceBase>;
using NetworkServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NetworkServiceInterfaceBase>;
using NetworkServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NetworkServiceInterfaceBase>;


class HttpAuthStaticParamsDataView {
 public:
  HttpAuthStaticParamsDataView() = default;

  HttpAuthStaticParamsDataView(
      internal::HttpAuthStaticParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGssapiLibraryNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGssapiLibraryName(UserType* output) {
    
    auto* pointer = data_->gssapi_library_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::HttpAuthStaticParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HttpAuthDynamicParamsDataView {
 public:
  HttpAuthDynamicParamsDataView() = default;

  HttpAuthDynamicParamsDataView(
      internal::HttpAuthDynamicParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAllowedSchemesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllowedSchemes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `allowed_schemes` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAllowedSchemes` instead "
    "of `ReadAllowedSchemes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->allowed_schemes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetPatternsAllowedToUseAllSchemesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPatternsAllowedToUseAllSchemes(UserType* output) {
    
    auto* pointer = data_->patterns_allowed_to_use_all_schemes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetServerAllowlistDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServerAllowlist(UserType* output) {
    
    auto* pointer = data_->server_allowlist.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDelegateAllowlistDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDelegateAllowlist(UserType* output) {
    
    auto* pointer = data_->delegate_allowlist.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool delegate_by_kdc_policy() const {
    return data_->delegate_by_kdc_policy;
  }
  bool negotiate_disable_cname_lookup() const {
    return data_->negotiate_disable_cname_lookup;
  }
  bool enable_negotiate_port() const {
    return data_->enable_negotiate_port;
  }
  bool ntlm_v2_enabled() const {
    return data_->ntlm_v2_enabled;
  }
  inline void GetAndroidNegotiateAccountTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAndroidNegotiateAccountType(UserType* output) {
    
    auto* pointer = data_->android_negotiate_account_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool allow_gssapi_library_load() const {
    return data_->allow_gssapi_library_load;
  }
  bool basic_over_http_enabled() const {
    return data_->basic_over_http_enabled;
  }
 private:
  internal::HttpAuthDynamicParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EnvironmentVariableDataView {
 public:
  EnvironmentVariableDataView() = default;

  EnvironmentVariableDataView(
      internal::EnvironmentVariable_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::EnvironmentVariable_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkServiceParamsDataView {
 public:
  NetworkServiceParamsDataView() = default;

  NetworkServiceParamsDataView(
      internal::NetworkServiceParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadInitialConnectionType(UserType* output) const {
    auto data_value = data_->initial_connection_type;
    return mojo::internal::Deserialize<::network::mojom::ConnectionType>(
        data_value, output);
  }
  ::network::mojom::ConnectionType initial_connection_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ConnectionType>(data_->initial_connection_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInitialConnectionSubtype(UserType* output) const {
    auto data_value = data_->initial_connection_subtype;
    return mojo::internal::Deserialize<::network::mojom::ConnectionSubtype>(
        data_value, output);
  }
  ::network::mojom::ConnectionSubtype initial_connection_subtype() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ConnectionSubtype>(data_->initial_connection_subtype));
  }
  inline void GetEnvironmentDataView(
      mojo::ArrayDataView<EnvironmentVariableDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnvironment(UserType* output) {
    
    auto* pointer = data_->environment.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::EnvironmentVariableDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeDefaultObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderNetworkServiceObserverInterfaceBase>>(
            &data_->default_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool first_party_sets_enabled() const {
    return data_->first_party_sets_enabled;
  }
  template <typename UserType>
  UserType TakeSystemDnsResolver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::SystemDnsResolverInterfaceBase>>(
            &data_->system_dns_resolver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::NetworkServiceParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SCTAuditingConfigurationDataView {
 public:
  SCTAuditingConfigurationDataView() = default;

  SCTAuditingConfigurationDataView(
      internal::SCTAuditingConfiguration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  double sampling_rate() const {
    return data_->sampling_rate;
  }
  inline void GetLogExpectedIngestionDelayDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLogExpectedIngestionDelay(UserType* output) {
    
    auto* pointer = data_->log_expected_ingestion_delay.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetLogMaxIngestionRandomDelayDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLogMaxIngestionRandomDelay(UserType* output) {
    
    auto* pointer = data_->log_max_ingestion_random_delay.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetReportUriDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportUri(UserType* output) {
    
    auto* pointer = data_->report_uri.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetHashdanceLookupUriDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHashdanceLookupUri(UserType* output) {
    
    auto* pointer = data_->hashdance_lookup_uri.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTrafficAnnotationDataView(
      ::network::mojom::MutableNetworkTrafficAnnotationTagDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrafficAnnotation(UserType* output) {
    
    auto* pointer = data_->traffic_annotation.Get();
    return mojo::internal::Deserialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
        pointer, output, message_);
  }
  inline void GetHashdanceTrafficAnnotationDataView(
      ::network::mojom::MutableNetworkTrafficAnnotationTagDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHashdanceTrafficAnnotation(UserType* output) {
    
    auto* pointer = data_->hashdance_traffic_annotation.Get();
    return mojo::internal::Deserialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
        pointer, output, message_);
  }
 private:
  internal::SCTAuditingConfiguration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_DATA_VIEW_H_