// services/network/public/mojom/network_service.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_BLINK_TEST_UTILS_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_BLINK_TEST_UTILS_H_

#include "services/network/public/mojom/network_service.mojom-blink.h"
#include "third_party/blink/public/platform/web_common.h"


namespace network::mojom::blink {


class BLINK_PLATFORM_EXPORT NetworkServiceInterceptorForTesting : public NetworkService {
  virtual NetworkService* GetForwardingInterface() = 0;
  void SetParams(NetworkServiceParamsPtr params) override;
  void StartNetLog(::base::File file, uint64_t max_total_size, ::network::mojom::blink::NetLogCaptureMode capture_mode, ::base::Value::Dict constants, std::optional<::base::TimeDelta> duration) override;
  void AttachNetLogProxy(::mojo::PendingRemote<::network::mojom::blink::NetLogProxySource> proxy_source, ::mojo::PendingReceiver<::network::mojom::blink::NetLogProxySink> proxy_sink) override;
  void SetSSLKeyLogFile(::base::File file) override;
  void CreateNetworkContext(::mojo::PendingReceiver<::network::mojom::blink::NetworkContext> context, ::network::mojom::blink::NetworkContextParamsPtr params) override;
  void ConfigureStubHostResolver(bool insecure_dns_client_enabled, bool happy_eyeballs_v3_enabled, ::network::mojom::blink::SecureDnsMode secure_dns_mode, ::network::mojom::blink::DnsOverHttpsConfigPtr dns_over_https_config, bool additional_dns_types_enabled, const ::blink::Vector<::net::IPEndPoint>& fallback_doh_nameservers) override;
  void DisableQuic() override;
  void SetUpHttpAuth(HttpAuthStaticParamsPtr http_auth_static_params) override;
  void ConfigureHttpAuthPrefs(HttpAuthDynamicParamsPtr http_auth_dynamic_params) override;
  void SetRawHeadersAccess(int32_t process_id, const ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>& origins) override;
  void SetMaxConnectionsPerProxyChain(uint32_t max_connections) override;
  void GetNetworkChangeManager(::mojo::PendingReceiver<::network::mojom::blink::NetworkChangeManager> network_change_manager) override;
  void GetNetworkQualityEstimatorManager(::mojo::PendingReceiver<::network::mojom::blink::NetworkQualityEstimatorManager> receiver) override;
  void GetDnsConfigChangeManager(::mojo::PendingReceiver<::network::mojom::blink::DnsConfigChangeManager> receiver) override;
  void GetNetworkList(uint32_t policy, GetNetworkListCallback callback) override;
  void OnTrustStoreChanged() override;
  void OnClientCertStoreChanged() override;
  void SetEncryptionKey(const std::string& encryption_key) override;
  void OnMemoryPressure(::mojo_base::mojom::blink::MemoryPressureLevel memory_pressure_level) override;
  void OnPeerToPeerConnectionsCountChange(uint32_t count) override;
  void SetTrustTokenKeyCommitments(const ::blink::String& raw_commitments, SetTrustTokenKeyCommitmentsCallback callback) override;
  void ClearSCTAuditingCache() override;
  void ConfigureSCTAuditing(SCTAuditingConfigurationPtr configuration) override;
  void UpdateCtLogList(::blink::Vector<::network::mojom::blink::CTLogInfoPtr> log_list, UpdateCtLogListCallback callback) override;
  void UpdateCtKnownPopularSCTs(const ::blink::Vector<::blink::Vector<uint8_t>>& sct_hashes, UpdateCtKnownPopularSCTsCallback callback) override;
  void SetCtEnforcementEnabled(bool enabled, SetCtEnforcementEnabledCallback callback) override;
  void UpdateKeyPinsList(::network::mojom::blink::PinListPtr pin_list, ::base::Time update_time) override;
  void BindTestInterfaceForTesting(::mojo::PendingReceiver<::network::mojom::blink::NetworkServiceTest> receiver) override;
  void SetFirstPartySets(::network::mojom::blink::GlobalFirstPartySetsPtr sets) override;
  void SetExplicitlyAllowedPorts(const ::blink::Vector<uint16_t>& ports) override;
  void ParseHeaders(const ::blink::KURL& url, ::network::mojom::blink::HttpResponseHeadersPtr headers, ParseHeadersCallback callback) override;
  void EnableDataUseUpdates(bool enable) override;
  void SetIPv6ReachabilityOverride(bool reachability_override) override;
  void SetNetworkAnnotationMonitor(::mojo::PendingRemote<::network::mojom::blink::NetworkAnnotationMonitor> remote) override;
  void SetTpcdMetadataGrants(::blink::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> settings) override;
  void InterceptUrlLoaderForBodyDecoding(const ::blink::Vector<::net::SourceStreamType>& content_encoding_types, ::mojo::ScopedDataPipeConsumerHandle source_body, ::mojo::ScopedDataPipeProducerHandle dest_body, ::mojo::PendingRemote<::network::mojom::blink::URLLoader> source_url_loader, ::mojo::PendingReceiver<::network::mojom::blink::URLLoaderClient> source_url_loader_client, ::mojo::PendingReceiver<::network::mojom::blink::URLLoader> dest_url_loader, ::mojo::PendingRemote<::network::mojom::blink::URLLoaderClient> dest_url_loader_client) override;
  void DecodeContentEncoding(const ::blink::Vector<::net::SourceStreamType>& content_encoding_types, ::mojo::ScopedDataPipeConsumerHandle source_body, ::mojo::ScopedDataPipeProducerHandle dest_body, DecodeContentEncodingCallback callback) override;
  void SetTLS13EarlyDataEnabled(bool enabled) override;
};
class BLINK_PLATFORM_EXPORT NetworkServiceAsyncWaiter {
 public:
  explicit NetworkServiceAsyncWaiter(NetworkService* proxy);

  NetworkServiceAsyncWaiter(const NetworkServiceAsyncWaiter&) = delete;
  NetworkServiceAsyncWaiter& operator=(const NetworkServiceAsyncWaiter&) = delete;

  ~NetworkServiceAsyncWaiter();
  void GetNetworkList(
      uint32_t policy, std::optional<::blink::Vector<::net::NetworkInterface>>* out_networks);
  std::optional<::blink::Vector<::net::NetworkInterface>> GetNetworkList(uint32_t policy);
  void SetTrustTokenKeyCommitments(
      const ::blink::String& raw_commitments);
  
  void UpdateCtLogList(
      ::blink::Vector<::network::mojom::blink::CTLogInfoPtr> log_list);
  
  void UpdateCtKnownPopularSCTs(
      const ::blink::Vector<::blink::Vector<uint8_t>>& sct_hashes);
  
  void SetCtEnforcementEnabled(
      bool enabled);
  
  void ParseHeaders(
      const ::blink::KURL& url, ::network::mojom::blink::HttpResponseHeadersPtr headers, ::network::mojom::blink::ParsedHeadersPtr* out_parsed_headers);
  ::network::mojom::blink::ParsedHeadersPtr ParseHeaders(const ::blink::KURL& url, ::network::mojom::blink::HttpResponseHeadersPtr headers);
  void DecodeContentEncoding(
      const ::blink::Vector<::net::SourceStreamType>& content_encoding_types, ::mojo::ScopedDataPipeConsumerHandle source_body, ::mojo::ScopedDataPipeProducerHandle dest_body, int32_t* out_error_code);
  int32_t DecodeContentEncoding(const ::blink::Vector<::net::SourceStreamType>& content_encoding_types, ::mojo::ScopedDataPipeConsumerHandle source_body, ::mojo::ScopedDataPipeProducerHandle dest_body);

 private:
  NetworkService* const proxy_;
};




}  // network::mojom::blink

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_BLINK_TEST_UTILS_H_