// services/network/public/mojom/network_isolation_key.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ISOLATION_KEY_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ISOLATION_KEY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/network_isolation_key.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/network_isolation_partition.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"


namespace network::mojom {
class EmptyNetworkIsolationKeyDataView;

class NonEmptyNetworkIsolationKeyDataView;

class NetworkIsolationKeyDataView;


}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::EmptyNetworkIsolationKeyDataView> {
  using Data = ::network::mojom::internal::EmptyNetworkIsolationKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::NonEmptyNetworkIsolationKeyDataView> {
  using Data = ::network::mojom::internal::NonEmptyNetworkIsolationKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::NetworkIsolationKeyDataView> {
  using Data = ::network::mojom::internal::NetworkIsolationKey_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class EmptyNetworkIsolationKeyDataView {
 public:
  EmptyNetworkIsolationKeyDataView() = default;

  EmptyNetworkIsolationKeyDataView(
      internal::EmptyNetworkIsolationKey_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::EmptyNetworkIsolationKey_Data* data_ = nullptr;
};


class NonEmptyNetworkIsolationKeyDataView {
 public:
  NonEmptyNetworkIsolationKeyDataView() = default;

  NonEmptyNetworkIsolationKeyDataView(
      internal::NonEmptyNetworkIsolationKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTopFrameSiteDataView(
      ::network::mojom::SchemefulSiteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopFrameSite(UserType* output) {
    
    auto* pointer = data_->top_frame_site.Get();
    return mojo::internal::Deserialize<::network::mojom::SchemefulSiteDataView>(
        pointer, output, message_);
  }
  inline void GetFrameSiteDataView(
      ::network::mojom::SchemefulSiteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameSite(UserType* output) {
    
    auto* pointer = data_->frame_site.Get();
    return mojo::internal::Deserialize<::network::mojom::SchemefulSiteDataView>(
        pointer, output, message_);
  }
  inline void GetNonceDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNonce(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `nonce` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNonce` instead "
    "of `ReadNonce if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->nonce.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNetworkIsolationPartition(UserType* output) const {
    auto data_value = data_->network_isolation_partition;
    return mojo::internal::Deserialize<::network::mojom::NetworkIsolationPartition>(
        data_value, output);
  }
  ::network::mojom::NetworkIsolationPartition network_isolation_partition() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::NetworkIsolationPartition>(data_->network_isolation_partition));
  }
 private:
  internal::NonEmptyNetworkIsolationKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkIsolationKeyDataView {
 public:
  using Tag = internal::NetworkIsolationKey_Data::NetworkIsolationKey_Tag;

  NetworkIsolationKeyDataView() = default;

  NetworkIsolationKeyDataView(
      internal::NetworkIsolationKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_empty() const { return data_->tag == Tag::kEmpty; }
  inline void GetEmptyDataView(
      EmptyNetworkIsolationKeyDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadEmpty(UserType* output) const {
    
    CHECK(is_empty());
    return mojo::internal::Deserialize<::network::mojom::EmptyNetworkIsolationKeyDataView>(
        data_->data.f_empty.Get(), output, message_);
  }
  bool is_non_empty() const { return data_->tag == Tag::kNonEmpty; }
  inline void GetNonEmptyDataView(
      NonEmptyNetworkIsolationKeyDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNonEmpty(UserType* output) const {
    
    CHECK(is_non_empty());
    return mojo::internal::Deserialize<::network::mojom::NonEmptyNetworkIsolationKeyDataView>(
        data_->data.f_non_empty.Get(), output, message_);
  }

 private:
  internal::NetworkIsolationKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ISOLATION_KEY_MOJOM_DATA_VIEW_H_