// services/network/public/mojom/network_interface.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_INTERFACE_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_INTERFACE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/network_interface.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/network_interface.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/network_interface.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/ip_address.mojom.h"
#include "services/network/public/mojom/network_change_manager.mojom-forward.h"
#include <string>
#include <vector>




#include "services/network/public/cpp/network_interface_mojom_traits.h"




namespace network::mojom {








class  NetworkInterface {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NetworkInterface, T>::value>;
  using DataView = NetworkInterfaceDataView;
  using Data_ = internal::NetworkInterface_Data;

  template <typename... Args>
  static NetworkInterfacePtr New(Args&&... args) {
    return NetworkInterfacePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NetworkInterfacePtr From(const U& u) {
    return mojo::TypeConverter<NetworkInterfacePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NetworkInterface>::Convert(*this);
  }


  NetworkInterface();

  NetworkInterface(
      const std::string& name,
      const std::string& friendly_name,
      uint32_t interface_index,
      ::network::mojom::ConnectionType type,
      const ::net::IPAddress& address,
      uint32_t prefix_length,
      int32_t ip_address_attributes,
      std::optional<std::vector<uint8_t>> mac_address);


  ~NetworkInterface();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NetworkInterfacePtr>
  NetworkInterfacePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NetworkInterface::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NetworkInterface::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NetworkInterface::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NetworkInterface::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NetworkInterface::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NetworkInterface::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NetworkInterface_UnserializedMessageContext<
            UserType, NetworkInterface::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NetworkInterface::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NetworkInterface::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NetworkInterface_UnserializedMessageContext<
            UserType, NetworkInterface::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NetworkInterface::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  std::string friendly_name;
  
  uint32_t interface_index;
  
  ::network::mojom::ConnectionType type;
  
  ::net::IPAddress address;
  
  uint32_t prefix_length;
  
  int32_t ip_address_attributes;
  
  std::optional<std::vector<uint8_t>> mac_address;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NetworkInterface::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NetworkInterface::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NetworkInterface::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NetworkInterface::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
NetworkInterfacePtr NetworkInterface::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(friendly_name),
      mojo::Clone(interface_index),
      mojo::Clone(type),
      mojo::Clone(address),
      mojo::Clone(prefix_length),
      mojo::Clone(ip_address_attributes),
      mojo::Clone(mac_address)
  );
}

template <typename T, NetworkInterface::EnableIfSame<T>*>
bool NetworkInterface::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->friendly_name, other_struct.friendly_name))
    return false;
  if (!mojo::Equals(this->interface_index, other_struct.interface_index))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->address, other_struct.address))
    return false;
  if (!mojo::Equals(this->prefix_length, other_struct.prefix_length))
    return false;
  if (!mojo::Equals(this->ip_address_attributes, other_struct.ip_address_attributes))
    return false;
  if (!mojo::Equals(this->mac_address, other_struct.mac_address))
    return false;
  return true;
}

template <typename T, NetworkInterface::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.friendly_name < rhs.friendly_name)
    return true;
  if (rhs.friendly_name < lhs.friendly_name)
    return false;
  if (lhs.interface_index < rhs.interface_index)
    return true;
  if (rhs.interface_index < lhs.interface_index)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.address < rhs.address)
    return true;
  if (rhs.address < lhs.address)
    return false;
  if (lhs.prefix_length < rhs.prefix_length)
    return true;
  if (rhs.prefix_length < lhs.prefix_length)
    return false;
  if (lhs.ip_address_attributes < rhs.ip_address_attributes)
    return true;
  if (rhs.ip_address_attributes < lhs.ip_address_attributes)
    return false;
  if (lhs.mac_address < rhs.mac_address)
    return true;
  if (rhs.mac_address < lhs.mac_address)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::NetworkInterface::DataView,
                                         ::network::mojom::NetworkInterfacePtr> {
  static bool IsNull(const ::network::mojom::NetworkInterfacePtr& input) { return !input; }
  static void SetToNull(::network::mojom::NetworkInterfacePtr* output) { output->reset(); }

  static const decltype(::network::mojom::NetworkInterface::name)& name(
      const ::network::mojom::NetworkInterfacePtr& input) {
    return input->name;
  }

  static const decltype(::network::mojom::NetworkInterface::friendly_name)& friendly_name(
      const ::network::mojom::NetworkInterfacePtr& input) {
    return input->friendly_name;
  }

  static decltype(::network::mojom::NetworkInterface::interface_index) interface_index(
      const ::network::mojom::NetworkInterfacePtr& input) {
    return input->interface_index;
  }

  static decltype(::network::mojom::NetworkInterface::type) type(
      const ::network::mojom::NetworkInterfacePtr& input) {
    return input->type;
  }

  static const decltype(::network::mojom::NetworkInterface::address)& address(
      const ::network::mojom::NetworkInterfacePtr& input) {
    return input->address;
  }

  static decltype(::network::mojom::NetworkInterface::prefix_length) prefix_length(
      const ::network::mojom::NetworkInterfacePtr& input) {
    return input->prefix_length;
  }

  static decltype(::network::mojom::NetworkInterface::ip_address_attributes) ip_address_attributes(
      const ::network::mojom::NetworkInterfacePtr& input) {
    return input->ip_address_attributes;
  }

  static const decltype(::network::mojom::NetworkInterface::mac_address)& mac_address(
      const ::network::mojom::NetworkInterfacePtr& input) {
    return input->mac_address;
  }

  static bool Read(::network::mojom::NetworkInterface::DataView input, ::network::mojom::NetworkInterfacePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_INTERFACE_MOJOM_H_