// services/network/public/mojom/network_interface.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_INTERFACE_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_INTERFACE_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/network_interface.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/network_change_manager.mojom-shared.h"

#include "services/network/public/mojom/network_interface.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::NetworkInterfaceDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::NetworkInterfaceDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::NetworkInterface_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in NetworkInterface struct");

      decltype(Traits::friendly_name(input)) in_friendly_name = Traits::friendly_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->friendly_name)::BaseType> friendly_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_friendly_name,
        friendly_name_fragment);

      fragment->friendly_name.Set(
          friendly_name_fragment.is_null() ? nullptr : friendly_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->friendly_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null friendly_name in NetworkInterface struct");

      fragment->interface_index = Traits::interface_index(input);

      
      mojo::internal::Serialize<::network::mojom::ConnectionType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::address(input)) in_address = Traits::address(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->address)::BaseType> address_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::IPAddressDataView, send_validation>(
        in_address,
        address_fragment);

      fragment->address.Set(
          address_fragment.is_null() ? nullptr : address_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->address.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null address in NetworkInterface struct");

      fragment->prefix_length = Traits::prefix_length(input);

      fragment->ip_address_attributes = Traits::ip_address_attributes(input);

      decltype(Traits::mac_address(input)) in_mac_address = Traits::mac_address(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mac_address)::BaseType>
          mac_address_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& mac_address_validate_params =
          mojo::internal::GetArrayValidator<6, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_mac_address,
        mac_address_fragment,
        &mac_address_validate_params);

      fragment->mac_address.Set(
          mac_address_fragment.is_null() ? nullptr : mac_address_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_INTERFACE_MOJOM_SEND_VALIDATION_H_