// services/network/public/mojom/network_context_client.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/network_context_client.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var file$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file.mojom', '../../../../mojo/public/mojom/base/file.mojom.js');
  }
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../../mojo/public/mojom/base/file_path.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../url/mojom/origin.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }



  function NetworkContextClient_OnFileUploadRequested_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContextClient_OnFileUploadRequested_Params.prototype.initDefaults_ = function() {
    this.processId = 0;
    this.async = false;
    this.filePaths = null;
    this.destinationUrl = null;
  };
  NetworkContextClient_OnFileUploadRequested_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContextClient_OnFileUploadRequested_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate NetworkContextClient_OnFileUploadRequested_Params.filePaths
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(file_path$.FilePath), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextClient_OnFileUploadRequested_Params.destinationUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContextClient_OnFileUploadRequested_Params.encodedSize = codec.kStructHeaderSize + 24;

  NetworkContextClient_OnFileUploadRequested_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContextClient_OnFileUploadRequested_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.processId =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.async = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.filePaths =
        decoder.decodeArrayPointer(new codec.PointerTo(file_path$.FilePath));
    val.destinationUrl =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  NetworkContextClient_OnFileUploadRequested_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContextClient_OnFileUploadRequested_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.processId);
    packed = 0;
    packed |= (val.async & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(file_path$.FilePath), val.filePaths);
    encoder.encodeStructPointer(url$.Url, val.destinationUrl);
  };
  function NetworkContextClient_OnFileUploadRequested_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContextClient_OnFileUploadRequested_ResponseParams.prototype.initDefaults_ = function() {
    this.netError = 0;
    this.files = null;
  };
  NetworkContextClient_OnFileUploadRequested_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContextClient_OnFileUploadRequested_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkContextClient_OnFileUploadRequested_ResponseParams.files
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(file$.ReadOnlyFile), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContextClient_OnFileUploadRequested_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContextClient_OnFileUploadRequested_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContextClient_OnFileUploadRequested_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.netError =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.files =
        decoder.decodeArrayPointer(new codec.PointerTo(file$.ReadOnlyFile));
    return val;
  };

  NetworkContextClient_OnFileUploadRequested_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContextClient_OnFileUploadRequested_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.netError);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(file$.ReadOnlyFile), val.files);
  };
  function NetworkContextClient_OnCanSendReportingReports_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContextClient_OnCanSendReportingReports_Params.prototype.initDefaults_ = function() {
    this.origins = null;
  };
  NetworkContextClient_OnCanSendReportingReports_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContextClient_OnCanSendReportingReports_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextClient_OnCanSendReportingReports_Params.origins
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(origin$.Origin), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContextClient_OnCanSendReportingReports_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContextClient_OnCanSendReportingReports_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContextClient_OnCanSendReportingReports_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.origins =
        decoder.decodeArrayPointer(new codec.PointerTo(origin$.Origin));
    return val;
  };

  NetworkContextClient_OnCanSendReportingReports_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContextClient_OnCanSendReportingReports_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(origin$.Origin), val.origins);
  };
  function NetworkContextClient_OnCanSendReportingReports_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContextClient_OnCanSendReportingReports_ResponseParams.prototype.initDefaults_ = function() {
    this.origins = null;
  };
  NetworkContextClient_OnCanSendReportingReports_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContextClient_OnCanSendReportingReports_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextClient_OnCanSendReportingReports_ResponseParams.origins
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(origin$.Origin), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContextClient_OnCanSendReportingReports_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContextClient_OnCanSendReportingReports_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContextClient_OnCanSendReportingReports_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.origins =
        decoder.decodeArrayPointer(new codec.PointerTo(origin$.Origin));
    return val;
  };

  NetworkContextClient_OnCanSendReportingReports_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContextClient_OnCanSendReportingReports_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(origin$.Origin), val.origins);
  };
  function NetworkContextClient_OnCanSendDomainReliabilityUpload_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContextClient_OnCanSendDomainReliabilityUpload_Params.prototype.initDefaults_ = function() {
    this.origin = null;
  };
  NetworkContextClient_OnCanSendDomainReliabilityUpload_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContextClient_OnCanSendDomainReliabilityUpload_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextClient_OnCanSendDomainReliabilityUpload_Params.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContextClient_OnCanSendDomainReliabilityUpload_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContextClient_OnCanSendDomainReliabilityUpload_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContextClient_OnCanSendDomainReliabilityUpload_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    return val;
  };

  NetworkContextClient_OnCanSendDomainReliabilityUpload_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContextClient_OnCanSendDomainReliabilityUpload_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
  };
  function NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams.prototype.initDefaults_ = function() {
    this.allowed = false;
  };
  NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.allowed = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.allowed & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContextClient_OnCanSendSCTAuditingReport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContextClient_OnCanSendSCTAuditingReport_Params.prototype.initDefaults_ = function() {
  };
  NetworkContextClient_OnCanSendSCTAuditingReport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContextClient_OnCanSendSCTAuditingReport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContextClient_OnCanSendSCTAuditingReport_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContextClient_OnCanSendSCTAuditingReport_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContextClient_OnCanSendSCTAuditingReport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContextClient_OnCanSendSCTAuditingReport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContextClient_OnCanSendSCTAuditingReport_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams.prototype.initDefaults_ = function() {
    this.allowed = false;
  };
  NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.allowed = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.allowed & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContextClient_OnNewSCTAuditingReportSent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContextClient_OnNewSCTAuditingReportSent_Params.prototype.initDefaults_ = function() {
  };
  NetworkContextClient_OnNewSCTAuditingReportSent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContextClient_OnNewSCTAuditingReportSent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContextClient_OnNewSCTAuditingReportSent_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContextClient_OnNewSCTAuditingReportSent_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContextClient_OnNewSCTAuditingReportSent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContextClient_OnNewSCTAuditingReportSent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContextClient_OnNewSCTAuditingReportSent_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kNetworkContextClient_OnFileUploadRequested_Name = 0;
  var kNetworkContextClient_OnCanSendReportingReports_Name = 1;
  var kNetworkContextClient_OnCanSendDomainReliabilityUpload_Name = 2;
  var kNetworkContextClient_OnCanSendSCTAuditingReport_Name = 3;
  var kNetworkContextClient_OnNewSCTAuditingReportSent_Name = 4;

  function NetworkContextClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(NetworkContextClient,
                                                   handleOrPtrInfo);
  }

  function NetworkContextClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        NetworkContextClient, associatedInterfacePtrInfo);
  }

  NetworkContextClientAssociatedPtr.prototype =
      Object.create(NetworkContextClientPtr.prototype);
  NetworkContextClientAssociatedPtr.prototype.constructor =
      NetworkContextClientAssociatedPtr;

  function NetworkContextClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  NetworkContextClientPtr.prototype.onFileUploadRequested = function() {
    return NetworkContextClientProxy.prototype.onFileUploadRequested
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextClientProxy.prototype.onFileUploadRequested = function(processId, async, filePaths, destinationUrl) {
    var params_ = new NetworkContextClient_OnFileUploadRequested_Params();
    params_.processId = processId;
    params_.async = async;
    params_.filePaths = filePaths;
    params_.destinationUrl = destinationUrl;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContextClient_OnFileUploadRequested_Name,
          codec.align(NetworkContextClient_OnFileUploadRequested_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContextClient_OnFileUploadRequested_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContextClient_OnFileUploadRequested_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextClientPtr.prototype.onCanSendReportingReports = function() {
    return NetworkContextClientProxy.prototype.onCanSendReportingReports
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextClientProxy.prototype.onCanSendReportingReports = function(origins) {
    var params_ = new NetworkContextClient_OnCanSendReportingReports_Params();
    params_.origins = origins;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContextClient_OnCanSendReportingReports_Name,
          codec.align(NetworkContextClient_OnCanSendReportingReports_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContextClient_OnCanSendReportingReports_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContextClient_OnCanSendReportingReports_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextClientPtr.prototype.onCanSendDomainReliabilityUpload = function() {
    return NetworkContextClientProxy.prototype.onCanSendDomainReliabilityUpload
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextClientProxy.prototype.onCanSendDomainReliabilityUpload = function(origin) {
    var params_ = new NetworkContextClient_OnCanSendDomainReliabilityUpload_Params();
    params_.origin = origin;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContextClient_OnCanSendDomainReliabilityUpload_Name,
          codec.align(NetworkContextClient_OnCanSendDomainReliabilityUpload_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContextClient_OnCanSendDomainReliabilityUpload_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextClientPtr.prototype.onCanSendSCTAuditingReport = function() {
    return NetworkContextClientProxy.prototype.onCanSendSCTAuditingReport
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextClientProxy.prototype.onCanSendSCTAuditingReport = function() {
    var params_ = new NetworkContextClient_OnCanSendSCTAuditingReport_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContextClient_OnCanSendSCTAuditingReport_Name,
          codec.align(NetworkContextClient_OnCanSendSCTAuditingReport_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContextClient_OnCanSendSCTAuditingReport_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextClientPtr.prototype.onNewSCTAuditingReportSent = function() {
    return NetworkContextClientProxy.prototype.onNewSCTAuditingReportSent
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextClientProxy.prototype.onNewSCTAuditingReportSent = function() {
    var params_ = new NetworkContextClient_OnNewSCTAuditingReportSent_Params();
    var builder = new codec.MessageV0Builder(
        kNetworkContextClient_OnNewSCTAuditingReportSent_Name,
        codec.align(NetworkContextClient_OnNewSCTAuditingReportSent_Params.encodedSize));
    builder.encodeStruct(NetworkContextClient_OnNewSCTAuditingReportSent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function NetworkContextClientStub(delegate) {
    this.delegate_ = delegate;
  }
  NetworkContextClientStub.prototype.onFileUploadRequested = function(processId, async, filePaths, destinationUrl) {
    return this.delegate_ && this.delegate_.onFileUploadRequested && this.delegate_.onFileUploadRequested(processId, async, filePaths, destinationUrl);
  }
  NetworkContextClientStub.prototype.onCanSendReportingReports = function(origins) {
    return this.delegate_ && this.delegate_.onCanSendReportingReports && this.delegate_.onCanSendReportingReports(origins);
  }
  NetworkContextClientStub.prototype.onCanSendDomainReliabilityUpload = function(origin) {
    return this.delegate_ && this.delegate_.onCanSendDomainReliabilityUpload && this.delegate_.onCanSendDomainReliabilityUpload(origin);
  }
  NetworkContextClientStub.prototype.onCanSendSCTAuditingReport = function() {
    return this.delegate_ && this.delegate_.onCanSendSCTAuditingReport && this.delegate_.onCanSendSCTAuditingReport();
  }
  NetworkContextClientStub.prototype.onNewSCTAuditingReportSent = function() {
    return this.delegate_ && this.delegate_.onNewSCTAuditingReportSent && this.delegate_.onNewSCTAuditingReportSent();
  }

  NetworkContextClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kNetworkContextClient_OnNewSCTAuditingReportSent_Name:
      var params = reader.decodeStruct(NetworkContextClient_OnNewSCTAuditingReportSent_Params);
      this.onNewSCTAuditingReportSent();
      return true;
    default:
      return false;
    }
  };

  NetworkContextClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kNetworkContextClient_OnFileUploadRequested_Name:
      var params = reader.decodeStruct(NetworkContextClient_OnFileUploadRequested_Params);
      this.onFileUploadRequested(params.processId, params.async, params.filePaths, params.destinationUrl).then(function(response) {
        var responseParams =
            new NetworkContextClient_OnFileUploadRequested_ResponseParams();
        responseParams.netError = response.netError;
        responseParams.files = response.files;
        var builder = new codec.MessageV1Builder(
            kNetworkContextClient_OnFileUploadRequested_Name,
            codec.align(NetworkContextClient_OnFileUploadRequested_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContextClient_OnFileUploadRequested_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContextClient_OnCanSendReportingReports_Name:
      var params = reader.decodeStruct(NetworkContextClient_OnCanSendReportingReports_Params);
      this.onCanSendReportingReports(params.origins).then(function(response) {
        var responseParams =
            new NetworkContextClient_OnCanSendReportingReports_ResponseParams();
        responseParams.origins = response.origins;
        var builder = new codec.MessageV1Builder(
            kNetworkContextClient_OnCanSendReportingReports_Name,
            codec.align(NetworkContextClient_OnCanSendReportingReports_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContextClient_OnCanSendReportingReports_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContextClient_OnCanSendDomainReliabilityUpload_Name:
      var params = reader.decodeStruct(NetworkContextClient_OnCanSendDomainReliabilityUpload_Params);
      this.onCanSendDomainReliabilityUpload(params.origin).then(function(response) {
        var responseParams =
            new NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams();
        responseParams.allowed = response.allowed;
        var builder = new codec.MessageV1Builder(
            kNetworkContextClient_OnCanSendDomainReliabilityUpload_Name,
            codec.align(NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContextClient_OnCanSendSCTAuditingReport_Name:
      var params = reader.decodeStruct(NetworkContextClient_OnCanSendSCTAuditingReport_Params);
      this.onCanSendSCTAuditingReport().then(function(response) {
        var responseParams =
            new NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams();
        responseParams.allowed = response.allowed;
        var builder = new codec.MessageV1Builder(
            kNetworkContextClient_OnCanSendSCTAuditingReport_Name,
            codec.align(NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateNetworkContextClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kNetworkContextClient_OnFileUploadRequested_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContextClient_OnFileUploadRequested_Params;
      break;
      case kNetworkContextClient_OnCanSendReportingReports_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContextClient_OnCanSendReportingReports_Params;
      break;
      case kNetworkContextClient_OnCanSendDomainReliabilityUpload_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContextClient_OnCanSendDomainReliabilityUpload_Params;
      break;
      case kNetworkContextClient_OnCanSendSCTAuditingReport_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContextClient_OnCanSendSCTAuditingReport_Params;
      break;
      case kNetworkContextClient_OnNewSCTAuditingReportSent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContextClient_OnNewSCTAuditingReportSent_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateNetworkContextClientResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kNetworkContextClient_OnFileUploadRequested_Name:
        if (message.isResponse())
          paramsClass = NetworkContextClient_OnFileUploadRequested_ResponseParams;
        break;
      case kNetworkContextClient_OnCanSendReportingReports_Name:
        if (message.isResponse())
          paramsClass = NetworkContextClient_OnCanSendReportingReports_ResponseParams;
        break;
      case kNetworkContextClient_OnCanSendDomainReliabilityUpload_Name:
        if (message.isResponse())
          paramsClass = NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams;
        break;
      case kNetworkContextClient_OnCanSendSCTAuditingReport_Name:
        if (message.isResponse())
          paramsClass = NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var NetworkContextClient = {
    name: 'network.mojom.NetworkContextClient',
    kVersion: 0,
    ptrClass: NetworkContextClientPtr,
    proxyClass: NetworkContextClientProxy,
    stubClass: NetworkContextClientStub,
    validateRequest: validateNetworkContextClientRequest,
    validateResponse: validateNetworkContextClientResponse,
  };
  NetworkContextClientStub.prototype.validator = validateNetworkContextClientRequest;
  NetworkContextClientProxy.prototype.validator = validateNetworkContextClientResponse;
  exports.NetworkContextClient = NetworkContextClient;
  exports.NetworkContextClientPtr = NetworkContextClientPtr;
  exports.NetworkContextClientAssociatedPtr = NetworkContextClientAssociatedPtr;
})();