// services/network/public/mojom/network_context_client.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/network_context_client.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_context_client.mojom-params-data.h"
#include "services/network/public/mojom/network_context_client.mojom-shared-message-ids.h"

#include "services/network/public/mojom/network_context_client.mojom-blink-import-headers.h"
#include "services/network/public/mojom/network_context_client.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
// The declaration includes the definition on other builds.

NetworkContextClient::IPCStableHashFunction NetworkContextClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NetworkContextClient>(message.name())) {
    case messages::NetworkContextClient::kOnFileUploadRequested: {
      return &NetworkContextClient::OnFileUploadRequested_Sym::IPCStableHash;
    }
    case messages::NetworkContextClient::kOnCanSendReportingReports: {
      return &NetworkContextClient::OnCanSendReportingReports_Sym::IPCStableHash;
    }
    case messages::NetworkContextClient::kOnCanSendDomainReliabilityUpload: {
      return &NetworkContextClient::OnCanSendDomainReliabilityUpload_Sym::IPCStableHash;
    }
    case messages::NetworkContextClient::kOnCanSendSCTAuditingReport: {
      return &NetworkContextClient::OnCanSendSCTAuditingReport_Sym::IPCStableHash;
    }
    case messages::NetworkContextClient::kOnNewSCTAuditingReportSent: {
      return &NetworkContextClient::OnNewSCTAuditingReportSent_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NetworkContextClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NetworkContextClient>(message.name())) {
      case messages::NetworkContextClient::kOnFileUploadRequested:
            return "Receive network::mojom::NetworkContextClient::OnFileUploadRequested";
      case messages::NetworkContextClient::kOnCanSendReportingReports:
            return "Receive network::mojom::NetworkContextClient::OnCanSendReportingReports";
      case messages::NetworkContextClient::kOnCanSendDomainReliabilityUpload:
            return "Receive network::mojom::NetworkContextClient::OnCanSendDomainReliabilityUpload";
      case messages::NetworkContextClient::kOnCanSendSCTAuditingReport:
            return "Receive network::mojom::NetworkContextClient::OnCanSendSCTAuditingReport";
      case messages::NetworkContextClient::kOnNewSCTAuditingReportSent:
            return "Receive network::mojom::NetworkContextClient::OnNewSCTAuditingReportSent";
    }
  } else {
    switch (static_cast<messages::NetworkContextClient>(message.name())) {
      case messages::NetworkContextClient::kOnFileUploadRequested:
            return "Receive reply network::mojom::NetworkContextClient::OnFileUploadRequested";
      case messages::NetworkContextClient::kOnCanSendReportingReports:
            return "Receive reply network::mojom::NetworkContextClient::OnCanSendReportingReports";
      case messages::NetworkContextClient::kOnCanSendDomainReliabilityUpload:
            return "Receive reply network::mojom::NetworkContextClient::OnCanSendDomainReliabilityUpload";
      case messages::NetworkContextClient::kOnCanSendSCTAuditingReport:
            return "Receive reply network::mojom::NetworkContextClient::OnCanSendSCTAuditingReport";
      case messages::NetworkContextClient::kOnNewSCTAuditingReportSent:
            return "Receive reply network::mojom::NetworkContextClient::OnNewSCTAuditingReportSent";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NetworkContextClient::OnFileUploadRequested_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc41ada7e;  // IPCStableHash for network::mojom::NetworkContextClient::OnFileUploadRequested
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContextClient::OnCanSendReportingReports_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4cd90f1a;  // IPCStableHash for network::mojom::NetworkContextClient::OnCanSendReportingReports
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContextClient::OnCanSendDomainReliabilityUpload_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf6465456;  // IPCStableHash for network::mojom::NetworkContextClient::OnCanSendDomainReliabilityUpload
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContextClient::OnCanSendSCTAuditingReport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe0702940;  // IPCStableHash for network::mojom::NetworkContextClient::OnCanSendSCTAuditingReport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContextClient::OnNewSCTAuditingReportSent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf69d6cc7;  // IPCStableHash for network::mojom::NetworkContextClient::OnNewSCTAuditingReportSent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class NetworkContextClient_OnFileUploadRequested_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContextClient_OnFileUploadRequested_ForwardToCallback(
      NetworkContextClient::OnFileUploadRequestedCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContextClient_OnFileUploadRequested_ForwardToCallback(const NetworkContextClient_OnFileUploadRequested_ForwardToCallback&) = delete;
  NetworkContextClient_OnFileUploadRequested_ForwardToCallback& operator=(const NetworkContextClient_OnFileUploadRequested_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContextClient::OnFileUploadRequestedCallback callback_;
};

class NetworkContextClient_OnCanSendReportingReports_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContextClient_OnCanSendReportingReports_ForwardToCallback(
      NetworkContextClient::OnCanSendReportingReportsCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContextClient_OnCanSendReportingReports_ForwardToCallback(const NetworkContextClient_OnCanSendReportingReports_ForwardToCallback&) = delete;
  NetworkContextClient_OnCanSendReportingReports_ForwardToCallback& operator=(const NetworkContextClient_OnCanSendReportingReports_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContextClient::OnCanSendReportingReportsCallback callback_;
};

class NetworkContextClient_OnCanSendDomainReliabilityUpload_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContextClient_OnCanSendDomainReliabilityUpload_ForwardToCallback(
      NetworkContextClient::OnCanSendDomainReliabilityUploadCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContextClient_OnCanSendDomainReliabilityUpload_ForwardToCallback(const NetworkContextClient_OnCanSendDomainReliabilityUpload_ForwardToCallback&) = delete;
  NetworkContextClient_OnCanSendDomainReliabilityUpload_ForwardToCallback& operator=(const NetworkContextClient_OnCanSendDomainReliabilityUpload_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContextClient::OnCanSendDomainReliabilityUploadCallback callback_;
};

class NetworkContextClient_OnCanSendSCTAuditingReport_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContextClient_OnCanSendSCTAuditingReport_ForwardToCallback(
      NetworkContextClient::OnCanSendSCTAuditingReportCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContextClient_OnCanSendSCTAuditingReport_ForwardToCallback(const NetworkContextClient_OnCanSendSCTAuditingReport_ForwardToCallback&) = delete;
  NetworkContextClient_OnCanSendSCTAuditingReport_ForwardToCallback& operator=(const NetworkContextClient_OnCanSendSCTAuditingReport_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContextClient::OnCanSendSCTAuditingReportCallback callback_;
};

NetworkContextClientProxy::NetworkContextClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkContextClientProxy::OnFileUploadRequested(
    int32_t in_process_id, bool in_async, const ::blink::Vector<::base::FilePath>& in_file_paths, const ::blink::KURL& in_destination_url, OnFileUploadRequestedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContextClient::OnFileUploadRequested", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process_id"), in_process_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("async"), in_async,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_paths"), in_file_paths,
                        "<value of type const ::blink::Vector<::base::FilePath>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("destination_url"), in_destination_url,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContextClient::kOnFileUploadRequested), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContextClient_OnFileUploadRequested_Params_Data> params(
          message);
  params.Allocate();

  params->process_id = in_process_id;

  params->async = in_async;
  mojo::internal::MessageFragment<
      typename decltype(params->file_paths)::BaseType>
      file_paths_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& file_paths_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
    in_file_paths,
    file_paths_fragment,
    &file_paths_validate_params);

  params->file_paths.Set(
      file_paths_fragment.is_null() ? nullptr : file_paths_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_paths.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_paths in NetworkContextClient.OnFileUploadRequested request");
  mojo::internal::MessageFragment<
      typename decltype(params->destination_url)::BaseType> destination_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_destination_url,
    destination_url_fragment);

  params->destination_url.Set(
      destination_url_fragment.is_null() ? nullptr : destination_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->destination_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null destination_url in NetworkContextClient.OnFileUploadRequested request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnFileUploadRequested");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContextClient_OnFileUploadRequested_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextClientProxy::OnCanSendReportingReports(
    const ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>& in_origins, OnCanSendReportingReportsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContextClient::OnCanSendReportingReports", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origins"), in_origins,
                        "<value of type const ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContextClient::kOnCanSendReportingReports), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContextClient_OnCanSendReportingReports_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origins)::BaseType>
      origins_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& origins_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
    in_origins,
    origins_fragment,
    &origins_validate_params);

  params->origins.Set(
      origins_fragment.is_null() ? nullptr : origins_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origins.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origins in NetworkContextClient.OnCanSendReportingReports request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnCanSendReportingReports");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContextClient_OnCanSendReportingReports_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextClientProxy::OnCanSendDomainReliabilityUpload(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& in_origin, OnCanSendDomainReliabilityUploadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContextClient::OnCanSendDomainReliabilityUpload", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContextClient::kOnCanSendDomainReliabilityUpload), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContextClient_OnCanSendDomainReliabilityUpload_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in NetworkContextClient.OnCanSendDomainReliabilityUpload request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnCanSendDomainReliabilityUpload");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContextClient_OnCanSendDomainReliabilityUpload_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextClientProxy::OnCanSendSCTAuditingReport(
    OnCanSendSCTAuditingReportCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkContextClient::OnCanSendSCTAuditingReport");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContextClient::kOnCanSendSCTAuditingReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContextClient_OnCanSendSCTAuditingReport_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnCanSendSCTAuditingReport");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContextClient_OnCanSendSCTAuditingReport_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextClientProxy::OnNewSCTAuditingReportSent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkContextClient::OnNewSCTAuditingReportSent");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContextClient::kOnNewSCTAuditingReportSent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContextClient_OnNewSCTAuditingReportSent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnNewSCTAuditingReportSent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class NetworkContextClient_OnFileUploadRequested_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContextClient::OnFileUploadRequestedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContextClient_OnFileUploadRequested_ProxyToResponder> proxy(
        new NetworkContextClient_OnFileUploadRequested_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContextClient_OnFileUploadRequested_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContextClient_OnFileUploadRequested_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContextClient_OnFileUploadRequested_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NetworkContextClient::OnFileUploadRequestedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error, ::blink::Vector<::base::File> in_files);
};

bool NetworkContextClient_OnFileUploadRequested_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContextClient_OnFileUploadRequested_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContextClient_OnFileUploadRequested_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContextClient.0
  bool success = true;
  int32_t p_net_error{};
  ::blink::Vector<::base::File> p_files{};
  NetworkContextClient_OnFileUploadRequested_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (success && !input_data_view.ReadFiles(&p_files))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContextClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_net_error), 
std::move(p_files));
  }
  return true;
}

void NetworkContextClient_OnFileUploadRequested_ProxyToResponder::Run(
    int32_t in_net_error, ::blink::Vector<::base::File> in_files) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContextClient::OnFileUploadRequested", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("files"), in_files,
                        "<value of type ::blink::Vector<::base::File>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContextClient::kOnFileUploadRequested), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContextClient_OnFileUploadRequested_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->net_error = in_net_error;
  mojo::internal::MessageFragment<
      typename decltype(params->files)::BaseType>
      files_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::ReadOnlyFileDataView>>(
    in_files,
    files_fragment,
    &files_validate_params);

  params->files.Set(
      files_fragment.is_null() ? nullptr : files_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->files.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null files in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnFileUploadRequested");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContextClient_OnCanSendReportingReports_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContextClient::OnCanSendReportingReportsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContextClient_OnCanSendReportingReports_ProxyToResponder> proxy(
        new NetworkContextClient_OnCanSendReportingReports_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContextClient_OnCanSendReportingReports_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContextClient_OnCanSendReportingReports_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContextClient_OnCanSendReportingReports_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NetworkContextClient::OnCanSendReportingReportsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>& in_origins);
};

bool NetworkContextClient_OnCanSendReportingReports_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContextClient_OnCanSendReportingReports_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContextClient_OnCanSendReportingReports_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContextClient.1
  bool success = true;
  ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>> p_origins{};
  NetworkContextClient_OnCanSendReportingReports_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadOrigins(&p_origins))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContextClient::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_origins));
  }
  return true;
}

void NetworkContextClient_OnCanSendReportingReports_ProxyToResponder::Run(
    const ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>& in_origins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContextClient::OnCanSendReportingReports", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origins"), in_origins,
                        "<value of type const ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContextClient::kOnCanSendReportingReports), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContextClient_OnCanSendReportingReports_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origins)::BaseType>
      origins_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& origins_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
    in_origins,
    origins_fragment,
    &origins_validate_params);

  params->origins.Set(
      origins_fragment.is_null() ? nullptr : origins_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origins.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origins in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnCanSendReportingReports");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContextClient_OnCanSendDomainReliabilityUpload_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContextClient::OnCanSendDomainReliabilityUploadCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContextClient_OnCanSendDomainReliabilityUpload_ProxyToResponder> proxy(
        new NetworkContextClient_OnCanSendDomainReliabilityUpload_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContextClient_OnCanSendDomainReliabilityUpload_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContextClient_OnCanSendDomainReliabilityUpload_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContextClient_OnCanSendDomainReliabilityUpload_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NetworkContextClient::OnCanSendDomainReliabilityUploadCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_allowed);
};

bool NetworkContextClient_OnCanSendDomainReliabilityUpload_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContextClient.2
  bool success = true;
  bool p_allowed{};
  NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_allowed = input_data_view.allowed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContextClient::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_allowed));
  }
  return true;
}

void NetworkContextClient_OnCanSendDomainReliabilityUpload_ProxyToResponder::Run(
    bool in_allowed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContextClient::OnCanSendDomainReliabilityUpload", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allowed"), in_allowed,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContextClient::kOnCanSendDomainReliabilityUpload), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->allowed = in_allowed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnCanSendDomainReliabilityUpload");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContextClient_OnCanSendSCTAuditingReport_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContextClient::OnCanSendSCTAuditingReportCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContextClient_OnCanSendSCTAuditingReport_ProxyToResponder> proxy(
        new NetworkContextClient_OnCanSendSCTAuditingReport_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContextClient_OnCanSendSCTAuditingReport_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContextClient_OnCanSendSCTAuditingReport_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContextClient_OnCanSendSCTAuditingReport_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NetworkContextClient::OnCanSendSCTAuditingReportCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_allowed);
};

bool NetworkContextClient_OnCanSendSCTAuditingReport_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContextClient.3
  bool success = true;
  bool p_allowed{};
  NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_allowed = input_data_view.allowed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContextClient::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_allowed));
  }
  return true;
}

void NetworkContextClient_OnCanSendSCTAuditingReport_ProxyToResponder::Run(
    bool in_allowed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContextClient::OnCanSendSCTAuditingReport", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allowed"), in_allowed,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContextClient::kOnCanSendSCTAuditingReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->allowed = in_allowed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnCanSendSCTAuditingReport");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NetworkContextClientStubDispatch::Accept(
    NetworkContextClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NetworkContextClient>(message->header()->name)) {
    case messages::NetworkContextClient::kOnFileUploadRequested: {
      break;
    }
    case messages::NetworkContextClient::kOnCanSendReportingReports: {
      break;
    }
    case messages::NetworkContextClient::kOnCanSendDomainReliabilityUpload: {
      break;
    }
    case messages::NetworkContextClient::kOnCanSendSCTAuditingReport: {
      break;
    }
    case messages::NetworkContextClient::kOnNewSCTAuditingReportSent: {
      DCHECK(message->is_serialized());
      internal::NetworkContextClient_OnNewSCTAuditingReportSent_Params_Data* params =
          reinterpret_cast<internal::NetworkContextClient_OnNewSCTAuditingReportSent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContextClient.4
      bool success = true;
      NetworkContextClient_OnNewSCTAuditingReportSent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContextClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNewSCTAuditingReportSent(        );
      return true;
    }
  }
  return false;
}

// static
bool NetworkContextClientStubDispatch::AcceptWithResponder(
    NetworkContextClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NetworkContextClient>(message->header()->name)) {
    case messages::NetworkContextClient::kOnFileUploadRequested: {
      internal::NetworkContextClient_OnFileUploadRequested_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContextClient_OnFileUploadRequested_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContextClient.0
      bool success = true;
      int32_t p_process_id{};
      bool p_async{};
      ::blink::Vector<::base::FilePath> p_file_paths{};
      ::blink::KURL p_destination_url{};
      NetworkContextClient_OnFileUploadRequested_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_process_id = input_data_view.process_id();
      if (success)
        p_async = input_data_view.async();
      if (success && !input_data_view.ReadFilePaths(&p_file_paths))
        success = false;
      if (success && !input_data_view.ReadDestinationUrl(&p_destination_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContextClient::Name_, 0, false);
        return false;
      }
      auto callback =
          NetworkContextClient_OnFileUploadRequested_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFileUploadRequested(        
        std::move(p_process_id), 
        std::move(p_async), 
        std::move(p_file_paths), 
        std::move(p_destination_url), std::move(callback));
      return true;
    }
    case messages::NetworkContextClient::kOnCanSendReportingReports: {
      internal::NetworkContextClient_OnCanSendReportingReports_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContextClient_OnCanSendReportingReports_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContextClient.1
      bool success = true;
      ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>> p_origins{};
      NetworkContextClient_OnCanSendReportingReports_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigins(&p_origins))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContextClient::Name_, 1, false);
        return false;
      }
      auto callback =
          NetworkContextClient_OnCanSendReportingReports_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCanSendReportingReports(        
        std::move(p_origins), std::move(callback));
      return true;
    }
    case messages::NetworkContextClient::kOnCanSendDomainReliabilityUpload: {
      internal::NetworkContextClient_OnCanSendDomainReliabilityUpload_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContextClient_OnCanSendDomainReliabilityUpload_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContextClient.2
      bool success = true;
      ::scoped_refptr<const ::blink::SecurityOrigin> p_origin{};
      NetworkContextClient_OnCanSendDomainReliabilityUpload_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContextClient::Name_, 2, false);
        return false;
      }
      auto callback =
          NetworkContextClient_OnCanSendDomainReliabilityUpload_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCanSendDomainReliabilityUpload(        
        std::move(p_origin), std::move(callback));
      return true;
    }
    case messages::NetworkContextClient::kOnCanSendSCTAuditingReport: {
      internal::NetworkContextClient_OnCanSendSCTAuditingReport_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContextClient_OnCanSendSCTAuditingReport_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContextClient.3
      bool success = true;
      NetworkContextClient_OnCanSendSCTAuditingReport_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContextClient::Name_, 3, false);
        return false;
      }
      auto callback =
          NetworkContextClient_OnCanSendSCTAuditingReport_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCanSendSCTAuditingReport(std::move(callback));
      return true;
    }
    case messages::NetworkContextClient::kOnNewSCTAuditingReportSent: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNetworkContextClientValidationInfo[] = {
    { &internal::NetworkContextClient_OnFileUploadRequested_Params_Data::Validate,
     &internal::NetworkContextClient_OnFileUploadRequested_ResponseParams_Data::Validate},
    { &internal::NetworkContextClient_OnCanSendReportingReports_Params_Data::Validate,
     &internal::NetworkContextClient_OnCanSendReportingReports_ResponseParams_Data::Validate},
    { &internal::NetworkContextClient_OnCanSendDomainReliabilityUpload_Params_Data::Validate,
     &internal::NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams_Data::Validate},
    { &internal::NetworkContextClient_OnCanSendSCTAuditingReport_Params_Data::Validate,
     &internal::NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams_Data::Validate},
    { &internal::NetworkContextClient_OnNewSCTAuditingReportSent_Params_Data::Validate,
     nullptr /* no response */},
};

bool NetworkContextClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::blink::NetworkContextClient::Name_,
    kNetworkContextClientValidationInfo);
}

bool NetworkContextClientResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::network::mojom::blink::NetworkContextClient::Name_,
    kNetworkContextClientValidationInfo);
}


}  // network::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {


void NetworkContextClientInterceptorForTesting::OnFileUploadRequested(int32_t process_id, bool async, const ::blink::Vector<::base::FilePath>& file_paths, const ::blink::KURL& destination_url, OnFileUploadRequestedCallback callback) {
  GetForwardingInterface()->OnFileUploadRequested(
    std::move(process_id)
    , 
    std::move(async)
    , 
    std::move(file_paths)
    , 
    std::move(destination_url)
    , std::move(callback));
}
void NetworkContextClientInterceptorForTesting::OnCanSendReportingReports(const ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>& origins, OnCanSendReportingReportsCallback callback) {
  GetForwardingInterface()->OnCanSendReportingReports(
    std::move(origins)
    , std::move(callback));
}
void NetworkContextClientInterceptorForTesting::OnCanSendDomainReliabilityUpload(const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, OnCanSendDomainReliabilityUploadCallback callback) {
  GetForwardingInterface()->OnCanSendDomainReliabilityUpload(
    std::move(origin)
    , std::move(callback));
}
void NetworkContextClientInterceptorForTesting::OnCanSendSCTAuditingReport(OnCanSendSCTAuditingReportCallback callback) {
  GetForwardingInterface()->OnCanSendSCTAuditingReport(std::move(callback));
}
void NetworkContextClientInterceptorForTesting::OnNewSCTAuditingReportSent() {
  GetForwardingInterface()->OnNewSCTAuditingReportSent();
}
NetworkContextClientAsyncWaiter::NetworkContextClientAsyncWaiter(
    NetworkContextClient* proxy) : proxy_(proxy) {}

NetworkContextClientAsyncWaiter::~NetworkContextClientAsyncWaiter() = default;


void NetworkContextClientAsyncWaiter::OnFileUploadRequested(
    int32_t process_id, bool async, const ::blink::Vector<::base::FilePath>& file_paths, const ::blink::KURL& destination_url, int32_t* out_net_error, ::blink::Vector<::base::File>* out_files) {
  base::RunLoop loop;
  proxy_->OnFileUploadRequested(
      std::move(process_id),
      std::move(async),
      std::move(file_paths),
      std::move(destination_url),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_net_error
,
             ::blink::Vector<::base::File>* out_files
,
             int32_t net_error,
             ::blink::Vector<::base::File> files) {*out_net_error = std::move(net_error);*out_files = std::move(files);
            loop->Quit();
          },
          &loop,
          out_net_error,
          out_files));
  loop.Run();
}



void NetworkContextClientAsyncWaiter::OnCanSendReportingReports(
    const ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>& origins, ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>* out_origins) {
  base::RunLoop loop;
  proxy_->OnCanSendReportingReports(
      std::move(origins),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>* out_origins
,
             const ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>& origins) {*out_origins = std::move(origins);
            loop->Quit();
          },
          &loop,
          out_origins));
  loop.Run();
}

::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>> NetworkContextClientAsyncWaiter::OnCanSendReportingReports(
    const ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>& origins) {
  ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>> async_wait_result;
  OnCanSendReportingReports(std::move(origins),&async_wait_result);
  return async_wait_result;
}

void NetworkContextClientAsyncWaiter::OnCanSendDomainReliabilityUpload(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, bool* out_allowed) {
  base::RunLoop loop;
  proxy_->OnCanSendDomainReliabilityUpload(
      std::move(origin),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_allowed
,
             bool allowed) {*out_allowed = std::move(allowed);
            loop->Quit();
          },
          &loop,
          out_allowed));
  loop.Run();
}

bool NetworkContextClientAsyncWaiter::OnCanSendDomainReliabilityUpload(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& origin) {
  bool async_wait_result;
  OnCanSendDomainReliabilityUpload(std::move(origin),&async_wait_result);
  return async_wait_result;
}

void NetworkContextClientAsyncWaiter::OnCanSendSCTAuditingReport(
    bool* out_allowed) {
  base::RunLoop loop;
  proxy_->OnCanSendSCTAuditingReport(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_allowed
,
             bool allowed) {*out_allowed = std::move(allowed);
            loop->Quit();
          },
          &loop,
          out_allowed));
  loop.Run();
}

bool NetworkContextClientAsyncWaiter::OnCanSendSCTAuditingReport(
    ) {
  bool async_wait_result;
  OnCanSendSCTAuditingReport(&async_wait_result);
  return async_wait_result;
}






}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif