// services/network/public/mojom/network_context.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/network_context.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var content_settings$ =
      mojo.internal.exposeNamespace('contentSettings.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/content_settings/core/common/content_settings.mojom', '../../../../components/content_settings/core/common/content_settings.mojom.js');
  }
  var unexportable_key_service$ =
      mojo.internal.exposeNamespace('unexportableKeys.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/unexportable_keys/mojom/unexportable_key_service.mojom', '../../../../components/unexportable_keys/mojom/unexportable_key_service.mojom.js');
  }
  var big_buffer$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/big_buffer.mojom', '../../../../mojo/public/mojom/base/big_buffer.mojom.js');
  }
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../../mojo/public/mojom/base/file_path.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var values$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/values.mojom', '../../../../mojo/public/mojom/base/values.mojom.js');
  }
  var context$ =
      mojo.internal.exposeNamespace('sandbox.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'sandbox/policy/mojom/context.mojom', '../../../../sandbox/policy/mojom/context.mojom.js');
  }
  var address_list$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/address_list.mojom', 'address_list.mojom.js');
  }
  var cert_verifier_service$ =
      mojo.internal.exposeNamespace('certVerifier.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cert_verifier_service.mojom', 'cert_verifier_service.mojom.js');
  }
  var clear_data_filter$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/clear_data_filter.mojom', 'clear_data_filter.mojom.js');
  }
  var client_security_state$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/client_security_state.mojom', 'client_security_state.mojom.js');
  }
  var connection_change_observer_client$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/connection_change_observer_client.mojom', 'connection_change_observer_client.mojom.js');
  }
  var cookie_access_observer$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cookie_access_observer.mojom', 'cookie_access_observer.mojom.js');
  }
  var cookie_encryption_provider$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cookie_encryption_provider.mojom', 'cookie_encryption_provider.mojom.js');
  }
  var cookie_manager$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cookie_manager.mojom', 'cookie_manager.mojom.js');
  }
  var cookie_setting_overrides$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cookie_setting_overrides.mojom', 'cookie_setting_overrides.mojom.js');
  }
  var cors_origin_pattern$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cors_origin_pattern.mojom', 'cors_origin_pattern.mojom.js');
  }
  var cross_origin_embedder_policy$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cross_origin_embedder_policy.mojom', 'cross_origin_embedder_policy.mojom.js');
  }
  var ct_policy$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ct_policy.mojom', 'ct_policy.mojom.js');
  }
  var default_credentials$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/default_credentials.mojom', 'default_credentials.mojom.js');
  }
  var device_bound_sessions$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/device_bound_sessions.mojom', 'device_bound_sessions.mojom.js');
  }
  var devtools_observer$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/devtools_observer.mojom', 'devtools_observer.mojom.js');
  }
  var document_isolation_policy$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/document_isolation_policy.mojom', 'document_isolation_policy.mojom.js');
  }
  var fetch_api$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/fetch_api.mojom', 'fetch_api.mojom.js');
  }
  var first_party_sets_access_delegate$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/first_party_sets_access_delegate.mojom', 'first_party_sets_access_delegate.mojom.js');
  }
  var hash_value$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/hash_value.mojom', 'hash_value.mojom.js');
  }
  var host_resolver$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/host_resolver.mojom', 'host_resolver.mojom.js');
  }
  var http_cache_backend_file_operations$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/http_cache_backend_file_operations.mojom', 'http_cache_backend_file_operations.mojom.js');
  }
  var http_request_headers$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/http_request_headers.mojom', 'http_request_headers.mojom.js');
  }
  var ip_address$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_address.mojom', 'ip_address.mojom.js');
  }
  var ip_address_space$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_address_space.mojom', 'ip_address_space.mojom.js');
  }
  var ip_endpoint$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_endpoint.mojom', 'ip_endpoint.mojom.js');
  }
  var isolation_info$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/isolation_info.mojom', 'isolation_info.mojom.js');
  }
  var mdns_responder$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/mdns_responder.mojom', 'mdns_responder.mojom.js');
  }
  var mutable_network_traffic_annotation_tag$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom', 'mutable_network_traffic_annotation_tag.mojom.js');
  }
  var net_log$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/net_log.mojom', 'net_log.mojom.js');
  }
  var network_anonymization_key$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_anonymization_key.mojom', 'network_anonymization_key.mojom.js');
  }
  var network_context_client$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_context_client.mojom', 'network_context_client.mojom.js');
  }
  var network_isolation_key$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_isolation_key.mojom', 'network_isolation_key.mojom.js');
  }
  var network_param$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_param.mojom', 'network_param.mojom.js');
  }
  var oblivious_http_request$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/oblivious_http_request.mojom', 'oblivious_http_request.mojom.js');
  }
  var parsed_headers$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/parsed_headers.mojom', 'parsed_headers.mojom.js');
  }
  var proxy_config$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/proxy_config.mojom', 'proxy_config.mojom.js');
  }
  var proxy_config_with_annotation$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/proxy_config_with_annotation.mojom', 'proxy_config_with_annotation.mojom.js');
  }
  var proxy_lookup_client$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/proxy_lookup_client.mojom', 'proxy_lookup_client.mojom.js');
  }
  var proxy_resolving_socket$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/proxy_resolving_socket.mojom', 'proxy_resolving_socket.mojom.js');
  }
  var reporting_service$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/reporting_service.mojom', 'reporting_service.mojom.js');
  }
  var restricted_cookie_manager$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/restricted_cookie_manager.mojom', 'restricted_cookie_manager.mojom.js');
  }
  var restricted_udp_socket$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/restricted_udp_socket.mojom', 'restricted_udp_socket.mojom.js');
  }
  var shared_dictionary_access_observer$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/shared_dictionary_access_observer.mojom', 'shared_dictionary_access_observer.mojom.js');
  }
  var shared_dictionary_isolation_key$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/shared_dictionary_isolation_key.mojom', 'shared_dictionary_isolation_key.mojom.js');
  }
  var shared_dictionary_usage_info$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/shared_dictionary_usage_info.mojom', 'shared_dictionary_usage_info.mojom.js');
  }
  var site_for_cookies$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/site_for_cookies.mojom', 'site_for_cookies.mojom.js');
  }
  var socket_broker$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/socket_broker.mojom', 'socket_broker.mojom.js');
  }
  var ssl_config$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ssl_config.mojom', 'ssl_config.mojom.js');
  }
  var storage_access_api$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/storage_access_api.mojom', 'storage_access_api.mojom.js');
  }
  var tcp_socket$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/tcp_socket.mojom', 'tcp_socket.mojom.js');
  }
  var transferable_directory$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/transferable_directory.mojom', 'transferable_directory.mojom.js');
  }
  var trust_token_access_observer$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/trust_token_access_observer.mojom', 'trust_token_access_observer.mojom.js');
  }
  var trust_tokens$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/trust_tokens.mojom', 'trust_tokens.mojom.js');
  }
  var udp_socket$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/udp_socket.mojom', 'udp_socket.mojom.js');
  }
  var url_loader$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_loader.mojom', 'url_loader.mojom.js');
  }
  var url_loader_factory$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_loader_factory.mojom', 'url_loader_factory.mojom.js');
  }
  var url_loader_network_service_observer$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_loader_network_service_observer.mojom', 'url_loader_network_service_observer.mojom.js');
  }
  var url_request$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_request.mojom', 'url_request.mojom.js');
  }
  var url_response_head$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_response_head.mojom', 'url_response_head.mojom.js');
  }
  var web_transport$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/web_transport.mojom', 'web_transport.mojom.js');
  }
  var websocket$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/websocket.mojom', 'websocket.mojom.js');
  }
  var proxy_resolver$ =
      mojo.internal.exposeNamespace('proxyResolver.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/proxy_resolver/public/mojom/proxy_resolver.mojom', '../../../proxy_resolver/public/mojom/proxy_resolver.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../url/mojom/origin.mojom.js');
  }
  var scheme_host_port$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/scheme_host_port.mojom', '../../../../url/mojom/scheme_host_port.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }
  var p2p$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/p2p.mojom', 'p2p.mojom.js');
  }
  var p2p_trusted$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/p2p_trusted.mojom', 'p2p_trusted.mojom.js');
  }


  var WEB_SOCKET_OPTION_NONE = 0;
  var WEB_SOCKET_OPTION_BLOCK_ALL_COOKIES = 1;
  var WEB_SOCKET_OPTION_BLOCK_THIRD_PARTY_COOKIES = 2;
  var BROWSER_PROCESS_ID = 0;
  var INVALID_PROCESS_ID = -1;
  var TrustTokenOperationPolicyVerdict = {};
  TrustTokenOperationPolicyVerdict.kForbid = 0;
  TrustTokenOperationPolicyVerdict.kPotentiallyPermit = 1;
  TrustTokenOperationPolicyVerdict.MIN_VALUE = 0;
  TrustTokenOperationPolicyVerdict.MAX_VALUE = 1;

  TrustTokenOperationPolicyVerdict.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  TrustTokenOperationPolicyVerdict.toKnownEnumValue = function(value) {
    return value;
  };

  TrustTokenOperationPolicyVerdict.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SCTAuditingMode = {};
  SCTAuditingMode.kDisabled = 0;
  SCTAuditingMode.kEnhancedSafeBrowsingReporting = 1;
  SCTAuditingMode.kHashdance = 2;
  SCTAuditingMode.MIN_VALUE = 0;
  SCTAuditingMode.MAX_VALUE = 2;

  SCTAuditingMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  SCTAuditingMode.toKnownEnumValue = function(value) {
    return value;
  };

  SCTAuditingMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function CustomProxyConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CustomProxyConfig.prototype.initDefaults_ = function() {
    this.rules = null;
    this.shouldOverrideExistingConfig = false;
    this.allowNonIdempotentMethods = false;
    this.connectTunnelHeaders = null;
  };
  CustomProxyConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CustomProxyConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CustomProxyConfig.rules
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, proxy_config$.ProxyRules, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate CustomProxyConfig.connectTunnelHeaders
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, http_request_headers$.HttpRequestHeaders, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CustomProxyConfig.encodedSize = codec.kStructHeaderSize + 24;

  CustomProxyConfig.decode = function(decoder) {
    var packed;
    var val = new CustomProxyConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.rules =
        decoder.decodeStructPointer(proxy_config$.ProxyRules);
    packed = decoder.readUint8();
    val.shouldOverrideExistingConfig = (packed >> 0) & 1 ? true : false;
    val.allowNonIdempotentMethods = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.connectTunnelHeaders =
        decoder.decodeStructPointer(http_request_headers$.HttpRequestHeaders);
    return val;
  };

  CustomProxyConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CustomProxyConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(proxy_config$.ProxyRules, val.rules);
    packed = 0;
    packed |= (val.shouldOverrideExistingConfig & 1) << 0
    packed |= (val.allowNonIdempotentMethods & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(http_request_headers$.HttpRequestHeaders, val.connectTunnelHeaders);
  };
  function CertVerifierServiceRemoteParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CertVerifierServiceRemoteParams.prototype.initDefaults_ = function() {
    this.certVerifierService = new cert_verifier_service$.CertVerifierServicePtr();
    this.certVerifierServiceClientReceiver = new bindings.InterfaceRequest();
  };
  CertVerifierServiceRemoteParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CertVerifierServiceRemoteParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CertVerifierServiceRemoteParams.certVerifierService
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CertVerifierServiceRemoteParams.certVerifierServiceClientReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CertVerifierServiceRemoteParams.encodedSize = codec.kStructHeaderSize + 16;

  CertVerifierServiceRemoteParams.decode = function(decoder) {
    var packed;
    var val = new CertVerifierServiceRemoteParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.certVerifierService =
        decoder.decodeStruct(new codec.NullableInterface(cert_verifier_service$.CertVerifierServicePtr));
    val.certVerifierServiceClientReceiver =
        decoder.decodeStruct(codec.NullableInterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CertVerifierServiceRemoteParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CertVerifierServiceRemoteParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.NullableInterface(cert_verifier_service$.CertVerifierServicePtr), val.certVerifierService);
    encoder.encodeStruct(codec.NullableInterfaceRequest, val.certVerifierServiceClientReceiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HttpAuthStaticNetworkContextParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HttpAuthStaticNetworkContextParams.prototype.initDefaults_ = function() {
    this.allowDefaultCredentials = default_credentials$.DefaultCredentials.ALLOW_DEFAULT_CREDENTIALS;
  };
  HttpAuthStaticNetworkContextParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HttpAuthStaticNetworkContextParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HttpAuthStaticNetworkContextParams.allowDefaultCredentials
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, default_credentials$.DefaultCredentials);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HttpAuthStaticNetworkContextParams.encodedSize = codec.kStructHeaderSize + 8;

  HttpAuthStaticNetworkContextParams.decode = function(decoder) {
    var packed;
    var val = new HttpAuthStaticNetworkContextParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.allowDefaultCredentials =
        decoder.decodeStruct(new codec.Enum(default_credentials$.DefaultCredentials));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HttpAuthStaticNetworkContextParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HttpAuthStaticNetworkContextParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.allowDefaultCredentials);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContextFilePaths(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContextFilePaths.prototype.initDefaults_ = function() {
    this.sharedDictionaryDirectory = null;
    this.httpCacheDirectory = null;
    this.noVarySearchDirectory = null;
    this.dataDirectory = null;
    this.unsandboxedDataPath = null;
    this.cookieDatabaseName = null;
    this.deviceBoundSessionsDatabaseName = null;
    this.trustTokenDatabaseName = null;
    this.httpServerPropertiesFileName = null;
    this.transportSecurityPersisterFileName = null;
    this.reportingAndNelStoreDatabaseName = null;
    this.sctAuditingPendingReportsFileName = null;
    this.triggerMigration = false;
  };
  NetworkContextFilePaths.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContextFilePaths.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 144}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextFilePaths.sharedDictionaryDirectory
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, transferable_directory$.TransferableDirectory, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextFilePaths.httpCacheDirectory
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, transferable_directory$.TransferableDirectory, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextFilePaths.noVarySearchDirectory
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 32, transferable_directory$.TransferableDirectory, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextFilePaths.dataDirectory
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 48, transferable_directory$.TransferableDirectory, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextFilePaths.unsandboxedDataPath
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, file_path$.FilePath, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextFilePaths.cookieDatabaseName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, file_path$.FilePath, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextFilePaths.deviceBoundSessionsDatabaseName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, file_path$.FilePath, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextFilePaths.trustTokenDatabaseName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, file_path$.FilePath, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextFilePaths.httpServerPropertiesFileName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 96, file_path$.FilePath, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextFilePaths.transportSecurityPersisterFileName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 104, file_path$.FilePath, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextFilePaths.reportingAndNelStoreDatabaseName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 112, file_path$.FilePath, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextFilePaths.sctAuditingPendingReportsFileName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 120, file_path$.FilePath, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContextFilePaths.encodedSize = codec.kStructHeaderSize + 136;

  NetworkContextFilePaths.decode = function(decoder) {
    var packed;
    var val = new NetworkContextFilePaths();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sharedDictionaryDirectory =
        decoder.decodeStruct(transferable_directory$.TransferableDirectory);
    val.httpCacheDirectory =
        decoder.decodeStruct(transferable_directory$.TransferableDirectory);
    val.noVarySearchDirectory =
        decoder.decodeStruct(transferable_directory$.TransferableDirectory);
    val.dataDirectory =
        decoder.decodeStruct(transferable_directory$.TransferableDirectory);
    val.unsandboxedDataPath =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.cookieDatabaseName =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.deviceBoundSessionsDatabaseName =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.trustTokenDatabaseName =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.httpServerPropertiesFileName =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.transportSecurityPersisterFileName =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.reportingAndNelStoreDatabaseName =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.sctAuditingPendingReportsFileName =
        decoder.decodeStructPointer(file_path$.FilePath);
    packed = decoder.readUint8();
    val.triggerMigration = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContextFilePaths.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContextFilePaths.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(transferable_directory$.TransferableDirectory, val.sharedDictionaryDirectory);
    encoder.encodeStruct(transferable_directory$.TransferableDirectory, val.httpCacheDirectory);
    encoder.encodeStruct(transferable_directory$.TransferableDirectory, val.noVarySearchDirectory);
    encoder.encodeStruct(transferable_directory$.TransferableDirectory, val.dataDirectory);
    encoder.encodeStructPointer(file_path$.FilePath, val.unsandboxedDataPath);
    encoder.encodeStructPointer(file_path$.FilePath, val.cookieDatabaseName);
    encoder.encodeStructPointer(file_path$.FilePath, val.deviceBoundSessionsDatabaseName);
    encoder.encodeStructPointer(file_path$.FilePath, val.trustTokenDatabaseName);
    encoder.encodeStructPointer(file_path$.FilePath, val.httpServerPropertiesFileName);
    encoder.encodeStructPointer(file_path$.FilePath, val.transportSecurityPersisterFileName);
    encoder.encodeStructPointer(file_path$.FilePath, val.reportingAndNelStoreDatabaseName);
    encoder.encodeStructPointer(file_path$.FilePath, val.sctAuditingPendingReportsFileName);
    packed = 0;
    packed |= (val.triggerMigration & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContextParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContextParams.prototype.initDefaults_ = function() {
    this.userAgent = null;
    this.acceptLanguage = null;
    this.enableBrotli = true;
    this.enableZstd = false;
    this.enableReferrers = true;
    this.validateReferrerPolicyOnInitialRequest = true;
    this.enableEncryptedCookies = true;
    this.restoreOldSessionCookies = false;
    this.persistSessionCookies = false;
    this.httpCacheEnabled = true;
    this.disableIdleSocketsCloseOnMemoryPressure = false;
    this.pacQuickCheckEnabled = true;
    this.enableCertificateReporting = false;
    this.enforceChromeCtPolicy = false;
    this.enableDomainReliability = false;
    this.discardDomainReliablityUploads = false;
    this.skipReportingSendPermissionCheck = false;
    this.resetHttpCacheBackend = false;
    this.splitAuthCacheByNetworkAnonymizationKey = false;
    this.requireNetworkAnonymizationKey = false;
    this.blockTrustTokens = false;
    this.sharedDictionaryEnabled = false;
    this.acamPreflightSpecConformant = true;
    this.deviceBoundSessionsEnabled = false;
    this.quic_idle_connection_timeout_seconds_$flag = false;
    this.enableEncryptedHttpCache = false;
    this.proxyResolverFactory = new proxy_resolver$.ProxyResolverFactoryPtr();
    this.httpCacheMaxSize = 0;
    this.httpCacheFileOperationsFactory = new http_cache_backend_file_operations$.HttpCacheBackendFileOperationsFactoryPtr();
    this.initialSslConfig = null;
    this.sslConfigClientReceiver = new bindings.InterfaceRequest();
    this.proxyConfigClientReceiver = new bindings.InterfaceRequest();
    this.initialProxyConfig = null;
    this.initialCustomProxyConfig = null;
    this.customProxyConfigClientReceiver = new bindings.InterfaceRequest();
    this.customProxyConnectionObserverRemote = new CustomProxyConnectionObserverPtr();
    this.proxyConfigPollerClient = new proxy_config_with_annotation$.ProxyConfigPollerClientPtr();
    this.proxyErrorClient = new proxy_config_with_annotation$.ProxyErrorClientPtr();
    this.sctAuditingMode = SCTAuditingMode.kDisabled;
    this.ctPolicy = null;
    this.certVerifierParams = null;
    this.cookieManagerParams = null;
    this.domainReliabilityUploadReporter = null;
    this.reportingDeliveryInterval = null;
    this.corsOriginAccessList = null;
    this.corsExemptHeaderList = null;
    this.hstsPolicyBypassList = null;
    this.httpAuthStaticNetworkContextParams = null;
    this.filePaths = null;
    this.sharedDictionaryCacheMaxSize = 0;
    this.firstPartySetsAccessDelegateParams = null;
    this.firstPartySetsAccessDelegateReceiver = new bindings.InterfaceRequest();
    this.cookieEncryptionProvider = new cookie_encryption_provider$.CookieEncryptionProviderPtr();
    this.boundNetwork = -1;
    this.enterpriseReportingEndpoints = null;
    this.quic_idle_connection_timeout_seconds_$value = 0;
    this.boundSessionsUnexportableKeyService = new unexportable_key_service$.UnexportableKeyServicePtr();
  };
  NetworkContextParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContextParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 256}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextParams.userAgent
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextParams.acceptLanguage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;






    // validate NetworkContextParams.proxyResolverFactory
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 20, true);
    if (err !== validator.validationError.NONE)
        return err;







    // validate NetworkContextParams.httpCacheFileOperationsFactory
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 32, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkContextParams.initialSslConfig
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, ssl_config$.SSLConfig, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextParams.sslConfigClientReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 48, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextParams.initialProxyConfig
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, proxy_config_with_annotation$.ProxyConfigWithAnnotation, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextParams.proxyConfigClientReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 52, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextParams.initialCustomProxyConfig
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, CustomProxyConfig, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextParams.customProxyConfigClientReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 72, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextParams.customProxyConnectionObserverRemote
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 76, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextParams.proxyConfigPollerClient
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 84, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextParams.proxyErrorClient
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 92, true);
    if (err !== validator.validationError.NONE)
        return err;





    // validate NetworkContextParams.sctAuditingMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 100, SCTAuditingMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextParams.ctPolicy
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 104, ct_policy$.CTPolicy, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextParams.certVerifierParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 112, CertVerifierServiceRemoteParams, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextParams.cookieManagerParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 120, cookie_manager$.CookieManagerParams, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkContextParams.domainReliabilityUploadReporter
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 128, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkContextParams.reportingDeliveryInterval
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 136, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkContextParams.corsOriginAccessList
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 144, 8, new codec.PointerTo(cors_origin_pattern$.CorsOriginAccessPatterns), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextParams.corsExemptHeaderList
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 152, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextParams.hstsPolicyBypassList
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 160, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextParams.httpAuthStaticNetworkContextParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 168, HttpAuthStaticNetworkContextParams, true);
    if (err !== validator.validationError.NONE)
        return err;





    // validate NetworkContextParams.filePaths
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 176, NetworkContextFilePaths, true);
    if (err !== validator.validationError.NONE)
        return err;





    // validate NetworkContextParams.firstPartySetsAccessDelegateParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 192, first_party_sets_access_delegate$.FirstPartySetsAccessDelegateParams, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContextParams.firstPartySetsAccessDelegateReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 200, true)
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkContextParams.cookieEncryptionProvider
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 204, true);
    if (err !== validator.validationError.NONE)
        return err;




    // validate NetworkContextParams.enterpriseReportingEndpoints
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 224, true, codec.String, new codec.PointerTo(url$.Url), false);
    if (err !== validator.validationError.NONE)
        return err;





    // validate NetworkContextParams.boundSessionsUnexportableKeyService
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 240, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContextParams.encodedSize = codec.kStructHeaderSize + 248;

  NetworkContextParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContextParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.userAgent =
        decoder.decodeStruct(codec.String);
    val.acceptLanguage =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.enableBrotli = (packed >> 0) & 1 ? true : false;
    val.enableZstd = (packed >> 1) & 1 ? true : false;
    val.enableReferrers = (packed >> 2) & 1 ? true : false;
    val.validateReferrerPolicyOnInitialRequest = (packed >> 3) & 1 ? true : false;
    val.enableEncryptedCookies = (packed >> 4) & 1 ? true : false;
    val.restoreOldSessionCookies = (packed >> 5) & 1 ? true : false;
    val.persistSessionCookies = (packed >> 6) & 1 ? true : false;
    val.httpCacheEnabled = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.disableIdleSocketsCloseOnMemoryPressure = (packed >> 0) & 1 ? true : false;
    val.pacQuickCheckEnabled = (packed >> 1) & 1 ? true : false;
    val.enableCertificateReporting = (packed >> 2) & 1 ? true : false;
    val.enforceChromeCtPolicy = (packed >> 3) & 1 ? true : false;
    val.enableDomainReliability = (packed >> 4) & 1 ? true : false;
    val.discardDomainReliablityUploads = (packed >> 5) & 1 ? true : false;
    val.skipReportingSendPermissionCheck = (packed >> 6) & 1 ? true : false;
    val.resetHttpCacheBackend = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.splitAuthCacheByNetworkAnonymizationKey = (packed >> 0) & 1 ? true : false;
    val.requireNetworkAnonymizationKey = (packed >> 1) & 1 ? true : false;
    val.blockTrustTokens = (packed >> 2) & 1 ? true : false;
    val.sharedDictionaryEnabled = (packed >> 3) & 1 ? true : false;
    val.acamPreflightSpecConformant = (packed >> 4) & 1 ? true : false;
    val.deviceBoundSessionsEnabled = (packed >> 5) & 1 ? true : false;
    val.quic_idle_connection_timeout_seconds_$flag = (packed >> 6) & 1 ? true : false;
    val.enableEncryptedHttpCache = (packed >> 7) & 1 ? true : false;
    decoder.skip(1);
    val.proxyResolverFactory =
        decoder.decodeStruct(new codec.NullableInterface(proxy_resolver$.ProxyResolverFactoryPtr));
    val.httpCacheMaxSize =
        decoder.decodeStruct(codec.Int32);
    val.httpCacheFileOperationsFactory =
        decoder.decodeStruct(new codec.NullableInterface(http_cache_backend_file_operations$.HttpCacheBackendFileOperationsFactoryPtr));
    val.initialSslConfig =
        decoder.decodeStructPointer(ssl_config$.SSLConfig);
    val.sslConfigClientReceiver =
        decoder.decodeStruct(codec.NullableInterfaceRequest);
    val.proxyConfigClientReceiver =
        decoder.decodeStruct(codec.NullableInterfaceRequest);
    val.initialProxyConfig =
        decoder.decodeStructPointer(proxy_config_with_annotation$.ProxyConfigWithAnnotation);
    val.initialCustomProxyConfig =
        decoder.decodeStructPointer(CustomProxyConfig);
    val.customProxyConfigClientReceiver =
        decoder.decodeStruct(codec.NullableInterfaceRequest);
    val.customProxyConnectionObserverRemote =
        decoder.decodeStruct(new codec.NullableInterface(CustomProxyConnectionObserverPtr));
    val.proxyConfigPollerClient =
        decoder.decodeStruct(new codec.NullableInterface(proxy_config_with_annotation$.ProxyConfigPollerClientPtr));
    val.proxyErrorClient =
        decoder.decodeStruct(new codec.NullableInterface(proxy_config_with_annotation$.ProxyErrorClientPtr));
    val.sctAuditingMode =
        decoder.decodeStruct(new codec.Enum(SCTAuditingMode));
    val.ctPolicy =
        decoder.decodeStructPointer(ct_policy$.CTPolicy);
    val.certVerifierParams =
        decoder.decodeStructPointer(CertVerifierServiceRemoteParams);
    val.cookieManagerParams =
        decoder.decodeStructPointer(cookie_manager$.CookieManagerParams);
    val.domainReliabilityUploadReporter =
        decoder.decodeStruct(codec.String);
    val.reportingDeliveryInterval =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.corsOriginAccessList =
        decoder.decodeArrayPointer(new codec.PointerTo(cors_origin_pattern$.CorsOriginAccessPatterns));
    val.corsExemptHeaderList =
        decoder.decodeArrayPointer(codec.String);
    val.hstsPolicyBypassList =
        decoder.decodeArrayPointer(codec.String);
    val.httpAuthStaticNetworkContextParams =
        decoder.decodeStructPointer(HttpAuthStaticNetworkContextParams);
    val.filePaths =
        decoder.decodeStructPointer(NetworkContextFilePaths);
    val.sharedDictionaryCacheMaxSize =
        decoder.decodeStruct(codec.Uint64);
    val.firstPartySetsAccessDelegateParams =
        decoder.decodeStructPointer(first_party_sets_access_delegate$.FirstPartySetsAccessDelegateParams);
    val.firstPartySetsAccessDelegateReceiver =
        decoder.decodeStruct(codec.NullableInterfaceRequest);
    val.cookieEncryptionProvider =
        decoder.decodeStruct(new codec.NullableInterface(cookie_encryption_provider$.CookieEncryptionProviderPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.boundNetwork =
        decoder.decodeStruct(codec.Int64);
    val.enterpriseReportingEndpoints =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(url$.Url));
    val.quic_idle_connection_timeout_seconds_$value =
        decoder.decodeStruct(codec.Int64);
    val.boundSessionsUnexportableKeyService =
        decoder.decodeStruct(new codec.NullableInterface(unexportable_key_service$.UnexportableKeyServicePtr));
    return val;
  };

  NetworkContextParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContextParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.userAgent);
    encoder.encodeStruct(codec.String, val.acceptLanguage);
    packed = 0;
    packed |= (val.enableBrotli & 1) << 0
    packed |= (val.enableZstd & 1) << 1
    packed |= (val.enableReferrers & 1) << 2
    packed |= (val.validateReferrerPolicyOnInitialRequest & 1) << 3
    packed |= (val.enableEncryptedCookies & 1) << 4
    packed |= (val.restoreOldSessionCookies & 1) << 5
    packed |= (val.persistSessionCookies & 1) << 6
    packed |= (val.httpCacheEnabled & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.disableIdleSocketsCloseOnMemoryPressure & 1) << 0
    packed |= (val.pacQuickCheckEnabled & 1) << 1
    packed |= (val.enableCertificateReporting & 1) << 2
    packed |= (val.enforceChromeCtPolicy & 1) << 3
    packed |= (val.enableDomainReliability & 1) << 4
    packed |= (val.discardDomainReliablityUploads & 1) << 5
    packed |= (val.skipReportingSendPermissionCheck & 1) << 6
    packed |= (val.resetHttpCacheBackend & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.splitAuthCacheByNetworkAnonymizationKey & 1) << 0
    packed |= (val.requireNetworkAnonymizationKey & 1) << 1
    packed |= (val.blockTrustTokens & 1) << 2
    packed |= (val.sharedDictionaryEnabled & 1) << 3
    packed |= (val.acamPreflightSpecConformant & 1) << 4
    packed |= (val.deviceBoundSessionsEnabled & 1) << 5
    packed |= (val.quic_idle_connection_timeout_seconds_$flag & 1) << 6
    packed |= (val.enableEncryptedHttpCache & 1) << 7
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(new codec.NullableInterface(proxy_resolver$.ProxyResolverFactoryPtr), val.proxyResolverFactory);
    encoder.encodeStruct(codec.Int32, val.httpCacheMaxSize);
    encoder.encodeStruct(new codec.NullableInterface(http_cache_backend_file_operations$.HttpCacheBackendFileOperationsFactoryPtr), val.httpCacheFileOperationsFactory);
    encoder.encodeStructPointer(ssl_config$.SSLConfig, val.initialSslConfig);
    encoder.encodeStruct(codec.NullableInterfaceRequest, val.sslConfigClientReceiver);
    encoder.encodeStruct(codec.NullableInterfaceRequest, val.proxyConfigClientReceiver);
    encoder.encodeStructPointer(proxy_config_with_annotation$.ProxyConfigWithAnnotation, val.initialProxyConfig);
    encoder.encodeStructPointer(CustomProxyConfig, val.initialCustomProxyConfig);
    encoder.encodeStruct(codec.NullableInterfaceRequest, val.customProxyConfigClientReceiver);
    encoder.encodeStruct(new codec.NullableInterface(CustomProxyConnectionObserverPtr), val.customProxyConnectionObserverRemote);
    encoder.encodeStruct(new codec.NullableInterface(proxy_config_with_annotation$.ProxyConfigPollerClientPtr), val.proxyConfigPollerClient);
    encoder.encodeStruct(new codec.NullableInterface(proxy_config_with_annotation$.ProxyErrorClientPtr), val.proxyErrorClient);
    encoder.encodeStruct(codec.Int32, val.sctAuditingMode);
    encoder.encodeStructPointer(ct_policy$.CTPolicy, val.ctPolicy);
    encoder.encodeStructPointer(CertVerifierServiceRemoteParams, val.certVerifierParams);
    encoder.encodeStructPointer(cookie_manager$.CookieManagerParams, val.cookieManagerParams);
    encoder.encodeStruct(codec.String, val.domainReliabilityUploadReporter);
    encoder.encodeStructPointer(time$.TimeDelta, val.reportingDeliveryInterval);
    encoder.encodeArrayPointer(new codec.PointerTo(cors_origin_pattern$.CorsOriginAccessPatterns), val.corsOriginAccessList);
    encoder.encodeArrayPointer(codec.String, val.corsExemptHeaderList);
    encoder.encodeArrayPointer(codec.String, val.hstsPolicyBypassList);
    encoder.encodeStructPointer(HttpAuthStaticNetworkContextParams, val.httpAuthStaticNetworkContextParams);
    encoder.encodeStructPointer(NetworkContextFilePaths, val.filePaths);
    encoder.encodeStruct(codec.Uint64, val.sharedDictionaryCacheMaxSize);
    encoder.encodeStructPointer(first_party_sets_access_delegate$.FirstPartySetsAccessDelegateParams, val.firstPartySetsAccessDelegateParams);
    encoder.encodeStruct(codec.NullableInterfaceRequest, val.firstPartySetsAccessDelegateReceiver);
    encoder.encodeStruct(new codec.NullableInterface(cookie_encryption_provider$.CookieEncryptionProviderPtr), val.cookieEncryptionProvider);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int64, val.boundNetwork);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(url$.Url), val.enterpriseReportingEndpoints);
    encoder.encodeStruct(codec.Int64, val.quic_idle_connection_timeout_seconds_$value);
    encoder.encodeStruct(new codec.NullableInterface(unexportable_key_service$.UnexportableKeyServicePtr), val.boundSessionsUnexportableKeyService);
  };
  function NetworkConditions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkConditions.prototype.initDefaults_ = function() {
    this.offline = false;
    this.packetReordering = false;
    this.packetQueueLength = 0;
    this.latency = null;
    this.downloadThroughput = 0;
    this.uploadThroughput = 0;
    this.packetLoss = 0;
    this.ruleId = null;
  };
  NetworkConditions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkConditions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkConditions.latency
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;







    // validate NetworkConditions.ruleId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkConditions.encodedSize = codec.kStructHeaderSize + 48;

  NetworkConditions.decode = function(decoder) {
    var packed;
    var val = new NetworkConditions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.offline = (packed >> 0) & 1 ? true : false;
    val.packetReordering = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.packetQueueLength =
        decoder.decodeStruct(codec.Int32);
    val.latency =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.downloadThroughput =
        decoder.decodeStruct(codec.Double);
    val.uploadThroughput =
        decoder.decodeStruct(codec.Double);
    val.packetLoss =
        decoder.decodeStruct(codec.Double);
    val.ruleId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  NetworkConditions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkConditions.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.offline & 1) << 0
    packed |= (val.packetReordering & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.packetQueueLength);
    encoder.encodeStructPointer(time$.TimeDelta, val.latency);
    encoder.encodeStruct(codec.Double, val.downloadThroughput);
    encoder.encodeStruct(codec.Double, val.uploadThroughput);
    encoder.encodeStruct(codec.Double, val.packetLoss);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.ruleId);
  };
  function MatchedNetworkConditions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MatchedNetworkConditions.prototype.initDefaults_ = function() {
    this.pattern = null;
    this.conditions = null;
  };
  MatchedNetworkConditions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MatchedNetworkConditions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MatchedNetworkConditions.pattern
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MatchedNetworkConditions.conditions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, NetworkConditions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MatchedNetworkConditions.encodedSize = codec.kStructHeaderSize + 16;

  MatchedNetworkConditions.decode = function(decoder) {
    var packed;
    var val = new MatchedNetworkConditions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pattern =
        decoder.decodeStruct(codec.String);
    val.conditions =
        decoder.decodeStructPointer(NetworkConditions);
    return val;
  };

  MatchedNetworkConditions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MatchedNetworkConditions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.pattern);
    encoder.encodeStructPointer(NetworkConditions, val.conditions);
  };
  function NetworkDurableMessageConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkDurableMessageConfig.prototype.initDefaults_ = function() {
    this.httpStorageMaxSize = 0;
  };
  NetworkDurableMessageConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkDurableMessageConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkDurableMessageConfig.encodedSize = codec.kStructHeaderSize + 8;

  NetworkDurableMessageConfig.decode = function(decoder) {
    var packed;
    var val = new NetworkDurableMessageConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.httpStorageMaxSize =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  NetworkDurableMessageConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkDurableMessageConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.httpStorageMaxSize);
  };
  function SharedDictionaryInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedDictionaryInfo.prototype.initDefaults_ = function() {
    this.match = null;
    this.matchDest = null;
    this.id = null;
    this.dictionaryUrl = null;
    this.lastFetchTime = null;
    this.responseTime = null;
    this.expiration = null;
    this.lastUsedTime = null;
    this.size = 0;
    this.hash = null;
  };
  SharedDictionaryInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedDictionaryInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 88}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedDictionaryInfo.match
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedDictionaryInfo.matchDest
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 4, new codec.Enum(fetch_api$.RequestDestination), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedDictionaryInfo.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedDictionaryInfo.dictionaryUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedDictionaryInfo.lastFetchTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedDictionaryInfo.responseTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedDictionaryInfo.expiration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedDictionaryInfo.lastUsedTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SharedDictionaryInfo.hash
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, hash_value$.SHA256HashValue, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedDictionaryInfo.encodedSize = codec.kStructHeaderSize + 80;

  SharedDictionaryInfo.decode = function(decoder) {
    var packed;
    var val = new SharedDictionaryInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.match =
        decoder.decodeStruct(codec.String);
    val.matchDest =
        decoder.decodeArrayPointer(new codec.Enum(fetch_api$.RequestDestination));
    val.id =
        decoder.decodeStruct(codec.String);
    val.dictionaryUrl =
        decoder.decodeStructPointer(url$.Url);
    val.lastFetchTime =
        decoder.decodeStructPointer(time$.Time);
    val.responseTime =
        decoder.decodeStructPointer(time$.Time);
    val.expiration =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.lastUsedTime =
        decoder.decodeStructPointer(time$.Time);
    val.size =
        decoder.decodeStruct(codec.Uint64);
    val.hash =
        decoder.decodeStructPointer(hash_value$.SHA256HashValue);
    return val;
  };

  SharedDictionaryInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedDictionaryInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.match);
    encoder.encodeArrayPointer(new codec.Enum(fetch_api$.RequestDestination), val.matchDest);
    encoder.encodeStruct(codec.String, val.id);
    encoder.encodeStructPointer(url$.Url, val.dictionaryUrl);
    encoder.encodeStructPointer(time$.Time, val.lastFetchTime);
    encoder.encodeStructPointer(time$.Time, val.responseTime);
    encoder.encodeStructPointer(time$.TimeDelta, val.expiration);
    encoder.encodeStructPointer(time$.Time, val.lastUsedTime);
    encoder.encodeStruct(codec.Uint64, val.size);
    encoder.encodeStructPointer(hash_value$.SHA256HashValue, val.hash);
  };
  function SignedExchangeReport(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SignedExchangeReport.prototype.initDefaults_ = function() {
    this.success = false;
    this.statusCode = 0;
    this.type = null;
    this.outerUrl = null;
    this.innerUrl = null;
    this.certUrl = null;
    this.referrer = null;
    this.serverIpAddress = null;
    this.protocol = null;
    this.method = null;
    this.elapsedTime = null;
  };
  SignedExchangeReport.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SignedExchangeReport.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 88}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SignedExchangeReport.type
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SignedExchangeReport.outerUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SignedExchangeReport.innerUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SignedExchangeReport.certUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SignedExchangeReport.referrer
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SignedExchangeReport.serverIpAddress
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, ip_address$.IPAddress, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SignedExchangeReport.protocol
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 56, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SignedExchangeReport.method
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 64, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate SignedExchangeReport.elapsedTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SignedExchangeReport.encodedSize = codec.kStructHeaderSize + 80;

  SignedExchangeReport.decode = function(decoder) {
    var packed;
    var val = new SignedExchangeReport();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.statusCode =
        decoder.decodeStruct(codec.Int32);
    val.type =
        decoder.decodeStruct(codec.String);
    val.outerUrl =
        decoder.decodeStructPointer(url$.Url);
    val.innerUrl =
        decoder.decodeStructPointer(url$.Url);
    val.certUrl =
        decoder.decodeStructPointer(url$.Url);
    val.referrer =
        decoder.decodeStruct(codec.String);
    val.serverIpAddress =
        decoder.decodeStructPointer(ip_address$.IPAddress);
    val.protocol =
        decoder.decodeStruct(codec.String);
    val.method =
        decoder.decodeStruct(codec.String);
    val.elapsedTime =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  SignedExchangeReport.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SignedExchangeReport.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.statusCode);
    encoder.encodeStruct(codec.String, val.type);
    encoder.encodeStructPointer(url$.Url, val.outerUrl);
    encoder.encodeStructPointer(url$.Url, val.innerUrl);
    encoder.encodeStructPointer(url$.Url, val.certUrl);
    encoder.encodeStruct(codec.String, val.referrer);
    encoder.encodeStructPointer(ip_address$.IPAddress, val.serverIpAddress);
    encoder.encodeStruct(codec.String, val.protocol);
    encoder.encodeStruct(codec.String, val.method);
    encoder.encodeStructPointer(time$.TimeDelta, val.elapsedTime);
  };
  function URLLoaderFactoryOverride(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderFactoryOverride.prototype.initDefaults_ = function() {
    this.overridingFactory = new url_loader_factory$.URLLoaderFactoryPtr();
    this.overriddenFactoryReceiver = new bindings.InterfaceRequest();
    this.skipCorsEnabledSchemeCheck = false;
  };
  URLLoaderFactoryOverride.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderFactoryOverride.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactoryOverride.overridingFactory
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactoryOverride.overriddenFactoryReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  URLLoaderFactoryOverride.encodedSize = codec.kStructHeaderSize + 16;

  URLLoaderFactoryOverride.decode = function(decoder) {
    var packed;
    var val = new URLLoaderFactoryOverride();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.overridingFactory =
        decoder.decodeStruct(new codec.Interface(url_loader_factory$.URLLoaderFactoryPtr));
    val.overriddenFactoryReceiver =
        decoder.decodeStruct(codec.NullableInterfaceRequest);
    packed = decoder.readUint8();
    val.skipCorsEnabledSchemeCheck = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  URLLoaderFactoryOverride.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderFactoryOverride.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(url_loader_factory$.URLLoaderFactoryPtr), val.overridingFactory);
    encoder.encodeStruct(codec.NullableInterfaceRequest, val.overriddenFactoryReceiver);
    packed = 0;
    packed |= (val.skipCorsEnabledSchemeCheck & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function URLLoaderFactoryParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderFactoryParams.prototype.initDefaults_ = function() {
    this.processId = INVALID_PROCESS_ID;
    this.isOrbEnabled = true;
    this.ignoreIsolatedWorldOrigin = true;
    this.unsafeNonWebbyInitiator = false;
    this.disableWebSecurity = false;
    this.disableSecureDns = false;
    this.isTrusted = false;
    this.automaticallyAssignIsolationInfo = false;
    this.requireCrossSiteRequestForCookies = false;
    this.ignoreFactoryReset = false;
    this.isMainFrameOriginRecentlyAccessed = false;
    this.requestInitiatorOriginLock = null;
    this.headerClient = new TrustedURLLoaderHeaderClientPtr();
    this.isolationInfo = null;
    this.topFrameId = null;
    this.factoryOverride = null;
    this.clientSecurityState = null;
    this.coepReporter = new cross_origin_embedder_policy$.CrossOriginEmbedderPolicyReporterPtr();
    this.dipReporter = new document_isolation_policy$.DocumentIsolationPolicyReporterPtr();
    this.cookieObserver = new cookie_access_observer$.CookieAccessObserverPtr();
    this.trustTokenObserver = new trust_token_access_observer$.TrustTokenAccessObserverPtr();
    this.sharedDictionaryObserver = new shared_dictionary_access_observer$.SharedDictionaryAccessObserverPtr();
    this.urlLoaderNetworkObserver = new url_loader_network_service_observer$.URLLoaderNetworkServiceObserverPtr();
    this.devtoolsObserver = new devtools_observer$.DevToolsObserverPtr();
    this.deviceBoundSessionObserver = new device_bound_sessions$.DeviceBoundSessionAccessObserverPtr();
    this.trustTokenIssuancePolicy = TrustTokenOperationPolicyVerdict.kPotentiallyPermit;
    this.trustTokenRedemptionPolicy = TrustTokenOperationPolicyVerdict.kPotentiallyPermit;
    this.debugTag = "";
    this.cookieSettingOverrides = null;
    this.devtoolsCookieSettingOverrides = null;
    this.networkRestrictionsId = null;
  };
  URLLoaderFactoryParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderFactoryParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 168}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate URLLoaderFactoryParams.requestInitiatorOriginLock
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, origin$.Origin, true);
    if (err !== validator.validationError.NONE)
        return err;






    // validate URLLoaderFactoryParams.headerClient
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactoryParams.isolationInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, isolation_info$.IsolationInfo, false);
    if (err !== validator.validationError.NONE)
        return err;





    // validate URLLoaderFactoryParams.topFrameId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactoryParams.factoryOverride
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, URLLoaderFactoryOverride, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactoryParams.clientSecurityState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, client_security_state$.ClientSecurityState, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactoryParams.coepReporter
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 56, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactoryParams.dipReporter
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 64, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactoryParams.cookieObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 72, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactoryParams.trustTokenObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 80, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactoryParams.sharedDictionaryObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 88, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactoryParams.urlLoaderNetworkObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 96, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactoryParams.devtoolsObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 104, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactoryParams.deviceBoundSessionObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 112, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactoryParams.trustTokenIssuancePolicy
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 120, TrustTokenOperationPolicyVerdict);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactoryParams.trustTokenRedemptionPolicy
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 124, TrustTokenOperationPolicyVerdict);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactoryParams.debugTag
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 128, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactoryParams.cookieSettingOverrides
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 136, cookie_setting_overrides$.CookieSettingOverrides, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderFactoryParams.devtoolsCookieSettingOverrides
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 144, cookie_setting_overrides$.CookieSettingOverrides, false);
    if (err !== validator.validationError.NONE)
        return err;





    // validate URLLoaderFactoryParams.networkRestrictionsId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 152, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderFactoryParams.encodedSize = codec.kStructHeaderSize + 160;

  URLLoaderFactoryParams.decode = function(decoder) {
    var packed;
    var val = new URLLoaderFactoryParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.processId =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.isOrbEnabled = (packed >> 0) & 1 ? true : false;
    val.ignoreIsolatedWorldOrigin = (packed >> 1) & 1 ? true : false;
    val.unsafeNonWebbyInitiator = (packed >> 2) & 1 ? true : false;
    val.disableWebSecurity = (packed >> 3) & 1 ? true : false;
    val.disableSecureDns = (packed >> 4) & 1 ? true : false;
    val.isTrusted = (packed >> 5) & 1 ? true : false;
    val.automaticallyAssignIsolationInfo = (packed >> 6) & 1 ? true : false;
    val.requireCrossSiteRequestForCookies = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.ignoreFactoryReset = (packed >> 0) & 1 ? true : false;
    val.isMainFrameOriginRecentlyAccessed = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    val.requestInitiatorOriginLock =
        decoder.decodeStructPointer(origin$.Origin);
    val.headerClient =
        decoder.decodeStruct(new codec.NullableInterface(TrustedURLLoaderHeaderClientPtr));
    val.isolationInfo =
        decoder.decodeStructPointer(isolation_info$.IsolationInfo);
    val.topFrameId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.factoryOverride =
        decoder.decodeStructPointer(URLLoaderFactoryOverride);
    val.clientSecurityState =
        decoder.decodeStructPointer(client_security_state$.ClientSecurityState);
    val.coepReporter =
        decoder.decodeStruct(new codec.NullableInterface(cross_origin_embedder_policy$.CrossOriginEmbedderPolicyReporterPtr));
    val.dipReporter =
        decoder.decodeStruct(new codec.NullableInterface(document_isolation_policy$.DocumentIsolationPolicyReporterPtr));
    val.cookieObserver =
        decoder.decodeStruct(new codec.NullableInterface(cookie_access_observer$.CookieAccessObserverPtr));
    val.trustTokenObserver =
        decoder.decodeStruct(new codec.NullableInterface(trust_token_access_observer$.TrustTokenAccessObserverPtr));
    val.sharedDictionaryObserver =
        decoder.decodeStruct(new codec.NullableInterface(shared_dictionary_access_observer$.SharedDictionaryAccessObserverPtr));
    val.urlLoaderNetworkObserver =
        decoder.decodeStruct(new codec.NullableInterface(url_loader_network_service_observer$.URLLoaderNetworkServiceObserverPtr));
    val.devtoolsObserver =
        decoder.decodeStruct(new codec.NullableInterface(devtools_observer$.DevToolsObserverPtr));
    val.deviceBoundSessionObserver =
        decoder.decodeStruct(new codec.NullableInterface(device_bound_sessions$.DeviceBoundSessionAccessObserverPtr));
    val.trustTokenIssuancePolicy =
        decoder.decodeStruct(new codec.Enum(TrustTokenOperationPolicyVerdict));
    val.trustTokenRedemptionPolicy =
        decoder.decodeStruct(new codec.Enum(TrustTokenOperationPolicyVerdict));
    val.debugTag =
        decoder.decodeStruct(codec.String);
    val.cookieSettingOverrides =
        decoder.decodeStructPointer(cookie_setting_overrides$.CookieSettingOverrides);
    val.devtoolsCookieSettingOverrides =
        decoder.decodeStructPointer(cookie_setting_overrides$.CookieSettingOverrides);
    val.networkRestrictionsId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  URLLoaderFactoryParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderFactoryParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.processId);
    packed = 0;
    packed |= (val.isOrbEnabled & 1) << 0
    packed |= (val.ignoreIsolatedWorldOrigin & 1) << 1
    packed |= (val.unsafeNonWebbyInitiator & 1) << 2
    packed |= (val.disableWebSecurity & 1) << 3
    packed |= (val.disableSecureDns & 1) << 4
    packed |= (val.isTrusted & 1) << 5
    packed |= (val.automaticallyAssignIsolationInfo & 1) << 6
    packed |= (val.requireCrossSiteRequestForCookies & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.ignoreFactoryReset & 1) << 0
    packed |= (val.isMainFrameOriginRecentlyAccessed & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(origin$.Origin, val.requestInitiatorOriginLock);
    encoder.encodeStruct(new codec.NullableInterface(TrustedURLLoaderHeaderClientPtr), val.headerClient);
    encoder.encodeStructPointer(isolation_info$.IsolationInfo, val.isolationInfo);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.topFrameId);
    encoder.encodeStructPointer(URLLoaderFactoryOverride, val.factoryOverride);
    encoder.encodeStructPointer(client_security_state$.ClientSecurityState, val.clientSecurityState);
    encoder.encodeStruct(new codec.NullableInterface(cross_origin_embedder_policy$.CrossOriginEmbedderPolicyReporterPtr), val.coepReporter);
    encoder.encodeStruct(new codec.NullableInterface(document_isolation_policy$.DocumentIsolationPolicyReporterPtr), val.dipReporter);
    encoder.encodeStruct(new codec.NullableInterface(cookie_access_observer$.CookieAccessObserverPtr), val.cookieObserver);
    encoder.encodeStruct(new codec.NullableInterface(trust_token_access_observer$.TrustTokenAccessObserverPtr), val.trustTokenObserver);
    encoder.encodeStruct(new codec.NullableInterface(shared_dictionary_access_observer$.SharedDictionaryAccessObserverPtr), val.sharedDictionaryObserver);
    encoder.encodeStruct(new codec.NullableInterface(url_loader_network_service_observer$.URLLoaderNetworkServiceObserverPtr), val.urlLoaderNetworkObserver);
    encoder.encodeStruct(new codec.NullableInterface(devtools_observer$.DevToolsObserverPtr), val.devtoolsObserver);
    encoder.encodeStruct(new codec.NullableInterface(device_bound_sessions$.DeviceBoundSessionAccessObserverPtr), val.deviceBoundSessionObserver);
    encoder.encodeStruct(codec.Int32, val.trustTokenIssuancePolicy);
    encoder.encodeStruct(codec.Int32, val.trustTokenRedemptionPolicy);
    encoder.encodeStruct(codec.String, val.debugTag);
    encoder.encodeStructPointer(cookie_setting_overrides$.CookieSettingOverrides, val.cookieSettingOverrides);
    encoder.encodeStructPointer(cookie_setting_overrides$.CookieSettingOverrides, val.devtoolsCookieSettingOverrides);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.networkRestrictionsId);
  };
  function NonceAndAllowlistedPatterns(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NonceAndAllowlistedPatterns.prototype.initDefaults_ = function() {
    this.nonce = null;
    this.allowlistedPatterns = null;
  };
  NonceAndAllowlistedPatterns.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NonceAndAllowlistedPatterns.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NonceAndAllowlistedPatterns.nonce
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NonceAndAllowlistedPatterns.allowlistedPatterns
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NonceAndAllowlistedPatterns.encodedSize = codec.kStructHeaderSize + 16;

  NonceAndAllowlistedPatterns.decode = function(decoder) {
    var packed;
    var val = new NonceAndAllowlistedPatterns();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.nonce =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.allowlistedPatterns =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  NonceAndAllowlistedPatterns.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NonceAndAllowlistedPatterns.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.nonce);
    encoder.encodeArrayPointer(codec.String, val.allowlistedPatterns);
  };
  function CustomProxyConnectionObserver_OnFallback_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CustomProxyConnectionObserver_OnFallback_Params.prototype.initDefaults_ = function() {
    this.badChain = null;
    this.netError = 0;
  };
  CustomProxyConnectionObserver_OnFallback_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CustomProxyConnectionObserver_OnFallback_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CustomProxyConnectionObserver_OnFallback_Params.badChain
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, network_param$.ProxyChain, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CustomProxyConnectionObserver_OnFallback_Params.encodedSize = codec.kStructHeaderSize + 16;

  CustomProxyConnectionObserver_OnFallback_Params.decode = function(decoder) {
    var packed;
    var val = new CustomProxyConnectionObserver_OnFallback_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.badChain =
        decoder.decodeStructPointer(network_param$.ProxyChain);
    val.netError =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CustomProxyConnectionObserver_OnFallback_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CustomProxyConnectionObserver_OnFallback_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(network_param$.ProxyChain, val.badChain);
    encoder.encodeStruct(codec.Int32, val.netError);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params.prototype.initDefaults_ = function() {
    this.proxyChain = null;
    this.chainIndex = 0;
    this.responseHeaders = null;
  };
  CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params.proxyChain
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, network_param$.ProxyChain, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params.responseHeaders
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, network_param$.HttpResponseHeaders, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params.encodedSize = codec.kStructHeaderSize + 24;

  CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params.decode = function(decoder) {
    var packed;
    var val = new CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.proxyChain =
        decoder.decodeStructPointer(network_param$.ProxyChain);
    val.chainIndex =
        decoder.decodeStruct(codec.Uint64);
    val.responseHeaders =
        decoder.decodeStructPointer(network_param$.HttpResponseHeaders);
    return val;
  };

  CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(network_param$.ProxyChain, val.proxyChain);
    encoder.encodeStruct(codec.Uint64, val.chainIndex);
    encoder.encodeStructPointer(network_param$.HttpResponseHeaders, val.responseHeaders);
  };
  function CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params.prototype.initDefaults_ = function() {
    this.proxyConfig = null;
  };
  CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params.proxyConfig
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, CustomProxyConfig, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params.encodedSize = codec.kStructHeaderSize + 8;

  CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params.decode = function(decoder) {
    var packed;
    var val = new CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.proxyConfig =
        decoder.decodeStructPointer(CustomProxyConfig);
    return val;
  };

  CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(CustomProxyConfig, val.proxyConfig);
  };
  function CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams.prototype.initDefaults_ = function() {
  };
  CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function TrustedHeaderClient_OnBeforeSendHeaders_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TrustedHeaderClient_OnBeforeSendHeaders_Params.prototype.initDefaults_ = function() {
    this.headers = null;
  };
  TrustedHeaderClient_OnBeforeSendHeaders_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TrustedHeaderClient_OnBeforeSendHeaders_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TrustedHeaderClient_OnBeforeSendHeaders_Params.headers
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, http_request_headers$.HttpRequestHeaders, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TrustedHeaderClient_OnBeforeSendHeaders_Params.encodedSize = codec.kStructHeaderSize + 8;

  TrustedHeaderClient_OnBeforeSendHeaders_Params.decode = function(decoder) {
    var packed;
    var val = new TrustedHeaderClient_OnBeforeSendHeaders_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.headers =
        decoder.decodeStructPointer(http_request_headers$.HttpRequestHeaders);
    return val;
  };

  TrustedHeaderClient_OnBeforeSendHeaders_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TrustedHeaderClient_OnBeforeSendHeaders_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(http_request_headers$.HttpRequestHeaders, val.headers);
  };
  function TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.headers = null;
  };
  TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams.headers
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, http_request_headers$.HttpRequestHeaders, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.headers =
        decoder.decodeStructPointer(http_request_headers$.HttpRequestHeaders);
    return val;
  };

  TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(http_request_headers$.HttpRequestHeaders, val.headers);
  };
  function TrustedHeaderClient_OnHeadersReceived_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TrustedHeaderClient_OnHeadersReceived_Params.prototype.initDefaults_ = function() {
    this.headers = null;
    this.remoteEndpoint = null;
    this.sslInfo = null;
  };
  TrustedHeaderClient_OnHeadersReceived_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TrustedHeaderClient_OnHeadersReceived_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TrustedHeaderClient_OnHeadersReceived_Params.headers
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate TrustedHeaderClient_OnHeadersReceived_Params.remoteEndpoint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ip_endpoint$.IPEndPoint, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TrustedHeaderClient_OnHeadersReceived_Params.sslInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, network_param$.SSLInfo, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TrustedHeaderClient_OnHeadersReceived_Params.encodedSize = codec.kStructHeaderSize + 24;

  TrustedHeaderClient_OnHeadersReceived_Params.decode = function(decoder) {
    var packed;
    var val = new TrustedHeaderClient_OnHeadersReceived_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.headers =
        decoder.decodeStruct(codec.String);
    val.remoteEndpoint =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    val.sslInfo =
        decoder.decodeStructPointer(network_param$.SSLInfo);
    return val;
  };

  TrustedHeaderClient_OnHeadersReceived_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TrustedHeaderClient_OnHeadersReceived_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.headers);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.remoteEndpoint);
    encoder.encodeStructPointer(network_param$.SSLInfo, val.sslInfo);
  };
  function TrustedHeaderClient_OnHeadersReceived_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TrustedHeaderClient_OnHeadersReceived_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.headers = null;
    this.preserveFragmentOnRedirectUrl = null;
  };
  TrustedHeaderClient_OnHeadersReceived_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TrustedHeaderClient_OnHeadersReceived_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate TrustedHeaderClient_OnHeadersReceived_ResponseParams.headers
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate TrustedHeaderClient_OnHeadersReceived_ResponseParams.preserveFragmentOnRedirectUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TrustedHeaderClient_OnHeadersReceived_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  TrustedHeaderClient_OnHeadersReceived_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new TrustedHeaderClient_OnHeadersReceived_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.headers =
        decoder.decodeStruct(codec.String);
    val.preserveFragmentOnRedirectUrl =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  TrustedHeaderClient_OnHeadersReceived_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TrustedHeaderClient_OnHeadersReceived_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.headers);
    encoder.encodeStructPointer(url$.Url, val.preserveFragmentOnRedirectUrl);
  };
  function TrustedURLLoaderHeaderClient_OnLoaderCreated_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TrustedURLLoaderHeaderClient_OnLoaderCreated_Params.prototype.initDefaults_ = function() {
    this.requestId = 0;
    this.headerClient = new bindings.InterfaceRequest();
  };
  TrustedURLLoaderHeaderClient_OnLoaderCreated_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TrustedURLLoaderHeaderClient_OnLoaderCreated_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate TrustedURLLoaderHeaderClient_OnLoaderCreated_Params.headerClient
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 4, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TrustedURLLoaderHeaderClient_OnLoaderCreated_Params.encodedSize = codec.kStructHeaderSize + 8;

  TrustedURLLoaderHeaderClient_OnLoaderCreated_Params.decode = function(decoder) {
    var packed;
    var val = new TrustedURLLoaderHeaderClient_OnLoaderCreated_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    val.headerClient =
        decoder.decodeStruct(codec.InterfaceRequest);
    return val;
  };

  TrustedURLLoaderHeaderClient_OnLoaderCreated_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TrustedURLLoaderHeaderClient_OnLoaderCreated_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.requestId);
    encoder.encodeStruct(codec.InterfaceRequest, val.headerClient);
  };
  function TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params.prototype.initDefaults_ = function() {
    this.request = null;
    this.headerClient = new bindings.InterfaceRequest();
  };
  TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url_request$.URLRequest, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params.headerClient
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params.encodedSize = codec.kStructHeaderSize + 16;

  TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params.decode = function(decoder) {
    var packed;
    var val = new TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.request =
        decoder.decodeStructPointer(url_request$.URLRequest);
    val.headerClient =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url_request$.URLRequest, val.request);
    encoder.encodeStruct(codec.InterfaceRequest, val.headerClient);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DurableMessageCollector_Configure_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DurableMessageCollector_Configure_Params.prototype.initDefaults_ = function() {
    this.config = null;
  };
  DurableMessageCollector_Configure_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DurableMessageCollector_Configure_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DurableMessageCollector_Configure_Params.config
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, NetworkDurableMessageConfig, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DurableMessageCollector_Configure_Params.encodedSize = codec.kStructHeaderSize + 8;

  DurableMessageCollector_Configure_Params.decode = function(decoder) {
    var packed;
    var val = new DurableMessageCollector_Configure_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.config =
        decoder.decodeStructPointer(NetworkDurableMessageConfig);
    return val;
  };

  DurableMessageCollector_Configure_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DurableMessageCollector_Configure_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(NetworkDurableMessageConfig, val.config);
  };
  function DurableMessageCollector_Retrieve_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DurableMessageCollector_Retrieve_Params.prototype.initDefaults_ = function() {
    this.devtoolsRequestId = null;
  };
  DurableMessageCollector_Retrieve_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DurableMessageCollector_Retrieve_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DurableMessageCollector_Retrieve_Params.devtoolsRequestId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DurableMessageCollector_Retrieve_Params.encodedSize = codec.kStructHeaderSize + 8;

  DurableMessageCollector_Retrieve_Params.decode = function(decoder) {
    var packed;
    var val = new DurableMessageCollector_Retrieve_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.devtoolsRequestId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  DurableMessageCollector_Retrieve_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DurableMessageCollector_Retrieve_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.devtoolsRequestId);
  };
  function DurableMessageCollector_Retrieve_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DurableMessageCollector_Retrieve_ResponseParams.prototype.initDefaults_ = function() {
    this.message = null;
  };
  DurableMessageCollector_Retrieve_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DurableMessageCollector_Retrieve_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DurableMessageCollector_Retrieve_ResponseParams.message
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, big_buffer$.BigBuffer, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DurableMessageCollector_Retrieve_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  DurableMessageCollector_Retrieve_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DurableMessageCollector_Retrieve_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.message =
        decoder.decodeStruct(big_buffer$.BigBuffer);
    return val;
  };

  DurableMessageCollector_Retrieve_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DurableMessageCollector_Retrieve_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(big_buffer$.BigBuffer, val.message);
  };
  function NetworkContext_SetClient_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_SetClient_Params.prototype.initDefaults_ = function() {
    this.client = new network_context_client$.NetworkContextClientPtr();
  };
  NetworkContext_SetClient_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_SetClient_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_SetClient_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_SetClient_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_SetClient_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_SetClient_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(new codec.Interface(network_context_client$.NetworkContextClientPtr));
    return val;
  };

  NetworkContext_SetClient_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_SetClient_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(network_context_client$.NetworkContextClientPtr), val.client);
  };
  function NetworkContext_CreateURLLoaderFactory_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CreateURLLoaderFactory_Params.prototype.initDefaults_ = function() {
    this.urlLoaderFactory = new bindings.InterfaceRequest();
    this.params = null;
  };
  NetworkContext_CreateURLLoaderFactory_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CreateURLLoaderFactory_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateURLLoaderFactory_Params.urlLoaderFactory
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateURLLoaderFactory_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, URLLoaderFactoryParams, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CreateURLLoaderFactory_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_CreateURLLoaderFactory_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CreateURLLoaderFactory_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.urlLoaderFactory =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.params =
        decoder.decodeStructPointer(URLLoaderFactoryParams);
    return val;
  };

  NetworkContext_CreateURLLoaderFactory_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CreateURLLoaderFactory_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.urlLoaderFactory);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(URLLoaderFactoryParams, val.params);
  };
  function NetworkContext_ResetURLLoaderFactories_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ResetURLLoaderFactories_Params.prototype.initDefaults_ = function() {
  };
  NetworkContext_ResetURLLoaderFactories_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ResetURLLoaderFactories_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ResetURLLoaderFactories_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ResetURLLoaderFactories_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ResetURLLoaderFactories_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ResetURLLoaderFactories_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ResetURLLoaderFactories_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_GetViaObliviousHttp_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetViaObliviousHttp_Params.prototype.initDefaults_ = function() {
    this.request = null;
    this.client = new oblivious_http_request$.ObliviousHttpClientPtr();
  };
  NetworkContext_GetViaObliviousHttp_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetViaObliviousHttp_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetViaObliviousHttp_Params.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, oblivious_http_request$.ObliviousHttpRequest, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetViaObliviousHttp_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetViaObliviousHttp_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_GetViaObliviousHttp_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetViaObliviousHttp_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.request =
        decoder.decodeStructPointer(oblivious_http_request$.ObliviousHttpRequest);
    val.client =
        decoder.decodeStruct(new codec.Interface(oblivious_http_request$.ObliviousHttpClientPtr));
    return val;
  };

  NetworkContext_GetViaObliviousHttp_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetViaObliviousHttp_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(oblivious_http_request$.ObliviousHttpRequest, val.request);
    encoder.encodeStruct(new codec.Interface(oblivious_http_request$.ObliviousHttpClientPtr), val.client);
  };
  function NetworkContext_GetCookieManager_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetCookieManager_Params.prototype.initDefaults_ = function() {
    this.cookieManager = new bindings.InterfaceRequest();
  };
  NetworkContext_GetCookieManager_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetCookieManager_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetCookieManager_Params.cookieManager
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetCookieManager_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_GetCookieManager_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetCookieManager_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cookieManager =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_GetCookieManager_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetCookieManager_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.cookieManager);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_GetRestrictedCookieManager_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetRestrictedCookieManager_Params.prototype.initDefaults_ = function() {
    this.restrictedCookieManager = new bindings.InterfaceRequest();
    this.role = 0;
    this.origin = null;
    this.isolationInfo = null;
    this.cookieSettingOverrides = null;
    this.devtoolsCookieSettingOverrides = null;
    this.cookieObserver = new cookie_access_observer$.CookieAccessObserverPtr();
  };
  NetworkContext_GetRestrictedCookieManager_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetRestrictedCookieManager_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetRestrictedCookieManager_Params.restrictedCookieManager
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetRestrictedCookieManager_Params.role
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, restricted_cookie_manager$.RestrictedCookieManagerRole);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetRestrictedCookieManager_Params.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetRestrictedCookieManager_Params.isolationInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, isolation_info$.IsolationInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetRestrictedCookieManager_Params.cookieSettingOverrides
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, cookie_setting_overrides$.CookieSettingOverrides, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetRestrictedCookieManager_Params.devtoolsCookieSettingOverrides
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, cookie_setting_overrides$.CookieSettingOverrides, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetRestrictedCookieManager_Params.cookieObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 40, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetRestrictedCookieManager_Params.encodedSize = codec.kStructHeaderSize + 48;

  NetworkContext_GetRestrictedCookieManager_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetRestrictedCookieManager_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.restrictedCookieManager =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.role =
        decoder.decodeStruct(new codec.Enum(restricted_cookie_manager$.RestrictedCookieManagerRole));
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    val.isolationInfo =
        decoder.decodeStructPointer(isolation_info$.IsolationInfo);
    val.cookieSettingOverrides =
        decoder.decodeStructPointer(cookie_setting_overrides$.CookieSettingOverrides);
    val.devtoolsCookieSettingOverrides =
        decoder.decodeStructPointer(cookie_setting_overrides$.CookieSettingOverrides);
    val.cookieObserver =
        decoder.decodeStruct(new codec.NullableInterface(cookie_access_observer$.CookieAccessObserverPtr));
    return val;
  };

  NetworkContext_GetRestrictedCookieManager_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetRestrictedCookieManager_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.restrictedCookieManager);
    encoder.encodeStruct(codec.Int32, val.role);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
    encoder.encodeStructPointer(isolation_info$.IsolationInfo, val.isolationInfo);
    encoder.encodeStructPointer(cookie_setting_overrides$.CookieSettingOverrides, val.cookieSettingOverrides);
    encoder.encodeStructPointer(cookie_setting_overrides$.CookieSettingOverrides, val.devtoolsCookieSettingOverrides);
    encoder.encodeStruct(new codec.NullableInterface(cookie_access_observer$.CookieAccessObserverPtr), val.cookieObserver);
  };
  function NetworkContext_GetTrustTokenQueryAnswerer_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetTrustTokenQueryAnswerer_Params.prototype.initDefaults_ = function() {
    this.trustTokenQueryAnswerer = new bindings.InterfaceRequest();
    this.topFrameOrigin = null;
  };
  NetworkContext_GetTrustTokenQueryAnswerer_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetTrustTokenQueryAnswerer_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetTrustTokenQueryAnswerer_Params.trustTokenQueryAnswerer
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetTrustTokenQueryAnswerer_Params.topFrameOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetTrustTokenQueryAnswerer_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_GetTrustTokenQueryAnswerer_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetTrustTokenQueryAnswerer_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.trustTokenQueryAnswerer =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.topFrameOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    return val;
  };

  NetworkContext_GetTrustTokenQueryAnswerer_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetTrustTokenQueryAnswerer_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.trustTokenQueryAnswerer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(origin$.Origin, val.topFrameOrigin);
  };
  function NetworkContext_ClearTrustTokenData_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearTrustTokenData_Params.prototype.initDefaults_ = function() {
    this.filter = null;
  };
  NetworkContext_ClearTrustTokenData_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearTrustTokenData_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearTrustTokenData_Params.filter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, clear_data_filter$.ClearDataFilter, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearTrustTokenData_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_ClearTrustTokenData_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearTrustTokenData_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.filter =
        decoder.decodeStructPointer(clear_data_filter$.ClearDataFilter);
    return val;
  };

  NetworkContext_ClearTrustTokenData_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearTrustTokenData_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(clear_data_filter$.ClearDataFilter, val.filter);
  };
  function NetworkContext_ClearTrustTokenData_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearTrustTokenData_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_ClearTrustTokenData_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearTrustTokenData_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearTrustTokenData_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ClearTrustTokenData_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearTrustTokenData_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ClearTrustTokenData_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearTrustTokenData_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_ClearTrustTokenSessionOnlyData_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearTrustTokenSessionOnlyData_Params.prototype.initDefaults_ = function() {
  };
  NetworkContext_ClearTrustTokenSessionOnlyData_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearTrustTokenSessionOnlyData_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearTrustTokenSessionOnlyData_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ClearTrustTokenSessionOnlyData_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearTrustTokenSessionOnlyData_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ClearTrustTokenSessionOnlyData_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearTrustTokenSessionOnlyData_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams.prototype.initDefaults_ = function() {
    this.anyDataDeleted = false;
  };
  NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.anyDataDeleted = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.anyDataDeleted & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_GetStoredTrustTokenCounts_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetStoredTrustTokenCounts_Params.prototype.initDefaults_ = function() {
  };
  NetworkContext_GetStoredTrustTokenCounts_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetStoredTrustTokenCounts_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetStoredTrustTokenCounts_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_GetStoredTrustTokenCounts_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetStoredTrustTokenCounts_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_GetStoredTrustTokenCounts_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetStoredTrustTokenCounts_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_GetStoredTrustTokenCounts_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetStoredTrustTokenCounts_ResponseParams.prototype.initDefaults_ = function() {
    this.tokens = null;
  };
  NetworkContext_GetStoredTrustTokenCounts_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetStoredTrustTokenCounts_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetStoredTrustTokenCounts_ResponseParams.tokens
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(trust_tokens$.StoredTrustTokensForIssuer), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetStoredTrustTokenCounts_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_GetStoredTrustTokenCounts_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetStoredTrustTokenCounts_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tokens =
        decoder.decodeArrayPointer(new codec.PointerTo(trust_tokens$.StoredTrustTokensForIssuer));
    return val;
  };

  NetworkContext_GetStoredTrustTokenCounts_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetStoredTrustTokenCounts_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(trust_tokens$.StoredTrustTokensForIssuer), val.tokens);
  };
  function NetworkContext_GetPrivateStateTokenRedemptionRecords_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetPrivateStateTokenRedemptionRecords_Params.prototype.initDefaults_ = function() {
  };
  NetworkContext_GetPrivateStateTokenRedemptionRecords_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetPrivateStateTokenRedemptionRecords_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetPrivateStateTokenRedemptionRecords_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_GetPrivateStateTokenRedemptionRecords_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetPrivateStateTokenRedemptionRecords_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_GetPrivateStateTokenRedemptionRecords_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetPrivateStateTokenRedemptionRecords_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams.prototype.initDefaults_ = function() {
    this.issuerRedemptionRecordMap = null;
  };
  NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams.issuerRedemptionRecordMap
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, new codec.PointerTo(origin$.Origin), new codec.ArrayOf(new codec.PointerTo(trust_tokens$.ToplevelRedemptionRecord)), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.issuerRedemptionRecordMap =
        decoder.decodeMapPointer(new codec.PointerTo(origin$.Origin), new codec.ArrayOf(new codec.PointerTo(trust_tokens$.ToplevelRedemptionRecord)));
    return val;
  };

  NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(new codec.PointerTo(origin$.Origin), new codec.ArrayOf(new codec.PointerTo(trust_tokens$.ToplevelRedemptionRecord)), val.issuerRedemptionRecordMap);
  };
  function NetworkContext_DeleteStoredTrustTokens_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_DeleteStoredTrustTokens_Params.prototype.initDefaults_ = function() {
    this.issuer = null;
  };
  NetworkContext_DeleteStoredTrustTokens_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_DeleteStoredTrustTokens_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_DeleteStoredTrustTokens_Params.issuer
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_DeleteStoredTrustTokens_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_DeleteStoredTrustTokens_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_DeleteStoredTrustTokens_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.issuer =
        decoder.decodeStructPointer(origin$.Origin);
    return val;
  };

  NetworkContext_DeleteStoredTrustTokens_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_DeleteStoredTrustTokens_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.issuer);
  };
  function NetworkContext_DeleteStoredTrustTokens_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_DeleteStoredTrustTokens_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  NetworkContext_DeleteStoredTrustTokens_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_DeleteStoredTrustTokens_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_DeleteStoredTrustTokens_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, trust_tokens$.DeleteStoredTrustTokensStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_DeleteStoredTrustTokens_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_DeleteStoredTrustTokens_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_DeleteStoredTrustTokens_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(trust_tokens$.DeleteStoredTrustTokensStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_DeleteStoredTrustTokens_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_DeleteStoredTrustTokens_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_SetBlockTrustTokens_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_SetBlockTrustTokens_Params.prototype.initDefaults_ = function() {
    this.block = false;
  };
  NetworkContext_SetBlockTrustTokens_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_SetBlockTrustTokens_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContext_SetBlockTrustTokens_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_SetBlockTrustTokens_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_SetBlockTrustTokens_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.block = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_SetBlockTrustTokens_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_SetBlockTrustTokens_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.block & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_ClearNetworkingHistoryBetween_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearNetworkingHistoryBetween_Params.prototype.initDefaults_ = function() {
    this.startTime = null;
    this.endTime = null;
  };
  NetworkContext_ClearNetworkingHistoryBetween_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearNetworkingHistoryBetween_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearNetworkingHistoryBetween_Params.startTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearNetworkingHistoryBetween_Params.endTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearNetworkingHistoryBetween_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_ClearNetworkingHistoryBetween_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearNetworkingHistoryBetween_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.startTime =
        decoder.decodeStructPointer(time$.Time);
    val.endTime =
        decoder.decodeStructPointer(time$.Time);
    return val;
  };

  NetworkContext_ClearNetworkingHistoryBetween_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearNetworkingHistoryBetween_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.Time, val.startTime);
    encoder.encodeStructPointer(time$.Time, val.endTime);
  };
  function NetworkContext_ClearNetworkingHistoryBetween_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearNetworkingHistoryBetween_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_ClearNetworkingHistoryBetween_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearNetworkingHistoryBetween_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearNetworkingHistoryBetween_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ClearNetworkingHistoryBetween_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearNetworkingHistoryBetween_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ClearNetworkingHistoryBetween_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearNetworkingHistoryBetween_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_ClearHttpCache_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearHttpCache_Params.prototype.initDefaults_ = function() {
    this.startTime = null;
    this.endTime = null;
    this.filter = null;
  };
  NetworkContext_ClearHttpCache_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearHttpCache_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearHttpCache_Params.startTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearHttpCache_Params.endTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearHttpCache_Params.filter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, clear_data_filter$.ClearDataFilter, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearHttpCache_Params.encodedSize = codec.kStructHeaderSize + 24;

  NetworkContext_ClearHttpCache_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearHttpCache_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.startTime =
        decoder.decodeStructPointer(time$.Time);
    val.endTime =
        decoder.decodeStructPointer(time$.Time);
    val.filter =
        decoder.decodeStructPointer(clear_data_filter$.ClearDataFilter);
    return val;
  };

  NetworkContext_ClearHttpCache_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearHttpCache_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.Time, val.startTime);
    encoder.encodeStructPointer(time$.Time, val.endTime);
    encoder.encodeStructPointer(clear_data_filter$.ClearDataFilter, val.filter);
  };
  function NetworkContext_ClearHttpCache_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearHttpCache_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_ClearHttpCache_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearHttpCache_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearHttpCache_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ClearHttpCache_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearHttpCache_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ClearHttpCache_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearHttpCache_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_ComputeHttpCacheSize_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ComputeHttpCacheSize_Params.prototype.initDefaults_ = function() {
    this.startTime = null;
    this.endTime = null;
  };
  NetworkContext_ComputeHttpCacheSize_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ComputeHttpCacheSize_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ComputeHttpCacheSize_Params.startTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ComputeHttpCacheSize_Params.endTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ComputeHttpCacheSize_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_ComputeHttpCacheSize_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ComputeHttpCacheSize_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.startTime =
        decoder.decodeStructPointer(time$.Time);
    val.endTime =
        decoder.decodeStructPointer(time$.Time);
    return val;
  };

  NetworkContext_ComputeHttpCacheSize_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ComputeHttpCacheSize_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.Time, val.startTime);
    encoder.encodeStructPointer(time$.Time, val.endTime);
  };
  function NetworkContext_ComputeHttpCacheSize_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ComputeHttpCacheSize_ResponseParams.prototype.initDefaults_ = function() {
    this.isUpperBound = false;
    this.sizeOrError = 0;
  };
  NetworkContext_ComputeHttpCacheSize_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ComputeHttpCacheSize_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  NetworkContext_ComputeHttpCacheSize_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_ComputeHttpCacheSize_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ComputeHttpCacheSize_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isUpperBound = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.sizeOrError =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  NetworkContext_ComputeHttpCacheSize_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ComputeHttpCacheSize_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isUpperBound & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int64, val.sizeOrError);
  };
  function NetworkContext_NotifyBrowserIdle_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_NotifyBrowserIdle_Params.prototype.initDefaults_ = function() {
  };
  NetworkContext_NotifyBrowserIdle_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_NotifyBrowserIdle_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_NotifyBrowserIdle_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_NotifyBrowserIdle_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_NotifyBrowserIdle_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_NotifyBrowserIdle_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_NotifyBrowserIdle_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_NotifyExternalCacheHit_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_NotifyExternalCacheHit_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.httpMethod = null;
    this.key = null;
    this.includeCredentials = false;
  };
  NetworkContext_NotifyExternalCacheHit_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_NotifyExternalCacheHit_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_NotifyExternalCacheHit_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_NotifyExternalCacheHit_Params.httpMethod
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_NotifyExternalCacheHit_Params.key
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, network_isolation_key$.NetworkIsolationKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContext_NotifyExternalCacheHit_Params.encodedSize = codec.kStructHeaderSize + 40;

  NetworkContext_NotifyExternalCacheHit_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_NotifyExternalCacheHit_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.httpMethod =
        decoder.decodeStruct(codec.String);
    val.key =
        decoder.decodeStruct(network_isolation_key$.NetworkIsolationKey);
    packed = decoder.readUint8();
    val.includeCredentials = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_NotifyExternalCacheHit_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_NotifyExternalCacheHit_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.String, val.httpMethod);
    encoder.encodeStruct(network_isolation_key$.NetworkIsolationKey, val.key);
    packed = 0;
    packed |= (val.includeCredentials & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_ClearHostCache_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearHostCache_Params.prototype.initDefaults_ = function() {
    this.filter = null;
  };
  NetworkContext_ClearHostCache_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearHostCache_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearHostCache_Params.filter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, clear_data_filter$.ClearDataFilter, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearHostCache_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_ClearHostCache_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearHostCache_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.filter =
        decoder.decodeStructPointer(clear_data_filter$.ClearDataFilter);
    return val;
  };

  NetworkContext_ClearHostCache_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearHostCache_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(clear_data_filter$.ClearDataFilter, val.filter);
  };
  function NetworkContext_ClearHostCache_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearHostCache_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_ClearHostCache_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearHostCache_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearHostCache_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ClearHostCache_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearHostCache_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ClearHostCache_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearHostCache_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_ClearHttpAuthCache_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearHttpAuthCache_Params.prototype.initDefaults_ = function() {
    this.startTime = null;
    this.endTime = null;
    this.filter = null;
  };
  NetworkContext_ClearHttpAuthCache_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearHttpAuthCache_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearHttpAuthCache_Params.startTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearHttpAuthCache_Params.endTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearHttpAuthCache_Params.filter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, clear_data_filter$.ClearDataFilter, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearHttpAuthCache_Params.encodedSize = codec.kStructHeaderSize + 24;

  NetworkContext_ClearHttpAuthCache_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearHttpAuthCache_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.startTime =
        decoder.decodeStructPointer(time$.Time);
    val.endTime =
        decoder.decodeStructPointer(time$.Time);
    val.filter =
        decoder.decodeStructPointer(clear_data_filter$.ClearDataFilter);
    return val;
  };

  NetworkContext_ClearHttpAuthCache_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearHttpAuthCache_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.Time, val.startTime);
    encoder.encodeStructPointer(time$.Time, val.endTime);
    encoder.encodeStructPointer(clear_data_filter$.ClearDataFilter, val.filter);
  };
  function NetworkContext_ClearHttpAuthCache_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearHttpAuthCache_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_ClearHttpAuthCache_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearHttpAuthCache_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearHttpAuthCache_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ClearHttpAuthCache_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearHttpAuthCache_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ClearHttpAuthCache_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearHttpAuthCache_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_ClearCorsPreflightCache_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearCorsPreflightCache_Params.prototype.initDefaults_ = function() {
    this.filter = null;
  };
  NetworkContext_ClearCorsPreflightCache_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearCorsPreflightCache_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearCorsPreflightCache_Params.filter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, clear_data_filter$.ClearDataFilter, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearCorsPreflightCache_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_ClearCorsPreflightCache_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearCorsPreflightCache_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.filter =
        decoder.decodeStructPointer(clear_data_filter$.ClearDataFilter);
    return val;
  };

  NetworkContext_ClearCorsPreflightCache_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearCorsPreflightCache_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(clear_data_filter$.ClearDataFilter, val.filter);
  };
  function NetworkContext_ClearCorsPreflightCache_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearCorsPreflightCache_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_ClearCorsPreflightCache_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearCorsPreflightCache_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearCorsPreflightCache_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ClearCorsPreflightCache_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearCorsPreflightCache_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ClearCorsPreflightCache_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearCorsPreflightCache_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_ClearReportingCacheReports_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearReportingCacheReports_Params.prototype.initDefaults_ = function() {
    this.filter = null;
  };
  NetworkContext_ClearReportingCacheReports_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearReportingCacheReports_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearReportingCacheReports_Params.filter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, clear_data_filter$.ClearDataFilter, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearReportingCacheReports_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_ClearReportingCacheReports_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearReportingCacheReports_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.filter =
        decoder.decodeStructPointer(clear_data_filter$.ClearDataFilter);
    return val;
  };

  NetworkContext_ClearReportingCacheReports_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearReportingCacheReports_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(clear_data_filter$.ClearDataFilter, val.filter);
  };
  function NetworkContext_ClearReportingCacheReports_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearReportingCacheReports_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_ClearReportingCacheReports_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearReportingCacheReports_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearReportingCacheReports_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ClearReportingCacheReports_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearReportingCacheReports_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ClearReportingCacheReports_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearReportingCacheReports_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_ClearReportingCacheClients_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearReportingCacheClients_Params.prototype.initDefaults_ = function() {
    this.filter = null;
  };
  NetworkContext_ClearReportingCacheClients_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearReportingCacheClients_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearReportingCacheClients_Params.filter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, clear_data_filter$.ClearDataFilter, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearReportingCacheClients_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_ClearReportingCacheClients_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearReportingCacheClients_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.filter =
        decoder.decodeStructPointer(clear_data_filter$.ClearDataFilter);
    return val;
  };

  NetworkContext_ClearReportingCacheClients_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearReportingCacheClients_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(clear_data_filter$.ClearDataFilter, val.filter);
  };
  function NetworkContext_ClearReportingCacheClients_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearReportingCacheClients_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_ClearReportingCacheClients_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearReportingCacheClients_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearReportingCacheClients_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ClearReportingCacheClients_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearReportingCacheClients_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ClearReportingCacheClients_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearReportingCacheClients_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_ClearNetworkErrorLogging_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearNetworkErrorLogging_Params.prototype.initDefaults_ = function() {
    this.filter = null;
  };
  NetworkContext_ClearNetworkErrorLogging_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearNetworkErrorLogging_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearNetworkErrorLogging_Params.filter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, clear_data_filter$.ClearDataFilter, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearNetworkErrorLogging_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_ClearNetworkErrorLogging_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearNetworkErrorLogging_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.filter =
        decoder.decodeStructPointer(clear_data_filter$.ClearDataFilter);
    return val;
  };

  NetworkContext_ClearNetworkErrorLogging_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearNetworkErrorLogging_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(clear_data_filter$.ClearDataFilter, val.filter);
  };
  function NetworkContext_ClearNetworkErrorLogging_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearNetworkErrorLogging_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_ClearNetworkErrorLogging_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearNetworkErrorLogging_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearNetworkErrorLogging_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ClearNetworkErrorLogging_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearNetworkErrorLogging_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ClearNetworkErrorLogging_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearNetworkErrorLogging_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_ClearDomainReliability_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearDomainReliability_Params.prototype.initDefaults_ = function() {
    this.filter = null;
    this.mode = 0;
  };
  NetworkContext_ClearDomainReliability_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearDomainReliability_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearDomainReliability_Params.filter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, clear_data_filter$.ClearDataFilter, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearDomainReliability_Params.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, NetworkContext.DomainReliabilityClearMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearDomainReliability_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_ClearDomainReliability_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearDomainReliability_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.filter =
        decoder.decodeStructPointer(clear_data_filter$.ClearDataFilter);
    val.mode =
        decoder.decodeStruct(new codec.Enum(NetworkContext.DomainReliabilityClearMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_ClearDomainReliability_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearDomainReliability_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(clear_data_filter$.ClearDataFilter, val.filter);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_ClearDomainReliability_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearDomainReliability_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_ClearDomainReliability_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearDomainReliability_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearDomainReliability_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ClearDomainReliability_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearDomainReliability_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ClearDomainReliability_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearDomainReliability_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_ClearSharedDictionaryCache_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearSharedDictionaryCache_Params.prototype.initDefaults_ = function() {
    this.startTime = null;
    this.endTime = null;
    this.filter = null;
  };
  NetworkContext_ClearSharedDictionaryCache_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearSharedDictionaryCache_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearSharedDictionaryCache_Params.startTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearSharedDictionaryCache_Params.endTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearSharedDictionaryCache_Params.filter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, clear_data_filter$.ClearDataFilter, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearSharedDictionaryCache_Params.encodedSize = codec.kStructHeaderSize + 24;

  NetworkContext_ClearSharedDictionaryCache_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearSharedDictionaryCache_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.startTime =
        decoder.decodeStructPointer(time$.Time);
    val.endTime =
        decoder.decodeStructPointer(time$.Time);
    val.filter =
        decoder.decodeStructPointer(clear_data_filter$.ClearDataFilter);
    return val;
  };

  NetworkContext_ClearSharedDictionaryCache_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearSharedDictionaryCache_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.Time, val.startTime);
    encoder.encodeStructPointer(time$.Time, val.endTime);
    encoder.encodeStructPointer(clear_data_filter$.ClearDataFilter, val.filter);
  };
  function NetworkContext_ClearSharedDictionaryCache_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearSharedDictionaryCache_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_ClearSharedDictionaryCache_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearSharedDictionaryCache_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearSharedDictionaryCache_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ClearSharedDictionaryCache_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearSharedDictionaryCache_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ClearSharedDictionaryCache_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearSharedDictionaryCache_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params.prototype.initDefaults_ = function() {
    this.isolationKey = null;
  };
  NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params.isolationKey
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, shared_dictionary_isolation_key$.SharedDictionaryIsolationKey, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.isolationKey =
        decoder.decodeStructPointer(shared_dictionary_isolation_key$.SharedDictionaryIsolationKey);
    return val;
  };

  NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(shared_dictionary_isolation_key$.SharedDictionaryIsolationKey, val.isolationKey);
  };
  function NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_SetDocumentReportingEndpoints_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_SetDocumentReportingEndpoints_Params.prototype.initDefaults_ = function() {
    this.reportingSource = null;
    this.origin = null;
    this.isolationInfo = null;
    this.endpoints = null;
  };
  NetworkContext_SetDocumentReportingEndpoints_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_SetDocumentReportingEndpoints_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_SetDocumentReportingEndpoints_Params.reportingSource
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_SetDocumentReportingEndpoints_Params.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_SetDocumentReportingEndpoints_Params.isolationInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, isolation_info$.IsolationInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_SetDocumentReportingEndpoints_Params.endpoints
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 24, false, codec.String, codec.String, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_SetDocumentReportingEndpoints_Params.encodedSize = codec.kStructHeaderSize + 32;

  NetworkContext_SetDocumentReportingEndpoints_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_SetDocumentReportingEndpoints_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.reportingSource =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    val.isolationInfo =
        decoder.decodeStructPointer(isolation_info$.IsolationInfo);
    val.endpoints =
        decoder.decodeMapPointer(codec.String, codec.String);
    return val;
  };

  NetworkContext_SetDocumentReportingEndpoints_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_SetDocumentReportingEndpoints_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.reportingSource);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
    encoder.encodeStructPointer(isolation_info$.IsolationInfo, val.isolationInfo);
    encoder.encodeMapPointer(codec.String, codec.String, val.endpoints);
  };
  function NetworkContext_SetEnterpriseReportingEndpoints_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_SetEnterpriseReportingEndpoints_Params.prototype.initDefaults_ = function() {
    this.endpoints = null;
  };
  NetworkContext_SetEnterpriseReportingEndpoints_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_SetEnterpriseReportingEndpoints_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_SetEnterpriseReportingEndpoints_Params.endpoints
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.String, new codec.PointerTo(url$.Url), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_SetEnterpriseReportingEndpoints_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_SetEnterpriseReportingEndpoints_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_SetEnterpriseReportingEndpoints_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.endpoints =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(url$.Url));
    return val;
  };

  NetworkContext_SetEnterpriseReportingEndpoints_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_SetEnterpriseReportingEndpoints_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(url$.Url), val.endpoints);
  };
  function NetworkContext_SendReportsAndRemoveSource_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_SendReportsAndRemoveSource_Params.prototype.initDefaults_ = function() {
    this.reportingSource = null;
  };
  NetworkContext_SendReportsAndRemoveSource_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_SendReportsAndRemoveSource_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_SendReportsAndRemoveSource_Params.reportingSource
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_SendReportsAndRemoveSource_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_SendReportsAndRemoveSource_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_SendReportsAndRemoveSource_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.reportingSource =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  NetworkContext_SendReportsAndRemoveSource_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_SendReportsAndRemoveSource_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.reportingSource);
  };
  function NetworkContext_QueueReport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_QueueReport_Params.prototype.initDefaults_ = function() {
    this.type = null;
    this.group = null;
    this.url = null;
    this.reportingSource = null;
    this.networkAnonymizationKey = null;
    this.body = null;
  };
  NetworkContext_QueueReport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_QueueReport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_QueueReport_Params.type
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_QueueReport_Params.group
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_QueueReport_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_QueueReport_Params.reportingSource
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_QueueReport_Params.networkAnonymizationKey
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 32, network_anonymization_key$.NetworkAnonymizationKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_QueueReport_Params.body
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, values$.DictionaryValue, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_QueueReport_Params.encodedSize = codec.kStructHeaderSize + 56;

  NetworkContext_QueueReport_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_QueueReport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(codec.String);
    val.group =
        decoder.decodeStruct(codec.String);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.reportingSource =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.networkAnonymizationKey =
        decoder.decodeStruct(network_anonymization_key$.NetworkAnonymizationKey);
    val.body =
        decoder.decodeStructPointer(values$.DictionaryValue);
    return val;
  };

  NetworkContext_QueueReport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_QueueReport_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.type);
    encoder.encodeStruct(codec.String, val.group);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.reportingSource);
    encoder.encodeStruct(network_anonymization_key$.NetworkAnonymizationKey, val.networkAnonymizationKey);
    encoder.encodeStructPointer(values$.DictionaryValue, val.body);
  };
  function NetworkContext_QueueEnterpriseReport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_QueueEnterpriseReport_Params.prototype.initDefaults_ = function() {
    this.type = null;
    this.group = null;
    this.url = null;
    this.body = null;
  };
  NetworkContext_QueueEnterpriseReport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_QueueEnterpriseReport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_QueueEnterpriseReport_Params.type
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_QueueEnterpriseReport_Params.group
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_QueueEnterpriseReport_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_QueueEnterpriseReport_Params.body
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, values$.DictionaryValue, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_QueueEnterpriseReport_Params.encodedSize = codec.kStructHeaderSize + 32;

  NetworkContext_QueueEnterpriseReport_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_QueueEnterpriseReport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(codec.String);
    val.group =
        decoder.decodeStruct(codec.String);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.body =
        decoder.decodeStructPointer(values$.DictionaryValue);
    return val;
  };

  NetworkContext_QueueEnterpriseReport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_QueueEnterpriseReport_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.type);
    encoder.encodeStruct(codec.String, val.group);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(values$.DictionaryValue, val.body);
  };
  function NetworkContext_QueueSignedExchangeReport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_QueueSignedExchangeReport_Params.prototype.initDefaults_ = function() {
    this.report = null;
    this.networkAnonymizationKey = null;
  };
  NetworkContext_QueueSignedExchangeReport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_QueueSignedExchangeReport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_QueueSignedExchangeReport_Params.report
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SignedExchangeReport, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_QueueSignedExchangeReport_Params.networkAnonymizationKey
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, network_anonymization_key$.NetworkAnonymizationKey, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_QueueSignedExchangeReport_Params.encodedSize = codec.kStructHeaderSize + 24;

  NetworkContext_QueueSignedExchangeReport_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_QueueSignedExchangeReport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.report =
        decoder.decodeStructPointer(SignedExchangeReport);
    val.networkAnonymizationKey =
        decoder.decodeStruct(network_anonymization_key$.NetworkAnonymizationKey);
    return val;
  };

  NetworkContext_QueueSignedExchangeReport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_QueueSignedExchangeReport_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SignedExchangeReport, val.report);
    encoder.encodeStruct(network_anonymization_key$.NetworkAnonymizationKey, val.networkAnonymizationKey);
  };
  function NetworkContext_CloseAllConnections_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CloseAllConnections_Params.prototype.initDefaults_ = function() {
  };
  NetworkContext_CloseAllConnections_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CloseAllConnections_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CloseAllConnections_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_CloseAllConnections_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CloseAllConnections_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_CloseAllConnections_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CloseAllConnections_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_CloseAllConnections_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CloseAllConnections_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_CloseAllConnections_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CloseAllConnections_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CloseAllConnections_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_CloseAllConnections_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CloseAllConnections_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_CloseAllConnections_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CloseAllConnections_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_CloseIdleConnections_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CloseIdleConnections_Params.prototype.initDefaults_ = function() {
  };
  NetworkContext_CloseIdleConnections_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CloseIdleConnections_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CloseIdleConnections_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_CloseIdleConnections_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CloseIdleConnections_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_CloseIdleConnections_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CloseIdleConnections_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_CloseIdleConnections_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CloseIdleConnections_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_CloseIdleConnections_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CloseIdleConnections_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CloseIdleConnections_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_CloseIdleConnections_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CloseIdleConnections_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_CloseIdleConnections_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CloseIdleConnections_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_SetNetworkConditions_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_SetNetworkConditions_Params.prototype.initDefaults_ = function() {
    this.throttlingProfileId = null;
    this.conditions = null;
  };
  NetworkContext_SetNetworkConditions_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_SetNetworkConditions_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_SetNetworkConditions_Params.throttlingProfileId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_SetNetworkConditions_Params.conditions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(MatchedNetworkConditions), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_SetNetworkConditions_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_SetNetworkConditions_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_SetNetworkConditions_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.throttlingProfileId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.conditions =
        decoder.decodeArrayPointer(new codec.PointerTo(MatchedNetworkConditions));
    return val;
  };

  NetworkContext_SetNetworkConditions_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_SetNetworkConditions_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.throttlingProfileId);
    encoder.encodeArrayPointer(new codec.PointerTo(MatchedNetworkConditions), val.conditions);
  };
  function NetworkContext_EnableDurableMessageCollector_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_EnableDurableMessageCollector_Params.prototype.initDefaults_ = function() {
    this.throttlingProfileId = null;
    this.receiver = new bindings.InterfaceRequest();
  };
  NetworkContext_EnableDurableMessageCollector_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_EnableDurableMessageCollector_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_EnableDurableMessageCollector_Params.throttlingProfileId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_EnableDurableMessageCollector_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_EnableDurableMessageCollector_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_EnableDurableMessageCollector_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_EnableDurableMessageCollector_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.throttlingProfileId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_EnableDurableMessageCollector_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_EnableDurableMessageCollector_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.throttlingProfileId);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_SetAcceptLanguage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_SetAcceptLanguage_Params.prototype.initDefaults_ = function() {
    this.newAcceptLanguage = null;
  };
  NetworkContext_SetAcceptLanguage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_SetAcceptLanguage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_SetAcceptLanguage_Params.newAcceptLanguage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_SetAcceptLanguage_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_SetAcceptLanguage_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_SetAcceptLanguage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.newAcceptLanguage =
        decoder.decodeStruct(codec.String);
    return val;
  };

  NetworkContext_SetAcceptLanguage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_SetAcceptLanguage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.newAcceptLanguage);
  };
  function NetworkContext_SetEnableReferrers_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_SetEnableReferrers_Params.prototype.initDefaults_ = function() {
    this.enableReferrers = false;
  };
  NetworkContext_SetEnableReferrers_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_SetEnableReferrers_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContext_SetEnableReferrers_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_SetEnableReferrers_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_SetEnableReferrers_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.enableReferrers = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_SetEnableReferrers_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_SetEnableReferrers_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.enableReferrers & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_SetCTPolicy_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_SetCTPolicy_Params.prototype.initDefaults_ = function() {
    this.ctPolicy = null;
  };
  NetworkContext_SetCTPolicy_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_SetCTPolicy_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_SetCTPolicy_Params.ctPolicy
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ct_policy$.CTPolicy, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_SetCTPolicy_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_SetCTPolicy_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_SetCTPolicy_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.ctPolicy =
        decoder.decodeStructPointer(ct_policy$.CTPolicy);
    return val;
  };

  NetworkContext_SetCTPolicy_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_SetCTPolicy_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ct_policy$.CTPolicy, val.ctPolicy);
  };
  function NetworkContext_CreateUDPSocket_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CreateUDPSocket_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
    this.listener = new udp_socket$.UDPSocketListenerPtr();
  };
  NetworkContext_CreateUDPSocket_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CreateUDPSocket_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateUDPSocket_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateUDPSocket_Params.listener
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 4, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CreateUDPSocket_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_CreateUDPSocket_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CreateUDPSocket_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.listener =
        decoder.decodeStruct(new codec.NullableInterface(udp_socket$.UDPSocketListenerPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_CreateUDPSocket_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CreateUDPSocket_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.encodeStruct(new codec.NullableInterface(udp_socket$.UDPSocketListenerPtr), val.listener);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_CreateRestrictedUDPSocket_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CreateRestrictedUDPSocket_Params.prototype.initDefaults_ = function() {
    this.addr = null;
    this.mode = 0;
    this.receiver = new bindings.InterfaceRequest();
    this.trafficAnnotation = null;
    this.params = null;
    this.listener = new udp_socket$.UDPSocketListenerPtr();
    this.allowMulticast = false;
  };
  NetworkContext_CreateRestrictedUDPSocket_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CreateRestrictedUDPSocket_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateRestrictedUDPSocket_Params.addr
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ip_endpoint$.IPEndPoint, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateRestrictedUDPSocket_Params.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, restricted_udp_socket$.RestrictedUDPSocketMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateRestrictedUDPSocket_Params.trafficAnnotation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateRestrictedUDPSocket_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, restricted_udp_socket$.RestrictedUDPSocketParams, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateRestrictedUDPSocket_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 12, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateRestrictedUDPSocket_Params.listener
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 32, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContext_CreateRestrictedUDPSocket_Params.encodedSize = codec.kStructHeaderSize + 48;

  NetworkContext_CreateRestrictedUDPSocket_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CreateRestrictedUDPSocket_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.addr =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    val.mode =
        decoder.decodeStruct(new codec.Enum(restricted_udp_socket$.RestrictedUDPSocketMode));
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.trafficAnnotation =
        decoder.decodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag);
    val.params =
        decoder.decodeStructPointer(restricted_udp_socket$.RestrictedUDPSocketParams);
    val.listener =
        decoder.decodeStruct(new codec.NullableInterface(udp_socket$.UDPSocketListenerPtr));
    packed = decoder.readUint8();
    val.allowMulticast = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_CreateRestrictedUDPSocket_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CreateRestrictedUDPSocket_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.addr);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.encodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, val.trafficAnnotation);
    encoder.encodeStructPointer(restricted_udp_socket$.RestrictedUDPSocketParams, val.params);
    encoder.encodeStruct(new codec.NullableInterface(udp_socket$.UDPSocketListenerPtr), val.listener);
    packed = 0;
    packed |= (val.allowMulticast & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_CreateRestrictedUDPSocket_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CreateRestrictedUDPSocket_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.localAddrOut = null;
  };
  NetworkContext_CreateRestrictedUDPSocket_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CreateRestrictedUDPSocket_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkContext_CreateRestrictedUDPSocket_ResponseParams.localAddrOut
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ip_endpoint$.IPEndPoint, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CreateRestrictedUDPSocket_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_CreateRestrictedUDPSocket_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CreateRestrictedUDPSocket_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.localAddrOut =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    return val;
  };

  NetworkContext_CreateRestrictedUDPSocket_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CreateRestrictedUDPSocket_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.localAddrOut);
  };
  function NetworkContext_CreateTCPServerSocket_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CreateTCPServerSocket_Params.prototype.initDefaults_ = function() {
    this.localAddr = null;
    this.options = null;
    this.trafficAnnotation = null;
    this.socket = new bindings.InterfaceRequest();
  };
  NetworkContext_CreateTCPServerSocket_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CreateTCPServerSocket_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateTCPServerSocket_Params.localAddr
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ip_endpoint$.IPEndPoint, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateTCPServerSocket_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, tcp_socket$.TCPServerSocketOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateTCPServerSocket_Params.trafficAnnotation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateTCPServerSocket_Params.socket
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CreateTCPServerSocket_Params.encodedSize = codec.kStructHeaderSize + 32;

  NetworkContext_CreateTCPServerSocket_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CreateTCPServerSocket_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.localAddr =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    val.options =
        decoder.decodeStructPointer(tcp_socket$.TCPServerSocketOptions);
    val.trafficAnnotation =
        decoder.decodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag);
    val.socket =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_CreateTCPServerSocket_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CreateTCPServerSocket_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.localAddr);
    encoder.encodeStructPointer(tcp_socket$.TCPServerSocketOptions, val.options);
    encoder.encodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, val.trafficAnnotation);
    encoder.encodeStruct(codec.InterfaceRequest, val.socket);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_CreateTCPServerSocket_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CreateTCPServerSocket_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.localAddrOut = null;
  };
  NetworkContext_CreateTCPServerSocket_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CreateTCPServerSocket_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkContext_CreateTCPServerSocket_ResponseParams.localAddrOut
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ip_endpoint$.IPEndPoint, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CreateTCPServerSocket_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_CreateTCPServerSocket_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CreateTCPServerSocket_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.localAddrOut =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    return val;
  };

  NetworkContext_CreateTCPServerSocket_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CreateTCPServerSocket_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.localAddrOut);
  };
  function NetworkContext_CreateTCPConnectedSocket_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CreateTCPConnectedSocket_Params.prototype.initDefaults_ = function() {
    this.localAddr = null;
    this.remoteAddrList = null;
    this.tcpConnectedSocketOptions = null;
    this.trafficAnnotation = null;
    this.socket = new bindings.InterfaceRequest();
    this.observer = new tcp_socket$.SocketObserverPtr();
  };
  NetworkContext_CreateTCPConnectedSocket_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CreateTCPConnectedSocket_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateTCPConnectedSocket_Params.localAddr
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ip_endpoint$.IPEndPoint, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateTCPConnectedSocket_Params.remoteAddrList
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, address_list$.AddressList, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateTCPConnectedSocket_Params.tcpConnectedSocketOptions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, tcp_socket$.TCPConnectedSocketOptions, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateTCPConnectedSocket_Params.trafficAnnotation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateTCPConnectedSocket_Params.socket
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 32, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateTCPConnectedSocket_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 36, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CreateTCPConnectedSocket_Params.encodedSize = codec.kStructHeaderSize + 48;

  NetworkContext_CreateTCPConnectedSocket_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CreateTCPConnectedSocket_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.localAddr =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    val.remoteAddrList =
        decoder.decodeStructPointer(address_list$.AddressList);
    val.tcpConnectedSocketOptions =
        decoder.decodeStructPointer(tcp_socket$.TCPConnectedSocketOptions);
    val.trafficAnnotation =
        decoder.decodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag);
    val.socket =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.observer =
        decoder.decodeStruct(new codec.NullableInterface(tcp_socket$.SocketObserverPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_CreateTCPConnectedSocket_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CreateTCPConnectedSocket_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.localAddr);
    encoder.encodeStructPointer(address_list$.AddressList, val.remoteAddrList);
    encoder.encodeStructPointer(tcp_socket$.TCPConnectedSocketOptions, val.tcpConnectedSocketOptions);
    encoder.encodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, val.trafficAnnotation);
    encoder.encodeStruct(codec.InterfaceRequest, val.socket);
    encoder.encodeStruct(new codec.NullableInterface(tcp_socket$.SocketObserverPtr), val.observer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_CreateTCPConnectedSocket_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CreateTCPConnectedSocket_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.receiveStream = null;
    this.localAddr = null;
    this.peerAddr = null;
    this.sendStream = null;
  };
  NetworkContext_CreateTCPConnectedSocket_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CreateTCPConnectedSocket_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkContext_CreateTCPConnectedSocket_ResponseParams.localAddr
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ip_endpoint$.IPEndPoint, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateTCPConnectedSocket_ResponseParams.peerAddr
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, ip_endpoint$.IPEndPoint, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateTCPConnectedSocket_ResponseParams.receiveStream
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 4, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateTCPConnectedSocket_ResponseParams.sendStream
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CreateTCPConnectedSocket_ResponseParams.encodedSize = codec.kStructHeaderSize + 32;

  NetworkContext_CreateTCPConnectedSocket_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CreateTCPConnectedSocket_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.Int32);
    val.receiveStream =
        decoder.decodeStruct(codec.Handle);
    val.localAddr =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    val.peerAddr =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    val.sendStream =
        decoder.decodeStruct(codec.Handle);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_CreateTCPConnectedSocket_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CreateTCPConnectedSocket_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.encodeStruct(codec.Handle, val.receiveStream);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.localAddr);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.peerAddr);
    encoder.encodeStruct(codec.Handle, val.sendStream);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_CreateTCPBoundSocket_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CreateTCPBoundSocket_Params.prototype.initDefaults_ = function() {
    this.localAddr = null;
    this.trafficAnnotation = null;
    this.socket = new bindings.InterfaceRequest();
  };
  NetworkContext_CreateTCPBoundSocket_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CreateTCPBoundSocket_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateTCPBoundSocket_Params.localAddr
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ip_endpoint$.IPEndPoint, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateTCPBoundSocket_Params.trafficAnnotation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateTCPBoundSocket_Params.socket
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CreateTCPBoundSocket_Params.encodedSize = codec.kStructHeaderSize + 24;

  NetworkContext_CreateTCPBoundSocket_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CreateTCPBoundSocket_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.localAddr =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    val.trafficAnnotation =
        decoder.decodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag);
    val.socket =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_CreateTCPBoundSocket_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CreateTCPBoundSocket_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.localAddr);
    encoder.encodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, val.trafficAnnotation);
    encoder.encodeStruct(codec.InterfaceRequest, val.socket);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_CreateTCPBoundSocket_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CreateTCPBoundSocket_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.localAddr = null;
  };
  NetworkContext_CreateTCPBoundSocket_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CreateTCPBoundSocket_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkContext_CreateTCPBoundSocket_ResponseParams.localAddr
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ip_endpoint$.IPEndPoint, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CreateTCPBoundSocket_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_CreateTCPBoundSocket_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CreateTCPBoundSocket_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.localAddr =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    return val;
  };

  NetworkContext_CreateTCPBoundSocket_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CreateTCPBoundSocket_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.localAddr);
  };
  function NetworkContext_CreateProxyResolvingSocketFactory_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CreateProxyResolvingSocketFactory_Params.prototype.initDefaults_ = function() {
    this.factory = new bindings.InterfaceRequest();
  };
  NetworkContext_CreateProxyResolvingSocketFactory_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CreateProxyResolvingSocketFactory_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateProxyResolvingSocketFactory_Params.factory
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CreateProxyResolvingSocketFactory_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_CreateProxyResolvingSocketFactory_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CreateProxyResolvingSocketFactory_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.factory =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_CreateProxyResolvingSocketFactory_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CreateProxyResolvingSocketFactory_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.factory);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_LookUpProxyForURL_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_LookUpProxyForURL_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.networkAnonymizationKey = null;
    this.proxyLookupClient = new proxy_lookup_client$.ProxyLookupClientPtr();
  };
  NetworkContext_LookUpProxyForURL_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_LookUpProxyForURL_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_LookUpProxyForURL_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_LookUpProxyForURL_Params.networkAnonymizationKey
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, network_anonymization_key$.NetworkAnonymizationKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_LookUpProxyForURL_Params.proxyLookupClient
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 24, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_LookUpProxyForURL_Params.encodedSize = codec.kStructHeaderSize + 32;

  NetworkContext_LookUpProxyForURL_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_LookUpProxyForURL_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.networkAnonymizationKey =
        decoder.decodeStruct(network_anonymization_key$.NetworkAnonymizationKey);
    val.proxyLookupClient =
        decoder.decodeStruct(new codec.Interface(proxy_lookup_client$.ProxyLookupClientPtr));
    return val;
  };

  NetworkContext_LookUpProxyForURL_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_LookUpProxyForURL_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(network_anonymization_key$.NetworkAnonymizationKey, val.networkAnonymizationKey);
    encoder.encodeStruct(new codec.Interface(proxy_lookup_client$.ProxyLookupClientPtr), val.proxyLookupClient);
  };
  function NetworkContext_ForceReloadProxyConfig_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ForceReloadProxyConfig_Params.prototype.initDefaults_ = function() {
  };
  NetworkContext_ForceReloadProxyConfig_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ForceReloadProxyConfig_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ForceReloadProxyConfig_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ForceReloadProxyConfig_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ForceReloadProxyConfig_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ForceReloadProxyConfig_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ForceReloadProxyConfig_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_ForceReloadProxyConfig_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ForceReloadProxyConfig_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_ForceReloadProxyConfig_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ForceReloadProxyConfig_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ForceReloadProxyConfig_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ForceReloadProxyConfig_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ForceReloadProxyConfig_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ForceReloadProxyConfig_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ForceReloadProxyConfig_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_ClearBadProxiesCache_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearBadProxiesCache_Params.prototype.initDefaults_ = function() {
  };
  NetworkContext_ClearBadProxiesCache_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearBadProxiesCache_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearBadProxiesCache_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ClearBadProxiesCache_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearBadProxiesCache_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ClearBadProxiesCache_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearBadProxiesCache_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_ClearBadProxiesCache_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearBadProxiesCache_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_ClearBadProxiesCache_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearBadProxiesCache_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearBadProxiesCache_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ClearBadProxiesCache_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearBadProxiesCache_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ClearBadProxiesCache_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearBadProxiesCache_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_CreateWebSocket_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CreateWebSocket_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.requestedProtocols = null;
    this.siteForCookies = null;
    this.storageAccessApiStatus = 0;
    this.processId = 0;
    this.isolationInfo = null;
    this.additionalHeaders = null;
    this.origin = null;
    this.clientSecurityState = null;
    this.options = 0;
    this.trafficAnnotation = null;
    this.handshakeClient = new websocket$.WebSocketHandshakeClientPtr();
    this.urlLoaderNetworkObserver = new url_loader_network_service_observer$.URLLoaderNetworkServiceObserverPtr();
    this.authHandler = new websocket$.WebSocketAuthenticationHandlerPtr();
    this.headerClient = new TrustedHeaderClientPtr();
    this.throttlingProfileId = null;
  };
  NetworkContext_CreateWebSocket_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CreateWebSocket_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 128}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebSocket_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebSocket_Params.requestedProtocols
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebSocket_Params.siteForCookies
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, site_for_cookies$.SiteForCookies, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebSocket_Params.storageAccessApiStatus
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, storage_access_api$.StorageAccessApiStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebSocket_Params.isolationInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, isolation_info$.IsolationInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebSocket_Params.additionalHeaders
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 8, new codec.PointerTo(websocket$.HttpHeader), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkContext_CreateWebSocket_Params.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebSocket_Params.clientSecurityState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, client_security_state$.ClientSecurityState, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkContext_CreateWebSocket_Params.trafficAnnotation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebSocket_Params.handshakeClient
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 80, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebSocket_Params.urlLoaderNetworkObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 88, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebSocket_Params.authHandler
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 96, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebSocket_Params.headerClient
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 104, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebSocket_Params.throttlingProfileId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 112, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CreateWebSocket_Params.encodedSize = codec.kStructHeaderSize + 120;

  NetworkContext_CreateWebSocket_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CreateWebSocket_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.requestedProtocols =
        decoder.decodeArrayPointer(codec.String);
    val.siteForCookies =
        decoder.decodeStructPointer(site_for_cookies$.SiteForCookies);
    val.storageAccessApiStatus =
        decoder.decodeStruct(new codec.Enum(storage_access_api$.StorageAccessApiStatus));
    val.processId =
        decoder.decodeStruct(codec.Int32);
    val.isolationInfo =
        decoder.decodeStructPointer(isolation_info$.IsolationInfo);
    val.additionalHeaders =
        decoder.decodeArrayPointer(new codec.PointerTo(websocket$.HttpHeader));
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    val.clientSecurityState =
        decoder.decodeStructPointer(client_security_state$.ClientSecurityState);
    val.options =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.trafficAnnotation =
        decoder.decodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag);
    val.handshakeClient =
        decoder.decodeStruct(new codec.Interface(websocket$.WebSocketHandshakeClientPtr));
    val.urlLoaderNetworkObserver =
        decoder.decodeStruct(new codec.NullableInterface(url_loader_network_service_observer$.URLLoaderNetworkServiceObserverPtr));
    val.authHandler =
        decoder.decodeStruct(new codec.NullableInterface(websocket$.WebSocketAuthenticationHandlerPtr));
    val.headerClient =
        decoder.decodeStruct(new codec.NullableInterface(TrustedHeaderClientPtr));
    val.throttlingProfileId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  NetworkContext_CreateWebSocket_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CreateWebSocket_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeArrayPointer(codec.String, val.requestedProtocols);
    encoder.encodeStructPointer(site_for_cookies$.SiteForCookies, val.siteForCookies);
    encoder.encodeStruct(codec.Int32, val.storageAccessApiStatus);
    encoder.encodeStruct(codec.Int32, val.processId);
    encoder.encodeStructPointer(isolation_info$.IsolationInfo, val.isolationInfo);
    encoder.encodeArrayPointer(new codec.PointerTo(websocket$.HttpHeader), val.additionalHeaders);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
    encoder.encodeStructPointer(client_security_state$.ClientSecurityState, val.clientSecurityState);
    encoder.encodeStruct(codec.Uint32, val.options);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, val.trafficAnnotation);
    encoder.encodeStruct(new codec.Interface(websocket$.WebSocketHandshakeClientPtr), val.handshakeClient);
    encoder.encodeStruct(new codec.NullableInterface(url_loader_network_service_observer$.URLLoaderNetworkServiceObserverPtr), val.urlLoaderNetworkObserver);
    encoder.encodeStruct(new codec.NullableInterface(websocket$.WebSocketAuthenticationHandlerPtr), val.authHandler);
    encoder.encodeStruct(new codec.NullableInterface(TrustedHeaderClientPtr), val.headerClient);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.throttlingProfileId);
  };
  function NetworkContext_CreateWebTransport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CreateWebTransport_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.origin = null;
    this.networkAnonymizationKey = null;
    this.fingerprints = null;
    this.applicationProtocols = null;
    this.handshakeClient = new web_transport$.WebTransportHandshakeClientPtr();
    this.urlLoaderNetworkObserver = new url_loader_network_service_observer$.URLLoaderNetworkServiceObserverPtr();
    this.clientSecurityState = null;
  };
  NetworkContext_CreateWebTransport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CreateWebTransport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebTransport_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebTransport_Params.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebTransport_Params.networkAnonymizationKey
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, network_anonymization_key$.NetworkAnonymizationKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebTransport_Params.fingerprints
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, new codec.PointerTo(web_transport$.WebTransportCertificateFingerprint), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebTransport_Params.applicationProtocols
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebTransport_Params.handshakeClient
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 48, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebTransport_Params.urlLoaderNetworkObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 56, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateWebTransport_Params.clientSecurityState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, client_security_state$.ClientSecurityState, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CreateWebTransport_Params.encodedSize = codec.kStructHeaderSize + 72;

  NetworkContext_CreateWebTransport_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CreateWebTransport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    val.networkAnonymizationKey =
        decoder.decodeStruct(network_anonymization_key$.NetworkAnonymizationKey);
    val.fingerprints =
        decoder.decodeArrayPointer(new codec.PointerTo(web_transport$.WebTransportCertificateFingerprint));
    val.applicationProtocols =
        decoder.decodeArrayPointer(codec.String);
    val.handshakeClient =
        decoder.decodeStruct(new codec.Interface(web_transport$.WebTransportHandshakeClientPtr));
    val.urlLoaderNetworkObserver =
        decoder.decodeStruct(new codec.NullableInterface(url_loader_network_service_observer$.URLLoaderNetworkServiceObserverPtr));
    val.clientSecurityState =
        decoder.decodeStructPointer(client_security_state$.ClientSecurityState);
    return val;
  };

  NetworkContext_CreateWebTransport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CreateWebTransport_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
    encoder.encodeStruct(network_anonymization_key$.NetworkAnonymizationKey, val.networkAnonymizationKey);
    encoder.encodeArrayPointer(new codec.PointerTo(web_transport$.WebTransportCertificateFingerprint), val.fingerprints);
    encoder.encodeArrayPointer(codec.String, val.applicationProtocols);
    encoder.encodeStruct(new codec.Interface(web_transport$.WebTransportHandshakeClientPtr), val.handshakeClient);
    encoder.encodeStruct(new codec.NullableInterface(url_loader_network_service_observer$.URLLoaderNetworkServiceObserverPtr), val.urlLoaderNetworkObserver);
    encoder.encodeStructPointer(client_security_state$.ClientSecurityState, val.clientSecurityState);
  };
  function NetworkContext_CreateNetLogExporter_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CreateNetLogExporter_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  NetworkContext_CreateNetLogExporter_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CreateNetLogExporter_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateNetLogExporter_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CreateNetLogExporter_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_CreateNetLogExporter_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CreateNetLogExporter_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_CreateNetLogExporter_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CreateNetLogExporter_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_PreconnectSockets_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_PreconnectSockets_Params.prototype.initDefaults_ = function() {
    this.numStreams = 0;
    this.credentialsMode = 0;
    this.url = null;
    this.networkAnonymizationKey = null;
    this.trafficAnnotation = null;
    this.keepaliveConfig = null;
    this.observerClient = new connection_change_observer_client$.ConnectionChangeObserverClientPtr();
  };
  NetworkContext_PreconnectSockets_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_PreconnectSockets_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkContext_PreconnectSockets_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_PreconnectSockets_Params.credentialsMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, fetch_api$.CredentialsMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_PreconnectSockets_Params.networkAnonymizationKey
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, network_anonymization_key$.NetworkAnonymizationKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_PreconnectSockets_Params.trafficAnnotation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_PreconnectSockets_Params.keepaliveConfig
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, connection_change_observer_client$.ConnectionKeepAliveConfig, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_PreconnectSockets_Params.observerClient
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 48, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_PreconnectSockets_Params.encodedSize = codec.kStructHeaderSize + 56;

  NetworkContext_PreconnectSockets_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_PreconnectSockets_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.numStreams =
        decoder.decodeStruct(codec.Uint32);
    val.credentialsMode =
        decoder.decodeStruct(new codec.Enum(fetch_api$.CredentialsMode));
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.networkAnonymizationKey =
        decoder.decodeStruct(network_anonymization_key$.NetworkAnonymizationKey);
    val.trafficAnnotation =
        decoder.decodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag);
    val.keepaliveConfig =
        decoder.decodeStructPointer(connection_change_observer_client$.ConnectionKeepAliveConfig);
    val.observerClient =
        decoder.decodeStruct(new codec.NullableInterface(connection_change_observer_client$.ConnectionChangeObserverClientPtr));
    return val;
  };

  NetworkContext_PreconnectSockets_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_PreconnectSockets_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.numStreams);
    encoder.encodeStruct(codec.Int32, val.credentialsMode);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(network_anonymization_key$.NetworkAnonymizationKey, val.networkAnonymizationKey);
    encoder.encodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, val.trafficAnnotation);
    encoder.encodeStructPointer(connection_change_observer_client$.ConnectionKeepAliveConfig, val.keepaliveConfig);
    encoder.encodeStruct(new codec.NullableInterface(connection_change_observer_client$.ConnectionChangeObserverClientPtr), val.observerClient);
  };
  function NetworkContext_CreateP2PSocketManager_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CreateP2PSocketManager_Params.prototype.initDefaults_ = function() {
    this.networkAnonymizationKey = null;
    this.client = new p2p_trusted$.P2PTrustedSocketManagerClientPtr();
    this.trustedSocketManager = new bindings.InterfaceRequest();
    this.socketManager = new bindings.InterfaceRequest();
  };
  NetworkContext_CreateP2PSocketManager_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CreateP2PSocketManager_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateP2PSocketManager_Params.networkAnonymizationKey
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, network_anonymization_key$.NetworkAnonymizationKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateP2PSocketManager_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateP2PSocketManager_Params.trustedSocketManager
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateP2PSocketManager_Params.socketManager
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 28, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CreateP2PSocketManager_Params.encodedSize = codec.kStructHeaderSize + 32;

  NetworkContext_CreateP2PSocketManager_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CreateP2PSocketManager_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.networkAnonymizationKey =
        decoder.decodeStruct(network_anonymization_key$.NetworkAnonymizationKey);
    val.client =
        decoder.decodeStruct(new codec.Interface(p2p_trusted$.P2PTrustedSocketManagerClientPtr));
    val.trustedSocketManager =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.socketManager =
        decoder.decodeStruct(codec.InterfaceRequest);
    return val;
  };

  NetworkContext_CreateP2PSocketManager_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CreateP2PSocketManager_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(network_anonymization_key$.NetworkAnonymizationKey, val.networkAnonymizationKey);
    encoder.encodeStruct(new codec.Interface(p2p_trusted$.P2PTrustedSocketManagerClientPtr), val.client);
    encoder.encodeStruct(codec.InterfaceRequest, val.trustedSocketManager);
    encoder.encodeStruct(codec.InterfaceRequest, val.socketManager);
  };
  function NetworkContext_CreateMdnsResponder_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CreateMdnsResponder_Params.prototype.initDefaults_ = function() {
    this.responderReceiver = new bindings.InterfaceRequest();
  };
  NetworkContext_CreateMdnsResponder_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CreateMdnsResponder_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateMdnsResponder_Params.responderReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CreateMdnsResponder_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_CreateMdnsResponder_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CreateMdnsResponder_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.responderReceiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_CreateMdnsResponder_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CreateMdnsResponder_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.responderReceiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_ResolveHost_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ResolveHost_Params.prototype.initDefaults_ = function() {
    this.host = null;
    this.networkAnonymizationKey = null;
    this.optionalParameters = null;
    this.responseClient = new host_resolver$.ResolveHostClientPtr();
  };
  NetworkContext_ResolveHost_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ResolveHost_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ResolveHost_Params.host
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, host_resolver$.HostResolverHost, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ResolveHost_Params.networkAnonymizationKey
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, network_anonymization_key$.NetworkAnonymizationKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ResolveHost_Params.optionalParameters
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, host_resolver$.ResolveHostParameters, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ResolveHost_Params.responseClient
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 40, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ResolveHost_Params.encodedSize = codec.kStructHeaderSize + 48;

  NetworkContext_ResolveHost_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ResolveHost_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.host =
        decoder.decodeStruct(host_resolver$.HostResolverHost);
    val.networkAnonymizationKey =
        decoder.decodeStruct(network_anonymization_key$.NetworkAnonymizationKey);
    val.optionalParameters =
        decoder.decodeStructPointer(host_resolver$.ResolveHostParameters);
    val.responseClient =
        decoder.decodeStruct(new codec.Interface(host_resolver$.ResolveHostClientPtr));
    return val;
  };

  NetworkContext_ResolveHost_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ResolveHost_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(host_resolver$.HostResolverHost, val.host);
    encoder.encodeStruct(network_anonymization_key$.NetworkAnonymizationKey, val.networkAnonymizationKey);
    encoder.encodeStructPointer(host_resolver$.ResolveHostParameters, val.optionalParameters);
    encoder.encodeStruct(new codec.Interface(host_resolver$.ResolveHostClientPtr), val.responseClient);
  };
  function NetworkContext_CreateHostResolver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_CreateHostResolver_Params.prototype.initDefaults_ = function() {
    this.configOverrides = null;
    this.hostResolver = new bindings.InterfaceRequest();
  };
  NetworkContext_CreateHostResolver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_CreateHostResolver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateHostResolver_Params.configOverrides
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, host_resolver$.DnsConfigOverrides, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_CreateHostResolver_Params.hostResolver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_CreateHostResolver_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_CreateHostResolver_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_CreateHostResolver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.configOverrides =
        decoder.decodeStructPointer(host_resolver$.DnsConfigOverrides);
    val.hostResolver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_CreateHostResolver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_CreateHostResolver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(host_resolver$.DnsConfigOverrides, val.configOverrides);
    encoder.encodeStruct(codec.InterfaceRequest, val.hostResolver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_VerifyCert_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_VerifyCert_Params.prototype.initDefaults_ = function() {
    this.certificate = null;
    this.hostPort = null;
    this.ocspResponse = null;
    this.sctList = null;
  };
  NetworkContext_VerifyCert_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_VerifyCert_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_VerifyCert_Params.certificate
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, network_param$.X509Certificate, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_VerifyCert_Params.hostPort
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, network_param$.HostPortPair, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_VerifyCert_Params.ocspResponse
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_VerifyCert_Params.sctList
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_VerifyCert_Params.encodedSize = codec.kStructHeaderSize + 32;

  NetworkContext_VerifyCert_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_VerifyCert_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.certificate =
        decoder.decodeStructPointer(network_param$.X509Certificate);
    val.hostPort =
        decoder.decodeStructPointer(network_param$.HostPortPair);
    val.ocspResponse =
        decoder.decodeStruct(codec.String);
    val.sctList =
        decoder.decodeStruct(codec.String);
    return val;
  };

  NetworkContext_VerifyCert_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_VerifyCert_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(network_param$.X509Certificate, val.certificate);
    encoder.encodeStructPointer(network_param$.HostPortPair, val.hostPort);
    encoder.encodeStruct(codec.String, val.ocspResponse);
    encoder.encodeStruct(codec.String, val.sctList);
  };
  function NetworkContext_VerifyCert_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_VerifyCert_ResponseParams.prototype.initDefaults_ = function() {
    this.errorCode = 0;
    this.pkpBypassed = false;
    this.cvResult = null;
  };
  NetworkContext_VerifyCert_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_VerifyCert_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkContext_VerifyCert_ResponseParams.cvResult
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, network_param$.CertVerifyResult, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContext_VerifyCert_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_VerifyCert_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_VerifyCert_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.errorCode =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.pkpBypassed = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.cvResult =
        decoder.decodeStructPointer(network_param$.CertVerifyResult);
    return val;
  };

  NetworkContext_VerifyCert_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_VerifyCert_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.errorCode);
    packed = 0;
    packed |= (val.pkpBypassed & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(network_param$.CertVerifyResult, val.cvResult);
  };
  function NetworkContext_VerifyCertForSignedExchange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_VerifyCertForSignedExchange_Params.prototype.initDefaults_ = function() {
    this.certificate = null;
    this.hostPort = null;
    this.ocspResponse = null;
    this.sctList = null;
  };
  NetworkContext_VerifyCertForSignedExchange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_VerifyCertForSignedExchange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_VerifyCertForSignedExchange_Params.certificate
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, network_param$.X509Certificate, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_VerifyCertForSignedExchange_Params.hostPort
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, network_param$.HostPortPair, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_VerifyCertForSignedExchange_Params.ocspResponse
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_VerifyCertForSignedExchange_Params.sctList
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_VerifyCertForSignedExchange_Params.encodedSize = codec.kStructHeaderSize + 32;

  NetworkContext_VerifyCertForSignedExchange_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_VerifyCertForSignedExchange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.certificate =
        decoder.decodeStructPointer(network_param$.X509Certificate);
    val.hostPort =
        decoder.decodeStructPointer(network_param$.HostPortPair);
    val.ocspResponse =
        decoder.decodeStruct(codec.String);
    val.sctList =
        decoder.decodeStruct(codec.String);
    return val;
  };

  NetworkContext_VerifyCertForSignedExchange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_VerifyCertForSignedExchange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(network_param$.X509Certificate, val.certificate);
    encoder.encodeStructPointer(network_param$.HostPortPair, val.hostPort);
    encoder.encodeStruct(codec.String, val.ocspResponse);
    encoder.encodeStruct(codec.String, val.sctList);
  };
  function NetworkContext_VerifyCertForSignedExchange_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_VerifyCertForSignedExchange_ResponseParams.prototype.initDefaults_ = function() {
    this.errorCode = 0;
    this.pkpBypassed = false;
    this.cvResult = null;
  };
  NetworkContext_VerifyCertForSignedExchange_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_VerifyCertForSignedExchange_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate NetworkContext_VerifyCertForSignedExchange_ResponseParams.cvResult
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, network_param$.CertVerifyResult, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContext_VerifyCertForSignedExchange_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_VerifyCertForSignedExchange_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_VerifyCertForSignedExchange_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.errorCode =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.pkpBypassed = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.cvResult =
        decoder.decodeStructPointer(network_param$.CertVerifyResult);
    return val;
  };

  NetworkContext_VerifyCertForSignedExchange_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_VerifyCertForSignedExchange_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.errorCode);
    packed = 0;
    packed |= (val.pkpBypassed & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(network_param$.CertVerifyResult, val.cvResult);
  };
  function NetworkContext_Verify2QwacCertBinding_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_Verify2QwacCertBinding_Params.prototype.initDefaults_ = function() {
    this.binding = null;
    this.hostname = null;
    this.tlsCertificate = null;
  };
  NetworkContext_Verify2QwacCertBinding_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_Verify2QwacCertBinding_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_Verify2QwacCertBinding_Params.binding
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_Verify2QwacCertBinding_Params.hostname
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_Verify2QwacCertBinding_Params.tlsCertificate
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, network_param$.X509Certificate, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_Verify2QwacCertBinding_Params.encodedSize = codec.kStructHeaderSize + 24;

  NetworkContext_Verify2QwacCertBinding_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_Verify2QwacCertBinding_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.binding =
        decoder.decodeStruct(codec.String);
    val.hostname =
        decoder.decodeStruct(codec.String);
    val.tlsCertificate =
        decoder.decodeStructPointer(network_param$.X509Certificate);
    return val;
  };

  NetworkContext_Verify2QwacCertBinding_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_Verify2QwacCertBinding_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.binding);
    encoder.encodeStruct(codec.String, val.hostname);
    encoder.encodeStructPointer(network_param$.X509Certificate, val.tlsCertificate);
  };
  function NetworkContext_Verify2QwacCertBinding_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_Verify2QwacCertBinding_ResponseParams.prototype.initDefaults_ = function() {
    this.verifiedCert = null;
  };
  NetworkContext_Verify2QwacCertBinding_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_Verify2QwacCertBinding_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_Verify2QwacCertBinding_ResponseParams.verifiedCert
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, network_param$.X509Certificate, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_Verify2QwacCertBinding_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_Verify2QwacCertBinding_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_Verify2QwacCertBinding_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.verifiedCert =
        decoder.decodeStructPointer(network_param$.X509Certificate);
    return val;
  };

  NetworkContext_Verify2QwacCertBinding_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_Verify2QwacCertBinding_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(network_param$.X509Certificate, val.verifiedCert);
  };
  function NetworkContext_AddHSTS_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_AddHSTS_Params.prototype.initDefaults_ = function() {
    this.host = null;
    this.expiry = null;
    this.includeSubdomains = false;
  };
  NetworkContext_AddHSTS_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_AddHSTS_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_AddHSTS_Params.host
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_AddHSTS_Params.expiry
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContext_AddHSTS_Params.encodedSize = codec.kStructHeaderSize + 24;

  NetworkContext_AddHSTS_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_AddHSTS_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.host =
        decoder.decodeStruct(codec.String);
    val.expiry =
        decoder.decodeStructPointer(time$.Time);
    packed = decoder.readUint8();
    val.includeSubdomains = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_AddHSTS_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_AddHSTS_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.host);
    encoder.encodeStructPointer(time$.Time, val.expiry);
    packed = 0;
    packed |= (val.includeSubdomains & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_AddHSTS_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_AddHSTS_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_AddHSTS_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_AddHSTS_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_AddHSTS_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_AddHSTS_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_AddHSTS_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_AddHSTS_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_AddHSTS_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_IsHSTSActiveForHost_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_IsHSTSActiveForHost_Params.prototype.initDefaults_ = function() {
    this.host = null;
    this.isTopLevelNav = false;
  };
  NetworkContext_IsHSTSActiveForHost_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_IsHSTSActiveForHost_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_IsHSTSActiveForHost_Params.host
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContext_IsHSTSActiveForHost_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_IsHSTSActiveForHost_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_IsHSTSActiveForHost_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.host =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.isTopLevelNav = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_IsHSTSActiveForHost_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_IsHSTSActiveForHost_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.host);
    packed = 0;
    packed |= (val.isTopLevelNav & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_IsHSTSActiveForHost_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_IsHSTSActiveForHost_ResponseParams.prototype.initDefaults_ = function() {
    this.result = false;
  };
  NetworkContext_IsHSTSActiveForHost_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_IsHSTSActiveForHost_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContext_IsHSTSActiveForHost_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_IsHSTSActiveForHost_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_IsHSTSActiveForHost_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.result = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_IsHSTSActiveForHost_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_IsHSTSActiveForHost_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.result & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_GetHSTSState_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetHSTSState_Params.prototype.initDefaults_ = function() {
    this.domain = null;
  };
  NetworkContext_GetHSTSState_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetHSTSState_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetHSTSState_Params.domain
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetHSTSState_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_GetHSTSState_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetHSTSState_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.domain =
        decoder.decodeStruct(codec.String);
    return val;
  };

  NetworkContext_GetHSTSState_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetHSTSState_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.domain);
  };
  function NetworkContext_GetHSTSState_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetHSTSState_ResponseParams.prototype.initDefaults_ = function() {
    this.state = null;
  };
  NetworkContext_GetHSTSState_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetHSTSState_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetHSTSState_ResponseParams.state
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, values$.DictionaryValue, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetHSTSState_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_GetHSTSState_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetHSTSState_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.state =
        decoder.decodeStructPointer(values$.DictionaryValue);
    return val;
  };

  NetworkContext_GetHSTSState_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetHSTSState_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(values$.DictionaryValue, val.state);
  };
  function NetworkContext_SetCorsOriginAccessListsForOrigin_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_SetCorsOriginAccessListsForOrigin_Params.prototype.initDefaults_ = function() {
    this.sourceOrigin = null;
    this.allowPatterns = null;
    this.blockPatterns = null;
  };
  NetworkContext_SetCorsOriginAccessListsForOrigin_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_SetCorsOriginAccessListsForOrigin_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_SetCorsOriginAccessListsForOrigin_Params.sourceOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_SetCorsOriginAccessListsForOrigin_Params.allowPatterns
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(cors_origin_pattern$.CorsOriginPattern), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_SetCorsOriginAccessListsForOrigin_Params.blockPatterns
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(cors_origin_pattern$.CorsOriginPattern), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_SetCorsOriginAccessListsForOrigin_Params.encodedSize = codec.kStructHeaderSize + 24;

  NetworkContext_SetCorsOriginAccessListsForOrigin_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_SetCorsOriginAccessListsForOrigin_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sourceOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.allowPatterns =
        decoder.decodeArrayPointer(new codec.PointerTo(cors_origin_pattern$.CorsOriginPattern));
    val.blockPatterns =
        decoder.decodeArrayPointer(new codec.PointerTo(cors_origin_pattern$.CorsOriginPattern));
    return val;
  };

  NetworkContext_SetCorsOriginAccessListsForOrigin_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_SetCorsOriginAccessListsForOrigin_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.sourceOrigin);
    encoder.encodeArrayPointer(new codec.PointerTo(cors_origin_pattern$.CorsOriginPattern), val.allowPatterns);
    encoder.encodeArrayPointer(new codec.PointerTo(cors_origin_pattern$.CorsOriginPattern), val.blockPatterns);
  };
  function NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_DeleteDynamicDataForHost_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_DeleteDynamicDataForHost_Params.prototype.initDefaults_ = function() {
    this.host = null;
  };
  NetworkContext_DeleteDynamicDataForHost_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_DeleteDynamicDataForHost_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_DeleteDynamicDataForHost_Params.host
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_DeleteDynamicDataForHost_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_DeleteDynamicDataForHost_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_DeleteDynamicDataForHost_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.host =
        decoder.decodeStruct(codec.String);
    return val;
  };

  NetworkContext_DeleteDynamicDataForHost_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_DeleteDynamicDataForHost_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.host);
  };
  function NetworkContext_DeleteDynamicDataForHost_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_DeleteDynamicDataForHost_ResponseParams.prototype.initDefaults_ = function() {
    this.result = false;
  };
  NetworkContext_DeleteDynamicDataForHost_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_DeleteDynamicDataForHost_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContext_DeleteDynamicDataForHost_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_DeleteDynamicDataForHost_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_DeleteDynamicDataForHost_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.result = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_DeleteDynamicDataForHost_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_DeleteDynamicDataForHost_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.result & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params.prototype.initDefaults_ = function() {
    this.splitAuthCacheByNetworkAnonymizationKey = false;
  };
  NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.splitAuthCacheByNetworkAnonymizationKey = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.splitAuthCacheByNetworkAnonymizationKey & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_SaveHttpAuthCacheProxyEntries_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_SaveHttpAuthCacheProxyEntries_Params.prototype.initDefaults_ = function() {
  };
  NetworkContext_SaveHttpAuthCacheProxyEntries_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_SaveHttpAuthCacheProxyEntries_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_SaveHttpAuthCacheProxyEntries_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_SaveHttpAuthCacheProxyEntries_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_SaveHttpAuthCacheProxyEntries_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_SaveHttpAuthCacheProxyEntries_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_SaveHttpAuthCacheProxyEntries_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams.prototype.initDefaults_ = function() {
    this.cacheKey = null;
  };
  NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams.cacheKey
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cacheKey =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.cacheKey);
  };
  function NetworkContext_LoadHttpAuthCacheProxyEntries_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_LoadHttpAuthCacheProxyEntries_Params.prototype.initDefaults_ = function() {
    this.cacheKey = null;
  };
  NetworkContext_LoadHttpAuthCacheProxyEntries_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_LoadHttpAuthCacheProxyEntries_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_LoadHttpAuthCacheProxyEntries_Params.cacheKey
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_LoadHttpAuthCacheProxyEntries_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_LoadHttpAuthCacheProxyEntries_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_LoadHttpAuthCacheProxyEntries_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cacheKey =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  NetworkContext_LoadHttpAuthCacheProxyEntries_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_LoadHttpAuthCacheProxyEntries_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.cacheKey);
  };
  function NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_AddAuthCacheEntry_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_AddAuthCacheEntry_Params.prototype.initDefaults_ = function() {
    this.challenge = null;
    this.networkAnonymizationKey = null;
    this.credentials = null;
  };
  NetworkContext_AddAuthCacheEntry_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_AddAuthCacheEntry_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_AddAuthCacheEntry_Params.challenge
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, network_param$.AuthChallengeInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_AddAuthCacheEntry_Params.networkAnonymizationKey
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, network_anonymization_key$.NetworkAnonymizationKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_AddAuthCacheEntry_Params.credentials
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, network_param$.AuthCredentials, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_AddAuthCacheEntry_Params.encodedSize = codec.kStructHeaderSize + 32;

  NetworkContext_AddAuthCacheEntry_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_AddAuthCacheEntry_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.challenge =
        decoder.decodeStructPointer(network_param$.AuthChallengeInfo);
    val.networkAnonymizationKey =
        decoder.decodeStruct(network_anonymization_key$.NetworkAnonymizationKey);
    val.credentials =
        decoder.decodeStructPointer(network_param$.AuthCredentials);
    return val;
  };

  NetworkContext_AddAuthCacheEntry_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_AddAuthCacheEntry_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(network_param$.AuthChallengeInfo, val.challenge);
    encoder.encodeStruct(network_anonymization_key$.NetworkAnonymizationKey, val.networkAnonymizationKey);
    encoder.encodeStructPointer(network_param$.AuthCredentials, val.credentials);
  };
  function NetworkContext_AddAuthCacheEntry_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_AddAuthCacheEntry_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_AddAuthCacheEntry_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_AddAuthCacheEntry_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_AddAuthCacheEntry_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_AddAuthCacheEntry_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_AddAuthCacheEntry_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_AddAuthCacheEntry_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_AddAuthCacheEntry_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params.prototype.initDefaults_ = function() {
    this.value = false;
  };
  NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.value = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.value & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_EnableStaticKeyPinningForTesting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_EnableStaticKeyPinningForTesting_Params.prototype.initDefaults_ = function() {
  };
  NetworkContext_EnableStaticKeyPinningForTesting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_EnableStaticKeyPinningForTesting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_EnableStaticKeyPinningForTesting_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_EnableStaticKeyPinningForTesting_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_EnableStaticKeyPinningForTesting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_EnableStaticKeyPinningForTesting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_EnableStaticKeyPinningForTesting_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_VerifyCertificateForTesting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_VerifyCertificateForTesting_Params.prototype.initDefaults_ = function() {
    this.certificate = null;
    this.hostname = null;
    this.ocspResponse = null;
    this.sctList = null;
  };
  NetworkContext_VerifyCertificateForTesting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_VerifyCertificateForTesting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_VerifyCertificateForTesting_Params.certificate
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, network_param$.X509Certificate, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_VerifyCertificateForTesting_Params.hostname
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_VerifyCertificateForTesting_Params.ocspResponse
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_VerifyCertificateForTesting_Params.sctList
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_VerifyCertificateForTesting_Params.encodedSize = codec.kStructHeaderSize + 32;

  NetworkContext_VerifyCertificateForTesting_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_VerifyCertificateForTesting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.certificate =
        decoder.decodeStructPointer(network_param$.X509Certificate);
    val.hostname =
        decoder.decodeStruct(codec.String);
    val.ocspResponse =
        decoder.decodeStruct(codec.String);
    val.sctList =
        decoder.decodeStruct(codec.String);
    return val;
  };

  NetworkContext_VerifyCertificateForTesting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_VerifyCertificateForTesting_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(network_param$.X509Certificate, val.certificate);
    encoder.encodeStruct(codec.String, val.hostname);
    encoder.encodeStruct(codec.String, val.ocspResponse);
    encoder.encodeStruct(codec.String, val.sctList);
  };
  function NetworkContext_VerifyCertificateForTesting_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_VerifyCertificateForTesting_ResponseParams.prototype.initDefaults_ = function() {
    this.errorCode = 0;
  };
  NetworkContext_VerifyCertificateForTesting_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_VerifyCertificateForTesting_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContext_VerifyCertificateForTesting_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_VerifyCertificateForTesting_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_VerifyCertificateForTesting_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.errorCode =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_VerifyCertificateForTesting_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_VerifyCertificateForTesting_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.errorCode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_GetTrustAnchorIDsForTesting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetTrustAnchorIDsForTesting_Params.prototype.initDefaults_ = function() {
  };
  NetworkContext_GetTrustAnchorIDsForTesting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetTrustAnchorIDsForTesting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetTrustAnchorIDsForTesting_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_GetTrustAnchorIDsForTesting_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetTrustAnchorIDsForTesting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_GetTrustAnchorIDsForTesting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetTrustAnchorIDsForTesting_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams.prototype.initDefaults_ = function() {
    this.trustAnchorIds = null;
  };
  NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams.trustAnchorIds
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.ArrayOf(codec.Uint8), false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.trustAnchorIds =
        decoder.decodeArrayPointer(new codec.ArrayOf(codec.Uint8));
    return val;
  };

  NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.ArrayOf(codec.Uint8), val.trustAnchorIds);
  };
  function NetworkContext_AddDomainReliabilityContextForTesting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_AddDomainReliabilityContextForTesting_Params.prototype.initDefaults_ = function() {
    this.origin = null;
    this.uploadUrl = null;
  };
  NetworkContext_AddDomainReliabilityContextForTesting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_AddDomainReliabilityContextForTesting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_AddDomainReliabilityContextForTesting_Params.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_AddDomainReliabilityContextForTesting_Params.uploadUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_AddDomainReliabilityContextForTesting_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_AddDomainReliabilityContextForTesting_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_AddDomainReliabilityContextForTesting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    val.uploadUrl =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  NetworkContext_AddDomainReliabilityContextForTesting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_AddDomainReliabilityContextForTesting_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
    encoder.encodeStructPointer(url$.Url, val.uploadUrl);
  };
  function NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_ForceDomainReliabilityUploadsForTesting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ForceDomainReliabilityUploadsForTesting_Params.prototype.initDefaults_ = function() {
  };
  NetworkContext_ForceDomainReliabilityUploadsForTesting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ForceDomainReliabilityUploadsForTesting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ForceDomainReliabilityUploadsForTesting_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ForceDomainReliabilityUploadsForTesting_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ForceDomainReliabilityUploadsForTesting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ForceDomainReliabilityUploadsForTesting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ForceDomainReliabilityUploadsForTesting_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_SetSCTAuditingMode_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_SetSCTAuditingMode_Params.prototype.initDefaults_ = function() {
    this.mode = 0;
  };
  NetworkContext_SetSCTAuditingMode_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_SetSCTAuditingMode_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_SetSCTAuditingMode_Params.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SCTAuditingMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_SetSCTAuditingMode_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_SetSCTAuditingMode_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_SetSCTAuditingMode_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mode =
        decoder.decodeStruct(new codec.Enum(SCTAuditingMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_SetSCTAuditingMode_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_SetSCTAuditingMode_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_AddReportingApiObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_AddReportingApiObserver_Params.prototype.initDefaults_ = function() {
    this.observer = new reporting_service$.ReportingApiObserverPtr();
  };
  NetworkContext_AddReportingApiObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_AddReportingApiObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_AddReportingApiObserver_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_AddReportingApiObserver_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_AddReportingApiObserver_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_AddReportingApiObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observer =
        decoder.decodeStruct(new codec.Interface(reporting_service$.ReportingApiObserverPtr));
    return val;
  };

  NetworkContext_AddReportingApiObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_AddReportingApiObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(reporting_service$.ReportingApiObserverPtr), val.observer);
  };
  function NetworkContext_GetSharedDictionaryUsageInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetSharedDictionaryUsageInfo_Params.prototype.initDefaults_ = function() {
  };
  NetworkContext_GetSharedDictionaryUsageInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetSharedDictionaryUsageInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetSharedDictionaryUsageInfo_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_GetSharedDictionaryUsageInfo_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetSharedDictionaryUsageInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_GetSharedDictionaryUsageInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetSharedDictionaryUsageInfo_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams.prototype.initDefaults_ = function() {
    this.usageInfo = null;
  };
  NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams.usageInfo
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(shared_dictionary_usage_info$.SharedDictionaryUsageInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.usageInfo =
        decoder.decodeArrayPointer(new codec.PointerTo(shared_dictionary_usage_info$.SharedDictionaryUsageInfo));
    return val;
  };

  NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(shared_dictionary_usage_info$.SharedDictionaryUsageInfo), val.usageInfo);
  };
  function NetworkContext_GetSharedDictionaryInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetSharedDictionaryInfo_Params.prototype.initDefaults_ = function() {
    this.isolationKey = null;
  };
  NetworkContext_GetSharedDictionaryInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetSharedDictionaryInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetSharedDictionaryInfo_Params.isolationKey
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, shared_dictionary_isolation_key$.SharedDictionaryIsolationKey, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetSharedDictionaryInfo_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_GetSharedDictionaryInfo_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetSharedDictionaryInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.isolationKey =
        decoder.decodeStructPointer(shared_dictionary_isolation_key$.SharedDictionaryIsolationKey);
    return val;
  };

  NetworkContext_GetSharedDictionaryInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetSharedDictionaryInfo_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(shared_dictionary_isolation_key$.SharedDictionaryIsolationKey, val.isolationKey);
  };
  function NetworkContext_GetSharedDictionaryInfo_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetSharedDictionaryInfo_ResponseParams.prototype.initDefaults_ = function() {
    this.dictionaries = null;
  };
  NetworkContext_GetSharedDictionaryInfo_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetSharedDictionaryInfo_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetSharedDictionaryInfo_ResponseParams.dictionaries
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(SharedDictionaryInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetSharedDictionaryInfo_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_GetSharedDictionaryInfo_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetSharedDictionaryInfo_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.dictionaries =
        decoder.decodeArrayPointer(new codec.PointerTo(SharedDictionaryInfo));
    return val;
  };

  NetworkContext_GetSharedDictionaryInfo_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetSharedDictionaryInfo_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(SharedDictionaryInfo), val.dictionaries);
  };
  function NetworkContext_GetSharedDictionaryOriginsBetween_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetSharedDictionaryOriginsBetween_Params.prototype.initDefaults_ = function() {
    this.startTime = null;
    this.endTime = null;
  };
  NetworkContext_GetSharedDictionaryOriginsBetween_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetSharedDictionaryOriginsBetween_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetSharedDictionaryOriginsBetween_Params.startTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetSharedDictionaryOriginsBetween_Params.endTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetSharedDictionaryOriginsBetween_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_GetSharedDictionaryOriginsBetween_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetSharedDictionaryOriginsBetween_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.startTime =
        decoder.decodeStructPointer(time$.Time);
    val.endTime =
        decoder.decodeStructPointer(time$.Time);
    return val;
  };

  NetworkContext_GetSharedDictionaryOriginsBetween_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetSharedDictionaryOriginsBetween_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.Time, val.startTime);
    encoder.encodeStructPointer(time$.Time, val.endTime);
  };
  function NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams.prototype.initDefaults_ = function() {
    this.origins = null;
  };
  NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams.origins
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(origin$.Origin), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.origins =
        decoder.decodeArrayPointer(new codec.PointerTo(origin$.Origin));
    return val;
  };

  NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(origin$.Origin), val.origins);
  };
  function NetworkContext_SetSharedDictionaryCacheMaxSize_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_SetSharedDictionaryCacheMaxSize_Params.prototype.initDefaults_ = function() {
    this.cacheMaxSize = 0;
  };
  NetworkContext_SetSharedDictionaryCacheMaxSize_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_SetSharedDictionaryCacheMaxSize_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContext_SetSharedDictionaryCacheMaxSize_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_SetSharedDictionaryCacheMaxSize_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_SetSharedDictionaryCacheMaxSize_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cacheMaxSize =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  NetworkContext_SetSharedDictionaryCacheMaxSize_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_SetSharedDictionaryCacheMaxSize_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.cacheMaxSize);
  };
  function NetworkContext_PreloadSharedDictionaryInfoForDocument_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_PreloadSharedDictionaryInfoForDocument_Params.prototype.initDefaults_ = function() {
    this.urls = null;
    this.preloadHandle = new bindings.InterfaceRequest();
  };
  NetworkContext_PreloadSharedDictionaryInfoForDocument_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_PreloadSharedDictionaryInfoForDocument_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_PreloadSharedDictionaryInfoForDocument_Params.urls
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(url$.Url), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_PreloadSharedDictionaryInfoForDocument_Params.preloadHandle
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_PreloadSharedDictionaryInfoForDocument_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_PreloadSharedDictionaryInfoForDocument_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_PreloadSharedDictionaryInfoForDocument_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.urls =
        decoder.decodeArrayPointer(new codec.PointerTo(url$.Url));
    val.preloadHandle =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_PreloadSharedDictionaryInfoForDocument_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_PreloadSharedDictionaryInfoForDocument_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(url$.Url), val.urls);
    encoder.encodeStruct(codec.InterfaceRequest, val.preloadHandle);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params.prototype.initDefaults_ = function() {
  };
  NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams.prototype.initDefaults_ = function() {
    this.value = false;
  };
  NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.value = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.value & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_FlushCachedClientCertIfNeeded_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_FlushCachedClientCertIfNeeded_Params.prototype.initDefaults_ = function() {
    this.host = null;
    this.certificate = null;
  };
  NetworkContext_FlushCachedClientCertIfNeeded_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_FlushCachedClientCertIfNeeded_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_FlushCachedClientCertIfNeeded_Params.host
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, network_param$.HostPortPair, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_FlushCachedClientCertIfNeeded_Params.certificate
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, network_param$.X509Certificate, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_FlushCachedClientCertIfNeeded_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_FlushCachedClientCertIfNeeded_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_FlushCachedClientCertIfNeeded_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.host =
        decoder.decodeStructPointer(network_param$.HostPortPair);
    val.certificate =
        decoder.decodeStructPointer(network_param$.X509Certificate);
    return val;
  };

  NetworkContext_FlushCachedClientCertIfNeeded_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_FlushCachedClientCertIfNeeded_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(network_param$.HostPortPair, val.host);
    encoder.encodeStructPointer(network_param$.X509Certificate, val.certificate);
  };
  function NetworkContext_FlushMatchingCachedClientCert_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_FlushMatchingCachedClientCert_Params.prototype.initDefaults_ = function() {
    this.certificate = null;
  };
  NetworkContext_FlushMatchingCachedClientCert_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_FlushMatchingCachedClientCert_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_FlushMatchingCachedClientCert_Params.certificate
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, network_param$.X509Certificate, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_FlushMatchingCachedClientCert_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_FlushMatchingCachedClientCert_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_FlushMatchingCachedClientCert_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.certificate =
        decoder.decodeStructPointer(network_param$.X509Certificate);
    return val;
  };

  NetworkContext_FlushMatchingCachedClientCert_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_FlushMatchingCachedClientCert_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(network_param$.X509Certificate, val.certificate);
  };
  function NetworkContext_RevokeNetworkForNonces_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_RevokeNetworkForNonces_Params.prototype.initDefaults_ = function() {
    this.noncesToPatterns = null;
  };
  NetworkContext_RevokeNetworkForNonces_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_RevokeNetworkForNonces_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_RevokeNetworkForNonces_Params.noncesToPatterns
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(NonceAndAllowlistedPatterns), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_RevokeNetworkForNonces_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_RevokeNetworkForNonces_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_RevokeNetworkForNonces_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.noncesToPatterns =
        decoder.decodeArrayPointer(new codec.PointerTo(NonceAndAllowlistedPatterns));
    return val;
  };

  NetworkContext_RevokeNetworkForNonces_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_RevokeNetworkForNonces_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(NonceAndAllowlistedPatterns), val.noncesToPatterns);
  };
  function NetworkContext_RevokeNetworkForNonces_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_RevokeNetworkForNonces_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_RevokeNetworkForNonces_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_RevokeNetworkForNonces_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_RevokeNetworkForNonces_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_RevokeNetworkForNonces_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_RevokeNetworkForNonces_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_RevokeNetworkForNonces_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_RevokeNetworkForNonces_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_ClearNonces_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ClearNonces_Params.prototype.initDefaults_ = function() {
    this.nonces = null;
  };
  NetworkContext_ClearNonces_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ClearNonces_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ClearNonces_Params.nonces
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(unguessable_token$.UnguessableToken), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ClearNonces_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_ClearNonces_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ClearNonces_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.nonces =
        decoder.decodeArrayPointer(new codec.PointerTo(unguessable_token$.UnguessableToken));
    return val;
  };

  NetworkContext_ClearNonces_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ClearNonces_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(unguessable_token$.UnguessableToken), val.nonces);
  };
  function NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params.prototype.initDefaults_ = function() {
    this.exemptedUrl = null;
    this.nonce = null;
  };
  NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params.exemptedUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params.nonce
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params.encodedSize = codec.kStructHeaderSize + 16;

  NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.exemptedUrl =
        decoder.decodeStructPointer(url$.Url);
    val.nonce =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.exemptedUrl);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.nonce);
  };
  function NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams.prototype.initDefaults_ = function() {
  };
  NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_Prefetch_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_Prefetch_Params.prototype.initDefaults_ = function() {
    this.requestId = 0;
    this.options = 0;
    this.request = null;
    this.trafficAnnotation = null;
  };
  NetworkContext_Prefetch_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_Prefetch_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate NetworkContext_Prefetch_Params.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url_request$.URLRequest, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_Prefetch_Params.trafficAnnotation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_Prefetch_Params.encodedSize = codec.kStructHeaderSize + 24;

  NetworkContext_Prefetch_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_Prefetch_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    val.options =
        decoder.decodeStruct(codec.Uint32);
    val.request =
        decoder.decodeStructPointer(url_request$.URLRequest);
    val.trafficAnnotation =
        decoder.decodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag);
    return val;
  };

  NetworkContext_Prefetch_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_Prefetch_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.requestId);
    encoder.encodeStruct(codec.Uint32, val.options);
    encoder.encodeStructPointer(url_request$.URLRequest, val.request);
    encoder.encodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, val.trafficAnnotation);
  };
  function NetworkContext_GetBoundNetworkForTesting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetBoundNetworkForTesting_Params.prototype.initDefaults_ = function() {
  };
  NetworkContext_GetBoundNetworkForTesting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetBoundNetworkForTesting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetBoundNetworkForTesting_Params.encodedSize = codec.kStructHeaderSize + 0;

  NetworkContext_GetBoundNetworkForTesting_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetBoundNetworkForTesting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NetworkContext_GetBoundNetworkForTesting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetBoundNetworkForTesting_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function NetworkContext_GetBoundNetworkForTesting_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetBoundNetworkForTesting_ResponseParams.prototype.initDefaults_ = function() {
    this.boundNetwork = 0;
  };
  NetworkContext_GetBoundNetworkForTesting_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetBoundNetworkForTesting_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NetworkContext_GetBoundNetworkForTesting_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_GetBoundNetworkForTesting_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetBoundNetworkForTesting_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.boundNetwork =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  NetworkContext_GetBoundNetworkForTesting_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetBoundNetworkForTesting_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.boundNetwork);
  };
  function NetworkContext_GetDeviceBoundSessionManager_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_GetDeviceBoundSessionManager_Params.prototype.initDefaults_ = function() {
    this.deviceBoundSessionManager = new bindings.InterfaceRequest();
  };
  NetworkContext_GetDeviceBoundSessionManager_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_GetDeviceBoundSessionManager_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_GetDeviceBoundSessionManager_Params.deviceBoundSessionManager
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_GetDeviceBoundSessionManager_Params.encodedSize = codec.kStructHeaderSize + 8;

  NetworkContext_GetDeviceBoundSessionManager_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_GetDeviceBoundSessionManager_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.deviceBoundSessionManager =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NetworkContext_GetDeviceBoundSessionManager_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_GetDeviceBoundSessionManager_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.deviceBoundSessionManager);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NetworkContext_AddQuicHints_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NetworkContext_AddQuicHints_Params.prototype.initDefaults_ = function() {
    this.origins = null;
    this.networkAnonymizationKey = null;
  };
  NetworkContext_AddQuicHints_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NetworkContext_AddQuicHints_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_AddQuicHints_Params.origins
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(scheme_host_port$.SchemeHostPort), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NetworkContext_AddQuicHints_Params.networkAnonymizationKey
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, network_anonymization_key$.NetworkAnonymizationKey, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NetworkContext_AddQuicHints_Params.encodedSize = codec.kStructHeaderSize + 24;

  NetworkContext_AddQuicHints_Params.decode = function(decoder) {
    var packed;
    var val = new NetworkContext_AddQuicHints_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.origins =
        decoder.decodeArrayPointer(new codec.PointerTo(scheme_host_port$.SchemeHostPort));
    val.networkAnonymizationKey =
        decoder.decodeStruct(network_anonymization_key$.NetworkAnonymizationKey);
    return val;
  };

  NetworkContext_AddQuicHints_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NetworkContext_AddQuicHints_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(scheme_host_port$.SchemeHostPort), val.origins);
    encoder.encodeStruct(network_anonymization_key$.NetworkAnonymizationKey, val.networkAnonymizationKey);
  };
  var kCustomProxyConnectionObserver_OnFallback_Name = 0;
  var kCustomProxyConnectionObserver_OnTunnelHeadersReceived_Name = 1;

  function CustomProxyConnectionObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CustomProxyConnectionObserver,
                                                   handleOrPtrInfo);
  }

  function CustomProxyConnectionObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CustomProxyConnectionObserver, associatedInterfacePtrInfo);
  }

  CustomProxyConnectionObserverAssociatedPtr.prototype =
      Object.create(CustomProxyConnectionObserverPtr.prototype);
  CustomProxyConnectionObserverAssociatedPtr.prototype.constructor =
      CustomProxyConnectionObserverAssociatedPtr;

  function CustomProxyConnectionObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  CustomProxyConnectionObserverPtr.prototype.onFallback = function() {
    return CustomProxyConnectionObserverProxy.prototype.onFallback
        .apply(this.ptr.getProxy(), arguments);
  };

  CustomProxyConnectionObserverProxy.prototype.onFallback = function(badChain, netError) {
    var params_ = new CustomProxyConnectionObserver_OnFallback_Params();
    params_.badChain = badChain;
    params_.netError = netError;
    var builder = new codec.MessageV0Builder(
        kCustomProxyConnectionObserver_OnFallback_Name,
        codec.align(CustomProxyConnectionObserver_OnFallback_Params.encodedSize));
    builder.encodeStruct(CustomProxyConnectionObserver_OnFallback_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CustomProxyConnectionObserverPtr.prototype.onTunnelHeadersReceived = function() {
    return CustomProxyConnectionObserverProxy.prototype.onTunnelHeadersReceived
        .apply(this.ptr.getProxy(), arguments);
  };

  CustomProxyConnectionObserverProxy.prototype.onTunnelHeadersReceived = function(proxyChain, chainIndex, responseHeaders) {
    var params_ = new CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params();
    params_.proxyChain = proxyChain;
    params_.chainIndex = chainIndex;
    params_.responseHeaders = responseHeaders;
    var builder = new codec.MessageV0Builder(
        kCustomProxyConnectionObserver_OnTunnelHeadersReceived_Name,
        codec.align(CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params.encodedSize));
    builder.encodeStruct(CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function CustomProxyConnectionObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  CustomProxyConnectionObserverStub.prototype.onFallback = function(badChain, netError) {
    return this.delegate_ && this.delegate_.onFallback && this.delegate_.onFallback(badChain, netError);
  }
  CustomProxyConnectionObserverStub.prototype.onTunnelHeadersReceived = function(proxyChain, chainIndex, responseHeaders) {
    return this.delegate_ && this.delegate_.onTunnelHeadersReceived && this.delegate_.onTunnelHeadersReceived(proxyChain, chainIndex, responseHeaders);
  }

  CustomProxyConnectionObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCustomProxyConnectionObserver_OnFallback_Name:
      var params = reader.decodeStruct(CustomProxyConnectionObserver_OnFallback_Params);
      this.onFallback(params.badChain, params.netError);
      return true;
    case kCustomProxyConnectionObserver_OnTunnelHeadersReceived_Name:
      var params = reader.decodeStruct(CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params);
      this.onTunnelHeadersReceived(params.proxyChain, params.chainIndex, params.responseHeaders);
      return true;
    default:
      return false;
    }
  };

  CustomProxyConnectionObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateCustomProxyConnectionObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCustomProxyConnectionObserver_OnFallback_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CustomProxyConnectionObserver_OnFallback_Params;
      break;
      case kCustomProxyConnectionObserver_OnTunnelHeadersReceived_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCustomProxyConnectionObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var CustomProxyConnectionObserver = {
    name: 'network.mojom.CustomProxyConnectionObserver',
    kVersion: 0,
    ptrClass: CustomProxyConnectionObserverPtr,
    proxyClass: CustomProxyConnectionObserverProxy,
    stubClass: CustomProxyConnectionObserverStub,
    validateRequest: validateCustomProxyConnectionObserverRequest,
    validateResponse: null,
  };
  CustomProxyConnectionObserverStub.prototype.validator = validateCustomProxyConnectionObserverRequest;
  CustomProxyConnectionObserverProxy.prototype.validator = null;
  var kCustomProxyConfigClient_OnCustomProxyConfigUpdated_Name = 0;

  function CustomProxyConfigClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CustomProxyConfigClient,
                                                   handleOrPtrInfo);
  }

  function CustomProxyConfigClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CustomProxyConfigClient, associatedInterfacePtrInfo);
  }

  CustomProxyConfigClientAssociatedPtr.prototype =
      Object.create(CustomProxyConfigClientPtr.prototype);
  CustomProxyConfigClientAssociatedPtr.prototype.constructor =
      CustomProxyConfigClientAssociatedPtr;

  function CustomProxyConfigClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  CustomProxyConfigClientPtr.prototype.onCustomProxyConfigUpdated = function() {
    return CustomProxyConfigClientProxy.prototype.onCustomProxyConfigUpdated
        .apply(this.ptr.getProxy(), arguments);
  };

  CustomProxyConfigClientProxy.prototype.onCustomProxyConfigUpdated = function(proxyConfig) {
    var params_ = new CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params();
    params_.proxyConfig = proxyConfig;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCustomProxyConfigClient_OnCustomProxyConfigUpdated_Name,
          codec.align(CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function CustomProxyConfigClientStub(delegate) {
    this.delegate_ = delegate;
  }
  CustomProxyConfigClientStub.prototype.onCustomProxyConfigUpdated = function(proxyConfig) {
    return this.delegate_ && this.delegate_.onCustomProxyConfigUpdated && this.delegate_.onCustomProxyConfigUpdated(proxyConfig);
  }

  CustomProxyConfigClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  CustomProxyConfigClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCustomProxyConfigClient_OnCustomProxyConfigUpdated_Name:
      var params = reader.decodeStruct(CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params);
      this.onCustomProxyConfigUpdated(params.proxyConfig).then(function(response) {
        var responseParams =
            new CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kCustomProxyConfigClient_OnCustomProxyConfigUpdated_Name,
            codec.align(CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateCustomProxyConfigClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCustomProxyConfigClient_OnCustomProxyConfigUpdated_Name:
        if (message.expectsResponse())
          paramsClass = CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCustomProxyConfigClientResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kCustomProxyConfigClient_OnCustomProxyConfigUpdated_Name:
        if (message.isResponse())
          paramsClass = CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var CustomProxyConfigClient = {
    name: 'network.mojom.CustomProxyConfigClient',
    kVersion: 0,
    ptrClass: CustomProxyConfigClientPtr,
    proxyClass: CustomProxyConfigClientProxy,
    stubClass: CustomProxyConfigClientStub,
    validateRequest: validateCustomProxyConfigClientRequest,
    validateResponse: validateCustomProxyConfigClientResponse,
  };
  CustomProxyConfigClientStub.prototype.validator = validateCustomProxyConfigClientRequest;
  CustomProxyConfigClientProxy.prototype.validator = validateCustomProxyConfigClientResponse;
  var kTrustedHeaderClient_OnBeforeSendHeaders_Name = 0;
  var kTrustedHeaderClient_OnHeadersReceived_Name = 1;

  function TrustedHeaderClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(TrustedHeaderClient,
                                                   handleOrPtrInfo);
  }

  function TrustedHeaderClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        TrustedHeaderClient, associatedInterfacePtrInfo);
  }

  TrustedHeaderClientAssociatedPtr.prototype =
      Object.create(TrustedHeaderClientPtr.prototype);
  TrustedHeaderClientAssociatedPtr.prototype.constructor =
      TrustedHeaderClientAssociatedPtr;

  function TrustedHeaderClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  TrustedHeaderClientPtr.prototype.onBeforeSendHeaders = function() {
    return TrustedHeaderClientProxy.prototype.onBeforeSendHeaders
        .apply(this.ptr.getProxy(), arguments);
  };

  TrustedHeaderClientProxy.prototype.onBeforeSendHeaders = function(headers) {
    var params_ = new TrustedHeaderClient_OnBeforeSendHeaders_Params();
    params_.headers = headers;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kTrustedHeaderClient_OnBeforeSendHeaders_Name,
          codec.align(TrustedHeaderClient_OnBeforeSendHeaders_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(TrustedHeaderClient_OnBeforeSendHeaders_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  TrustedHeaderClientPtr.prototype.onHeadersReceived = function() {
    return TrustedHeaderClientProxy.prototype.onHeadersReceived
        .apply(this.ptr.getProxy(), arguments);
  };

  TrustedHeaderClientProxy.prototype.onHeadersReceived = function(headers, remoteEndpoint, sslInfo) {
    var params_ = new TrustedHeaderClient_OnHeadersReceived_Params();
    params_.headers = headers;
    params_.remoteEndpoint = remoteEndpoint;
    params_.sslInfo = sslInfo;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kTrustedHeaderClient_OnHeadersReceived_Name,
          codec.align(TrustedHeaderClient_OnHeadersReceived_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(TrustedHeaderClient_OnHeadersReceived_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(TrustedHeaderClient_OnHeadersReceived_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function TrustedHeaderClientStub(delegate) {
    this.delegate_ = delegate;
  }
  TrustedHeaderClientStub.prototype.onBeforeSendHeaders = function(headers) {
    return this.delegate_ && this.delegate_.onBeforeSendHeaders && this.delegate_.onBeforeSendHeaders(headers);
  }
  TrustedHeaderClientStub.prototype.onHeadersReceived = function(headers, remoteEndpoint, sslInfo) {
    return this.delegate_ && this.delegate_.onHeadersReceived && this.delegate_.onHeadersReceived(headers, remoteEndpoint, sslInfo);
  }

  TrustedHeaderClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  TrustedHeaderClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kTrustedHeaderClient_OnBeforeSendHeaders_Name:
      var params = reader.decodeStruct(TrustedHeaderClient_OnBeforeSendHeaders_Params);
      this.onBeforeSendHeaders(params.headers).then(function(response) {
        var responseParams =
            new TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams();
        responseParams.result = response.result;
        responseParams.headers = response.headers;
        var builder = new codec.MessageV1Builder(
            kTrustedHeaderClient_OnBeforeSendHeaders_Name,
            codec.align(TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kTrustedHeaderClient_OnHeadersReceived_Name:
      var params = reader.decodeStruct(TrustedHeaderClient_OnHeadersReceived_Params);
      this.onHeadersReceived(params.headers, params.remoteEndpoint, params.sslInfo).then(function(response) {
        var responseParams =
            new TrustedHeaderClient_OnHeadersReceived_ResponseParams();
        responseParams.result = response.result;
        responseParams.headers = response.headers;
        responseParams.preserveFragmentOnRedirectUrl = response.preserveFragmentOnRedirectUrl;
        var builder = new codec.MessageV1Builder(
            kTrustedHeaderClient_OnHeadersReceived_Name,
            codec.align(TrustedHeaderClient_OnHeadersReceived_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(TrustedHeaderClient_OnHeadersReceived_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateTrustedHeaderClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kTrustedHeaderClient_OnBeforeSendHeaders_Name:
        if (message.expectsResponse())
          paramsClass = TrustedHeaderClient_OnBeforeSendHeaders_Params;
      break;
      case kTrustedHeaderClient_OnHeadersReceived_Name:
        if (message.expectsResponse())
          paramsClass = TrustedHeaderClient_OnHeadersReceived_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateTrustedHeaderClientResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kTrustedHeaderClient_OnBeforeSendHeaders_Name:
        if (message.isResponse())
          paramsClass = TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams;
        break;
      case kTrustedHeaderClient_OnHeadersReceived_Name:
        if (message.isResponse())
          paramsClass = TrustedHeaderClient_OnHeadersReceived_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var TrustedHeaderClient = {
    name: 'network.mojom.TrustedHeaderClient',
    kVersion: 0,
    ptrClass: TrustedHeaderClientPtr,
    proxyClass: TrustedHeaderClientProxy,
    stubClass: TrustedHeaderClientStub,
    validateRequest: validateTrustedHeaderClientRequest,
    validateResponse: validateTrustedHeaderClientResponse,
  };
  TrustedHeaderClientStub.prototype.validator = validateTrustedHeaderClientRequest;
  TrustedHeaderClientProxy.prototype.validator = validateTrustedHeaderClientResponse;
  var kTrustedURLLoaderHeaderClient_OnLoaderCreated_Name = 0;
  var kTrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Name = 1;

  function TrustedURLLoaderHeaderClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(TrustedURLLoaderHeaderClient,
                                                   handleOrPtrInfo);
  }

  function TrustedURLLoaderHeaderClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        TrustedURLLoaderHeaderClient, associatedInterfacePtrInfo);
  }

  TrustedURLLoaderHeaderClientAssociatedPtr.prototype =
      Object.create(TrustedURLLoaderHeaderClientPtr.prototype);
  TrustedURLLoaderHeaderClientAssociatedPtr.prototype.constructor =
      TrustedURLLoaderHeaderClientAssociatedPtr;

  function TrustedURLLoaderHeaderClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  TrustedURLLoaderHeaderClientPtr.prototype.onLoaderCreated = function() {
    return TrustedURLLoaderHeaderClientProxy.prototype.onLoaderCreated
        .apply(this.ptr.getProxy(), arguments);
  };

  TrustedURLLoaderHeaderClientProxy.prototype.onLoaderCreated = function(requestId, headerClient) {
    var params_ = new TrustedURLLoaderHeaderClient_OnLoaderCreated_Params();
    params_.requestId = requestId;
    params_.headerClient = headerClient;
    var builder = new codec.MessageV0Builder(
        kTrustedURLLoaderHeaderClient_OnLoaderCreated_Name,
        codec.align(TrustedURLLoaderHeaderClient_OnLoaderCreated_Params.encodedSize));
    builder.encodeStruct(TrustedURLLoaderHeaderClient_OnLoaderCreated_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  TrustedURLLoaderHeaderClientPtr.prototype.onLoaderForCorsPreflightCreated = function() {
    return TrustedURLLoaderHeaderClientProxy.prototype.onLoaderForCorsPreflightCreated
        .apply(this.ptr.getProxy(), arguments);
  };

  TrustedURLLoaderHeaderClientProxy.prototype.onLoaderForCorsPreflightCreated = function(request, headerClient) {
    var params_ = new TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params();
    params_.request = request;
    params_.headerClient = headerClient;
    var builder = new codec.MessageV0Builder(
        kTrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Name,
        codec.align(TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params.encodedSize));
    builder.encodeStruct(TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function TrustedURLLoaderHeaderClientStub(delegate) {
    this.delegate_ = delegate;
  }
  TrustedURLLoaderHeaderClientStub.prototype.onLoaderCreated = function(requestId, headerClient) {
    return this.delegate_ && this.delegate_.onLoaderCreated && this.delegate_.onLoaderCreated(requestId, headerClient);
  }
  TrustedURLLoaderHeaderClientStub.prototype.onLoaderForCorsPreflightCreated = function(request, headerClient) {
    return this.delegate_ && this.delegate_.onLoaderForCorsPreflightCreated && this.delegate_.onLoaderForCorsPreflightCreated(request, headerClient);
  }

  TrustedURLLoaderHeaderClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kTrustedURLLoaderHeaderClient_OnLoaderCreated_Name:
      var params = reader.decodeStruct(TrustedURLLoaderHeaderClient_OnLoaderCreated_Params);
      this.onLoaderCreated(params.requestId, params.headerClient);
      return true;
    case kTrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Name:
      var params = reader.decodeStruct(TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params);
      this.onLoaderForCorsPreflightCreated(params.request, params.headerClient);
      return true;
    default:
      return false;
    }
  };

  TrustedURLLoaderHeaderClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateTrustedURLLoaderHeaderClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kTrustedURLLoaderHeaderClient_OnLoaderCreated_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = TrustedURLLoaderHeaderClient_OnLoaderCreated_Params;
      break;
      case kTrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateTrustedURLLoaderHeaderClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var TrustedURLLoaderHeaderClient = {
    name: 'network.mojom.TrustedURLLoaderHeaderClient',
    kVersion: 0,
    ptrClass: TrustedURLLoaderHeaderClientPtr,
    proxyClass: TrustedURLLoaderHeaderClientProxy,
    stubClass: TrustedURLLoaderHeaderClientStub,
    validateRequest: validateTrustedURLLoaderHeaderClientRequest,
    validateResponse: null,
  };
  TrustedURLLoaderHeaderClientStub.prototype.validator = validateTrustedURLLoaderHeaderClientRequest;
  TrustedURLLoaderHeaderClientProxy.prototype.validator = null;

  function PreloadedSharedDictionaryInfoHandlePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PreloadedSharedDictionaryInfoHandle,
                                                   handleOrPtrInfo);
  }

  function PreloadedSharedDictionaryInfoHandleAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PreloadedSharedDictionaryInfoHandle, associatedInterfacePtrInfo);
  }

  PreloadedSharedDictionaryInfoHandleAssociatedPtr.prototype =
      Object.create(PreloadedSharedDictionaryInfoHandlePtr.prototype);
  PreloadedSharedDictionaryInfoHandleAssociatedPtr.prototype.constructor =
      PreloadedSharedDictionaryInfoHandleAssociatedPtr;

  function PreloadedSharedDictionaryInfoHandleProxy(receiver) {
    this.receiver_ = receiver;
  }

  function PreloadedSharedDictionaryInfoHandleStub(delegate) {
    this.delegate_ = delegate;
  }

  PreloadedSharedDictionaryInfoHandleStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  PreloadedSharedDictionaryInfoHandleStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validatePreloadedSharedDictionaryInfoHandleRequest(messageValidator) {
    return validator.validationError.NONE;
  }

  function validatePreloadedSharedDictionaryInfoHandleResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var PreloadedSharedDictionaryInfoHandle = {
    name: 'network.mojom.PreloadedSharedDictionaryInfoHandle',
    kVersion: 0,
    ptrClass: PreloadedSharedDictionaryInfoHandlePtr,
    proxyClass: PreloadedSharedDictionaryInfoHandleProxy,
    stubClass: PreloadedSharedDictionaryInfoHandleStub,
    validateRequest: validatePreloadedSharedDictionaryInfoHandleRequest,
    validateResponse: null,
  };
  PreloadedSharedDictionaryInfoHandleStub.prototype.validator = validatePreloadedSharedDictionaryInfoHandleRequest;
  PreloadedSharedDictionaryInfoHandleProxy.prototype.validator = null;
  var kDurableMessageCollector_Configure_Name = 0;
  var kDurableMessageCollector_Retrieve_Name = 1;

  function DurableMessageCollectorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(DurableMessageCollector,
                                                   handleOrPtrInfo);
  }

  function DurableMessageCollectorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        DurableMessageCollector, associatedInterfacePtrInfo);
  }

  DurableMessageCollectorAssociatedPtr.prototype =
      Object.create(DurableMessageCollectorPtr.prototype);
  DurableMessageCollectorAssociatedPtr.prototype.constructor =
      DurableMessageCollectorAssociatedPtr;

  function DurableMessageCollectorProxy(receiver) {
    this.receiver_ = receiver;
  }
  DurableMessageCollectorPtr.prototype.configure = function() {
    return DurableMessageCollectorProxy.prototype.configure
        .apply(this.ptr.getProxy(), arguments);
  };

  DurableMessageCollectorProxy.prototype.configure = function(config) {
    var params_ = new DurableMessageCollector_Configure_Params();
    params_.config = config;
    var builder = new codec.MessageV0Builder(
        kDurableMessageCollector_Configure_Name,
        codec.align(DurableMessageCollector_Configure_Params.encodedSize));
    builder.encodeStruct(DurableMessageCollector_Configure_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DurableMessageCollectorPtr.prototype.retrieve = function() {
    return DurableMessageCollectorProxy.prototype.retrieve
        .apply(this.ptr.getProxy(), arguments);
  };

  DurableMessageCollectorProxy.prototype.retrieve = function(devtoolsRequestId) {
    var params_ = new DurableMessageCollector_Retrieve_Params();
    params_.devtoolsRequestId = devtoolsRequestId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDurableMessageCollector_Retrieve_Name,
          codec.align(DurableMessageCollector_Retrieve_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DurableMessageCollector_Retrieve_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DurableMessageCollector_Retrieve_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function DurableMessageCollectorStub(delegate) {
    this.delegate_ = delegate;
  }
  DurableMessageCollectorStub.prototype.configure = function(config) {
    return this.delegate_ && this.delegate_.configure && this.delegate_.configure(config);
  }
  DurableMessageCollectorStub.prototype.retrieve = function(devtoolsRequestId) {
    return this.delegate_ && this.delegate_.retrieve && this.delegate_.retrieve(devtoolsRequestId);
  }

  DurableMessageCollectorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kDurableMessageCollector_Configure_Name:
      var params = reader.decodeStruct(DurableMessageCollector_Configure_Params);
      this.configure(params.config);
      return true;
    default:
      return false;
    }
  };

  DurableMessageCollectorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kDurableMessageCollector_Retrieve_Name:
      var params = reader.decodeStruct(DurableMessageCollector_Retrieve_Params);
      this.retrieve(params.devtoolsRequestId).then(function(response) {
        var responseParams =
            new DurableMessageCollector_Retrieve_ResponseParams();
        responseParams.message = response.message;
        var builder = new codec.MessageV1Builder(
            kDurableMessageCollector_Retrieve_Name,
            codec.align(DurableMessageCollector_Retrieve_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DurableMessageCollector_Retrieve_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateDurableMessageCollectorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kDurableMessageCollector_Configure_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DurableMessageCollector_Configure_Params;
      break;
      case kDurableMessageCollector_Retrieve_Name:
        if (message.expectsResponse())
          paramsClass = DurableMessageCollector_Retrieve_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateDurableMessageCollectorResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kDurableMessageCollector_Retrieve_Name:
        if (message.isResponse())
          paramsClass = DurableMessageCollector_Retrieve_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var DurableMessageCollector = {
    name: 'network.mojom.DurableMessageCollector',
    kVersion: 0,
    ptrClass: DurableMessageCollectorPtr,
    proxyClass: DurableMessageCollectorProxy,
    stubClass: DurableMessageCollectorStub,
    validateRequest: validateDurableMessageCollectorRequest,
    validateResponse: validateDurableMessageCollectorResponse,
  };
  DurableMessageCollectorStub.prototype.validator = validateDurableMessageCollectorRequest;
  DurableMessageCollectorProxy.prototype.validator = validateDurableMessageCollectorResponse;
  var kNetworkContext_SetClient_Name = 0;
  var kNetworkContext_CreateURLLoaderFactory_Name = 1;
  var kNetworkContext_ResetURLLoaderFactories_Name = 2;
  var kNetworkContext_GetViaObliviousHttp_Name = 3;
  var kNetworkContext_GetCookieManager_Name = 4;
  var kNetworkContext_GetRestrictedCookieManager_Name = 5;
  var kNetworkContext_GetTrustTokenQueryAnswerer_Name = 6;
  var kNetworkContext_ClearTrustTokenData_Name = 7;
  var kNetworkContext_ClearTrustTokenSessionOnlyData_Name = 8;
  var kNetworkContext_GetStoredTrustTokenCounts_Name = 9;
  var kNetworkContext_GetPrivateStateTokenRedemptionRecords_Name = 10;
  var kNetworkContext_DeleteStoredTrustTokens_Name = 11;
  var kNetworkContext_SetBlockTrustTokens_Name = 12;
  var kNetworkContext_ClearNetworkingHistoryBetween_Name = 13;
  var kNetworkContext_ClearHttpCache_Name = 14;
  var kNetworkContext_ComputeHttpCacheSize_Name = 15;
  var kNetworkContext_NotifyBrowserIdle_Name = 16;
  var kNetworkContext_NotifyExternalCacheHit_Name = 17;
  var kNetworkContext_ClearHostCache_Name = 18;
  var kNetworkContext_ClearHttpAuthCache_Name = 19;
  var kNetworkContext_ClearCorsPreflightCache_Name = 20;
  var kNetworkContext_ClearReportingCacheReports_Name = 21;
  var kNetworkContext_ClearReportingCacheClients_Name = 22;
  var kNetworkContext_ClearNetworkErrorLogging_Name = 23;
  var kNetworkContext_ClearDomainReliability_Name = 24;
  var kNetworkContext_ClearSharedDictionaryCache_Name = 25;
  var kNetworkContext_ClearSharedDictionaryCacheForIsolationKey_Name = 26;
  var kNetworkContext_SetDocumentReportingEndpoints_Name = 27;
  var kNetworkContext_SetEnterpriseReportingEndpoints_Name = 28;
  var kNetworkContext_SendReportsAndRemoveSource_Name = 29;
  var kNetworkContext_QueueReport_Name = 30;
  var kNetworkContext_QueueEnterpriseReport_Name = 31;
  var kNetworkContext_QueueSignedExchangeReport_Name = 32;
  var kNetworkContext_CloseAllConnections_Name = 33;
  var kNetworkContext_CloseIdleConnections_Name = 34;
  var kNetworkContext_SetNetworkConditions_Name = 35;
  var kNetworkContext_EnableDurableMessageCollector_Name = 36;
  var kNetworkContext_SetAcceptLanguage_Name = 37;
  var kNetworkContext_SetEnableReferrers_Name = 38;
  var kNetworkContext_SetCTPolicy_Name = 39;
  var kNetworkContext_CreateUDPSocket_Name = 40;
  var kNetworkContext_CreateRestrictedUDPSocket_Name = 41;
  var kNetworkContext_CreateTCPServerSocket_Name = 42;
  var kNetworkContext_CreateTCPConnectedSocket_Name = 43;
  var kNetworkContext_CreateTCPBoundSocket_Name = 44;
  var kNetworkContext_CreateProxyResolvingSocketFactory_Name = 45;
  var kNetworkContext_LookUpProxyForURL_Name = 46;
  var kNetworkContext_ForceReloadProxyConfig_Name = 47;
  var kNetworkContext_ClearBadProxiesCache_Name = 48;
  var kNetworkContext_CreateWebSocket_Name = 49;
  var kNetworkContext_CreateWebTransport_Name = 50;
  var kNetworkContext_CreateNetLogExporter_Name = 51;
  var kNetworkContext_PreconnectSockets_Name = 52;
  var kNetworkContext_CreateP2PSocketManager_Name = 53;
  var kNetworkContext_CreateMdnsResponder_Name = 54;
  var kNetworkContext_ResolveHost_Name = 55;
  var kNetworkContext_CreateHostResolver_Name = 56;
  var kNetworkContext_VerifyCert_Name = 57;
  var kNetworkContext_VerifyCertForSignedExchange_Name = 58;
  var kNetworkContext_Verify2QwacCertBinding_Name = 59;
  var kNetworkContext_AddHSTS_Name = 60;
  var kNetworkContext_IsHSTSActiveForHost_Name = 61;
  var kNetworkContext_GetHSTSState_Name = 62;
  var kNetworkContext_SetCorsOriginAccessListsForOrigin_Name = 63;
  var kNetworkContext_DeleteDynamicDataForHost_Name = 64;
  var kNetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Name = 65;
  var kNetworkContext_SaveHttpAuthCacheProxyEntries_Name = 66;
  var kNetworkContext_LoadHttpAuthCacheProxyEntries_Name = 67;
  var kNetworkContext_AddAuthCacheEntry_Name = 68;
  var kNetworkContext_SetCorsNonWildcardRequestHeadersSupport_Name = 69;
  var kNetworkContext_EnableStaticKeyPinningForTesting_Name = 70;
  var kNetworkContext_VerifyCertificateForTesting_Name = 71;
  var kNetworkContext_GetTrustAnchorIDsForTesting_Name = 72;
  var kNetworkContext_AddDomainReliabilityContextForTesting_Name = 73;
  var kNetworkContext_ForceDomainReliabilityUploadsForTesting_Name = 74;
  var kNetworkContext_SetSCTAuditingMode_Name = 75;
  var kNetworkContext_AddReportingApiObserver_Name = 76;
  var kNetworkContext_GetSharedDictionaryUsageInfo_Name = 77;
  var kNetworkContext_GetSharedDictionaryInfo_Name = 78;
  var kNetworkContext_GetSharedDictionaryOriginsBetween_Name = 79;
  var kNetworkContext_SetSharedDictionaryCacheMaxSize_Name = 80;
  var kNetworkContext_PreloadSharedDictionaryInfoForDocument_Name = 81;
  var kNetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Name = 82;
  var kNetworkContext_FlushCachedClientCertIfNeeded_Name = 83;
  var kNetworkContext_FlushMatchingCachedClientCert_Name = 84;
  var kNetworkContext_RevokeNetworkForNonces_Name = 85;
  var kNetworkContext_ClearNonces_Name = 86;
  var kNetworkContext_ExemptUrlFromNetworkRevocationForNonce_Name = 87;
  var kNetworkContext_Prefetch_Name = 88;
  var kNetworkContext_GetBoundNetworkForTesting_Name = 89;
  var kNetworkContext_GetDeviceBoundSessionManager_Name = 90;
  var kNetworkContext_AddQuicHints_Name = 91;

  function NetworkContextPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(NetworkContext,
                                                   handleOrPtrInfo);
  }

  function NetworkContextAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        NetworkContext, associatedInterfacePtrInfo);
  }

  NetworkContextAssociatedPtr.prototype =
      Object.create(NetworkContextPtr.prototype);
  NetworkContextAssociatedPtr.prototype.constructor =
      NetworkContextAssociatedPtr;

  function NetworkContextProxy(receiver) {
    this.receiver_ = receiver;
  }
  NetworkContextPtr.prototype.setClient = function() {
    return NetworkContextProxy.prototype.setClient
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.setClient = function(client) {
    var params_ = new NetworkContext_SetClient_Params();
    params_.client = client;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_SetClient_Name,
        codec.align(NetworkContext_SetClient_Params.encodedSize));
    builder.encodeStruct(NetworkContext_SetClient_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.createURLLoaderFactory = function() {
    return NetworkContextProxy.prototype.createURLLoaderFactory
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.createURLLoaderFactory = function(urlLoaderFactory, params) {
    var params_ = new NetworkContext_CreateURLLoaderFactory_Params();
    params_.urlLoaderFactory = urlLoaderFactory;
    params_.params = params;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_CreateURLLoaderFactory_Name,
        codec.align(NetworkContext_CreateURLLoaderFactory_Params.encodedSize));
    builder.encodeStruct(NetworkContext_CreateURLLoaderFactory_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.resetURLLoaderFactories = function() {
    return NetworkContextProxy.prototype.resetURLLoaderFactories
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.resetURLLoaderFactories = function() {
    var params_ = new NetworkContext_ResetURLLoaderFactories_Params();
    var builder = new codec.MessageV0Builder(
        kNetworkContext_ResetURLLoaderFactories_Name,
        codec.align(NetworkContext_ResetURLLoaderFactories_Params.encodedSize));
    builder.encodeStruct(NetworkContext_ResetURLLoaderFactories_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.getViaObliviousHttp = function() {
    return NetworkContextProxy.prototype.getViaObliviousHttp
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.getViaObliviousHttp = function(request, client) {
    var params_ = new NetworkContext_GetViaObliviousHttp_Params();
    params_.request = request;
    params_.client = client;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_GetViaObliviousHttp_Name,
        codec.align(NetworkContext_GetViaObliviousHttp_Params.encodedSize));
    builder.encodeStruct(NetworkContext_GetViaObliviousHttp_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.getCookieManager = function() {
    return NetworkContextProxy.prototype.getCookieManager
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.getCookieManager = function(cookieManager) {
    var params_ = new NetworkContext_GetCookieManager_Params();
    params_.cookieManager = cookieManager;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_GetCookieManager_Name,
        codec.align(NetworkContext_GetCookieManager_Params.encodedSize));
    builder.encodeStruct(NetworkContext_GetCookieManager_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.getRestrictedCookieManager = function() {
    return NetworkContextProxy.prototype.getRestrictedCookieManager
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.getRestrictedCookieManager = function(restrictedCookieManager, role, origin, isolationInfo, cookieSettingOverrides, devtoolsCookieSettingOverrides, cookieObserver) {
    var params_ = new NetworkContext_GetRestrictedCookieManager_Params();
    params_.restrictedCookieManager = restrictedCookieManager;
    params_.role = role;
    params_.origin = origin;
    params_.isolationInfo = isolationInfo;
    params_.cookieSettingOverrides = cookieSettingOverrides;
    params_.devtoolsCookieSettingOverrides = devtoolsCookieSettingOverrides;
    params_.cookieObserver = cookieObserver;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_GetRestrictedCookieManager_Name,
        codec.align(NetworkContext_GetRestrictedCookieManager_Params.encodedSize));
    builder.encodeStruct(NetworkContext_GetRestrictedCookieManager_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.getTrustTokenQueryAnswerer = function() {
    return NetworkContextProxy.prototype.getTrustTokenQueryAnswerer
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.getTrustTokenQueryAnswerer = function(trustTokenQueryAnswerer, topFrameOrigin) {
    var params_ = new NetworkContext_GetTrustTokenQueryAnswerer_Params();
    params_.trustTokenQueryAnswerer = trustTokenQueryAnswerer;
    params_.topFrameOrigin = topFrameOrigin;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_GetTrustTokenQueryAnswerer_Name,
        codec.align(NetworkContext_GetTrustTokenQueryAnswerer_Params.encodedSize));
    builder.encodeStruct(NetworkContext_GetTrustTokenQueryAnswerer_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.clearTrustTokenData = function() {
    return NetworkContextProxy.prototype.clearTrustTokenData
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.clearTrustTokenData = function(filter) {
    var params_ = new NetworkContext_ClearTrustTokenData_Params();
    params_.filter = filter;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_ClearTrustTokenData_Name,
          codec.align(NetworkContext_ClearTrustTokenData_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_ClearTrustTokenData_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_ClearTrustTokenData_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.clearTrustTokenSessionOnlyData = function() {
    return NetworkContextProxy.prototype.clearTrustTokenSessionOnlyData
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.clearTrustTokenSessionOnlyData = function() {
    var params_ = new NetworkContext_ClearTrustTokenSessionOnlyData_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_ClearTrustTokenSessionOnlyData_Name,
          codec.align(NetworkContext_ClearTrustTokenSessionOnlyData_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_ClearTrustTokenSessionOnlyData_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.getStoredTrustTokenCounts = function() {
    return NetworkContextProxy.prototype.getStoredTrustTokenCounts
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.getStoredTrustTokenCounts = function() {
    var params_ = new NetworkContext_GetStoredTrustTokenCounts_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_GetStoredTrustTokenCounts_Name,
          codec.align(NetworkContext_GetStoredTrustTokenCounts_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_GetStoredTrustTokenCounts_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_GetStoredTrustTokenCounts_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.getPrivateStateTokenRedemptionRecords = function() {
    return NetworkContextProxy.prototype.getPrivateStateTokenRedemptionRecords
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.getPrivateStateTokenRedemptionRecords = function() {
    var params_ = new NetworkContext_GetPrivateStateTokenRedemptionRecords_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_GetPrivateStateTokenRedemptionRecords_Name,
          codec.align(NetworkContext_GetPrivateStateTokenRedemptionRecords_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_GetPrivateStateTokenRedemptionRecords_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.deleteStoredTrustTokens = function() {
    return NetworkContextProxy.prototype.deleteStoredTrustTokens
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.deleteStoredTrustTokens = function(issuer) {
    var params_ = new NetworkContext_DeleteStoredTrustTokens_Params();
    params_.issuer = issuer;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_DeleteStoredTrustTokens_Name,
          codec.align(NetworkContext_DeleteStoredTrustTokens_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_DeleteStoredTrustTokens_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_DeleteStoredTrustTokens_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.setBlockTrustTokens = function() {
    return NetworkContextProxy.prototype.setBlockTrustTokens
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.setBlockTrustTokens = function(block) {
    var params_ = new NetworkContext_SetBlockTrustTokens_Params();
    params_.block = block;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_SetBlockTrustTokens_Name,
        codec.align(NetworkContext_SetBlockTrustTokens_Params.encodedSize));
    builder.encodeStruct(NetworkContext_SetBlockTrustTokens_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.clearNetworkingHistoryBetween = function() {
    return NetworkContextProxy.prototype.clearNetworkingHistoryBetween
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.clearNetworkingHistoryBetween = function(startTime, endTime) {
    var params_ = new NetworkContext_ClearNetworkingHistoryBetween_Params();
    params_.startTime = startTime;
    params_.endTime = endTime;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_ClearNetworkingHistoryBetween_Name,
          codec.align(NetworkContext_ClearNetworkingHistoryBetween_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_ClearNetworkingHistoryBetween_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_ClearNetworkingHistoryBetween_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.clearHttpCache = function() {
    return NetworkContextProxy.prototype.clearHttpCache
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.clearHttpCache = function(startTime, endTime, filter) {
    var params_ = new NetworkContext_ClearHttpCache_Params();
    params_.startTime = startTime;
    params_.endTime = endTime;
    params_.filter = filter;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_ClearHttpCache_Name,
          codec.align(NetworkContext_ClearHttpCache_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_ClearHttpCache_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_ClearHttpCache_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.computeHttpCacheSize = function() {
    return NetworkContextProxy.prototype.computeHttpCacheSize
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.computeHttpCacheSize = function(startTime, endTime) {
    var params_ = new NetworkContext_ComputeHttpCacheSize_Params();
    params_.startTime = startTime;
    params_.endTime = endTime;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_ComputeHttpCacheSize_Name,
          codec.align(NetworkContext_ComputeHttpCacheSize_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_ComputeHttpCacheSize_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_ComputeHttpCacheSize_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.notifyBrowserIdle = function() {
    return NetworkContextProxy.prototype.notifyBrowserIdle
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.notifyBrowserIdle = function() {
    var params_ = new NetworkContext_NotifyBrowserIdle_Params();
    var builder = new codec.MessageV0Builder(
        kNetworkContext_NotifyBrowserIdle_Name,
        codec.align(NetworkContext_NotifyBrowserIdle_Params.encodedSize));
    builder.encodeStruct(NetworkContext_NotifyBrowserIdle_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.notifyExternalCacheHit = function() {
    return NetworkContextProxy.prototype.notifyExternalCacheHit
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.notifyExternalCacheHit = function(url, httpMethod, key, includeCredentials) {
    var params_ = new NetworkContext_NotifyExternalCacheHit_Params();
    params_.url = url;
    params_.httpMethod = httpMethod;
    params_.key = key;
    params_.includeCredentials = includeCredentials;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_NotifyExternalCacheHit_Name,
        codec.align(NetworkContext_NotifyExternalCacheHit_Params.encodedSize));
    builder.encodeStruct(NetworkContext_NotifyExternalCacheHit_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.clearHostCache = function() {
    return NetworkContextProxy.prototype.clearHostCache
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.clearHostCache = function(filter) {
    var params_ = new NetworkContext_ClearHostCache_Params();
    params_.filter = filter;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_ClearHostCache_Name,
          codec.align(NetworkContext_ClearHostCache_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_ClearHostCache_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_ClearHostCache_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.clearHttpAuthCache = function() {
    return NetworkContextProxy.prototype.clearHttpAuthCache
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.clearHttpAuthCache = function(startTime, endTime, filter) {
    var params_ = new NetworkContext_ClearHttpAuthCache_Params();
    params_.startTime = startTime;
    params_.endTime = endTime;
    params_.filter = filter;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_ClearHttpAuthCache_Name,
          codec.align(NetworkContext_ClearHttpAuthCache_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_ClearHttpAuthCache_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_ClearHttpAuthCache_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.clearCorsPreflightCache = function() {
    return NetworkContextProxy.prototype.clearCorsPreflightCache
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.clearCorsPreflightCache = function(filter) {
    var params_ = new NetworkContext_ClearCorsPreflightCache_Params();
    params_.filter = filter;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_ClearCorsPreflightCache_Name,
          codec.align(NetworkContext_ClearCorsPreflightCache_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_ClearCorsPreflightCache_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_ClearCorsPreflightCache_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.clearReportingCacheReports = function() {
    return NetworkContextProxy.prototype.clearReportingCacheReports
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.clearReportingCacheReports = function(filter) {
    var params_ = new NetworkContext_ClearReportingCacheReports_Params();
    params_.filter = filter;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_ClearReportingCacheReports_Name,
          codec.align(NetworkContext_ClearReportingCacheReports_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_ClearReportingCacheReports_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_ClearReportingCacheReports_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.clearReportingCacheClients = function() {
    return NetworkContextProxy.prototype.clearReportingCacheClients
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.clearReportingCacheClients = function(filter) {
    var params_ = new NetworkContext_ClearReportingCacheClients_Params();
    params_.filter = filter;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_ClearReportingCacheClients_Name,
          codec.align(NetworkContext_ClearReportingCacheClients_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_ClearReportingCacheClients_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_ClearReportingCacheClients_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.clearNetworkErrorLogging = function() {
    return NetworkContextProxy.prototype.clearNetworkErrorLogging
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.clearNetworkErrorLogging = function(filter) {
    var params_ = new NetworkContext_ClearNetworkErrorLogging_Params();
    params_.filter = filter;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_ClearNetworkErrorLogging_Name,
          codec.align(NetworkContext_ClearNetworkErrorLogging_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_ClearNetworkErrorLogging_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_ClearNetworkErrorLogging_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.clearDomainReliability = function() {
    return NetworkContextProxy.prototype.clearDomainReliability
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.clearDomainReliability = function(filter, mode) {
    var params_ = new NetworkContext_ClearDomainReliability_Params();
    params_.filter = filter;
    params_.mode = mode;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_ClearDomainReliability_Name,
          codec.align(NetworkContext_ClearDomainReliability_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_ClearDomainReliability_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_ClearDomainReliability_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.clearSharedDictionaryCache = function() {
    return NetworkContextProxy.prototype.clearSharedDictionaryCache
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.clearSharedDictionaryCache = function(startTime, endTime, filter) {
    var params_ = new NetworkContext_ClearSharedDictionaryCache_Params();
    params_.startTime = startTime;
    params_.endTime = endTime;
    params_.filter = filter;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_ClearSharedDictionaryCache_Name,
          codec.align(NetworkContext_ClearSharedDictionaryCache_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_ClearSharedDictionaryCache_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_ClearSharedDictionaryCache_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.clearSharedDictionaryCacheForIsolationKey = function() {
    return NetworkContextProxy.prototype.clearSharedDictionaryCacheForIsolationKey
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.clearSharedDictionaryCacheForIsolationKey = function(isolationKey) {
    var params_ = new NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params();
    params_.isolationKey = isolationKey;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_ClearSharedDictionaryCacheForIsolationKey_Name,
          codec.align(NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.setDocumentReportingEndpoints = function() {
    return NetworkContextProxy.prototype.setDocumentReportingEndpoints
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.setDocumentReportingEndpoints = function(reportingSource, origin, isolationInfo, endpoints) {
    var params_ = new NetworkContext_SetDocumentReportingEndpoints_Params();
    params_.reportingSource = reportingSource;
    params_.origin = origin;
    params_.isolationInfo = isolationInfo;
    params_.endpoints = endpoints;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_SetDocumentReportingEndpoints_Name,
        codec.align(NetworkContext_SetDocumentReportingEndpoints_Params.encodedSize));
    builder.encodeStruct(NetworkContext_SetDocumentReportingEndpoints_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.setEnterpriseReportingEndpoints = function() {
    return NetworkContextProxy.prototype.setEnterpriseReportingEndpoints
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.setEnterpriseReportingEndpoints = function(endpoints) {
    var params_ = new NetworkContext_SetEnterpriseReportingEndpoints_Params();
    params_.endpoints = endpoints;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_SetEnterpriseReportingEndpoints_Name,
        codec.align(NetworkContext_SetEnterpriseReportingEndpoints_Params.encodedSize));
    builder.encodeStruct(NetworkContext_SetEnterpriseReportingEndpoints_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.sendReportsAndRemoveSource = function() {
    return NetworkContextProxy.prototype.sendReportsAndRemoveSource
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.sendReportsAndRemoveSource = function(reportingSource) {
    var params_ = new NetworkContext_SendReportsAndRemoveSource_Params();
    params_.reportingSource = reportingSource;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_SendReportsAndRemoveSource_Name,
        codec.align(NetworkContext_SendReportsAndRemoveSource_Params.encodedSize));
    builder.encodeStruct(NetworkContext_SendReportsAndRemoveSource_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.queueReport = function() {
    return NetworkContextProxy.prototype.queueReport
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.queueReport = function(type, group, url, reportingSource, networkAnonymizationKey, body) {
    var params_ = new NetworkContext_QueueReport_Params();
    params_.type = type;
    params_.group = group;
    params_.url = url;
    params_.reportingSource = reportingSource;
    params_.networkAnonymizationKey = networkAnonymizationKey;
    params_.body = body;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_QueueReport_Name,
        codec.align(NetworkContext_QueueReport_Params.encodedSize));
    builder.encodeStruct(NetworkContext_QueueReport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.queueEnterpriseReport = function() {
    return NetworkContextProxy.prototype.queueEnterpriseReport
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.queueEnterpriseReport = function(type, group, url, body) {
    var params_ = new NetworkContext_QueueEnterpriseReport_Params();
    params_.type = type;
    params_.group = group;
    params_.url = url;
    params_.body = body;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_QueueEnterpriseReport_Name,
        codec.align(NetworkContext_QueueEnterpriseReport_Params.encodedSize));
    builder.encodeStruct(NetworkContext_QueueEnterpriseReport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.queueSignedExchangeReport = function() {
    return NetworkContextProxy.prototype.queueSignedExchangeReport
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.queueSignedExchangeReport = function(report, networkAnonymizationKey) {
    var params_ = new NetworkContext_QueueSignedExchangeReport_Params();
    params_.report = report;
    params_.networkAnonymizationKey = networkAnonymizationKey;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_QueueSignedExchangeReport_Name,
        codec.align(NetworkContext_QueueSignedExchangeReport_Params.encodedSize));
    builder.encodeStruct(NetworkContext_QueueSignedExchangeReport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.closeAllConnections = function() {
    return NetworkContextProxy.prototype.closeAllConnections
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.closeAllConnections = function() {
    var params_ = new NetworkContext_CloseAllConnections_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_CloseAllConnections_Name,
          codec.align(NetworkContext_CloseAllConnections_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_CloseAllConnections_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_CloseAllConnections_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.closeIdleConnections = function() {
    return NetworkContextProxy.prototype.closeIdleConnections
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.closeIdleConnections = function() {
    var params_ = new NetworkContext_CloseIdleConnections_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_CloseIdleConnections_Name,
          codec.align(NetworkContext_CloseIdleConnections_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_CloseIdleConnections_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_CloseIdleConnections_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.setNetworkConditions = function() {
    return NetworkContextProxy.prototype.setNetworkConditions
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.setNetworkConditions = function(throttlingProfileId, conditions) {
    var params_ = new NetworkContext_SetNetworkConditions_Params();
    params_.throttlingProfileId = throttlingProfileId;
    params_.conditions = conditions;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_SetNetworkConditions_Name,
        codec.align(NetworkContext_SetNetworkConditions_Params.encodedSize));
    builder.encodeStruct(NetworkContext_SetNetworkConditions_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.enableDurableMessageCollector = function() {
    return NetworkContextProxy.prototype.enableDurableMessageCollector
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.enableDurableMessageCollector = function(throttlingProfileId, receiver) {
    var params_ = new NetworkContext_EnableDurableMessageCollector_Params();
    params_.throttlingProfileId = throttlingProfileId;
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_EnableDurableMessageCollector_Name,
        codec.align(NetworkContext_EnableDurableMessageCollector_Params.encodedSize));
    builder.encodeStruct(NetworkContext_EnableDurableMessageCollector_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.setAcceptLanguage = function() {
    return NetworkContextProxy.prototype.setAcceptLanguage
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.setAcceptLanguage = function(newAcceptLanguage) {
    var params_ = new NetworkContext_SetAcceptLanguage_Params();
    params_.newAcceptLanguage = newAcceptLanguage;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_SetAcceptLanguage_Name,
        codec.align(NetworkContext_SetAcceptLanguage_Params.encodedSize));
    builder.encodeStruct(NetworkContext_SetAcceptLanguage_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.setEnableReferrers = function() {
    return NetworkContextProxy.prototype.setEnableReferrers
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.setEnableReferrers = function(enableReferrers) {
    var params_ = new NetworkContext_SetEnableReferrers_Params();
    params_.enableReferrers = enableReferrers;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_SetEnableReferrers_Name,
        codec.align(NetworkContext_SetEnableReferrers_Params.encodedSize));
    builder.encodeStruct(NetworkContext_SetEnableReferrers_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.setCTPolicy = function() {
    return NetworkContextProxy.prototype.setCTPolicy
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.setCTPolicy = function(ctPolicy) {
    var params_ = new NetworkContext_SetCTPolicy_Params();
    params_.ctPolicy = ctPolicy;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_SetCTPolicy_Name,
        codec.align(NetworkContext_SetCTPolicy_Params.encodedSize));
    builder.encodeStruct(NetworkContext_SetCTPolicy_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.createUDPSocket = function() {
    return NetworkContextProxy.prototype.createUDPSocket
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.createUDPSocket = function(receiver, listener) {
    var params_ = new NetworkContext_CreateUDPSocket_Params();
    params_.receiver = receiver;
    params_.listener = listener;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_CreateUDPSocket_Name,
        codec.align(NetworkContext_CreateUDPSocket_Params.encodedSize));
    builder.encodeStruct(NetworkContext_CreateUDPSocket_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.createRestrictedUDPSocket = function() {
    return NetworkContextProxy.prototype.createRestrictedUDPSocket
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.createRestrictedUDPSocket = function(addr, mode, trafficAnnotation, params, receiver, listener, allowMulticast) {
    var params_ = new NetworkContext_CreateRestrictedUDPSocket_Params();
    params_.addr = addr;
    params_.mode = mode;
    params_.trafficAnnotation = trafficAnnotation;
    params_.params = params;
    params_.receiver = receiver;
    params_.listener = listener;
    params_.allowMulticast = allowMulticast;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_CreateRestrictedUDPSocket_Name,
          codec.align(NetworkContext_CreateRestrictedUDPSocket_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_CreateRestrictedUDPSocket_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_CreateRestrictedUDPSocket_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.createTCPServerSocket = function() {
    return NetworkContextProxy.prototype.createTCPServerSocket
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.createTCPServerSocket = function(localAddr, options, trafficAnnotation, socket) {
    var params_ = new NetworkContext_CreateTCPServerSocket_Params();
    params_.localAddr = localAddr;
    params_.options = options;
    params_.trafficAnnotation = trafficAnnotation;
    params_.socket = socket;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_CreateTCPServerSocket_Name,
          codec.align(NetworkContext_CreateTCPServerSocket_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_CreateTCPServerSocket_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_CreateTCPServerSocket_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.createTCPConnectedSocket = function() {
    return NetworkContextProxy.prototype.createTCPConnectedSocket
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.createTCPConnectedSocket = function(localAddr, remoteAddrList, tcpConnectedSocketOptions, trafficAnnotation, socket, observer) {
    var params_ = new NetworkContext_CreateTCPConnectedSocket_Params();
    params_.localAddr = localAddr;
    params_.remoteAddrList = remoteAddrList;
    params_.tcpConnectedSocketOptions = tcpConnectedSocketOptions;
    params_.trafficAnnotation = trafficAnnotation;
    params_.socket = socket;
    params_.observer = observer;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_CreateTCPConnectedSocket_Name,
          codec.align(NetworkContext_CreateTCPConnectedSocket_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_CreateTCPConnectedSocket_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_CreateTCPConnectedSocket_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.createTCPBoundSocket = function() {
    return NetworkContextProxy.prototype.createTCPBoundSocket
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.createTCPBoundSocket = function(localAddr, trafficAnnotation, socket) {
    var params_ = new NetworkContext_CreateTCPBoundSocket_Params();
    params_.localAddr = localAddr;
    params_.trafficAnnotation = trafficAnnotation;
    params_.socket = socket;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_CreateTCPBoundSocket_Name,
          codec.align(NetworkContext_CreateTCPBoundSocket_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_CreateTCPBoundSocket_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_CreateTCPBoundSocket_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.createProxyResolvingSocketFactory = function() {
    return NetworkContextProxy.prototype.createProxyResolvingSocketFactory
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.createProxyResolvingSocketFactory = function(factory) {
    var params_ = new NetworkContext_CreateProxyResolvingSocketFactory_Params();
    params_.factory = factory;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_CreateProxyResolvingSocketFactory_Name,
        codec.align(NetworkContext_CreateProxyResolvingSocketFactory_Params.encodedSize));
    builder.encodeStruct(NetworkContext_CreateProxyResolvingSocketFactory_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.lookUpProxyForURL = function() {
    return NetworkContextProxy.prototype.lookUpProxyForURL
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.lookUpProxyForURL = function(url, networkAnonymizationKey, proxyLookupClient) {
    var params_ = new NetworkContext_LookUpProxyForURL_Params();
    params_.url = url;
    params_.networkAnonymizationKey = networkAnonymizationKey;
    params_.proxyLookupClient = proxyLookupClient;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_LookUpProxyForURL_Name,
        codec.align(NetworkContext_LookUpProxyForURL_Params.encodedSize));
    builder.encodeStruct(NetworkContext_LookUpProxyForURL_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.forceReloadProxyConfig = function() {
    return NetworkContextProxy.prototype.forceReloadProxyConfig
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.forceReloadProxyConfig = function() {
    var params_ = new NetworkContext_ForceReloadProxyConfig_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_ForceReloadProxyConfig_Name,
          codec.align(NetworkContext_ForceReloadProxyConfig_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_ForceReloadProxyConfig_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_ForceReloadProxyConfig_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.clearBadProxiesCache = function() {
    return NetworkContextProxy.prototype.clearBadProxiesCache
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.clearBadProxiesCache = function() {
    var params_ = new NetworkContext_ClearBadProxiesCache_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_ClearBadProxiesCache_Name,
          codec.align(NetworkContext_ClearBadProxiesCache_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_ClearBadProxiesCache_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_ClearBadProxiesCache_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.createWebSocket = function() {
    return NetworkContextProxy.prototype.createWebSocket
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.createWebSocket = function(url, requestedProtocols, siteForCookies, storageAccessApiStatus, isolationInfo, additionalHeaders, processId, origin, clientSecurityState, options, trafficAnnotation, handshakeClient, urlLoaderNetworkObserver, authHandler, headerClient, throttlingProfileId) {
    var params_ = new NetworkContext_CreateWebSocket_Params();
    params_.url = url;
    params_.requestedProtocols = requestedProtocols;
    params_.siteForCookies = siteForCookies;
    params_.storageAccessApiStatus = storageAccessApiStatus;
    params_.isolationInfo = isolationInfo;
    params_.additionalHeaders = additionalHeaders;
    params_.processId = processId;
    params_.origin = origin;
    params_.clientSecurityState = clientSecurityState;
    params_.options = options;
    params_.trafficAnnotation = trafficAnnotation;
    params_.handshakeClient = handshakeClient;
    params_.urlLoaderNetworkObserver = urlLoaderNetworkObserver;
    params_.authHandler = authHandler;
    params_.headerClient = headerClient;
    params_.throttlingProfileId = throttlingProfileId;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_CreateWebSocket_Name,
        codec.align(NetworkContext_CreateWebSocket_Params.encodedSize));
    builder.encodeStruct(NetworkContext_CreateWebSocket_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.createWebTransport = function() {
    return NetworkContextProxy.prototype.createWebTransport
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.createWebTransport = function(url, origin, networkAnonymizationKey, fingerprints, applicationProtocols, handshakeClient, urlLoaderNetworkObserver, clientSecurityState) {
    var params_ = new NetworkContext_CreateWebTransport_Params();
    params_.url = url;
    params_.origin = origin;
    params_.networkAnonymizationKey = networkAnonymizationKey;
    params_.fingerprints = fingerprints;
    params_.applicationProtocols = applicationProtocols;
    params_.handshakeClient = handshakeClient;
    params_.urlLoaderNetworkObserver = urlLoaderNetworkObserver;
    params_.clientSecurityState = clientSecurityState;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_CreateWebTransport_Name,
        codec.align(NetworkContext_CreateWebTransport_Params.encodedSize));
    builder.encodeStruct(NetworkContext_CreateWebTransport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.createNetLogExporter = function() {
    return NetworkContextProxy.prototype.createNetLogExporter
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.createNetLogExporter = function(receiver) {
    var params_ = new NetworkContext_CreateNetLogExporter_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_CreateNetLogExporter_Name,
        codec.align(NetworkContext_CreateNetLogExporter_Params.encodedSize));
    builder.encodeStruct(NetworkContext_CreateNetLogExporter_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.preconnectSockets = function() {
    return NetworkContextProxy.prototype.preconnectSockets
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.preconnectSockets = function(numStreams, url, credentialsMode, networkAnonymizationKey, trafficAnnotation, keepaliveConfig, observerClient) {
    var params_ = new NetworkContext_PreconnectSockets_Params();
    params_.numStreams = numStreams;
    params_.url = url;
    params_.credentialsMode = credentialsMode;
    params_.networkAnonymizationKey = networkAnonymizationKey;
    params_.trafficAnnotation = trafficAnnotation;
    params_.keepaliveConfig = keepaliveConfig;
    params_.observerClient = observerClient;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_PreconnectSockets_Name,
        codec.align(NetworkContext_PreconnectSockets_Params.encodedSize));
    builder.encodeStruct(NetworkContext_PreconnectSockets_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.createP2PSocketManager = function() {
    return NetworkContextProxy.prototype.createP2PSocketManager
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.createP2PSocketManager = function(networkAnonymizationKey, client, trustedSocketManager, socketManager) {
    var params_ = new NetworkContext_CreateP2PSocketManager_Params();
    params_.networkAnonymizationKey = networkAnonymizationKey;
    params_.client = client;
    params_.trustedSocketManager = trustedSocketManager;
    params_.socketManager = socketManager;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_CreateP2PSocketManager_Name,
        codec.align(NetworkContext_CreateP2PSocketManager_Params.encodedSize));
    builder.encodeStruct(NetworkContext_CreateP2PSocketManager_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.createMdnsResponder = function() {
    return NetworkContextProxy.prototype.createMdnsResponder
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.createMdnsResponder = function(responderReceiver) {
    var params_ = new NetworkContext_CreateMdnsResponder_Params();
    params_.responderReceiver = responderReceiver;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_CreateMdnsResponder_Name,
        codec.align(NetworkContext_CreateMdnsResponder_Params.encodedSize));
    builder.encodeStruct(NetworkContext_CreateMdnsResponder_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.resolveHost = function() {
    return NetworkContextProxy.prototype.resolveHost
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.resolveHost = function(host, networkAnonymizationKey, optionalParameters, responseClient) {
    var params_ = new NetworkContext_ResolveHost_Params();
    params_.host = host;
    params_.networkAnonymizationKey = networkAnonymizationKey;
    params_.optionalParameters = optionalParameters;
    params_.responseClient = responseClient;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_ResolveHost_Name,
        codec.align(NetworkContext_ResolveHost_Params.encodedSize));
    builder.encodeStruct(NetworkContext_ResolveHost_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.createHostResolver = function() {
    return NetworkContextProxy.prototype.createHostResolver
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.createHostResolver = function(configOverrides, hostResolver) {
    var params_ = new NetworkContext_CreateHostResolver_Params();
    params_.configOverrides = configOverrides;
    params_.hostResolver = hostResolver;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_CreateHostResolver_Name,
        codec.align(NetworkContext_CreateHostResolver_Params.encodedSize));
    builder.encodeStruct(NetworkContext_CreateHostResolver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.verifyCert = function() {
    return NetworkContextProxy.prototype.verifyCert
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.verifyCert = function(certificate, hostPort, ocspResponse, sctList) {
    var params_ = new NetworkContext_VerifyCert_Params();
    params_.certificate = certificate;
    params_.hostPort = hostPort;
    params_.ocspResponse = ocspResponse;
    params_.sctList = sctList;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_VerifyCert_Name,
          codec.align(NetworkContext_VerifyCert_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_VerifyCert_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_VerifyCert_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.verifyCertForSignedExchange = function() {
    return NetworkContextProxy.prototype.verifyCertForSignedExchange
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.verifyCertForSignedExchange = function(certificate, hostPort, ocspResponse, sctList) {
    var params_ = new NetworkContext_VerifyCertForSignedExchange_Params();
    params_.certificate = certificate;
    params_.hostPort = hostPort;
    params_.ocspResponse = ocspResponse;
    params_.sctList = sctList;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_VerifyCertForSignedExchange_Name,
          codec.align(NetworkContext_VerifyCertForSignedExchange_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_VerifyCertForSignedExchange_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_VerifyCertForSignedExchange_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.verify2QwacCertBinding = function() {
    return NetworkContextProxy.prototype.verify2QwacCertBinding
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.verify2QwacCertBinding = function(binding, hostname, tlsCertificate) {
    var params_ = new NetworkContext_Verify2QwacCertBinding_Params();
    params_.binding = binding;
    params_.hostname = hostname;
    params_.tlsCertificate = tlsCertificate;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_Verify2QwacCertBinding_Name,
          codec.align(NetworkContext_Verify2QwacCertBinding_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_Verify2QwacCertBinding_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_Verify2QwacCertBinding_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.addHSTS = function() {
    return NetworkContextProxy.prototype.addHSTS
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.addHSTS = function(host, expiry, includeSubdomains) {
    var params_ = new NetworkContext_AddHSTS_Params();
    params_.host = host;
    params_.expiry = expiry;
    params_.includeSubdomains = includeSubdomains;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_AddHSTS_Name,
          codec.align(NetworkContext_AddHSTS_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_AddHSTS_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_AddHSTS_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.isHSTSActiveForHost = function() {
    return NetworkContextProxy.prototype.isHSTSActiveForHost
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.isHSTSActiveForHost = function(host, isTopLevelNav) {
    var params_ = new NetworkContext_IsHSTSActiveForHost_Params();
    params_.host = host;
    params_.isTopLevelNav = isTopLevelNav;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_IsHSTSActiveForHost_Name,
          codec.align(NetworkContext_IsHSTSActiveForHost_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_IsHSTSActiveForHost_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_IsHSTSActiveForHost_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.getHSTSState = function() {
    return NetworkContextProxy.prototype.getHSTSState
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.getHSTSState = function(domain) {
    var params_ = new NetworkContext_GetHSTSState_Params();
    params_.domain = domain;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_GetHSTSState_Name,
          codec.align(NetworkContext_GetHSTSState_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_GetHSTSState_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_GetHSTSState_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.setCorsOriginAccessListsForOrigin = function() {
    return NetworkContextProxy.prototype.setCorsOriginAccessListsForOrigin
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.setCorsOriginAccessListsForOrigin = function(sourceOrigin, allowPatterns, blockPatterns) {
    var params_ = new NetworkContext_SetCorsOriginAccessListsForOrigin_Params();
    params_.sourceOrigin = sourceOrigin;
    params_.allowPatterns = allowPatterns;
    params_.blockPatterns = blockPatterns;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_SetCorsOriginAccessListsForOrigin_Name,
          codec.align(NetworkContext_SetCorsOriginAccessListsForOrigin_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_SetCorsOriginAccessListsForOrigin_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.deleteDynamicDataForHost = function() {
    return NetworkContextProxy.prototype.deleteDynamicDataForHost
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.deleteDynamicDataForHost = function(host) {
    var params_ = new NetworkContext_DeleteDynamicDataForHost_Params();
    params_.host = host;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_DeleteDynamicDataForHost_Name,
          codec.align(NetworkContext_DeleteDynamicDataForHost_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_DeleteDynamicDataForHost_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_DeleteDynamicDataForHost_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.setSplitAuthCacheByNetworkAnonymizationKey = function() {
    return NetworkContextProxy.prototype.setSplitAuthCacheByNetworkAnonymizationKey
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.setSplitAuthCacheByNetworkAnonymizationKey = function(splitAuthCacheByNetworkAnonymizationKey) {
    var params_ = new NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params();
    params_.splitAuthCacheByNetworkAnonymizationKey = splitAuthCacheByNetworkAnonymizationKey;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Name,
        codec.align(NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params.encodedSize));
    builder.encodeStruct(NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.saveHttpAuthCacheProxyEntries = function() {
    return NetworkContextProxy.prototype.saveHttpAuthCacheProxyEntries
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.saveHttpAuthCacheProxyEntries = function() {
    var params_ = new NetworkContext_SaveHttpAuthCacheProxyEntries_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_SaveHttpAuthCacheProxyEntries_Name,
          codec.align(NetworkContext_SaveHttpAuthCacheProxyEntries_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_SaveHttpAuthCacheProxyEntries_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.loadHttpAuthCacheProxyEntries = function() {
    return NetworkContextProxy.prototype.loadHttpAuthCacheProxyEntries
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.loadHttpAuthCacheProxyEntries = function(cacheKey) {
    var params_ = new NetworkContext_LoadHttpAuthCacheProxyEntries_Params();
    params_.cacheKey = cacheKey;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_LoadHttpAuthCacheProxyEntries_Name,
          codec.align(NetworkContext_LoadHttpAuthCacheProxyEntries_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_LoadHttpAuthCacheProxyEntries_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.addAuthCacheEntry = function() {
    return NetworkContextProxy.prototype.addAuthCacheEntry
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.addAuthCacheEntry = function(challenge, networkAnonymizationKey, credentials) {
    var params_ = new NetworkContext_AddAuthCacheEntry_Params();
    params_.challenge = challenge;
    params_.networkAnonymizationKey = networkAnonymizationKey;
    params_.credentials = credentials;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_AddAuthCacheEntry_Name,
          codec.align(NetworkContext_AddAuthCacheEntry_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_AddAuthCacheEntry_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_AddAuthCacheEntry_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.setCorsNonWildcardRequestHeadersSupport = function() {
    return NetworkContextProxy.prototype.setCorsNonWildcardRequestHeadersSupport
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.setCorsNonWildcardRequestHeadersSupport = function(value) {
    var params_ = new NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params();
    params_.value = value;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_SetCorsNonWildcardRequestHeadersSupport_Name,
        codec.align(NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params.encodedSize));
    builder.encodeStruct(NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.enableStaticKeyPinningForTesting = function() {
    return NetworkContextProxy.prototype.enableStaticKeyPinningForTesting
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.enableStaticKeyPinningForTesting = function() {
    var params_ = new NetworkContext_EnableStaticKeyPinningForTesting_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_EnableStaticKeyPinningForTesting_Name,
          codec.align(NetworkContext_EnableStaticKeyPinningForTesting_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_EnableStaticKeyPinningForTesting_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.verifyCertificateForTesting = function() {
    return NetworkContextProxy.prototype.verifyCertificateForTesting
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.verifyCertificateForTesting = function(certificate, hostname, ocspResponse, sctList) {
    var params_ = new NetworkContext_VerifyCertificateForTesting_Params();
    params_.certificate = certificate;
    params_.hostname = hostname;
    params_.ocspResponse = ocspResponse;
    params_.sctList = sctList;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_VerifyCertificateForTesting_Name,
          codec.align(NetworkContext_VerifyCertificateForTesting_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_VerifyCertificateForTesting_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_VerifyCertificateForTesting_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.getTrustAnchorIDsForTesting = function() {
    return NetworkContextProxy.prototype.getTrustAnchorIDsForTesting
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.getTrustAnchorIDsForTesting = function() {
    var params_ = new NetworkContext_GetTrustAnchorIDsForTesting_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_GetTrustAnchorIDsForTesting_Name,
          codec.align(NetworkContext_GetTrustAnchorIDsForTesting_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_GetTrustAnchorIDsForTesting_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.addDomainReliabilityContextForTesting = function() {
    return NetworkContextProxy.prototype.addDomainReliabilityContextForTesting
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.addDomainReliabilityContextForTesting = function(origin, uploadUrl) {
    var params_ = new NetworkContext_AddDomainReliabilityContextForTesting_Params();
    params_.origin = origin;
    params_.uploadUrl = uploadUrl;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_AddDomainReliabilityContextForTesting_Name,
          codec.align(NetworkContext_AddDomainReliabilityContextForTesting_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_AddDomainReliabilityContextForTesting_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.forceDomainReliabilityUploadsForTesting = function() {
    return NetworkContextProxy.prototype.forceDomainReliabilityUploadsForTesting
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.forceDomainReliabilityUploadsForTesting = function() {
    var params_ = new NetworkContext_ForceDomainReliabilityUploadsForTesting_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_ForceDomainReliabilityUploadsForTesting_Name,
          codec.align(NetworkContext_ForceDomainReliabilityUploadsForTesting_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_ForceDomainReliabilityUploadsForTesting_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.setSCTAuditingMode = function() {
    return NetworkContextProxy.prototype.setSCTAuditingMode
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.setSCTAuditingMode = function(mode) {
    var params_ = new NetworkContext_SetSCTAuditingMode_Params();
    params_.mode = mode;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_SetSCTAuditingMode_Name,
        codec.align(NetworkContext_SetSCTAuditingMode_Params.encodedSize));
    builder.encodeStruct(NetworkContext_SetSCTAuditingMode_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.addReportingApiObserver = function() {
    return NetworkContextProxy.prototype.addReportingApiObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.addReportingApiObserver = function(observer) {
    var params_ = new NetworkContext_AddReportingApiObserver_Params();
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_AddReportingApiObserver_Name,
        codec.align(NetworkContext_AddReportingApiObserver_Params.encodedSize));
    builder.encodeStruct(NetworkContext_AddReportingApiObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.getSharedDictionaryUsageInfo = function() {
    return NetworkContextProxy.prototype.getSharedDictionaryUsageInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.getSharedDictionaryUsageInfo = function() {
    var params_ = new NetworkContext_GetSharedDictionaryUsageInfo_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_GetSharedDictionaryUsageInfo_Name,
          codec.align(NetworkContext_GetSharedDictionaryUsageInfo_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_GetSharedDictionaryUsageInfo_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.getSharedDictionaryInfo = function() {
    return NetworkContextProxy.prototype.getSharedDictionaryInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.getSharedDictionaryInfo = function(isolationKey) {
    var params_ = new NetworkContext_GetSharedDictionaryInfo_Params();
    params_.isolationKey = isolationKey;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_GetSharedDictionaryInfo_Name,
          codec.align(NetworkContext_GetSharedDictionaryInfo_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_GetSharedDictionaryInfo_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_GetSharedDictionaryInfo_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.getSharedDictionaryOriginsBetween = function() {
    return NetworkContextProxy.prototype.getSharedDictionaryOriginsBetween
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.getSharedDictionaryOriginsBetween = function(startTime, endTime) {
    var params_ = new NetworkContext_GetSharedDictionaryOriginsBetween_Params();
    params_.startTime = startTime;
    params_.endTime = endTime;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_GetSharedDictionaryOriginsBetween_Name,
          codec.align(NetworkContext_GetSharedDictionaryOriginsBetween_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_GetSharedDictionaryOriginsBetween_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.setSharedDictionaryCacheMaxSize = function() {
    return NetworkContextProxy.prototype.setSharedDictionaryCacheMaxSize
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.setSharedDictionaryCacheMaxSize = function(cacheMaxSize) {
    var params_ = new NetworkContext_SetSharedDictionaryCacheMaxSize_Params();
    params_.cacheMaxSize = cacheMaxSize;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_SetSharedDictionaryCacheMaxSize_Name,
        codec.align(NetworkContext_SetSharedDictionaryCacheMaxSize_Params.encodedSize));
    builder.encodeStruct(NetworkContext_SetSharedDictionaryCacheMaxSize_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.preloadSharedDictionaryInfoForDocument = function() {
    return NetworkContextProxy.prototype.preloadSharedDictionaryInfoForDocument
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.preloadSharedDictionaryInfoForDocument = function(urls, preloadHandle) {
    var params_ = new NetworkContext_PreloadSharedDictionaryInfoForDocument_Params();
    params_.urls = urls;
    params_.preloadHandle = preloadHandle;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_PreloadSharedDictionaryInfoForDocument_Name,
        codec.align(NetworkContext_PreloadSharedDictionaryInfoForDocument_Params.encodedSize));
    builder.encodeStruct(NetworkContext_PreloadSharedDictionaryInfoForDocument_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.hasPreloadedSharedDictionaryInfoForTesting = function() {
    return NetworkContextProxy.prototype.hasPreloadedSharedDictionaryInfoForTesting
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.hasPreloadedSharedDictionaryInfoForTesting = function() {
    var params_ = new NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Name,
          codec.align(NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.flushCachedClientCertIfNeeded = function() {
    return NetworkContextProxy.prototype.flushCachedClientCertIfNeeded
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.flushCachedClientCertIfNeeded = function(host, certificate) {
    var params_ = new NetworkContext_FlushCachedClientCertIfNeeded_Params();
    params_.host = host;
    params_.certificate = certificate;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_FlushCachedClientCertIfNeeded_Name,
        codec.align(NetworkContext_FlushCachedClientCertIfNeeded_Params.encodedSize));
    builder.encodeStruct(NetworkContext_FlushCachedClientCertIfNeeded_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.flushMatchingCachedClientCert = function() {
    return NetworkContextProxy.prototype.flushMatchingCachedClientCert
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.flushMatchingCachedClientCert = function(certificate) {
    var params_ = new NetworkContext_FlushMatchingCachedClientCert_Params();
    params_.certificate = certificate;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_FlushMatchingCachedClientCert_Name,
        codec.align(NetworkContext_FlushMatchingCachedClientCert_Params.encodedSize));
    builder.encodeStruct(NetworkContext_FlushMatchingCachedClientCert_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.revokeNetworkForNonces = function() {
    return NetworkContextProxy.prototype.revokeNetworkForNonces
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.revokeNetworkForNonces = function(noncesToPatterns) {
    var params_ = new NetworkContext_RevokeNetworkForNonces_Params();
    params_.noncesToPatterns = noncesToPatterns;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_RevokeNetworkForNonces_Name,
          codec.align(NetworkContext_RevokeNetworkForNonces_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_RevokeNetworkForNonces_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_RevokeNetworkForNonces_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.clearNonces = function() {
    return NetworkContextProxy.prototype.clearNonces
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.clearNonces = function(nonces) {
    var params_ = new NetworkContext_ClearNonces_Params();
    params_.nonces = nonces;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_ClearNonces_Name,
        codec.align(NetworkContext_ClearNonces_Params.encodedSize));
    builder.encodeStruct(NetworkContext_ClearNonces_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.exemptUrlFromNetworkRevocationForNonce = function() {
    return NetworkContextProxy.prototype.exemptUrlFromNetworkRevocationForNonce
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.exemptUrlFromNetworkRevocationForNonce = function(exemptedUrl, nonce) {
    var params_ = new NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params();
    params_.exemptedUrl = exemptedUrl;
    params_.nonce = nonce;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_ExemptUrlFromNetworkRevocationForNonce_Name,
          codec.align(NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.prefetch = function() {
    return NetworkContextProxy.prototype.prefetch
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.prefetch = function(requestId, options, request, trafficAnnotation) {
    var params_ = new NetworkContext_Prefetch_Params();
    params_.requestId = requestId;
    params_.options = options;
    params_.request = request;
    params_.trafficAnnotation = trafficAnnotation;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_Prefetch_Name,
        codec.align(NetworkContext_Prefetch_Params.encodedSize));
    builder.encodeStruct(NetworkContext_Prefetch_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.getBoundNetworkForTesting = function() {
    return NetworkContextProxy.prototype.getBoundNetworkForTesting
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.getBoundNetworkForTesting = function() {
    var params_ = new NetworkContext_GetBoundNetworkForTesting_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kNetworkContext_GetBoundNetworkForTesting_Name,
          codec.align(NetworkContext_GetBoundNetworkForTesting_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NetworkContext_GetBoundNetworkForTesting_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NetworkContext_GetBoundNetworkForTesting_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NetworkContextPtr.prototype.getDeviceBoundSessionManager = function() {
    return NetworkContextProxy.prototype.getDeviceBoundSessionManager
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.getDeviceBoundSessionManager = function(deviceBoundSessionManager) {
    var params_ = new NetworkContext_GetDeviceBoundSessionManager_Params();
    params_.deviceBoundSessionManager = deviceBoundSessionManager;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_GetDeviceBoundSessionManager_Name,
        codec.align(NetworkContext_GetDeviceBoundSessionManager_Params.encodedSize));
    builder.encodeStruct(NetworkContext_GetDeviceBoundSessionManager_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NetworkContextPtr.prototype.addQuicHints = function() {
    return NetworkContextProxy.prototype.addQuicHints
        .apply(this.ptr.getProxy(), arguments);
  };

  NetworkContextProxy.prototype.addQuicHints = function(origins, networkAnonymizationKey) {
    var params_ = new NetworkContext_AddQuicHints_Params();
    params_.origins = origins;
    params_.networkAnonymizationKey = networkAnonymizationKey;
    var builder = new codec.MessageV0Builder(
        kNetworkContext_AddQuicHints_Name,
        codec.align(NetworkContext_AddQuicHints_Params.encodedSize));
    builder.encodeStruct(NetworkContext_AddQuicHints_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function NetworkContextStub(delegate) {
    this.delegate_ = delegate;
  }
  NetworkContextStub.prototype.setClient = function(client) {
    return this.delegate_ && this.delegate_.setClient && this.delegate_.setClient(client);
  }
  NetworkContextStub.prototype.createURLLoaderFactory = function(urlLoaderFactory, params) {
    return this.delegate_ && this.delegate_.createURLLoaderFactory && this.delegate_.createURLLoaderFactory(urlLoaderFactory, params);
  }
  NetworkContextStub.prototype.resetURLLoaderFactories = function() {
    return this.delegate_ && this.delegate_.resetURLLoaderFactories && this.delegate_.resetURLLoaderFactories();
  }
  NetworkContextStub.prototype.getViaObliviousHttp = function(request, client) {
    return this.delegate_ && this.delegate_.getViaObliviousHttp && this.delegate_.getViaObliviousHttp(request, client);
  }
  NetworkContextStub.prototype.getCookieManager = function(cookieManager) {
    return this.delegate_ && this.delegate_.getCookieManager && this.delegate_.getCookieManager(cookieManager);
  }
  NetworkContextStub.prototype.getRestrictedCookieManager = function(restrictedCookieManager, role, origin, isolationInfo, cookieSettingOverrides, devtoolsCookieSettingOverrides, cookieObserver) {
    return this.delegate_ && this.delegate_.getRestrictedCookieManager && this.delegate_.getRestrictedCookieManager(restrictedCookieManager, role, origin, isolationInfo, cookieSettingOverrides, devtoolsCookieSettingOverrides, cookieObserver);
  }
  NetworkContextStub.prototype.getTrustTokenQueryAnswerer = function(trustTokenQueryAnswerer, topFrameOrigin) {
    return this.delegate_ && this.delegate_.getTrustTokenQueryAnswerer && this.delegate_.getTrustTokenQueryAnswerer(trustTokenQueryAnswerer, topFrameOrigin);
  }
  NetworkContextStub.prototype.clearTrustTokenData = function(filter) {
    return this.delegate_ && this.delegate_.clearTrustTokenData && this.delegate_.clearTrustTokenData(filter);
  }
  NetworkContextStub.prototype.clearTrustTokenSessionOnlyData = function() {
    return this.delegate_ && this.delegate_.clearTrustTokenSessionOnlyData && this.delegate_.clearTrustTokenSessionOnlyData();
  }
  NetworkContextStub.prototype.getStoredTrustTokenCounts = function() {
    return this.delegate_ && this.delegate_.getStoredTrustTokenCounts && this.delegate_.getStoredTrustTokenCounts();
  }
  NetworkContextStub.prototype.getPrivateStateTokenRedemptionRecords = function() {
    return this.delegate_ && this.delegate_.getPrivateStateTokenRedemptionRecords && this.delegate_.getPrivateStateTokenRedemptionRecords();
  }
  NetworkContextStub.prototype.deleteStoredTrustTokens = function(issuer) {
    return this.delegate_ && this.delegate_.deleteStoredTrustTokens && this.delegate_.deleteStoredTrustTokens(issuer);
  }
  NetworkContextStub.prototype.setBlockTrustTokens = function(block) {
    return this.delegate_ && this.delegate_.setBlockTrustTokens && this.delegate_.setBlockTrustTokens(block);
  }
  NetworkContextStub.prototype.clearNetworkingHistoryBetween = function(startTime, endTime) {
    return this.delegate_ && this.delegate_.clearNetworkingHistoryBetween && this.delegate_.clearNetworkingHistoryBetween(startTime, endTime);
  }
  NetworkContextStub.prototype.clearHttpCache = function(startTime, endTime, filter) {
    return this.delegate_ && this.delegate_.clearHttpCache && this.delegate_.clearHttpCache(startTime, endTime, filter);
  }
  NetworkContextStub.prototype.computeHttpCacheSize = function(startTime, endTime) {
    return this.delegate_ && this.delegate_.computeHttpCacheSize && this.delegate_.computeHttpCacheSize(startTime, endTime);
  }
  NetworkContextStub.prototype.notifyBrowserIdle = function() {
    return this.delegate_ && this.delegate_.notifyBrowserIdle && this.delegate_.notifyBrowserIdle();
  }
  NetworkContextStub.prototype.notifyExternalCacheHit = function(url, httpMethod, key, includeCredentials) {
    return this.delegate_ && this.delegate_.notifyExternalCacheHit && this.delegate_.notifyExternalCacheHit(url, httpMethod, key, includeCredentials);
  }
  NetworkContextStub.prototype.clearHostCache = function(filter) {
    return this.delegate_ && this.delegate_.clearHostCache && this.delegate_.clearHostCache(filter);
  }
  NetworkContextStub.prototype.clearHttpAuthCache = function(startTime, endTime, filter) {
    return this.delegate_ && this.delegate_.clearHttpAuthCache && this.delegate_.clearHttpAuthCache(startTime, endTime, filter);
  }
  NetworkContextStub.prototype.clearCorsPreflightCache = function(filter) {
    return this.delegate_ && this.delegate_.clearCorsPreflightCache && this.delegate_.clearCorsPreflightCache(filter);
  }
  NetworkContextStub.prototype.clearReportingCacheReports = function(filter) {
    return this.delegate_ && this.delegate_.clearReportingCacheReports && this.delegate_.clearReportingCacheReports(filter);
  }
  NetworkContextStub.prototype.clearReportingCacheClients = function(filter) {
    return this.delegate_ && this.delegate_.clearReportingCacheClients && this.delegate_.clearReportingCacheClients(filter);
  }
  NetworkContextStub.prototype.clearNetworkErrorLogging = function(filter) {
    return this.delegate_ && this.delegate_.clearNetworkErrorLogging && this.delegate_.clearNetworkErrorLogging(filter);
  }
  NetworkContextStub.prototype.clearDomainReliability = function(filter, mode) {
    return this.delegate_ && this.delegate_.clearDomainReliability && this.delegate_.clearDomainReliability(filter, mode);
  }
  NetworkContextStub.prototype.clearSharedDictionaryCache = function(startTime, endTime, filter) {
    return this.delegate_ && this.delegate_.clearSharedDictionaryCache && this.delegate_.clearSharedDictionaryCache(startTime, endTime, filter);
  }
  NetworkContextStub.prototype.clearSharedDictionaryCacheForIsolationKey = function(isolationKey) {
    return this.delegate_ && this.delegate_.clearSharedDictionaryCacheForIsolationKey && this.delegate_.clearSharedDictionaryCacheForIsolationKey(isolationKey);
  }
  NetworkContextStub.prototype.setDocumentReportingEndpoints = function(reportingSource, origin, isolationInfo, endpoints) {
    return this.delegate_ && this.delegate_.setDocumentReportingEndpoints && this.delegate_.setDocumentReportingEndpoints(reportingSource, origin, isolationInfo, endpoints);
  }
  NetworkContextStub.prototype.setEnterpriseReportingEndpoints = function(endpoints) {
    return this.delegate_ && this.delegate_.setEnterpriseReportingEndpoints && this.delegate_.setEnterpriseReportingEndpoints(endpoints);
  }
  NetworkContextStub.prototype.sendReportsAndRemoveSource = function(reportingSource) {
    return this.delegate_ && this.delegate_.sendReportsAndRemoveSource && this.delegate_.sendReportsAndRemoveSource(reportingSource);
  }
  NetworkContextStub.prototype.queueReport = function(type, group, url, reportingSource, networkAnonymizationKey, body) {
    return this.delegate_ && this.delegate_.queueReport && this.delegate_.queueReport(type, group, url, reportingSource, networkAnonymizationKey, body);
  }
  NetworkContextStub.prototype.queueEnterpriseReport = function(type, group, url, body) {
    return this.delegate_ && this.delegate_.queueEnterpriseReport && this.delegate_.queueEnterpriseReport(type, group, url, body);
  }
  NetworkContextStub.prototype.queueSignedExchangeReport = function(report, networkAnonymizationKey) {
    return this.delegate_ && this.delegate_.queueSignedExchangeReport && this.delegate_.queueSignedExchangeReport(report, networkAnonymizationKey);
  }
  NetworkContextStub.prototype.closeAllConnections = function() {
    return this.delegate_ && this.delegate_.closeAllConnections && this.delegate_.closeAllConnections();
  }
  NetworkContextStub.prototype.closeIdleConnections = function() {
    return this.delegate_ && this.delegate_.closeIdleConnections && this.delegate_.closeIdleConnections();
  }
  NetworkContextStub.prototype.setNetworkConditions = function(throttlingProfileId, conditions) {
    return this.delegate_ && this.delegate_.setNetworkConditions && this.delegate_.setNetworkConditions(throttlingProfileId, conditions);
  }
  NetworkContextStub.prototype.enableDurableMessageCollector = function(throttlingProfileId, receiver) {
    return this.delegate_ && this.delegate_.enableDurableMessageCollector && this.delegate_.enableDurableMessageCollector(throttlingProfileId, receiver);
  }
  NetworkContextStub.prototype.setAcceptLanguage = function(newAcceptLanguage) {
    return this.delegate_ && this.delegate_.setAcceptLanguage && this.delegate_.setAcceptLanguage(newAcceptLanguage);
  }
  NetworkContextStub.prototype.setEnableReferrers = function(enableReferrers) {
    return this.delegate_ && this.delegate_.setEnableReferrers && this.delegate_.setEnableReferrers(enableReferrers);
  }
  NetworkContextStub.prototype.setCTPolicy = function(ctPolicy) {
    return this.delegate_ && this.delegate_.setCTPolicy && this.delegate_.setCTPolicy(ctPolicy);
  }
  NetworkContextStub.prototype.createUDPSocket = function(receiver, listener) {
    return this.delegate_ && this.delegate_.createUDPSocket && this.delegate_.createUDPSocket(receiver, listener);
  }
  NetworkContextStub.prototype.createRestrictedUDPSocket = function(addr, mode, trafficAnnotation, params, receiver, listener, allowMulticast) {
    return this.delegate_ && this.delegate_.createRestrictedUDPSocket && this.delegate_.createRestrictedUDPSocket(addr, mode, trafficAnnotation, params, receiver, listener, allowMulticast);
  }
  NetworkContextStub.prototype.createTCPServerSocket = function(localAddr, options, trafficAnnotation, socket) {
    return this.delegate_ && this.delegate_.createTCPServerSocket && this.delegate_.createTCPServerSocket(localAddr, options, trafficAnnotation, socket);
  }
  NetworkContextStub.prototype.createTCPConnectedSocket = function(localAddr, remoteAddrList, tcpConnectedSocketOptions, trafficAnnotation, socket, observer) {
    return this.delegate_ && this.delegate_.createTCPConnectedSocket && this.delegate_.createTCPConnectedSocket(localAddr, remoteAddrList, tcpConnectedSocketOptions, trafficAnnotation, socket, observer);
  }
  NetworkContextStub.prototype.createTCPBoundSocket = function(localAddr, trafficAnnotation, socket) {
    return this.delegate_ && this.delegate_.createTCPBoundSocket && this.delegate_.createTCPBoundSocket(localAddr, trafficAnnotation, socket);
  }
  NetworkContextStub.prototype.createProxyResolvingSocketFactory = function(factory) {
    return this.delegate_ && this.delegate_.createProxyResolvingSocketFactory && this.delegate_.createProxyResolvingSocketFactory(factory);
  }
  NetworkContextStub.prototype.lookUpProxyForURL = function(url, networkAnonymizationKey, proxyLookupClient) {
    return this.delegate_ && this.delegate_.lookUpProxyForURL && this.delegate_.lookUpProxyForURL(url, networkAnonymizationKey, proxyLookupClient);
  }
  NetworkContextStub.prototype.forceReloadProxyConfig = function() {
    return this.delegate_ && this.delegate_.forceReloadProxyConfig && this.delegate_.forceReloadProxyConfig();
  }
  NetworkContextStub.prototype.clearBadProxiesCache = function() {
    return this.delegate_ && this.delegate_.clearBadProxiesCache && this.delegate_.clearBadProxiesCache();
  }
  NetworkContextStub.prototype.createWebSocket = function(url, requestedProtocols, siteForCookies, storageAccessApiStatus, isolationInfo, additionalHeaders, processId, origin, clientSecurityState, options, trafficAnnotation, handshakeClient, urlLoaderNetworkObserver, authHandler, headerClient, throttlingProfileId) {
    return this.delegate_ && this.delegate_.createWebSocket && this.delegate_.createWebSocket(url, requestedProtocols, siteForCookies, storageAccessApiStatus, isolationInfo, additionalHeaders, processId, origin, clientSecurityState, options, trafficAnnotation, handshakeClient, urlLoaderNetworkObserver, authHandler, headerClient, throttlingProfileId);
  }
  NetworkContextStub.prototype.createWebTransport = function(url, origin, networkAnonymizationKey, fingerprints, applicationProtocols, handshakeClient, urlLoaderNetworkObserver, clientSecurityState) {
    return this.delegate_ && this.delegate_.createWebTransport && this.delegate_.createWebTransport(url, origin, networkAnonymizationKey, fingerprints, applicationProtocols, handshakeClient, urlLoaderNetworkObserver, clientSecurityState);
  }
  NetworkContextStub.prototype.createNetLogExporter = function(receiver) {
    return this.delegate_ && this.delegate_.createNetLogExporter && this.delegate_.createNetLogExporter(receiver);
  }
  NetworkContextStub.prototype.preconnectSockets = function(numStreams, url, credentialsMode, networkAnonymizationKey, trafficAnnotation, keepaliveConfig, observerClient) {
    return this.delegate_ && this.delegate_.preconnectSockets && this.delegate_.preconnectSockets(numStreams, url, credentialsMode, networkAnonymizationKey, trafficAnnotation, keepaliveConfig, observerClient);
  }
  NetworkContextStub.prototype.createP2PSocketManager = function(networkAnonymizationKey, client, trustedSocketManager, socketManager) {
    return this.delegate_ && this.delegate_.createP2PSocketManager && this.delegate_.createP2PSocketManager(networkAnonymizationKey, client, trustedSocketManager, socketManager);
  }
  NetworkContextStub.prototype.createMdnsResponder = function(responderReceiver) {
    return this.delegate_ && this.delegate_.createMdnsResponder && this.delegate_.createMdnsResponder(responderReceiver);
  }
  NetworkContextStub.prototype.resolveHost = function(host, networkAnonymizationKey, optionalParameters, responseClient) {
    return this.delegate_ && this.delegate_.resolveHost && this.delegate_.resolveHost(host, networkAnonymizationKey, optionalParameters, responseClient);
  }
  NetworkContextStub.prototype.createHostResolver = function(configOverrides, hostResolver) {
    return this.delegate_ && this.delegate_.createHostResolver && this.delegate_.createHostResolver(configOverrides, hostResolver);
  }
  NetworkContextStub.prototype.verifyCert = function(certificate, hostPort, ocspResponse, sctList) {
    return this.delegate_ && this.delegate_.verifyCert && this.delegate_.verifyCert(certificate, hostPort, ocspResponse, sctList);
  }
  NetworkContextStub.prototype.verifyCertForSignedExchange = function(certificate, hostPort, ocspResponse, sctList) {
    return this.delegate_ && this.delegate_.verifyCertForSignedExchange && this.delegate_.verifyCertForSignedExchange(certificate, hostPort, ocspResponse, sctList);
  }
  NetworkContextStub.prototype.verify2QwacCertBinding = function(binding, hostname, tlsCertificate) {
    return this.delegate_ && this.delegate_.verify2QwacCertBinding && this.delegate_.verify2QwacCertBinding(binding, hostname, tlsCertificate);
  }
  NetworkContextStub.prototype.addHSTS = function(host, expiry, includeSubdomains) {
    return this.delegate_ && this.delegate_.addHSTS && this.delegate_.addHSTS(host, expiry, includeSubdomains);
  }
  NetworkContextStub.prototype.isHSTSActiveForHost = function(host, isTopLevelNav) {
    return this.delegate_ && this.delegate_.isHSTSActiveForHost && this.delegate_.isHSTSActiveForHost(host, isTopLevelNav);
  }
  NetworkContextStub.prototype.getHSTSState = function(domain) {
    return this.delegate_ && this.delegate_.getHSTSState && this.delegate_.getHSTSState(domain);
  }
  NetworkContextStub.prototype.setCorsOriginAccessListsForOrigin = function(sourceOrigin, allowPatterns, blockPatterns) {
    return this.delegate_ && this.delegate_.setCorsOriginAccessListsForOrigin && this.delegate_.setCorsOriginAccessListsForOrigin(sourceOrigin, allowPatterns, blockPatterns);
  }
  NetworkContextStub.prototype.deleteDynamicDataForHost = function(host) {
    return this.delegate_ && this.delegate_.deleteDynamicDataForHost && this.delegate_.deleteDynamicDataForHost(host);
  }
  NetworkContextStub.prototype.setSplitAuthCacheByNetworkAnonymizationKey = function(splitAuthCacheByNetworkAnonymizationKey) {
    return this.delegate_ && this.delegate_.setSplitAuthCacheByNetworkAnonymizationKey && this.delegate_.setSplitAuthCacheByNetworkAnonymizationKey(splitAuthCacheByNetworkAnonymizationKey);
  }
  NetworkContextStub.prototype.saveHttpAuthCacheProxyEntries = function() {
    return this.delegate_ && this.delegate_.saveHttpAuthCacheProxyEntries && this.delegate_.saveHttpAuthCacheProxyEntries();
  }
  NetworkContextStub.prototype.loadHttpAuthCacheProxyEntries = function(cacheKey) {
    return this.delegate_ && this.delegate_.loadHttpAuthCacheProxyEntries && this.delegate_.loadHttpAuthCacheProxyEntries(cacheKey);
  }
  NetworkContextStub.prototype.addAuthCacheEntry = function(challenge, networkAnonymizationKey, credentials) {
    return this.delegate_ && this.delegate_.addAuthCacheEntry && this.delegate_.addAuthCacheEntry(challenge, networkAnonymizationKey, credentials);
  }
  NetworkContextStub.prototype.setCorsNonWildcardRequestHeadersSupport = function(value) {
    return this.delegate_ && this.delegate_.setCorsNonWildcardRequestHeadersSupport && this.delegate_.setCorsNonWildcardRequestHeadersSupport(value);
  }
  NetworkContextStub.prototype.enableStaticKeyPinningForTesting = function() {
    return this.delegate_ && this.delegate_.enableStaticKeyPinningForTesting && this.delegate_.enableStaticKeyPinningForTesting();
  }
  NetworkContextStub.prototype.verifyCertificateForTesting = function(certificate, hostname, ocspResponse, sctList) {
    return this.delegate_ && this.delegate_.verifyCertificateForTesting && this.delegate_.verifyCertificateForTesting(certificate, hostname, ocspResponse, sctList);
  }
  NetworkContextStub.prototype.getTrustAnchorIDsForTesting = function() {
    return this.delegate_ && this.delegate_.getTrustAnchorIDsForTesting && this.delegate_.getTrustAnchorIDsForTesting();
  }
  NetworkContextStub.prototype.addDomainReliabilityContextForTesting = function(origin, uploadUrl) {
    return this.delegate_ && this.delegate_.addDomainReliabilityContextForTesting && this.delegate_.addDomainReliabilityContextForTesting(origin, uploadUrl);
  }
  NetworkContextStub.prototype.forceDomainReliabilityUploadsForTesting = function() {
    return this.delegate_ && this.delegate_.forceDomainReliabilityUploadsForTesting && this.delegate_.forceDomainReliabilityUploadsForTesting();
  }
  NetworkContextStub.prototype.setSCTAuditingMode = function(mode) {
    return this.delegate_ && this.delegate_.setSCTAuditingMode && this.delegate_.setSCTAuditingMode(mode);
  }
  NetworkContextStub.prototype.addReportingApiObserver = function(observer) {
    return this.delegate_ && this.delegate_.addReportingApiObserver && this.delegate_.addReportingApiObserver(observer);
  }
  NetworkContextStub.prototype.getSharedDictionaryUsageInfo = function() {
    return this.delegate_ && this.delegate_.getSharedDictionaryUsageInfo && this.delegate_.getSharedDictionaryUsageInfo();
  }
  NetworkContextStub.prototype.getSharedDictionaryInfo = function(isolationKey) {
    return this.delegate_ && this.delegate_.getSharedDictionaryInfo && this.delegate_.getSharedDictionaryInfo(isolationKey);
  }
  NetworkContextStub.prototype.getSharedDictionaryOriginsBetween = function(startTime, endTime) {
    return this.delegate_ && this.delegate_.getSharedDictionaryOriginsBetween && this.delegate_.getSharedDictionaryOriginsBetween(startTime, endTime);
  }
  NetworkContextStub.prototype.setSharedDictionaryCacheMaxSize = function(cacheMaxSize) {
    return this.delegate_ && this.delegate_.setSharedDictionaryCacheMaxSize && this.delegate_.setSharedDictionaryCacheMaxSize(cacheMaxSize);
  }
  NetworkContextStub.prototype.preloadSharedDictionaryInfoForDocument = function(urls, preloadHandle) {
    return this.delegate_ && this.delegate_.preloadSharedDictionaryInfoForDocument && this.delegate_.preloadSharedDictionaryInfoForDocument(urls, preloadHandle);
  }
  NetworkContextStub.prototype.hasPreloadedSharedDictionaryInfoForTesting = function() {
    return this.delegate_ && this.delegate_.hasPreloadedSharedDictionaryInfoForTesting && this.delegate_.hasPreloadedSharedDictionaryInfoForTesting();
  }
  NetworkContextStub.prototype.flushCachedClientCertIfNeeded = function(host, certificate) {
    return this.delegate_ && this.delegate_.flushCachedClientCertIfNeeded && this.delegate_.flushCachedClientCertIfNeeded(host, certificate);
  }
  NetworkContextStub.prototype.flushMatchingCachedClientCert = function(certificate) {
    return this.delegate_ && this.delegate_.flushMatchingCachedClientCert && this.delegate_.flushMatchingCachedClientCert(certificate);
  }
  NetworkContextStub.prototype.revokeNetworkForNonces = function(noncesToPatterns) {
    return this.delegate_ && this.delegate_.revokeNetworkForNonces && this.delegate_.revokeNetworkForNonces(noncesToPatterns);
  }
  NetworkContextStub.prototype.clearNonces = function(nonces) {
    return this.delegate_ && this.delegate_.clearNonces && this.delegate_.clearNonces(nonces);
  }
  NetworkContextStub.prototype.exemptUrlFromNetworkRevocationForNonce = function(exemptedUrl, nonce) {
    return this.delegate_ && this.delegate_.exemptUrlFromNetworkRevocationForNonce && this.delegate_.exemptUrlFromNetworkRevocationForNonce(exemptedUrl, nonce);
  }
  NetworkContextStub.prototype.prefetch = function(requestId, options, request, trafficAnnotation) {
    return this.delegate_ && this.delegate_.prefetch && this.delegate_.prefetch(requestId, options, request, trafficAnnotation);
  }
  NetworkContextStub.prototype.getBoundNetworkForTesting = function() {
    return this.delegate_ && this.delegate_.getBoundNetworkForTesting && this.delegate_.getBoundNetworkForTesting();
  }
  NetworkContextStub.prototype.getDeviceBoundSessionManager = function(deviceBoundSessionManager) {
    return this.delegate_ && this.delegate_.getDeviceBoundSessionManager && this.delegate_.getDeviceBoundSessionManager(deviceBoundSessionManager);
  }
  NetworkContextStub.prototype.addQuicHints = function(origins, networkAnonymizationKey) {
    return this.delegate_ && this.delegate_.addQuicHints && this.delegate_.addQuicHints(origins, networkAnonymizationKey);
  }

  NetworkContextStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kNetworkContext_SetClient_Name:
      var params = reader.decodeStruct(NetworkContext_SetClient_Params);
      this.setClient(params.client);
      return true;
    case kNetworkContext_CreateURLLoaderFactory_Name:
      var params = reader.decodeStruct(NetworkContext_CreateURLLoaderFactory_Params);
      this.createURLLoaderFactory(params.urlLoaderFactory, params.params);
      return true;
    case kNetworkContext_ResetURLLoaderFactories_Name:
      var params = reader.decodeStruct(NetworkContext_ResetURLLoaderFactories_Params);
      this.resetURLLoaderFactories();
      return true;
    case kNetworkContext_GetViaObliviousHttp_Name:
      var params = reader.decodeStruct(NetworkContext_GetViaObliviousHttp_Params);
      this.getViaObliviousHttp(params.request, params.client);
      return true;
    case kNetworkContext_GetCookieManager_Name:
      var params = reader.decodeStruct(NetworkContext_GetCookieManager_Params);
      this.getCookieManager(params.cookieManager);
      return true;
    case kNetworkContext_GetRestrictedCookieManager_Name:
      var params = reader.decodeStruct(NetworkContext_GetRestrictedCookieManager_Params);
      this.getRestrictedCookieManager(params.restrictedCookieManager, params.role, params.origin, params.isolationInfo, params.cookieSettingOverrides, params.devtoolsCookieSettingOverrides, params.cookieObserver);
      return true;
    case kNetworkContext_GetTrustTokenQueryAnswerer_Name:
      var params = reader.decodeStruct(NetworkContext_GetTrustTokenQueryAnswerer_Params);
      this.getTrustTokenQueryAnswerer(params.trustTokenQueryAnswerer, params.topFrameOrigin);
      return true;
    case kNetworkContext_SetBlockTrustTokens_Name:
      var params = reader.decodeStruct(NetworkContext_SetBlockTrustTokens_Params);
      this.setBlockTrustTokens(params.block);
      return true;
    case kNetworkContext_NotifyBrowserIdle_Name:
      var params = reader.decodeStruct(NetworkContext_NotifyBrowserIdle_Params);
      this.notifyBrowserIdle();
      return true;
    case kNetworkContext_NotifyExternalCacheHit_Name:
      var params = reader.decodeStruct(NetworkContext_NotifyExternalCacheHit_Params);
      this.notifyExternalCacheHit(params.url, params.httpMethod, params.key, params.includeCredentials);
      return true;
    case kNetworkContext_SetDocumentReportingEndpoints_Name:
      var params = reader.decodeStruct(NetworkContext_SetDocumentReportingEndpoints_Params);
      this.setDocumentReportingEndpoints(params.reportingSource, params.origin, params.isolationInfo, params.endpoints);
      return true;
    case kNetworkContext_SetEnterpriseReportingEndpoints_Name:
      var params = reader.decodeStruct(NetworkContext_SetEnterpriseReportingEndpoints_Params);
      this.setEnterpriseReportingEndpoints(params.endpoints);
      return true;
    case kNetworkContext_SendReportsAndRemoveSource_Name:
      var params = reader.decodeStruct(NetworkContext_SendReportsAndRemoveSource_Params);
      this.sendReportsAndRemoveSource(params.reportingSource);
      return true;
    case kNetworkContext_QueueReport_Name:
      var params = reader.decodeStruct(NetworkContext_QueueReport_Params);
      this.queueReport(params.type, params.group, params.url, params.reportingSource, params.networkAnonymizationKey, params.body);
      return true;
    case kNetworkContext_QueueEnterpriseReport_Name:
      var params = reader.decodeStruct(NetworkContext_QueueEnterpriseReport_Params);
      this.queueEnterpriseReport(params.type, params.group, params.url, params.body);
      return true;
    case kNetworkContext_QueueSignedExchangeReport_Name:
      var params = reader.decodeStruct(NetworkContext_QueueSignedExchangeReport_Params);
      this.queueSignedExchangeReport(params.report, params.networkAnonymizationKey);
      return true;
    case kNetworkContext_SetNetworkConditions_Name:
      var params = reader.decodeStruct(NetworkContext_SetNetworkConditions_Params);
      this.setNetworkConditions(params.throttlingProfileId, params.conditions);
      return true;
    case kNetworkContext_EnableDurableMessageCollector_Name:
      var params = reader.decodeStruct(NetworkContext_EnableDurableMessageCollector_Params);
      this.enableDurableMessageCollector(params.throttlingProfileId, params.receiver);
      return true;
    case kNetworkContext_SetAcceptLanguage_Name:
      var params = reader.decodeStruct(NetworkContext_SetAcceptLanguage_Params);
      this.setAcceptLanguage(params.newAcceptLanguage);
      return true;
    case kNetworkContext_SetEnableReferrers_Name:
      var params = reader.decodeStruct(NetworkContext_SetEnableReferrers_Params);
      this.setEnableReferrers(params.enableReferrers);
      return true;
    case kNetworkContext_SetCTPolicy_Name:
      var params = reader.decodeStruct(NetworkContext_SetCTPolicy_Params);
      this.setCTPolicy(params.ctPolicy);
      return true;
    case kNetworkContext_CreateUDPSocket_Name:
      var params = reader.decodeStruct(NetworkContext_CreateUDPSocket_Params);
      this.createUDPSocket(params.receiver, params.listener);
      return true;
    case kNetworkContext_CreateProxyResolvingSocketFactory_Name:
      var params = reader.decodeStruct(NetworkContext_CreateProxyResolvingSocketFactory_Params);
      this.createProxyResolvingSocketFactory(params.factory);
      return true;
    case kNetworkContext_LookUpProxyForURL_Name:
      var params = reader.decodeStruct(NetworkContext_LookUpProxyForURL_Params);
      this.lookUpProxyForURL(params.url, params.networkAnonymizationKey, params.proxyLookupClient);
      return true;
    case kNetworkContext_CreateWebSocket_Name:
      var params = reader.decodeStruct(NetworkContext_CreateWebSocket_Params);
      this.createWebSocket(params.url, params.requestedProtocols, params.siteForCookies, params.storageAccessApiStatus, params.isolationInfo, params.additionalHeaders, params.processId, params.origin, params.clientSecurityState, params.options, params.trafficAnnotation, params.handshakeClient, params.urlLoaderNetworkObserver, params.authHandler, params.headerClient, params.throttlingProfileId);
      return true;
    case kNetworkContext_CreateWebTransport_Name:
      var params = reader.decodeStruct(NetworkContext_CreateWebTransport_Params);
      this.createWebTransport(params.url, params.origin, params.networkAnonymizationKey, params.fingerprints, params.applicationProtocols, params.handshakeClient, params.urlLoaderNetworkObserver, params.clientSecurityState);
      return true;
    case kNetworkContext_CreateNetLogExporter_Name:
      var params = reader.decodeStruct(NetworkContext_CreateNetLogExporter_Params);
      this.createNetLogExporter(params.receiver);
      return true;
    case kNetworkContext_PreconnectSockets_Name:
      var params = reader.decodeStruct(NetworkContext_PreconnectSockets_Params);
      this.preconnectSockets(params.numStreams, params.url, params.credentialsMode, params.networkAnonymizationKey, params.trafficAnnotation, params.keepaliveConfig, params.observerClient);
      return true;
    case kNetworkContext_CreateP2PSocketManager_Name:
      var params = reader.decodeStruct(NetworkContext_CreateP2PSocketManager_Params);
      this.createP2PSocketManager(params.networkAnonymizationKey, params.client, params.trustedSocketManager, params.socketManager);
      return true;
    case kNetworkContext_CreateMdnsResponder_Name:
      var params = reader.decodeStruct(NetworkContext_CreateMdnsResponder_Params);
      this.createMdnsResponder(params.responderReceiver);
      return true;
    case kNetworkContext_ResolveHost_Name:
      var params = reader.decodeStruct(NetworkContext_ResolveHost_Params);
      this.resolveHost(params.host, params.networkAnonymizationKey, params.optionalParameters, params.responseClient);
      return true;
    case kNetworkContext_CreateHostResolver_Name:
      var params = reader.decodeStruct(NetworkContext_CreateHostResolver_Params);
      this.createHostResolver(params.configOverrides, params.hostResolver);
      return true;
    case kNetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Name:
      var params = reader.decodeStruct(NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params);
      this.setSplitAuthCacheByNetworkAnonymizationKey(params.splitAuthCacheByNetworkAnonymizationKey);
      return true;
    case kNetworkContext_SetCorsNonWildcardRequestHeadersSupport_Name:
      var params = reader.decodeStruct(NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params);
      this.setCorsNonWildcardRequestHeadersSupport(params.value);
      return true;
    case kNetworkContext_SetSCTAuditingMode_Name:
      var params = reader.decodeStruct(NetworkContext_SetSCTAuditingMode_Params);
      this.setSCTAuditingMode(params.mode);
      return true;
    case kNetworkContext_AddReportingApiObserver_Name:
      var params = reader.decodeStruct(NetworkContext_AddReportingApiObserver_Params);
      this.addReportingApiObserver(params.observer);
      return true;
    case kNetworkContext_SetSharedDictionaryCacheMaxSize_Name:
      var params = reader.decodeStruct(NetworkContext_SetSharedDictionaryCacheMaxSize_Params);
      this.setSharedDictionaryCacheMaxSize(params.cacheMaxSize);
      return true;
    case kNetworkContext_PreloadSharedDictionaryInfoForDocument_Name:
      var params = reader.decodeStruct(NetworkContext_PreloadSharedDictionaryInfoForDocument_Params);
      this.preloadSharedDictionaryInfoForDocument(params.urls, params.preloadHandle);
      return true;
    case kNetworkContext_FlushCachedClientCertIfNeeded_Name:
      var params = reader.decodeStruct(NetworkContext_FlushCachedClientCertIfNeeded_Params);
      this.flushCachedClientCertIfNeeded(params.host, params.certificate);
      return true;
    case kNetworkContext_FlushMatchingCachedClientCert_Name:
      var params = reader.decodeStruct(NetworkContext_FlushMatchingCachedClientCert_Params);
      this.flushMatchingCachedClientCert(params.certificate);
      return true;
    case kNetworkContext_ClearNonces_Name:
      var params = reader.decodeStruct(NetworkContext_ClearNonces_Params);
      this.clearNonces(params.nonces);
      return true;
    case kNetworkContext_Prefetch_Name:
      var params = reader.decodeStruct(NetworkContext_Prefetch_Params);
      this.prefetch(params.requestId, params.options, params.request, params.trafficAnnotation);
      return true;
    case kNetworkContext_GetDeviceBoundSessionManager_Name:
      var params = reader.decodeStruct(NetworkContext_GetDeviceBoundSessionManager_Params);
      this.getDeviceBoundSessionManager(params.deviceBoundSessionManager);
      return true;
    case kNetworkContext_AddQuicHints_Name:
      var params = reader.decodeStruct(NetworkContext_AddQuicHints_Params);
      this.addQuicHints(params.origins, params.networkAnonymizationKey);
      return true;
    default:
      return false;
    }
  };

  NetworkContextStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kNetworkContext_ClearTrustTokenData_Name:
      var params = reader.decodeStruct(NetworkContext_ClearTrustTokenData_Params);
      this.clearTrustTokenData(params.filter).then(function(response) {
        var responseParams =
            new NetworkContext_ClearTrustTokenData_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_ClearTrustTokenData_Name,
            codec.align(NetworkContext_ClearTrustTokenData_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_ClearTrustTokenData_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_ClearTrustTokenSessionOnlyData_Name:
      var params = reader.decodeStruct(NetworkContext_ClearTrustTokenSessionOnlyData_Params);
      this.clearTrustTokenSessionOnlyData().then(function(response) {
        var responseParams =
            new NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams();
        responseParams.anyDataDeleted = response.anyDataDeleted;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_ClearTrustTokenSessionOnlyData_Name,
            codec.align(NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_GetStoredTrustTokenCounts_Name:
      var params = reader.decodeStruct(NetworkContext_GetStoredTrustTokenCounts_Params);
      this.getStoredTrustTokenCounts().then(function(response) {
        var responseParams =
            new NetworkContext_GetStoredTrustTokenCounts_ResponseParams();
        responseParams.tokens = response.tokens;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_GetStoredTrustTokenCounts_Name,
            codec.align(NetworkContext_GetStoredTrustTokenCounts_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_GetStoredTrustTokenCounts_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_GetPrivateStateTokenRedemptionRecords_Name:
      var params = reader.decodeStruct(NetworkContext_GetPrivateStateTokenRedemptionRecords_Params);
      this.getPrivateStateTokenRedemptionRecords().then(function(response) {
        var responseParams =
            new NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams();
        responseParams.issuerRedemptionRecordMap = response.issuerRedemptionRecordMap;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_GetPrivateStateTokenRedemptionRecords_Name,
            codec.align(NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_DeleteStoredTrustTokens_Name:
      var params = reader.decodeStruct(NetworkContext_DeleteStoredTrustTokens_Params);
      this.deleteStoredTrustTokens(params.issuer).then(function(response) {
        var responseParams =
            new NetworkContext_DeleteStoredTrustTokens_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_DeleteStoredTrustTokens_Name,
            codec.align(NetworkContext_DeleteStoredTrustTokens_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_DeleteStoredTrustTokens_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_ClearNetworkingHistoryBetween_Name:
      var params = reader.decodeStruct(NetworkContext_ClearNetworkingHistoryBetween_Params);
      this.clearNetworkingHistoryBetween(params.startTime, params.endTime).then(function(response) {
        var responseParams =
            new NetworkContext_ClearNetworkingHistoryBetween_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_ClearNetworkingHistoryBetween_Name,
            codec.align(NetworkContext_ClearNetworkingHistoryBetween_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_ClearNetworkingHistoryBetween_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_ClearHttpCache_Name:
      var params = reader.decodeStruct(NetworkContext_ClearHttpCache_Params);
      this.clearHttpCache(params.startTime, params.endTime, params.filter).then(function(response) {
        var responseParams =
            new NetworkContext_ClearHttpCache_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_ClearHttpCache_Name,
            codec.align(NetworkContext_ClearHttpCache_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_ClearHttpCache_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_ComputeHttpCacheSize_Name:
      var params = reader.decodeStruct(NetworkContext_ComputeHttpCacheSize_Params);
      this.computeHttpCacheSize(params.startTime, params.endTime).then(function(response) {
        var responseParams =
            new NetworkContext_ComputeHttpCacheSize_ResponseParams();
        responseParams.isUpperBound = response.isUpperBound;
        responseParams.sizeOrError = response.sizeOrError;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_ComputeHttpCacheSize_Name,
            codec.align(NetworkContext_ComputeHttpCacheSize_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_ComputeHttpCacheSize_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_ClearHostCache_Name:
      var params = reader.decodeStruct(NetworkContext_ClearHostCache_Params);
      this.clearHostCache(params.filter).then(function(response) {
        var responseParams =
            new NetworkContext_ClearHostCache_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_ClearHostCache_Name,
            codec.align(NetworkContext_ClearHostCache_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_ClearHostCache_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_ClearHttpAuthCache_Name:
      var params = reader.decodeStruct(NetworkContext_ClearHttpAuthCache_Params);
      this.clearHttpAuthCache(params.startTime, params.endTime, params.filter).then(function(response) {
        var responseParams =
            new NetworkContext_ClearHttpAuthCache_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_ClearHttpAuthCache_Name,
            codec.align(NetworkContext_ClearHttpAuthCache_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_ClearHttpAuthCache_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_ClearCorsPreflightCache_Name:
      var params = reader.decodeStruct(NetworkContext_ClearCorsPreflightCache_Params);
      this.clearCorsPreflightCache(params.filter).then(function(response) {
        var responseParams =
            new NetworkContext_ClearCorsPreflightCache_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_ClearCorsPreflightCache_Name,
            codec.align(NetworkContext_ClearCorsPreflightCache_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_ClearCorsPreflightCache_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_ClearReportingCacheReports_Name:
      var params = reader.decodeStruct(NetworkContext_ClearReportingCacheReports_Params);
      this.clearReportingCacheReports(params.filter).then(function(response) {
        var responseParams =
            new NetworkContext_ClearReportingCacheReports_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_ClearReportingCacheReports_Name,
            codec.align(NetworkContext_ClearReportingCacheReports_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_ClearReportingCacheReports_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_ClearReportingCacheClients_Name:
      var params = reader.decodeStruct(NetworkContext_ClearReportingCacheClients_Params);
      this.clearReportingCacheClients(params.filter).then(function(response) {
        var responseParams =
            new NetworkContext_ClearReportingCacheClients_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_ClearReportingCacheClients_Name,
            codec.align(NetworkContext_ClearReportingCacheClients_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_ClearReportingCacheClients_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_ClearNetworkErrorLogging_Name:
      var params = reader.decodeStruct(NetworkContext_ClearNetworkErrorLogging_Params);
      this.clearNetworkErrorLogging(params.filter).then(function(response) {
        var responseParams =
            new NetworkContext_ClearNetworkErrorLogging_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_ClearNetworkErrorLogging_Name,
            codec.align(NetworkContext_ClearNetworkErrorLogging_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_ClearNetworkErrorLogging_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_ClearDomainReliability_Name:
      var params = reader.decodeStruct(NetworkContext_ClearDomainReliability_Params);
      this.clearDomainReliability(params.filter, params.mode).then(function(response) {
        var responseParams =
            new NetworkContext_ClearDomainReliability_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_ClearDomainReliability_Name,
            codec.align(NetworkContext_ClearDomainReliability_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_ClearDomainReliability_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_ClearSharedDictionaryCache_Name:
      var params = reader.decodeStruct(NetworkContext_ClearSharedDictionaryCache_Params);
      this.clearSharedDictionaryCache(params.startTime, params.endTime, params.filter).then(function(response) {
        var responseParams =
            new NetworkContext_ClearSharedDictionaryCache_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_ClearSharedDictionaryCache_Name,
            codec.align(NetworkContext_ClearSharedDictionaryCache_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_ClearSharedDictionaryCache_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_ClearSharedDictionaryCacheForIsolationKey_Name:
      var params = reader.decodeStruct(NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params);
      this.clearSharedDictionaryCacheForIsolationKey(params.isolationKey).then(function(response) {
        var responseParams =
            new NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_ClearSharedDictionaryCacheForIsolationKey_Name,
            codec.align(NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_CloseAllConnections_Name:
      var params = reader.decodeStruct(NetworkContext_CloseAllConnections_Params);
      this.closeAllConnections().then(function(response) {
        var responseParams =
            new NetworkContext_CloseAllConnections_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_CloseAllConnections_Name,
            codec.align(NetworkContext_CloseAllConnections_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_CloseAllConnections_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_CloseIdleConnections_Name:
      var params = reader.decodeStruct(NetworkContext_CloseIdleConnections_Params);
      this.closeIdleConnections().then(function(response) {
        var responseParams =
            new NetworkContext_CloseIdleConnections_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_CloseIdleConnections_Name,
            codec.align(NetworkContext_CloseIdleConnections_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_CloseIdleConnections_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_CreateRestrictedUDPSocket_Name:
      var params = reader.decodeStruct(NetworkContext_CreateRestrictedUDPSocket_Params);
      this.createRestrictedUDPSocket(params.addr, params.mode, params.trafficAnnotation, params.params, params.receiver, params.listener, params.allowMulticast).then(function(response) {
        var responseParams =
            new NetworkContext_CreateRestrictedUDPSocket_ResponseParams();
        responseParams.result = response.result;
        responseParams.localAddrOut = response.localAddrOut;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_CreateRestrictedUDPSocket_Name,
            codec.align(NetworkContext_CreateRestrictedUDPSocket_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_CreateRestrictedUDPSocket_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_CreateTCPServerSocket_Name:
      var params = reader.decodeStruct(NetworkContext_CreateTCPServerSocket_Params);
      this.createTCPServerSocket(params.localAddr, params.options, params.trafficAnnotation, params.socket).then(function(response) {
        var responseParams =
            new NetworkContext_CreateTCPServerSocket_ResponseParams();
        responseParams.result = response.result;
        responseParams.localAddrOut = response.localAddrOut;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_CreateTCPServerSocket_Name,
            codec.align(NetworkContext_CreateTCPServerSocket_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_CreateTCPServerSocket_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_CreateTCPConnectedSocket_Name:
      var params = reader.decodeStruct(NetworkContext_CreateTCPConnectedSocket_Params);
      this.createTCPConnectedSocket(params.localAddr, params.remoteAddrList, params.tcpConnectedSocketOptions, params.trafficAnnotation, params.socket, params.observer).then(function(response) {
        var responseParams =
            new NetworkContext_CreateTCPConnectedSocket_ResponseParams();
        responseParams.result = response.result;
        responseParams.localAddr = response.localAddr;
        responseParams.peerAddr = response.peerAddr;
        responseParams.receiveStream = response.receiveStream;
        responseParams.sendStream = response.sendStream;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_CreateTCPConnectedSocket_Name,
            codec.align(NetworkContext_CreateTCPConnectedSocket_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_CreateTCPConnectedSocket_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_CreateTCPBoundSocket_Name:
      var params = reader.decodeStruct(NetworkContext_CreateTCPBoundSocket_Params);
      this.createTCPBoundSocket(params.localAddr, params.trafficAnnotation, params.socket).then(function(response) {
        var responseParams =
            new NetworkContext_CreateTCPBoundSocket_ResponseParams();
        responseParams.result = response.result;
        responseParams.localAddr = response.localAddr;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_CreateTCPBoundSocket_Name,
            codec.align(NetworkContext_CreateTCPBoundSocket_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_CreateTCPBoundSocket_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_ForceReloadProxyConfig_Name:
      var params = reader.decodeStruct(NetworkContext_ForceReloadProxyConfig_Params);
      this.forceReloadProxyConfig().then(function(response) {
        var responseParams =
            new NetworkContext_ForceReloadProxyConfig_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_ForceReloadProxyConfig_Name,
            codec.align(NetworkContext_ForceReloadProxyConfig_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_ForceReloadProxyConfig_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_ClearBadProxiesCache_Name:
      var params = reader.decodeStruct(NetworkContext_ClearBadProxiesCache_Params);
      this.clearBadProxiesCache().then(function(response) {
        var responseParams =
            new NetworkContext_ClearBadProxiesCache_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_ClearBadProxiesCache_Name,
            codec.align(NetworkContext_ClearBadProxiesCache_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_ClearBadProxiesCache_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_VerifyCert_Name:
      var params = reader.decodeStruct(NetworkContext_VerifyCert_Params);
      this.verifyCert(params.certificate, params.hostPort, params.ocspResponse, params.sctList).then(function(response) {
        var responseParams =
            new NetworkContext_VerifyCert_ResponseParams();
        responseParams.errorCode = response.errorCode;
        responseParams.cvResult = response.cvResult;
        responseParams.pkpBypassed = response.pkpBypassed;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_VerifyCert_Name,
            codec.align(NetworkContext_VerifyCert_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_VerifyCert_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_VerifyCertForSignedExchange_Name:
      var params = reader.decodeStruct(NetworkContext_VerifyCertForSignedExchange_Params);
      this.verifyCertForSignedExchange(params.certificate, params.hostPort, params.ocspResponse, params.sctList).then(function(response) {
        var responseParams =
            new NetworkContext_VerifyCertForSignedExchange_ResponseParams();
        responseParams.errorCode = response.errorCode;
        responseParams.cvResult = response.cvResult;
        responseParams.pkpBypassed = response.pkpBypassed;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_VerifyCertForSignedExchange_Name,
            codec.align(NetworkContext_VerifyCertForSignedExchange_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_VerifyCertForSignedExchange_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_Verify2QwacCertBinding_Name:
      var params = reader.decodeStruct(NetworkContext_Verify2QwacCertBinding_Params);
      this.verify2QwacCertBinding(params.binding, params.hostname, params.tlsCertificate).then(function(response) {
        var responseParams =
            new NetworkContext_Verify2QwacCertBinding_ResponseParams();
        responseParams.verifiedCert = response.verifiedCert;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_Verify2QwacCertBinding_Name,
            codec.align(NetworkContext_Verify2QwacCertBinding_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_Verify2QwacCertBinding_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_AddHSTS_Name:
      var params = reader.decodeStruct(NetworkContext_AddHSTS_Params);
      this.addHSTS(params.host, params.expiry, params.includeSubdomains).then(function(response) {
        var responseParams =
            new NetworkContext_AddHSTS_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_AddHSTS_Name,
            codec.align(NetworkContext_AddHSTS_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_AddHSTS_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_IsHSTSActiveForHost_Name:
      var params = reader.decodeStruct(NetworkContext_IsHSTSActiveForHost_Params);
      this.isHSTSActiveForHost(params.host, params.isTopLevelNav).then(function(response) {
        var responseParams =
            new NetworkContext_IsHSTSActiveForHost_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_IsHSTSActiveForHost_Name,
            codec.align(NetworkContext_IsHSTSActiveForHost_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_IsHSTSActiveForHost_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_GetHSTSState_Name:
      var params = reader.decodeStruct(NetworkContext_GetHSTSState_Params);
      this.getHSTSState(params.domain).then(function(response) {
        var responseParams =
            new NetworkContext_GetHSTSState_ResponseParams();
        responseParams.state = response.state;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_GetHSTSState_Name,
            codec.align(NetworkContext_GetHSTSState_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_GetHSTSState_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_SetCorsOriginAccessListsForOrigin_Name:
      var params = reader.decodeStruct(NetworkContext_SetCorsOriginAccessListsForOrigin_Params);
      this.setCorsOriginAccessListsForOrigin(params.sourceOrigin, params.allowPatterns, params.blockPatterns).then(function(response) {
        var responseParams =
            new NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_SetCorsOriginAccessListsForOrigin_Name,
            codec.align(NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_DeleteDynamicDataForHost_Name:
      var params = reader.decodeStruct(NetworkContext_DeleteDynamicDataForHost_Params);
      this.deleteDynamicDataForHost(params.host).then(function(response) {
        var responseParams =
            new NetworkContext_DeleteDynamicDataForHost_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_DeleteDynamicDataForHost_Name,
            codec.align(NetworkContext_DeleteDynamicDataForHost_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_DeleteDynamicDataForHost_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_SaveHttpAuthCacheProxyEntries_Name:
      var params = reader.decodeStruct(NetworkContext_SaveHttpAuthCacheProxyEntries_Params);
      this.saveHttpAuthCacheProxyEntries().then(function(response) {
        var responseParams =
            new NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams();
        responseParams.cacheKey = response.cacheKey;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_SaveHttpAuthCacheProxyEntries_Name,
            codec.align(NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_LoadHttpAuthCacheProxyEntries_Name:
      var params = reader.decodeStruct(NetworkContext_LoadHttpAuthCacheProxyEntries_Params);
      this.loadHttpAuthCacheProxyEntries(params.cacheKey).then(function(response) {
        var responseParams =
            new NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_LoadHttpAuthCacheProxyEntries_Name,
            codec.align(NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_AddAuthCacheEntry_Name:
      var params = reader.decodeStruct(NetworkContext_AddAuthCacheEntry_Params);
      this.addAuthCacheEntry(params.challenge, params.networkAnonymizationKey, params.credentials).then(function(response) {
        var responseParams =
            new NetworkContext_AddAuthCacheEntry_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_AddAuthCacheEntry_Name,
            codec.align(NetworkContext_AddAuthCacheEntry_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_AddAuthCacheEntry_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_EnableStaticKeyPinningForTesting_Name:
      var params = reader.decodeStruct(NetworkContext_EnableStaticKeyPinningForTesting_Params);
      this.enableStaticKeyPinningForTesting().then(function(response) {
        var responseParams =
            new NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_EnableStaticKeyPinningForTesting_Name,
            codec.align(NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_VerifyCertificateForTesting_Name:
      var params = reader.decodeStruct(NetworkContext_VerifyCertificateForTesting_Params);
      this.verifyCertificateForTesting(params.certificate, params.hostname, params.ocspResponse, params.sctList).then(function(response) {
        var responseParams =
            new NetworkContext_VerifyCertificateForTesting_ResponseParams();
        responseParams.errorCode = response.errorCode;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_VerifyCertificateForTesting_Name,
            codec.align(NetworkContext_VerifyCertificateForTesting_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_VerifyCertificateForTesting_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_GetTrustAnchorIDsForTesting_Name:
      var params = reader.decodeStruct(NetworkContext_GetTrustAnchorIDsForTesting_Params);
      this.getTrustAnchorIDsForTesting().then(function(response) {
        var responseParams =
            new NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams();
        responseParams.trustAnchorIds = response.trustAnchorIds;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_GetTrustAnchorIDsForTesting_Name,
            codec.align(NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_AddDomainReliabilityContextForTesting_Name:
      var params = reader.decodeStruct(NetworkContext_AddDomainReliabilityContextForTesting_Params);
      this.addDomainReliabilityContextForTesting(params.origin, params.uploadUrl).then(function(response) {
        var responseParams =
            new NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_AddDomainReliabilityContextForTesting_Name,
            codec.align(NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_ForceDomainReliabilityUploadsForTesting_Name:
      var params = reader.decodeStruct(NetworkContext_ForceDomainReliabilityUploadsForTesting_Params);
      this.forceDomainReliabilityUploadsForTesting().then(function(response) {
        var responseParams =
            new NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_ForceDomainReliabilityUploadsForTesting_Name,
            codec.align(NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_GetSharedDictionaryUsageInfo_Name:
      var params = reader.decodeStruct(NetworkContext_GetSharedDictionaryUsageInfo_Params);
      this.getSharedDictionaryUsageInfo().then(function(response) {
        var responseParams =
            new NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams();
        responseParams.usageInfo = response.usageInfo;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_GetSharedDictionaryUsageInfo_Name,
            codec.align(NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_GetSharedDictionaryInfo_Name:
      var params = reader.decodeStruct(NetworkContext_GetSharedDictionaryInfo_Params);
      this.getSharedDictionaryInfo(params.isolationKey).then(function(response) {
        var responseParams =
            new NetworkContext_GetSharedDictionaryInfo_ResponseParams();
        responseParams.dictionaries = response.dictionaries;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_GetSharedDictionaryInfo_Name,
            codec.align(NetworkContext_GetSharedDictionaryInfo_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_GetSharedDictionaryInfo_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_GetSharedDictionaryOriginsBetween_Name:
      var params = reader.decodeStruct(NetworkContext_GetSharedDictionaryOriginsBetween_Params);
      this.getSharedDictionaryOriginsBetween(params.startTime, params.endTime).then(function(response) {
        var responseParams =
            new NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams();
        responseParams.origins = response.origins;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_GetSharedDictionaryOriginsBetween_Name,
            codec.align(NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Name:
      var params = reader.decodeStruct(NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params);
      this.hasPreloadedSharedDictionaryInfoForTesting().then(function(response) {
        var responseParams =
            new NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams();
        responseParams.value = response.value;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Name,
            codec.align(NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_RevokeNetworkForNonces_Name:
      var params = reader.decodeStruct(NetworkContext_RevokeNetworkForNonces_Params);
      this.revokeNetworkForNonces(params.noncesToPatterns).then(function(response) {
        var responseParams =
            new NetworkContext_RevokeNetworkForNonces_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_RevokeNetworkForNonces_Name,
            codec.align(NetworkContext_RevokeNetworkForNonces_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_RevokeNetworkForNonces_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_ExemptUrlFromNetworkRevocationForNonce_Name:
      var params = reader.decodeStruct(NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params);
      this.exemptUrlFromNetworkRevocationForNonce(params.exemptedUrl, params.nonce).then(function(response) {
        var responseParams =
            new NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kNetworkContext_ExemptUrlFromNetworkRevocationForNonce_Name,
            codec.align(NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kNetworkContext_GetBoundNetworkForTesting_Name:
      var params = reader.decodeStruct(NetworkContext_GetBoundNetworkForTesting_Params);
      this.getBoundNetworkForTesting().then(function(response) {
        var responseParams =
            new NetworkContext_GetBoundNetworkForTesting_ResponseParams();
        responseParams.boundNetwork = response.boundNetwork;
        var builder = new codec.MessageV1Builder(
            kNetworkContext_GetBoundNetworkForTesting_Name,
            codec.align(NetworkContext_GetBoundNetworkForTesting_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NetworkContext_GetBoundNetworkForTesting_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateNetworkContextRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kNetworkContext_SetClient_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_SetClient_Params;
      break;
      case kNetworkContext_CreateURLLoaderFactory_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_CreateURLLoaderFactory_Params;
      break;
      case kNetworkContext_ResetURLLoaderFactories_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_ResetURLLoaderFactories_Params;
      break;
      case kNetworkContext_GetViaObliviousHttp_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_GetViaObliviousHttp_Params;
      break;
      case kNetworkContext_GetCookieManager_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_GetCookieManager_Params;
      break;
      case kNetworkContext_GetRestrictedCookieManager_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_GetRestrictedCookieManager_Params;
      break;
      case kNetworkContext_GetTrustTokenQueryAnswerer_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_GetTrustTokenQueryAnswerer_Params;
      break;
      case kNetworkContext_ClearTrustTokenData_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_ClearTrustTokenData_Params;
      break;
      case kNetworkContext_ClearTrustTokenSessionOnlyData_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_ClearTrustTokenSessionOnlyData_Params;
      break;
      case kNetworkContext_GetStoredTrustTokenCounts_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_GetStoredTrustTokenCounts_Params;
      break;
      case kNetworkContext_GetPrivateStateTokenRedemptionRecords_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_GetPrivateStateTokenRedemptionRecords_Params;
      break;
      case kNetworkContext_DeleteStoredTrustTokens_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_DeleteStoredTrustTokens_Params;
      break;
      case kNetworkContext_SetBlockTrustTokens_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_SetBlockTrustTokens_Params;
      break;
      case kNetworkContext_ClearNetworkingHistoryBetween_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_ClearNetworkingHistoryBetween_Params;
      break;
      case kNetworkContext_ClearHttpCache_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_ClearHttpCache_Params;
      break;
      case kNetworkContext_ComputeHttpCacheSize_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_ComputeHttpCacheSize_Params;
      break;
      case kNetworkContext_NotifyBrowserIdle_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_NotifyBrowserIdle_Params;
      break;
      case kNetworkContext_NotifyExternalCacheHit_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_NotifyExternalCacheHit_Params;
      break;
      case kNetworkContext_ClearHostCache_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_ClearHostCache_Params;
      break;
      case kNetworkContext_ClearHttpAuthCache_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_ClearHttpAuthCache_Params;
      break;
      case kNetworkContext_ClearCorsPreflightCache_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_ClearCorsPreflightCache_Params;
      break;
      case kNetworkContext_ClearReportingCacheReports_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_ClearReportingCacheReports_Params;
      break;
      case kNetworkContext_ClearReportingCacheClients_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_ClearReportingCacheClients_Params;
      break;
      case kNetworkContext_ClearNetworkErrorLogging_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_ClearNetworkErrorLogging_Params;
      break;
      case kNetworkContext_ClearDomainReliability_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_ClearDomainReliability_Params;
      break;
      case kNetworkContext_ClearSharedDictionaryCache_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_ClearSharedDictionaryCache_Params;
      break;
      case kNetworkContext_ClearSharedDictionaryCacheForIsolationKey_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params;
      break;
      case kNetworkContext_SetDocumentReportingEndpoints_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_SetDocumentReportingEndpoints_Params;
      break;
      case kNetworkContext_SetEnterpriseReportingEndpoints_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_SetEnterpriseReportingEndpoints_Params;
      break;
      case kNetworkContext_SendReportsAndRemoveSource_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_SendReportsAndRemoveSource_Params;
      break;
      case kNetworkContext_QueueReport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_QueueReport_Params;
      break;
      case kNetworkContext_QueueEnterpriseReport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_QueueEnterpriseReport_Params;
      break;
      case kNetworkContext_QueueSignedExchangeReport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_QueueSignedExchangeReport_Params;
      break;
      case kNetworkContext_CloseAllConnections_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_CloseAllConnections_Params;
      break;
      case kNetworkContext_CloseIdleConnections_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_CloseIdleConnections_Params;
      break;
      case kNetworkContext_SetNetworkConditions_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_SetNetworkConditions_Params;
      break;
      case kNetworkContext_EnableDurableMessageCollector_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_EnableDurableMessageCollector_Params;
      break;
      case kNetworkContext_SetAcceptLanguage_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_SetAcceptLanguage_Params;
      break;
      case kNetworkContext_SetEnableReferrers_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_SetEnableReferrers_Params;
      break;
      case kNetworkContext_SetCTPolicy_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_SetCTPolicy_Params;
      break;
      case kNetworkContext_CreateUDPSocket_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_CreateUDPSocket_Params;
      break;
      case kNetworkContext_CreateRestrictedUDPSocket_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_CreateRestrictedUDPSocket_Params;
      break;
      case kNetworkContext_CreateTCPServerSocket_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_CreateTCPServerSocket_Params;
      break;
      case kNetworkContext_CreateTCPConnectedSocket_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_CreateTCPConnectedSocket_Params;
      break;
      case kNetworkContext_CreateTCPBoundSocket_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_CreateTCPBoundSocket_Params;
      break;
      case kNetworkContext_CreateProxyResolvingSocketFactory_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_CreateProxyResolvingSocketFactory_Params;
      break;
      case kNetworkContext_LookUpProxyForURL_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_LookUpProxyForURL_Params;
      break;
      case kNetworkContext_ForceReloadProxyConfig_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_ForceReloadProxyConfig_Params;
      break;
      case kNetworkContext_ClearBadProxiesCache_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_ClearBadProxiesCache_Params;
      break;
      case kNetworkContext_CreateWebSocket_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_CreateWebSocket_Params;
      break;
      case kNetworkContext_CreateWebTransport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_CreateWebTransport_Params;
      break;
      case kNetworkContext_CreateNetLogExporter_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_CreateNetLogExporter_Params;
      break;
      case kNetworkContext_PreconnectSockets_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_PreconnectSockets_Params;
      break;
      case kNetworkContext_CreateP2PSocketManager_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_CreateP2PSocketManager_Params;
      break;
      case kNetworkContext_CreateMdnsResponder_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_CreateMdnsResponder_Params;
      break;
      case kNetworkContext_ResolveHost_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_ResolveHost_Params;
      break;
      case kNetworkContext_CreateHostResolver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_CreateHostResolver_Params;
      break;
      case kNetworkContext_VerifyCert_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_VerifyCert_Params;
      break;
      case kNetworkContext_VerifyCertForSignedExchange_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_VerifyCertForSignedExchange_Params;
      break;
      case kNetworkContext_Verify2QwacCertBinding_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_Verify2QwacCertBinding_Params;
      break;
      case kNetworkContext_AddHSTS_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_AddHSTS_Params;
      break;
      case kNetworkContext_IsHSTSActiveForHost_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_IsHSTSActiveForHost_Params;
      break;
      case kNetworkContext_GetHSTSState_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_GetHSTSState_Params;
      break;
      case kNetworkContext_SetCorsOriginAccessListsForOrigin_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_SetCorsOriginAccessListsForOrigin_Params;
      break;
      case kNetworkContext_DeleteDynamicDataForHost_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_DeleteDynamicDataForHost_Params;
      break;
      case kNetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params;
      break;
      case kNetworkContext_SaveHttpAuthCacheProxyEntries_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_SaveHttpAuthCacheProxyEntries_Params;
      break;
      case kNetworkContext_LoadHttpAuthCacheProxyEntries_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_LoadHttpAuthCacheProxyEntries_Params;
      break;
      case kNetworkContext_AddAuthCacheEntry_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_AddAuthCacheEntry_Params;
      break;
      case kNetworkContext_SetCorsNonWildcardRequestHeadersSupport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params;
      break;
      case kNetworkContext_EnableStaticKeyPinningForTesting_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_EnableStaticKeyPinningForTesting_Params;
      break;
      case kNetworkContext_VerifyCertificateForTesting_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_VerifyCertificateForTesting_Params;
      break;
      case kNetworkContext_GetTrustAnchorIDsForTesting_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_GetTrustAnchorIDsForTesting_Params;
      break;
      case kNetworkContext_AddDomainReliabilityContextForTesting_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_AddDomainReliabilityContextForTesting_Params;
      break;
      case kNetworkContext_ForceDomainReliabilityUploadsForTesting_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_ForceDomainReliabilityUploadsForTesting_Params;
      break;
      case kNetworkContext_SetSCTAuditingMode_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_SetSCTAuditingMode_Params;
      break;
      case kNetworkContext_AddReportingApiObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_AddReportingApiObserver_Params;
      break;
      case kNetworkContext_GetSharedDictionaryUsageInfo_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_GetSharedDictionaryUsageInfo_Params;
      break;
      case kNetworkContext_GetSharedDictionaryInfo_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_GetSharedDictionaryInfo_Params;
      break;
      case kNetworkContext_GetSharedDictionaryOriginsBetween_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_GetSharedDictionaryOriginsBetween_Params;
      break;
      case kNetworkContext_SetSharedDictionaryCacheMaxSize_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_SetSharedDictionaryCacheMaxSize_Params;
      break;
      case kNetworkContext_PreloadSharedDictionaryInfoForDocument_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_PreloadSharedDictionaryInfoForDocument_Params;
      break;
      case kNetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params;
      break;
      case kNetworkContext_FlushCachedClientCertIfNeeded_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_FlushCachedClientCertIfNeeded_Params;
      break;
      case kNetworkContext_FlushMatchingCachedClientCert_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_FlushMatchingCachedClientCert_Params;
      break;
      case kNetworkContext_RevokeNetworkForNonces_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_RevokeNetworkForNonces_Params;
      break;
      case kNetworkContext_ClearNonces_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_ClearNonces_Params;
      break;
      case kNetworkContext_ExemptUrlFromNetworkRevocationForNonce_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params;
      break;
      case kNetworkContext_Prefetch_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_Prefetch_Params;
      break;
      case kNetworkContext_GetBoundNetworkForTesting_Name:
        if (message.expectsResponse())
          paramsClass = NetworkContext_GetBoundNetworkForTesting_Params;
      break;
      case kNetworkContext_GetDeviceBoundSessionManager_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_GetDeviceBoundSessionManager_Params;
      break;
      case kNetworkContext_AddQuicHints_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NetworkContext_AddQuicHints_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateNetworkContextResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kNetworkContext_ClearTrustTokenData_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_ClearTrustTokenData_ResponseParams;
        break;
      case kNetworkContext_ClearTrustTokenSessionOnlyData_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams;
        break;
      case kNetworkContext_GetStoredTrustTokenCounts_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_GetStoredTrustTokenCounts_ResponseParams;
        break;
      case kNetworkContext_GetPrivateStateTokenRedemptionRecords_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams;
        break;
      case kNetworkContext_DeleteStoredTrustTokens_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_DeleteStoredTrustTokens_ResponseParams;
        break;
      case kNetworkContext_ClearNetworkingHistoryBetween_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_ClearNetworkingHistoryBetween_ResponseParams;
        break;
      case kNetworkContext_ClearHttpCache_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_ClearHttpCache_ResponseParams;
        break;
      case kNetworkContext_ComputeHttpCacheSize_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_ComputeHttpCacheSize_ResponseParams;
        break;
      case kNetworkContext_ClearHostCache_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_ClearHostCache_ResponseParams;
        break;
      case kNetworkContext_ClearHttpAuthCache_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_ClearHttpAuthCache_ResponseParams;
        break;
      case kNetworkContext_ClearCorsPreflightCache_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_ClearCorsPreflightCache_ResponseParams;
        break;
      case kNetworkContext_ClearReportingCacheReports_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_ClearReportingCacheReports_ResponseParams;
        break;
      case kNetworkContext_ClearReportingCacheClients_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_ClearReportingCacheClients_ResponseParams;
        break;
      case kNetworkContext_ClearNetworkErrorLogging_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_ClearNetworkErrorLogging_ResponseParams;
        break;
      case kNetworkContext_ClearDomainReliability_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_ClearDomainReliability_ResponseParams;
        break;
      case kNetworkContext_ClearSharedDictionaryCache_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_ClearSharedDictionaryCache_ResponseParams;
        break;
      case kNetworkContext_ClearSharedDictionaryCacheForIsolationKey_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams;
        break;
      case kNetworkContext_CloseAllConnections_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_CloseAllConnections_ResponseParams;
        break;
      case kNetworkContext_CloseIdleConnections_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_CloseIdleConnections_ResponseParams;
        break;
      case kNetworkContext_CreateRestrictedUDPSocket_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_CreateRestrictedUDPSocket_ResponseParams;
        break;
      case kNetworkContext_CreateTCPServerSocket_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_CreateTCPServerSocket_ResponseParams;
        break;
      case kNetworkContext_CreateTCPConnectedSocket_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_CreateTCPConnectedSocket_ResponseParams;
        break;
      case kNetworkContext_CreateTCPBoundSocket_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_CreateTCPBoundSocket_ResponseParams;
        break;
      case kNetworkContext_ForceReloadProxyConfig_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_ForceReloadProxyConfig_ResponseParams;
        break;
      case kNetworkContext_ClearBadProxiesCache_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_ClearBadProxiesCache_ResponseParams;
        break;
      case kNetworkContext_VerifyCert_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_VerifyCert_ResponseParams;
        break;
      case kNetworkContext_VerifyCertForSignedExchange_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_VerifyCertForSignedExchange_ResponseParams;
        break;
      case kNetworkContext_Verify2QwacCertBinding_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_Verify2QwacCertBinding_ResponseParams;
        break;
      case kNetworkContext_AddHSTS_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_AddHSTS_ResponseParams;
        break;
      case kNetworkContext_IsHSTSActiveForHost_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_IsHSTSActiveForHost_ResponseParams;
        break;
      case kNetworkContext_GetHSTSState_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_GetHSTSState_ResponseParams;
        break;
      case kNetworkContext_SetCorsOriginAccessListsForOrigin_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams;
        break;
      case kNetworkContext_DeleteDynamicDataForHost_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_DeleteDynamicDataForHost_ResponseParams;
        break;
      case kNetworkContext_SaveHttpAuthCacheProxyEntries_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams;
        break;
      case kNetworkContext_LoadHttpAuthCacheProxyEntries_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams;
        break;
      case kNetworkContext_AddAuthCacheEntry_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_AddAuthCacheEntry_ResponseParams;
        break;
      case kNetworkContext_EnableStaticKeyPinningForTesting_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams;
        break;
      case kNetworkContext_VerifyCertificateForTesting_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_VerifyCertificateForTesting_ResponseParams;
        break;
      case kNetworkContext_GetTrustAnchorIDsForTesting_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams;
        break;
      case kNetworkContext_AddDomainReliabilityContextForTesting_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams;
        break;
      case kNetworkContext_ForceDomainReliabilityUploadsForTesting_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams;
        break;
      case kNetworkContext_GetSharedDictionaryUsageInfo_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams;
        break;
      case kNetworkContext_GetSharedDictionaryInfo_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_GetSharedDictionaryInfo_ResponseParams;
        break;
      case kNetworkContext_GetSharedDictionaryOriginsBetween_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams;
        break;
      case kNetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams;
        break;
      case kNetworkContext_RevokeNetworkForNonces_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_RevokeNetworkForNonces_ResponseParams;
        break;
      case kNetworkContext_ExemptUrlFromNetworkRevocationForNonce_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams;
        break;
      case kNetworkContext_GetBoundNetworkForTesting_Name:
        if (message.isResponse())
          paramsClass = NetworkContext_GetBoundNetworkForTesting_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var NetworkContext = {
    name: 'network.mojom.NetworkContext',
    kVersion: 0,
    ptrClass: NetworkContextPtr,
    proxyClass: NetworkContextProxy,
    stubClass: NetworkContextStub,
    validateRequest: validateNetworkContextRequest,
    validateResponse: validateNetworkContextResponse,
  };
  NetworkContext.DomainReliabilityClearMode = {};
  NetworkContext.DomainReliabilityClearMode.CLEAR_CONTEXTS = 0;
  NetworkContext.DomainReliabilityClearMode.CLEAR_BEACONS = 1;
  NetworkContext.DomainReliabilityClearMode.MIN_VALUE = 0;
  NetworkContext.DomainReliabilityClearMode.MAX_VALUE = 1;

  NetworkContext.DomainReliabilityClearMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  NetworkContext.DomainReliabilityClearMode.toKnownEnumValue = function(value) {
    return value;
  };

  NetworkContext.DomainReliabilityClearMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  NetworkContextStub.prototype.validator = validateNetworkContextRequest;
  NetworkContextProxy.prototype.validator = validateNetworkContextResponse;
  exports.WEB_SOCKET_OPTION_NONE = WEB_SOCKET_OPTION_NONE;
  exports.WEB_SOCKET_OPTION_BLOCK_ALL_COOKIES = WEB_SOCKET_OPTION_BLOCK_ALL_COOKIES;
  exports.WEB_SOCKET_OPTION_BLOCK_THIRD_PARTY_COOKIES = WEB_SOCKET_OPTION_BLOCK_THIRD_PARTY_COOKIES;
  exports.BROWSER_PROCESS_ID = BROWSER_PROCESS_ID;
  exports.INVALID_PROCESS_ID = INVALID_PROCESS_ID;
  exports.TrustTokenOperationPolicyVerdict = TrustTokenOperationPolicyVerdict;
  exports.SCTAuditingMode = SCTAuditingMode;
  exports.CustomProxyConfig = CustomProxyConfig;
  exports.CertVerifierServiceRemoteParams = CertVerifierServiceRemoteParams;
  exports.HttpAuthStaticNetworkContextParams = HttpAuthStaticNetworkContextParams;
  exports.NetworkContextFilePaths = NetworkContextFilePaths;
  exports.NetworkContextParams = NetworkContextParams;
  exports.NetworkConditions = NetworkConditions;
  exports.MatchedNetworkConditions = MatchedNetworkConditions;
  exports.NetworkDurableMessageConfig = NetworkDurableMessageConfig;
  exports.SharedDictionaryInfo = SharedDictionaryInfo;
  exports.SignedExchangeReport = SignedExchangeReport;
  exports.URLLoaderFactoryOverride = URLLoaderFactoryOverride;
  exports.URLLoaderFactoryParams = URLLoaderFactoryParams;
  exports.NonceAndAllowlistedPatterns = NonceAndAllowlistedPatterns;
  exports.CustomProxyConnectionObserver = CustomProxyConnectionObserver;
  exports.CustomProxyConnectionObserverPtr = CustomProxyConnectionObserverPtr;
  exports.CustomProxyConnectionObserverAssociatedPtr = CustomProxyConnectionObserverAssociatedPtr;
  exports.CustomProxyConfigClient = CustomProxyConfigClient;
  exports.CustomProxyConfigClientPtr = CustomProxyConfigClientPtr;
  exports.CustomProxyConfigClientAssociatedPtr = CustomProxyConfigClientAssociatedPtr;
  exports.TrustedHeaderClient = TrustedHeaderClient;
  exports.TrustedHeaderClientPtr = TrustedHeaderClientPtr;
  exports.TrustedHeaderClientAssociatedPtr = TrustedHeaderClientAssociatedPtr;
  exports.TrustedURLLoaderHeaderClient = TrustedURLLoaderHeaderClient;
  exports.TrustedURLLoaderHeaderClientPtr = TrustedURLLoaderHeaderClientPtr;
  exports.TrustedURLLoaderHeaderClientAssociatedPtr = TrustedURLLoaderHeaderClientAssociatedPtr;
  exports.PreloadedSharedDictionaryInfoHandle = PreloadedSharedDictionaryInfoHandle;
  exports.PreloadedSharedDictionaryInfoHandlePtr = PreloadedSharedDictionaryInfoHandlePtr;
  exports.PreloadedSharedDictionaryInfoHandleAssociatedPtr = PreloadedSharedDictionaryInfoHandleAssociatedPtr;
  exports.DurableMessageCollector = DurableMessageCollector;
  exports.DurableMessageCollectorPtr = DurableMessageCollectorPtr;
  exports.DurableMessageCollectorAssociatedPtr = DurableMessageCollectorAssociatedPtr;
  exports.NetworkContext = NetworkContext;
  exports.NetworkContextPtr = NetworkContextPtr;
  exports.NetworkContextAssociatedPtr = NetworkContextAssociatedPtr;
})();