// services/network/public/mojom/network_anonymization_key.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ANONYMIZATION_KEY_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ANONYMIZATION_KEY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/network_anonymization_key.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/network_isolation_partition.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"


namespace network::mojom {
class EmptyNetworkAnonymizationKeyDataView;

class NonEmptyNetworkAnonymizationKeyDataView;

class NetworkAnonymizationKeyDataView;


}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::EmptyNetworkAnonymizationKeyDataView> {
  using Data = ::network::mojom::internal::EmptyNetworkAnonymizationKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::NonEmptyNetworkAnonymizationKeyDataView> {
  using Data = ::network::mojom::internal::NonEmptyNetworkAnonymizationKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::NetworkAnonymizationKeyDataView> {
  using Data = ::network::mojom::internal::NetworkAnonymizationKey_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class EmptyNetworkAnonymizationKeyDataView {
 public:
  EmptyNetworkAnonymizationKeyDataView() = default;

  EmptyNetworkAnonymizationKeyDataView(
      internal::EmptyNetworkAnonymizationKey_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::EmptyNetworkAnonymizationKey_Data* data_ = nullptr;
};


class NonEmptyNetworkAnonymizationKeyDataView {
 public:
  NonEmptyNetworkAnonymizationKeyDataView() = default;

  NonEmptyNetworkAnonymizationKeyDataView(
      internal::NonEmptyNetworkAnonymizationKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTopFrameSiteDataView(
      ::network::mojom::SchemefulSiteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopFrameSite(UserType* output) {
    
    auto* pointer = data_->top_frame_site.Get();
    return mojo::internal::Deserialize<::network::mojom::SchemefulSiteDataView>(
        pointer, output, message_);
  }
  bool is_cross_site() const {
    return data_->is_cross_site;
  }
  inline void GetNonceDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNonce(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `nonce` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNonce` instead "
    "of `ReadNonce if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->nonce.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNetworkIsolationPartition(UserType* output) const {
    auto data_value = data_->network_isolation_partition;
    return mojo::internal::Deserialize<::network::mojom::NetworkIsolationPartition>(
        data_value, output);
  }
  ::network::mojom::NetworkIsolationPartition network_isolation_partition() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::NetworkIsolationPartition>(data_->network_isolation_partition));
  }
 private:
  internal::NonEmptyNetworkAnonymizationKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkAnonymizationKeyDataView {
 public:
  using Tag = internal::NetworkAnonymizationKey_Data::NetworkAnonymizationKey_Tag;

  NetworkAnonymizationKeyDataView() = default;

  NetworkAnonymizationKeyDataView(
      internal::NetworkAnonymizationKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_empty() const { return data_->tag == Tag::kEmpty; }
  inline void GetEmptyDataView(
      EmptyNetworkAnonymizationKeyDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadEmpty(UserType* output) const {
    
    CHECK(is_empty());
    return mojo::internal::Deserialize<::network::mojom::EmptyNetworkAnonymizationKeyDataView>(
        data_->data.f_empty.Get(), output, message_);
  }
  bool is_non_empty() const { return data_->tag == Tag::kNonEmpty; }
  inline void GetNonEmptyDataView(
      NonEmptyNetworkAnonymizationKeyDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNonEmpty(UserType* output) const {
    
    CHECK(is_non_empty());
    return mojo::internal::Deserialize<::network::mojom::NonEmptyNetworkAnonymizationKeyDataView>(
        data_->data.f_non_empty.Get(), output, message_);
  }

 private:
  internal::NetworkAnonymizationKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ANONYMIZATION_KEY_MOJOM_DATA_VIEW_H_