// services/network/public/mojom/network_anonymization_key.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/network_anonymization_key.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_anonymization_key.mojom-params-data.h"
#include "services/network/public/mojom/network_anonymization_key.mojom-shared-message-ids.h"

#include "services/network/public/mojom/network_anonymization_key.mojom-blink-import-headers.h"
#include "services/network/public/mojom/network_anonymization_key.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
EmptyNetworkAnonymizationKey::EmptyNetworkAnonymizationKey() {}

EmptyNetworkAnonymizationKey::~EmptyNetworkAnonymizationKey() = default;
size_t EmptyNetworkAnonymizationKey::Hash(size_t seed) const {
  return seed;
}

void EmptyNetworkAnonymizationKey::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool EmptyNetworkAnonymizationKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NonEmptyNetworkAnonymizationKey::NonEmptyNetworkAnonymizationKey()
    : top_frame_site(),
      is_cross_site(),
      nonce(),
      network_isolation_partition() {}

NonEmptyNetworkAnonymizationKey::NonEmptyNetworkAnonymizationKey(
    const ::blink::BlinkSchemefulSite& top_frame_site_in,
    bool is_cross_site_in,
    const std::optional<::base::UnguessableToken>& nonce_in,
    ::network::mojom::blink::NetworkIsolationPartition network_isolation_partition_in)
    : top_frame_site(std::move(top_frame_site_in)),
      is_cross_site(std::move(is_cross_site_in)),
      nonce(std::move(nonce_in)),
      network_isolation_partition(std::move(network_isolation_partition_in)) {}

NonEmptyNetworkAnonymizationKey::~NonEmptyNetworkAnonymizationKey() = default;

void NonEmptyNetworkAnonymizationKey::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_frame_site"), this->top_frame_site,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::BlinkSchemefulSite&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_cross_site"), this->is_cross_site,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nonce"), this->nonce,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "network_isolation_partition"), this->network_isolation_partition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::NetworkIsolationPartition>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NonEmptyNetworkAnonymizationKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NetworkAnonymizationKeyPtr
NetworkAnonymizationKey::NewEmpty(
    EmptyNetworkAnonymizationKeyPtr value) {
  return NetworkAnonymizationKeyPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kEmpty)>,
      std::move(value));
}

NetworkAnonymizationKeyPtr
NetworkAnonymizationKey::NewNonEmpty(
    NonEmptyNetworkAnonymizationKeyPtr value) {
  return NetworkAnonymizationKeyPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNonEmpty)>,
      std::move(value));
}

NetworkAnonymizationKey::NetworkAnonymizationKey(
    std::in_place_index_t<static_cast<size_t>(Tag::kEmpty)>,
    EmptyNetworkAnonymizationKeyPtr value)
    : tag_(Tag::kEmpty),
      data_(std::in_place_index<static_cast<size_t>(Tag::kEmpty)>,
            std::move(value)) {}

NetworkAnonymizationKey::NetworkAnonymizationKey(
    std::in_place_index_t<static_cast<size_t>(Tag::kNonEmpty)>,
    NonEmptyNetworkAnonymizationKeyPtr value)
    : tag_(Tag::kNonEmpty),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNonEmpty)>,
            std::move(value)) {}
NetworkAnonymizationKey::~NetworkAnonymizationKey() {
  DestroyActive();
}

void NetworkAnonymizationKey::set_empty(EmptyNetworkAnonymizationKeyPtr empty) {
  if (tag_ == Tag::kEmpty) {
    data_.empty = std::move(empty);
  } else {
    DestroyActive();
    tag_ = Tag::kEmpty;
    new (&data_.empty) EmptyNetworkAnonymizationKeyPtr(
        std::move(empty));
  }
}

void NetworkAnonymizationKey::set_non_empty(NonEmptyNetworkAnonymizationKeyPtr non_empty) {
  if (tag_ == Tag::kNonEmpty) {
    data_.non_empty = std::move(non_empty);
  } else {
    DestroyActive();
    tag_ = Tag::kNonEmpty;
    new (&data_.non_empty) NonEmptyNetworkAnonymizationKeyPtr(
        std::move(non_empty));
  }
}


NetworkAnonymizationKey::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kEmpty)>,
    EmptyNetworkAnonymizationKeyPtr value)
    : empty(std::move(value)) {}

NetworkAnonymizationKey::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNonEmpty)>,
    NonEmptyNetworkAnonymizationKeyPtr value)
    : non_empty(std::move(value)) {}

void NetworkAnonymizationKey::DestroyActive() {
  switch (tag_) {

    case Tag::kEmpty:
      std::destroy_at(&data_.empty);
      break;
    case Tag::kNonEmpty:
      std::destroy_at(&data_.non_empty);
      break;
  }
}

bool NetworkAnonymizationKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::EmptyNetworkAnonymizationKey::DataView, ::network::mojom::blink::EmptyNetworkAnonymizationKeyPtr>::Read(
    ::network::mojom::blink::EmptyNetworkAnonymizationKey::DataView input,
    ::network::mojom::blink::EmptyNetworkAnonymizationKeyPtr* output) {
  bool success = true;
  ::network::mojom::blink::EmptyNetworkAnonymizationKeyPtr result(::network::mojom::blink::EmptyNetworkAnonymizationKey::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::NonEmptyNetworkAnonymizationKey::DataView, ::network::mojom::blink::NonEmptyNetworkAnonymizationKeyPtr>::Read(
    ::network::mojom::blink::NonEmptyNetworkAnonymizationKey::DataView input,
    ::network::mojom::blink::NonEmptyNetworkAnonymizationKeyPtr* output) {
  bool success = true;
  ::network::mojom::blink::NonEmptyNetworkAnonymizationKeyPtr result(::network::mojom::blink::NonEmptyNetworkAnonymizationKey::New());
  
      if (success && !input.ReadTopFrameSite(&result->top_frame_site))
        success = false;
      if (success)
        result->is_cross_site = input.is_cross_site();
      if (success && !input.ReadNonce(&result->nonce))
        success = false;
      if (success && !input.ReadNetworkIsolationPartition(&result->network_isolation_partition))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::network::mojom::blink::NetworkAnonymizationKey::DataView, ::network::mojom::blink::NetworkAnonymizationKeyPtr>::Read(
    ::network::mojom::blink::NetworkAnonymizationKey::DataView input,
    ::network::mojom::blink::NetworkAnonymizationKeyPtr* output) {
  using UnionType = ::network::mojom::blink::NetworkAnonymizationKey;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kEmpty: {
      ::network::mojom::blink::EmptyNetworkAnonymizationKeyPtr result_empty{};
      if (!input.ReadEmpty(&result_empty))
        return false;

      *output = UnionType::NewEmpty(
          std::move(result_empty));
      break;
    }
    case Tag::kNonEmpty: {
      ::network::mojom::blink::NonEmptyNetworkAnonymizationKeyPtr result_non_empty{};
      if (!input.ReadNonEmpty(&result_non_empty))
        return false;

      *output = UnionType::NewNonEmpty(
          std::move(result_non_empty));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {




}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif