// services/network/public/mojom/net_log.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NET_LOG_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NET_LOG_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/net_log.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/net_log.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/net_log.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "services/network/public/cpp/net_log_mojom_traits.h"




namespace network::mojom {

class NetLogExporterProxy;

template <typename ImplRefTraits>
class NetLogExporterStub;

class NetLogExporterRequestValidator;
class NetLogExporterResponseValidator;


class NetLogExporter
    : public NetLogExporterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.NetLogExporter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NetLogExporterInterfaceBase;
  using Proxy_ = NetLogExporterProxy;

  template <typename ImplRefTraits>
  using Stub_ = NetLogExporterStub<ImplRefTraits>;

  using RequestValidator_ = NetLogExporterRequestValidator;
  using ResponseValidator_ = NetLogExporterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kStartMinVersion = 0,
    kStopMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Start_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Stop_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  static constexpr uint64_t kUnlimitedFileSize = 0xFFFFFFFFFFFFFFFFULL;
  virtual ~NetLogExporter() = default;

  using StartCallback = base::OnceCallback<void(int32_t)>;
  using StartMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void Start(::base::File destination, ::base::Value::Dict extra_constants, ::net::NetLogCaptureMode capture_mode, uint64_t max_file_size, StartCallback callback) = 0;

  using StopCallback = base::OnceCallback<void(int32_t)>;
  using StopMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void Stop(::base::Value::Dict polled_values, StopCallback callback) = 0;
};

class NetLogProxySourceProxy;

template <typename ImplRefTraits>
class NetLogProxySourceStub;

class NetLogProxySourceRequestValidator;


class NetLogProxySource
    : public NetLogProxySourceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.NetLogProxySource";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NetLogProxySourceInterfaceBase;
  using Proxy_ = NetLogProxySourceProxy;

  template <typename ImplRefTraits>
  using Stub_ = NetLogProxySourceStub<ImplRefTraits>;

  using RequestValidator_ = NetLogProxySourceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kUpdateCaptureModesMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpdateCaptureModes_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NetLogProxySource() = default;

  virtual void UpdateCaptureModes(uint8_t modes) = 0;
};

class NetLogProxySinkProxy;

template <typename ImplRefTraits>
class NetLogProxySinkStub;

class NetLogProxySinkRequestValidator;


class NetLogProxySink
    : public NetLogProxySinkInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.NetLogProxySink";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NetLogProxySinkInterfaceBase;
  using Proxy_ = NetLogProxySinkProxy;

  template <typename ImplRefTraits>
  using Stub_ = NetLogProxySinkStub<ImplRefTraits>;

  using RequestValidator_ = NetLogProxySinkRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddEntryMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddEntry_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NetLogProxySink() = default;

  virtual void AddEntry(uint32_t type, const ::net::NetLogSource& net_log_source, ::net::NetLogEventPhase phase, ::base::TimeTicks time, ::base::Value::Dict params) = 0;
};



class  NetLogExporterProxy
    : public NetLogExporter {
 public:
  using InterfaceType = NetLogExporter;

  explicit NetLogExporterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Start(::base::File destination, ::base::Value::Dict extra_constants, ::net::NetLogCaptureMode capture_mode, uint64_t max_file_size, StartCallback callback) final;
  
  void Stop(::base::Value::Dict polled_values, StopCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  NetLogProxySourceProxy
    : public NetLogProxySource {
 public:
  using InterfaceType = NetLogProxySource;

  explicit NetLogProxySourceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateCaptureModes(uint8_t modes) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  NetLogProxySinkProxy
    : public NetLogProxySink {
 public:
  using InterfaceType = NetLogProxySink;

  explicit NetLogProxySinkProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddEntry(uint32_t type, const ::net::NetLogSource& net_log_source, ::net::NetLogEventPhase phase, ::base::TimeTicks time, ::base::Value::Dict params) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  NetLogExporterStubDispatch {
 public:
  static bool Accept(NetLogExporter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NetLogExporter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NetLogExporter>>
class NetLogExporterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NetLogExporterStub() = default;
  ~NetLogExporterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetLogExporterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetLogExporterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NetLogProxySourceStubDispatch {
 public:
  static bool Accept(NetLogProxySource* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NetLogProxySource* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NetLogProxySource>>
class NetLogProxySourceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NetLogProxySourceStub() = default;
  ~NetLogProxySourceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetLogProxySourceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetLogProxySourceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NetLogProxySinkStubDispatch {
 public:
  static bool Accept(NetLogProxySink* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NetLogProxySink* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NetLogProxySink>>
class NetLogProxySinkStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NetLogProxySinkStub() = default;
  ~NetLogProxySinkStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetLogProxySinkStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetLogProxySinkStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NetLogExporterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NetLogProxySourceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NetLogProxySinkRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NetLogExporterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // network::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NET_LOG_MOJOM_H_