// services/network/public/mojom/mdns_responder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/mdns_responder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/mdns_responder.mojom-params-data.h"
#include "services/network/public/mojom/mdns_responder.mojom-shared-message-ids.h"

#include "services/network/public/mojom/mdns_responder.mojom-import-headers.h"
#include "services/network/public/mojom/mdns_responder.mojom-test-utils.h"


namespace network::mojom {
// The declaration includes the definition on other builds.

MdnsResponder::IPCStableHashFunction MdnsResponder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MdnsResponder>(message.name())) {
    case messages::MdnsResponder::kCreateNameForAddress: {
      return &MdnsResponder::CreateNameForAddress_Sym::IPCStableHash;
    }
    case messages::MdnsResponder::kRemoveNameForAddress: {
      return &MdnsResponder::RemoveNameForAddress_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MdnsResponder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MdnsResponder>(message.name())) {
      case messages::MdnsResponder::kCreateNameForAddress:
            return "Receive network::mojom::MdnsResponder::CreateNameForAddress";
      case messages::MdnsResponder::kRemoveNameForAddress:
            return "Receive network::mojom::MdnsResponder::RemoveNameForAddress";
    }
  } else {
    switch (static_cast<messages::MdnsResponder>(message.name())) {
      case messages::MdnsResponder::kCreateNameForAddress:
            return "Receive reply network::mojom::MdnsResponder::CreateNameForAddress";
      case messages::MdnsResponder::kRemoveNameForAddress:
            return "Receive reply network::mojom::MdnsResponder::RemoveNameForAddress";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MdnsResponder::CreateNameForAddress_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x34949689;  // IPCStableHash for network::mojom::MdnsResponder::CreateNameForAddress
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MdnsResponder::RemoveNameForAddress_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x10a8ff89;  // IPCStableHash for network::mojom::MdnsResponder::RemoveNameForAddress
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class MdnsResponder_CreateNameForAddress_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MdnsResponder_CreateNameForAddress_ForwardToCallback(
      MdnsResponder::CreateNameForAddressCallback callback
      ) : callback_(std::move(callback)) {
  }

  MdnsResponder_CreateNameForAddress_ForwardToCallback(const MdnsResponder_CreateNameForAddress_ForwardToCallback&) = delete;
  MdnsResponder_CreateNameForAddress_ForwardToCallback& operator=(const MdnsResponder_CreateNameForAddress_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MdnsResponder::CreateNameForAddressCallback callback_;
};

class MdnsResponder_RemoveNameForAddress_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MdnsResponder_RemoveNameForAddress_ForwardToCallback(
      MdnsResponder::RemoveNameForAddressCallback callback
      ) : callback_(std::move(callback)) {
  }

  MdnsResponder_RemoveNameForAddress_ForwardToCallback(const MdnsResponder_RemoveNameForAddress_ForwardToCallback&) = delete;
  MdnsResponder_RemoveNameForAddress_ForwardToCallback& operator=(const MdnsResponder_RemoveNameForAddress_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MdnsResponder::RemoveNameForAddressCallback callback_;
};

MdnsResponderProxy::MdnsResponderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MdnsResponderProxy::CreateNameForAddress(
    const ::net::IPAddress& in_address, CreateNameForAddressCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::MdnsResponder::CreateNameForAddress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("address"), in_address,
                        "<value of type const ::net::IPAddress&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MdnsResponder::kCreateNameForAddress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::MdnsResponder_CreateNameForAddress_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->address)::BaseType> address_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPAddressDataView>(
    in_address,
    address_fragment);

  params->address.Set(
      address_fragment.is_null() ? nullptr : address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null address in MdnsResponder.CreateNameForAddress request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MdnsResponder::Name_);
  message.set_method_name("CreateNameForAddress");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MdnsResponder_CreateNameForAddress_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MdnsResponderProxy::RemoveNameForAddress(
    const ::net::IPAddress& in_address, RemoveNameForAddressCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::MdnsResponder::RemoveNameForAddress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("address"), in_address,
                        "<value of type const ::net::IPAddress&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MdnsResponder::kRemoveNameForAddress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::MdnsResponder_RemoveNameForAddress_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->address)::BaseType> address_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPAddressDataView>(
    in_address,
    address_fragment);

  params->address.Set(
      address_fragment.is_null() ? nullptr : address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null address in MdnsResponder.RemoveNameForAddress request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MdnsResponder::Name_);
  message.set_method_name("RemoveNameForAddress");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MdnsResponder_RemoveNameForAddress_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class MdnsResponder_CreateNameForAddress_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MdnsResponder::CreateNameForAddressCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MdnsResponder_CreateNameForAddress_ProxyToResponder> proxy(
        new MdnsResponder_CreateNameForAddress_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MdnsResponder_CreateNameForAddress_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MdnsResponder_CreateNameForAddress_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MdnsResponder_CreateNameForAddress_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MdnsResponder::CreateNameForAddressCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_name, bool in_announcement_scheduled);
};

bool MdnsResponder_CreateNameForAddress_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MdnsResponder_CreateNameForAddress_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MdnsResponder_CreateNameForAddress_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MdnsResponder.0
  bool success = true;
  std::string p_name{};
  bool p_announcement_scheduled{};
  MdnsResponder_CreateNameForAddress_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadName(&p_name))
    success = false;
  if (success)
    p_announcement_scheduled = input_data_view.announcement_scheduled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MdnsResponder::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_name), 
std::move(p_announcement_scheduled));
  }
  return true;
}

void MdnsResponder_CreateNameForAddress_ProxyToResponder::Run(
    const std::string& in_name, bool in_announcement_scheduled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::MdnsResponder::CreateNameForAddress", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("announcement_scheduled"), in_announcement_scheduled,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MdnsResponder::kCreateNameForAddress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::MdnsResponder_CreateNameForAddress_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in ");

  params->announcement_scheduled = in_announcement_scheduled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MdnsResponder::Name_);
  message.set_method_name("CreateNameForAddress");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MdnsResponder_RemoveNameForAddress_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MdnsResponder::RemoveNameForAddressCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MdnsResponder_RemoveNameForAddress_ProxyToResponder> proxy(
        new MdnsResponder_RemoveNameForAddress_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MdnsResponder_RemoveNameForAddress_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MdnsResponder_RemoveNameForAddress_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MdnsResponder_RemoveNameForAddress_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MdnsResponder::RemoveNameForAddressCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_removed, bool in_goodbye_scheduled);
};

bool MdnsResponder_RemoveNameForAddress_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MdnsResponder_RemoveNameForAddress_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MdnsResponder_RemoveNameForAddress_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MdnsResponder.1
  bool success = true;
  bool p_removed{};
  bool p_goodbye_scheduled{};
  MdnsResponder_RemoveNameForAddress_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_removed = input_data_view.removed();
  if (success)
    p_goodbye_scheduled = input_data_view.goodbye_scheduled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MdnsResponder::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_removed), 
std::move(p_goodbye_scheduled));
  }
  return true;
}

void MdnsResponder_RemoveNameForAddress_ProxyToResponder::Run(
    bool in_removed, bool in_goodbye_scheduled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::MdnsResponder::RemoveNameForAddress", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("removed"), in_removed,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("goodbye_scheduled"), in_goodbye_scheduled,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MdnsResponder::kRemoveNameForAddress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::MdnsResponder_RemoveNameForAddress_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->removed = in_removed;

  params->goodbye_scheduled = in_goodbye_scheduled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MdnsResponder::Name_);
  message.set_method_name("RemoveNameForAddress");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MdnsResponderStubDispatch::Accept(
    MdnsResponder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MdnsResponder>(message->header()->name)) {
    case messages::MdnsResponder::kCreateNameForAddress: {
      break;
    }
    case messages::MdnsResponder::kRemoveNameForAddress: {
      break;
    }
  }
  return false;
}

// static
bool MdnsResponderStubDispatch::AcceptWithResponder(
    MdnsResponder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MdnsResponder>(message->header()->name)) {
    case messages::MdnsResponder::kCreateNameForAddress: {
      internal::MdnsResponder_CreateNameForAddress_Params_Data* params =
          reinterpret_cast<
              internal::MdnsResponder_CreateNameForAddress_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MdnsResponder.0
      bool success = true;
      ::net::IPAddress p_address{};
      MdnsResponder_CreateNameForAddress_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAddress(&p_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MdnsResponder::Name_, 0, false);
        return false;
      }
      auto callback =
          MdnsResponder_CreateNameForAddress_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNameForAddress(        
        std::move(p_address), std::move(callback));
      return true;
    }
    case messages::MdnsResponder::kRemoveNameForAddress: {
      internal::MdnsResponder_RemoveNameForAddress_Params_Data* params =
          reinterpret_cast<
              internal::MdnsResponder_RemoveNameForAddress_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MdnsResponder.1
      bool success = true;
      ::net::IPAddress p_address{};
      MdnsResponder_RemoveNameForAddress_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAddress(&p_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MdnsResponder::Name_, 1, false);
        return false;
      }
      auto callback =
          MdnsResponder_RemoveNameForAddress_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveNameForAddress(        
        std::move(p_address), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMdnsResponderValidationInfo[] = {
    { &internal::MdnsResponder_CreateNameForAddress_Params_Data::Validate,
     &internal::MdnsResponder_CreateNameForAddress_ResponseParams_Data::Validate},
    { &internal::MdnsResponder_RemoveNameForAddress_Params_Data::Validate,
     &internal::MdnsResponder_RemoveNameForAddress_ResponseParams_Data::Validate},
};

bool MdnsResponderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::MdnsResponder::Name_,
    kMdnsResponderValidationInfo);
}

bool MdnsResponderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::network::mojom::MdnsResponder::Name_,
    kMdnsResponderValidationInfo);
}


}  // network::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void MdnsResponderInterceptorForTesting::CreateNameForAddress(const ::net::IPAddress& address, CreateNameForAddressCallback callback) {
  GetForwardingInterface()->CreateNameForAddress(
    std::move(address)
    , std::move(callback));
}
void MdnsResponderInterceptorForTesting::RemoveNameForAddress(const ::net::IPAddress& address, RemoveNameForAddressCallback callback) {
  GetForwardingInterface()->RemoveNameForAddress(
    std::move(address)
    , std::move(callback));
}
MdnsResponderAsyncWaiter::MdnsResponderAsyncWaiter(
    MdnsResponder* proxy) : proxy_(proxy) {}

MdnsResponderAsyncWaiter::~MdnsResponderAsyncWaiter() = default;


void MdnsResponderAsyncWaiter::CreateNameForAddress(
    const ::net::IPAddress& address, std::string* out_name, bool* out_announcement_scheduled) {
  base::RunLoop loop;
  proxy_->CreateNameForAddress(
      std::move(address),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_name
,
             bool* out_announcement_scheduled
,
             const std::string& name,
             bool announcement_scheduled) {*out_name = std::move(name);*out_announcement_scheduled = std::move(announcement_scheduled);
            loop->Quit();
          },
          &loop,
          out_name,
          out_announcement_scheduled));
  loop.Run();
}



void MdnsResponderAsyncWaiter::RemoveNameForAddress(
    const ::net::IPAddress& address, bool* out_removed, bool* out_goodbye_scheduled) {
  base::RunLoop loop;
  proxy_->RemoveNameForAddress(
      std::move(address),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_removed
,
             bool* out_goodbye_scheduled
,
             bool removed,
             bool goodbye_scheduled) {*out_removed = std::move(removed);*out_goodbye_scheduled = std::move(goodbye_scheduled);
            loop->Quit();
          },
          &loop,
          out_removed,
          out_goodbye_scheduled));
  loop.Run();
}








}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif