// services/network/public/mojom/load_timing_internal_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/load_timing_internal_info.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/load_timing_internal_info.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* SessionSourceToStringHelper(SessionSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SessionSource::kNew:
      return "kNew";
    case SessionSource::kExisting:
      return "kExisting";
    default:
      return nullptr;
  }
}

std::string SessionSourceToString(SessionSource value) {
  const char *str = SessionSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SessionSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SessionSource value) {
  return os << SessionSourceToString(value);
}

NOINLINE static const char* AdvertisedAltSvcStateToStringHelper(AdvertisedAltSvcState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AdvertisedAltSvcState::kUnknown:
      return "kUnknown";
    case AdvertisedAltSvcState::kQuicNotBroken:
      return "kQuicNotBroken";
    case AdvertisedAltSvcState::kQuicBroken:
      return "kQuicBroken";
    default:
      return nullptr;
  }
}

std::string AdvertisedAltSvcStateToString(AdvertisedAltSvcState value) {
  const char *str = AdvertisedAltSvcStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AdvertisedAltSvcState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AdvertisedAltSvcState value) {
  return os << AdvertisedAltSvcStateToString(value);
}

namespace internal {


// static
bool LoadTimingInternalInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LoadTimingInternalInfo_Data* object =
      static_cast<const LoadTimingInternalInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->create_stream_delay, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->create_stream_delay, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->connected_callback_delay, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->connected_callback_delay, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initialize_stream_delay, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->initialize_stream_delay, validation_context))
    return false;


  if (!::network::mojom::internal::SessionSource_Data
        ::Validate(object->session_source_$value, validation_context))
    return false;


  if (!::network::mojom::internal::AdvertisedAltSvcState_Data
        ::Validate(object->advertised_alt_svc_state, validation_context))
    return false;

  return true;
}

LoadTimingInternalInfo_Data::LoadTimingInternalInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::SessionSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::SessionSource value) {
  return std::move(context).WriteString(::network::mojom::SessionSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::AdvertisedAltSvcState>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::AdvertisedAltSvcState value) {
  return std::move(context).WriteString(::network::mojom::AdvertisedAltSvcStateToString(value));
}

} // namespace perfetto