// services/network/public/mojom/load_timing_internal_info.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INTERNAL_INFO_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INTERNAL_INFO_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/load_timing_internal_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace network::mojom {
class LoadTimingInternalInfoDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::LoadTimingInternalInfoDataView> {
  using Data = ::network::mojom::internal::LoadTimingInternalInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class SessionSource : int32_t {
  
  kNew = 0,
  
  kExisting = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SessionSource value);
inline bool IsKnownEnumValue(SessionSource value) {
  return internal::SessionSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AdvertisedAltSvcState : int32_t {
  
  kUnknown = 0,
  
  kQuicNotBroken = 1,
  
  kQuicBroken = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, AdvertisedAltSvcState value);
inline bool IsKnownEnumValue(AdvertisedAltSvcState value) {
  return internal::AdvertisedAltSvcState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class LoadTimingInternalInfoDataView {
 public:
  LoadTimingInternalInfoDataView() = default;

  LoadTimingInternalInfoDataView(
      internal::LoadTimingInternalInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCreateStreamDelayDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCreateStreamDelay(UserType* output) {
    
    auto* pointer = data_->create_stream_delay.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetConnectedCallbackDelayDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConnectedCallbackDelay(UserType* output) {
    
    auto* pointer = data_->connected_callback_delay.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetInitializeStreamDelayDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitializeStreamDelay(UserType* output) {
    
    auto* pointer = data_->initialize_stream_delay.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSessionSource(UserType* output) const {
    if (!data_->session_source_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::network::mojom::SessionSource>(
        data_->session_source_$value, &output->emplace());
  }
  std::optional<SessionSource> session_source() const {
    if (!data_->session_source_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::SessionSource>(data_->session_source_$value));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAdvertisedAltSvcState(UserType* output) const {
    auto data_value = data_->advertised_alt_svc_state;
    return mojo::internal::Deserialize<::network::mojom::AdvertisedAltSvcState>(
        data_value, output);
  }
  AdvertisedAltSvcState advertised_alt_svc_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::AdvertisedAltSvcState>(data_->advertised_alt_svc_state));
  }
  bool http_network_session_quic_enabled() const {
    return data_->http_network_session_quic_enabled;
  }
 private:
  internal::LoadTimingInternalInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INTERNAL_INFO_MOJOM_DATA_VIEW_H_