// services/network/public/mojom/link_header.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/link_header.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var request_priority$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/request_priority.mojom', 'request_priority.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }


  var LinkRelAttribute = {};
  LinkRelAttribute.kDnsPrefetch = 0;
  LinkRelAttribute.kPreconnect = 1;
  LinkRelAttribute.kPreload = 2;
  LinkRelAttribute.kModulePreload = 3;
  LinkRelAttribute.MIN_VALUE = 0;
  LinkRelAttribute.MAX_VALUE = 3;

  LinkRelAttribute.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  LinkRelAttribute.toKnownEnumValue = function(value) {
    return value;
  };

  LinkRelAttribute.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var LinkAsAttribute = {};
  LinkAsAttribute.kUnspecified = 0;
  LinkAsAttribute.kFont = 1;
  LinkAsAttribute.kImage = 2;
  LinkAsAttribute.kScript = 3;
  LinkAsAttribute.kStyleSheet = 4;
  LinkAsAttribute.kFetch = 5;
  LinkAsAttribute.MIN_VALUE = 0;
  LinkAsAttribute.MAX_VALUE = 5;

  LinkAsAttribute.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  LinkAsAttribute.toKnownEnumValue = function(value) {
    return value;
  };

  LinkAsAttribute.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CrossOriginAttribute = {};
  CrossOriginAttribute.kUnspecified = 0;
  CrossOriginAttribute.kAnonymous = 1;
  CrossOriginAttribute.kUseCredentials = 2;
  CrossOriginAttribute.MIN_VALUE = 0;
  CrossOriginAttribute.MAX_VALUE = 2;

  CrossOriginAttribute.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  CrossOriginAttribute.toKnownEnumValue = function(value) {
    return value;
  };

  CrossOriginAttribute.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function LinkHeader(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LinkHeader.prototype.initDefaults_ = function() {
    this.href = null;
    this.rel = 0;
    this.as = LinkAsAttribute.kUnspecified;
    this.crossOrigin = CrossOriginAttribute.kUnspecified;
    this.fetchPriority = request_priority$.FetchPriorityAttribute.kAuto;
    this.mimeType = null;
  };
  LinkHeader.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LinkHeader.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LinkHeader.href
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LinkHeader.rel
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, LinkRelAttribute);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LinkHeader.as
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, LinkAsAttribute);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LinkHeader.crossOrigin
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, CrossOriginAttribute);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LinkHeader.fetchPriority
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 20, request_priority$.FetchPriorityAttribute);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LinkHeader.mimeType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LinkHeader.encodedSize = codec.kStructHeaderSize + 32;

  LinkHeader.decode = function(decoder) {
    var packed;
    var val = new LinkHeader();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.href =
        decoder.decodeStructPointer(url$.Url);
    val.rel =
        decoder.decodeStruct(new codec.Enum(LinkRelAttribute));
    val.as =
        decoder.decodeStruct(new codec.Enum(LinkAsAttribute));
    val.crossOrigin =
        decoder.decodeStruct(new codec.Enum(CrossOriginAttribute));
    val.fetchPriority =
        decoder.decodeStruct(new codec.Enum(request_priority$.FetchPriorityAttribute));
    val.mimeType =
        decoder.decodeStruct(codec.String);
    return val;
  };

  LinkHeader.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LinkHeader.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.href);
    encoder.encodeStruct(codec.Int32, val.rel);
    encoder.encodeStruct(codec.Int32, val.as);
    encoder.encodeStruct(codec.Int32, val.crossOrigin);
    encoder.encodeStruct(codec.Int32, val.fetchPriority);
    encoder.encodeStruct(codec.String, val.mimeType);
  };
  exports.LinkRelAttribute = LinkRelAttribute;
  exports.LinkAsAttribute = LinkAsAttribute;
  exports.CrossOriginAttribute = CrossOriginAttribute;
  exports.LinkHeader = LinkHeader;
})();